pragma Warnings (Off);
pragma Ada_95;
with System;
with System.Parameters;
with System.Secondary_Stack;
package ada_main is

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 15.2.1 20251112" & ASCII.NUL;
   pragma Export (C, GNAT_Version, "__gnat_version");

   GNAT_Version_Address : constant System.Address := GNAT_Version'Address;
   pragma Export (C, GNAT_Version_Address, "__gnat_version_address");

   Ada_Main_Program_Name : constant String := "_ada_gnatbind" & ASCII.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#db11a731#;
   pragma Export (C, u00001, "gnatbindB");
   u00002 : constant Version_32 := 16#d6787f71#;
   pragma Export (C, u00002, "gnatbindS");
   u00003 : constant Version_32 := 16#b2cfab41#;
   pragma Export (C, u00003, "system__standard_libraryB");
   u00004 : constant Version_32 := 16#708b39be#;
   pragma Export (C, u00004, "system__standard_libraryS");
   u00005 : constant Version_32 := 16#2152a7be#;
   pragma Export (C, u00005, "ada__exceptionsB");
   u00006 : constant Version_32 := 16#1274cc34#;
   pragma Export (C, u00006, "ada__exceptionsS");
   u00007 : constant Version_32 := 16#76789da1#;
   pragma Export (C, u00007, "adaS");
   u00008 : constant Version_32 := 16#85bf25f7#;
   pragma Export (C, u00008, "ada__exceptions__last_chance_handlerB");
   u00009 : constant Version_32 := 16#a028f72d#;
   pragma Export (C, u00009, "ada__exceptions__last_chance_handlerS");
   u00010 : constant Version_32 := 16#62859e27#;
   pragma Export (C, u00010, "systemS");
   u00011 : constant Version_32 := 16#7fa0a598#;
   pragma Export (C, u00011, "system__soft_linksB");
   u00012 : constant Version_32 := 16#b10e2b0e#;
   pragma Export (C, u00012, "system__soft_linksS");
   u00013 : constant Version_32 := 16#d0b087d0#;
   pragma Export (C, u00013, "system__secondary_stackB");
   u00014 : constant Version_32 := 16#cc4ecf2b#;
   pragma Export (C, u00014, "system__secondary_stackS");
   u00015 : constant Version_32 := 16#a43efea2#;
   pragma Export (C, u00015, "system__parametersB");
   u00016 : constant Version_32 := 16#57126236#;
   pragma Export (C, u00016, "system__parametersS");
   u00017 : constant Version_32 := 16#ae5b4acf#;
   pragma Export (C, u00017, "system__storage_elementsS");
   u00018 : constant Version_32 := 16#0286ce9f#;
   pragma Export (C, u00018, "system__soft_links__initializeB");
   u00019 : constant Version_32 := 16#ac2e8b53#;
   pragma Export (C, u00019, "system__soft_links__initializeS");
   u00020 : constant Version_32 := 16#8599b27b#;
   pragma Export (C, u00020, "system__stack_checkingB");
   u00021 : constant Version_32 := 16#a5da8b31#;
   pragma Export (C, u00021, "system__stack_checkingS");
   u00022 : constant Version_32 := 16#45e1965e#;
   pragma Export (C, u00022, "system__exception_tableB");
   u00023 : constant Version_32 := 16#efaee83e#;
   pragma Export (C, u00023, "system__exception_tableS");
   u00024 : constant Version_32 := 16#50202115#;
   pragma Export (C, u00024, "system__exceptionsS");
   u00025 : constant Version_32 := 16#c367aa24#;
   pragma Export (C, u00025, "system__exceptions__machineB");
   u00026 : constant Version_32 := 16#ec13924a#;
   pragma Export (C, u00026, "system__exceptions__machineS");
   u00027 : constant Version_32 := 16#7706238d#;
   pragma Export (C, u00027, "system__exceptions_debugB");
   u00028 : constant Version_32 := 16#528bc674#;
   pragma Export (C, u00028, "system__exceptions_debugS");
   u00029 : constant Version_32 := 16#401add66#;
   pragma Export (C, u00029, "system__img_intS");
   u00030 : constant Version_32 := 16#f2c63a02#;
   pragma Export (C, u00030, "ada__numericsS");
   u00031 : constant Version_32 := 16#174f5472#;
   pragma Export (C, u00031, "ada__numerics__big_numbersS");
   u00032 : constant Version_32 := 16#98afe17e#;
   pragma Export (C, u00032, "system__unsigned_typesS");
   u00033 : constant Version_32 := 16#5c7d9c20#;
   pragma Export (C, u00033, "system__tracebackB");
   u00034 : constant Version_32 := 16#e41f6a9a#;
   pragma Export (C, u00034, "system__tracebackS");
   u00035 : constant Version_32 := 16#5f6b6486#;
   pragma Export (C, u00035, "system__traceback_entriesB");
   u00036 : constant Version_32 := 16#aa9921ab#;
   pragma Export (C, u00036, "system__traceback_entriesS");
   u00037 : constant Version_32 := 16#65d5266b#;
   pragma Export (C, u00037, "system__traceback__symbolicB");
   u00038 : constant Version_32 := 16#140ceb78#;
   pragma Export (C, u00038, "system__traceback__symbolicS");
   u00039 : constant Version_32 := 16#701f9d88#;
   pragma Export (C, u00039, "ada__exceptions__tracebackB");
   u00040 : constant Version_32 := 16#26ed0985#;
   pragma Export (C, u00040, "ada__exceptions__tracebackS");
   u00041 : constant Version_32 := 16#f9910acc#;
   pragma Export (C, u00041, "system__address_imageB");
   u00042 : constant Version_32 := 16#c369031d#;
   pragma Export (C, u00042, "system__address_imageS");
   u00043 : constant Version_32 := 16#82dc8754#;
   pragma Export (C, u00043, "system__img_address_32S");
   u00044 : constant Version_32 := 16#44f60a17#;
   pragma Export (C, u00044, "interfacesS");
   u00045 : constant Version_32 := 16#affc26d6#;
   pragma Export (C, u00045, "system__img_address_64S");
   u00046 : constant Version_32 := 16#fd158a37#;
   pragma Export (C, u00046, "system__wch_conB");
   u00047 : constant Version_32 := 16#bb86bd44#;
   pragma Export (C, u00047, "system__wch_conS");
   u00048 : constant Version_32 := 16#5c289972#;
   pragma Export (C, u00048, "system__wch_stwB");
   u00049 : constant Version_32 := 16#96979145#;
   pragma Export (C, u00049, "system__wch_stwS");
   u00050 : constant Version_32 := 16#a931ce33#;
   pragma Export (C, u00050, "system__wch_cnvB");
   u00051 : constant Version_32 := 16#bd467734#;
   pragma Export (C, u00051, "system__wch_cnvS");
   u00052 : constant Version_32 := 16#e538de43#;
   pragma Export (C, u00052, "system__wch_jisB");
   u00053 : constant Version_32 := 16#08f1151e#;
   pragma Export (C, u00053, "system__wch_jisS");
   u00054 : constant Version_32 := 16#6012a598#;
   pragma Export (C, u00054, "aliB");
   u00055 : constant Version_32 := 16#6e4fa57f#;
   pragma Export (C, u00055, "aliS");
   u00056 : constant Version_32 := 16#5ebf53df#;
   pragma Export (C, u00056, "butilB");
   u00057 : constant Version_32 := 16#add434b3#;
   pragma Export (C, u00057, "butilS");
   u00058 : constant Version_32 := 16#b5988c27#;
   pragma Export (C, u00058, "gnatS");
   u00059 : constant Version_32 := 16#24f86cf0#;
   pragma Export (C, u00059, "optB");
   u00060 : constant Version_32 := 16#020cffb0#;
   pragma Export (C, u00060, "optS");
   u00061 : constant Version_32 := 16#9391f6c2#;
   pragma Export (C, u00061, "hostparmS");
   u00062 : constant Version_32 := 16#ca878138#;
   pragma Export (C, u00062, "system__concat_2B");
   u00063 : constant Version_32 := 16#d77eedd0#;
   pragma Export (C, u00063, "system__concat_2S");
   u00064 : constant Version_32 := 16#7c7c2d03#;
   pragma Export (C, u00064, "typesB");
   u00065 : constant Version_32 := 16#54006ea1#;
   pragma Export (C, u00065, "typesS");
   u00066 : constant Version_32 := 16#256dbbe5#;
   pragma Export (C, u00066, "system__stringsB");
   u00067 : constant Version_32 := 16#f9079e3f#;
   pragma Export (C, u00067, "system__stringsS");
   u00068 : constant Version_32 := 16#a61ae265#;
   pragma Export (C, u00068, "outputB");
   u00069 : constant Version_32 := 16#08759545#;
   pragma Export (C, u00069, "outputS");
   u00070 : constant Version_32 := 16#c04dcb27#;
   pragma Export (C, u00070, "system__os_libB");
   u00071 : constant Version_32 := 16#e7ee01b7#;
   pragma Export (C, u00071, "system__os_libS");
   u00072 : constant Version_32 := 16#401f6fd6#;
   pragma Export (C, u00072, "interfaces__cB");
   u00073 : constant Version_32 := 16#faa8fe4b#;
   pragma Export (C, u00073, "interfaces__cS");
   u00074 : constant Version_32 := 16#b98923bf#;
   pragma Export (C, u00074, "system__case_utilB");
   u00075 : constant Version_32 := 16#ad964972#;
   pragma Export (C, u00075, "system__case_utilS");
   u00076 : constant Version_32 := 16#e9a1f9a8#;
   pragma Export (C, u00076, "system__crtlS");
   u00077 : constant Version_32 := 16#31661ce6#;
   pragma Export (C, u00077, "nametB");
   u00078 : constant Version_32 := 16#6a2022b9#;
   pragma Export (C, u00078, "nametS");
   u00079 : constant Version_32 := 16#91fc5baa#;
   pragma Export (C, u00079, "debugB");
   u00080 : constant Version_32 := 16#1ac546f9#;
   pragma Export (C, u00080, "debugS");
   u00081 : constant Version_32 := 16#6dee85fb#;
   pragma Export (C, u00081, "widecharB");
   u00082 : constant Version_32 := 16#540fd05b#;
   pragma Export (C, u00082, "widecharS");
   u00083 : constant Version_32 := 16#1b78961f#;
   pragma Export (C, u00083, "allocS");
   u00084 : constant Version_32 := 16#01bab8fb#;
   pragma Export (C, u00084, "tableB");
   u00085 : constant Version_32 := 16#28fc04cc#;
   pragma Export (C, u00085, "tableS");
   u00086 : constant Version_32 := 16#0ddbd91f#;
   pragma Export (C, u00086, "system__memoryB");
   u00087 : constant Version_32 := 16#7a11023d#;
   pragma Export (C, u00087, "system__memoryS");
   u00088 : constant Version_32 := 16#c24bf6d6#;
   pragma Export (C, u00088, "fnameB");
   u00089 : constant Version_32 := 16#ca6efcdf#;
   pragma Export (C, u00089, "fnameS");
   u00090 : constant Version_32 := 16#26305230#;
   pragma Export (C, u00090, "gnat__dynamic_htablesB");
   u00091 : constant Version_32 := 16#2317962f#;
   pragma Export (C, u00091, "gnat__dynamic_htablesS");
   u00092 : constant Version_32 := 16#52647a30#;
   pragma Export (C, u00092, "osintB");
   u00093 : constant Version_32 := 16#d9f1c153#;
   pragma Export (C, u00093, "osintS");
   u00094 : constant Version_32 := 16#50ee5e6f#;
   pragma Export (C, u00094, "fmapB");
   u00095 : constant Version_32 := 16#1e66216c#;
   pragma Export (C, u00095, "fmapS");
   u00096 : constant Version_32 := 16#9f9cc922#;
   pragma Export (C, u00096, "gnat__htableB");
   u00097 : constant Version_32 := 16#4a45b320#;
   pragma Export (C, u00097, "gnat__htableS");
   u00098 : constant Version_32 := 16#3548d972#;
   pragma Export (C, u00098, "system__htableB");
   u00099 : constant Version_32 := 16#e35cc6cc#;
   pragma Export (C, u00099, "system__htableS");
   u00100 : constant Version_32 := 16#1f1abe38#;
   pragma Export (C, u00100, "system__string_hashB");
   u00101 : constant Version_32 := 16#441946b3#;
   pragma Export (C, u00101, "system__string_hashS");
   u00102 : constant Version_32 := 16#db439280#;
   pragma Export (C, u00102, "gnatvsnB");
   u00103 : constant Version_32 := 16#5befe981#;
   pragma Export (C, u00103, "gnatvsnS");
   u00104 : constant Version_32 := 16#5fb2abdd#;
   pragma Export (C, u00104, "sdefaultB");
   u00105 : constant Version_32 := 16#83d5b4b7#;
   pragma Export (C, u00105, "sdefaultS");
   u00106 : constant Version_32 := 16#dc05b9aa#;
   pragma Export (C, u00106, "targparmB");
   u00107 : constant Version_32 := 16#67d21b74#;
   pragma Export (C, u00107, "targparmS");
   u00108 : constant Version_32 := 16#81e20d54#;
   pragma Export (C, u00108, "csetsB");
   u00109 : constant Version_32 := 16#bbc4794e#;
   pragma Export (C, u00109, "csetsS");
   u00110 : constant Version_32 := 16#29e0a804#;
   pragma Export (C, u00110, "ridentS");
   u00111 : constant Version_32 := 16#2f18859d#;
   pragma Export (C, u00111, "snamesB");
   u00112 : constant Version_32 := 16#d710aba4#;
   pragma Export (C, u00112, "snamesS");
   u00113 : constant Version_32 := 16#eded6d25#;
   pragma Export (C, u00113, "casingB");
   u00114 : constant Version_32 := 16#62d8bd76#;
   pragma Export (C, u00114, "casingS");
   u00115 : constant Version_32 := 16#185c9e3b#;
   pragma Export (C, u00115, "ali__utilB");
   u00116 : constant Version_32 := 16#12f99719#;
   pragma Export (C, u00116, "ali__utilS");
   u00117 : constant Version_32 := 16#df380f7b#;
   pragma Export (C, u00117, "atreeB");
   u00118 : constant Version_32 := 16#a32400a2#;
   pragma Export (C, u00118, "atreeS");
   u00119 : constant Version_32 := 16#b887954b#;
   pragma Export (C, u00119, "nlistsB");
   u00120 : constant Version_32 := 16#41c00ee0#;
   pragma Export (C, u00120, "nlistsS");
   u00121 : constant Version_32 := 16#967d496c#;
   pragma Export (C, u00121, "sinfoS");
   u00122 : constant Version_32 := 16#bcd3cf22#;
   pragma Export (C, u00122, "uintpB");
   u00123 : constant Version_32 := 16#6e316fbf#;
   pragma Export (C, u00123, "uintpS");
   u00124 : constant Version_32 := 16#9bf8863e#;
   pragma Export (C, u00124, "urealpB");
   u00125 : constant Version_32 := 16#85d8bd50#;
   pragma Export (C, u00125, "urealpS");
   u00126 : constant Version_32 := 16#70a074fc#;
   pragma Export (C, u00126, "sinfo__nodesB");
   u00127 : constant Version_32 := 16#61d9125d#;
   pragma Export (C, u00127, "sinfo__nodesS");
   u00128 : constant Version_32 := 16#2acd5a34#;
   pragma Export (C, u00128, "einfoS");
   u00129 : constant Version_32 := 16#c68dea0c#;
   pragma Export (C, u00129, "standS");
   u00130 : constant Version_32 := 16#a5436f2c#;
   pragma Export (C, u00130, "einfo__utilsB");
   u00131 : constant Version_32 := 16#dfbad553#;
   pragma Export (C, u00131, "einfo__utilsS");
   u00132 : constant Version_32 := 16#8ce492bd#;
   pragma Export (C, u00132, "elistsB");
   u00133 : constant Version_32 := 16#3621c53c#;
   pragma Export (C, u00133, "elistsS");
   u00134 : constant Version_32 := 16#2609ca55#;
   pragma Export (C, u00134, "sinfo__utilsB");
   u00135 : constant Version_32 := 16#6c38dd85#;
   pragma Export (C, u00135, "sinfo__utilsS");
   u00136 : constant Version_32 := 16#0c7515d2#;
   pragma Export (C, u00136, "gnat__listsB");
   u00137 : constant Version_32 := 16#ec560056#;
   pragma Export (C, u00137, "gnat__listsS");
   u00138 : constant Version_32 := 16#9cca8964#;
   pragma Export (C, u00138, "seinfoS");
   u00139 : constant Version_32 := 16#ba8ea5c8#;
   pragma Export (C, u00139, "sinputB");
   u00140 : constant Version_32 := 16#9555ad74#;
   pragma Export (C, u00140, "sinputS");
   u00141 : constant Version_32 := 16#641bd22f#;
   pragma Export (C, u00141, "gnat__byte_order_markB");
   u00142 : constant Version_32 := 16#0475df31#;
   pragma Export (C, u00142, "gnat__byte_order_markS");
   u00143 : constant Version_32 := 16#404ffa35#;
   pragma Export (C, u00143, "scansB");
   u00144 : constant Version_32 := 16#a67433c2#;
   pragma Export (C, u00144, "scansS");
   u00145 : constant Version_32 := 16#5420d25f#;
   pragma Export (C, u00145, "einfo__entitiesB");
   u00146 : constant Version_32 := 16#a6dc6d3f#;
   pragma Export (C, u00146, "einfo__entitiesS");
   u00147 : constant Version_32 := 16#9bad5a0c#;
   pragma Export (C, u00147, "binderrB");
   u00148 : constant Version_32 := 16#a7ac8fef#;
   pragma Export (C, u00148, "binderrS");
   u00149 : constant Version_32 := 16#bcb85e89#;
   pragma Export (C, u00149, "err_varsS");
   u00150 : constant Version_32 := 16#b5cdd58d#;
   pragma Export (C, u00150, "erroutB");
   u00151 : constant Version_32 := 16#8b744e63#;
   pragma Export (C, u00151, "erroutS");
   u00152 : constant Version_32 := 16#a3831597#;
   pragma Export (C, u00152, "diagnosticsB");
   u00153 : constant Version_32 := 16#cd4e60cb#;
   pragma Export (C, u00153, "diagnosticsS");
   u00154 : constant Version_32 := 16#670b264f#;
   pragma Export (C, u00154, "diagnostics__brief_emitterB");
   u00155 : constant Version_32 := 16#9dee3494#;
   pragma Export (C, u00155, "diagnostics__brief_emitterS");
   u00156 : constant Version_32 := 16#07ddb981#;
   pragma Export (C, u00156, "diagnostics__utilsB");
   u00157 : constant Version_32 := 16#4c02bf71#;
   pragma Export (C, u00157, "diagnostics__utilsS");
   u00158 : constant Version_32 := 16#02494b0f#;
   pragma Export (C, u00158, "diagnostics__repositoryB");
   u00159 : constant Version_32 := 16#2a6bc609#;
   pragma Export (C, u00159, "diagnostics__repositoryS");
   u00160 : constant Version_32 := 16#c2ae913b#;
   pragma Export (C, u00160, "diagnostics__json_utilsB");
   u00161 : constant Version_32 := 16#a197d0a6#;
   pragma Export (C, u00161, "diagnostics__json_utilsS");
   u00162 : constant Version_32 := 16#ad5b5e25#;
   pragma Export (C, u00162, "diagnostics__switch_repositoryB");
   u00163 : constant Version_32 := 16#b1bd49d8#;
   pragma Export (C, u00163, "diagnostics__switch_repositoryS");
   u00164 : constant Version_32 := 16#2413b60b#;
   pragma Export (C, u00164, "erroutcB");
   u00165 : constant Version_32 := 16#19025ba2#;
   pragma Export (C, u00165, "erroutcS");
   u00166 : constant Version_32 := 16#31bdb1fc#;
   pragma Export (C, u00166, "stringtB");
   u00167 : constant Version_32 := 16#8b08e80d#;
   pragma Export (C, u00167, "stringtS");
   u00168 : constant Version_32 := 16#a45ea7c3#;
   pragma Export (C, u00168, "styleswB");
   u00169 : constant Version_32 := 16#4850a7dc#;
   pragma Export (C, u00169, "styleswS");
   u00170 : constant Version_32 := 16#3d5a5eeb#;
   pragma Export (C, u00170, "warnswB");
   u00171 : constant Version_32 := 16#ca369e86#;
   pragma Export (C, u00171, "warnswS");
   u00172 : constant Version_32 := 16#faa66d54#;
   pragma Export (C, u00172, "diagnostics__pretty_emitterB");
   u00173 : constant Version_32 := 16#3570582e#;
   pragma Export (C, u00173, "diagnostics__pretty_emitterS");
   u00174 : constant Version_32 := 16#5ba670e3#;
   pragma Export (C, u00174, "libB");
   u00175 : constant Version_32 := 16#f77a98ec#;
   pragma Export (C, u00175, "libS");
   u00176 : constant Version_32 := 16#304110d5#;
   pragma Export (C, u00176, "unameB");
   u00177 : constant Version_32 := 16#7fb12790#;
   pragma Export (C, u00177, "unameS");
   u00178 : constant Version_32 := 16#a7d1b8b8#;
   pragma Export (C, u00178, "diagnostics__converterB");
   u00179 : constant Version_32 := 16#613b189d#;
   pragma Export (C, u00179, "diagnostics__converterS");
   u00180 : constant Version_32 := 16#a6eba0dc#;
   pragma Export (C, u00180, "diagnostics__sarif_emitterB");
   u00181 : constant Version_32 := 16#653debb1#;
   pragma Export (C, u00181, "diagnostics__sarif_emitterS");
   u00182 : constant Version_32 := 16#d351e871#;
   pragma Export (C, u00182, "sem_auxB");
   u00183 : constant Version_32 := 16#32c14980#;
   pragma Export (C, u00183, "sem_auxS");
   u00184 : constant Version_32 := 16#75741ab8#;
   pragma Export (C, u00184, "scngB");
   u00185 : constant Version_32 := 16#3a2d193a#;
   pragma Export (C, u00185, "scngS");
   u00186 : constant Version_32 := 16#1e6e5cd0#;
   pragma Export (C, u00186, "system__crc32B");
   u00187 : constant Version_32 := 16#02bb2785#;
   pragma Export (C, u00187, "system__crc32S");
   u00188 : constant Version_32 := 16#1f3e80d3#;
   pragma Export (C, u00188, "system__utf_32B");
   u00189 : constant Version_32 := 16#e6e44f98#;
   pragma Export (C, u00189, "system__utf_32S");
   u00190 : constant Version_32 := 16#551b1769#;
   pragma Export (C, u00190, "stylegB");
   u00191 : constant Version_32 := 16#04d7b557#;
   pragma Export (C, u00191, "stylegS");
   u00192 : constant Version_32 := 16#268bfe9e#;
   pragma Export (C, u00192, "sinput__cB");
   u00193 : constant Version_32 := 16#a4295aa8#;
   pragma Export (C, u00193, "sinput__cS");
   u00194 : constant Version_32 := 16#fa25cd34#;
   pragma Export (C, u00194, "bcheckB");
   u00195 : constant Version_32 := 16#881dacd4#;
   pragma Export (C, u00195, "bcheckS");
   u00196 : constant Version_32 := 16#202a6963#;
   pragma Export (C, u00196, "bindgenB");
   u00197 : constant Version_32 := 16#248bc880#;
   pragma Export (C, u00197, "bindgenS");
   u00198 : constant Version_32 := 16#89e8bac3#;
   pragma Export (C, u00198, "gnat__heap_sort_aB");
   u00199 : constant Version_32 := 16#a0f346d1#;
   pragma Export (C, u00199, "gnat__heap_sort_aS");
   u00200 : constant Version_32 := 16#d421959d#;
   pragma Export (C, u00200, "osint__bB");
   u00201 : constant Version_32 := 16#cc9435e0#;
   pragma Export (C, u00201, "osint__bS");
   u00202 : constant Version_32 := 16#dc83f4cb#;
   pragma Export (C, u00202, "bindoB");
   u00203 : constant Version_32 := 16#745856bb#;
   pragma Export (C, u00203, "bindoS");
   u00204 : constant Version_32 := 16#70a84050#;
   pragma Export (C, u00204, "bindeB");
   u00205 : constant Version_32 := 16#250a621f#;
   pragma Export (C, u00205, "bindeS");
   u00206 : constant Version_32 := 16#fa4ca414#;
   pragma Export (C, u00206, "bindo__elaboratorsB");
   u00207 : constant Version_32 := 16#ba15b383#;
   pragma Export (C, u00207, "bindo__elaboratorsS");
   u00208 : constant Version_32 := 16#257ae541#;
   pragma Export (C, u00208, "bindo__augmentorsB");
   u00209 : constant Version_32 := 16#4de1d230#;
   pragma Export (C, u00209, "bindo__augmentorsS");
   u00210 : constant Version_32 := 16#46c1a98d#;
   pragma Export (C, u00210, "bindo__writersB");
   u00211 : constant Version_32 := 16#58366ded#;
   pragma Export (C, u00211, "bindo__writersS");
   u00212 : constant Version_32 := 16#910aca30#;
   pragma Export (C, u00212, "bindo__unitsB");
   u00213 : constant Version_32 := 16#02f95f8c#;
   pragma Export (C, u00213, "bindo__unitsS");
   u00214 : constant Version_32 := 16#6ffde2e6#;
   pragma Export (C, u00214, "gnat__setsB");
   u00215 : constant Version_32 := 16#f203e24e#;
   pragma Export (C, u00215, "gnat__setsS");
   u00216 : constant Version_32 := 16#18033725#;
   pragma Export (C, u00216, "gnat__graphsB");
   u00217 : constant Version_32 := 16#6a9751bb#;
   pragma Export (C, u00217, "gnat__graphsS");
   u00218 : constant Version_32 := 16#51bd4a32#;
   pragma Export (C, u00218, "bindo__graphsB");
   u00219 : constant Version_32 := 16#a4e7d8fc#;
   pragma Export (C, u00219, "bindo__graphsS");
   u00220 : constant Version_32 := 16#a91ce61a#;
   pragma Export (C, u00220, "bindo__buildersB");
   u00221 : constant Version_32 := 16#1ff68edf#;
   pragma Export (C, u00221, "bindo__buildersS");
   u00222 : constant Version_32 := 16#c8350795#;
   pragma Export (C, u00222, "bindo__validatorsB");
   u00223 : constant Version_32 := 16#500a8d28#;
   pragma Export (C, u00223, "bindo__validatorsS");
   u00224 : constant Version_32 := 16#bcb5ca21#;
   pragma Export (C, u00224, "bindo__diagnosticsB");
   u00225 : constant Version_32 := 16#0693eff6#;
   pragma Export (C, u00225, "bindo__diagnosticsS");
   u00226 : constant Version_32 := 16#0bf3fb56#;
   pragma Export (C, u00226, "bindusgB");
   u00227 : constant Version_32 := 16#12f067e3#;
   pragma Export (C, u00227, "bindusgS");
   u00228 : constant Version_32 := 16#52ebc05d#;
   pragma Export (C, u00228, "switchB");
   u00229 : constant Version_32 := 16#1a3900eb#;
   pragma Export (C, u00229, "switchS");
   u00230 : constant Version_32 := 16#b02c2680#;
   pragma Export (C, u00230, "switch__bB");
   u00231 : constant Version_32 := 16#2c145cac#;
   pragma Export (C, u00231, "switch__bS");
   u00232 : constant Version_32 := 16#3d85829e#;
   pragma Export (C, u00232, "system__response_fileB");
   u00233 : constant Version_32 := 16#dc02831e#;
   pragma Export (C, u00233, "system__response_fileS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  interfaces%s
   --  system%s
   --  system.parameters%s
   --  system.parameters%b
   --  system.crtl%s
   --  system.storage_elements%s
   --  system.img_address_32%s
   --  system.img_address_64%s
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.string_hash%s
   --  system.string_hash%b
   --  system.htable%s
   --  system.htable%b
   --  system.strings%s
   --  system.strings%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  system.unsigned_types%s
   --  system.utf_32%s
   --  system.utf_32%b
   --  system.wch_con%s
   --  system.wch_con%b
   --  system.wch_jis%s
   --  system.wch_jis%b
   --  system.wch_cnv%s
   --  system.wch_cnv%b
   --  system.concat_2%s
   --  system.concat_2%b
   --  system.crc32%s
   --  system.crc32%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.secondary_stack%s
   --  system.standard_library%s
   --  ada.exceptions%s
   --  system.exceptions_debug%s
   --  system.exceptions_debug%b
   --  system.soft_links%s
   --  system.wch_stw%s
   --  system.wch_stw%b
   --  ada.exceptions.last_chance_handler%s
   --  ada.exceptions.last_chance_handler%b
   --  ada.exceptions.traceback%s
   --  ada.exceptions.traceback%b
   --  system.address_image%s
   --  system.address_image%b
   --  system.exception_table%s
   --  system.exception_table%b
   --  ada.numerics%s
   --  ada.numerics.big_numbers%s
   --  system.exceptions%s
   --  system.exceptions.machine%s
   --  system.exceptions.machine%b
   --  system.img_int%s
   --  system.memory%s
   --  system.memory%b
   --  system.secondary_stack%b
   --  system.soft_links.initialize%s
   --  system.soft_links.initialize%b
   --  system.soft_links%b
   --  system.standard_library%b
   --  system.traceback.symbolic%s
   --  system.traceback.symbolic%b
   --  ada.exceptions%b
   --  gnat%s
   --  gnat.heap_sort_a%s
   --  gnat.heap_sort_a%b
   --  gnat.htable%s
   --  gnat.htable%b
   --  interfaces.c%s
   --  interfaces.c%b
   --  system.case_util%s
   --  system.case_util%b
   --  system.os_lib%s
   --  system.os_lib%b
   --  gnat.byte_order_mark%s
   --  gnat.byte_order_mark%b
   --  gnat.dynamic_htables%s
   --  gnat.dynamic_htables%b
   --  gnat.lists%s
   --  gnat.lists%b
   --  gnat.sets%s
   --  gnat.sets%b
   --  gnat.graphs%s
   --  gnat.graphs%b
   --  system.response_file%s
   --  system.response_file%b
   --  debug%s
   --  debug%b
   --  types%s
   --  types%b
   --  alloc%s
   --  gnatvsn%s
   --  gnatvsn%b
   --  hostparm%s
   --  opt%s
   --  opt%b
   --  csets%s
   --  csets%b
   --  output%s
   --  output%b
   --  rident%s
   --  seinfo%s
   --  stand%s
   --  stylesw%s
   --  stylesw%b
   --  table%s
   --  table%b
   --  elists%s
   --  elists%b
   --  uintp%s
   --  uintp%b
   --  urealp%s
   --  urealp%b
   --  warnsw%s
   --  warnsw%b
   --  widechar%s
   --  widechar%b
   --  namet%s
   --  namet%b
   --  butil%s
   --  butil%b
   --  binderr%s
   --  binderr%b
   --  casing%s
   --  casing%b
   --  err_vars%s
   --  fmap%s
   --  osint%s
   --  fmap%b
   --  sdefault%s
   --  sdefault%b
   --  targparm%s
   --  targparm%b
   --  osint%b
   --  fname%s
   --  fname%b
   --  osint.b%s
   --  osint.b%b
   --  sinfo%s
   --  snames%s
   --  snames%b
   --  ali%s
   --  ali%b
   --  binde%s
   --  binde%b
   --  bindgen%s
   --  bindgen%b
   --  bindo%s
   --  bindo.units%s
   --  bindo.graphs%s
   --  bindo.augmentors%s
   --  bindo.builders%s
   --  bindo.diagnostics%s
   --  bindo.elaborators%s
   --  bindo%b
   --  bindo.validators%s
   --  bindo.writers%s
   --  bindo.writers%b
   --  bindo.augmentors%b
   --  bindo.builders%b
   --  bindo.diagnostics%b
   --  bindo.elaborators%b
   --  bindo.graphs%b
   --  bindo.units%b
   --  bindo.validators%b
   --  einfo%s
   --  scans%s
   --  scans%b
   --  nlists%s
   --  sinfo.nodes%s
   --  einfo.entities%s
   --  einfo.utils%s
   --  atree%s
   --  einfo.entities%b
   --  nlists%b
   --  sinfo.utils%s
   --  atree%b
   --  einfo.utils%b
   --  sinfo.nodes%b
   --  sinput%s
   --  sinput%b
   --  sinfo.utils%b
   --  sem_aux%s
   --  sem_aux%b
   --  sinput.c%s
   --  sinput.c%b
   --  stringt%s
   --  stringt%b
   --  erroutc%s
   --  erroutc%b
   --  lib%s
   --  uname%s
   --  uname%b
   --  lib%b
   --  diagnostics%s
   --  diagnostics.brief_emitter%s
   --  diagnostics.converter%s
   --  diagnostics.json_utils%s
   --  diagnostics.json_utils%b
   --  diagnostics.pretty_emitter%s
   --  diagnostics.repository%s
   --  diagnostics.sarif_emitter%s
   --  diagnostics.switch_repository%s
   --  diagnostics.switch_repository%b
   --  diagnostics.converter%b
   --  diagnostics.utils%s
   --  diagnostics%b
   --  diagnostics.brief_emitter%b
   --  diagnostics.pretty_emitter%b
   --  diagnostics.repository%b
   --  errout%s
   --  errout%b
   --  diagnostics.sarif_emitter%b
   --  diagnostics.utils%b
   --  styleg%s
   --  styleg%b
   --  scng%s
   --  scng%b
   --  ali.util%s
   --  ali.util%b
   --  bcheck%s
   --  bcheck%b
   --  switch%s
   --  switch%b
   --  bindusg%s
   --  bindusg%b
   --  switch.b%s
   --  switch.b%b
   --  gnatbind%s
   --  gnatbind%b
   --  END ELABORATION ORDER

end ada_main;
