/* do not edit automatically generated by mc from DynamicPath.  */
/* DynamicPath.def implements a path for DynamicStrings.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */


#if !defined (_DynamicPath_H)
#   define _DynamicPath_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_DynamicPath_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (DynamicPath_PathList_D)
#  define DynamicPath_PathList_D
   typedef void *DynamicPath_PathList;
#endif


/*
   InitPathList - creates a new empty path list.
*/

EXTERN DynamicPath_PathList DynamicPath_InitPathList (DynamicStrings_String str);

/*
   KillPathList - places list pl onto the freelist.
                  Postcondition: pl will be NIL.
*/

EXTERN void DynamicPath_KillPathList (DynamicPath_PathList *pl);

/*
   Cons - appends str to the end of a path list.
          If pl is NIL a new list is created and returned
          containing str.
*/

EXTERN DynamicPath_PathList DynamicPath_Cons (DynamicPath_PathList pl, DynamicStrings_String str);

/*
   ConsList - concatenates path list left and right together.
*/

EXTERN DynamicPath_PathList DynamicPath_ConsList (DynamicPath_PathList left, DynamicPath_PathList right);

/*
   Stash - returns pl before setting pl to NIL.
*/

EXTERN DynamicPath_PathList DynamicPath_Stash (DynamicPath_PathList *pl);

/*
   FindFileName - returns NIL if a file cannot be found otherwise
                  it returns the path including the filename.
*/

EXTERN DynamicStrings_String DynamicPath_FindFileName (DynamicStrings_String filename, DynamicPath_PathList pl);

/*
   DumpPath - debugging dump of the pathlist.
*/

EXTERN void DynamicPath_DumpPath (DynamicStrings_String name, DynamicPath_PathList pl);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
