/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern0 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_TImode)
      || GET_MODE (x2) != E_TImode
      || !register_operand (operands[1], E_TImode))
    return -1;
  x5 = XEXP (x3, 0);
  operands[2] = x5;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  return 0;
}

int
pattern18 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  return pattern17 (x1); /* [-1, 1] */
}

int
pattern22 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern32 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (operands[2]))
    {
    case CONST_INT:
      switch (GET_MODE (operands[0]))
        {
        case E_V1TImode:
          return pattern30 (x3); /* [-1, 0] */

        case E_V16SImode:
          if (pattern31 (x3, 
E_V16SImode) != 0)
            return -1;
          return 1;

        case E_V8SImode:
          if (pattern31 (x3, 
E_V8SImode) != 0)
            return -1;
          return 2;

        case E_V4SImode:
          if (!register_operand (operands[0], E_V4SImode)
              || GET_MODE (x3) != E_V4SImode
              || !nonimmediate_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V8DImode:
          if (pattern31 (x3, 
E_V8DImode) != 0)
            return -1;
          return 4;

        case E_V4DImode:
          if (pattern31 (x3, 
E_V4DImode) != 0)
            return -1;
          return 5;

        case E_V2DImode:
          if (!register_operand (operands[0], E_V2DImode)
              || GET_MODE (x3) != E_V2DImode
              || !nonimmediate_operand (operands[1], E_V2DImode))
            return -1;
          return 6;

        case E_V16QImode:
          if (!register_operand (operands[0], E_V16QImode)
              || GET_MODE (x3) != E_V16QImode
              || !nonimmediate_operand (operands[1], E_V16QImode)
              || !const_0_to_7_operand (operands[2], E_SImode))
            return -1;
          return 7;

        case E_V8HImode:
          if (!register_operand (operands[0], E_V8HImode)
              || GET_MODE (x3) != E_V8HImode
              || !nonimmediate_operand (operands[1], E_V8HImode)
              || !const_0_to_15_operand (operands[2], E_SImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern14 (x3, 
E_V16SImode) != 0)
            return -1;
          return 9;

        case E_V8SImode:
          if (pattern14 (x3, 
E_V8SImode) != 0)
            return -1;
          return 10;

        case E_V4SImode:
          if (pattern14 (x3, 
E_V4SImode) != 0)
            return -1;
          return 11;

        case E_V8DImode:
          if (pattern14 (x3, 
E_V8DImode) != 0)
            return -1;
          return 12;

        case E_V4DImode:
          if (pattern14 (x3, 
E_V4DImode) != 0)
            return -1;
          return 13;

        case E_V2DImode:
          if (pattern14 (x3, 
E_V2DImode) != 0)
            return -1;
          return 14;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern54 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_CONCAT
      || GET_MODE (x4) != E_V8HImode)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 4)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x10 = XEXP (x2, 1);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V4HImode)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_CONCAT
      || GET_MODE (x11) != E_V8HImode)
    return -1;
  x12 = XEXP (x10, 1);
  if (GET_CODE (x12) != PARALLEL
      || XVECLEN (x12, 0) != 4)
    return -1;
  x13 = XVECEXP (x12, 0, 0);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x14 = XVECEXP (x12, 0, 1);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x15 = XVECEXP (x12, 0, 2);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x16 = XVECEXP (x12, 0, 3);
  if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x17 = XEXP (x1, 0);
  operands[0] = x17;
  if (!register_operand (operands[0], E_V4HImode)
      || pattern53 (x2) != 0)
    return -1;
  return 0;
}

int
pattern72 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern71 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern71 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern81 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_QImode
      || !register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_QImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return 0;
}

int
pattern88 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern92 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_BLKmode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!memory_operand (operands[0], E_BLKmode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern101 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT
      || GET_MODE (x3) != E_V8HImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != VEC_SELECT
      || GET_MODE (x9) != E_V4HImode)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_CONCAT
      || GET_MODE (x10) != E_V8HImode)
    return -1;
  x11 = XEXP (x9, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V4HImode)
      || GET_MODE (x1) != E_V4HImode
      || pattern53 (x1) != 0)
    return -1;
  return 0;
}

int
pattern119 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_DImode
      || pattern41 (x1, 
E_SImode, 
E_DImode) != 0)
    return -1;
  return 0;
}

int
pattern125 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern124 (x2, 
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern124 (x2, 
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern136 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern145 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern128 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern128 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern129 (x1, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern128 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern128 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern128 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern128 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern128 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern128 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern128 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern128 (x1, 
E_V16HImode, 
E_HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern129 (x1, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern157 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern152 (x3, 
E_V64QImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern152 (x3, 
E_V32QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern152 (x3, 
E_V16QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern164 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern163 (x3, 
E_V64QImode, 
E_V32HFmode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern163 (x3, 
E_V32QImode, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern163 (x3, 
E_V16QImode, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern173 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DImode:
      return pattern172 (x3, 
E_V8DImode); /* [-1, 0] */

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 1;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern180 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_V4HFmode:
          if (!const0_operand (operands[2], E_V4HFmode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!vector_operand (operands[1], E_V4SImode))
                return -1;
              return 0;

            case E_V4DImode:
              if (!vector_operand (operands[1], E_V4DImode))
                return -1;
              return 1;

            default:
              return -1;
            }

        case E_V2HFmode:
          if (!vector_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V6HFmode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V4SFmode:
      if (pattern179 (x1, 
E_V2SFmode, 
E_V2DImode, 
E_V4SFmode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern192 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_SELECT)
    return -1;
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 8:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x14 = XVECEXP (x4, 0, 4);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x15 = XVECEXP (x4, 0, 5);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x16 = XVECEXP (x4, 0, 6);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x17 = XVECEXP (x4, 0, 7);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x22 = XVECEXP (x7, 0, 4);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x23 = XVECEXP (x7, 0, 5);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x24 = XVECEXP (x7, 0, 6);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x25 = XVECEXP (x7, 0, 7);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern191 (x1, 
E_V8QImode, 
E_V8HImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 4:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern191 (x1, 
E_V4HImode, 
E_V4SImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case 2:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2]
          || XVECLEN (x7, 0) != 2)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
          || pattern191 (x1, 
E_V2SImode, 
E_V2DImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern222 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern221 (x7, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern221 (x7, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern236 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      return pattern235 (x1, 
E_V4HImode); /* [-1, 0] */

    case E_V2SImode:
      if (pattern235 (x1, 
E_V2SImode) != 0)
        return -1;
      return 1;

    case E_V2HImode:
      if (pattern235 (x1, 
E_V2HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern246 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern245 (x6); /* [-1, 1] */
}

int
pattern256 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V2QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!memory_operand (operands[0], E_HImode)
      || GET_MODE (x2) != E_HImode)
    return -1;
  x5 = XEXP (x3, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_V2DImode))
    return -1;
  return 0;
}

int
pattern262 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL
      || !nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern268 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern2 (x1); /* [-1, 1] */
}

int
pattern274 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern279 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (!nonimmediate_operand (x3, i2))
    return -1;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      if (pnum_clobbers == NULL)
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], i1))
        return -1;
      operands[2] = x3;
      return 0;

    case ASHIFT:
      if (GET_MODE (x4) != i1)
        return -1;
      operands[1] = x3;
      res = pattern37 (x4, 
i1, 
i2);
      if (res >= 0)
        return res + 1; /* [1, 3] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      if (!const_scalar_int_operand (operands[2], i1))
        return -1;
      operands[1] = x3;
      return 4;

    default:
      return -1;
    }
}

int
pattern295 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V4QImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 0;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V2HImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern307 (rtx x1, int i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 2)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern315 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern319 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern325 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x1) != E_V32HImode
          || !vector_operand (operands[1], i1))
        return -1;
      return 0;

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x1) != E_V16HImode
          || !vector_operand (operands[1], i2))
        return -1;
      return 1;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || !vector_operand (operands[1], i3))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern330 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern332 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_V4SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != SIGN_EXTEND
      || GET_MODE (x2) != E_V4SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != SIGN_EXTEND)
    return -1;
  return 0;
}

int
pattern339 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V4DImode:
      return pattern338 (x1, 
E_V4DImode); /* [-1, 0] */

    case E_V2DImode:
      if (pattern338 (x1, 
E_V2DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern343 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern348 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern352 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (XVECLEN (x4, 0) != 3)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC
      || XVECLEN (x6, 0) != 3)
    return -1;
  return 0;
}

int
pattern355 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  x6 = XEXP (x1, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern359 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern364 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XVECEXP (x5, 0, 0);
  operands[0] = x6;
  x7 = XVECEXP (x5, 0, 1);
  operands[2] = x7;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  x8 = XEXP (x4, 1);
  operands[1] = x8;
  x9 = XVECEXP (x1, 0, 1);
  x10 = XEXP (x9, 1);
  x11 = XEXP (x10, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x10, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  x13 = XEXP (x9, 0);
  if (!rtx_equal_p (x13, operands[0]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_QImode:
      return pattern363 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern363 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern363 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern363 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern377 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          return 0;

        case USE:
          return 1;

        default:
          return -1;
        }

    case STRICT_LOW_PART:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      x8 = XEXP (x5, 0);
      operands[0] = x8;
      res = pattern376 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern394 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 0);
  operands[0] = x7;
  x8 = XEXP (x6, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  x10 = XEXP (x8, 1);
  operands[3] = x10;
  x11 = XEXP (x2, 0);
  operands[1] = x11;
  x12 = XEXP (x3, 0);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  x13 = XEXP (x3, 1);
  if (!rtx_equal_p (x13, operands[3]))
    return -1;
  x14 = XVECEXP (x1, 0, 2);
  switch (GET_CODE (x14))
    {
    case UNSPEC:
      return pattern391 (x1); /* [-1, 1] */

    case USE:
      res = pattern393 (x1);
      if (res >= 0)
        return res + 2; /* [2, 4] */
      return -1;

    default:
      return -1;
    }
}

int
pattern411 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!memory_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!memory_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern415 (rtx x1, rtx_code i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern419 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern426 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern435 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XEXP (x3, 0);
  operands[2] = x6;
  if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern434 (x2, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern434 (x2, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern449 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern448 (x1); /* [-1, 1] */
}

int
pattern454 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_V32QImode:
      if (!vector_operand (operands[1], E_V32QImode)
          || !vector_operand (operands[2], E_V32QImode)
          || !const0_operand (operands[3], E_V32QImode))
        return -1;
      return 0;

    case E_V32HImode:
      if (!vector_operand (operands[1], E_V32HImode)
          || !vector_operand (operands[2], E_V32HImode)
          || !const0_operand (operands[3], E_V32HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern464 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern470 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !vector_operand (operands[1], i2)
      || !vector_operand (operands[2], i2)
      || !vector_operand (operands[3], i2)
      || !const0_operand (operands[4], i2))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[5], E_QImode))
    return -1;
  return 0;
}

int
pattern478 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern486 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  x7 = XEXP (x1, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      if (!rtx_equal_p (x7, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          return pattern480 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

        case E_V8SImode:
          if (pattern480 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 1;

        case E_V4SImode:
          if (pattern480 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[5] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern485 (x1, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SImode:
          if (pattern485 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SImode:
          if (pattern485 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern498 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode
          || GET_MODE (x2) != E_V2HFmode)
        return -1;
      x7 = XEXP (x2, 0);
      if (GET_MODE (x7) != E_V2HFmode
          || !vector_operand (operands[1], i1)
          || GET_MODE (x3) != E_V2HFmode
          || !nonimm_or_0_operand (operands[2], E_V8HFmode)
          || !const0_operand (operands[4], E_V6HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (pattern497 (x1, 
E_V2SFmode, 
E_V4SFmode, 
i1) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern506 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern511 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const0_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern517 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2DFmode)
      || GET_MODE (x1) != E_V2DFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!nonimmediate_operand (operands[1], E_V2SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!nonimmediate_operand (operands[1], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern522 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !permvar_truncate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern530 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !regmem_or_bitnot_regmem_operand (operands[1], i1)
      || !regmem_or_bitnot_regmem_operand (operands[2], i1)
      || !regmem_or_bitnot_regmem_operand (operands[3], i1)
      || !regmem_or_bitnot_regmem_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern533 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern532 (x1); /* [-1, 11] */

    case IOR:
      res = pattern532 (x1);
      if (res >= 0)
        return res + 12; /* [12, 23] */
      return -1;

    case XOR:
      res = pattern532 (x1);
      if (res >= 0)
        return res + 24; /* [24, 35] */
      return -1;

    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern528 (x1, 
E_V32HFmode) != 0)
            return -1;
          return 36;

        case E_V16HFmode:
          if (pattern528 (x1, 
E_V16HFmode) != 0)
            return -1;
          return 37;

        case E_V8HFmode:
          if (pattern528 (x1, 
E_V8HFmode) != 0)
            return -1;
          return 38;

        case E_V32BFmode:
          if (pattern528 (x1, 
E_V32BFmode) != 0)
            return -1;
          return 39;

        case E_V16BFmode:
          if (pattern528 (x1, 
E_V16BFmode) != 0)
            return -1;
          return 40;

        case E_V8BFmode:
          if (pattern528 (x1, 
E_V8BFmode) != 0)
            return -1;
          return 41;

        case E_V16SFmode:
          if (pattern528 (x1, 
E_V16SFmode) != 0)
            return -1;
          return 42;

        case E_V8SFmode:
          if (pattern528 (x1, 
E_V8SFmode) != 0)
            return -1;
          return 43;

        case E_V4SFmode:
          if (pattern528 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 44;

        case E_V8DFmode:
          if (pattern528 (x1, 
E_V8DFmode) != 0)
            return -1;
          return 45;

        case E_V4DFmode:
          if (pattern528 (x1, 
E_V4DFmode) != 0)
            return -1;
          return 46;

        case E_V2DFmode:
          if (pattern528 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 47;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern546 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern552 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern551 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern551 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern557 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern562 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !x86_64_general_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern568 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!ix86_carry_flag_operator (operands[1], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern573 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const123_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern430 (x1); /* [-1, 1] */
}

int
pattern578 (rtx x1, rtx_code i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern583 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (GET_MODE (x7) != E_SFmode)
        return -1;
      return 1;

    case E_DFmode:
      if (GET_MODE (x7) != E_DFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern590 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SUBREG
      || maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XVECEXP (x1, 0, 0);
  operands[1] = x3;
  return pattern589 (x1); /* [-1, 2] */
}

int
pattern594 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (!commutative_operator (x2, E_VOIDmode))
    return -1;
  operands[3] = x2;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_VOIDmode))
    return -1;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = XEXP (x1, 0);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  return 0;
}

int
pattern600 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !const_int_operand (operands[2], E_QImode)
      || !const_scalar_int_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern606 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern611 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!const_1_to_63_operand (operands[2], E_QImode)
      || !register_operand (operands[0], E_TImode)
      || GET_MODE (x1) != E_TImode
      || !register_operand (operands[1], E_TImode))
    return -1;
  return 0;
}

int
pattern618 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != SUBREG
      || maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      return pattern449 (x1); /* [-1, 1] */

    case PLUS:
      res = pattern449 (x1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern16 (x1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern631 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[3] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern628 (x1, 
E_V16SImode, 
E_HImode, 
E_V16SFmode); /* [-1, 0] */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x1) != E_V8SImode
          || GET_MODE (x2) != E_V8SImode
          || !nonimm_or_0_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8SFmode:
          if (!vector_operand (operands[1], E_V8SFmode))
            return -1;
          return 1;

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode
          || GET_MODE (x2) != E_V4SImode
          || !nonimm_or_0_operand (operands[2], E_V4SImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 3;

        case E_V4DFmode:
          if (!vector_operand (operands[1], E_V4DFmode))
            return -1;
          return 4;

        case E_V2DFmode:
          if (!vector_operand (operands[1], E_V2DFmode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode
          || GET_MODE (x2) != E_V8DImode
          || !nonimm_or_0_operand (operands[2], E_V8DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode))
            return -1;
          return 6;

        case E_V8SFmode:
          if (!vector_operand (operands[1], E_V8SFmode))
            return -1;
          return 7;

        default:
          return -1;
        }

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x1) != E_V4DImode
          || GET_MODE (x2) != E_V4DImode
          || !nonimm_or_0_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V4DFmode:
          if (!vector_operand (operands[1], E_V4DFmode))
            return -1;
          return 8;

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 9;

        default:
          return -1;
        }

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode
          || GET_MODE (x2) != E_V2DImode
          || !nonimm_or_0_operand (operands[2], E_V2DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V2DFmode:
          if (!vector_operand (operands[1], E_V2DFmode))
            return -1;
          return 10;

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern670 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_BFmode:
      if (!memory_operand (operands[1], E_BFmode))
        return -1;
      return 0;

    case E_HFmode:
      if (!memory_operand (operands[1], E_HFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern676 (rtx x1, rtx_code i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern679 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCOmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x2, 1);
  if (GET_MODE (x6) != E_CCOmode)
    return -1;
  x7 = XEXP (x4, 0);
  operands[0] = x7;
  return 0;
}

int
pattern686 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  return pattern685 (x2); /* [-1, 3] */
}

int
pattern691 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2SFmode)
      || GET_MODE (x1) != E_V2SFmode
      || !register_operand (operands[1], E_V2SFmode)
      || !nonimmediate_operand (operands[2], E_V2SFmode))
    return -1;
  return 0;
}

int
pattern698 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  return pattern407 (x5); /* [-1, 1] */
}

int
pattern704 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 37)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 0;

    case SET:
      x3 = XEXP (x1, 1);
      if (GET_CODE (x3) != PLUS
          || GET_MODE (x3) != E_SImode)
        return -1;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 7
          || GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_CODE (x5) != REG
          || REGNO (x5) != 7
          || GET_MODE (x5) != E_SImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern710 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const_scalar_int_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern718 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != i2
      || GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern723 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  x4 = XEXP (x1, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  x7 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x7) != SET)
    return -1;
  return 0;
}

int
pattern729 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern733 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != EQ)
    return -1;
  x4 = XEXP (x3, 0);
  operands[3] = x4;
  x5 = XEXP (x3, 1);
  operands[4] = x5;
  x6 = XEXP (x2, 1);
  operands[5] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      return pattern732 (x1, 
E_V8QImode); /* [-1, 0] */

    case E_V4QImode:
      if (pattern732 (x1, 
E_V4QImode) != 0)
        return -1;
      return 1;

    case E_V2QImode:
      if (pattern732 (x1, 
E_V2QImode) != 0)
        return -1;
      return 2;

    case E_V2HImode:
      if (pattern732 (x1, 
E_V2HImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern744 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x4, 0);
  operands[2] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      if (!register_operand (operands[0], E_V4HImode)
          || GET_MODE (x1) != E_V4HImode
          || GET_MODE (x2) != E_V4SImode
          || GET_MODE (x3) != E_V4SImode
          || GET_MODE (x5) != E_V4SImode
          || !register_mmxmem_operand (operands[1], E_V4HImode)
          || GET_MODE (x4) != E_V4SImode
          || !register_mmxmem_operand (operands[2], E_V4HImode))
        return -1;
      return 0;

    case E_V2HImode:
      if (!register_operand (operands[0], E_V2HImode)
          || GET_MODE (x1) != E_V2HImode
          || GET_MODE (x2) != E_V2SImode
          || GET_MODE (x3) != E_V2SImode
          || GET_MODE (x5) != E_V2SImode
          || !register_operand (operands[1], E_V2HImode)
          || GET_MODE (x4) != E_V2SImode
          || !register_operand (operands[2], E_V2HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern768 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern772 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern771 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern771 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern771 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern779 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern788 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern796 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !pmovzx_parallel (operands[3], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern806 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern811 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0)
      || GET_MODE (x1) != E_QImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x2;
      x3 = XEXP (x2, 1);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x4 = XEXP (x2, 2);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern816 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != USE)
    return -1;
  x5 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x5) != USE
      || !register_operand (operands[0], E_XFmode)
      || !register_operand (operands[1], E_XFmode))
    return -1;
  x6 = XEXP (x4, 0);
  operands[2] = x6;
  if (!memory_operand (operands[2], E_HImode))
    return -1;
  x7 = XEXP (x5, 0);
  operands[3] = x7;
  if (!memory_operand (operands[3], E_HImode))
    return -1;
  return 0;
}

int
pattern823 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !x86_64_nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern827 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V2SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern691 (x5); /* [-1, 0] */

    case E_V2BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2BFmode) != 0)
        return -1;
      return 1;

    case E_V4BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4BFmode) != 0)
        return -1;
      return 2;

    case E_V2HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2HFmode) != 0)
        return -1;
      return 3;

    case E_V4HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4HFmode) != 0)
        return -1;
      return 4;

    case E_V32BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32BFmode) != 0)
        return -1;
      return 5;

    case E_V16BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16BFmode) != 0)
        return -1;
      return 6;

    case E_V8BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8BFmode) != 0)
        return -1;
      return 7;

    case E_V32HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32HFmode) != 0)
        return -1;
      return 8;

    case E_V16HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16HFmode) != 0)
        return -1;
      return 9;

    case E_V8HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8HFmode) != 0)
        return -1;
      return 10;

    case E_V16SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16SFmode) != 0)
        return -1;
      return 11;

    case E_V8SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8SFmode) != 0)
        return -1;
      return 12;

    case E_V4SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4SFmode) != 0)
        return -1;
      return 13;

    case E_V8DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8DFmode) != 0)
        return -1;
      return 14;

    case E_V4DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4DFmode) != 0)
        return -1;
      return 15;

    case E_V2DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V2DFmode) != 0)
        return -1;
      return 16;

    default:
      return -1;
    }
}

int
pattern863 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_DImode:
      if (!register_operand (operands[1], E_V64QImode)
          || !nonimmediate_operand (operands[2], E_V64QImode))
        return -1;
      return 0;

    case E_SImode:
      res = pattern862 ();
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_HImode:
      res = pattern736 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case E_QImode:
      res = pattern737 ();
      if (res >= 0)
        return res + 6; /* [6, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern873 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !const_int_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern882 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern888 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x1, 0, 9);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x1, 0, 10);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x1, 0, 11);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x1, 0, 12);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x1, 0, 13);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x1, 0, 14);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x1, 0, 15);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x1, 0, 16);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x1, 0, 17);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x1, 0, 18);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x1, 0, 19);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x1, 0, 20);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x1, 0, 21);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x1, 0, 22);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x1, 0, 23);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x1, 0, 24);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x1, 0, 25);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x1, 0, 26);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x1, 0, 27);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x1, 0, 28);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x1, 0, 29);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x1, 0, 30);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x1, 0, 31);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  return 0;
}

int
pattern917 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  return 0;
}

int
pattern925 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  return pattern812 (x6, pnum_clobbers); /* [-1, 1] */
}

int
pattern933 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern940 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern203 (x3, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern203 (x3, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern947 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || !general_reg_operand (operands[1], i1))
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      if (peep2_current_count < 4)
        return -1;
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!general_reg_operand (operands[2], i1))
        return -1;
      x3 = XEXP (x1, 1);
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      x4 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 2)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) != ASHIFTRT
          || GET_MODE (x6) != i1)
        return -1;
      x7 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x7) != CLOBBER)
        return -1;
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      x9 = XEXP (x6, 1);
      operands[4] = x9;
      if (!const_int_operand (operands[4], E_VOIDmode))
        return -1;
      x10 = XEXP (x6, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x5, 0);
      if (!rtx_equal_p (x11, operands[2]))
        return -1;
      x12 = PATTERN (peep2_next_insn (3));
      if (GET_CODE (x12) != SET)
        return -1;
      x13 = XEXP (x12, 0);
      operands[3] = x13;
      if (!memory_operand (operands[3], i1))
        return -1;
      x14 = XEXP (x12, 1);
      if (!rtx_equal_p (x14, operands[2]))
        return -1;
      return 0;

    case PARALLEL:
      if (XVECLEN (x1, 0) != 2)
        return -1;
      x15 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x15) != SET)
        return -1;
      x16 = XEXP (x15, 1);
      if (GET_CODE (x16) != ASHIFTRT
          || GET_MODE (x16) != i1)
        return -1;
      x17 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x17) != CLOBBER)
        return -1;
      x18 = XEXP (x17, 0);
      if (GET_CODE (x18) != REG
          || REGNO (x18) != 17
          || GET_MODE (x18) != E_CCmode)
        return -1;
      x19 = XEXP (x15, 0);
      operands[2] = x19;
      if (!general_reg_operand (operands[2], i1))
        return -1;
      x20 = XEXP (x16, 1);
      operands[4] = x20;
      if (!const_int_operand (operands[4], E_VOIDmode))
        return -1;
      x21 = XEXP (x16, 0);
      if (!rtx_equal_p (x21, operands[1]))
        return -1;
      x4 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x4) != SET)
        return -1;
      x22 = XEXP (x4, 0);
      operands[3] = x22;
      if (!memory_operand (operands[3], i1))
        return -1;
      x23 = XEXP (x4, 1);
      if (!rtx_equal_p (x23, operands[2]))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern970 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vector_all_ones_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern976 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[1], E_V32HFmode)
          || !nonimmediate_operand (operands[2], E_V32HFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !nonimmediate_operand (operands[2], E_V32QImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_V32HImode:
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern987 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern990 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern999 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1008 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8SImode)
      || GET_MODE (x1) != E_V8SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V8SImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8DFmode:
      if (!register_operand (operands[1], E_V8DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1019 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1027 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_HImode
          || !extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_SImode
          || !extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_DImode
          || !extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1035 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[2] = x5;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x6 = XEXP (x1, 0);
  switch (GET_CODE (x6))
    {
    case STRICT_LOW_PART:
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      return pattern1034 (); /* [-1, 2] */

    case REG:
    case SUBREG:
      operands[0] = x6;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      res = pattern1034 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1042 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1045 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1049 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 1);
  operands[3] = x4;
  switch (GET_CODE (x3))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x3), 0))
        return -1;
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) != AND)
        return -1;
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      if (!const_int_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          return pattern371 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern371 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case AND:
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern371 (x1, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern371 (x1, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1074 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0))
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case VEC_MERGE:
      x3 = XEXP (x2, 2);
      if (GET_CODE (x3) != UNSPEC
          || XVECLEN (x3, 0) != 3
          || XINT (x3, 1) != 59
          || GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XVECEXP (x3, 0, 2);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x5 = XEXP (x2, 0);
      operands[3] = x5;
      x6 = XEXP (x2, 1);
      operands[4] = x6;
      x7 = XVECEXP (x3, 0, 0);
      operands[1] = x7;
      x8 = XVECEXP (x3, 0, 1);
      operands[2] = x8;
      switch (GET_MODE (x1))
        {
        case E_V8SFmode:
          return pattern1073 (x2, 
E_V8SImode); /* [-1, 0] */

        case E_V4SFmode:
          if (pattern1073 (x2, 
E_V4SImode) != 0)
            return -1;
          return 1;

        case E_V4DFmode:
          if (pattern1073 (x2, 
E_V4DImode) != 0)
            return -1;
          return 2;

        case E_V2DFmode:
          if (pattern1073 (x2, 
E_V2DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    case ASHIFTRT:
      x5 = XEXP (x2, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (x1))
        {
        case E_V8SFmode:
          if (GET_MODE (x2) != E_V8SImode
              || !register_operand (operands[1], E_V8SImode))
            return -1;
          return 4;

        case E_V4SFmode:
          if (GET_MODE (x2) != E_V4SImode
              || !register_operand (operands[1], E_V4SImode))
            return -1;
          return 5;

        case E_V4DFmode:
          if (GET_MODE (x2) != E_V4DImode
              || !register_operand (operands[1], E_V4DImode))
            return -1;
          return 6;

        case E_V2DFmode:
          if (GET_MODE (x2) != E_V2DImode
              || !register_operand (operands[1], E_V2DImode))
            return -1;
          return 7;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1098 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1106 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[1], i1)
      || !avx2_pblendw_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1113 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !nonimmediate_operand (operands[2], i3))
    return -1;
  x4 = XEXP (x2, 1);
  return pattern1112 (x4, 
i1, 
i2, 
i3, 
i4); /* [-1, 0] */
}

int
pattern1119 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1125 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1131 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x1, 2);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1140 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != 19
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1145 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1152 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  return pattern1151 (x3); /* [-1, 2] */
}

int
pattern1159 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC_VOLATILE
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i2
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1165 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x3;
      x4 = XEXP (x3, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x5 = XEXP (x3, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
          || GET_MODE (x1) != E_QImode)
        return -1;
      x6 = XEXP (x3, 0);
      if (!int248_register_operand (x6, E_VOIDmode))
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern1178 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PLUS)
    return -1;
  x7 = XEXP (x2, 0);
  if (GET_MODE (x7) != E_CCCmode
      || GET_MODE (x3) != E_CCCmode)
    return -1;
  x8 = XEXP (x4, 1);
  operands[2] = x8;
  if (!memory_operand (operands[2], i1))
    return -1;
  x9 = XEXP (x4, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x3, 1);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x6, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x6, 1);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  return 0;
}

int
pattern1188 (rtx x1, machine_mode i1, rtx_code i2, machine_mode i3, rtx_code i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i4
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1192 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1195 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1203 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1211 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || !vector_operand (operands[1], E_V16QImode)
          || !register_operand (operands[2], E_V16QImode)
          || GET_MODE (x2) != E_V16QImode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_V4SImode:
          if (!register_operand (operands[3], E_V4SImode)
              || !vector_all_ones_operand (operands[4], E_V4SImode))
            return -1;
          return 0;

        case E_V2DImode:
          if (!register_operand (operands[3], E_V2DImode)
              || !vector_all_ones_operand (operands[4], E_V2DImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || GET_MODE (x1) != E_V32QImode
          || !vector_operand (operands[1], E_V32QImode)
          || !register_operand (operands[2], E_V32QImode)
          || GET_MODE (x2) != E_V32QImode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_V8SImode:
          if (!register_operand (operands[3], E_V8SImode)
              || !vector_all_ones_operand (operands[4], E_V8SImode))
            return -1;
          return 2;

        case E_V4DImode:
          if (!register_operand (operands[3], E_V4DImode)
              || !vector_all_ones_operand (operands[4], E_V4DImode))
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1229 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern1228 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1228 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1237 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V4QImode:
      if (GET_MODE (x1) != E_V4QImode)
        return -1;
      return 0;

    case E_V2QImode:
      if (GET_MODE (x1) != E_V2QImode)
        return -1;
      return 1;

    case E_V2HImode:
      if (GET_MODE (x1) != E_V2HImode)
        return -1;
      return 2;

    case E_QImode:
      if (pattern1236 (x1, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_HImode:
      if (pattern1236 (x1, 
E_HImode) != 0)
        return -1;
      return 4;

    case E_SImode:
      if (pattern1236 (x1, 
E_SImode) != 0)
        return -1;
      return 5;

    case E_DImode:
      if (pattern1236 (x1, 
E_DImode) != 0)
        return -1;
      return 6;

    default:
      return -1;
    }
}

int
pattern1249 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_QImode))
    return -1;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      x5 = XEXP (x4, 0);
      operands[0] = x5;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      return pattern1248 (); /* [-1, 2] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      res = pattern1248 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1264 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1273 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !vector_all_ones_operand (operands[1], i2)
      || !const0_operand (operands[2], i2)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1283 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1291 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!const48_operand (operands[4], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern1288 (x1, 
E_QImode, 
E_V8HImode, 
E_V8HFmode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern1288 (x1, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V32HImode:
      if (pattern1288 (x1, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      res = pattern1289 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case E_V16SImode:
      res = pattern1290 (x1);
      if (res >= 0)
        return res + 5; /* [5, 6] */
      return -1;

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (GET_MODE (x2) != E_V8DImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_MODE (x3) != E_V8DImode
          || !nonimm_or_0_operand (operands[2], E_V8DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          return 7;

        case E_V8DFmode:
          if (!register_operand (operands[1], E_V8DFmode))
            return -1;
          return 8;

        case E_V8SFmode:
          if (!register_operand (operands[1], E_V8SFmode))
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1313 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1319 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1328 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_QImode:
      if (!general_reg_operand (operands[1], E_QImode)
          || !nonimmediate_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!general_reg_operand (operands[1], E_HImode)
          || !nonimmediate_operand (operands[2], E_HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1335 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x2, 1);
  operands[5] = x5;
  x6 = XEXP (x4, 1);
  operands[6] = x6;
  x7 = XEXP (x4, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  x8 = PATTERN (peep2_next_insn (2));
  return pattern1334 (x8, 
i1); /* [-1, 0] */
}

int
pattern1345 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1353 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !vector_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern1360 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || pattern1359 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1368 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x2, 2);
  return pattern1367 (x3, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1378 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x4 = XEXP (x2, 2);
  return pattern1367 (x4, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1387 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      x5 = XEXP (x3, 2);
      operands[4] = x5;
      x6 = XVECEXP (x1, 0, 1);
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return pattern1386 (x1, 
E_V8HFmode); /* [-1, 0] */

        case E_V4SFmode:
          if (pattern1386 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 1;

        case E_V2DFmode:
          if (pattern1386 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x4;
      x7 = XEXP (x3, 0);
      x8 = XEXP (x7, 0);
      x9 = XEXP (x8, 0);
      operands[2] = x9;
      x10 = XEXP (x7, 1);
      operands[1] = x10;
      x5 = XEXP (x3, 2);
      operands[5] = x5;
      x6 = XVECEXP (x1, 0, 1);
      operands[6] = x6;
      x11 = XEXP (x2, 1);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 3;

        case E_V4SFmode:
          return 4;

        case E_V2DFmode:
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1410 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern1413 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !x86_64_general_operand (operands[2], E_SImode)
      || !register_operand (operands[0], E_DImode))
    return -1;
  x8 = XEXP (x4, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x4, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern1431 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !addsub_vm_operator (operands[6], i1))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1438 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1448 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1456 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 2);
  return pattern1455 (x2, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1461 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern1468 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1474 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern1481 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !memory_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1488 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 0);
  operands[0] = x8;
  x9 = XEXP (x4, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  return pattern1477 (x1); /* [-1, 1] */
}

int
pattern1495 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1503 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_4_to_7_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1510 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1519 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[1], i2))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i1
      || !register_operand (operands[2], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i1)
    return -1;
  return 0;
}

int
pattern1529 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 4);
  operands[2] = x2;
  if (!const_4_to_7_operand (operands[2], E_VOIDmode))
    return -1;
  x3 = XVECEXP (x1, 0, 5);
  operands[3] = x3;
  if (!const_4_to_7_operand (operands[3], E_VOIDmode))
    return -1;
  x4 = XVECEXP (x1, 0, 6);
  operands[4] = x4;
  if (!const_4_to_7_operand (operands[4], E_VOIDmode))
    return -1;
  x5 = XVECEXP (x1, 0, 7);
  operands[5] = x5;
  if (!const_4_to_7_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1538 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (XWINT (x2, 0) != 2L)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (XWINT (x3, 0) != 3L)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (XWINT (x5, 0) != 5L)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (XWINT (x6, 0) != 6L)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (XWINT (x7, 0) != 7L)
    return -1;
  return 0;
}

int
pattern1551 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !memory_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1560 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !x86_64_sext_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1565 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1576 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x3, 2);
  if (GET_MODE (x4) != i2
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1585 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1584 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1584 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1595 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1603 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x5 = XEXP (x3, 0);
  if (!rtx_equal_p (x5, operands[1]))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  switch (GET_MODE (x8))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1620 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x1, 1);
  if (!nonimm_or_0_operand (x4, i1))
    return -1;
  return 0;
}

int
pattern1627 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !register_operand (operands[3], i2)
      || !const0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1636 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1))
    return -1;
  return 0;
}

int
pattern1645 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_SImode:
      return pattern1644 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1644 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1656 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || pattern1655 () != 0)
    return -1;
  return 0;
}

int
pattern1665 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1670 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 2);
  if (maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != AND)
    return -1;
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  x7 = XEXP (x5, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  x8 = XEXP (x1, 1);
  x9 = XEXP (x8, 0);
  operands[4] = x9;
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1669 (x5, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern1669 (x5, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1681 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[5], i3))
    return -1;
  return 0;
}

int
pattern1691 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_7_operand (operands[2], E_VOIDmode)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || !const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_0_to_7_operand (operands[7], E_VOIDmode)
      || !const_0_to_7_operand (operands[8], E_VOIDmode)
      || !const_0_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1702 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1709 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1)
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1708 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1708 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1721 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1726 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1725 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1725 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1739 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || !const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_8_to_15_operand (operands[7], E_VOIDmode)
      || !const_8_to_15_operand (operands[8], E_VOIDmode)
      || !const_8_to_15_operand (operands[9], E_VOIDmode)
      || !const_8_to_15_operand (operands[10], E_VOIDmode)
      || !nonimm_or_0_operand (operands[11], i1))
    return -1;
  return 0;
}

int
pattern1754 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V16SImode:
      return pattern1752 (
E_HImode, 
E_V16SFmode, 
E_V16SImode); /* [-1, 0] */

    case E_V8DImode:
      if (pattern1752 (
E_QImode, 
E_V8SFmode, 
E_V8DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1762 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[3], i1)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1768 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x6 = XVECEXP (x1, 0, 16);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x7 = XVECEXP (x1, 0, 17);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x8 = XVECEXP (x1, 0, 18);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x9 = XVECEXP (x1, 0, 19);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  return 0;
}

int
pattern1782 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1792 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_0_to_3_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode)
      || !const_4_to_7_operand (operands[7], E_VOIDmode)
      || !const_4_to_7_operand (operands[8], E_VOIDmode)
      || !const_4_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1800 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != VEC_SELECT
      || GET_MODE (x5) != E_V2QImode)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 2)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XVECEXP (x6, 0, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x9 = XEXP (x3, 1);
  if (GET_CODE (x9) != i1)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V2QImode)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 2)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x14 = XEXP (x2, 1);
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != i1)
    return -1;
  x16 = XEXP (x15, 0);
  if (GET_CODE (x16) != VEC_SELECT
      || GET_MODE (x16) != E_V2QImode)
    return -1;
  x17 = XEXP (x16, 1);
  if (GET_CODE (x17) != PARALLEL
      || XVECLEN (x17, 0) != 2)
    return -1;
  x18 = XVECEXP (x17, 0, 0);
  if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x19 = XVECEXP (x17, 0, 1);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x20 = XEXP (x14, 1);
  if (GET_CODE (x20) != i1)
    return -1;
  x21 = XEXP (x20, 0);
  if (GET_CODE (x21) != VEC_SELECT
      || GET_MODE (x21) != E_V2QImode)
    return -1;
  x22 = XEXP (x21, 1);
  if (GET_CODE (x22) != PARALLEL
      || XVECLEN (x22, 0) != 2)
    return -1;
  x23 = XVECEXP (x22, 0, 0);
  if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x24 = XVECEXP (x22, 0, 1);
  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x25 = XEXP (x1, 1);
  x26 = XEXP (x25, 0);
  x27 = XEXP (x26, 0);
  if (GET_CODE (x27) != i1)
    return -1;
  x28 = XEXP (x27, 0);
  if (GET_CODE (x28) != VEC_SELECT
      || GET_MODE (x28) != E_V2QImode)
    return -1;
  x29 = XEXP (x28, 1);
  if (GET_CODE (x29) != PARALLEL
      || XVECLEN (x29, 0) != 2)
    return -1;
  x30 = XVECEXP (x29, 0, 0);
  if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x31 = XVECEXP (x29, 0, 1);
  if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x32 = XEXP (x26, 1);
  if (GET_CODE (x32) != i1)
    return -1;
  x33 = XEXP (x32, 0);
  if (GET_CODE (x33) != VEC_SELECT
      || GET_MODE (x33) != E_V2QImode)
    return -1;
  x34 = XEXP (x33, 1);
  if (GET_CODE (x34) != PARALLEL
      || XVECLEN (x34, 0) != 2)
    return -1;
  x35 = XVECEXP (x34, 0, 0);
  if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x36 = XVECEXP (x34, 0, 1);
  if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x37 = XEXP (x25, 1);
  x38 = XEXP (x37, 0);
  if (GET_CODE (x38) != i1)
    return -1;
  x39 = XEXP (x38, 0);
  if (GET_CODE (x39) != VEC_SELECT
      || GET_MODE (x39) != E_V2QImode)
    return -1;
  x40 = XEXP (x39, 1);
  if (GET_CODE (x40) != PARALLEL
      || XVECLEN (x40, 0) != 2)
    return -1;
  x41 = XVECEXP (x40, 0, 0);
  if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x42 = XVECEXP (x40, 0, 1);
  if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x43 = XEXP (x37, 1);
  if (GET_CODE (x43) != i1)
    return -1;
  x44 = XEXP (x43, 0);
  if (GET_CODE (x44) != VEC_SELECT
      || GET_MODE (x44) != E_V2QImode)
    return -1;
  x45 = XEXP (x44, 1);
  if (GET_CODE (x45) != PARALLEL
      || XVECLEN (x45, 0) != 2)
    return -1;
  x46 = XVECEXP (x45, 0, 0);
  if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x47 = XVECEXP (x45, 0, 1);
  if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  x48 = XEXP (x5, 0);
  operands[1] = x48;
  if (!nonimmediate_operand (operands[1], E_V16QImode))
    return -1;
  x49 = XEXP (x10, 0);
  if (!rtx_equal_p (x49, operands[1]))
    return -1;
  x50 = XEXP (x16, 0);
  if (!rtx_equal_p (x50, operands[1]))
    return -1;
  x51 = XEXP (x21, 0);
  if (!rtx_equal_p (x51, operands[1]))
    return -1;
  x52 = XEXP (x28, 0);
  if (!rtx_equal_p (x52, operands[1]))
    return -1;
  x53 = XEXP (x33, 0);
  if (!rtx_equal_p (x53, operands[1]))
    return -1;
  x54 = XEXP (x39, 0);
  if (!rtx_equal_p (x54, operands[1]))
    return -1;
  x55 = XEXP (x44, 0);
  if (!rtx_equal_p (x55, operands[1]))
    return -1;
  return 0;
}

int
pattern1855 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !sext_operand (operands[2], i1)
      || pattern1854 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1862 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_int_operand (operands[6], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i2)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1
      || !ix86_carry_flag_operator (operands[5], i1))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  return pattern1857 (x11, 
i1); /* [-1, 0] */
}

int
pattern1872 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 24);
  if (XWINT (x2, 0) != 28L)
    return -1;
  x3 = XVECEXP (x1, 0, 25);
  if (XWINT (x3, 0) != 60L)
    return -1;
  x4 = XVECEXP (x1, 0, 26);
  if (XWINT (x4, 0) != 29L)
    return -1;
  x5 = XVECEXP (x1, 0, 27);
  if (XWINT (x5, 0) != 61L)
    return -1;
  x6 = XVECEXP (x1, 0, 28);
  if (XWINT (x6, 0) != 30L)
    return -1;
  x7 = XVECEXP (x1, 0, 29);
  if (XWINT (x7, 0) != 62L)
    return -1;
  x8 = XVECEXP (x1, 0, 30);
  if (XWINT (x8, 0) != 31L)
    return -1;
  x9 = XVECEXP (x1, 0, 31);
  if (XWINT (x9, 0) != 63L)
    return -1;
  return 0;
}

 int
recog_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], E_HImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x4) != E_CCFPmode)
    return -1;
  switch (GET_CODE (x4))
    {
    case COMPARE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      switch (GET_CODE (x6))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x6;
          switch (GET_MODE (operands[1]))
            {
            case E_XFmode:
              if (!register_operand (operands[1], E_XFmode)
                  || !reg_or_0_operand (operands[2], E_XFmode)
                  || !
#line 1936 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 35; /* *cmpxf_i387 */

            case E_SFmode:
              if (!register_operand (operands[1], E_SFmode)
                  || !nonimm_or_0_operand (operands[2], E_SFmode)
                  || !
#line 1949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 36; /* *cmpsf_i387 */

            case E_DFmode:
              if (!register_operand (operands[1], E_DFmode)
                  || !nonimm_or_0_operand (operands[2], E_DFmode)
                  || !
#line 1949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 37; /* *cmpdf_i387 */

            default:
              return -1;
            }

        case FLOAT:
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (GET_MODE (operands[1]))
            {
            case E_SFmode:
              switch (pattern1247 (x6, 
E_SFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 38; /* *cmpsf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 41; /* *cmpsf_si_i387 */

                default:
                  return -1;
                }

            case E_DFmode:
              switch (pattern1247 (x6, 
E_DFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 39; /* *cmpdf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 42; /* *cmpdf_si_i387 */

                default:
                  return -1;
                }

            case E_XFmode:
              switch (pattern1247 (x6, 
E_XFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 40; /* *cmpxf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 43; /* *cmpxf_si_i387 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 26)
        return -1;
      x8 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x8) != COMPARE
          || GET_MODE (x8) != E_CCFPmode)
        return -1;
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      x10 = XEXP (x8, 1);
      operands[2] = x10;
      switch (GET_MODE (operands[1]))
        {
        case E_SFmode:
          if (!register_operand (operands[1], E_SFmode)
              || !register_operand (operands[2], E_SFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 44; /* *cmpusf_i387 */

        case E_DFmode:
          if (!register_operand (operands[1], E_DFmode)
              || !register_operand (operands[2], E_DFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 45; /* *cmpudf_i387 */

        case E_XFmode:
          if (!register_operand (operands[1], E_XFmode)
              || !register_operand (operands[2], E_XFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 46; /* *cmpuxf_i387 */

        default:
          return -1;
        }

    case REG:
      if (REGNO (x4) != 18
          || !
#line 23896 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 1714; /* x86_fnstsw_1 */

    default:
      return -1;
    }
}

 int
recog_15 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V1TImode:
      if (!push_operand (operands[0], E_V1TImode)
          || !register_operand (operands[1], E_V1TImode))
        return -1;
      if ((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return 65; /* *pushv1ti2 */
      if (!(
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 66; /* *pushv1ti2 */

    case E_DImode:
      if (push_operand (operands[0], E_DImode)
          && general_no_elim_operand (operands[1], E_DImode))
        {
          if (
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 67; /* *pushdi2 */
          if (
#line 2206 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 69; /* *pushdi2_rex64 */
        }
      if (nonimmediate_operand (operands[0], E_DImode)
          && pop_operand (operands[1], E_DImode)
          && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
        return 77; /* *popdi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_DImode))
        {
          if (register_operand (operands[0], E_DImode)
              && (
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 85; /* *movdi_xor */
            }
          if (memory_operand (operands[0], E_DImode)
              && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 88; /* *movdi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_DImode)
          && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pnum_clobbers = 1;
          return 91; /* *movdi_or */
        }
      if (!general_operand (operands[1], E_DImode)
          || !
#line 2594 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 95; /* *movdi_internal */

    case E_TImode:
      if (push_operand (operands[0], E_TImode)
          && general_no_elim_operand (operands[1], E_TImode)
          && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return 68; /* *pushti2 */
      if (!nonimmediate_operand (operands[0], E_TImode)
          || !general_operand (operands[1], E_TImode)
          || !
#line 2510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT
    && !(MEM_P (operands[0]) && MEM_P (operands[1])))
   || (TARGET_SSE
       && nonimmediate_or_sse_const_operand (operands[1], TImode)
       && (register_operand (operands[0], TImode)
	   || register_operand (operands[1], TImode)))))
        return -1;
      return 94; /* *movti_internal */

    case E_SImode:
      if (push_operand (operands[0], E_SImode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SImode)
              && 
#line 2249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 70; /* *pushsi2_rex64 */
          if (general_no_elim_operand (operands[1], E_SImode)
              && 
#line 2259 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 71; /* *pushsi2 */
        }
      if (nonimmediate_operand (operands[0], E_SImode)
          && pop_operand (operands[1], E_SImode)
          && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
        return 76; /* *popsi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_SImode))
        {
          if (register_operand (operands[0], E_SImode)
              && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 84; /* *movsi_xor */
            }
          if (memory_operand (operands[0], E_SImode)
              && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 87; /* *movsi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_SImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_SImode)
          && 
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 90; /* *movsi_or */
        }
      if (!general_operand (operands[1], E_SImode)
          || !
#line 2834 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 96; /* *movsi_internal */

    case E_QImode:
      if (push_operand (operands[0], E_QImode)
          && nonmemory_no_elim_operand (operands[1], E_QImode))
        return 72; /* *pushqi2 */
      if (!nonimmediate_operand (operands[0], E_QImode)
          || !general_operand (operands[1], E_QImode)
          || !
#line 3156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 98; /* *movqi_internal */

    case E_HImode:
      if (push_operand (operands[0], E_HImode)
          && nonmemory_no_elim_operand (operands[1], E_HImode))
        return 73; /* *pushhi2 */
      if (pnum_clobbers != NULL
          && memory_operand (operands[0], E_HImode)
          && const0_operand (operands[1], E_HImode)
          && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 86; /* *movhi_and */
        }
      if (!nonimmediate_operand (operands[0], E_HImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_HImode)
          && 
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 89; /* *movhi_or */
        }
      if (!general_operand (operands[1], E_HImode)
          || !
#line 2993 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 97; /* *movhi_internal */

    case E_TFmode:
      if (push_operand (operands[0], E_TFmode)
          && general_no_elim_operand (operands[1], E_TFmode)
          && 
#line 3777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT || TARGET_SSE))
        return 152; /* *pushtf */
      if (!nonimmediate_operand (operands[0], E_TFmode)
          || !general_operand (operands[1], E_TFmode)
          || !
#line 4046 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT || TARGET_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || (standard_sse_constant_p (operands[1], TFmode) == 1
	   && !memory_operand (operands[0], TFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], TFmode)))))
        return -1;
      return 167; /* *movtf_internal */

    case E_XFmode:
      if (push_operand (operands[0], E_XFmode)
          && general_no_elim_operand (operands[1], E_XFmode))
        return 153; /* *pushxf */
      if (!nonimmediate_operand (operands[0], E_XFmode)
          || !general_operand (operands[1], E_XFmode)
          || !
#line 4106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], XFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], XFmode))
       || !TARGET_HARD_XF_REGS)))
        return -1;
      return 168; /* *movxf_internal */

    case E_DFmode:
      if (push_operand (operands[0], E_DFmode)
          && general_no_elim_operand (operands[1], E_DFmode))
        return 154; /* *pushdf */
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || !general_operand (operands[1], E_DFmode)
          || !
#line 4178 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (DFmode)
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], DFmode))
       || (TARGET_SSE2 && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], DFmode) == 1
	   && !memory_operand (operands[0], DFmode))
       || ((TARGET_64BIT || !TARGET_MEMORY_MISMATCH_STALL)
	   && memory_operand (operands[0], DFmode))
       || !TARGET_HARD_DF_REGS)))
        return -1;
      return 169; /* *movdf_internal */

    case E_HFmode:
      if (push_operand (operands[0], E_HFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3873 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 155; /* *pushhf_rex64 */
          if (general_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3886 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 157; /* *pushhf */
        }
      if (!nonimmediate_operand (operands[0], E_HFmode)
          || !general_operand (operands[1], E_HFmode)
          || !
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], HFmode) == 1)
      || memory_operand (operands[0], HFmode))))
        return -1;
      return 171; /* *movhf_internal */

    case E_BFmode:
      if (push_operand (operands[0], E_BFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3873 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 156; /* *pushbf_rex64 */
          if (general_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3886 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 158; /* *pushbf */
        }
      if (!nonimmediate_operand (operands[0], E_BFmode)
          || !general_operand (operands[1], E_BFmode)
          || !
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], BFmode) == 1)
      || memory_operand (operands[0], BFmode))))
        return -1;
      return 172; /* *movbf_internal */

    case E_SFmode:
      if (push_operand (operands[0], E_SFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3961 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 165; /* *pushsf_rex64 */
          if (general_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3975 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 166; /* *pushsf */
        }
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !general_operand (operands[1], E_SFmode)
          || !
#line 4355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (SFmode)
	   && standard_80387_constant_p (operands[1]) > 0)
       || (TARGET_SSE && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], SFmode) == 1)
       || memory_operand (operands[0], SFmode)
       || !TARGET_HARD_SF_REGS)))
        return -1;
      return 170; /* *movsf_internal */

    case E_V8QImode:
      if (nonimmediate_operand (operands[0], E_V8QImode)
          && nonimm_or_0_operand (operands[1], E_V8QImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2019; /* *movv8qi_internal */
      if (!memory_operand (operands[0], E_V8QImode)
          || !x86_64_const_vector_operand (operands[1], E_V8QImode)
          || !
#line 87 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2035; /* *movv8qi_imm */

    case E_V4HImode:
      if (nonimmediate_operand (operands[0], E_V4HImode)
          && nonimm_or_0_operand (operands[1], E_V4HImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2020; /* *movv4hi_internal */
      if (!memory_operand (operands[0], E_V4HImode)
          || !x86_64_const_vector_operand (operands[1], E_V4HImode)
          || !
#line 87 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2036; /* *movv4hi_imm */

    case E_V2SImode:
      if (nonimmediate_operand (operands[0], E_V2SImode)
          && nonimm_or_0_operand (operands[1], E_V2SImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2021; /* *movv2si_internal */
      if (!memory_operand (operands[0], E_V2SImode)
          || !x86_64_const_vector_operand (operands[1], E_V2SImode)
          || !
#line 89 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2039; /* *movv2si_imm */

    case E_V1DImode:
      if (!nonimmediate_operand (operands[0], E_V1DImode)
          || !nonimm_or_0_operand (operands[1], E_V1DImode)
          || !
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2022; /* *movv1di_internal */

    case E_V2SFmode:
      if (nonimmediate_operand (operands[0], E_V2SFmode)
          && nonimm_or_0_operand (operands[1], E_V2SFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2023; /* *movv2sf_internal */
      if (!memory_operand (operands[0], E_V2SFmode)
          || !x86_64_const_vector_operand (operands[1], E_V2SFmode)
          || !
#line 89 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2040; /* *movv2sf_imm */

    case E_V4HFmode:
      if (nonimmediate_operand (operands[0], E_V4HFmode)
          && nonimm_or_0_operand (operands[1], E_V4HFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2024; /* *movv4hf_internal */
      if (!memory_operand (operands[0], E_V4HFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4HFmode)
          || !
#line 88 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2037; /* *movv4hf_imm */

    case E_V4BFmode:
      if (nonimmediate_operand (operands[0], E_V4BFmode)
          && nonimm_or_0_operand (operands[1], E_V4BFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2025; /* *movv4bf_internal */
      if (!memory_operand (operands[0], E_V4BFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4BFmode)
          || !
#line 88 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2038; /* *movv4bf_imm */

    case E_V4QImode:
      if (nonimmediate_operand (operands[0], E_V4QImode)
          && general_operand (operands[1], E_V4QImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2026; /* *movv4qi_internal */
      if (memory_operand (operands[0], E_V4QImode)
          && x86_64_const_vector_operand (operands[1], E_V4QImode))
        return 2032; /* *movv4qi_imm */
      if (!push_operand (operands[0], E_V4QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V4QImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2041; /* *pushv4qi2_rex64 */

    case E_V2HImode:
      if (nonimmediate_operand (operands[0], E_V2HImode)
          && general_operand (operands[1], E_V2HImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2027; /* *movv2hi_internal */
      if (memory_operand (operands[0], E_V2HImode)
          && x86_64_const_vector_operand (operands[1], E_V2HImode))
        return 2033; /* *movv2hi_imm */
      if (!push_operand (operands[0], E_V2HImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2042; /* *pushv2hi2_rex64 */

    case E_V1SImode:
      if (nonimmediate_operand (operands[0], E_V1SImode)
          && general_operand (operands[1], E_V1SImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2028; /* *movv1si_internal */
      if (!push_operand (operands[0], E_V1SImode)
          || !nonmemory_no_elim_operand (operands[1], E_V1SImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2043; /* *pushv1si2_rex64 */

    case E_V2HFmode:
      if (nonimmediate_operand (operands[0], E_V2HFmode)
          && general_operand (operands[1], E_V2HFmode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2029; /* *movv2hf_internal */
      if (memory_operand (operands[0], E_V2HFmode)
          && x86_64_const_vector_operand (operands[1], E_V2HFmode))
        return 2034; /* *movv2hf_imm */
      if (!push_operand (operands[0], E_V2HFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HFmode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2044; /* *pushv2hf2_rex64 */

    case E_V2BFmode:
      if (nonimmediate_operand (operands[0], E_V2BFmode)
          && general_operand (operands[1], E_V2BFmode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2030; /* *movv2bf_internal */
      if (!push_operand (operands[0], E_V2BFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2BFmode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2045; /* *pushv2bf2_rex64 */

    case E_V2QImode:
      if (memory_operand (operands[0], E_V2QImode)
          && x86_64_const_vector_operand (operands[1], E_V2QImode))
        return 2031; /* *movv2qi_imm */
      if (nonimmediate_operand (operands[0], E_V2QImode)
          && general_operand (operands[1], E_V2QImode)
          && 
#line 472 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return 2046; /* *movv2qi_internal */
      if (!push_operand (operands[0], E_V2QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2QImode))
        return -1;
      return 2047; /* *pushv2qi2 */

    case E_P2QImode:
      if (!nonimmediate_operand (operands[0], E_P2QImode)
          || !nonimmediate_operand (operands[1], E_P2QImode)
          || !
#line 30964 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10256; /* *movp2qi_internal */

    case E_P2HImode:
      if (!nonimmediate_operand (operands[0], E_P2HImode)
          || !nonimmediate_operand (operands[1], E_P2HImode)
          || !
#line 30964 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10257; /* *movp2hi_internal */

    default:
      return -1;
    }
}

 int
recog_29 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (GET_MODE (x3) != E_SFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_SFmode)
          && register_ssemem_operand (operands[1], E_DFmode)
          && 
#line 5542 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 206; /* truncdfsf2 */
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 207; /* truncxfsf2 */

    case E_DFmode:
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || GET_MODE (x3) != E_DFmode
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 208; /* truncxfdf2 */

    case E_HFmode:
      if (!register_operand (operands[0], E_HFmode))
        return -1;
      switch (pattern425 (x3, 
E_HFmode))
        {
        case 0:
          if (!
#line 5711 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 209; /* *truncsfhf2 */

        case 1:
          if (!
#line 5711 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 210; /* *truncdfhf2 */

        default:
          return -1;
        }

    case E_BFmode:
      if (!register_operand (operands[0], E_BFmode)
          || GET_MODE (x3) != E_BFmode
          || !register_operand (operands[1], E_SFmode)
          || !
#line 5727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2 && !HONOR_NANS (BFmode) && !flag_rounding_math
   && (flag_unsafe_math_optimizations
       || TARGET_AVXNECONVERT
       || (TARGET_AVX512BF16 && TARGET_AVX512VL))))
        return -1;
      return 211; /* truncsfbf2 */

    case E_V2SFmode:
      if (!register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 10138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MMX_WITH_SSE))
        return -1;
      return 5088; /* truncv2dfv2sf2 */

    default:
      return -1;
    }
}

 int
recog_34 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 12515 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 704; /* *andti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 719; /* *andhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 720; /* *andhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 12723 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 723; /* *andqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12723 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 724; /* *andqi_1 */

        case E_V2SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2SFmode) != 0
              || !
#line 1357 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
            return -1;
          return 2077; /* andv2sf3 */

        case E_V2BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2BFmode) != 0
              || !
#line 2582 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2111; /* andv2bf3 */

        case E_V4BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4BFmode) != 0
              || !(
#line 2582 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2224 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2114; /* andv4bf3 */

        case E_V2HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HFmode) != 0
              || !
#line 2582 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2117; /* andv2hf3 */

        case E_V4HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4HFmode) != 0
              || !(
#line 2582 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2120; /* andv4hf3 */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 4687 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V8QImode, operands)))
            return -1;
          return 2274; /* *mmx_andv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 4687 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V4HImode, operands)))
            return -1;
          return 2277; /* *mmx_andv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 4687 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V2SImode, operands)))
            return -1;
          return 2280; /* *mmx_andv2si3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0
              || !
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V4QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2283; /* *andv4qi3 */

        case E_V2QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0
              || !
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2286; /* *andv2qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0
              || !
#line 4713 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2HImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2289; /* *andv2hi3 */

        case E_BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_BFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3745; /* andbf3 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_HFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3748; /* andhf3 */

        case E_SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_SFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3751; /* andsf3 */

        case E_DFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_DFmode) != 0
              || !(
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1352 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2)))
            return -1;
          return 3754; /* anddf3 */

        case E_TFmode:
          x2 = XEXP (x1, 1);
          if (pattern25 (x2, 
E_TFmode) != 0
              || !
#line 5740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 3757; /* *andtf3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 725; /* *andqi_1_slp */

    case 2:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 728; /* *andhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_41 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          if (pnum_clobbers != NULL
              && GET_CODE (x4) == SUBREG
              && pattern423 (x1, 
E_TImode) == 0
              && (
#line 15217 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1053; /* *ashlti3_doubleword_mask */
            }
          operands[2] = x4;
          switch (pattern258 (x1, pnum_clobbers))
            {
            case 0:
              switch (GET_MODE (operands[0]))
                {
                case E_TImode:
                  if (pnum_clobbers == NULL
                      || !register_operand (operands[0], E_TImode)
                      || GET_MODE (x2) != E_TImode
                      || !reg_or_pm1_operand (operands[1], E_TImode)
                      || !nonmemory_operand (operands[2], E_QImode)
                      || !
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1057; /* ashlti3_doubleword */

                case E_HImode:
                  if (pattern619 (x2, 
E_HImode) != 0)
                    return -1;
                  if (
#line 16109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1104; /* *ashlhi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1105; /* *ashlhi3_1 */

                case E_QImode:
                  if (pattern619 (x2, 
E_QImode) != 0)
                    return -1;
                  if (
#line 16168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1106; /* *ashlqi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1107; /* *ashlqi3_1 */

                case E_V4HImode:
                  if (pattern734 (x2, 
E_V4HImode, 
E_DImode) != 0
                      || !
#line 3891 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2202; /* mmx_ashlv4hi3 */

                case E_V2SImode:
                  if (pattern734 (x2, 
E_V2SImode, 
E_DImode) != 0
                      || !
#line 3891 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2204; /* mmx_ashlv2si3 */

                case E_V1DImode:
                  if (pattern734 (x2, 
E_V1DImode, 
E_DImode) != 0
                      || !
#line 3891 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2206; /* mmx_ashlv1di3 */

                case E_V1SImode:
                  if (pattern734 (x2, 
E_V1SImode, 
E_DImode) != 0
                      || !
#line 3928 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2208; /* mmx_ashlv1si3 */

                case E_V2HImode:
                  if (pattern734 (x2, 
E_V2HImode, 
E_DImode) != 0
                      || !
#line 3945 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2210; /* ashlv2hi3 */

                case E_V2QImode:
                  if (pnum_clobbers == NULL
                      || pattern734 (x2, 
E_V2QImode, 
E_QImode) != 0
                      || !
#line 4007 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
                    return -1;
                  *pnum_clobbers = 1;
                  return 2214; /* ashlv2qi3 */

                default:
                  return -1;
                }

            case 1:
              if (!
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1108; /* *ashlqi3_1_slp */

            case 2:
              if (!
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1109; /* *ashlhi3_1_slp */

            default:
              return -1;
            }

        case AND:
          if (pattern0 (x1, pnum_clobbers) != 0
              || !(
#line 15278 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1055; /* *ashlti3_doubleword_mask_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1060; /* *ashlti3_doubleword_highpart */

    case ZERO_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1061; /* *ashlti3_doubleword_highpart */

    default:
      return -1;
    }
}

 int
recog_47 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
      res = recog_46 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  operands[3] = x3;
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (pattern740 (
E_SFmode) != 0
          || !
#line 19708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)))
        return -1;
      return 1455; /* setcc_sf_sse */

    case E_DFmode:
      if (pattern740 (
E_DFmode) != 0
          || !
#line 19708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)))
        return -1;
      return 1456; /* setcc_df_sse */

    default:
      return -1;
    }
}

 int
recog_51 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 267; /* *addti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 297; /* *addhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 298; /* *addhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 299; /* *addqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 300; /* *addqi_1 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern5 (x2, 
E_HFmode) != 0
              || !
#line 23483 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 1676; /* *addhf */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 3211 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V8QImode, operands)))
            return -1;
          return 2124; /* *mmx_addv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 3211 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V4HImode, operands)))
            return -1;
          return 2126; /* *mmx_addv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 3211 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V2SImode, operands)))
            return -1;
          return 2128; /* *mmx_addv2si3 */

        case E_V1DImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V1DImode) != 0
              || !(
#line 3211 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V1DImode, operands)) && 
#line 50 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2)))
            return -1;
          return 2130; /* *mmx_addv1di3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4QImode) != 0
              || !
#line 3227 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2132; /* addv4qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HImode) != 0
              || !
#line 3227 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2134; /* addv2hi3 */

        case E_V2QImode:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2QImode) != 0
              || !
#line 3241 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
            return -1;
          *pnum_clobbers = 1;
          return 2136; /* addv2qi3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 301; /* *addqi_1_slp */

    case 2:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 302; /* *addhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_59 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern95 (x3, 
E_V2SFmode, 
E_SFmode) != 0)
        return -1;
      x5 = XEXP (x3, 1);
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_V2SFmode)
          || pattern1832 (x3) != 0
          || !
#line 995 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW
   && INTVAL (operands[3]) != INTVAL (operands[4])
   && INTVAL (operands[5]) != INTVAL (operands[6])))
        return -1;
      return 2064; /* *mmx_haddv2sf3 */

    case MINUS:
      if (pattern96 (x4, 
E_SFmode) != 0
          || !register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode)
        return -1;
      x8 = XEXP (x4, 0);
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V2SFmode))
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_MODE (x5) != E_SFmode)
        return -1;
      x10 = XEXP (x4, 1);
      x11 = XEXP (x10, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_CODE (x5))
        {
        case MINUS:
          if (pattern1536 (x5, 
E_SFmode) != 0)
            return -1;
          x6 = XEXP (x5, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x12 = XEXP (x5, 1);
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1043 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A))
            return -1;
          return 2066; /* mmx_hsubv2sf3 */

        case PLUS:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != VEC_SELECT
              || GET_MODE (x6) != E_SFmode)
            return -1;
          x14 = XEXP (x6, 1);
          if (GET_CODE (x14) != PARALLEL
              || XVECLEN (x14, 0) != 1)
            return -1;
          x12 = XEXP (x5, 1);
          if (GET_CODE (x12) != VEC_SELECT
              || GET_MODE (x12) != E_SFmode)
            return -1;
          x15 = XEXP (x12, 1);
          if (GET_CODE (x15) != PARALLEL
              || XVECLEN (x15, 0) != 1)
            return -1;
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x16 = XVECEXP (x14, 0, 0);
          operands[3] = x16;
          if (!const_0_to_1_operand (operands[3], E_SImode))
            return -1;
          x17 = XVECEXP (x15, 0, 0);
          operands[4] = x17;
          if (!const_0_to_1_operand (operands[4], E_SImode))
            return -1;
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1105 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A
   && INTVAL (operands[3]) != INTVAL (operands[4])))
            return -1;
          return 2068; /* *mmx_haddsubv2sf3 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V2SFmode:
          if (!register_operand (operands[0], E_V2SFmode)
              || GET_MODE (x3) != E_V2SFmode
              || !nonimmediate_operand (operands[1], E_SFmode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SFmode))
            {
              if (
#line 1755 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2092; /* *mmx_concatv2sf */
              if (
#line 11739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 5190; /* *vec_concatv2sf_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SFmode)
              || !
#line 11803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 5191; /* *vec_concatv2sf_sse */

        case E_V2SImode:
          if (!register_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SImode))
            {
              if (
#line 5701 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2348; /* *mmx_concatv2si */
              if (
#line 21493 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 8406; /* *vec_concatv2si_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SImode)
              || !
#line 21542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !TARGET_SSE4_1))
            return -1;
          return 8407; /* *vec_concatv2si */

        default:
          return -1;
        }

    case SS_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SS_TRUNCATE)
        return -1;
      switch (pattern272 (x3))
        {
        case 0:
          if (!
#line 4771 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2292; /* mmx_packsswb */

        case 1:
          if (!
#line 4812 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2294; /* mmx_packssdw */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_65 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case LSHIFTRT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MULT:
          if (XWINT (x5, 0) != 16L)
            return -1;
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case SIGN_EXTEND:
              switch (pattern744 (x3, 
SIGN_EXTEND))
                {
                case 0:
                  if (!
#line 3447 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2161; /* *mmx_smulv4hi3_highpart */

                case 1:
                  if (!
#line 3516 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2163; /* smulv2hi3_highpart */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              switch (pattern744 (x3, 
ZERO_EXTEND))
                {
                case 0:
                  if (!
#line 3482 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2162; /* *mmx_umulv4hi3_highpart */

                case 1:
                  if (!
#line 3516 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2164; /* umulv2hi3_highpart */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PLUS:
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case MULT:
              if (GET_MODE (x7) != E_V4SImode)
                return -1;
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != SIGN_EXTEND
                  || GET_MODE (x8) != E_V4SImode)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != SIGN_EXTEND
                  || GET_MODE (x9) != E_V4SImode)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XVECLEN (x10, 0) != 4
                  || GET_MODE (x10) != E_V4SImode)
                return -1;
              x11 = XVECEXP (x10, 0, 0);
              if (GET_CODE (x11) != CONST_INT
                  || XWINT (x11, 0) != 32768L)
                return -1;
              x12 = XVECEXP (x10, 0, 1);
              if (GET_CODE (x12) != CONST_INT
                  || XWINT (x12, 0) != 32768L)
                return -1;
              x13 = XVECEXP (x10, 0, 2);
              if (GET_CODE (x13) != CONST_INT
                  || XWINT (x13, 0) != 32768L)
                return -1;
              x14 = XVECEXP (x10, 0, 3);
              if (GET_CODE (x14) != CONST_INT
                  || XWINT (x14, 0) != 32768L
                  || XWINT (x5, 0) != 16L
                  || !register_operand (operands[0], E_V4HImode)
                  || GET_MODE (x3) != E_V4HImode
                  || GET_MODE (x4) != E_V4SImode
                  || GET_MODE (x6) != E_V4SImode)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              if (!nonimmediate_operand (operands[1], E_V4HImode))
                return -1;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              if (!nonimmediate_operand (operands[2], E_V4HImode)
                  || !
#line 3605 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                return -1;
              return 2166; /* *mmx_pmulhrwv4hi3 */

            case PLUS:
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != ZERO_EXTEND)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XWINT (x5, 0) != 1L)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              switch (XVECLEN (x10, 0))
                {
                case 8:
                  if (pattern1346 (x10, 
E_V8HImode) != 0
                      || pattern1616 (x3, 
E_V8QImode, 
E_V8HImode) != 0
                      || !
#line 6332 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 2378; /* *mmx_uavgv8qi3 */

                case 4:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x13 = XVECEXP (x10, 0, 2);
                  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x14 = XVECEXP (x10, 0, 3);
                  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V4HImode:
                      if (pattern1616 (x3, 
E_V4HImode, 
E_V4SImode) != 0
                          || GET_MODE (x10) != E_V4SImode
                          || !
#line 6376 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                        return -1;
                      return 2379; /* *mmx_uavgv4hi3 */

                    case E_V4QImode:
                      if (pattern1519 (x3, 
E_V4HImode, 
E_V4QImode) != 0
                          || !
#line 6416 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2380; /* uavgv4qi3_ceil */

                    default:
                      return -1;
                    }

                case 2:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V2QImode:
                      if (pattern1519 (x3, 
E_V2HImode, 
E_V2QImode) != 0
                          || !
#line 6436 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2381; /* uavgv2qi3_ceil */

                    case E_V2HImode:
                      if (pattern1519 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                          || !
#line 6456 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2382; /* uavgv2hi3_ceil */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case LSHIFTRT:
              if (pattern612 (x7) != 0
                  || XWINT (x5, 0) != 1L)
                return -1;
              x8 = XEXP (x7, 0);
              x15 = XEXP (x8, 0);
              x17 = XEXP (x15, 0);
              operands[1] = x17;
              x18 = XEXP (x8, 1);
              x19 = XEXP (x18, 0);
              operands[2] = x19;
              x10 = XEXP (x6, 1);
              operands[3] = x10;
              switch (GET_MODE (operands[0]))
                {
                case E_V4HImode:
                  if (pattern1496 (x3, 
E_V4SImode, 
E_V4HImode) != 0
                      || !register_mmxmem_operand (operands[1], E_V4HImode)
                      || GET_MODE (x18) != E_V4SImode
                      || !register_mmxmem_operand (operands[2], E_V4HImode)
                      || !const1_operand (operands[3], E_V4HImode)
                      || !
#line 23058 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8549; /* *ssse3_pmulhrswv4hi3 */

                case E_V2HImode:
                  if (pattern1496 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                      || !register_operand (operands[1], E_V2HImode)
                      || GET_MODE (x18) != E_V2SImode
                      || !register_operand (operands[2], E_V2HImode)
                      || !const1_operand (operands[3], E_V2HImode)
                      || !
#line 23103 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8550; /* *smulhrsv2hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V4QImode:
          if (GET_MODE (x3) != E_V4QImode)
            return -1;
          if (register_operand (operands[0], E_V4QImode)
              && register_operand (operands[1], E_V4HImode)
              && (
#line 5144 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW) && 
#line 73 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return 2312; /* avx512vl_truncv4hiv4qi2 */
          if (!memory_operand (operands[0], E_V4QImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7238; /* *avx512vl_truncatev4siv4qi2_store_1 */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7241; /* *avx512vl_truncatev4div4qi2_store_1 */

            default:
              return -1;
            }

        case E_V2QImode:
          if (GET_MODE (x3) != E_V2QImode)
            return -1;
          if (register_operand (operands[0], E_V2QImode))
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V2HImode:
                  if (register_operand (operands[1], E_V2HImode)
                      && 
#line 5144 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW))
                    return 2313; /* avx512vl_truncv2hiv2qi2 */
                  break;

                case E_V2SImode:
                  if (register_operand (operands[1], E_V2SImode)
                      && 
#line 5170 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
                    return 2314; /* avx512vl_truncv2siv2qi2 */
                  break;

                default:
                  break;
                }
            }
          if (!memory_operand (operands[0], E_V2QImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7223; /* *avx512vl_truncatev2div2qi2_store_1 */

        case E_V2HImode:
          if (GET_MODE (x3) != E_V2HImode)
            return -1;
          if (register_operand (operands[0], E_V2HImode)
              && register_operand (operands[1], E_V2SImode)
              && 
#line 5170 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
            return 2315; /* avx512vl_truncv2siv2hi2 */
          if (!memory_operand (operands[0], E_V2HImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7338; /* *avx512vl_truncatev2div2hi2_store_1 */

        case E_V8QImode:
          switch (pattern12 (x3))
            {
            case 0:
              if (!(
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 7268; /* *avx512vl_truncatev8hiv8qi2_store_1 */

            case 1:
              if (!
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7271; /* *avx512vl_truncatev8siv8qi2_store_1 */

            case 2:
              if (!
#line 16095 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 7375; /* *avx512f_truncatev8div16qi2_store_1 */

            default:
              return -1;
            }

        case E_V4HImode:
          switch (pattern11 (x3, 
E_V4HImode))
            {
            case 0:
              if (!
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7308; /* *avx512vl_truncatev4siv4hi2_store_1 */

            case 1:
              if (!
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7311; /* *avx512vl_truncatev4div4hi2_store_1 */

            default:
              return -1;
            }

        case E_V2SImode:
          if (!memory_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7357; /* *avx512vl_truncatev2div2si2_store_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_75 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      return recog_70 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_72 (x1, insn, pnum_clobbers);

    case MULT:
      return recog_74 (x1, insn, pnum_clobbers);

    case SMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 631; /* *smulsi3_highpart_zext */

    case UMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 632; /* *umulsi3_highpart_zext */

    case TRUNCATE:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != LSHIFTRT
          || GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MULT
          || GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 32]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_MODE (x8) != E_DImode)
        return -1;
      x9 = XEXP (x6, 1);
      if (GET_MODE (x9) != E_DImode)
        return -1;
      switch (GET_CODE (x8))
        {
        case SIGN_EXTEND:
          if (GET_CODE (x9) != SIGN_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 635; /* *smulsi3_highpart_zext */

        case ZERO_EXTEND:
          if (GET_CODE (x9) != ZERO_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 636; /* *umulsi3_highpart_zext */

        default:
          return -1;
        }

    case AND:
      return recog_71 (x1, insn, pnum_clobbers);

    case IOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 847; /* *iorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 848; /* *iorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 855; /* *iorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 856; /* *iorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 851; /* *iorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 852; /* *iorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 859; /* *iorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 860; /* *iorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 863; /* *iorsi_1_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 849; /* *xorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 850; /* *xorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 857; /* *xorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 858; /* *xorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 853; /* *xorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 854; /* *xorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 861; /* *xorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 862; /* *xorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 864; /* *xorsi_1_zext */

        default:
          return -1;
        }

    case NEG:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern283 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 964; /* *negqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 965; /* *negqi_1_zextsi */

        case 1:
          if (
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 968; /* *neghi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 969; /* *neghi_1_zextsi */

        case 2:
          if (
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 966; /* *negqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 967; /* *negqi_1_zextdi */

        case 3:
          if (
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 970; /* *neghi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 971; /* *neghi_1_zextdi */

        case 4:
          if (!
#line 14395 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 972; /* *negsi_1_zext */

        default:
          return -1;
        }

    case NOT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern282 (x3))
            {
            case 0:
              if (!
#line 15016 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1036; /* *one_cmplqi2_1_zextsi */

            case 1:
              if (!
#line 15025 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1038; /* *one_cmplhi2_1_zextsi */

            default:
              return -1;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15016 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1037; /* *one_cmplqi2_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15025 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1039; /* *one_cmplhi2_1_zextdi */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 15034 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NOT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1040; /* *one_cmplsi2_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ASHIFT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 16012 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1092; /* *bmi2_ashlsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 16045 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1103; /* *ashlsi3_1_zext */

        case 1:
          if (
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1097; /* *ashlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1098; /* *ashlqi3_1_zextdi */

        case 2:
          if (
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1101; /* *ashlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1102; /* *ashlhi3_1_zextdi */

        case 3:
          if (
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1095; /* *ashlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1096; /* *ashlqi3_1_zextsi */

        case 4:
          if (
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1099; /* *ashlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1100; /* *ashlhi3_1_zextsi */

        default:
          return -1;
        }

    case ASHIFTRT:
      if (GET_MODE (x4) == E_SImode
          && register_operand (operands[0], E_DImode))
        {
          res = recog_68 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
        }
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1192; /* *ashrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1193; /* *ashrqi3_1_zextsi */

        case 1:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1200; /* *ashrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1201; /* *ashrhi3_1_zextsi */

        case 2:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1196; /* *ashrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1197; /* *ashrqi3_1_zextdi */

        case 3:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1204; /* *ashrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1205; /* *ashrhi3_1_zextdi */

        case 4:
          if (!
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1207; /* *ashrsi3_1_zext */

        default:
          return -1;
        }

    case LSHIFTRT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 17459 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1184; /* *bmi2_lshrsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1206; /* *lshrsi3_1_zext */

        case 1:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1194; /* *lshrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1195; /* *lshrqi3_1_zextdi */

        case 2:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1202; /* *lshrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1203; /* *lshrhi3_1_zextdi */

        case 3:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1190; /* *lshrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1191; /* *lshrqi3_1_zextsi */

        case 4:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1198; /* *lshrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1199; /* *lshrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern109 (x3))
        {
        case 0:
          if (const_0_to_31_operand (operands[2], E_QImode)
              && 
#line 18592 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
            return 1350; /* *bmi2_rorxsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1372; /* *rotrsi3_1_zext */

        case 1:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1361; /* *rotrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1362; /* *rotrqi3_1_zextdi */

        case 2:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1369; /* *rotrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1370; /* *rotrhi3_1_zextdi */

        case 3:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1357; /* *rotrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1358; /* *rotrqi3_1_zextsi */

        case 4:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1365; /* *rotrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1366; /* *rotrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1355; /* *rotlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1356; /* *rotlqi3_1_zextsi */

        case 1:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1363; /* *rotlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1364; /* *rotlhi3_1_zextsi */

        case 2:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1359; /* *rotlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1360; /* *rotlqi3_1_zextdi */

        case 3:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1367; /* *rotlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1368; /* *rotlhi3_1_zextdi */

        case 4:
          if (!
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1371; /* *rotlsi3_1_zext */

        default:
          return -1;
        }

    case CTZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21193 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1521; /* *ctzsidi2_uext */

    case CLZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21628 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1543; /* *clzsi2_lzcnt_zext_2 */

    case POPCOUNT:
      if (pnum_clobbers == NULL)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern613 (x3, 
E_DImode, 
E_SImode) != 0
              || !
#line 22465 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1634; /* *popcountsi2_zext_2 */

        case E_SImode:
          if (pattern613 (x3, 
E_SImode, 
E_HImode) != 0
              || !
#line 22531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1637; /* *popcounthi2_2 */

        default:
          return -1;
        }

    case UNSPEC:
      return recog_69 (x1, insn, pnum_clobbers);

    case IF_THEN_ELSE:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (!ix86_comparison_operator (x5, E_VOIDmode))
        return -1;
      operands[1] = x5;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x12 = XEXP (x4, 1);
      operands[2] = x12;
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      x13 = XEXP (x4, 2);
      operands[3] = x13;
      if (!nonimmediate_operand (operands[3], E_SImode)
          || !
#line 26393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 1807; /* *movsicc_noc_zext_1 */

    case VEC_SELECT:
      return recog_73 (x1, insn, pnum_clobbers);

    case SUBREG:
      if (pattern111 (x3) != 0
          || !
#line 22139 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
        return -1;
      return 8488; /* *sse2_pmovskb_zexthisi */

    default:
      return -1;
    }
}

 int
recog_102 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (pattern20 (x1, pnum_clobbers))
    {
    case 0:
      if (!
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1297; /* *rotrsi3_mask_1 */

    case 1:
      if (!(
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1299; /* *rotrdi3_mask_1 */

    case 2:
      if (!
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1313; /* *rotrsi3_add_1 */

    case 3:
      if (!(
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1315; /* *rotrdi3_add_1 */

    case 4:
      if (!
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1329; /* *rotrsi3_sub_1 */

    case 5:
      if (!(
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1331; /* *rotrdi3_sub_1 */

    case 6:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case SUBREG:
          switch (pattern450 (x2, pnum_clobbers))
            {
            case 0:
              if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1289; /* *rotrsi3_mask */
                }
              break;

            case 1:
              if ((
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1291; /* *rotrdi3_mask */
                }
              break;

            case 2:
              if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1305; /* *rotrsi3_add */
                }
              break;

            case 3:
              if ((
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1307; /* *rotrdi3_add */
                }
              break;

            case 4:
              if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1321; /* *rotrsi3_sub */
                }
              break;

            case 5:
              if ((
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1323; /* *rotrdi3_sub */
                }
              break;

            default:
              break;
            }
          break;

        case CONST_INT:
          operands[2] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern609 (x2, pnum_clobbers, 
E_DImode) == 0
                  && const_1_to_31_operand (operands[2], E_QImode)
                  && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                {
                  *pnum_clobbers = 2;
                  return 1334; /* ix86_rotrdi3_doubleword */
                }
              break;

            case E_SImode:
              if (register_operand (operands[0], E_SImode)
                  && GET_MODE (x2) == E_SImode
                  && nonimmediate_operand (operands[1], E_SImode)
                  && const_0_to_31_operand (operands[2], E_QImode)
                  && 
#line 18500 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
                return 1340; /* *bmi2_rorxsi3_1 */
              break;

            default:
              break;
            }
          if (register_operand (operands[0], E_DImode)
              && GET_MODE (x2) == E_DImode)
            {
              if (XWINT (x3, 0) == 32L
                  && register_operand (operands[1], E_DImode)
                  && 
#line 18459 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return 1337; /* rotr32di2_doubleword */
              if (nonimmediate_operand (operands[1], E_DImode))
                {
                  operands[2] = x3;
                  if (const_0_to_63_operand (operands[2], E_QImode)
                      && (
#line 18500 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1341; /* *bmi2_rorxdi3_1 */
                }
            }
          break;

        default:
          break;
        }
      operands[2] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (pattern16 (x2))
        {
        case 0:
          if (
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 1344; /* *rotrsi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 1345; /* *rotrsi3_1 */

        case 1:
          if ((
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1348; /* *rotrdi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1349; /* *rotrdi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_113 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (pattern126 (x3))
    {
    case 0:
      if (
#line 21517 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT))
        return 1532; /* clzsi2_lzcnt_nf */
      if (pnum_clobbers == NULL
          || !
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
        return -1;
      *pnum_clobbers = 1;
      return 1534; /* clzsi2_lzcnt */

    case 1:
      if ((
#line 21517 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1533; /* clzdi2_lzcnt_nf */
      if (pnum_clobbers == NULL
          || !(
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1535; /* clzdi2_lzcnt */

    default:
      return -1;
    }
}

 int
recog_116 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      switch (XINT (x3, 1))
        {
        case 2:
          if (pnum_clobbers == NULL)
            return -1;
          switch (pattern304 (x3))
            {
            case 0:
              if (!(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              *pnum_clobbers = 1;
              return 1859; /* allocate_stack_worker_probe_si */

            case 1:
              if (!(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              *pnum_clobbers = 1;
              return 1860; /* allocate_stack_worker_probe_di */

            default:
              return -1;
            }

        case 11:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1895; /* rdpmc */

        case 9:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_DImode)
              || !
#line 29126 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1897; /* rdtsc */

        case 36:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29350 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1925; /* xgetbv */

        case 13:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!(
#line 29444 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1933; /* lwp_slwpcbsi */

            case 1:
              if (!(
#line 29444 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1934; /* lwp_slwpcbdi */

            default:
              return -1;
            }

        case 16:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1939; /* rdfsbasesi */

            case 1:
              if (!(
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1941; /* rdfsbasedi */

            default:
              return -1;
            }

        case 17:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1940; /* rdgsbasesi */

            case 1:
              if (!(
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1942; /* rdgsbasedi */

            default:
              return -1;
            }

        case 59:
          switch (pattern304 (x3))
            {
            case 0:
              if (!
#line 29560 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)))
                return -1;
              return 1956; /* rdsspsi */

            case 1:
              if (!(
#line 29560 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1957; /* rdsspdi */

            default:
              return -1;
            }

        case 57:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29800 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_RDPID))
                return -1;
              return 1982; /* rdpid */

            case 1:
              if (!
#line 29807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_RDPID))
                return -1;
              return 1983; /* rdpid_rex64 */

            default:
              return -1;
            }

        case 85:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!x86_64_szext_nonmemory_operand (operands[1], E_DImode)
              || !
#line 30083 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USER_MSR && TARGET_64BIT))
            return -1;
          return 2011; /* urdmsr */

        case 89:
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !memory_operand (operands[1], E_SImode)
                  || !
#line 30121 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVRS && TARGET_64BIT))
                return -1;
              return 2017; /* movrssi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !memory_operand (operands[1], E_DImode)
                  || !
#line 30121 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVRS && TARGET_64BIT))
                return -1;
              return 2018; /* movrsdi */

            default:
              return -1;
            }

        case 93:
          if (GET_MODE (x3) != E_SImode)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !memory_operand (operands[0], E_SImode)
              || !
#line 22498 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 8509; /* sse_stmxcsr */

        default:
          return -1;
        }

    case 2:
      switch (XINT (x3, 1))
        {
        case 3:
          if (pnum_clobbers == NULL)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          x5 = XVECEXP (x3, 0, 1);
          operands[2] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern873 (x3, 
E_SImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
                return -1;
              *pnum_clobbers = 1;
              return 1865; /* probe_stack_range_si */

            case E_DImode:
              if (pattern873 (x3, 
E_DImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
                return -1;
              *pnum_clobbers = 1;
              return 1866; /* probe_stack_range_di */

            default:
              return -1;
            }

        case 113:
          x5 = XVECEXP (x3, 0, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case AND:
              switch (pattern621 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10934; /* rao_aandsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10938; /* rao_aanddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern621 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10935; /* rao_aorsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10939; /* rao_aordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern621 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10936; /* rao_axorsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10940; /* rao_axordi */

                default:
                  return -1;
                }

            case PLUS:
              switch (pattern621 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10937; /* rao_aaddsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10941; /* rao_aadddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 111:
          if (pnum_clobbers == NULL)
            return -1;
          x5 = XVECEXP (x3, 0, 1);
          operands[2] = x5;
          if (!const_int_operand (operands[2], E_SImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case PLUS:
              switch (pattern874 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10944; /* atomic_addsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10945; /* atomic_adddi */

                default:
                  return -1;
                }

            case MINUS:
              switch (pattern874 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10948; /* atomic_subsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10949; /* atomic_subdi */

                default:
                  return -1;
                }

            case AND:
              switch (pattern874 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10956; /* atomic_andsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10959; /* atomic_anddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern874 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10957; /* atomic_orsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10960; /* atomic_ordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern874 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10958; /* atomic_xorsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10961; /* atomic_xordi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_130 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_15_operand (operands[2], E_SImode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (pattern468 (x2, 
E_V32HFmode, 
E_SImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 9934; /* avx512bw_getmantv32hf_mask */

    case E_V16HFmode:
      if (pattern468 (x2, 
E_V16HFmode, 
E_HImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 9938; /* avx512vl_getmantv16hf_mask */

    case E_V8HFmode:
      if (pattern468 (x2, 
E_V8HFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 9942; /* avx512fp16_getmantv8hf_mask */

    case E_V16SFmode:
      if (pattern468 (x2, 
E_V16SFmode, 
E_HImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9946; /* avx512f_getmantv16sf_mask */

    case E_V8SFmode:
      if (pattern468 (x2, 
E_V8SFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9950; /* avx512vl_getmantv8sf_mask */

    case E_V4SFmode:
      if (pattern468 (x2, 
E_V4SFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9954; /* avx512vl_getmantv4sf_mask */

    case E_V8DFmode:
      if (pattern468 (x2, 
E_V8DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9958; /* avx512f_getmantv8df_mask */

    case E_V4DFmode:
      if (pattern468 (x2, 
E_V4DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9962; /* avx512vl_getmantv4df_mask */

    case E_V2DFmode:
      if (pattern468 (x2, 
E_V2DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9966; /* avx512vl_getmantv2df_mask */

    default:
      return -1;
    }
}

 int
recog_135 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern483 (x2))
    {
    case 0:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10154; /* vpshrdv_v32hi_mask */

    case 1:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10155; /* vpshrdv_v16si_mask */

    case 2:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10156; /* vpshrdv_v8di_mask */

    case 3:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10157; /* vpshrdv_v16hi_mask */

    case 4:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10158; /* vpshrdv_v8si_mask */

    case 5:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10159; /* vpshrdv_v4di_mask */

    case 6:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10160; /* vpshrdv_v8hi_mask */

    case 7:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10161; /* vpshrdv_v4si_mask */

    case 8:
      if (!(
#line 30436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10162; /* vpshrdv_v2di_mask */

    case 9:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10163; /* vpshrdv_v32hi_maskz_1 */

    case 10:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10164; /* vpshrdv_v16si_maskz_1 */

    case 11:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10165; /* vpshrdv_v8di_maskz_1 */

    case 12:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10166; /* vpshrdv_v16hi_maskz_1 */

    case 13:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10167; /* vpshrdv_v8si_maskz_1 */

    case 14:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10168; /* vpshrdv_v4di_maskz_1 */

    case 15:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10169; /* vpshrdv_v8hi_maskz_1 */

    case 16:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10170; /* vpshrdv_v4si_maskz_1 */

    case 17:
      if (!(
#line 30466 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10171; /* vpshrdv_v2di_maskz_1 */

    default:
      return -1;
    }
}

 int
recog_141 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern479 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10128; /* vpshld_v32hi_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10130; /* vpshld_v16si_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10132; /* vpshld_v8di_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10134; /* vpshld_v16hi_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10136; /* vpshld_v8si_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10138; /* vpshld_v4di_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10140; /* vpshld_v8hi_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10142; /* vpshld_v4si_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30410 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10144; /* vpshld_v2di_mask */

    default:
      return -1;
    }
}

 int
recog_149 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V8BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_QImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V8BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V8BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V8BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2529; /* avx512vl_blendmv8bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V8BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2553; /* *avx512vl_storev8bf_mask */
}

 int
recog_150 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V16BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_HImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V16BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V16BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V16BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2528; /* avx512vl_blendmv16bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V16BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V16BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2552; /* *avx512vl_storev16bf_mask */
}

 int
recog_151 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V32BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_SImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V32BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V32BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V32BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 2527; /* avx512bw_blendmv32bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V32BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V32BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
    return -1;
  return 2551; /* *avx512bw_storev32bf_mask */
}

 int
recog_152 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V8HFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_QImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V8HFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V8HFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V8HFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2526; /* avx512fp16_blendmv8hf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V8HFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8HFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2550; /* *avx512fp16_storev8hf_mask */
}

 int
recog_153 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V16HFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_HImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V16HFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V16HFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V16HFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2525; /* avx512vl_blendmv16hf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V16HFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V16HFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2549; /* *avx512vl_storev16hf_mask */
}

 int
recog_154 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2506; /* avx512f_blendmv16si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2530; /* *avx512f_storev16si_mask */

    case E_V8SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2507; /* avx512vl_blendmv8si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2531; /* *avx512vl_storev8si_mask */

    case E_V4SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2508; /* avx512vl_blendmv4si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2532; /* *avx512vl_storev4si_mask */

    case E_V8DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2509; /* avx512f_blendmv8di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2533; /* *avx512f_storev8di_mask */

    case E_V4DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2510; /* avx512vl_blendmv4di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2534; /* *avx512vl_storev4di_mask */

    case E_V2DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V2DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V2DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V2DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2511; /* avx512vl_blendmv2di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2535; /* *avx512vl_storev2di_mask */

    case E_V16SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2512; /* avx512f_blendmv16sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2536; /* *avx512f_storev16sf_mask */

    case E_V8SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2513; /* avx512vl_blendmv8sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2537; /* *avx512vl_storev8sf_mask */

    case E_V4SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2514; /* avx512vl_blendmv4sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2538; /* *avx512vl_storev4sf_mask */

    case E_V8DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2515; /* avx512f_blendmv8df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2539; /* *avx512f_storev8df_mask */

    case E_V4DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2516; /* avx512vl_blendmv4df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2540; /* *avx512vl_storev4df_mask */

    case E_V2DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V2DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V2DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V2DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V2DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2517; /* avx512vl_blendmv2df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V2DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2541; /* *avx512vl_storev2df_mask */

    case E_V64QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V64QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_DImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V64QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V64QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V64QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2518; /* avx512bw_blendmv64qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V64QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V64QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2542; /* *avx512bw_storev64qi_mask */

    case E_V16QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2519; /* avx512vl_blendmv16qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2543; /* *avx512vl_storev16qi_mask */

    case E_V32QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2520; /* avx512vl_blendmv32qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2544; /* *avx512vl_storev32qi_mask */

    case E_V32HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2521; /* avx512bw_blendmv32hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2545; /* *avx512bw_storev32hi_mask */

    case E_V16HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2522; /* avx512vl_blendmv16hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2546; /* *avx512vl_storev16hi_mask */

    case E_V8HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2523; /* avx512vl_blendmv8hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2547; /* *avx512vl_storev8hi_mask */

    case E_V32HFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32HFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32HFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32HFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32HFmode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2524; /* avx512bw_blendmv32hf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32HFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32HFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2548; /* *avx512bw_storev32hf_mask */

    case E_V16HFmode:
      return recog_153 (x1, insn, pnum_clobbers);

    case E_V8HFmode:
      return recog_152 (x1, insn, pnum_clobbers);

    case E_V32BFmode:
      return recog_151 (x1, insn, pnum_clobbers);

    case E_V16BFmode:
      return recog_150 (x1, insn, pnum_clobbers);

    case E_V8BFmode:
      return recog_149 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_162 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 2);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x4, 0, 3);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XEXP (x2, 2);
  if (!register_operand (x7, E_QImode))
    return -1;
  x8 = XVECEXP (x4, 0, 0);
  switch (XWINT (x8, 0))
    {
    case 2L:
      x9 = XVECEXP (x4, 0, 1);
      if (XWINT (x9, 0) != 6L
          || XWINT (x5, 0) != 3L
          || XWINT (x6, 0) != 7L)
        return -1;
      x10 = XEXP (x3, 0);
      x11 = XEXP (x10, 1);
      operands[2] = x11;
      x12 = XEXP (x2, 1);
      operands[3] = x12;
      operands[4] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (pattern1564 (x2, 
E_V4SFmode, 
E_V8SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11203 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL)))
            return -1;
          return 5155; /* vec_interleave_highv4sf_mask */

        case E_V4SImode:
          if (pattern1564 (x2, 
E_V4SImode, 
E_V8SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19745 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
            return -1;
          return 8299; /* vec_interleave_highv4si_mask */

        default:
          return -1;
        }

    case 0L:
      x9 = XVECEXP (x4, 0, 1);
      switch (XWINT (x9, 0))
        {
        case 4L:
          switch (XWINT (x5, 0))
            {
            case 1L:
              if (XWINT (x6, 0) != 5L)
                return -1;
              x10 = XEXP (x3, 0);
              x11 = XEXP (x10, 1);
              operands[2] = x11;
              x12 = XEXP (x2, 1);
              operands[3] = x12;
              operands[4] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1563 (x2, 
E_V4SFmode, 
E_V8SFmode) != 0
                      || !
#line 11260 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 5160; /* unpcklps128_mask */

                case E_V4SImode:
                  if (pattern1564 (x2, 
E_V4SImode, 
E_V8SImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19799 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                    return -1;
                  return 8305; /* vec_interleave_lowv4si_mask */

                default:
                  return -1;
                }

            case 2L:
              if (XWINT (x6, 0) != 6L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4DFmode:
                  if (pattern1620 (x2, 
E_V4DFmode, 
E_V8DFmode) != 0)
                    return -1;
                  x12 = XEXP (x2, 1);
                  operands[2] = x12;
                  if (nonimmediate_operand (operands[1], E_V4DFmode))
                    {
                      operands[3] = x7;
                      x10 = XEXP (x3, 0);
                      x11 = XEXP (x10, 1);
                      if (rtx_equal_p (x11, operands[1])
                          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13455 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                        return 5315; /* avx_movddup256_mask */
                    }
                  operands[3] = x12;
                  if (!register_operand (operands[1], E_V4DFmode))
                    return -1;
                  x10 = XEXP (x3, 0);
                  x11 = XEXP (x10, 1);
                  operands[2] = x11;
                  if (!nonimmediate_operand (operands[2], E_V4DFmode))
                    return -1;
                  operands[4] = x7;
                  if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13469 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                    return -1;
                  return 5317; /* avx_unpcklpd256_mask */

                case E_V4DImode:
                  if (pattern1621 (x2, 
E_V4DImode, 
E_V8DImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
                    return -1;
                  return 7130; /* avx2_interleave_lowv4di_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 0L:
          if (XWINT (x5, 0) != 6L
              || XWINT (x6, 0) != 6L
              || pattern1562 (x2) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_AVX512VL)))
            return -1;
          return 5171; /* sse3_movsldup_mask */

        default:
          return -1;
        }

    case 1L:
      if (XWINT (x6, 0) != 7L)
        return -1;
      x9 = XVECEXP (x4, 0, 1);
      switch (XWINT (x9, 0))
        {
        case 1L:
          if (XWINT (x5, 0) != 7L
              || pattern1562 (x2) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11345 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_AVX512VL)))
            return -1;
          return 5165; /* sse3_movshdup_mask */

        case 5L:
          if (XWINT (x5, 0) != 3L)
            return -1;
          x10 = XEXP (x3, 0);
          x11 = XEXP (x10, 1);
          operands[2] = x11;
          x12 = XEXP (x2, 1);
          operands[3] = x12;
          operands[4] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DFmode:
              if (pattern1563 (x2, 
E_V4DFmode, 
E_V8DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13325 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                return -1;
              return 5307; /* avx_unpckhpd256_mask */

            case E_V4DImode:
              if (pattern1563 (x2, 
E_V4DImode, 
E_V8DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14451 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
                return -1;
              return 7124; /* avx2_interleave_highv4di_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_170 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x4, 0, 2);
  operands[4] = x6;
  x7 = XVECEXP (x4, 0, 3);
  operands[5] = x7;
  x8 = XVECEXP (x4, 0, 5);
  operands[7] = x8;
  x9 = XVECEXP (x4, 0, 6);
  operands[8] = x9;
  x10 = XVECEXP (x4, 0, 7);
  operands[9] = x10;
  x11 = XEXP (x2, 1);
  operands[10] = x11;
  x12 = XEXP (x2, 2);
  operands[11] = x12;
  if (!register_operand (operands[11], E_QImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || GET_MODE (x3) != E_V8DFmode
          || !register_operand (operands[1], E_V8DFmode)
          || pattern1791 () != 0
          || !nonimm_or_0_operand (operands[10], E_V8DFmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 8349; /* *avx512f_shuf_f64x2_1_mask_1 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x2) != E_V8DImode
          || GET_MODE (x3) != E_V8DImode
          || !nonimm_or_0_operand (operands[10], E_V8DImode))
        return -1;
      if (register_operand (operands[1], E_V8DImode)
          && pattern1791 () == 0
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 8351; /* *avx512f_shuf_i64x2_1_mask_1 */
      if (!nonimmediate_operand (operands[1], E_V8DImode)
          || pattern1792 () != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL)
   && (INTVAL (operands[2]) == (INTVAL (operands[6]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9103; /* avx512f_permv8di_1_mask */

    case E_V8SImode:
      if (pattern751 (x2, 
E_V8SImode) != 0
          || pattern1792 () != 0
          || !nonimm_or_0_operand (operands[10], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20616 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   && TARGET_AVX512VL
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9]))))
        return -1;
      return 8367; /* avx2_pshufd_1_mask */

    default:
      return -1;
    }
}

 int
recog_182 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case SS_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SS_TRUNCATE)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x7 = XEXP (x5, 0);
      operands[2] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern1111 (x2, 
E_HImode, 
E_V16QImode, 
E_V8HImode, 
E_V8QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8229; /* sse2_packsswb_mask */

        case E_V8HImode:
          if (pattern1111 (x2, 
E_QImode, 
E_V8HImode, 
E_V4SImode, 
E_V4HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8235; /* sse2_packssdw_mask */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x4;
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != VEC_SELECT)
        return -1;
      x10 = XEXP (x5, 1);
      if (GET_CODE (x10) != PARALLEL)
        return -1;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (XVECLEN (x10, 0))
        {
        case 8:
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x12 = XVECEXP (x10, 0, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
            return -1;
          x13 = XVECEXP (x10, 0, 2);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 10]
              || pattern1400 (x10, 
15, 
14, 
13, 
12, 
11) != 0
              || !register_operand (operands[4], E_HImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1500 (x2, 
E_V16SFmode, 
E_V8SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20081 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8325; /* vec_set_lo_v16sf_mask */

            case E_V16SImode:
              if (pattern1500 (x2, 
E_V16SImode, 
E_V8SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20081 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8327; /* vec_set_lo_v16si_mask */

            default:
              return -1;
            }

        case 4:
          if (pattern1203 (x10, 
7, 
6, 
5, 
4) != 0
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1500 (x2, 
E_V8DFmode, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8333; /* vec_set_lo_v8df_mask */

            case E_V8DImode:
              if (pattern1500 (x2, 
E_V8DImode, 
E_V4DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8335; /* vec_set_lo_v8di_mask */

            case E_V8SImode:
              if (pattern1500 (x2, 
E_V8SImode, 
E_V4SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28485 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9397; /* vec_set_lo_v8si_mask */

            case E_V8SFmode:
              if (pattern1500 (x2, 
E_V8SFmode, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28485 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9399; /* vec_set_lo_v8sf_mask */

            default:
              return -1;
            }

        case 2:
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
            return -1;
          x12 = XVECEXP (x10, 0, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DImode:
              if (pattern1500 (x2, 
E_V4DImode, 
E_V2DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9389; /* vec_set_lo_v4di_mask */

            case E_V4DFmode:
              if (pattern1500 (x2, 
E_V4DFmode, 
E_V2DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28436 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9391; /* vec_set_lo_v4df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x14 = XEXP (x4, 1);
      if (GET_CODE (x14) != PARALLEL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (XVECLEN (x14, 0))
        {
        case 8:
          if (pattern635 (x14) != 0)
            return -1;
          x15 = XVECEXP (x14, 0, 4);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
            return -1;
          x16 = XVECEXP (x14, 0, 5);
          if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
            return -1;
          x17 = XVECEXP (x14, 0, 6);
          if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
            return -1;
          x18 = XVECEXP (x14, 0, 7);
          if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
              || !register_operand (operands[4], E_HImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1458 (x2, 
E_V16SFmode, 
E_V8SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20098 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8329; /* vec_set_hi_v16sf_mask */

            case E_V16SImode:
              if (pattern1458 (x2, 
E_V16SImode, 
E_V8SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20098 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8331; /* vec_set_hi_v16si_mask */

            default:
              return -1;
            }

        case 4:
          if (pattern635 (x14) != 0
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1458 (x2, 
E_V8DFmode, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8337; /* vec_set_hi_v8df_mask */

            case E_V8DImode:
              if (pattern1458 (x2, 
E_V8DImode, 
E_V4DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8339; /* vec_set_hi_v8di_mask */

            case E_V8SImode:
              if (pattern1458 (x2, 
E_V8SImode, 
E_V4SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9401; /* vec_set_hi_v8si_mask */

            case E_V8SFmode:
              if (pattern1458 (x2, 
E_V8SFmode, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28508 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9403; /* vec_set_hi_v8sf_mask */

            default:
              return -1;
            }

        case 2:
          x19 = XVECEXP (x14, 0, 0);
          if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x20 = XVECEXP (x14, 0, 1);
          if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DImode:
              if (pattern1458 (x2, 
E_V4DImode, 
E_V2DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9393; /* vec_set_hi_v4di_mask */

            case E_V4DFmode:
              if (pattern1458 (x2, 
E_V4DFmode, 
E_V2DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9395; /* vec_set_hi_v4df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 2
          || XINT (x4, 1) != 150
          || GET_MODE (x4) != E_V4HImode
          || !register_operand (operands[0], E_V8HImode)
          || GET_MODE (x2) != E_V8HImode
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      x21 = XVECEXP (x4, 0, 0);
      operands[1] = x21;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x22 = XVECEXP (x4, 0, 1);
      operands[2] = x22;
      if (!const_0_to_255_operand (operands[2], E_SImode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[3] = x5;
      if (!const0_operand (operands[3], E_V4HImode))
        return -1;
      x8 = XEXP (x2, 1);
      operands[4] = x8;
      if (!nonimm_or_0_operand (operands[4], E_V8HImode))
        return -1;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!register_operand (operands[5], E_QImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_F16C || TARGET_AVX512VL) && TARGET_AVX512VL)))
        return -1;
      return 9584; /* *vcvtps2ph_mask */

    case FLOAT_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != FLOAT_TRUNCATE)
        return -1;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern1113 (x2, 
E_SImode, 
E_V32BFmode, 
E_V16SFmode, 
E_V16BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10265; /* avx512f_cvtne2ps2bf16_v32bf_mask */

        case E_V16BFmode:
          if (pattern1113 (x2, 
E_HImode, 
E_V16BFmode, 
E_V8SFmode, 
E_V8BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10267; /* avx512f_cvtne2ps2bf16_v16bf_mask */

        case E_V8BFmode:
          if (pattern1113 (x2, 
E_QImode, 
E_V8BFmode, 
E_V4SFmode, 
E_V4BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 30994 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10269; /* avx512f_cvtne2ps2bf16_v8bf_mask */

        case E_V32HFmode:
          if (pattern1114 (x2, 
E_SImode, 
E_V32HFmode, 
E_V16SFmode, 
E_V16HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10365; /* avx10_2_cvt2ps2phx_v32hf_mask */

        case E_V16HFmode:
          if (pattern1114 (x2, 
E_HImode, 
E_V16HFmode, 
E_V8SFmode, 
E_V8HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10368; /* avx10_2_cvt2ps2phx_v16hf_mask */

        case E_V8HFmode:
          if (pattern1114 (x2, 
E_QImode, 
E_V8HFmode, 
E_V4SFmode, 
E_V4HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31727 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10370; /* avx10_2_cvt2ps2phx_v8hf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_188 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      x6 = XEXP (x2, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DFmode:
          if (pattern136 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!vector_operand (operands[1], E_V8HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4648; /* avx512fp16_float_extend_phv8df2_mask */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 5093; /* avx512f_cvtps2pd512_mask */

            default:
              return -1;
            }

        case E_V16SFmode:
          if (pattern135 (x2, 
E_V16SFmode, 
E_HImode, 
E_V16HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4652; /* avx512fp16_float_extend_phv16sf2_mask */

        case E_V8SFmode:
          if (pattern135 (x2, 
E_V8SFmode, 
E_QImode, 
E_V8HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4656; /* avx512fp16_float_extend_phv8sf2_mask */

        case E_V4DFmode:
          if (pattern136 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4HFmode:
              if (!memory_operand (operands[1], E_V4HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4663; /* *avx512fp16_float_extend_phv4df2_load_mask */

            case E_V4SFmode:
              if (!vector_operand (operands[1], E_V4SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (32 == 64 || TARGET_AVX512VL) && 1)))
                return -1;
              return 5096; /* avx_cvtps2pd256_mask */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (pattern150 (x2, 
E_V4SFmode, 
E_V4HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4665; /* *avx512fp16_float_extend_phv4sf2_load_mask */

        case E_V2DFmode:
          if (pattern136 (x2, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V2HFmode:
              if (!memory_operand (operands[1], E_V2HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4669; /* *avx512fp16_float_extend_phv2df2_load_mask */

            case E_V2SFmode:
              if (!memory_operand (operands[1], E_V2SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                return -1;
              return 5144; /* sse2_cvtps2pd_mask_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x7 = XEXP (x4, 1);
      if (GET_CODE (x7) != PARALLEL)
        return -1;
      switch (XVECLEN (x7, 0))
        {
        case 4:
          if (pattern635 (x7) != 0
              || GET_MODE (x4) != E_V4HFmode)
            return -1;
          x8 = XEXP (x4, 0);
          operands[1] = x8;
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          x5 = XEXP (x2, 1);
          operands[2] = x5;
          x6 = XEXP (x2, 2);
          operands[3] = x6;
          if (!register_operand (operands[3], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DFmode:
              if (pattern137 (x2, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4659; /* avx512fp16_float_extend_phv4df2_mask */

            case E_V4SFmode:
              if (pattern137 (x2, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4661; /* avx512fp16_float_extend_phv4sf2_mask */

            default:
              return -1;
            }

        case 2:
          x9 = XVECEXP (x7, 0, 0);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XVECEXP (x7, 0, 1);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || !register_operand (operands[0], E_V2DFmode)
              || GET_MODE (x2) != E_V2DFmode
              || GET_MODE (x3) != E_V2DFmode)
            return -1;
          x6 = XEXP (x2, 2);
          switch (GET_CODE (x6))
            {
            case REG:
            case SUBREG:
              operands[3] = x6;
              if (!register_operand (operands[3], E_QImode))
                return -1;
              x8 = XEXP (x4, 0);
              operands[1] = x8;
              x5 = XEXP (x2, 1);
              operands[2] = x5;
              if (!nonimm_or_0_operand (operands[2], E_V2DFmode))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_V2HFmode:
                  if (!register_operand (operands[1], E_V8HFmode)
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8090 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 4667; /* avx512fp16_float_extend_phv2df2_mask */

                case E_V2SFmode:
                  if (!register_operand (operands[1], E_V4SFmode)
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                    return -1;
                  return 5142; /* sse2_cvtps2pd_mask */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x6, 0) != 1L
                  || GET_MODE (x4) != E_V2SFmode)
                return -1;
              x8 = XEXP (x4, 0);
              operands[2] = x8;
              if (!nonimmediate_operand (operands[2], E_V4SFmode))
                return -1;
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (!register_operand (operands[1], E_V2DFmode)
                  || !
#line 10034 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 5076; /* sse2_cvtss2sd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_196 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern133 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 2988; /* *sminv32hf3_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2993; /* *sminv16hf3_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2997; /* *sminv8hf3_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3004; /* *sminv16sf3_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3009; /* *sminv8sf3_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1)))
        return -1;
      return 3013; /* *sminv4sf3_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3020; /* *sminv8df3_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3025; /* *sminv4df3_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 3029; /* *sminv2df3_mask */

    case 9:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7700; /* *avx512f_sminv16si3_mask */

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7708; /* *avx512f_sminv8si3_mask */

    case 11:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7716; /* *avx512f_sminv4si3_mask */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7800; /* *sse4_1_sminv4si3_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7724; /* *avx512f_sminv8di3_mask */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7732; /* *avx512f_sminv4di3_mask */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7740; /* *avx512f_sminv2di3_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7748; /* *avx512bw_sminv64qi3_mask */

    case 16:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7756; /* *avx512bw_sminv16qi3_mask */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7796; /* *sse4_1_sminv16qi3_mask */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7764; /* *avx512bw_sminv32qi3_mask */

    case 18:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7772; /* *avx512bw_sminv32hi3_mask */

    case 19:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7780; /* *avx512bw_sminv16hi3_mask */

    case 20:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7788; /* *avx512bw_sminv8hi3_mask */

    case 21:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10521; /* avx10_2_sminbf16_v32bf_mask */

    case 22:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10525; /* avx10_2_sminbf16_v16bf_mask */

    case 23:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10529; /* avx10_2_sminbf16_v8bf_mask */

    case 24:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
        return -1;
      return 3101; /* *avx512fp16_vmsminv8hf3 */

    case 25:
      if (!
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 3109; /* *sse_vmsminv4sf3 */

    case 26:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3117; /* *sse2_vmsminv2df3 */

    default:
      return -1;
    }
}

 int
recog_209 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern323 (x2))
    {
    case 0:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x2) != E_V32HImode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4336; /* avx512fp16_vcvtph2uw_v32hi */

    case 1:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16HFmode:
          if (!vector_operand (operands[1], E_V16HFmode)
              || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4344; /* avx512fp16_vcvtph2udq_v16si */

        case E_V16SFmode:
          if (!nonimmediate_operand (operands[1], E_V16SFmode)
              || !(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4772; /* *avx512f_fixuns_notruncv16sfv16si */

        default:
          return -1;
        }

    case 2:
      switch (pattern769 (x2, 
E_V8DImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4352; /* avx512fp16_vcvtph2uqq_v8di */

        case 1:
          if (!(
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4792; /* *avx512dq_cvtps2uqqv8di */

        case 2:
          if (!(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5018; /* fixuns_notruncv8dfv8di2 */

        default:
          return -1;
        }

    case 3:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x2) != E_V16HImode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4360; /* avx512fp16_vcvtph2uw_v16hi */

    case 4:
      switch (pattern769 (x2, 
E_V8SImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4368; /* avx512fp16_vcvtph2udq_v8si */

        case 1:
          if (!(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4776; /* *avx512vl_fixuns_notruncv8sfv8si */

        case 2:
          if (!(
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4938; /* fixuns_notruncv8dfv8si2 */

        default:
          return -1;
        }

    case 5:
      switch (pattern770 (x2, 
E_V4DImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4376; /* avx512fp16_vcvtph2uqq_v4di */

        case 1:
          if (!(
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4796; /* *avx512dq_cvtps2uqqv4di */

        case 2:
          if (!(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5022; /* fixuns_notruncv4dfv4di2 */

        default:
          return -1;
        }

    case 6:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x2) != E_V8HImode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4384; /* avx512fp16_vcvtph2uw_v8hi */

    case 7:
      switch (pattern770 (x2, 
E_V4SImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4392; /* avx512fp16_vcvtph2udq_v4si */

        case 1:
          if (!(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4780; /* *avx512vl_fixuns_notruncv4sfv4si */

        case 2:
          if (!(
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4942; /* fixuns_notruncv4dfv4si2 */

        default:
          return -1;
        }

    case 8:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x2) != E_V2DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4400; /* avx512fp16_vcvtph2uqq_v2di */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5024; /* fixuns_notruncv2dfv2di2 */

        default:
          return -1;
        }

    case 9:
      if (!
#line 8743 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
        return -1;
      return 4798; /* *avx512dq_cvtps2uqqv2di */

    default:
      return -1;
    }
}

 int
recog_223 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  switch (XVECLEN (x4, 0))
    {
    case 2:
      return recog_218 (x1, insn, pnum_clobbers);

    case 3:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      switch (XINT (x4, 1))
        {
        case 192:
          x7 = XEXP (x3, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1394 (x2))
            {
            case 0:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3197; /* reducesv8hf_round */

            case 1:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode)))))
                return -1;
              return 3201; /* reducesv4sf_round */

            case 2:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3205; /* reducesv2df_round */

            default:
              return -1;
            }

        case 133:
          return recog_217 (x1, insn, pnum_clobbers);

        case 217:
          switch (pattern1118 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4255; /* fma_fmaddc_v32hf_maskz_1_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4293; /* avx512bw_fmaddc_v32hf_mask_round */

            case 2:
              if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4318; /* avx512fp16_fma_fmaddcsh_v8hf_round */

            default:
              return -1;
            }

        case 219:
          switch (pattern1118 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4259; /* fma_fcmaddc_v32hf_maskz_1_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4295; /* avx512bw_fcmaddc_v32hf_mask_round */

            case 2:
              if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4322; /* avx512fp16_fma_fcmaddcsh_v8hf_round */

            default:
              return -1;
            }

        case 194:
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          x9 = XVECEXP (x2, 0, 1);
          if (!const48_operand (x9, E_SImode))
            return -1;
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              x10 = XEXP (x3, 1);
              operands[4] = x10;
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1629 (x2, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                    return -1;
                  return 9887; /* avx512dq_rangepv16sf_mask_round */

                case E_V8DFmode:
                  if (pattern1629 (x2, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                    return -1;
                  return 9895; /* avx512dq_rangepv8df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[4] = x9;
              x10 = XEXP (x3, 1);
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1392 (x2, 
E_V4SFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                    return -1;
                  return 9902; /* avx512dq_rangesv4sf_round */

                case E_V2DFmode:
                  if (pattern1392 (x2, 
E_V2DFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29838 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 9906; /* avx512dq_rangesv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 166:
          x7 = XEXP (x3, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1394 (x2))
            {
            case 0:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 9970; /* avx512f_vgetmantv8hf_round */

            case 1:
              if (!
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 9974; /* avx512f_vgetmantv4sf_round */

            case 2:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9978; /* avx512f_vgetmantv2df_round */

            default:
              return -1;
            }

        case 278:
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          x9 = XVECEXP (x2, 0, 1);
          if (!const48_operand (x9, E_SImode))
            return -1;
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              x10 = XEXP (x3, 1);
              operands[4] = x10;
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V32HFmode:
                  if (pattern1629 (x2, 
E_V32HFmode, 
E_SImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10833; /* avx10_2_minmaxpv32hf_mask_round */

                case E_V16HFmode:
                  if (pattern1629 (x2, 
E_V16HFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10837; /* avx10_2_minmaxpv16hf_mask_round */

                case E_V8HFmode:
                  if (pattern1629 (x2, 
E_V8HFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10841; /* avx10_2_minmaxpv8hf_mask_round */

                case E_V16SFmode:
                  if (pattern1629 (x2, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10845; /* avx10_2_minmaxpv16sf_mask_round */

                case E_V8SFmode:
                  if (pattern1629 (x2, 
E_V8SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10849; /* avx10_2_minmaxpv8sf_mask_round */

                case E_V4SFmode:
                  if (pattern1629 (x2, 
E_V4SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10853; /* avx10_2_minmaxpv4sf_mask_round */

                case E_V8DFmode:
                  if (pattern1629 (x2, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10857; /* avx10_2_minmaxpv8df_mask_round */

                case E_V4DFmode:
                  if (pattern1629 (x2, 
E_V4DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10861; /* avx10_2_minmaxpv4df_mask_round */

                case E_V2DFmode:
                  if (pattern1629 (x2, 
E_V2DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32656 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10865; /* avx10_2_minmaxpv2df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[4] = x9;
              switch (pattern1393 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 10868; /* avx10_2_minmaxsv8hf_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                    return -1;
                  return 10872; /* avx10_2_minmaxsv4sf_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 10876; /* avx10_2_minmaxsv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 1:
      return recog_219 (x1, insn, pnum_clobbers);

    case 4:
      if (XINT (x4, 1) != 163)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      x8 = XVECEXP (x4, 0, 2);
      operands[3] = x8;
      x11 = XVECEXP (x4, 0, 3);
      operands[4] = x11;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x9 = XVECEXP (x2, 0, 1);
      if (!const48_operand (x9, E_SImode))
        return -1;
      x10 = XEXP (x3, 1);
      switch (GET_CODE (x10))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[5] = x10;
          x7 = XEXP (x3, 2);
          operands[6] = x7;
          operands[7] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1654 (x2, 
E_V16SFmode, 
E_V16SImode, 
E_HImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7017; /* avx512f_fixupimmv16sf_maskz_1_round */

            case E_V8SFmode:
              if (pattern1654 (x2, 
E_V8SFmode, 
E_V8SImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7021; /* avx512vl_fixupimmv8sf_maskz_1_round */

            case E_V4SFmode:
              if (pattern1654 (x2, 
E_V4SFmode, 
E_V4SImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7025; /* avx512vl_fixupimmv4sf_maskz_1_round */

            case E_V8DFmode:
              if (pattern1654 (x2, 
E_V8DFmode, 
E_V8DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7029; /* avx512f_fixupimmv8df_maskz_1_round */

            case E_V4DFmode:
              if (pattern1654 (x2, 
E_V4DFmode, 
E_V4DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7033; /* avx512vl_fixupimmv4df_maskz_1_round */

            case E_V2DFmode:
              if (pattern1654 (x2, 
E_V2DFmode, 
E_V2DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7037; /* avx512vl_fixupimmv2df_maskz_1_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              operands[6] = x9;
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1681 (x2, 
E_V16SImode, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 7039; /* avx512f_fixupimmv16sf_mask_round */

                case E_V8SFmode:
                  if (pattern1681 (x2, 
E_V8SImode, 
E_V8SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7041; /* avx512vl_fixupimmv8sf_mask_round */

                case E_V4SFmode:
                  if (pattern1681 (x2, 
E_V4SImode, 
E_V4SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7043; /* avx512vl_fixupimmv4sf_mask_round */

                case E_V8DFmode:
                  if (pattern1681 (x2, 
E_V8DImode, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 7045; /* avx512f_fixupimmv8df_mask_round */

                case E_V4DFmode:
                  if (pattern1681 (x2, 
E_V4DImode, 
E_V4DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7047; /* avx512vl_fixupimmv4df_mask_round */

                case E_V2DFmode:
                  if (pattern1681 (x2, 
E_V2DImode, 
E_V2DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7049; /* avx512vl_fixupimmv2df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[5] = x9;
              if (!rtx_equal_p (x10, operands[2]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1682 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                      || !
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 7051; /* avx512f_sfixupimmv4sf_round */

                case E_V2DFmode:
                  if (pattern1682 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 7055; /* avx512f_sfixupimmv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_231 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[0] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || !vector_operand (operands[1], E_V16QImode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8865; /* *sse4_1_ptestv16qi */

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || !vector_operand (operands[1], E_V8HImode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8866; /* *sse4_1_ptestv8hi */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || !vector_operand (operands[1], E_V4SImode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8867; /* *sse4_1_ptestv4si */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || !vector_operand (operands[1], E_V2DImode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8868; /* *sse4_1_ptestv2di */

    case E_V1TImode:
      if (!register_operand (operands[0], E_V1TImode)
          || !vector_operand (operands[1], E_V1TImode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8869; /* *sse4_1_ptestv1ti */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !vector_operand (operands[1], E_V4SFmode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8870; /* *sse4_1_ptestv4sf */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8871; /* *sse4_1_ptestv2df */

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || !vector_operand (operands[1], E_V32QImode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8872; /* *avx_ptestv32qi */

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || !vector_operand (operands[1], E_V16HImode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8873; /* *avx_ptestv16hi */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || !vector_operand (operands[1], E_V8SImode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8874; /* *avx_ptestv8si */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || !vector_operand (operands[1], E_V4DImode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8875; /* *avx_ptestv4di */

    case E_V2TImode:
      if (!register_operand (operands[0], E_V2TImode)
          || !vector_operand (operands[1], E_V2TImode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8876; /* *avx_ptestv2ti */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8877; /* *avx_ptestv8sf */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !vector_operand (operands[1], E_V4DFmode)
          || !(
#line 25319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8878; /* *avx_ptestv4df */

    default:
      return -1;
    }
}

 int
recog_232 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (pattern775 (x3, 
E_V32HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 7062; /* avx512bw_rndscalev32hf */

    case E_V16HFmode:
      if (pattern775 (x3, 
E_V16HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 7066; /* avx512vl_rndscalev16hf */

    case E_V8HFmode:
      if (pattern775 (x3, 
E_V8HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 7070; /* avx512fp16_rndscalev8hf */

    case E_V16SFmode:
      if (pattern775 (x3, 
E_V16SFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7074; /* avx512f_rndscalev16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7078; /* avx512vl_rndscalev8sf */
      if (!vector_operand (operands[1], E_V8SFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25480 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8894; /* avx_roundps256 */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7082; /* avx512vl_rndscalev4sf */
      if (!vector_operand (operands[1], E_V4SFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !
#line 25480 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
        return -1;
      return 8895; /* sse4_1_roundps */

    case E_V8DFmode:
      if (pattern775 (x3, 
E_V8DFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7086; /* avx512f_rndscalev8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7090; /* avx512vl_rndscalev4df */
      if (!vector_operand (operands[1], E_V4DFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25480 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8896; /* avx_roundpd256 */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7094; /* avx512vl_rndscalev2df */
      if (!vector_operand (operands[1], E_V2DFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25480 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 8897; /* sse4_1_roundpd */

    default:
      return -1;
    }
}

 int
recog_235 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x3) != E_V32HFmode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V32HFmode))) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3159; /* *reducepv32hf */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x3) != E_V16HFmode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16HFmode))) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3163; /* *reducepv16hf */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3167; /* *reducepv8hf */

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x3) != E_V16SFmode
          || !vector_operand (operands[1], E_V16SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3171; /* *reducepv16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3175; /* *reducepv8sf */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !vector_operand (operands[1], E_V4SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3179; /* *reducepv4sf */

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x3) != E_V8DFmode
          || !vector_operand (operands[1], E_V8DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3183; /* *reducepv8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode
          || !vector_operand (operands[1], E_V4DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3187; /* *reducepv4df */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3191; /* *reducepv2df */

    default:
      return -1;
    }
}

 int
recog_240 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      if (pattern152 (x3, 
E_V32QImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 752 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8558; /* avx2_psignv32qi3 */

    case E_V16QImode:
      if (pattern152 (x3, 
E_V16QImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8559; /* ssse3_psignv16qi3 */

    case E_V16HImode:
      if (pattern152 (x3, 
E_V16HImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8560; /* avx2_psignv16hi3 */

    case E_V8HImode:
      if (pattern152 (x3, 
E_V8HImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8561; /* ssse3_psignv8hi3 */

    case E_V8SImode:
      if (pattern152 (x3, 
E_V8SImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8562; /* avx2_psignv8si3 */

    case E_V4SImode:
      if (pattern152 (x3, 
E_V4SImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8563; /* ssse3_psignv4si3 */

    default:
      return -1;
    }
}

 int
recog_246 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16SImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9848; /* expandv16si_mask */

        case E_V16SFmode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16SFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9849; /* expandv16sf_mask */

        case E_V8DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8DImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9850; /* expandv8di_mask */

        case E_V8DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8DFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9851; /* expandv8df_mask */

        case E_V8SImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8SImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9852; /* expandv8si_mask */

        case E_V8SFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8SFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9853; /* expandv8sf_mask */

        case E_V4DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4DImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9854; /* expandv4di_mask */

        case E_V4DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4DFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9855; /* expandv4df_mask */

        case E_V4SImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4SImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9856; /* expandv4si_mask */

        case E_V4SFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4SFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9857; /* expandv4sf_mask */

        case E_V2DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V2DImode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9858; /* expandv2di_mask */

        case E_V2DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V2DFmode) != 0
              || !(
#line 29721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9859; /* expandv2df_mask */

        case E_V64QImode:
          if (pattern1020 (x3, 
E_DImode, 
E_V64QImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9860; /* expandv64qi_mask */

        case E_V16QImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16QImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9861; /* expandv16qi_mask */

        case E_V32QImode:
          if (pattern1020 (x3, 
E_SImode, 
E_V32QImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9862; /* expandv32qi_mask */

        case E_V32HImode:
          if (pattern1020 (x3, 
E_SImode, 
E_V32HImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9863; /* expandv32hi_mask */

        case E_V16HImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16HImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9864; /* expandv16hi_mask */

        case E_V8HImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8HImode) != 0
              || !(
#line 29735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9865; /* expandv8hi_mask */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern906 (x3))
        {
        case 0:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SImode)) >= 4)) && 
#line 1016 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9866; /* *expandv16si_mask */

        case 1:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SFmode)) >= 4)) && 
#line 1017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9867; /* *expandv16sf_mask */

        case 2:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DImode)) >= 4)) && 
#line 1018 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9868; /* *expandv8di_mask */

        case 3:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DFmode)) >= 4)) && 
#line 1019 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9869; /* *expandv8df_mask */

        case 4:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SImode)) >= 4)) && 
#line 1020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9870; /* *expandv8si_mask */

        case 5:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SFmode)) >= 4)) && 
#line 1020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9871; /* *expandv8sf_mask */

        case 6:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DImode)) >= 4)) && 
#line 1021 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9872; /* *expandv4di_mask */

        case 7:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DFmode)) >= 4)) && 
#line 1021 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9873; /* *expandv4df_mask */

        case 8:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SImode)) >= 4)) && 
#line 1022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9874; /* *expandv4si_mask */

        case 9:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SFmode)) >= 4)) && 
#line 1022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9875; /* *expandv4sf_mask */

        case 10:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DImode)) >= 4)) && 
#line 1023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9876; /* *expandv2di_mask */

        case 11:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DFmode)) >= 4)) && 
#line 1023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9877; /* *expandv2df_mask */

        case 12:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V64QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9878; /* *expandv64qi_mask */

        case 13:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9879; /* *expandv16qi_mask */

        case 14:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9880; /* *expandv32qi_mask */

        case 15:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9881; /* *expandv32hi_mask */

        case 16:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9882; /* *expandv16hi_mask */

        case 17:
          if (!(
#line 29749 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9883; /* *expandv8hi_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_251 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_0_to_15_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (pattern152 (x3, 
E_V16SFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9884; /* avx512dq_rangepv16sf */

    case E_V8SFmode:
      if (pattern152 (x3, 
E_V8SFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9888; /* avx512dq_rangepv8sf */

    case E_V4SFmode:
      if (pattern152 (x3, 
E_V4SFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9890; /* avx512dq_rangepv4sf */

    case E_V8DFmode:
      if (pattern152 (x3, 
E_V8DFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9892; /* avx512dq_rangepv8df */

    case E_V4DFmode:
      if (pattern152 (x3, 
E_V4DFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9896; /* avx512dq_rangepv4df */

    case E_V2DFmode:
      if (pattern152 (x3, 
E_V2DFmode) != 0
          || !(
#line 29815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9898; /* avx512dq_rangepv2df */

    default:
      return -1;
    }
}

 int
recog_255 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern176 (x1))
    {
    case 0:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10145; /* vpshrdv_v32hi */

    case 1:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10146; /* vpshrdv_v16si */

    case 2:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10147; /* vpshrdv_v8di */

    case 3:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10148; /* vpshrdv_v16hi */

    case 4:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10149; /* vpshrdv_v8si */

    case 5:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10150; /* vpshrdv_v4di */

    case 6:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10151; /* vpshrdv_v8hi */

    case 7:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10152; /* vpshrdv_v4si */

    case 8:
      if (!(
#line 30421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10153; /* vpshrdv_v2di */

    default:
      return -1;
    }
}

 int
recog_262 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 51:
      return recog_245 (x1, insn, pnum_clobbers);

    case 59:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!cmpps_imm_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3207; /* avx_cmpv8sf3 */

        case E_V4SFmode:
          if (pattern61 (x2, 
E_V4SFmode) != 0
              || !
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3208; /* avx_cmpv4sf3 */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3209; /* avx_cmpv4df3 */

        case E_V2DFmode:
          if (pattern61 (x2, 
E_V2DFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3210; /* avx_cmpv2df3 */

        default:
          return -1;
        }

    case 133:
      return recog_244 (x1, insn, pnum_clobbers);

    case 217:
      return recog_260 (x1, insn, pnum_clobbers);

    case 219:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (pattern661 (x2))
        {
        case 0:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 4256; /* fma_fcmaddc_v32hf */
          break;

        case 1:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4262; /* fma_fcmaddc_v16hf */
          break;

        case 2:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4266; /* fma_fcmaddc_v8hf */
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0))
        return -1;
      switch (pattern589 (x2))
        {
        case 0:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4289; /* fma_v32hf_fcmaddc_bcst */

        case 1:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4290; /* fma_v16hf_fcmaddc_bcst */

        case 2:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4291; /* fma_v8hf_fcmaddc_bcst */

        default:
          return -1;
        }

    case 218:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4280; /* fma_fmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4282; /* fma_fmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4284; /* fma_fmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 220:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4281; /* fma_fcmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4283; /* fma_fcmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4285; /* fma_fcmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 50:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[2] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          if (pattern957 (x2, 
E_V4SImode) != 0
              || !
#line 12216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5234; /* sse4_1_insertps_v4si */

        case E_V4SFmode:
          if (pattern957 (x2, 
E_V4SFmode) != 0
              || !
#line 12216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5235; /* sse4_1_insertps_v4sf */

        default:
          return -1;
        }

    case 167:
      return recog_252 (x1, insn, pnum_clobbers);

    case 155:
      return recog_247 (x1, insn, pnum_clobbers);

    case 47:
      return recog_243 (x1, insn, pnum_clobbers);

    case 121:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4TImode:
          if (pattern152 (x2, 
E_V4TImode) != 0
              || !(
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8570; /* avx512bw_palignrv4ti */

        case E_V2TImode:
          if (pattern152 (x2, 
E_V2TImode) != 0
              || !(
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8571; /* avx2_palignrv2ti */

        case E_V1TImode:
          if (pattern152 (x2, 
E_V1TImode) != 0
              || !
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8572; /* ssse3_palignrv1ti */

        default:
          return -1;
        }

    case 122:
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_VOIDmode)
          || !
#line 23438 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8602; /* sse4a_extrqi */

    case 126:
      return recog_258 (x1, insn, pnum_clobbers);

    case 128:
      return recog_259 (x1, insn, pnum_clobbers);

    case 53:
      if (pattern63 (x1, 
E_V16QImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_V16QImode)
          || !
#line 26487 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 8955; /* xop_pperm */

    case 135:
      return recog_257 (x1, insn, pnum_clobbers);

    case 143:
      if (pattern160 (x1, 
E_V2DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27200 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_PCLMUL))
        return -1;
      return 9014; /* pclmulqdq */

    case 152:
      if (pattern63 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27657 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
        return -1;
      return 9104; /* avx2_permv2ti */

    case 146:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SImode:
          if (pattern61 (x2, 
E_V8SImode) != 0
              || !
#line 28310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9374; /* *avx_vperm2f128v8si_full */

        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !
#line 28310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9375; /* *avx_vperm2f128v8sf_full */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !
#line 28310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9376; /* *avx_vperm2f128v4df_full */

        default:
          return -1;
        }

    case 153:
      return recog_242 (x1, insn, pnum_clobbers);

    case 169:
      return recog_249 (x1, insn, pnum_clobbers);

    case 170:
      return recog_248 (x1, insn, pnum_clobbers);

    case 171:
      return recog_246 (x1, insn, pnum_clobbers);

    case 194:
      return recog_251 (x1, insn, pnum_clobbers);

    case 186:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern163 (x2, 
E_V8HImode, 
E_V16QImode) != 0
              || !(
#line 29927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9980; /* *avx512bw_dbpsadbwv8hi */

        case E_V16HImode:
          if (pattern163 (x2, 
E_V16HImode, 
E_V32QImode) != 0
              || !(
#line 29927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9982; /* *avx512bw_dbpsadbwv16hi */

        case E_V32HImode:
          if (pattern163 (x2, 
E_V32HImode, 
E_V64QImode) != 0
              || !(
#line 29927 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9984; /* *avx512bw_dbpsadbwv32hi */

        default:
          return -1;
        }

    case 182:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_3_operand (operands[3], E_SImode)
          || !
#line 29995 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10013; /* sha1rnds4 */

    case 185:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V4SImode)
          || !
#line 30030 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10016; /* sha256rnds2 */

    case 224:
      if (pattern171 (x1) != 0
          || !
#line 30043 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10017; /* vsm3msg1 */

    case 225:
      if (pattern171 (x1) != 0
          || !
#line 30055 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10018; /* vsm3msg2 */

    case 241:
      if (pattern159 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V2DImode)
          || !
#line 30103 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA512))
        return -1;
      return 10022; /* vsha512rnds2 */

    case 195:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30212 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10035; /* vpmadd52luqv8di */

        case 1:
          if (!(
#line 30225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10037; /* vpmadd52luqv4di */

        case 2:
          if (!
#line 30225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10039; /* vpmadd52luqv2di */

        default:
          return -1;
        }

    case 196:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30212 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10036; /* vpmadd52huqv8di */

        case 1:
          if (!(
#line 30225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10038; /* vpmadd52huqv4di */

        case 2:
          if (!
#line 30225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10040; /* vpmadd52huqv2di */

        default:
          return -1;
        }

    case 198:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30349 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10091; /* vgf2p8affineinvqb_v64qi */

        case 1:
          if (!(
#line 30349 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10093; /* vgf2p8affineinvqb_v32qi */

        case 2:
          if (!
#line 30349 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10095; /* vgf2p8affineinvqb_v16qi */

        default:
          return -1;
        }

    case 199:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10097; /* vgf2p8affineqb_v64qi */

        case 1:
          if (!(
#line 30366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10099; /* vgf2p8affineqb_v32qi */

        case 2:
          if (!
#line 30366 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10101; /* vgf2p8affineqb_v16qi */

        default:
          return -1;
        }

    case 202:
      return recog_256 (x1, insn, pnum_clobbers);

    case 201:
      return recog_254 (x1, insn, pnum_clobbers);

    case 203:
      return recog_255 (x1, insn, pnum_clobbers);

    case 204:
      return recog_253 (x1, insn, pnum_clobbers);

    case 205:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30583 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10199; /* vpdpbusd_v16si */

        case 1:
          if (!(
#line 30594 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10200; /* vpdpbusd_v8si */

        case 2:
          if (!
#line 30594 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10201; /* vpdpbusd_v4si */

        default:
          return -1;
        }

    case 206:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30652 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10208; /* vpdpbusds_v16si */

        case 1:
          if (!(
#line 30663 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10209; /* vpdpbusds_v8si */

        case 2:
          if (!
#line 30663 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10210; /* vpdpbusds_v4si */

        default:
          return -1;
        }

    case 207:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10217; /* vpdpwssd_v16si */

        case 1:
          if (!(
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10218; /* vpdpwssd_v8si */

        case 2:
          if (!
#line 30732 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10219; /* vpdpwssd_v4si */

        default:
          return -1;
        }

    case 208:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30790 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10226; /* vpdpwssds_v16si */

        case 1:
          if (!(
#line 30801 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10227; /* vpdpwssds_v8si */

        case 2:
          if (!
#line 30801 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10228; /* vpdpwssds_v4si */

        default:
          return -1;
        }

    case 213:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern152 (x2, 
E_V8DImode) != 0
              || !(
#line 30930 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10247; /* vpclmulqdq_v8di */

        case E_V4DImode:
          if (pattern152 (x2, 
E_V4DImode) != 0
              || !
#line 30930 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ))
            return -1;
          return 10248; /* vpclmulqdq_v4di */

        case E_V2DImode:
          if (pattern152 (x2, 
E_V2DImode) != 0
              || !(
#line 30930 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10249; /* vpclmulqdq_v2di */

        default:
          return -1;
        }

    case 216:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern907 (x2, 
E_V32BFmode, 
E_V16SFmode) != 0
              || !(
#line 31209 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10277; /* avx512f_dpbf16ps_v16sf */

        case E_V8SFmode:
          if (pattern907 (x2, 
E_V16BFmode, 
E_V8SFmode) != 0
              || !(
#line 31209 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10279; /* avx512f_dpbf16ps_v8sf */

        case E_V4SFmode:
          if (pattern907 (x2, 
E_V8BFmode, 
E_V4SFmode) != 0
              || !(
#line 31209 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10281; /* avx512f_dpbf16ps_v4sf */

        default:
          return -1;
        }

    case 227:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10297; /* vpdpbssd_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10303; /* vpdpbssd_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10309; /* vpdpbssd_v16si */

        default:
          return -1;
        }

    case 228:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10298; /* vpdpbssds_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10304; /* vpdpbssds_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10310; /* vpdpbssds_v16si */

        default:
          return -1;
        }

    case 229:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10299; /* vpdpbsud_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10305; /* vpdpbsud_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10311; /* vpdpbsud_v16si */

        default:
          return -1;
        }

    case 230:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10300; /* vpdpbsuds_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10306; /* vpdpbsuds_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10312; /* vpdpbsuds_v16si */

        default:
          return -1;
        }

    case 231:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10301; /* vpdpbuud_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10307; /* vpdpbuud_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10313; /* vpdpbuud_v16si */

        default:
          return -1;
        }

    case 232:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10302; /* vpdpbuuds_v8si */

        case 1:
          if (!
#line 31582 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10308; /* vpdpbuuds_v4si */

        case 2:
          if (!
#line 31593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10314; /* vpdpbuuds_v16si */

        default:
          return -1;
        }

    case 233:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10449; /* vpdpwusd_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10455; /* vpdpwusd_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10461; /* vpdpwusd_v16si */

        default:
          return -1;
        }

    case 234:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10450; /* vpdpwusds_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10456; /* vpdpwusds_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10462; /* vpdpwusds_v16si */

        default:
          return -1;
        }

    case 235:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10451; /* vpdpwsud_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10457; /* vpdpwsud_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10463; /* vpdpwsud_v16si */

        default:
          return -1;
        }

    case 236:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10452; /* vpdpwsuds_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10458; /* vpdpwsuds_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10464; /* vpdpwsuds_v16si */

        default:
          return -1;
        }

    case 237:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10453; /* vpdpwuud_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10459; /* vpdpwuud_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10465; /* vpdpwuud_v16si */

        default:
          return -1;
        }

    case 238:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10454; /* vpdpwuuds_v8si */

        case 1:
          if (!
#line 31991 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10460; /* vpdpwuuds_v4si */

        case 2:
          if (!
#line 32002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10466; /* vpdpwuuds_v16si */

        default:
          return -1;
        }

    case 244:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern172 (x2, 
E_V16SFmode) != 0
              || !
#line 32054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10503; /* vdpphps_v16sf */

        case E_V8SFmode:
          if (pattern172 (x2, 
E_V8SFmode) != 0
              || !
#line 32054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10504; /* vdpphps_v8sf */

        case E_V4SFmode:
          if (pattern172 (x2, 
E_V4SFmode) != 0
              || !
#line 32054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10505; /* vdpphps_v4sf */

        default:
          return -1;
        }

    case 277:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern1021 (x2, 
E_V32BFmode) != 0
              || !
#line 32644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10824; /* avx10_2_minmaxbf16_v32bf */

        case E_V16BFmode:
          if (pattern1021 (x2, 
E_V16BFmode) != 0
              || !
#line 32644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10826; /* avx10_2_minmaxbf16_v16bf */

        case E_V8BFmode:
          if (pattern1021 (x2, 
E_V8BFmode) != 0
              || !
#line 32644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10828; /* avx10_2_minmaxbf16_v8bf */

        default:
          return -1;
        }

    case 278:
      return recog_250 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_287 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  operands[6] = x4;
  res = recog_286 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V8HImode)
      || GET_MODE (x2) != E_V8HImode
      || !vector_operand (operands[1], E_V8HImode)
      || pattern668 (x3) != 0
      || !
#line 20834 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
    return -1;
  return 8374; /* sse2_pshuflw_1 */
}

 int
recog_290 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 1);
  operands[3] = x4;
  x5 = XVECEXP (x3, 0, 2);
  operands[4] = x5;
  x6 = XVECEXP (x3, 0, 3);
  operands[5] = x6;
  x7 = XVECEXP (x3, 0, 5);
  operands[7] = x7;
  x8 = XVECEXP (x3, 0, 6);
  operands[8] = x8;
  x9 = XVECEXP (x3, 0, 7);
  operands[9] = x9;
  x10 = XVECEXP (x3, 0, 8);
  operands[10] = x10;
  x11 = XVECEXP (x3, 0, 9);
  operands[11] = x11;
  x12 = XVECEXP (x3, 0, 10);
  operands[12] = x12;
  x13 = XVECEXP (x3, 0, 11);
  operands[13] = x13;
  x14 = XVECEXP (x3, 0, 12);
  operands[14] = x14;
  x15 = XVECEXP (x3, 0, 13);
  operands[15] = x15;
  x16 = XVECEXP (x3, 0, 14);
  operands[16] = x16;
  x17 = XVECEXP (x3, 0, 15);
  operands[17] = x17;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || pattern1814 () != 0
          || !(
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 8360; /* *avx512f_shuf_f32x4_1_1 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode)
        return -1;
      if (register_operand (operands[1], E_V16SImode)
          && pattern1814 () == 0
          && (
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 8362; /* *avx512f_shuf_i32x4_1_1 */
      if (!nonimmediate_operand (operands[1], E_V16SImode)
          || pattern1692 () != 0
          || !const_8_to_11_operand (operands[10], E_VOIDmode)
          || !const_8_to_11_operand (operands[11], E_VOIDmode)
          || !const_8_to_11_operand (operands[12], E_VOIDmode)
          || !const_8_to_11_operand (operands[13], E_VOIDmode)
          || !const_12_to_15_operand (operands[14], E_VOIDmode)
          || !const_12_to_15_operand (operands[15], E_VOIDmode)
          || !const_12_to_15_operand (operands[16], E_VOIDmode)
          || !const_12_to_15_operand (operands[17], E_VOIDmode)
          || !
#line 20535 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])
   && INTVAL (operands[2]) + 8 == INTVAL (operands[10])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[11])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[12])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[13])
   && INTVAL (operands[2]) + 12 == INTVAL (operands[14])
   && INTVAL (operands[3]) + 12 == INTVAL (operands[15])
   && INTVAL (operands[4]) + 12 == INTVAL (operands[16])
   && INTVAL (operands[5]) + 12 == INTVAL (operands[17])))
        return -1;
      return 8364; /* avx512f_pshufd_1 */

    default:
      return -1;
    }
}

 int
recog_302 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern529 (x2))
        {
        case 0:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5438; /* *avx512bw_vpternlogv64qi_1 */

        case 1:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5465; /* *avx512vl_vpternlogv32qi_1 */

        case 2:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5492; /* *avx512vl_vpternlogv16qi_1 */

        case 3:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5519; /* *avx512bw_vpternlogv32hi_1 */

        case 4:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5546; /* *avx512vl_vpternlogv16hi_1 */

        case 5:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5573; /* *avx512vl_vpternlogv8hi_1 */

        case 6:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5600; /* *avx512f_vpternlogv16si_1 */

        case 7:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5627; /* *avx512vl_vpternlogv8si_1 */

        case 8:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5654; /* *avx512vl_vpternlogv4si_1 */

        case 9:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5681; /* *avx512f_vpternlogv8di_1 */

        case 10:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5708; /* *avx512vl_vpternlogv4di_1 */

        case 11:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5735; /* *avx512vl_vpternlogv2di_1 */

        case 12:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5441; /* *avx512bw_vpternlogv64qi_1 */

        case 13:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5468; /* *avx512vl_vpternlogv32qi_1 */

        case 14:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5495; /* *avx512vl_vpternlogv16qi_1 */

        case 15:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5522; /* *avx512bw_vpternlogv32hi_1 */

        case 16:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5549; /* *avx512vl_vpternlogv16hi_1 */

        case 17:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5576; /* *avx512vl_vpternlogv8hi_1 */

        case 18:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5603; /* *avx512f_vpternlogv16si_1 */

        case 19:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5630; /* *avx512vl_vpternlogv8si_1 */

        case 20:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5657; /* *avx512vl_vpternlogv4si_1 */

        case 21:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5684; /* *avx512f_vpternlogv8di_1 */

        case 22:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5711; /* *avx512vl_vpternlogv4di_1 */

        case 23:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5738; /* *avx512vl_vpternlogv2di_1 */

        case 24:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5444; /* *avx512bw_vpternlogv64qi_1 */

        case 25:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5471; /* *avx512vl_vpternlogv32qi_1 */

        case 26:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5498; /* *avx512vl_vpternlogv16qi_1 */

        case 27:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5525; /* *avx512bw_vpternlogv32hi_1 */

        case 28:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5552; /* *avx512vl_vpternlogv16hi_1 */

        case 29:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5579; /* *avx512vl_vpternlogv8hi_1 */

        case 30:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5606; /* *avx512f_vpternlogv16si_1 */

        case 31:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5633; /* *avx512vl_vpternlogv8si_1 */

        case 32:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5660; /* *avx512vl_vpternlogv4si_1 */

        case 33:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5687; /* *avx512f_vpternlogv8di_1 */

        case 34:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5714; /* *avx512vl_vpternlogv4di_1 */

        case 35:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5741; /* *avx512vl_vpternlogv2di_1 */

        case 36:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6728; /* *avx512bw_vpternlogv64qi_3 */

        case 37:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6737; /* *avx512vl_vpternlogv32qi_3 */

        case 38:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6746; /* *avx512vl_vpternlogv16qi_3 */

        case 39:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6755; /* *avx512bw_vpternlogv32hi_3 */

        case 40:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6764; /* *avx512vl_vpternlogv16hi_3 */

        case 41:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6773; /* *avx512vl_vpternlogv8hi_3 */

        case 42:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6782; /* *avx512f_vpternlogv16si_3 */

        case 43:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6791; /* *avx512vl_vpternlogv8si_3 */

        case 44:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6800; /* *avx512vl_vpternlogv4si_3 */

        case 45:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6809; /* *avx512f_vpternlogv8di_3 */

        case 46:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6818; /* *avx512vl_vpternlogv4di_3 */

        case 47:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6827; /* *avx512vl_vpternlogv2di_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6086; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6113; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6140; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6167; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6194; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6221; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6248; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6275; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6302; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6329; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6356; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6383; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6089; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6116; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6143; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6170; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6197; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6224; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6251; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6278; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6305; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6332; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6359; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6386; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6092; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6119; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6146; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6173; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6200; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6227; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6254; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6281; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6308; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6335; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6362; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6389; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_311 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern533 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5752; /* *avx512bw_vpternlogv32hf_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5779; /* *avx512vl_vpternlogv16hf_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5806; /* *avx512fp16_vpternlogv8hf_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5833; /* *avx512bw_vpternlogv32bf_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5860; /* *avx512vl_vpternlogv16bf_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5887; /* *avx512vl_vpternlogv8bf_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5914; /* *avx512f_vpternlogv16sf_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5941; /* *avx512vl_vpternlogv8sf_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5968; /* *avx512vl_vpternlogv4sf_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5995; /* *avx512f_vpternlogv8df_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6022; /* *avx512vl_vpternlogv4df_1 */

            case 11:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6049; /* *avx512vl_vpternlogv2df_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5755; /* *avx512bw_vpternlogv32hf_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5782; /* *avx512vl_vpternlogv16hf_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5809; /* *avx512fp16_vpternlogv8hf_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5836; /* *avx512bw_vpternlogv32bf_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5863; /* *avx512vl_vpternlogv16bf_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5890; /* *avx512vl_vpternlogv8bf_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5917; /* *avx512f_vpternlogv16sf_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5944; /* *avx512vl_vpternlogv8sf_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5971; /* *avx512vl_vpternlogv4sf_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5998; /* *avx512f_vpternlogv8df_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6025; /* *avx512vl_vpternlogv4df_1 */

            case 23:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6052; /* *avx512vl_vpternlogv2df_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5758; /* *avx512bw_vpternlogv32hf_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5785; /* *avx512vl_vpternlogv16hf_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5812; /* *avx512fp16_vpternlogv8hf_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5839; /* *avx512bw_vpternlogv32bf_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5866; /* *avx512vl_vpternlogv16bf_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5893; /* *avx512vl_vpternlogv8bf_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5920; /* *avx512f_vpternlogv16sf_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5947; /* *avx512vl_vpternlogv8sf_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5974; /* *avx512vl_vpternlogv4sf_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6001; /* *avx512f_vpternlogv8df_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6028; /* *avx512vl_vpternlogv4df_1 */

            case 35:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6055; /* *avx512vl_vpternlogv2df_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6832; /* *avx512bw_vpternlogv32hf_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6841; /* *avx512vl_vpternlogv16hf_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6850; /* *avx512fp16_vpternlogv8hf_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6859; /* *avx512bw_vpternlogv32bf_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6868; /* *avx512vl_vpternlogv16bf_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6877; /* *avx512vl_vpternlogv8bf_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6886; /* *avx512f_vpternlogv16sf_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6895; /* *avx512vl_vpternlogv8sf_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6904; /* *avx512vl_vpternlogv4sf_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6913; /* *avx512f_vpternlogv8df_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6922; /* *avx512vl_vpternlogv4df_3 */

            case 47:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6931; /* *avx512vl_vpternlogv2df_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6400; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6427; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6454; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6481; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6508; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6535; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6562; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6589; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6616; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6643; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6670; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6697; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6403; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6430; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6457; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6484; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6511; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6538; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6565; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6592; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6619; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6646; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6673; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6700; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6406; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6433; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6460; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6487; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6514; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6541; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6568; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6595; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6622; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6649; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6676; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6703; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern533 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5761; /* *avx512bw_vpternlogv32hf_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5788; /* *avx512vl_vpternlogv16hf_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5815; /* *avx512fp16_vpternlogv8hf_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5842; /* *avx512bw_vpternlogv32bf_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5869; /* *avx512vl_vpternlogv16bf_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5896; /* *avx512vl_vpternlogv8bf_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5923; /* *avx512f_vpternlogv16sf_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5950; /* *avx512vl_vpternlogv8sf_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5977; /* *avx512vl_vpternlogv4sf_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6004; /* *avx512f_vpternlogv8df_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6031; /* *avx512vl_vpternlogv4df_1 */

            case 11:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6058; /* *avx512vl_vpternlogv2df_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5764; /* *avx512bw_vpternlogv32hf_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5791; /* *avx512vl_vpternlogv16hf_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5818; /* *avx512fp16_vpternlogv8hf_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5845; /* *avx512bw_vpternlogv32bf_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5872; /* *avx512vl_vpternlogv16bf_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5899; /* *avx512vl_vpternlogv8bf_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5926; /* *avx512f_vpternlogv16sf_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5953; /* *avx512vl_vpternlogv8sf_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5980; /* *avx512vl_vpternlogv4sf_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6007; /* *avx512f_vpternlogv8df_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6034; /* *avx512vl_vpternlogv4df_1 */

            case 23:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6061; /* *avx512vl_vpternlogv2df_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5767; /* *avx512bw_vpternlogv32hf_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5794; /* *avx512vl_vpternlogv16hf_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5821; /* *avx512fp16_vpternlogv8hf_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5848; /* *avx512bw_vpternlogv32bf_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5875; /* *avx512vl_vpternlogv16bf_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5902; /* *avx512vl_vpternlogv8bf_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5929; /* *avx512f_vpternlogv16sf_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5956; /* *avx512vl_vpternlogv8sf_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5983; /* *avx512vl_vpternlogv4sf_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6010; /* *avx512f_vpternlogv8df_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6037; /* *avx512vl_vpternlogv4df_1 */

            case 35:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6064; /* *avx512vl_vpternlogv2df_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6835; /* *avx512bw_vpternlogv32hf_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6844; /* *avx512vl_vpternlogv16hf_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6853; /* *avx512fp16_vpternlogv8hf_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6862; /* *avx512bw_vpternlogv32bf_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6871; /* *avx512vl_vpternlogv16bf_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6880; /* *avx512vl_vpternlogv8bf_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6889; /* *avx512f_vpternlogv16sf_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6898; /* *avx512vl_vpternlogv8sf_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6907; /* *avx512vl_vpternlogv4sf_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6916; /* *avx512f_vpternlogv8df_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6925; /* *avx512vl_vpternlogv4df_3 */

            case 47:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6934; /* *avx512vl_vpternlogv2df_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6409; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6436; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6463; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6490; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6517; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6544; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6571; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6598; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6625; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6652; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6679; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6706; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6412; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6439; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6466; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6493; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6520; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6547; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6574; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6601; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6628; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6655; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6682; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6709; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6415; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6442; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6469; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6496; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6523; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6550; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6577; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6604; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6631; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6658; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6685; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6712; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case XOR:
      return recog_306 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_371 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 0);
  operands[0] = x4;
  x5 = XEXP (x3, 1);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  switch (pattern926 (x1))
    {
    case 0:
      if (!
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
        return -1;
      *pnum_clobbers = 1;
      return 261; /* floatunssisf2_i387_with_xmm */

    case 1:
      if (!
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
        return -1;
      *pnum_clobbers = 1;
      return 262; /* floatunssidf2_i387_with_xmm */

    case 2:
      if (!
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
        return -1;
      *pnum_clobbers = 1;
      return 263; /* floatunssixf2_i387_with_xmm */

    default:
      return -1;
    }
}

 int
recog_374 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (XWINT (x4, 0) != 0L)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x5))
    {
    case SET:
      x6 = XEXP (x5, 0);
      operands[0] = x6;
      x7 = XEXP (x5, 1);
      switch (GET_CODE (x7))
        {
        case PLUS:
          switch (pattern1412 (x1))
            {
            case 0:
              if (!
#line 7140 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 309; /* *addqi_2 */

            case 1:
              if (!
#line 7140 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 310; /* *addhi_2 */

            case 2:
              if (!
#line 7140 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 311; /* *addsi_2 */

            case 3:
              if (!(
#line 7140 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 312; /* *adddi_2 */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          if (pattern1413 (x1, 
PLUS) != 0
              || !
#line 7190 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 313; /* *addsi_2_zext */

        default:
          return -1;
        }

    case CLOBBER:
      x6 = XEXP (x5, 0);
      operands[0] = x6;
      x8 = XEXP (x3, 0);
      switch (pattern938 (x8))
        {
        case 0:
          if (!
#line 7422 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 323; /* *addqi_5 */

        case 1:
          if (!
#line 7422 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 324; /* *addhi_5 */

        case 2:
          if (!
#line 7422 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 325; /* *addsi_5 */

        case 3:
          if (!(
#line 7422 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGOCmode)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 326; /* *adddi_5 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_377 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 17
      || GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  operands[0] = x8;
  x9 = XEXP (x4, 1);
  switch (GET_CODE (x9))
    {
    case ZERO_EXTEND:
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      x11 = XEXP (x3, 0);
      switch (GET_MODE (x11))
        {
        case E_DImode:
          if (pattern1741 (x4, 
E_SImode, 
E_DImode) != 0
              || !
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 517; /* subsi3_carry_ccc */

        case E_TImode:
          if (pattern1741 (x4, 
E_DImode, 
E_TImode) != 0
              || !
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 518; /* subdi3_carry_ccc */

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x9;
      x11 = XEXP (x3, 0);
      switch (GET_MODE (x11))
        {
        case E_DImode:
          if (pattern1742 (x4, 
E_SImode, 
E_DImode) != 0
              || !
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 519; /* *subsi3_carry_ccc_1 */

        case E_TImode:
          if (pattern1742 (x4, 
E_DImode, 
E_TImode) != 0
              || !
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 520; /* *subdi3_carry_ccc_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_380 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17)
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x6;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      x8 = XEXP (x4, 1);
      switch (GET_CODE (x8))
        {
        case CONST_INT:
          res = recog_374 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case REG:
        case SUBREG:
        case MEM:
          res = recog_375 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        default:
          break;
        }
      if (GET_MODE (x3) != E_CCCmode
          || GET_MODE (x4) != E_CCCmode)
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x9))
        {
        case CLOBBER:
          x10 = XEXP (x9, 0);
          operands[0] = x10;
          if (!rtx_equal_p (x8, operands[2]))
            return -1;
          switch (pattern938 (x5))
            {
            case 0:
              if (!
#line 10037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 543; /* *addqi3_cconly_overflow_2 */

            case 1:
              if (!
#line 10037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 544; /* *addhi3_cconly_overflow_2 */

            case 2:
              if (!
#line 10037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 545; /* *addsi3_cconly_overflow_2 */

            case 3:
              if (!(
#line 10037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 546; /* *adddi3_cconly_overflow_2 */

            default:
              return -1;
            }

        case SET:
          x10 = XEXP (x9, 0);
          operands[0] = x10;
          x11 = XEXP (x9, 1);
          switch (GET_CODE (x11))
            {
            case PLUS:
              x12 = XEXP (x11, 0);
              if (!rtx_equal_p (x12, operands[1]))
                return -1;
              x13 = XEXP (x11, 1);
              if (!rtx_equal_p (x13, operands[2]))
                return -1;
              switch (GET_MODE (x5))
                {
                case E_QImode:
                  if (pattern1610 (x1, 
E_QImode) != 0
                      || !
#line 10055 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 547; /* *addqi3_cc_overflow_2 */

                case E_HImode:
                  if (pattern1610 (x1, 
E_HImode) != 0
                      || !
#line 10055 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 548; /* *addhi3_cc_overflow_2 */

                case E_SImode:
                  if (!nonimmediate_operand (operands[1], E_SImode)
                      || !x86_64_general_operand (operands[2], E_SImode)
                      || !nonimmediate_operand (operands[0], E_SImode)
                      || GET_MODE (x11) != E_SImode
                      || !rtx_equal_p (x8, operands[2])
                      || !
#line 10055 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 549; /* *addsi3_cc_overflow_2 */

                case E_DImode:
                  if (!nonimmediate_operand (operands[1], E_DImode)
                      || !nonimmediate_operand (operands[0], E_DImode)
                      || GET_MODE (x11) != E_DImode)
                    return -1;
                  if (x86_64_general_operand (operands[2], E_DImode)
                      && rtx_equal_p (x8, operands[2])
                      && (
#line 10055 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 550; /* *adddi3_cc_overflow_2 */
                  if (!x86_64_hilo_general_operand (operands[2], E_DImode)
                      || !rtx_equal_p (x8, operands[1])
                      || !(
#line 10093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return -1;
                  return 552; /* *adddi3_doubleword_cc_overflow_1 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (GET_MODE (x11) != E_DImode)
                return -1;
              x12 = XEXP (x11, 0);
              if (GET_CODE (x12) != PLUS
                  || GET_MODE (x12) != E_SImode
                  || GET_MODE (x5) != E_SImode
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !register_operand (operands[0], E_DImode)
                  || !rtx_equal_p (x8, operands[2]))
                return -1;
              x14 = XEXP (x12, 0);
              if (!rtx_equal_p (x14, operands[1]))
                return -1;
              x15 = XEXP (x12, 1);
              if (!rtx_equal_p (x15, operands[2])
                  || !
#line 10074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 551; /* *addsi3_zext_cc_overflow_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      if (XVECLEN (x6, 0) != 2
          || XINT (x6, 1) != 110)
        return -1;
      x8 = XEXP (x4, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      switch (pattern1218 (x1, 
PLUS))
        {
        case 0:
          return 10971; /* atomic_add_fetch_cmp_0qi_1 */

        case 1:
          return 10972; /* atomic_add_fetch_cmp_0hi_1 */

        case 2:
          return 10973; /* atomic_add_fetch_cmp_0si_1 */

        case 3:
          if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 10974; /* atomic_add_fetch_cmp_0di_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_385 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern680 (x1, 
PLUS) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          switch (pattern1544 (x1))
            {
            case 0:
              if (!
#line 7672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 342; /* *addvqi4 */

            case 1:
              if (!
#line 7672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 343; /* *addvhi4 */

            case 2:
              if (!
#line 7672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 344; /* *addvsi4 */

            case 3:
              if (x86_64_sext_operand (operands[2], E_DImode)
                  && (
#line 7672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 345; /* *addvdi4 */
              if (!nonimmediate_operand (operands[2], E_DImode)
                  || !(
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 350; /* *addvdi4_doubleword */

            case 4:
              if (!(
#line 7725 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 351; /* *addvti4_doubleword */

            case 5:
              if (!
#line 7694 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 346; /* addvqi4_1 */

            case 6:
              if (!
#line 7694 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 347; /* addvhi4_1 */

            case 7:
              if (!
#line 7694 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 348; /* addvsi4_1 */

            case 8:
              if (const_int_operand (operands[3], E_TImode)
                  && x86_64_immediate_operand (operands[2], E_DImode)
                  && (
#line 7694 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 349; /* addvdi4_1 */
              if (!const_scalar_int_operand (operands[3], E_TImode)
                  || !x86_64_hilo_general_operand (operands[2], E_DImode)
                  || !(
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 352; /* *addvdi4_doubleword_1 */

            case 9:
              if (!(
#line 7771 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 353; /* *addvti4_doubleword_1 */

            default:
              return -1;
            }

        case PLUS:
          x6 = XEXP (x5, 0);
          switch (GET_CODE (x6))
            {
            case LTU:
            case UNLT:
              operands[4] = x6;
              x7 = XEXP (x6, 1);
              if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x8 = XEXP (x5, 1);
              if (GET_CODE (x8) != SIGN_EXTEND)
                return -1;
              x9 = XEXP (x3, 1);
              x10 = XEXP (x9, 0);
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != PLUS)
                return -1;
              x12 = XEXP (x11, 0);
              switch (GET_CODE (x12))
                {
                case LTU:
                case UNLT:
                  operands[5] = x12;
                  x13 = XEXP (x12, 1);
                  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                    return -1;
                  x14 = XVECEXP (x1, 0, 1);
                  x15 = XEXP (x14, 1);
                  x16 = XEXP (x15, 0);
                  if (GET_CODE (x16) != PLUS)
                    return -1;
                  x17 = XEXP (x16, 0);
                  switch (GET_CODE (x17))
                    {
                    case LTU:
                    case UNLT:
                      if (!rtx_equal_p (x17, operands[5]))
                        return -1;
                      x18 = XEXP (x6, 0);
                      operands[3] = x18;
                      if (!flags_reg_operand (operands[3], E_VOIDmode))
                        return -1;
                      x19 = XEXP (x8, 0);
                      operands[1] = x19;
                      x20 = XEXP (x12, 0);
                      if (!rtx_equal_p (x20, operands[3]))
                        return -1;
                      x21 = XEXP (x11, 1);
                      if (!rtx_equal_p (x21, operands[1]))
                        return -1;
                      x22 = XEXP (x16, 1);
                      if (!rtx_equal_p (x22, operands[1]))
                        return -1;
                      switch (pattern1839 (x1))
                        {
                        case 0:
                          if (pattern1855 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 7838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 354; /* *addvqi4_overflow_1 */

                        case 1:
                          if (pattern1855 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 7838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 355; /* *addvhi4_overflow_1 */

                        case 2:
                          if (pattern1856 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 7838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 356; /* *addvsi4_overflow_1 */

                        case 3:
                          if (pattern1856 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 7838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 357; /* *addvdi4_overflow_1 */

                        case 4:
                          if (pattern1858 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 7871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 358; /* *addvqi4_overflow_2 */

                        case 5:
                          if (pattern1858 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 7871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 359; /* *addvhi4_overflow_2 */

                        case 6:
                          if (pattern1858 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 7871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 360; /* *addvsi4_overflow_2 */

                        case 7:
                          if (pattern1858 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 7871 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 361; /* *addvdi4_overflow_2 */

                        default:
                          return -1;
                        }

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      if (pattern680 (x1, 
MINUS) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          switch (pattern1544 (x1))
            {
            case 0:
              if (!
#line 8447 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 425; /* *subvqi4 */

            case 1:
              if (!
#line 8447 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 426; /* *subvhi4 */

            case 2:
              if (!
#line 8447 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 427; /* *subvsi4 */

            case 3:
              if (x86_64_sext_operand (operands[2], E_DImode)
                  && (
#line 8447 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 428; /* *subvdi4 */
              if (!nonimmediate_operand (operands[2], E_DImode)
                  || !(
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 433; /* *subvdi4_doubleword */

            case 4:
              if (!(
#line 8497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 434; /* *subvti4_doubleword */

            case 5:
              if (!
#line 8469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 429; /* subvqi4_1 */

            case 6:
              if (!
#line 8469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 430; /* subvhi4_1 */

            case 7:
              if (!
#line 8469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 431; /* subvsi4_1 */

            case 8:
              if (const_int_operand (operands[3], E_TImode)
                  && x86_64_immediate_operand (operands[2], E_DImode)
                  && (
#line 8469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 432; /* subvdi4_1 */
              if (!const_scalar_int_operand (operands[3], E_TImode)
                  || !x86_64_hilo_general_operand (operands[2], E_DImode)
                  || !(
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 435; /* *subvdi4_doubleword_1 */

            case 9:
              if (!(
#line 8541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 436; /* *subvti4_doubleword_1 */

            default:
              return -1;
            }

        case MINUS:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != SIGN_EXTEND)
            return -1;
          x8 = XEXP (x5, 1);
          switch (GET_CODE (x8))
            {
            case LTU:
            case UNLT:
              operands[4] = x8;
              x23 = XEXP (x8, 1);
              if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x9 = XEXP (x3, 1);
              x10 = XEXP (x9, 0);
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != MINUS)
                return -1;
              x21 = XEXP (x11, 1);
              switch (GET_CODE (x21))
                {
                case LTU:
                case UNLT:
                  operands[5] = x21;
                  x24 = XEXP (x21, 1);
                  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                    return -1;
                  x14 = XVECEXP (x1, 0, 1);
                  x15 = XEXP (x14, 1);
                  x16 = XEXP (x15, 0);
                  if (GET_CODE (x16) != MINUS)
                    return -1;
                  x22 = XEXP (x16, 1);
                  switch (GET_CODE (x22))
                    {
                    case LTU:
                    case UNLT:
                      if (!rtx_equal_p (x22, operands[5]))
                        return -1;
                      x18 = XEXP (x6, 0);
                      operands[1] = x18;
                      x19 = XEXP (x8, 0);
                      operands[3] = x19;
                      if (!flags_reg_operand (operands[3], E_VOIDmode))
                        return -1;
                      x12 = XEXP (x11, 0);
                      if (!rtx_equal_p (x12, operands[1]))
                        return -1;
                      x25 = XEXP (x21, 0);
                      if (!rtx_equal_p (x25, operands[3]))
                        return -1;
                      x17 = XEXP (x16, 0);
                      if (!rtx_equal_p (x17, operands[1]))
                        return -1;
                      switch (pattern1839 (x1))
                        {
                        case 0:
                          if (pattern1860 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 8606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 437; /* *subvqi4_overflow_1 */

                        case 1:
                          if (pattern1860 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 8606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 438; /* *subvhi4_overflow_1 */

                        case 2:
                          if (pattern1861 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 8606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 439; /* *subvsi4_overflow_1 */

                        case 3:
                          if (pattern1861 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 8606 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 440; /* *subvdi4_overflow_1 */

                        case 4:
                          if (pattern1862 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 8639 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 441; /* *subvqi4_overflow_2 */

                        case 5:
                          if (pattern1862 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 8639 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 442; /* *subvhi4_overflow_2 */

                        case 6:
                          if (pattern1862 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 8639 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 443; /* *subvsi4_overflow_2 */

                        case 7:
                          if (pattern1862 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 8639 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 444; /* *subvdi4_overflow_2 */

                        default:
                          return -1;
                        }

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MULT:
      if (pattern679 (x1, 
MULT) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != SIGN_EXTEND)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MULT)
            return -1;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          x11 = XEXP (x10, 0);
          if (!rtx_equal_p (x11, operands[1]))
            return -1;
          x14 = XVECEXP (x1, 0, 1);
          x15 = XEXP (x14, 1);
          x16 = XEXP (x15, 0);
          if (!rtx_equal_p (x16, operands[1]))
            return -1;
          x26 = XEXP (x4, 1);
          switch (GET_CODE (x26))
            {
            case SIGN_EXTEND:
              x27 = XEXP (x26, 0);
              operands[2] = x27;
              x28 = XEXP (x10, 1);
              if (!rtx_equal_p (x28, operands[2]))
                return -1;
              x29 = XEXP (x15, 1);
              if (!rtx_equal_p (x29, operands[2]))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_DImode:
                  if (pattern1779 (x1, 
E_SImode, 
E_DImode) != 0
                      || !
#line 10754 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 604; /* *mulvsi4 */

                case E_TImode:
                  if (pattern1779 (x1, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 10754 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 605; /* *mulvdi4 */

                case E_SImode:
                  if (pattern1780 (x1, 
E_HImode, 
E_SImode) != 0
                      || !
#line 10790 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 606; /* *mulvhi4 */

                case E_HImode:
                  if (pattern1780 (x1, 
E_QImode, 
E_HImode) != 0
                      || !
#line 10928 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 613; /* *mulvqi4 */

                default:
                  return -1;
                }

            case CONST_INT:
              operands[3] = x26;
              x28 = XEXP (x10, 1);
              operands[2] = x28;
              x29 = XEXP (x15, 1);
              if (!rtx_equal_p (x29, operands[2]))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_SImode:
                  if (GET_MODE (x5) != E_SImode
                      || !nonimmediate_operand (operands[1], E_HImode)
                      || !const_int_operand (operands[3], E_SImode)
                      || GET_MODE (x9) != E_SImode
                      || GET_MODE (x10) != E_HImode
                      || !immediate_operand (operands[2], E_HImode)
                      || !register_operand (operands[0], E_HImode)
                      || GET_MODE (x15) != E_HImode
                      || !
#line 10814 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                    return -1;
                  return 607; /* *mulvhi4_1 */

                case E_DImode:
                  if (pattern1781 (x1, 
E_SImode, 
E_DImode) != 0
                      || !
#line 10814 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                    return -1;
                  return 608; /* *mulvsi4_1 */

                case E_TImode:
                  if (pattern1781 (x1, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 10814 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 609; /* *mulvdi4_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case ZERO_EXTEND:
          x26 = XEXP (x4, 1);
          if (GET_CODE (x26) != ZERO_EXTEND)
            return -1;
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != ZERO_EXTEND)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MULT)
            return -1;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          x27 = XEXP (x26, 0);
          operands[2] = x27;
          x11 = XEXP (x10, 0);
          if (!rtx_equal_p (x11, operands[1]))
            return -1;
          x28 = XEXP (x10, 1);
          if (!rtx_equal_p (x28, operands[2]))
            return -1;
          x14 = XVECEXP (x1, 0, 1);
          x15 = XEXP (x14, 1);
          x16 = XEXP (x15, 0);
          if (!rtx_equal_p (x16, operands[1]))
            return -1;
          x29 = XEXP (x15, 1);
          if (!rtx_equal_p (x29, operands[2]))
            return -1;
          switch (GET_MODE (x4))
            {
            case E_SImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_HImode, 
E_SImode) != 0
                  || !
#line 10884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              *pnum_clobbers = 1;
              return 610; /* *umulvhi4 */

            case E_DImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_SImode, 
E_DImode) != 0
                  || !
#line 10884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              *pnum_clobbers = 1;
              return 611; /* *umulvsi4 */

            case E_TImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_DImode, 
E_TImode) != 0
                  || !(
#line 10884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 612; /* *umulvdi4 */

            case E_HImode:
              if (pattern1780 (x1, 
E_QImode, 
E_HImode) != 0
                  || !
#line 10928 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 614; /* *umulvqi4 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      switch (pattern681 (x1))
        {
        case 0:
          if (!
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
            return -1;
          return 1440; /* *btsi_setncqi_2 */

        case 1:
          if (!(
#line 19416 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1441; /* *btdi_setncqi_2 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_V2SFmode))
        return -1;
      x14 = XVECEXP (x1, 0, 1);
      if (pattern383 (x14, 
110, 
0) != 0)
        return -1;
      x30 = XEXP (x2, 0);
      operands[0] = x30;
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode)
        return -1;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      if (!nonimmediate_operand (operands[2], E_V2SFmode)
          || !
#line 1203 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (EQ, V2SFmode, operands)))
        return -1;
      return 2069; /* *mmx_eqv2sf3 */

    default:
      return -1;
    }
}

 int
recog_407 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x2, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_DImode))
    return -1;
  x5 = XEXP (x3, 0);
  if (GET_MODE (x5) != E_SImode)
    return -1;
  switch (GET_CODE (x5))
    {
    case CTZ:
      switch (pattern925 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 21193 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1520; /* *ctzsidi2_sext */

        case 1:
          if (!
#line 21233 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1522; /* *ctzsidi2_sext_falsedep */

        default:
          return -1;
        }

    case XOR:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MINUS
          || GET_MODE (x6) != E_SImode)
        return -1;
      x7 = XEXP (x6, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
        return -1;
      x8 = XEXP (x6, 1);
      if (GET_CODE (x8) != CLZ
          || GET_MODE (x8) != E_SImode)
        return -1;
      x9 = XEXP (x5, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
        return -1;
      x10 = XVECEXP (x1, 0, 1);
      if (pattern231 (x10, 
E_CCmode, 
17) != 0)
        return -1;
      x11 = XEXP (x8, 0);
      operands[1] = x11;
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !
#line 21365 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()))
        return -1;
      return 1531; /* *bsr_2 */

    default:
      return -1;
    }
}

 int
recog_412 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (pattern383 (x5, 
174, 
0) != 0)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  x7 = XEXP (x4, 0);
  operands[1] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DImode:
      if (pattern1230 (x3, 
E_V8DImode, 
E_QImode, 
E_DImode) != 0
          || !(
#line 28101 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 623 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9272; /* avx512cd_maskb_vec_dupv8di */

    case E_V4DImode:
      if (pattern1230 (x3, 
E_V4DImode, 
E_QImode, 
E_DImode) != 0
          || !(
#line 28101 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 623 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9273; /* avx512cd_maskb_vec_dupv4di */

    case E_V2DImode:
      if (pattern1230 (x3, 
E_V2DImode, 
E_QImode, 
E_DImode) != 0
          || !(
#line 28101 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 623 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9274; /* avx512cd_maskb_vec_dupv2di */

    case E_V16SImode:
      if (pattern1230 (x3, 
E_V16SImode, 
E_HImode, 
E_SImode) != 0
          || !(
#line 28113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9275; /* avx512cd_maskw_vec_dupv16si */

    case E_V8SImode:
      if (pattern1230 (x3, 
E_V8SImode, 
E_HImode, 
E_SImode) != 0
          || !(
#line 28113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9276; /* avx512cd_maskw_vec_dupv8si */

    case E_V4SImode:
      if (pattern1230 (x3, 
E_V4SImode, 
E_HImode, 
E_SImode) != 0
          || !(
#line 28113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9277; /* avx512cd_maskw_vec_dupv4si */

    default:
      return -1;
    }
}

 int
recog_417 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x2, 0);
  if (!register_operand (x4, E_DImode))
    return -1;
  x5 = XEXP (x3, 0);
  if (GET_MODE (x5) != E_SImode)
    return -1;
  switch (GET_CODE (x5))
    {
    case SMUL_HIGHPART:
      if (pattern819 (x1) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 631; /* *smulsi3_highpart_zext */

    case UMUL_HIGHPART:
      if (pattern819 (x1) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 632; /* *umulsi3_highpart_zext */

    case TRUNCATE:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != LSHIFTRT
          || GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != MULT
          || GET_MODE (x7) != E_DImode)
        return -1;
      x8 = XEXP (x6, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 32])
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != CLOBBER
          || pattern821 (x1) != 0)
        return -1;
      x10 = XEXP (x7, 0);
      if (GET_MODE (x10) != E_DImode)
        return -1;
      x11 = XEXP (x7, 1);
      if (GET_MODE (x11) != E_DImode)
        return -1;
      x12 = XEXP (x9, 0);
      operands[3] = x12;
      if (!scratch_operand (operands[3], E_SImode))
        return -1;
      switch (GET_CODE (x10))
        {
        case SIGN_EXTEND:
          if (GET_CODE (x11) != SIGN_EXTEND)
            return -1;
          x13 = XEXP (x10, 0);
          operands[1] = x13;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x14 = XEXP (x11, 0);
          operands[2] = x14;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 635; /* *smulsi3_highpart_zext */

        case ZERO_EXTEND:
          if (GET_CODE (x11) != ZERO_EXTEND)
            return -1;
          x13 = XEXP (x10, 0);
          operands[1] = x13;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x14 = XEXP (x11, 0);
          operands[2] = x14;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 636; /* *umulsi3_highpart_zext */

        default:
          return -1;
        }

    case DIV:
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      x15 = XEXP (x9, 1);
      if (GET_CODE (x15) != MOD
          || GET_MODE (x15) != E_SImode)
        return -1;
      operands[0] = x4;
      x6 = XEXP (x5, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x16 = XEXP (x5, 1);
      operands[3] = x16;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x12 = XEXP (x9, 0);
      operands[1] = x12;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      switch (pattern1614 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 11497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 643; /* divmodsi4_zext_1 */

        case 1:
          if (!
#line 11696 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 655; /* *divmodsi4_zext_1 */

        case 2:
          if (!
#line 11892 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 673; /* *divmodsi4_noext_zext_1 */

        default:
          return -1;
        }

    case UDIV:
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      x15 = XEXP (x9, 1);
      if (GET_CODE (x15) != UMOD
          || GET_MODE (x15) != E_SImode)
        return -1;
      operands[0] = x4;
      x6 = XEXP (x5, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x16 = XEXP (x5, 1);
      operands[3] = x16;
      x12 = XEXP (x9, 0);
      operands[1] = x12;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      switch (pattern1553 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 11533 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 644; /* udivmodsi4_zext_1 */

        case 1:
          if (!
#line 11731 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 656; /* *udivmodsi4_zext_1 */

        case 2:
          if (!
#line 11892 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 674; /* *udivmodsi4_noext_zext_1 */

        case 3:
          if (!
#line 11753 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          return 657; /* *udivmodsi4_pow2_zext_1 */

        default:
          return -1;
        }

    case MOD:
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      x15 = XEXP (x9, 1);
      if (GET_CODE (x15) != DIV
          || GET_MODE (x15) != E_SImode)
        return -1;
      operands[1] = x4;
      x6 = XEXP (x5, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x16 = XEXP (x5, 1);
      operands[3] = x16;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x12 = XEXP (x9, 0);
      operands[0] = x12;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      switch (pattern1614 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 11556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 645; /* divmodsi4_zext_2 */

        case 1:
          if (!
#line 11779 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 658; /* *divmodsi4_zext_2 */

        case 2:
          if (!
#line 11906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 675; /* *divmodsi4_noext_zext_2 */

        default:
          return -1;
        }

    case UMOD:
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      x15 = XEXP (x9, 1);
      if (GET_CODE (x15) != UDIV
          || GET_MODE (x15) != E_SImode)
        return -1;
      operands[1] = x4;
      x6 = XEXP (x5, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x16 = XEXP (x5, 1);
      operands[3] = x16;
      x12 = XEXP (x9, 0);
      operands[0] = x12;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      switch (pattern1553 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 11593 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 646; /* udivmodsi4_zext_2 */

        case 1:
          if (!
#line 11815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 659; /* *udivmodsi4_zext_2 */

        case 2:
          if (!
#line 11906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 676; /* *udivmodsi4_noext_zext_2 */

        case 3:
          if (!
#line 11837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          return 660; /* *udivmodsi4_pow2_zext_2 */

        default:
          return -1;
        }

    case CTZ:
      if (pattern820 (x1) != 0
          || !
#line 21233 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 1523; /* *ctzsidi2_uext_falsedep */

    case CLZ:
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != UNSPEC
          || XVECLEN (x9, 0) != 1
          || XINT (x9, 1) != 38)
        return -1;
      x17 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x17) != CLOBBER)
        return -1;
      x18 = XEXP (x17, 0);
      if (GET_CODE (x18) != REG
          || REGNO (x18) != 17
          || GET_MODE (x18) != E_CCmode)
        return -1;
      operands[0] = x4;
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      x19 = XVECEXP (x9, 0, 0);
      switch (pattern1409 (x19))
        {
        case 0:
          if (!
#line 21653 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          return 1544; /* *clzsi2_lzcnt_zext_2_falsedep */

        case 1:
          if (!(
#line 21653 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1545; /* *clzsi2_lzcnt_zext_2_falsedep */

        default:
          return -1;
        }

    case POPCOUNT:
      if (pattern820 (x1) != 0
          || !
#line 22496 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
        return -1;
      return 1635; /* *popcountsi2_zext_2_falsedep */

    default:
      return -1;
    }
}

 int
recog_430 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case IF_THEN_ELSE:
      res = recog_2 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case COMPARE:
      res = recog_5 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UNSPEC:
      res = recog_14 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      res = recog_18 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      res = recog_20 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case LSHIFTRT:
      res = recog_21 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ASHIFTRT:
      res = recog_22 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case IOR:
      res = recog_23 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case XOR:
      res = recog_24 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ZERO_EXTEND:
      res = recog_26 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SIGN_EXTEND:
      res = recog_27 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FLOAT_EXTEND:
      res = recog_28 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FLOAT_TRUNCATE:
      res = recog_29 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FIX:
      res = recog_30 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UNSIGNED_FIX:
      res = recog_31 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FLOAT:
      res = recog_32 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UNSIGNED_FLOAT:
      res = recog_33 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case AND:
      res = recog_37 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NOT:
      res = recog_38 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NEG:
      res = recog_39 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ABS:
      res = recog_40 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ASHIFT:
      res = recog_41 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ROTATE:
      res = recog_42 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ROTATERT:
      res = recog_43 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      res = recog_49 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case POPCOUNT:
      res = recog_50 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case BSWAP:
      if (GET_MODE (x2) == E_HImode)
        {
          x3 = XEXP (x1, 0);
          operands[0] = x3;
          x4 = XEXP (x2, 0);
          operands[1] = x4;
          if (nonimmediate_operand (operands[1], E_HImode)
              && nonimmediate_operand (operands[0], E_HImode)
              && 
#line 22627 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVBE
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return 1644; /* *bswaphi2_movbe */
          if (register_operand (operands[1], E_HImode)
              && register_operand (operands[0], E_HImode)
              && 
#line 22646 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_MOVBE))
            return 1645; /* *bswaphi2 */
        }
      break;

    case PLUS:
    case MINUS:
    case MULT:
    case DIV:
      res = recog_57 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SQRT:
      res = recog_351 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SMAX:
      switch (pattern9 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 26761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return 1815; /* smaxsf3 */
          break;

        case 1:
          if (
#line 26761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return 1817; /* smaxdf3 */
          break;

        case 2:
          if (
#line 26775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return 1819; /* smaxhf3 */
          break;

        case 3:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1835; /* *smaxti3_doubleword */
            }
          break;

        case 4:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1839; /* *smaxqi3_1 */
            }
          break;

        case 5:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1843; /* *smaxhi3_1 */
            }
          break;

        case 6:
          if (
#line 3659 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2168; /* smaxv8qi3 */
          break;

        case 7:
          if (
#line 3659 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2170; /* smaxv2si3 */
          break;

        case 8:
          if (
#line 3684 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (SMAX, V4HImode, operands)))
            return 2172; /* *mmx_smaxv4hi3 */
          break;

        case 9:
          if (
#line 3708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2174; /* smaxv4qi3 */
          break;

        case 10:
          if (
#line 3708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2176; /* smaxv2qi3 */
          break;

        case 11:
          if (
#line 3724 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2178; /* smaxv2hi3 */
          break;

        default:
          break;
        }
      break;

    case SMIN:
      switch (pattern9 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 26761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return 1816; /* sminsf3 */
          break;

        case 1:
          if (
#line 26761 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return 1818; /* smindf3 */
          break;

        case 2:
          if (
#line 26775 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return 1820; /* sminhf3 */
          break;

        case 3:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1836; /* *sminti3_doubleword */
            }
          break;

        case 4:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1840; /* *sminqi3_1 */
            }
          break;

        case 5:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1844; /* *sminhi3_1 */
            }
          break;

        case 6:
          if (
#line 3659 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2169; /* sminv8qi3 */
          break;

        case 7:
          if (
#line 3659 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2171; /* sminv2si3 */
          break;

        case 8:
          if (
#line 3684 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (SMIN, V4HImode, operands)))
            return 2173; /* *mmx_sminv4hi3 */
          break;

        case 9:
          if (
#line 3708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2175; /* sminv4qi3 */
          break;

        case 10:
          if (
#line 3708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2177; /* sminv2qi3 */
          break;

        case 11:
          if (
#line 3724 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2179; /* sminv2hi3 */
          break;

        default:
          break;
        }
      break;

    case UMAX:
      switch (pattern10 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1837; /* *umaxti3_doubleword */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1841; /* *umaxqi3_1 */
            }
          break;

        case 2:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1845; /* *umaxhi3_1 */
            }
          break;

        case 3:
          if (
#line 3737 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2180; /* umaxv4hi3 */
          break;

        case 4:
          if (
#line 3737 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2182; /* umaxv2si3 */
          break;

        case 5:
          if (
#line 3762 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (UMAX, V8QImode, operands)))
            return 2184; /* *mmx_umaxv8qi3 */
          break;

        case 6:
          if (
#line 3786 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2186; /* umaxv4qi3 */
          break;

        case 7:
          if (
#line 3786 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2188; /* umaxv2qi3 */
          break;

        case 8:
          if (
#line 3799 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2190; /* umaxv2hi3 */
          break;

        default:
          break;
        }
      break;

    case UMIN:
      switch (pattern10 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1838; /* *uminti3_doubleword */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1842; /* *uminqi3_1 */
            }
          break;

        case 2:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1846; /* *uminhi3_1 */
            }
          break;

        case 3:
          if (
#line 3737 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2181; /* uminv4hi3 */
          break;

        case 4:
          if (
#line 3737 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2183; /* uminv2si3 */
          break;

        case 5:
          if (
#line 3762 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (UMIN, V8QImode, operands)))
            return 2185; /* *mmx_uminv8qi3 */
          break;

        case 6:
          if (
#line 3786 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2187; /* uminv4qi3 */
          break;

        case 7:
          if (
#line 3786 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2189; /* uminv2qi3 */
          break;

        case 8:
          if (
#line 3799 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2191; /* uminv2hi3 */
          break;

        default:
          break;
        }
      break;

    case UNSPEC_VOLATILE:
      res = recog_58 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case VEC_CONCAT:
      res = recog_59 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case VEC_MERGE:
      res = recog_60 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case VEC_SELECT:
      res = recog_62 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case VEC_DUPLICATE:
      res = recog_63 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SS_PLUS:
      res = recog_64 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case US_PLUS:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern45 (x2))
        {
        case 0:
          if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (US_PLUS, V8QImode, operands)))
            return 2139; /* *mmx_usaddv8qi3 */
          break;

        case 1:
          if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (US_PLUS, V4HImode, operands)))
            return 2143; /* *mmx_usaddv4hi3 */
          break;

        case 2:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2147; /* usaddv4qi3 */
          break;

        case 3:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2151; /* usaddv2qi3 */
          break;

        case 4:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2155; /* usaddv2hi3 */
          break;

        default:
          break;
        }
      break;

    case SS_MINUS:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
          switch (pattern45 (x2))
            {
            case 0:
              if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_MINUS, V8QImode, operands)))
                return 2140; /* *mmx_sssubv8qi3 */
              break;

            case 1:
              if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_MINUS, V4HImode, operands)))
                return 2144; /* *mmx_sssubv4hi3 */
              break;

            case 2:
              if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return 2148; /* sssubv4qi3 */
              break;

            case 3:
              if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return 2152; /* sssubv2qi3 */
              break;

            case 4:
              if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return 2156; /* sssubv2hi3 */
              break;

            default:
              break;
            }
          break;

        case VEC_SELECT:
          if (pattern101 (x2) == 0
              && 
#line 22618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return 8525; /* ssse3_phsubswv4hi3 */
          break;

        default:
          break;
        }
      break;

    case US_MINUS:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern45 (x2))
        {
        case 0:
          if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (US_MINUS, V8QImode, operands)))
            return 2141; /* *mmx_ussubv8qi3 */
          break;

        case 1:
          if (
#line 3323 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (US_MINUS, V4HImode, operands)))
            return 2145; /* *mmx_ussubv4hi3 */
          break;

        case 2:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2149; /* ussubv4qi3 */
          break;

        case 3:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2153; /* ussubv2qi3 */
          break;

        case 4:
          if (
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2157; /* ussubv2hi3 */
          break;

        default:
          break;
        }
      break;

    case TRUNCATE:
      res = recog_65 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FMA:
      res = recog_66 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SS_TRUNCATE:
      switch (pattern13 (x1))
        {
        case 0:
          if (
#line 15386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7222; /* *avx512vl_ss_truncatev2div2qi2_store_1 */
          break;

        case 1:
          if (
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7237; /* *avx512vl_ss_truncatev4siv4qi2_store_1 */
          break;

        case 2:
          if (
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7240; /* *avx512vl_ss_truncatev4div4qi2_store_1 */
          break;

        case 3:
          if ((
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 7267; /* *avx512vl_ss_truncatev8hiv8qi2_store_1 */
          break;

        case 4:
          if (
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7270; /* *avx512vl_ss_truncatev8siv8qi2_store_1 */
          break;

        case 5:
          if (
#line 16095 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return 7374; /* *avx512f_ss_truncatev8div16qi2_store_1 */
          break;

        case 6:
          if (
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7307; /* *avx512vl_ss_truncatev4siv4hi2_store_1 */
          break;

        case 7:
          if (
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7310; /* *avx512vl_ss_truncatev4div4hi2_store_1 */
          break;

        case 8:
          if (
#line 15832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7337; /* *avx512vl_ss_truncatev2div2hi2_store_1 */
          break;

        case 9:
          if (
#line 15982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7356; /* *avx512vl_ss_truncatev2div2si2_store_1 */
          break;

        default:
          break;
        }
      break;

    case US_TRUNCATE:
      switch (pattern13 (x1))
        {
        case 0:
          if (
#line 15386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7224; /* *avx512vl_us_truncatev2div2qi2_store_1 */
          break;

        case 1:
          if (
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7239; /* *avx512vl_us_truncatev4siv4qi2_store_1 */
          break;

        case 2:
          if (
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7242; /* *avx512vl_us_truncatev4div4qi2_store_1 */
          break;

        case 3:
          if ((
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 7269; /* *avx512vl_us_truncatev8hiv8qi2_store_1 */
          break;

        case 4:
          if (
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7272; /* *avx512vl_us_truncatev8siv8qi2_store_1 */
          break;

        case 5:
          if (
#line 16095 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return 7376; /* *avx512f_us_truncatev8div16qi2_store_1 */
          break;

        case 6:
          if (
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7309; /* *avx512vl_us_truncatev4siv4hi2_store_1 */
          break;

        case 7:
          if (
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7312; /* *avx512vl_us_truncatev4div4hi2_store_1 */
          break;

        case 8:
          if (
#line 15832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7339; /* *avx512vl_us_truncatev2div2hi2_store_1 */
          break;

        case 9:
          if (
#line 15982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return 7358; /* *avx512vl_us_truncatev2div2si2_store_1 */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_XImode:
      if (nonimmediate_operand (operands[0], E_XImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_XImode)
          && 
#line 2463 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512F && TARGET_EVEX512
   && (register_operand (operands[0], XImode)
       || register_operand (operands[1], XImode))))
        return 92; /* *movxi_internal_avx512f */
      break;

    case E_OImode:
      if (nonimmediate_operand (operands[0], E_OImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_OImode)
          && 
#line 2486 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX
   && (register_operand (operands[0], OImode)
       || register_operand (operands[1], OImode))))
        return 93; /* *movoi_internal_avx */
      break;

    case E_SImode:
      if (register_operand (operands[0], E_SImode)
          && address_no_seg_operand (operands[1], E_SImode)
          && 
#line 6384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 264; /* *leasi */
      break;

    case E_DImode:
      if (register_operand (operands[0], E_DImode)
          && address_no_seg_operand (operands[1], E_DImode)
          && (
#line 6384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 265; /* *leadi */
      break;

    default:
      break;
    }
  switch (GET_CODE (x2))
    {
    case PLUS:
      res = recog_67 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ZERO_EXTEND:
      res = recog_75 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case COMPARE:
      res = recog_76 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case IOR:
      res = recog_80 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case XOR:
      res = recog_81 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case MINUS:
      res = recog_83 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case IF_THEN_ELSE:
      res = recog_86 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case MULT:
      res = recog_87 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SMUL_HIGHPART:
      switch (pattern15 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            {
              *pnum_clobbers = 2;
              return 627; /* smulsi3_highpart */
            }
          break;

        case 1:
          if (
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            {
              *pnum_clobbers = 2;
              return 629; /* smuldi3_highpart */
            }
          break;

        default:
          break;
        }
      break;

    case UMUL_HIGHPART:
      switch (pattern15 (x1, pnum_clobbers))
        {
        case 0:
          if (
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            {
              *pnum_clobbers = 2;
              return 628; /* umulsi3_highpart */
            }
          break;

        case 1:
          if (
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            {
              *pnum_clobbers = 2;
              return 630; /* umuldi3_highpart */
            }
          break;

        default:
          break;
        }
      break;

    case TRUNCATE:
      res = recog_88 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case AND:
      res = recog_90 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NOT:
      res = recog_91 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NEG:
      res = recog_92 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ABS:
      res = recog_93 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ASHIFT:
      res = recog_95 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case LSHIFTRT:
      res = recog_97 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ASHIFTRT:
      res = recog_99 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SUBREG:
      res = recog_100 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ROTATE:
      res = recog_101 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ROTATERT:
      res = recog_102 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case ZERO_EXTRACT:
      res = recog_104 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      res = recog_105 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UNSPEC:
      res = recog_109 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case CALL:
      res = recog_110 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FFS:
      if (pnum_clobbers != NULL
          && GET_MODE (x2) == E_SImode)
        {
          operands[0] = x3;
          if (register_operand (operands[0], E_SImode))
            {
              x4 = XEXP (x2, 0);
              operands[1] = x4;
              if (nonimmediate_operand (operands[1], E_SImode)
                  && 
#line 20997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_CMOVE))
                {
                  *pnum_clobbers = 2;
                  return 1507; /* ffssi2_no_cmove */
                }
            }
        }
      break;

    case CTZ:
      res = recog_111 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SIGN_EXTEND:
      res = recog_112 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case CLZ:
      res = recog_113 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case POPCOUNT:
      res = recog_114 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case BSWAP:
      res = recog_352 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SIGN_EXTRACT:
      res = recog_115 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SMAX:
      switch (pattern21 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1831; /* *smaxdi3_doubleword */
            }
          if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1851; /* *smaxdi3_1 */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1847; /* *smaxsi3_1 */
            }
          break;

        default:
          break;
        }
      break;

    case SMIN:
      switch (pattern21 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1832; /* *smindi3_doubleword */
            }
          if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1852; /* *smindi3_1 */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1848; /* *sminsi3_1 */
            }
          break;

        default:
          break;
        }
      break;

    case UMAX:
      switch (pattern21 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1833; /* *umaxdi3_doubleword */
            }
          if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1853; /* *umaxdi3_1 */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1849; /* *umaxsi3_1 */
            }
          break;

        default:
          break;
        }
      break;

    case UMIN:
      switch (pattern21 (x1, pnum_clobbers))
        {
        case 0:
          if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1834; /* *umindi3_doubleword */
            }
          if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1854; /* *umindi3_1 */
            }
          break;

        case 1:
          if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            {
              *pnum_clobbers = 1;
              return 1850; /* *uminsi3_1 */
            }
          break;

        default:
          break;
        }
      break;

    case UNSPEC_VOLATILE:
      res = recog_116 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case VEC_SELECT:
      res = recog_119 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case FIX:
      switch (pattern24 (x1))
        {
        case 0:
          if (
#line 7992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return 4634; /* avx512fp16_fix_truncsi2 */
          break;

        case 1:
          if (
#line 8586 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return 4733; /* sse_cvttss2si */
          break;

        case 2:
          if (
#line 9131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return 4868; /* sse2_cvttsd2si */
          break;

        case 3:
          if ((
#line 7992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4638; /* avx512fp16_fix_truncdi2 */
          break;

        case 4:
          if ((
#line 8586 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4735; /* sse_cvttss2siq */
          break;

        case 5:
          if ((
#line 9131 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4870; /* sse2_cvttsd2siq */
          break;

        case 6:
          if (
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return 4642; /* avx512fp16_fix_truncsi2_mem */
          break;

        case 7:
          if ((
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4644; /* avx512fp16_fix_truncdi2_mem */
          break;

        default:
          break;
        }
      break;

    case UNSIGNED_FIX:
      switch (pattern24 (x1))
        {
        case 0:
          if (
#line 7992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return 4636; /* avx512fp16_fixuns_truncsi2 */
          break;

        case 1:
          if (
#line 9036 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 4842; /* avx512f_vcvttss2usi */
          break;

        case 2:
          if (
#line 9072 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 4854; /* avx512f_vcvttsd2usi */
          break;

        case 3:
          if ((
#line 7992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4640; /* avx512fp16_fixuns_truncdi2 */
          break;

        case 4:
          if ((
#line 9036 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4844; /* avx512f_vcvttss2usiq */
          break;

        case 5:
          if ((
#line 9072 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4856; /* avx512f_vcvttsd2usiq */
          break;

        case 6:
          if (
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return 4643; /* avx512fp16_fixuns_truncsi2_mem */
          break;

        case 7:
          if ((
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 4645; /* avx512fp16_fixuns_truncdi2_mem */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  res = recog_321 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  switch (GET_CODE (x2))
    {
    case VEC_MERGE:
      return recog_318 (x1, insn, pnum_clobbers);

    case UNSPEC:
      return recog_315 (x1, insn, pnum_clobbers);

    case VEC_CONCAT:
      return recog_314 (x1, insn, pnum_clobbers);

    case PLUS:
      return recog_316 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_340 (x1, insn, pnum_clobbers);

    case MULT:
      return recog_329 (x1, insn, pnum_clobbers);

    case DIV:
      return recog_347 (x1, insn, pnum_clobbers);

    case SQRT:
      return recog_334 (x1, insn, pnum_clobbers);

    case SMAX:
      return recog_336 (x1, insn, pnum_clobbers);

    case SMIN:
      return recog_337 (x1, insn, pnum_clobbers);

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      return recog_350 (x1, insn, pnum_clobbers);

    case FMA:
      return recog_322 (x1, insn, pnum_clobbers);

    case FLOAT:
      return recog_328 (x1, insn, pnum_clobbers);

    case UNSIGNED_FLOAT:
      return recog_333 (x1, insn, pnum_clobbers);

    case FIX:
      return recog_342 (x1, insn, pnum_clobbers);

    case UNSIGNED_FIX:
      return recog_341 (x1, insn, pnum_clobbers);

    case FLOAT_EXTEND:
      return recog_323 (x1, insn, pnum_clobbers);

    case FLOAT_TRUNCATE:
      return recog_345 (x1, insn, pnum_clobbers);

    case VEC_SELECT:
      return recog_317 (x1, insn, pnum_clobbers);

    case VEC_DUPLICATE:
      return recog_319 (x1, insn, pnum_clobbers);

    case AND:
    case IOR:
    case XOR:
    case NOT:
      return recog_339 (x1, insn, pnum_clobbers);

    case SS_TRUNCATE:
      operands[0] = x3;
      switch (pattern50 (x2))
        {
        case 0:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7150; /* *avx512f_ss_truncatev16siv16qi2 */

        case 1:
          if (!(
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7192; /* *avx512vl_ss_truncatev16hiv16qi2 */

        case 2:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7153; /* *avx512f_ss_truncatev16siv16hi2 */

        case 3:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7156; /* *avx512f_ss_truncatev8div8si2 */

        case 4:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7159; /* *avx512f_ss_truncatev8div8hi2 */

        case 5:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7189; /* *avx512vl_ss_truncatev8siv8hi2 */

        case 6:
          if (!
#line 15147 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
            return -1;
          return 7179; /* avx512bw_ss_truncatev32hiv32qi2 */

        case 7:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7186; /* *avx512vl_ss_truncatev4div4si2 */

        default:
          return -1;
        }

    case TRUNCATE:
      return recog_335 (x1, insn, pnum_clobbers);

    case US_TRUNCATE:
      operands[0] = x3;
      switch (pattern50 (x2))
        {
        case 0:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7152; /* *avx512f_us_truncatev16siv16qi2 */

        case 1:
          if (!(
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 7194; /* *avx512vl_us_truncatev16hiv16qi2 */

        case 2:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7155; /* *avx512f_us_truncatev16siv16hi2 */

        case 3:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7158; /* *avx512f_us_truncatev8div8si2 */

        case 4:
          if (!
#line 14974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 7161; /* *avx512f_us_truncatev8div8hi2 */

        case 5:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7191; /* *avx512vl_us_truncatev8siv8hi2 */

        case 6:
          if (!
#line 15147 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
            return -1;
          return 7181; /* avx512bw_us_truncatev32hiv32qi2 */

        case 7:
          if (!
#line 15236 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7188; /* *avx512vl_us_truncatev4div4si2 */

        default:
          return -1;
        }

    case SS_PLUS:
      return recog_320 (x1, insn, pnum_clobbers);

    case US_PLUS:
      operands[0] = x3;
      switch (pattern51 (x2))
        {
        case 0:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7439; /* *avx512bw_usaddv64qi3 */

        case 1:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7447; /* *avx2_usaddv32qi3 */

        case 2:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V16QImode, operands)))
            return -1;
          return 7455; /* *sse2_usaddv16qi3 */

        case 3:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7463; /* *avx512bw_usaddv32hi3 */

        case 4:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7471; /* *avx2_usaddv16hi3 */

        case 5:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_PLUS, V8HImode, operands)))
            return -1;
          return 7479; /* *sse2_usaddv8hi3 */

        default:
          return -1;
        }

    case SS_MINUS:
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
          switch (pattern51 (x2))
            {
            case 0:
              if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7441; /* *avx512bw_sssubv64qi3 */

            case 1:
              if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return -1;
              return 7449; /* *avx2_sssubv32qi3 */

            case 2:
              if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V16QImode, operands)))
                return -1;
              return 7457; /* *sse2_sssubv16qi3 */

            case 3:
              if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7465; /* *avx512bw_sssubv32hi3 */

            case 4:
              if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return -1;
              return 7473; /* *avx2_sssubv16hi3 */

            case 5:
              if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (SS_MINUS, V8HImode, operands)))
                return -1;
              return 7481; /* *sse2_sssubv8hi3 */

            default:
              return -1;
            }

        case VEC_SELECT:
          switch (pattern196 (x2))
            {
            case 0:
              if (!
#line 22570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 8517; /* avx2_phsubswv16hi3 */

            case 1:
              if (!
#line 22593 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
                return -1;
              return 8521; /* ssse3_phsubswv8hi3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case US_MINUS:
      operands[0] = x3;
      switch (pattern51 (x2))
        {
        case 0:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V64QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7443; /* *avx512bw_ussubv64qi3 */

        case 1:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V32QImode, operands)) && 
#line 739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7451; /* *avx2_ussubv32qi3 */

        case 2:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V16QImode, operands)))
            return -1;
          return 7459; /* *sse2_ussubv16qi3 */

        case 3:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V32HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 7467; /* *avx512bw_ussubv32hi3 */

        case 4:
          if (!(
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)) && 
#line 740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7475; /* *avx2_ussubv16hi3 */

        case 5:
          if (!
#line 16304 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1
   && ix86_binary_operator_ok (US_MINUS, V8HImode, operands)))
            return -1;
          return 7483; /* *sse2_ussubv8hi3 */

        default:
          return -1;
        }

    case ASHIFTRT:
      return recog_324 (x1, insn, pnum_clobbers);

    case ASHIFT:
      return recog_326 (x1, insn, pnum_clobbers);

    case LSHIFTRT:
      return recog_325 (x1, insn, pnum_clobbers);

    case ROTATE:
      return recog_349 (x1, insn, pnum_clobbers);

    case ROTATERT:
      return recog_348 (x1, insn, pnum_clobbers);

    case UMAX:
      return recog_344 (x1, insn, pnum_clobbers);

    case UMIN:
      return recog_343 (x1, insn, pnum_clobbers);

    case ABS:
      return recog_332 (x1, insn, pnum_clobbers);

    case SIGN_EXTEND:
      return recog_338 (x1, insn, pnum_clobbers);

    case ZERO_EXTEND:
      return recog_330 (x1, insn, pnum_clobbers);

    case IF_THEN_ELSE:
      return recog_327 (x1, insn, pnum_clobbers);

    case CLZ:
      return recog_346 (x1, insn, pnum_clobbers);

    case POPCOUNT:
      return recog_331 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 rtx_insn *
split_36 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[3] = x3;
  if (promotable_binary_operator (operands[3], E_VOIDmode)
      && pattern340 (x1) == 0
      && general_reg_operand (operands[0], E_VOIDmode))
    {
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (general_reg_operand (operands[1], E_VOIDmode))
        {
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (aligned_operand (operands[2], E_VOIDmode)
              && 
#line 27688 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL && reload_completed
   && ((GET_MODE (operands[0]) == HImode
	&& ((optimize_function_for_speed_p (cfun) && !TARGET_FAST_PREFIX)
            /* ??? next two lines just !satisfies_constraint_K (...) */
	    || !CONST_INT_P (operands[2])
	    || satisfies_constraint_K (operands[2])))
       || (GET_MODE (operands[0]) == QImode
	   && (TARGET_PROMOTE_QImode || optimize_function_for_size_p (cfun))))))
            return gen_split_989 (insn, operands);
        }
    }
  x6 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x6) != CLOBBER)
    return NULL;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return NULL;
  x8 = XEXP (x2, 0);
  operands[0] = x8;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (x3))
    {
    case PLUS:
      if (GET_MODE (x3) != E_V2QImode)
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (general_reg_operand (operands[1], E_V2QImode)
          && general_reg_operand (operands[0], E_V2QImode)
          && general_reg_operand (operands[2], E_V2QImode)
          && 
#line 3260 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
        return gen_split_1054 (insn, operands);
      if (!sse_reg_operand (operands[1], E_V2QImode)
          || !sse_reg_operand (operands[0], E_V2QImode)
          || !sse_reg_operand (operands[2], E_V2QImode)
          || !
#line 3294 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
        return NULL;
      return gen_split_1056 (insn, operands);

    case MINUS:
      if (GET_MODE (x3) != E_V2QImode)
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (general_reg_operand (operands[1], E_V2QImode)
          && general_reg_operand (operands[0], E_V2QImode)
          && general_reg_operand (operands[2], E_V2QImode)
          && 
#line 3260 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
        return gen_split_1055 (insn, operands);
      if (!sse_reg_operand (operands[1], E_V2QImode)
          || !sse_reg_operand (operands[0], E_V2QImode)
          || !sse_reg_operand (operands[2], E_V2QImode)
          || !
#line 3294 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
        return NULL;
      return gen_split_1057 (insn, operands);

    case ASHIFT:
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V2QImode:
          if (pattern1233 (x3, 
E_V2QImode) != 0
              || !
#line 4009 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
            return NULL;
          return gen_split_1065 (insn, operands);

        case E_QImode:
          if (pattern1327 (x3, 
E_QImode) != 0
              || !
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1230 (insn, operands);

        case E_HImode:
          if (pattern1327 (x3, 
E_HImode) != 0
              || !
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1232 (insn, operands);

        case E_SImode:
          if (pattern1327 (x3, 
E_SImode) != 0
              || !(
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1234 (insn, operands);

        case E_DImode:
          if (pattern1327 (x3, 
E_DImode) != 0
              || !(
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1236 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case NOT:
          x9 = XEXP (x4, 0);
          operands[1] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V4QImode:
              if (GET_MODE (x3) != E_V4QImode
                  || GET_MODE (x4) != E_V4QImode)
                return NULL;
              if (general_reg_operand (operands[0], E_V4QImode)
                  && general_reg_operand (operands[1], E_V4QImode)
                  && general_reg_operand (operands[2], E_V4QImode))
                {
                  if (
#line 4622 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_BMI && reload_completed))
                    return gen_split_1081 (insn, operands);
                  if (
#line 4639 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_BMI && reload_completed))
                    return gen_split_1084 (insn, operands);
                }
              if (!sse_reg_operand (operands[0], E_V4QImode)
                  || !sse_reg_operand (operands[1], E_V4QImode)
                  || !sse_reg_operand (operands[2], E_V4QImode)
                  || !
#line 4658 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1087 (insn, operands);

            case E_V2QImode:
              if (GET_MODE (x3) != E_V2QImode
                  || GET_MODE (x4) != E_V2QImode)
                return NULL;
              if (general_reg_operand (operands[0], E_V2QImode)
                  && general_reg_operand (operands[1], E_V2QImode)
                  && general_reg_operand (operands[2], E_V2QImode))
                {
                  if (
#line 4622 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_BMI && reload_completed))
                    return gen_split_1082 (insn, operands);
                  if (
#line 4639 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_BMI && reload_completed))
                    return gen_split_1085 (insn, operands);
                }
              if (!sse_reg_operand (operands[0], E_V2QImode)
                  || !sse_reg_operand (operands[1], E_V2QImode)
                  || !sse_reg_operand (operands[2], E_V2QImode)
                  || !
#line 4658 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1088 (insn, operands);

            case E_V2HImode:
              if (GET_MODE (x3) != E_V2HImode
                  || GET_MODE (x4) != E_V2HImode)
                return NULL;
              if (general_reg_operand (operands[0], E_V2HImode)
                  && general_reg_operand (operands[1], E_V2HImode)
                  && general_reg_operand (operands[2], E_V2HImode))
                {
                  if (
#line 4622 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_BMI && reload_completed))
                    return gen_split_1083 (insn, operands);
                  if (
#line 4639 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_BMI && reload_completed))
                    return gen_split_1086 (insn, operands);
                }
              if (!sse_reg_operand (operands[0], E_V2HImode)
                  || !sse_reg_operand (operands[1], E_V2HImode)
                  || !sse_reg_operand (operands[2], E_V2HImode)
                  || !
#line 4658 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1089 (insn, operands);

            case E_QImode:
              if (pattern1490 (x3, 
E_QImode) != 0
                  || !
#line 2166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1213 (insn, operands);

            case E_HImode:
              if (pattern1490 (x3, 
E_HImode) != 0
                  || !
#line 2166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1214 (insn, operands);

            case E_SImode:
              if (pattern1490 (x3, 
E_SImode) != 0
                  || !(
#line 2166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1215 (insn, operands);

            case E_DImode:
              if (pattern1490 (x3, 
E_DImode) != 0
                  || !(
#line 2166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1216 (insn, operands);

            default:
              return NULL;
            }

        case REG:
        case SUBREG:
        case MEM:
          switch (pattern1237 (x3))
            {
            case 0:
              if (nonimmediate_gr_operand (operands[0], E_V4QImode)
                  && nonimmediate_gr_operand (operands[1], E_V4QImode)
                  && reg_or_const_vector_operand (operands[2], E_V4QImode)
                  && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
                return gen_split_1090 (insn, operands);
              if (!sse_reg_operand (operands[0], E_V4QImode)
                  || !sse_reg_operand (operands[1], E_V4QImode)
                  || !sse_reg_operand (operands[2], E_V4QImode)
                  || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1099 (insn, operands);

            case 1:
              if (nonimmediate_gr_operand (operands[0], E_V2QImode)
                  && nonimmediate_gr_operand (operands[1], E_V2QImode)
                  && reg_or_const_vector_operand (operands[2], E_V2QImode)
                  && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
                return gen_split_1093 (insn, operands);
              if (!sse_reg_operand (operands[0], E_V2QImode)
                  || !sse_reg_operand (operands[1], E_V2QImode)
                  || !sse_reg_operand (operands[2], E_V2QImode)
                  || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1102 (insn, operands);

            case 2:
              if (nonimmediate_gr_operand (operands[0], E_V2HImode)
                  && nonimmediate_gr_operand (operands[1], E_V2HImode)
                  && reg_or_const_vector_operand (operands[2], E_V2HImode)
                  && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
                return gen_split_1096 (insn, operands);
              if (!sse_reg_operand (operands[0], E_V2HImode)
                  || !sse_reg_operand (operands[1], E_V2HImode)
                  || !sse_reg_operand (operands[2], E_V2HImode)
                  || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
                return NULL;
              return gen_split_1105 (insn, operands);

            case 3:
              if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1201 (insn, operands);

            case 4:
              if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1204 (insn, operands);

            case 5:
              if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1207 (insn, operands);

            case 6:
              if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1210 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      switch (pattern1237 (x3))
        {
        case 0:
          if (nonimmediate_gr_operand (operands[0], E_V4QImode)
              && nonimmediate_gr_operand (operands[1], E_V4QImode)
              && reg_or_const_vector_operand (operands[2], E_V4QImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1091 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V4QImode)
              || !sse_reg_operand (operands[1], E_V4QImode)
              || !sse_reg_operand (operands[2], E_V4QImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1100 (insn, operands);

        case 1:
          if (nonimmediate_gr_operand (operands[0], E_V2QImode)
              && nonimmediate_gr_operand (operands[1], E_V2QImode)
              && reg_or_const_vector_operand (operands[2], E_V2QImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1094 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V2QImode)
              || !sse_reg_operand (operands[1], E_V2QImode)
              || !sse_reg_operand (operands[2], E_V2QImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1103 (insn, operands);

        case 2:
          if (nonimmediate_gr_operand (operands[0], E_V2HImode)
              && nonimmediate_gr_operand (operands[1], E_V2HImode)
              && reg_or_const_vector_operand (operands[2], E_V2HImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1097 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V2HImode)
              || !sse_reg_operand (operands[1], E_V2HImode)
              || !sse_reg_operand (operands[2], E_V2HImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1106 (insn, operands);

        case 3:
          if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1202 (insn, operands);

        case 4:
          if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1205 (insn, operands);

        case 5:
          if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1208 (insn, operands);

        case 6:
          if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1211 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern1237 (x3))
        {
        case 0:
          if (nonimmediate_gr_operand (operands[0], E_V4QImode)
              && nonimmediate_gr_operand (operands[1], E_V4QImode)
              && reg_or_const_vector_operand (operands[2], E_V4QImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1092 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V4QImode)
              || !sse_reg_operand (operands[1], E_V4QImode)
              || !sse_reg_operand (operands[2], E_V4QImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1101 (insn, operands);

        case 1:
          if (nonimmediate_gr_operand (operands[0], E_V2QImode)
              && nonimmediate_gr_operand (operands[1], E_V2QImode)
              && reg_or_const_vector_operand (operands[2], E_V2QImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1095 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V2QImode)
              || !sse_reg_operand (operands[1], E_V2QImode)
              || !sse_reg_operand (operands[2], E_V2QImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1104 (insn, operands);

        case 2:
          if (nonimmediate_gr_operand (operands[0], E_V2HImode)
              && nonimmediate_gr_operand (operands[1], E_V2HImode)
              && reg_or_const_vector_operand (operands[2], E_V2HImode)
              && 
#line 4725 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(reload_completed))
            return gen_split_1098 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V2HImode)
              || !sse_reg_operand (operands[1], E_V2HImode)
              || !sse_reg_operand (operands[2], E_V2HImode)
              || !
#line 4749 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1107 (insn, operands);

        case 3:
          if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1203 (insn, operands);

        case 4:
          if (!
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1206 (insn, operands);

        case 5:
          if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1209 (insn, operands);

        case 6:
          if (!(
#line 2130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1212 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_53 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case VEC_SELECT:
      if (GET_MODE (x4) != E_SImode)
        return NULL;
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL
          || XVECLEN (x5, 0) != 1)
        return NULL;
      x6 = XVECEXP (x5, 0, 0);
      if (GET_CODE (x6) != CONST_INT
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x7 = XEXP (x4, 0);
      operands[1] = x7;
      if (XWINT (x6, 0) == 0L)
        {
          switch (GET_MODE (operands[1]))
            {
            case E_V2SImode:
              if (register_operand (operands[1], E_V2SImode)
                  && 
#line 5774 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSE2 && reload_completed))
                return gen_split_1125 (insn, operands);
              break;

            case E_V4SImode:
              if (register_operand (operands[1], E_V4SImode)
                  && 
#line 21226 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
                return gen_split_3398 (insn, operands);
              break;

            default:
              break;
            }
        }
      operands[2] = x6;
      switch (GET_MODE (operands[1]))
        {
        case E_V2SImode:
          if (!memory_operand (operands[1], E_V2SImode)
              || !const_0_to_1_operand (operands[2], E_SImode)
              || !(
#line 5842 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_64BIT) && 
#line 5844 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1127 (insn, operands);

        case E_V4SImode:
          if (!memory_operand (operands[1], E_V4SImode)
              || !const_0_to_3_operand (operands[2], E_SImode)
              || !(
#line 21301 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 21303 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3399 (insn, operands);

        default:
          return NULL;
        }

    case NOT:
      x7 = XEXP (x4, 0);
      switch (GET_CODE (x7))
        {
        case REG:
          operands[1] = x7;
          if (!mask_reg_operand (operands[1], E_SImode)
              || !mask_reg_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_SImode
              || !
#line 2243 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && reload_completed))
            return NULL;
          return gen_split_1221 (insn, operands);

        case SUBREG:
          if (maybe_ne (SUBREG_BYTE (x7), 0)
              || GET_MODE (x7) != E_HImode)
            return NULL;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != UNSPEC
              || XVECLEN (x8, 0) != 1
              || XINT (x8, 1) != 49
              || GET_MODE (x8) != E_SImode
              || !register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_HImode)
            return NULL;
          x9 = XVECEXP (x8, 0, 0);
          operands[1] = x9;
          if (!register_operand (operands[1], E_V16QImode)
              || !
#line 22153 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return NULL;
          return gen_split_3448 (insn, operands);

        default:
          return NULL;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 49
          || GET_MODE (x4) != E_SImode
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x10 = XVECEXP (x4, 0, 0);
      switch (GET_CODE (x10))
        {
        case LT:
          switch (pattern969 (x10))
            {
            case 0:
              if (!((
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22006 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3420 (insn, operands);

            case 1:
              if (!(
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22006 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3422 (insn, operands);

            case 2:
              if (!((
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22006 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3424 (insn, operands);

            case 3:
              if (!((
#line 22004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22006 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3426 (insn, operands);

            case 4:
              if (!((
#line 22264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 22266 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3457 (insn, operands);

            case 5:
              if (!(
#line 22264 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 22266 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3458 (insn, operands);

            default:
              return NULL;
            }

        case SUBREG:
          switch (pattern1074 (x10))
            {
            case 0:
              if (!((
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3428 (insn, operands);

            case 1:
              if (!(
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3430 (insn, operands);

            case 2:
              if (!((
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3432 (insn, operands);

            case 3:
              if (!((
#line 22029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3434 (insn, operands);

            case 4:
              if (!((
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22070 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3440 (insn, operands);

            case 5:
              if (!(
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22070 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3442 (insn, operands);

            case 6:
              if (!((
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22070 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3444 (insn, operands);

            case 7:
              if (!((
#line 22068 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22070 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3446 (insn, operands);

            default:
              return NULL;
            }

        case VEC_MERGE:
          switch (pattern971 (x10))
            {
            case 0:
              if (!((
#line 22293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3459 (insn, operands);

            case 1:
              if (!(
#line 22293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 22295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3460 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case SUBREG:
      if (pattern111 (x3) != 0
          || !(
#line 22139 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 22141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3447 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_61 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (pattern828 (x3) != 0)
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SFmode:
      if (!nonimmediate_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode)
        return NULL;
      switch (GET_MODE (operands[1]))
        {
        case E_V16SFmode:
          if (!register_operand (operands[1], E_V16SFmode)
              || !(
#line 12527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1]))) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_1567 (insn, operands);

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !
#line 12928 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && reload_completed))
            return NULL;
          return gen_split_1576 (insn, operands);

        default:
          return NULL;
        }

    case E_V4SImode:
      if (!nonimmediate_operand (operands[0], E_V4SImode)
          || GET_MODE (x2) != E_V4SImode)
        return NULL;
      switch (GET_MODE (operands[1]))
        {
        case E_V16SImode:
          if (!register_operand (operands[1], E_V16SImode)
              || !(
#line 12527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1]))) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_1568 (insn, operands);

        case E_V8SImode:
          if (!nonimmediate_operand (operands[1], E_V8SImode)
              || !
#line 12928 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && reload_completed))
            return NULL;
          return gen_split_1575 (insn, operands);

        default:
          return NULL;
        }

    case E_V4DFmode:
      if (!nonimmediate_operand (operands[0], E_V4DFmode)
          || GET_MODE (x2) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode)
          || !(
#line 12592 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && reload_completed
   && (TARGET_AVX512VL
       || (REG_P (operands[0]) && !EXT_REX_SSE_REG_P (operands[1])))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return NULL;
      return gen_split_1569 (insn, operands);

    case E_V4DImode:
      if (!nonimmediate_operand (operands[0], E_V4DImode)
          || GET_MODE (x2) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V8DImode)
          || !(
#line 12592 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && reload_completed
   && (TARGET_AVX512VL
       || (REG_P (operands[0]) && !EXT_REX_SSE_REG_P (operands[1])))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return NULL;
      return gen_split_1570 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_63 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (XVECLEN (x3, 0))
    {
    case 2:
      res = split_60 (x1, insn);
      if (res != NULL_RTX)
        return res;
      break;

    case 4:
      res = split_61 (x1, insn);
      if (res != NULL_RTX)
        return res;
      break;

    case 8:
      res = split_62 (x1, insn);
      if (res != NULL_RTX)
        return res;
      break;

    case 16:
      if (pattern829 (x3, 
6, 
5, 
4) == 0
          && pattern1491 (x3, 
11, 
10, 
9, 
8, 
7) == 0)
        {
          switch (pattern1763 (x2))
            {
            case 0:
              if (((
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1])))))
                return gen_split_1577 (insn, operands);
              break;

            case 1:
              if (((
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1])))))
                return gen_split_1578 (insn, operands);
              break;

            case 2:
              if (((
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1])))))
                return gen_split_1579 (insn, operands);
              break;

            case 3:
              if ((
#line 13181 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13183 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1584 (insn, operands);
              break;

            default:
              break;
            }
        }
      break;

    case 32:
      if (pattern831 (x3, 
11, 
10, 
9, 
8) == 0
          && pattern1673 (x3, 
15, 
14, 
13, 
12, 
16) == 0
          && pattern1784 (x3, 
21, 
20, 
19, 
18, 
17) == 0
          && pattern1826 (x3, 
26, 
25, 
24, 
23, 
22) == 0)
        {
          x4 = XVECEXP (x3, 0, 27);
          if (x4 == const_int_rtx[MAX_SAVED_CONST_INT + 27]
              && pattern1844 (x3, 
31, 
30, 
29, 
28) == 0
              && nonimmediate_operand (operands[0], E_V32QImode)
              && GET_MODE (x2) == E_V32QImode
              && nonimmediate_operand (operands[1], E_V64QImode)
              && (
#line 13113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13123 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed
   && (TARGET_AVX512VL
       || REG_P (operands[0])
       || !EXT_REX_SSE_REG_P (operands[1])))))
            return gen_split_1583 (insn, operands);
        }
      break;

    default:
      break;
    }
  if (XVECLEN (x3, 0) < 1)
    return NULL;
  operands[2] = x3;
  if (!avx_vbroadcast_operand (operands[2], E_VOIDmode))
    return NULL;
  x5 = XVECEXP (x3, 0, 0);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode)
          || !(
#line 27392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && (V8SFmode != V4DFmode || !TARGET_AVX2 || operands[3] == const0_rtx)) && 
#line 27395 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
        return NULL;
      return gen_split_3732 (insn, operands);

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x2) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode)
          || !(
#line 27392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && (V4DFmode != V4DFmode || !TARGET_AVX2 || operands[3] == const0_rtx)) && 
#line 27395 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
        return NULL;
      return gen_split_3733 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_66 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern944 (x2, 
E_V32BFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 411 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1494 (insn, operands);

        case E_V16BFmode:
          if (pattern944 (x2, 
E_V16BFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1495 (insn, operands);

        case E_V8BFmode:
          if (pattern944 (x2, 
E_V8BFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1496 (insn, operands);

        case E_V32HFmode:
          if (pattern944 (x2, 
E_V32HFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 413 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1497 (insn, operands);

        case E_V16HFmode:
          if (pattern944 (x2, 
E_V16HFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1498 (insn, operands);

        case E_V8HFmode:
          if (pattern944 (x2, 
E_V8HFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1499 (insn, operands);

        case E_V16SFmode:
          if (pattern944 (x2, 
E_V16SFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1500 (insn, operands);

        case E_V8SFmode:
          if (pattern944 (x2, 
E_V8SFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1501 (insn, operands);

        case E_V4SFmode:
          if (pattern944 (x2, 
E_V4SFmode) != 0
              || !(
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1502 (insn, operands);

        case E_V8DFmode:
          if (pattern944 (x2, 
E_V8DFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 416 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1503 (insn, operands);

        case E_V4DFmode:
          if (pattern944 (x2, 
E_V4DFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1504 (insn, operands);

        case E_V2DFmode:
          if (pattern944 (x2, 
E_V2DFmode) != 0
              || !((
#line 5474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 5476 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1505 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern529 (x2))
            {
            case 0:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1665 (insn, operands);

            case 1:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1692 (insn, operands);

            case 2:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1719 (insn, operands);

            case 3:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1746 (insn, operands);

            case 4:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1773 (insn, operands);

            case 5:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1800 (insn, operands);

            case 6:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1827 (insn, operands);

            case 7:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1854 (insn, operands);

            case 8:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1881 (insn, operands);

            case 9:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1908 (insn, operands);

            case 10:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1935 (insn, operands);

            case 11:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1962 (insn, operands);

            case 12:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1668 (insn, operands);

            case 13:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1695 (insn, operands);

            case 14:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1722 (insn, operands);

            case 15:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1749 (insn, operands);

            case 16:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1776 (insn, operands);

            case 17:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1803 (insn, operands);

            case 18:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1830 (insn, operands);

            case 19:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1857 (insn, operands);

            case 20:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1884 (insn, operands);

            case 21:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1911 (insn, operands);

            case 22:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1938 (insn, operands);

            case 23:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1965 (insn, operands);

            case 24:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1671 (insn, operands);

            case 25:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1698 (insn, operands);

            case 26:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1725 (insn, operands);

            case 27:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1752 (insn, operands);

            case 28:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1779 (insn, operands);

            case 29:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1806 (insn, operands);

            case 30:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1833 (insn, operands);

            case 31:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1860 (insn, operands);

            case 32:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1887 (insn, operands);

            case 33:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1914 (insn, operands);

            case 34:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1941 (insn, operands);

            case 35:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1968 (insn, operands);

            case 36:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2961 (insn, operands);

            case 37:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2970 (insn, operands);

            case 38:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2979 (insn, operands);

            case 39:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2988 (insn, operands);

            case 40:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2997 (insn, operands);

            case 41:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3006 (insn, operands);

            case 42:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3015 (insn, operands);

            case 43:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3024 (insn, operands);

            case 44:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3033 (insn, operands);

            case 45:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3042 (insn, operands);

            case 46:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3051 (insn, operands);

            case 47:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3060 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern531 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2313 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2340 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2367 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2394 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2421 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2448 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2475 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2502 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2529 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2556 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2583 (insn, operands);

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2610 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2316 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2343 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2370 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2397 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2424 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2451 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2478 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2505 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2532 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2559 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2586 (insn, operands);

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2613 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2319 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2346 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2373 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2400 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2427 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2454 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2481 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2508 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2535 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2562 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2589 (insn, operands);

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2616 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      return split_65 (x1, insn);

    case XOR:
      return split_64 (x1, insn);

    case GT:
      switch (pattern339 (x2))
        {
        case 0:
          if (!((
#line 17311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2 && ix86_pre_reload_split ()) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 17313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3241 (insn, operands);

        case 1:
          if (!(
#line 17311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2 && ix86_pre_reload_split ()) && 
#line 17313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3242 (insn, operands);

        default:
          return NULL;
        }

    case LT:
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      x4 = XEXP (x2, 1);
      operands[3] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V4DImode:
          if (pattern922 (x2, 
E_V4DImode) != 0)
            return NULL;
          if (((
#line 17328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 17330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3243 (insn, operands);
          if (!(
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 776 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return NULL;
          return gen_split_3249 (insn, operands);

        case E_V2DImode:
          if (pattern922 (x2, 
E_V2DImode) != 0)
            return NULL;
          if ((
#line 17328 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 17330 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3244 (insn, operands);
          if (!
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_3250 (insn, operands);

        case E_V16HImode:
          if (pattern922 (x2, 
E_V16HImode) != 0
              || !(
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 774 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return NULL;
          return gen_split_3245 (insn, operands);

        case E_V8HImode:
          if (pattern922 (x2, 
E_V8HImode) != 0
              || !
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_3246 (insn, operands);

        case E_V8SImode:
          if (pattern922 (x2, 
E_V8SImode) != 0
              || !(
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return NULL;
          return gen_split_3247 (insn, operands);

        case E_V4SImode:
          if (pattern922 (x2, 
E_V4SImode) != 0
              || !
#line 17340 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_3248 (insn, operands);

        default:
          return NULL;
        }

    case VEC_DUPLICATE:
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) != NOT)
        return NULL;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x4 = XEXP (x2, 1);
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          if (pattern1054 (x2, 
E_V4SImode, 
E_SImode) != 0)
            return NULL;
          if (register_operand (operands[1], E_SImode)
              && 
#line 18603 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return gen_split_3352 (insn, operands);
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3362 (insn, operands);

        case E_V2DImode:
          if (pattern1054 (x2, 
E_V2DImode, 
E_DImode) != 0)
            return NULL;
          if (register_operand (operands[1], E_DImode)
              && 
#line 18603 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return gen_split_3353 (insn, operands);
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3365 (insn, operands);

        case E_V64QImode:
          if (pattern591 (x2, 
E_V64QImode, 
E_QImode) != 0
              || !(
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 587 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return NULL;
          return gen_split_3354 (insn, operands);

        case E_V32QImode:
          if (pattern591 (x2, 
E_V32QImode, 
E_QImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3355 (insn, operands);

        case E_V16QImode:
          if (pattern591 (x2, 
E_V16QImode, 
E_QImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3356 (insn, operands);

        case E_V32HImode:
          if (pattern591 (x2, 
E_V32HImode, 
E_HImode) != 0
              || !(
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return NULL;
          return gen_split_3357 (insn, operands);

        case E_V16HImode:
          if (pattern591 (x2, 
E_V16HImode, 
E_HImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3358 (insn, operands);

        case E_V8HImode:
          if (pattern591 (x2, 
E_V8HImode, 
E_HImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3359 (insn, operands);

        case E_V16SImode:
          if (pattern591 (x2, 
E_V16SImode, 
E_SImode) != 0
              || !(
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return NULL;
          return gen_split_3360 (insn, operands);

        case E_V8SImode:
          if (pattern591 (x2, 
E_V8SImode, 
E_SImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3361 (insn, operands);

        case E_V8DImode:
          if (pattern591 (x2, 
E_V8DImode, 
E_DImode) != 0
              || !(
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 590 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return NULL;
          return gen_split_3363 (insn, operands);

        case E_V4DImode:
          if (pattern591 (x2, 
E_V4DImode, 
E_DImode) != 0
              || !
#line 18619 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return NULL;
          return gen_split_3364 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_82 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NOT:
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern613 (x2, 
E_V16SImode, 
E_SImode) != 0
              || !(
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return NULL;
          return gen_split_3346 (insn, operands);

        case E_V8SImode:
          if (pattern613 (x2, 
E_V8SImode, 
E_SImode) != 0
              || !
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
            return NULL;
          return gen_split_3347 (insn, operands);

        case E_V4SImode:
          if (pattern613 (x2, 
E_V4SImode, 
E_SImode) != 0
              || !
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
            return NULL;
          return gen_split_3348 (insn, operands);

        case E_V8DImode:
          if (pattern613 (x2, 
E_V8DImode, 
E_DImode) != 0
              || !(
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(64 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return NULL;
          return gen_split_3349 (insn, operands);

        case E_V4DImode:
          if (pattern613 (x2, 
E_V4DImode, 
E_DImode) != 0
              || !
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(32 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
            return NULL;
          return gen_split_3350 (insn, operands);

        case E_V2DImode:
          if (pattern613 (x2, 
E_V2DImode, 
E_DImode) != 0
              || !
#line 18435 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(16 == 64 || TARGET_AVX512VL
   || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256)))
            return NULL;
          return gen_split_3351 (insn, operands);

        default:
          return NULL;
        }

    case REG:
    case SUBREG:
      operands[1] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_V32QImode:
          if (!register_operand (operands[0], E_V32QImode)
              || GET_MODE (x2) != E_V32QImode
              || !register_operand (operands[1], E_QImode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || QImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3735 (insn, operands);

        case E_V16QImode:
          if (!register_operand (operands[0], E_V16QImode)
              || GET_MODE (x2) != E_V16QImode
              || !register_operand (operands[1], E_QImode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || QImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3736 (insn, operands);

        case E_V16HImode:
          if (!register_operand (operands[0], E_V16HImode)
              || GET_MODE (x2) != E_V16HImode
              || !register_operand (operands[1], E_HImode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || HImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3737 (insn, operands);

        case E_V8HImode:
          if (!register_operand (operands[0], E_V8HImode)
              || GET_MODE (x2) != E_V8HImode
              || !register_operand (operands[1], E_HImode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || HImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3738 (insn, operands);

        case E_V8SImode:
          if (!register_operand (operands[0], E_V8SImode)
              || GET_MODE (x2) != E_V8SImode
              || !register_operand (operands[1], E_SImode))
            return NULL;
          if (
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || SImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return gen_split_3739 (insn, operands);
          if (!
#line 27992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !TARGET_AVX2 && reload_completed))
            return NULL;
          return gen_split_3745 (insn, operands);

        case E_V4SImode:
          if (!register_operand (operands[0], E_V4SImode)
              || GET_MODE (x2) != E_V4SImode
              || !register_operand (operands[1], E_SImode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || SImode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3740 (insn, operands);

        case E_V16HFmode:
          if (!register_operand (operands[0], E_V16HFmode)
              || GET_MODE (x2) != E_V16HFmode
              || !register_operand (operands[1], E_HFmode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || HFmode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3741 (insn, operands);

        case E_V8HFmode:
          if (!register_operand (operands[0], E_V8HFmode)
              || GET_MODE (x2) != E_V8HFmode
              || !register_operand (operands[1], E_HFmode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || HFmode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3742 (insn, operands);

        case E_V16BFmode:
          if (!register_operand (operands[0], E_V16BFmode)
              || GET_MODE (x2) != E_V16BFmode
              || !register_operand (operands[1], E_BFmode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || BFmode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3743 (insn, operands);

        case E_V8BFmode:
          if (!register_operand (operands[0], E_V8BFmode)
              || GET_MODE (x2) != E_V8BFmode
              || !register_operand (operands[1], E_BFmode)
              || !
#line 27969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   /* Disable this splitter if avx512vl_vec_dup_gprv*[qhs]i insn is
      available, because then we can broadcast from GPRs directly.
      For V*[QH]I modes it requires both -mavx512vl and -mavx512bw,
      for V*SI mode it requires just -mavx512vl.  */
   && !(TARGET_AVX512VL
	&& (TARGET_AVX512BW || BFmode == SImode))
   && reload_completed && GENERAL_REG_P (operands[1])))
            return NULL;
          return gen_split_3744 (insn, operands);

        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x2) != E_V8SFmode
              || !register_operand (operands[1], E_SFmode)
              || !
#line 27992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !TARGET_AVX2 && reload_completed))
            return NULL;
          return gen_split_3746 (insn, operands);

        case E_V4DImode:
          if (!register_operand (operands[0], E_V4DImode)
              || GET_MODE (x2) != E_V4DImode
              || !register_operand (operands[1], E_DImode)
              || !
#line 27992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !TARGET_AVX2 && reload_completed))
            return NULL;
          return gen_split_3747 (insn, operands);

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x2) != E_V4DFmode
              || !register_operand (operands[1], E_DFmode)
              || !
#line 27992 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !TARGET_AVX2 && reload_completed))
            return NULL;
          return gen_split_3748 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_84 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  res = split_81 (x1, insn);
  if (res != NULL_RTX)
    return res;
  switch (GET_CODE (x2))
    {
    case UNSPEC:
      return split_79 (x1, insn);

    case VEC_MERGE:
      return split_78 (x1, insn);

    case VEC_SELECT:
      return split_83 (x1, insn);

    case AND:
    case IOR:
    case XOR:
    case NOT:
      return split_80 (x1, insn);

    case PLUS:
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != UNSPEC)
        return NULL;
      switch (pattern186 (x2))
        {
        case 0:
          if (!((
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 7181 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1506 (insn, operands);

        case 1:
          if (!((
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7181 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1507 (insn, operands);

        case 2:
          if (!((
#line 7178 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7181 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1508 (insn, operands);

        case 3:
          if (!((
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 7198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1509 (insn, operands);

        case 4:
          if (!((
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1510 (insn, operands);

        case 5:
          if (!((
#line 7195 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1511 (insn, operands);

        case 6:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1512 (insn, operands);

        case 7:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1514 (insn, operands);

        case 8:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1516 (insn, operands);

        case 9:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1513 (insn, operands);

        case 10:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1515 (insn, operands);

        case 11:
          if (!((
#line 7213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && flag_unsafe_math_optimizations
  && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 7216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1517 (insn, operands);

        default:
          return NULL;
        }

    case VEC_CONCAT:
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case ZERO_EXTEND:
          switch (pattern181 (x2))
            {
            case 0:
              if (!(
#line 12083 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1555 (insn, operands);

            case 1:
              if (!(
#line 12197 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1559 (insn, operands);

            default:
              return NULL;
            }

        case VEC_SELECT:
          if (GET_MODE (x3) != E_DFmode)
            return NULL;
          x4 = XEXP (x3, 1);
          if (GET_CODE (x4) != PARALLEL
              || XVECLEN (x4, 0) != 1)
            return NULL;
          x5 = XVECEXP (x4, 0, 0);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !memory_operand (operands[0], E_V2DFmode)
              || GET_MODE (x2) != E_V2DFmode)
            return NULL;
          x6 = XEXP (x2, 1);
          operands[1] = x6;
          if (!register_operand (operands[1], E_DFmode))
            return NULL;
          x7 = XEXP (x3, 0);
          if (!rtx_equal_p (x7, operands[0])
              || !
#line 14737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_3181 (insn, operands);

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x3;
          res = split_77 (x1, insn);
          if (res != NULL_RTX)
            return res;
          if (GET_CODE (x3) != SUBREG
              || maybe_ne (SUBREG_BYTE (x3), 0))
            return NULL;
          x6 = XEXP (x2, 1);
          if (GET_CODE (x6) != SUBREG)
            return NULL;
          x7 = XEXP (x3, 0);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[1] = x7;
              if (!register_operand (operands[1], E_TImode)
                  || maybe_ne (SUBREG_BYTE (x6), 8)
                  || GET_MODE (x6) != E_DImode
                  || !register_operand (operands[0], E_V2DImode)
                  || GET_MODE (x2) != E_V2DImode
                  || GET_MODE (x3) != E_DImode)
                return NULL;
              x8 = XEXP (x6, 0);
              if (!rtx_equal_p (x8, operands[1])
                  || !
#line 21713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                return NULL;
              return gen_split_3410 (insn, operands);

            case UNSPEC:
              if (XVECLEN (x7, 0) != 1
                  || XINT (x7, 1) != 119
                  || GET_MODE (x7) != E_V16QImode
                  || pattern1238 (x6) != 0
                  || !register_operand (operands[0], E_V4DImode)
                  || GET_MODE (x2) != E_V4DImode
                  || GET_MODE (x3) != E_V2DImode)
                return NULL;
              x9 = XVECEXP (x7, 0, 0);
              operands[1] = x9;
              if (!memory_operand (operands[1], E_V16QImode))
                return NULL;
              x8 = XEXP (x6, 0);
              x10 = XVECEXP (x8, 0, 0);
              if (!rtx_equal_p (x10, operands[1])
                  || !(
#line 27912 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && ix86_pre_reload_split ()) && 
#line 27914 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3734 (insn, operands);

            default:
              return NULL;
            }

        case VEC_CONCAT:
          if (pattern410 (x2) != 0)
            return NULL;
          x7 = XEXP (x3, 0);
          operands[1] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern1466 (x2, 
E_V8SImode, 
E_V4SImode, 
E_V16SImode) != 0
                  || !((
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30143 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3818 (insn, operands);

            case E_V16SFmode:
              if (pattern1466 (x2, 
E_V8SFmode, 
E_V4SFmode, 
E_V16SFmode) != 0
                  || !((
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30143 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3819 (insn, operands);

            case E_V8DFmode:
              if (pattern1466 (x2, 
E_V4DFmode, 
E_V2DFmode, 
E_V8DFmode) != 0
                  || !((
#line 30141 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1444 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 30143 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3820 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case EQ:
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case US_MINUS:
          x7 = XEXP (x3, 0);
          operands[1] = x7;
          x4 = XEXP (x3, 1);
          operands[2] = x4;
          x6 = XEXP (x2, 1);
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V32QImode:
              if (pattern945 (x2, 
E_V32QImode) != 0
                  || !(
#line 16323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && (V32QImode != V8HImode || TARGET_SSE4_1)
   && ix86_binary_operator_ok (US_MINUS, V32QImode, operands)) && 
#line 735 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3224 (insn, operands);

            case E_V16QImode:
              if (pattern945 (x2, 
E_V16QImode) != 0
                  || !
#line 16323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && (V16QImode != V8HImode || TARGET_SSE4_1)
   && ix86_binary_operator_ok (US_MINUS, V16QImode, operands)))
                return NULL;
              return gen_split_3225 (insn, operands);

            case E_V16HImode:
              if (pattern945 (x2, 
E_V16HImode) != 0
                  || !(
#line 16323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && (V16HImode != V8HImode || TARGET_SSE4_1)
   && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)) && 
#line 736 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3226 (insn, operands);

            case E_V8HImode:
              if (pattern945 (x2, 
E_V8HImode) != 0
                  || !
#line 16323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && (V8HImode != V8HImode || TARGET_SSE4_1)
   && ix86_binary_operator_ok (US_MINUS, V8HImode, operands)))
                return NULL;
              return gen_split_3227 (insn, operands);

            default:
              return NULL;
            }

        case EQ:
          x7 = XEXP (x3, 0);
          if (GET_CODE (x7) != LSHIFTRT)
            return NULL;
          x11 = XEXP (x7, 0);
          operands[1] = x11;
          x12 = XEXP (x7, 1);
          operands[2] = x12;
          if (!const_int_operand (operands[2], E_SImode))
            return NULL;
          x4 = XEXP (x3, 1);
          operands[3] = x4;
          x6 = XEXP (x2, 1);
          operands[4] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V16HImode:
              if (pattern1239 (x2, 
E_V16HImode) != 0
                  || !(
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (HImode) - 1) && 
#line 774 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3272 (insn, operands);

            case E_V8HImode:
              if (pattern1239 (x2, 
E_V8HImode) != 0
                  || !
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (HImode) - 1))
                return NULL;
              return gen_split_3273 (insn, operands);

            case E_V8SImode:
              if (pattern1239 (x2, 
E_V8SImode) != 0
                  || !(
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (SImode) - 1) && 
#line 775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3274 (insn, operands);

            case E_V4SImode:
              if (pattern1239 (x2, 
E_V4SImode) != 0
                  || !
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (SImode) - 1))
                return NULL;
              return gen_split_3275 (insn, operands);

            case E_V4DImode:
              if (pattern1239 (x2, 
E_V4DImode) != 0
                  || !(
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (DImode) - 1) && 
#line 776 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3276 (insn, operands);

            case E_V2DImode:
              if (pattern1239 (x2, 
E_V2DImode) != 0
                  || !
#line 17517 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(INTVAL (operands[2]) == GET_MODE_PRECISION (DImode) - 1))
                return NULL;
              return gen_split_3277 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case LT:
      x3 = XEXP (x2, 0);
      operands[1] = x3;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16HImode:
          if (pattern235 (x2, 
E_V16HImode) != 0
              || !((
#line 17113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 743 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 17115 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3228 (insn, operands);

        case E_V8HImode:
          if (pattern235 (x2, 
E_V8HImode) != 0
              || !(
#line 17113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 17115 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3229 (insn, operands);

        case E_V8SImode:
          if (pattern235 (x2, 
E_V8SImode) != 0
              || !((
#line 17113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 744 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 17115 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3230 (insn, operands);

        case E_V4SImode:
          if (pattern235 (x2, 
E_V4SImode) != 0
              || !(
#line 17113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 17115 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3231 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      switch (pattern240 (x2))
        {
        case 0:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V32HImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return NULL;
          return gen_split_3260 (insn, operands);

        case 1:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V16SImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_3263 (insn, operands);

        case 2:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V8DImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_3266 (insn, operands);

        case 3:
          if (!(
#line 17439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()) && 
#line 17442 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3269 (insn, operands);

        default:
          return NULL;
        }

    case LSHIFTRT:
      switch (pattern240 (x2))
        {
        case 0:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V32HImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return NULL;
          return gen_split_3261 (insn, operands);

        case 1:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V16SImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_3264 (insn, operands);

        case 2:
          if (!(
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V8DImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return NULL;
          return gen_split_3267 (insn, operands);

        case 3:
          if (!(
#line 17468 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()) && 
#line 17471 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3270 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFTRT:
      x3 = XEXP (x2, 0);
      operands[1] = x3;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      switch (GET_CODE (operands[2]))
        {
        case CONST_VECTOR:
          switch (GET_MODE (operands[0]))
            {
            case E_V32HImode:
              if (pattern239 (x2, 
E_V32HImode) == 0
                  && (
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V32HImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return gen_split_3262 (insn, operands);
              break;

            case E_V16SImode:
              if (pattern239 (x2, 
E_V16SImode) == 0
                  && (
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V16SImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return gen_split_3265 (insn, operands);
              break;

            case E_V8DImode:
              if (pattern239 (x2, 
E_V8DImode) == 0
                  && (
#line 17380 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && GET_MODE_UNIT_BITSIZE (V8DImode)
   > INTVAL (XVECEXP (operands[2], 0, 0))) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return gen_split_3268 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case CONST_INT:
          if (const_0_to_255_operand (operands[2], E_SImode)
              && register_operand (operands[0], E_V1TImode)
              && GET_MODE (x2) == E_V1TImode
              && register_operand (operands[1], E_V1TImode)
              && (
#line 17498 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()) && 
#line 17501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3271 (insn, operands);
          break;

        default:
          break;
        }
      if (!nonmemory_operand (operands[2], E_DImode)
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x2) != E_V2DImode
          || !register_operand (operands[1], E_V2DImode)
          || !(
#line 26983 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 26985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3731 (insn, operands);

    case ROTATE:
      if (pattern241 (x2) != 0
          || !(
#line 17539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()) && 
#line 17542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3278 (insn, operands);

    case ROTATERT:
      if (pattern241 (x2) != 0
          || !(
#line 17568 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()) && 
#line 17571 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3279 (insn, operands);

    case VEC_DUPLICATE:
      return split_82 (x1, insn);

    case SIGN_EXTEND:
      x3 = XEXP (x2, 0);
      if (pattern242 (x3) != 0)
        return NULL;
      switch (pattern675 (x2))
        {
        case 0:
          if ((
#line 24269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1
   && ix86_pre_reload_split ()) && 
#line 24272 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3524 (insn, operands);
          if (!(
#line 24269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24272 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3525 (insn, operands);

        case 1:
          if ((
#line 24421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3532 (insn, operands);
          if (!(
#line 24421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3533 (insn, operands);

        case 2:
          if (!(
#line 24785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 24787 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3556 (insn, operands);

        case 3:
          if ((
#line 24655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 24658 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3548 (insn, operands);
          if (!(
#line 24655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24658 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3549 (insn, operands);

        case 4:
          if ((
#line 24985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3567 (insn, operands);
          if (!(
#line 24985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3568 (insn, operands);

        case 5:
          if ((
#line 25210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 25213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3579 (insn, operands);
          if (!(
#line 25210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 25213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3580 (insn, operands);

        case 6:
          if ((
#line 24486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 24489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3536 (insn, operands);
          if (!(
#line 24486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3537 (insn, operands);

        case 7:
          if ((
#line 24846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24849 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3560 (insn, operands);
          if (!(
#line 24846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24849 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3561 (insn, operands);

        case 8:
          if ((
#line 25048 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 25051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3571 (insn, operands);
          if (!(
#line 25048 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 25051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3572 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      x3 = XEXP (x2, 0);
      if (pattern242 (x3) != 0)
        return NULL;
      x7 = XEXP (x3, 0);
      x11 = XEXP (x7, 0);
      switch (GET_CODE (x11))
        {
        case VEC_CONCAT:
          switch (pattern673 (x2))
            {
            case 0:
              if ((
#line 24269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1
   && ix86_pre_reload_split ()) && 
#line 24272 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3526 (insn, operands);
              if (!(
#line 24269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24272 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3527 (insn, operands);

            case 1:
              if ((
#line 24421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3534 (insn, operands);
              if (!(
#line 24421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3535 (insn, operands);

            case 2:
              if (!(
#line 24785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 24787 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3558 (insn, operands);

            case 3:
              if ((
#line 24655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 24658 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3550 (insn, operands);
              if (!(
#line 24655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24658 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3551 (insn, operands);

            case 4:
              if ((
#line 24985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3569 (insn, operands);
              if (!(
#line 24985 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3570 (insn, operands);

            case 5:
              if ((
#line 25210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 25213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3581 (insn, operands);
              if (!(
#line 25210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 25213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3582 (insn, operands);

            default:
              return NULL;
            }

        case VEC_MERGE:
          x13 = XEXP (x11, 0);
          if (GET_CODE (x13) != VEC_DUPLICATE)
            return NULL;
          if (GET_MODE (x13) == E_V4SImode)
            {
              switch (pattern1024 (x2))
                {
                case 0:
                  if ((
#line 24486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 24489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3538 (insn, operands);
                  if ((
#line 24486 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3539 (insn, operands);
                  break;

                case 1:
                  if ((
#line 24846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()) && 
#line 24849 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3562 (insn, operands);
                  if ((
#line 24846 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 24849 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3563 (insn, operands);
                  break;

                case 2:
                  if ((
#line 25048 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()) && 
#line 25051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3573 (insn, operands);
                  if ((
#line 25048 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ()) && 
#line 25051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_3574 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          x14 = XEXP (x11, 2);
          if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return NULL;
          switch (pattern1025 (x2))
            {
            case 0:
              if (!(
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 24924 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3564 (insn, operands);

            case 1:
              if (!(
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 24924 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3565 (insn, operands);

            case 2:
              if (!(
#line 24922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 24924 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3566 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_9 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2)
    return NULL;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DFmode)
    return NULL;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 1)
    return NULL;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!memory_operand (operands[0], E_DFmode))
    return NULL;
  x6 = XEXP (x2, 0);
  operands[1] = x6;
  if (!sse_reg_operand (operands[1], E_V2DFmode))
    return NULL;
  x7 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != VEC_SELECT
      || GET_MODE (x8) != E_DFmode)
    return NULL;
  x9 = XEXP (x8, 1);
  if (GET_CODE (x9) != PARALLEL
      || XVECLEN (x9, 0) != 1)
    return NULL;
  x10 = XVECEXP (x9, 0, 0);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return NULL;
  x11 = XEXP (x7, 0);
  operands[2] = x11;
  if (!memory_operand (operands[2], E_DFmode))
    return NULL;
  x12 = XEXP (x8, 0);
  operands[3] = x12;
  if (!sse_reg_operand (operands[3], E_V2DFmode)
      || !
#line 1980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_SSE_UNALIGNED_STORE_OPTIMAL
   && ix86_operands_ok_for_move_multiple (operands, false, DFmode)))
    return NULL;
  *pmatch_len_ = 1;
  return gen_peephole2_402 (insn, operands);
}

 rtx_insn *
peephole2_10 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (address_no_seg_operand (operands[1], E_SImode)
      && 
#line 6404 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_hardreg_mov_ok (operands[0], operands[1])
   && peep2_regno_dead_p (0, FLAGS_REG)
   && ix86_avoid_lea_for_addr (peep2_next_insn (0), operands)))
    {
      *pmatch_len_ = 0;
      res = gen_peephole2_60 (insn, operands);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 2
      || !memory_operand (operands[1], E_SImode))
    return NULL;
  x2 = PATTERN (peep2_next_insn (1));
  switch (GET_CODE (x2))
    {
    case CALL:
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != MEM
          || GET_MODE (x3) != E_QImode)
        return NULL;
      x4 = XEXP (x2, 1);
      operands[3] = x4;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 20213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_176 (insn, operands);

    case UNSPEC_VOLATILE:
      if (pattern833 (x2) != 0)
        return NULL;
      x6 = PATTERN (peep2_next_insn (2));
      switch (GET_CODE (x6))
        {
        case CALL:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != MEM
              || GET_MODE (x7) != E_QImode)
            return NULL;
          x8 = XEXP (x6, 1);
          operands[3] = x8;
          x9 = XEXP (x7, 0);
          if (!rtx_equal_p (x9, operands[0])
              || !(
#line 20227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_178 (insn, operands);

        case PARALLEL:
          if (XVECLEN (x6, 0) != 2)
            return NULL;
          x10 = XVECEXP (x6, 0, 1);
          if (GET_CODE (x10) != SET)
            return NULL;
          x11 = XEXP (x10, 1);
          if (GET_CODE (x11) != PLUS
              || GET_MODE (x11) != E_SImode)
            return NULL;
          x12 = XEXP (x11, 0);
          if (GET_CODE (x12) != REG
              || REGNO (x12) != 7
              || GET_MODE (x12) != E_SImode)
            return NULL;
          x13 = XEXP (x10, 0);
          if (GET_CODE (x13) != REG
              || REGNO (x13) != 7
              || GET_MODE (x13) != E_SImode)
            return NULL;
          x14 = XEXP (x11, 1);
          operands[4] = x14;
          if (!immediate_operand (operands[4], E_SImode))
            return NULL;
          x15 = XVECEXP (x6, 0, 0);
          switch (GET_CODE (x15))
            {
            case CALL:
              x16 = XEXP (x15, 0);
              if (GET_CODE (x16) != MEM
                  || GET_MODE (x16) != E_QImode)
                return NULL;
              x17 = XEXP (x15, 1);
              operands[3] = x17;
              x18 = XEXP (x16, 0);
              if (!rtx_equal_p (x18, operands[0])
                  || !
#line 20307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))))
                return NULL;
              *pmatch_len_ = 2;
              return gen_peephole2_181 (insn, operands);

            case SET:
              x17 = XEXP (x15, 1);
              if (GET_CODE (x17) != CALL)
                return NULL;
              x19 = XEXP (x17, 0);
              if (GET_CODE (x19) != MEM
                  || GET_MODE (x19) != E_QImode)
                return NULL;
              x16 = XEXP (x15, 0);
              operands[2] = x16;
              x20 = XEXP (x17, 1);
              operands[3] = x20;
              x21 = XEXP (x19, 0);
              if (!rtx_equal_p (x21, operands[0])
                  || !
#line 20522 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))))
                return NULL;
              *pmatch_len_ = 2;
              return gen_peephole2_189 (insn, operands);

            default:
              return NULL;
            }

        case SET:
          if (pattern1330 (x6) != 0
              || !(
#line 20434 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_186 (insn, operands);

        default:
          return NULL;
        }

    case PARALLEL:
      if (XVECLEN (x2, 0) != 2)
        return NULL;
      x22 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x22) != CALL)
        return NULL;
      x23 = XEXP (x22, 0);
      if (GET_CODE (x23) != MEM
          || GET_MODE (x23) != E_QImode)
        return NULL;
      x24 = XVECEXP (x2, 0, 1);
      if (pattern1241 (x24) != 0)
        return NULL;
      x25 = XEXP (x24, 0);
      if (GET_CODE (x25) != REG
          || REGNO (x25) != 7
          || GET_MODE (x25) != E_SImode)
        return NULL;
      x26 = XEXP (x22, 1);
      operands[3] = x26;
      x27 = XEXP (x24, 1);
      x28 = XEXP (x27, 1);
      operands[4] = x28;
      if (!immediate_operand (operands[4], E_SImode))
        return NULL;
      x29 = XEXP (x23, 0);
      if (!rtx_equal_p (x29, operands[0])
          || !
#line 20288 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_180 (insn, operands);

    case SET:
      switch (pattern834 (x2))
        {
        case 0:
          if (!(
#line 20324 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && peep2_reg_dead_p (2, operands[0])) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
            return NULL;
          *pmatch_len_ = 1;
          return gen_peephole2_182 (insn, operands);

        case 1:
          if (!(
#line 20418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
            return NULL;
          *pmatch_len_ = 1;
          return gen_peephole2_184 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_13 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 0);
  if (!general_reg_operand (x3, E_SImode))
    return NULL;
  operands[8] = x3;
  switch (pattern949 (x1, 
E_SImode, 
E_DImode))
    {
    case 0:
      if (
#line 9672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_100 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    case 1:
      if (
#line 9727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (6, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && !reg_overlap_mentioned_p (operands[0], operands[10])
   && !reg_overlap_mentioned_p (operands[10], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[11])
   && !reg_overlap_mentioned_p (operands[11], operands[1])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))))
        {
          *pmatch_len_ = 5;
          res = gen_peephole2_102 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  if (pattern952 (x1, 
E_SImode) != 0
      || !
#line 26563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_207 (insn, operands);
}

 rtx_insn *
peephole2_15 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (address_no_seg_operand (operands[1], E_DImode)
      && (
#line 6404 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_hardreg_mov_ok (operands[0], operands[1])
   && peep2_regno_dead_p (0, FLAGS_REG)
   && ix86_avoid_lea_for_addr (peep2_next_insn (0), operands)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    {
      *pmatch_len_ = 0;
      res = gen_peephole2_61 (insn, operands);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 2
      || !memory_operand (operands[1], E_DImode))
    return NULL;
  x2 = PATTERN (peep2_next_insn (1));
  switch (GET_CODE (x2))
    {
    case CALL:
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != MEM
          || GET_MODE (x3) != E_QImode)
        return NULL;
      x4 = XEXP (x2, 1);
      operands[3] = x4;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 20213 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_177 (insn, operands);

    case UNSPEC_VOLATILE:
      if (pattern833 (x2) != 0)
        return NULL;
      x6 = PATTERN (peep2_next_insn (2));
      switch (GET_CODE (x6))
        {
        case CALL:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != MEM
              || GET_MODE (x7) != E_QImode)
            return NULL;
          x8 = XEXP (x6, 1);
          operands[3] = x8;
          x9 = XEXP (x7, 0);
          if (!rtx_equal_p (x9, operands[0])
              || !(
#line 20227 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_179 (insn, operands);

        case SET:
          if (pattern1330 (x6) != 0
              || !(
#line 20434 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (2))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (2)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_187 (insn, operands);

        default:
          return NULL;
        }

    case SET:
      switch (pattern834 (x2))
        {
        case 0:
          if (!(
#line 20324 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && peep2_reg_dead_p (2, operands[0])) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
            return NULL;
          *pmatch_len_ = 1;
          return gen_peephole2_183 (insn, operands);

        case 1:
          if (!(
#line 20418 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER
   && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
            return NULL;
          *pmatch_len_ = 1;
          return gen_peephole2_185 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_19 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 1);
  if (!ix86_comparison_operator (x3, E_QImode))
    return NULL;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return NULL;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x6 = XEXP (x2, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
      operands[1] = x6;
      if (!register_operand (operands[1], E_QImode))
        return NULL;
      operands[2] = x3;
      x7 = PATTERN (peep2_next_insn (2));
      switch (GET_CODE (x7))
        {
        case SET:
          x8 = XEXP (x7, 1);
          if (GET_CODE (x8) != ZERO_EXTEND)
            return NULL;
          x9 = XEXP (x7, 0);
          operands[3] = x9;
          if (!any_QIreg_operand (operands[3], E_VOIDmode))
            return NULL;
          x10 = XEXP (x8, 0);
          if (!rtx_equal_p (x10, operands[1])
              || !
#line 19958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((peep2_reg_dead_p (3, operands[1])
    || operands_match_p (operands[1], operands[3]))
   && ! reg_overlap_mentioned_p (operands[3], operands[0])
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_169 (insn, operands);

        case PARALLEL:
          if (XVECLEN (x7, 0) != 2)
            return NULL;
          x11 = XVECEXP (x7, 0, 0);
          if (GET_CODE (x11) != SET)
            return NULL;
          x12 = XEXP (x11, 1);
          if (GET_CODE (x12) != AND
              || GET_MODE (x12) != E_SImode)
            return NULL;
          x13 = XEXP (x12, 1);
          if (GET_CODE (x13) != CONST_INT
              || XWINT (x13, 0) != 255L
              || pattern1713 (x7, 
E_SImode) != 0)
            return NULL;
          x14 = XEXP (x12, 0);
          if (!rtx_equal_p (x14, operands[3])
              || !
#line 20030 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[1]) == REGNO (operands[3])
   && ! reg_overlap_mentioned_p (operands[3], operands[0])
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_172 (insn, operands);

        default:
          return NULL;
        }

    case STRICT_LOW_PART:
      if (peep2_current_count < 4)
        return NULL;
      x15 = XEXP (x6, 0);
      operands[5] = x15;
      if (!register_operand (operands[5], E_QImode))
        return NULL;
      operands[6] = x3;
      x7 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x7) != SET)
        return NULL;
      x8 = XEXP (x7, 1);
      if (!ix86_comparison_operator (x8, E_QImode))
        return NULL;
      operands[2] = x8;
      x10 = XEXP (x8, 0);
      if (GET_CODE (x10) != REG
          || REGNO (x10) != 17)
        return NULL;
      x16 = XEXP (x8, 1);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x9 = XEXP (x7, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_QImode))
        return NULL;
      x17 = PATTERN (peep2_next_insn (3));
      if (GET_CODE (x17) != SET)
        return NULL;
      x18 = XEXP (x17, 1);
      if (GET_CODE (x18) != ZERO_EXTEND)
        return NULL;
      x19 = XEXP (x17, 0);
      operands[3] = x19;
      if (!any_QIreg_operand (operands[3], E_VOIDmode))
        return NULL;
      x20 = XEXP (x18, 0);
      if (!rtx_equal_p (x20, operands[1])
          || !
#line 20103 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((peep2_reg_dead_p (4, operands[1])
    || operands_match_p (operands[1], operands[3]))
   && ! reg_overlap_mentioned_p (operands[3], operands[0])
   && ! reg_overlap_mentioned_p (operands[3], operands[5])
   && ! reg_overlap_mentioned_p (operands[1], operands[5])
   && peep2_regno_dead_p (0, FLAGS_REG)))
        return NULL;
      *pmatch_len_ = 3;
      return gen_peephole2_175 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_23 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (pattern415 (x2, 
CALL, 
2) != 0)
    return NULL;
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != MEM
      || GET_MODE (x5) != E_QImode)
    return NULL;
  x6 = XVECEXP (x2, 0, 1);
  if (pattern1241 (x6) != 0)
    return NULL;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 7
      || GET_MODE (x7) != E_SImode)
    return NULL;
  x8 = XEXP (x3, 0);
  operands[2] = x8;
  x9 = XEXP (x4, 1);
  operands[3] = x9;
  x10 = XEXP (x6, 1);
  x11 = XEXP (x10, 1);
  operands[4] = x11;
  if (!immediate_operand (operands[4], E_SImode))
    return NULL;
  x12 = XEXP (x5, 0);
  if (!rtx_equal_p (x12, operands[0])
      || !
#line 20501 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && SIBLING_CALL_P (peep2_next_insn (1))
   && !reg_mentioned_p (operands[0],
			CALL_INSN_FUNCTION_USAGE (peep2_next_insn (1)))))
    return NULL;
  *pmatch_len_ = 1;
  return gen_peephole2_188 (insn, operands);
}

 rtx_insn *
peephole2_26 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count >= 2)
    {
      res = peephole2_24 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (memory_operand (operands[1], E_SImode)
      && push_operand (operands[0], E_SImode)
      && 
#line 27818 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
    {
      *pmatch_len_ = 0;
      res = gen_peephole2_253 (insn, operands);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 2)
    return NULL;
  if (general_reg_operand (operands[1], E_SImode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x3, 
E_SImode) == 0
          && 
#line 28018 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (SImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_281 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count >= 3)
    {
      res = peephole2_25 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (mmx_reg_operand (operands[1], E_VOIDmode)
      && mmx_reg_operand (operands[0], E_VOIDmode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern594 (x3) == 0
          && 
#line 28037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_283 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (sse_reg_operand (operands[1], E_VOIDmode)
      && sse_reg_operand (operands[0], E_VOIDmode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern594 (x3) == 0
          && 
#line 28049 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   /* Punt if operands[1] is %[xy]mm16+ and AVX512BW is not enabled,
      as EVEX encoded vpadd[bw], vpmullw, vpmin[su][bw] and vpmax[su][bw]
      instructions require AVX512BW and AVX512VL, but with the original
      instructions it might require just AVX512VL.
      AVX512VL is implied from TARGET_HARD_REGNO_MODE_OK.  */
   && (!EXT_REX_SSE_REGNO_P (REGNO (operands[1]))
       || TARGET_AVX512BW
       || GET_MODE_SIZE (GET_MODE_INNER (GET_MODE (operands[0]))) > 2
       || logic_operator (operands[3], VOIDmode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_284 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count >= 3
      && peep2_current_count >= 4)
    {
      if (memory_operand (operands[1], E_QImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern726 (x3, 
E_QImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_301 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_HImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern726 (x3, 
E_HImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_302 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_SImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern727 (x3, 
E_SImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (SImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_303 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_DImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern727 (x3, 
E_DImode) == 0
              && (
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_304 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (!memory_operand (operands[1], E_VOIDmode)
      || !register_operand (operands[0], E_VOIDmode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x3) != SET)
    return NULL;
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!memory_operand (operands[2], E_VOIDmode))
    return NULL;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !
#line 28507 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_VOLATILE_P (operands[1])
   && !MEM_VOLATILE_P (operands[2])
   && rtx_equal_p (operands[1], operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
    return NULL;
  *pmatch_len_ = 1;
  return gen_peephole2_331 (insn, operands);
}

 rtx_insn *
peephole2_39 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
      if (peep2_current_count < 2)
        return NULL;
      operands[0] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          x4 = PATTERN (peep2_next_insn (1));
          switch (pattern1336 (x4, 
E_SImode))
            {
            case 0:
              if (!
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_29 (insn, operands);

            case 1:
              if (!
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_31 (insn, operands);

            case 2:
              if (!(
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_33 (insn, operands);

            case 3:
              if (!
#line 4949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_41 (insn, operands);

            case 4:
              if (!
#line 4949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_43 (insn, operands);

            case 5:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_SImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_133 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_145 (insn, operands);

            case 6:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_SImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_134 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_146 (insn, operands);

            case 7:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_SImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_135 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_147 (insn, operands);

            case 8:
              if (!
#line 14345 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_153 (insn, operands);

            default:
              return NULL;
            }

        case E_DImode:
          x4 = PATTERN (peep2_next_insn (1));
          switch (pattern1336 (x4, 
E_DImode))
            {
            case 0:
              if (!(
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_30 (insn, operands);

            case 1:
              if (!(
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_32 (insn, operands);

            case 2:
              if (!(
#line 3655 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_34 (insn, operands);

            case 3:
              if (!(
#line 4949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_42 (insn, operands);

            case 4:
              if (!(
#line 4949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_44 (insn, operands);

            case 5:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_DImode)
                  && (
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_136 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0])
                  || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_148 (insn, operands);

            case 6:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_DImode)
                  && (
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_137 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0])
                  || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_149 (insn, operands);

            case 7:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (x86_64_general_operand (operands[1], E_DImode)
                  && (
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_138 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0])
                  || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_150 (insn, operands);

            case 8:
              if (!(
#line 14345 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_154 (insn, operands);

            default:
              return NULL;
            }

        case E_QImode:
          x4 = PATTERN (peep2_next_insn (1));
          switch (pattern1337 (x4, 
E_QImode))
            {
            case 0:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_QImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_127 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_139 (insn, operands);

            case 1:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_QImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_128 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_140 (insn, operands);

            case 2:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_QImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_129 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_141 (insn, operands);

            default:
              return NULL;
            }

        case E_HImode:
          x4 = PATTERN (peep2_next_insn (1));
          switch (pattern1337 (x4, 
E_HImode))
            {
            case 0:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_HImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_130 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_142 (insn, operands);

            case 1:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_HImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_131 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_143 (insn, operands);

            case 2:
              x5 = XVECEXP (x4, 0, 0);
              x6 = XEXP (x5, 1);
              x7 = XEXP (x6, 1);
              operands[1] = x7;
              if (general_operand (operands[1], E_HImode)
                  && 
#line 14051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!reg_mentioned_p (operands[0], operands[1])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_132 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (!rtx_equal_p (x7, operands[0]))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_144 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case ZERO_EXTRACT:
      if (pattern1057 (x3) != 0
          || !
#line 19113 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && !TARGET_USE_BT))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_166 (insn, operands);

    default:
      return NULL;
    }
}
