/* Application.c generated by valac 0.56.17, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright 2019 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <handy.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <libportal/portal.h>
#include <libportal-gtk3/portal-gtk3.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libical-glib/libical-glib.h>
#include <locale.h>

#define GETTEXT_PACKAGE "io.elementary.tasks"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_APPLICATION (tasks_application_get_type ())
#define TASKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_APPLICATION, TasksApplication))
#define TASKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_APPLICATION, TasksApplicationClass))
#define TASKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_APPLICATION))
#define TASKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_APPLICATION))
#define TASKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_APPLICATION, TasksApplicationClass))

typedef struct _TasksApplication TasksApplication;
typedef struct _TasksApplicationClass TasksApplicationClass;
typedef struct _TasksApplicationPrivate TasksApplicationPrivate;
enum  {
	TASKS_APPLICATION_0_PROPERTY,
	TASKS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* tasks_application_properties[TASKS_APPLICATION_NUM_PROPERTIES];

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TASKS_TYPE_TODAY_TASK_MONITOR (tasks_today_task_monitor_get_type ())
#define TASKS_TODAY_TASK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitor))
#define TASKS_TODAY_TASK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitorClass))
#define TASKS_IS_TODAY_TASK_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TODAY_TASK_MONITOR))
#define TASKS_IS_TODAY_TASK_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TODAY_TASK_MONITOR))
#define TASKS_TODAY_TASK_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TODAY_TASK_MONITOR, TasksTodayTaskMonitorClass))

typedef struct _TasksTodayTaskMonitor TasksTodayTaskMonitor;
typedef struct _TasksTodayTaskMonitorClass TasksTodayTaskMonitorClass;

#define TASKS_TYPE_MAIN_WINDOW (tasks_main_window_get_type ())
#define TASKS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindow))
#define TASKS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))
#define TASKS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))

typedef struct _TasksMainWindow TasksMainWindow;
typedef struct _TasksMainWindowClass TasksMainWindowClass;
#define __vala_XdpParent_free0(var) ((var == NULL) ? NULL : (var = (_vala_XdpParent_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TasksApplicationRequestBackgroundData TasksApplicationRequestBackgroundData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TasksApplication {
	GtkApplication parent_instance;
	TasksApplicationPrivate * priv;
};

struct _TasksApplicationClass {
	GtkApplicationClass parent_class;
};

struct _TasksApplicationPrivate {
	gboolean first_activation;
};

struct _Block1Data {
	int _ref_count_;
	TasksApplication* self;
	GtkSettings* gtk_settings;
};

struct _TasksApplicationRequestBackgroundData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TasksApplication* self;
	XdpPortal* portal;
	XdpPortal* _tmp0_;
	XdpParent* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	XdpParent* _tmp6_;
	XdpParent* parent;
	XdpParent* _tmp7_;
	GPtrArray* command;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	gboolean _tmp11_;
	XdpPortal* _tmp12_;
	GPtrArray* _tmp13_;
	GError* e;
	GError* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _inner_error0_;
};

static gint TasksApplication_private_offset;
static gpointer tasks_application_parent_class = NULL;
VALA_EXTERN gboolean tasks_application_run_in_background;
VALA_EXTERN GSettings* tasks_application_settings;
GSettings* tasks_application_settings = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;
TasksTaskModel* tasks_application_model = NULL;
gboolean tasks_application_run_in_background = FALSE;
static GeeHashMap* tasks_application_providers;
static GeeHashMap* tasks_application_providers = NULL;

VALA_EXTERN GType tasks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksApplication, g_object_unref)
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN TasksApplication* tasks_application_new (void);
VALA_EXTERN TasksApplication* tasks_application_construct (GType object_type);
static void tasks_application_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda23_ (Block1Data* _data1_,
                  GObject* obj,
                  GParamSpec* pspec);
static void ___lambda23__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda24_ (TasksApplication* self);
static void ___lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
VALA_EXTERN TasksTodayTaskMonitor* tasks_today_task_monitor_new (void);
VALA_EXTERN TasksTodayTaskMonitor* tasks_today_task_monitor_construct (GType object_type);
VALA_EXTERN GType tasks_today_task_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTodayTaskMonitor, g_object_unref)
VALA_EXTERN void tasks_today_task_monitor_start (TasksTodayTaskMonitor* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_today_task_monitor_start_finish (TasksTodayTaskMonitor* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void tasks_application_real_activate (GApplication* base);
VALA_EXTERN void tasks_application_request_background (TasksApplication* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void tasks_application_request_background_finish (TasksApplication* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN void tasks_task_model_start (TasksTaskModel* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void tasks_task_model_start_finish (TasksTaskModel* self,
                                    GAsyncResult* _res_);
VALA_EXTERN GType tasks_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksMainWindow, g_object_unref)
VALA_EXTERN TasksMainWindow* tasks_main_window_new (GtkApplication* application);
VALA_EXTERN TasksMainWindow* tasks_main_window_construct (GType object_type,
                                              GtkApplication* application);
static void tasks_application_request_background_data_free (gpointer _data);
static gboolean tasks_application_request_background_co (TasksApplicationRequestBackgroundData* _data_);
static void _vala_XdpParent_free (XdpParent* self);
static XdpParent* _vala_XdpParent_copy (XdpParent* self);
static void tasks_application_request_background_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN void tasks_application_set_task_color (ESource* source,
                                       GtkWidget* widget);
static gint tasks_application_main (gchar** args,
                             gint args_length1);
static GObject * tasks_application_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN TasksTaskModel* tasks_task_model_new (void);
VALA_EXTERN TasksTaskModel* tasks_task_model_construct (GType object_type);
static void tasks_application_finalize (GObject * obj);
static GType tasks_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry TASKS_APPLICATION_OPTIONS[2] = {{"background", 'b', (gint) 0, G_OPTION_ARG_NONE, &tasks_application_run_in_background, "Run the Application in background", NULL}, {NULL}};
const GtkTargetEntry TASKS_APPLICATION_DRAG_AND_DROP_TASK_DATA[1] = {{"text/uri-list", (guint) (GTK_TARGET_SAME_APP | GTK_TARGET_OTHER_WIDGET), (guint) 0}};

static inline gpointer
tasks_application_get_instance_private (TasksApplication* self)
{
	return G_STRUCT_MEMBER_P (self, TasksApplication_private_offset);
}

TasksApplication*
tasks_application_construct (GType object_type)
{
	TasksApplication * self = NULL;
	self = (TasksApplication*) g_object_new (object_type, "application-id", "io.elementary.tasks", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}

TasksApplication*
tasks_application_new (void)
{
	return tasks_application_construct (TASKS_TYPE_APPLICATION);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TasksApplication* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda23_ (Block1Data* _data1_,
             GObject* obj,
             GParamSpec* pspec)
{
	TasksApplication* self;
	GraniteSettingsColorScheme _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = granite_settings_get_prefers_color_scheme (G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_SETTINGS, GraniteSettings));
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda23__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda23_ (self, _sender, pspec);
}

static void
__lambda24_ (TasksApplication* self)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp3_ = _tmp2_;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
	}
}

static void
___lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda24_ ((TasksApplication*) self);
}

static void
tasks_application_real_startup (GApplication* base)
{
	TasksApplication * self;
	Block1Data* _data1_;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp4_;
	GdkScreen* _tmp5_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	TasksTodayTaskMonitor* _tmp10_;
	TasksTodayTaskMonitor* _tmp11_;
	self = (TasksApplication*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (tasks_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = granite_settings_get_default ();
	granite_settings = _tmp0_;
	_tmp1_ = gtk_settings_get_default ();
	_data1_->gtk_settings = _tmp1_;
	_tmp2_ = granite_settings_get_prefers_color_scheme (granite_settings);
	_tmp3_ = _tmp2_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda23__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp4_ = gtk_css_provider_new ();
	css_provider = _tmp4_;
	gtk_css_provider_load_from_resource (css_provider, "io/elementary/tasks/Application.css");
	_tmp5_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp5_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp6_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp6_;
	g_signal_connect_object (quit_action, "activate", (GCallback) ___lambda24__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp7_ = g_strdup ("<Control>q");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = tasks_today_task_monitor_new ();
	_tmp11_ = _tmp10_;
	tasks_today_task_monitor_start (_tmp11_, NULL, NULL);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (css_provider);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
tasks_application_real_activate (GApplication* base)
{
	TasksApplication * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp13_;
	GtkWindow* _tmp14_;
	self = (TasksApplication*) base;
	if (self->priv->first_activation) {
		self->priv->first_activation = FALSE;
		g_application_hold ((GApplication*) self);
	}
	if (tasks_application_run_in_background) {
		tasks_application_run_in_background = FALSE;
		tasks_application_request_background (self, NULL, NULL);
		return;
	}
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		TasksTaskModel* _tmp2_;
		TasksMainWindow* main_window = NULL;
		TasksMainWindow* _tmp3_;
		TasksMainWindow* _tmp4_;
		GtkAllocation rect = {0};
		GSettings* _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		TasksMainWindow* _tmp8_;
		GtkAllocation _tmp9_;
		GSettings* _tmp10_;
		TasksMainWindow* _tmp12_;
		_tmp2_ = tasks_application_model;
		tasks_task_model_start (_tmp2_, NULL, NULL);
		_tmp3_ = tasks_main_window_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp3_);
		main_window = _tmp3_;
		_tmp4_ = main_window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp4_);
		memset (&rect, 0, sizeof (GtkAllocation));
		_tmp5_ = tasks_application_settings;
		g_settings_get (_tmp5_, "window-size", "(ii)", &_tmp6_, &_tmp7_);
		rect.width = _tmp6_;
		rect.height = _tmp7_;
		_tmp8_ = main_window;
		_tmp9_ = rect;
		gtk_widget_set_allocation ((GtkWidget*) _tmp8_, &_tmp9_);
		_tmp10_ = tasks_application_settings;
		if (g_settings_get_boolean (_tmp10_, "window-maximized")) {
			TasksMainWindow* _tmp11_;
			_tmp11_ = main_window;
			gtk_window_maximize ((GtkWindow*) _tmp11_);
		}
		_tmp12_ = main_window;
		gtk_widget_show_all ((GtkWidget*) _tmp12_);
		_g_object_unref0 (main_window);
	}
	_tmp13_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp14_ = _tmp13_;
	gtk_window_present (_tmp14_);
}

static void
tasks_application_request_background_data_free (gpointer _data)
{
	TasksApplicationRequestBackgroundData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TasksApplicationRequestBackgroundData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tasks_application_request_background (TasksApplication* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	TasksApplicationRequestBackgroundData* _data_;
	TasksApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TasksApplicationRequestBackgroundData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tasks_application_request_background_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tasks_application_request_background_co (_data_);
}

void
tasks_application_request_background_finish (TasksApplication* self,
                                             GAsyncResult* _res_)
{
	TasksApplicationRequestBackgroundData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_XdpParent_free (XdpParent* self)
{
	g_boxed_free (xdp_parent_get_type (), self);
}

static XdpParent*
_vala_XdpParent_copy (XdpParent* self)
{
	return g_boxed_copy (xdp_parent_get_type (), self);
}

static gpointer
__vala_XdpParent_copy0 (gpointer self)
{
	return self ? _vala_XdpParent_copy (self) : NULL;
}

static void
tasks_application_request_background_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	TasksApplicationRequestBackgroundData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tasks_application_request_background_co (_data_);
}

static gboolean
tasks_application_request_background_co (TasksApplicationRequestBackgroundData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = xdp_portal_new ();
	_data_->portal = _data_->_tmp0_;
	_data_->_tmp2_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = gtk_application_get_active_window ((GtkApplication*) _data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = xdp_parent_new_gtk (_data_->_tmp5_);
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_data_->_tmp1_ = _data_->_tmp6_;
	} else {
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_data_->_tmp1_ = NULL;
	}
	_data_->_tmp7_ = __vala_XdpParent_copy0 (_data_->_tmp1_);
	_data_->parent = _data_->_tmp7_;
	_data_->_tmp8_ = g_ptr_array_new_full ((guint) 0, NULL);
	_data_->command = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->command;
	g_ptr_array_add (_data_->_tmp9_, "io.elementary.tasks");
	_data_->_tmp10_ = _data_->command;
	g_ptr_array_add (_data_->_tmp10_, "--background");
	{
		_data_->_tmp12_ = _data_->portal;
		_data_->_tmp13_ = _data_->command;
		_data_->command = NULL;
		_data_->_state_ = 1;
		xdp_portal_request_background (_data_->_tmp12_, _data_->parent, _ ("Tasks will automatically start when this device turns on and run when " \
"its window is closed so that it can send notifications for due tasks."), _data_->_tmp13_, XDP_BACKGROUND_FLAG_AUTOSTART, NULL, tasks_application_request_background_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = xdp_portal_request_background_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_data_->_tmp11_) {
			g_application_release ((GApplication*) _data_->self);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp14_ = _data_->e;
		if (g_error_matches (_data_->_tmp14_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_debug ("Application.vala:143: Request for autostart and background permissions" \
" denied: %s", _data_->_tmp16_);
			g_application_release ((GApplication*) _data_->self);
		} else {
			_data_->_tmp17_ = _data_->e;
			_data_->_tmp18_ = _data_->_tmp17_->message;
			g_warning ("Application.vala:146: Failed to request autostart and background permi" \
"ssions: %s", _data_->_tmp18_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (_data_->command);
		__vala_XdpParent_free0 (_data_->parent);
		__vala_XdpParent_free0 (_data_->_tmp1_);
		_g_object_unref0 (_data_->portal);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_ptr_array_unref0 (_data_->command);
	__vala_XdpParent_free0 (_data_->parent);
	__vala_XdpParent_free0 (_data_->_tmp1_);
	_g_object_unref0 (_data_->portal);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
tasks_application_set_task_color (ESource* source,
                                  GtkWidget* widget)
{
	GeeHashMap* _tmp0_;
	ESourceTaskList* task_list = NULL;
	ESourceExtension* _tmp2_;
	ESourceTaskList* _tmp3_;
	gchar* color = NULL;
	ESourceTaskList* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	const gchar* _tmp10_;
	GtkStyleContext* _tmp25_;
	GeeHashMap* _tmp26_;
	const gchar* _tmp27_;
	gpointer _tmp28_;
	GtkCssProvider* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (source != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = tasks_application_providers;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_css_provider_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (tasks_application_providers);
		tasks_application_providers = _tmp1_;
	}
	_tmp2_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, e_source_task_list_get_type (), ESourceTaskList));
	task_list = _tmp3_;
	_tmp4_ = task_list;
	_tmp5_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) 7);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	color = _tmp8_;
	_tmp9_ = tasks_application_providers;
	_tmp10_ = color;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, _tmp10_)) {
		gchar* style = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = color;
		_tmp12_ = color;
		_tmp13_ = g_strdup_printf ("\n" \
"                @define-color colorAccent %s;\n" \
"                @define-color accent_color %s;\n" \
"            ", _tmp11_, _tmp12_);
		style = _tmp13_;
		{
			GtkCssProvider* style_provider = NULL;
			GtkCssProvider* _tmp14_;
			GtkCssProvider* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeHashMap* _tmp20_;
			const gchar* _tmp21_;
			GtkCssProvider* _tmp22_;
			_tmp14_ = gtk_css_provider_new ();
			style_provider = _tmp14_;
			_tmp15_ = style_provider;
			_tmp16_ = style;
			_tmp17_ = style;
			_tmp18_ = strlen (_tmp17_);
			_tmp19_ = _tmp18_;
			gtk_css_provider_load_from_data (_tmp15_, _tmp16_, (gssize) _tmp19_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (style_provider);
				goto __catch0_g_error;
			}
			_tmp20_ = tasks_application_providers;
			_tmp21_ = color;
			_tmp22_ = style_provider;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp21_, _tmp22_);
			_g_object_unref0 (style_provider);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_critical ("Application.vala:171: Unable to set color: %s", _tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (style);
			_g_free0 (color);
			_g_object_unref0 (task_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (style);
	}
	_tmp25_ = gtk_widget_get_style_context (widget);
	_tmp26_ = tasks_application_providers;
	_tmp27_ = color;
	_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
	_tmp29_ = (GtkCssProvider*) _tmp28_;
	gtk_style_context_add_provider (_tmp25_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (_tmp29_);
	_g_free0 (color);
	_g_object_unref0 (task_list);
}

static gint
tasks_application_main (gchar** args,
                        gint args_length1)
{
	TasksApplication* app = NULL;
	TasksApplication* _tmp0_;
	gint res = 0;
	gint result;
	gtk_clutter_init ((gint*) (&args_length1), &args);
	_tmp0_ = tasks_application_new ();
	app = _tmp0_;
	res = g_application_run ((GApplication*) app, (gint) args_length1, args);
	i_cal_object_free_global_objects ();
	result = res;
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return tasks_application_main (argv, argc);
}

static GObject *
tasks_application_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksApplication * self;
	parent_class = G_OBJECT_CLASS (tasks_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_APPLICATION, TasksApplication);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_application_add_main_option_entries ((GApplication*) self, TASKS_APPLICATION_OPTIONS);
	return obj;
}

static void
tasks_application_class_init (TasksApplicationClass * klass,
                              gpointer klass_data)
{
	GSettings* _tmp0_;
	TasksTaskModel* _tmp1_;
	tasks_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) tasks_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) tasks_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = tasks_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_application_finalize;
	_tmp0_ = g_settings_new ("io.elementary.tasks");
	_g_object_unref0 (tasks_application_settings);
	tasks_application_settings = _tmp0_;
	_tmp1_ = tasks_task_model_new ();
	_g_object_unref0 (tasks_application_model);
	tasks_application_model = _tmp1_;
}

static void
tasks_application_instance_init (TasksApplication * self,
                                 gpointer klass)
{
	self->priv = tasks_application_get_instance_private (self);
	self->priv->first_activation = TRUE;
}

static void
tasks_application_finalize (GObject * obj)
{
	TasksApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_APPLICATION, TasksApplication);
	G_OBJECT_CLASS (tasks_application_parent_class)->finalize (obj);
}

static GType
tasks_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksApplication), 0, (GInstanceInitFunc) tasks_application_instance_init, NULL };
	GType tasks_application_type_id;
	tasks_application_type_id = g_type_register_static (gtk_application_get_type (), "TasksApplication", &g_define_type_info, 0);
	TasksApplication_private_offset = g_type_add_instance_private (tasks_application_type_id, sizeof (TasksApplicationPrivate));
	return tasks_application_type_id;
}

GType
tasks_application_get_type (void)
{
	static volatile gsize tasks_application_type_id__once = 0;
	if (g_once_init_enter (&tasks_application_type_id__once)) {
		GType tasks_application_type_id;
		tasks_application_type_id = tasks_application_get_type_once ();
		g_once_init_leave (&tasks_application_type_id__once, tasks_application_type_id);
	}
	return tasks_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

