/* MediaItem.c generated by valac 0.56.17, the Vala compiler
 * generated from MediaItem.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 */
/* This can be a show or a video */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM (audience_objects_media_item_get_type ())
#define AUDIENCE_OBJECTS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM))
#define AUDIENCE_OBJECTS_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItemClass))

typedef struct _AudienceObjectsMediaItem AudienceObjectsMediaItem;
typedef struct _AudienceObjectsMediaItemClass AudienceObjectsMediaItemClass;
typedef struct _AudienceObjectsMediaItemPrivate AudienceObjectsMediaItemPrivate;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
enum  {
	AUDIENCE_OBJECTS_MEDIA_ITEM_0_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY,
	AUDIENCE_OBJECTS_MEDIA_ITEM_NUM_PROPERTIES
};
static GParamSpec* audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AudienceObjectsMediaItemSetCustomPosterData AudienceObjectsMediaItemSetCustomPosterData;

#define AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER (audience_services_dbus_thumbnailer_get_type ())
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailer))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))

typedef struct _AudienceServicesDbusThumbnailer AudienceServicesDbusThumbnailer;
typedef struct _AudienceServicesDbusThumbnailerClass AudienceServicesDbusThumbnailerClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	AUDIENCE_OBJECTS_MEDIA_ITEM_TRASHED_SIGNAL,
	AUDIENCE_OBJECTS_MEDIA_ITEM_NUM_SIGNALS
};
static guint audience_objects_media_item_signals[AUDIENCE_OBJECTS_MEDIA_ITEM_NUM_SIGNALS] = {0};

struct _AudienceObjectsMediaItem {
	GObject parent_instance;
	AudienceObjectsMediaItemPrivate * priv;
};

struct _AudienceObjectsMediaItemClass {
	GObjectClass parent_class;
};

struct _AudienceObjectsMediaItemPrivate {
	gchar* _uri;
	AudienceObjectsMediaItem* _parent;
	GListStore* _children;
	gchar* _title;
	GdkPixbuf* _poster;
	AudienceServicesLibraryManager* manager;
	GFile* custom_poster_file;
	gchar* thumbnail_large_path;
};

struct _Block5Data {
	int _ref_count_;
	AudienceObjectsMediaItem* self;
	AudienceObjectsMediaItem* item;
};

struct _AudienceObjectsMediaItemSetCustomPosterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceObjectsMediaItem* self;
	GFile* new_poster_file;
	GdkPixbuf* new_poster;
	AudienceServicesLibraryManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GFile* _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

static gint AudienceObjectsMediaItem_private_offset;
static gpointer audience_objects_media_item_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_objects_media_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsMediaItem, g_object_unref)
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_new_show (const gchar* title,
                                                                const gchar* uri);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_construct_show (GType object_type,
                                                                      const gchar* title,
                                                                      const gchar* uri);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_new_video (const gchar* uri,
                                                                 const gchar* title,
                                                                 AudienceObjectsMediaItem* parent);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_construct_video (GType object_type,
                                                                       const gchar* uri,
                                                                       const gchar* title,
                                                                       AudienceObjectsMediaItem* parent);
static gboolean audience_objects_media_item_set_best_poster (AudienceObjectsMediaItem* self);
VALA_EXTERN const gchar* audience_objects_media_item_get_uri (AudienceObjectsMediaItem* self);
static void _vala_array_add5 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN const gchar* audience_objects_media_item_get_title (AudienceObjectsMediaItem* self);
static void _vala_array_add6 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_array_add7 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_array_add8 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN GdkPixbuf* audience_services_library_manager_get_poster_from_file (AudienceServicesLibraryManager* self,
                                                                   const gchar* poster_path);
VALA_EXTERN void audience_objects_media_item_set_poster (AudienceObjectsMediaItem* self,
                                             GdkPixbuf* value);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_get_parent (AudienceObjectsMediaItem* self);
VALA_EXTERN void audience_objects_media_item_update_poster (AudienceObjectsMediaItem* self,
                                                GdkPixbuf* new_poster);
VALA_EXTERN GdkPixbuf* audience_objects_media_item_get_poster (AudienceObjectsMediaItem* self);
VALA_EXTERN void audience_objects_media_item_add_item (AudienceObjectsMediaItem* self,
                                           AudienceObjectsMediaItem* item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda6_ (Block5Data* _data5_);
VALA_EXTERN GListStore* audience_objects_media_item_get_children (AudienceObjectsMediaItem* self);
static void ___lambda6__audience_objects_media_item_trashed (AudienceObjectsMediaItem* _sender,
                                                      gpointer self);
VALA_EXTERN gint audience_services_library_manager_library_item_sort_func (GObject* item1,
                                                               GObject* item2);
static gint _audience_services_library_manager_library_item_sort_func_gcompare_data_func (gconstpointer a,
                                                                                   gconstpointer b,
                                                                                   gpointer self);
static void audience_objects_media_item_set_custom_poster_data_free (gpointer _data);
VALA_EXTERN void audience_objects_media_item_set_custom_poster (AudienceObjectsMediaItem* self,
                                                    GFile* new_poster_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_objects_media_item_set_custom_poster_finish (AudienceObjectsMediaItem* self,
                                                           GAsyncResult* _res_);
static gboolean audience_objects_media_item_set_custom_poster_co (AudienceObjectsMediaItemSetCustomPosterData* _data_);
static void audience_objects_media_item_set_custom_poster_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
VALA_EXTERN void audience_objects_media_item_trash (AudienceObjectsMediaItem* self);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_new (void);
VALA_EXTERN AudienceObjectsMediaItem* audience_objects_media_item_construct (GType object_type);
static void audience_objects_media_item_set_uri (AudienceObjectsMediaItem* self,
                                          const gchar* value);
static void audience_objects_media_item_set_parent (AudienceObjectsMediaItem* self,
                                             AudienceObjectsMediaItem* value);
static void audience_objects_media_item_set_children (AudienceObjectsMediaItem* self,
                                               GListStore* value);
static void audience_objects_media_item_set_title (AudienceObjectsMediaItem* self,
                                            const gchar* value);
static GObject * audience_objects_media_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
VALA_EXTERN GType audience_services_dbus_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesDbusThumbnailer, g_object_unref)
VALA_EXTERN AudienceServicesDbusThumbnailer* audience_services_library_manager_get_thumbler (AudienceServicesLibraryManager* self);
static void _audience_objects_media_item___lambda8_ (AudienceObjectsMediaItem* self);
static void __audience_objects_media_item___lambda8__audience_services_dbus_thumbnailer_finished (AudienceServicesDbusThumbnailer* _sender,
                                                                                           guint handle,
                                                                                           gpointer self);
static void _audience_objects_media_item___lambda9_ (AudienceObjectsMediaItem* self,
                                              const gchar* _uri);
static void __audience_objects_media_item___lambda9__audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                                    const gchar* uri,
                                                                                                    gpointer self);
VALA_EXTERN GRegex* audience_services_library_manager_get_regex_year (AudienceServicesLibraryManager* self);
VALA_EXTERN void audience_services_dbus_thumbnailer_instand (AudienceServicesDbusThumbnailer* self,
                                                 GeeArrayList* uris,
                                                 GeeArrayList* mimes,
                                                 const gchar* size);
static void audience_objects_media_item_finalize (GObject * obj);
static GType audience_objects_media_item_get_type_once (void);
static void _vala_audience_objects_media_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_audience_objects_media_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_objects_media_item_get_instance_private (AudienceObjectsMediaItem* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceObjectsMediaItem_private_offset);
}

AudienceObjectsMediaItem*
audience_objects_media_item_construct_show (GType object_type,
                                            const gchar* title,
                                            const gchar* uri)
{
	AudienceObjectsMediaItem * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (AudienceObjectsMediaItem*) g_object_new (object_type, "title", title, "uri", uri, NULL);
	return self;
}

AudienceObjectsMediaItem*
audience_objects_media_item_new_show (const gchar* title,
                                      const gchar* uri)
{
	return audience_objects_media_item_construct_show (AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, title, uri);
}

AudienceObjectsMediaItem*
audience_objects_media_item_construct_video (GType object_type,
                                             const gchar* uri,
                                             const gchar* title,
                                             AudienceObjectsMediaItem* parent)
{
	AudienceObjectsMediaItem * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (AudienceObjectsMediaItem*) g_object_new (object_type, "uri", uri, "title", title, "parent", parent, NULL);
	return self;
}

AudienceObjectsMediaItem*
audience_objects_media_item_new_video (const gchar* uri,
                                       const gchar* title,
                                       AudienceObjectsMediaItem* parent)
{
	return audience_objects_media_item_construct_video (AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, uri, title, parent);
}

static void
_vala_array_add5 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
audience_objects_media_item_set_best_poster (AudienceObjectsMediaItem* self)
{
	GFile** possible_files = NULL;
	GFile** _tmp0_;
	gint possible_files_length1;
	gint _possible_files_size_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* dir = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* _tmp16_;
	GSettings* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile** _tmp26_;
	gint _tmp26__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	possible_files = _tmp0_;
	possible_files_length1 = 0;
	_possible_files_size_ = possible_files_length1;
	_tmp1_ = self->priv->_uri;
	_tmp2_ = g_file_new_for_uri (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_get_parent (_tmp3_);
	dir = _tmp4_;
	_tmp5_ = dir;
	_tmp6_ = file;
	_tmp7_ = g_file_get_basename (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".jpg", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_file_get_child (_tmp5_, _tmp10_);
	_vala_array_add5 (&possible_files, &possible_files_length1, &_possible_files_size_, _tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp12_ = dir;
	_tmp13_ = self->priv->_title;
	_tmp14_ = g_strconcat (_tmp13_, ".jpg", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_file_get_child (_tmp12_, _tmp15_);
	_vala_array_add6 (&possible_files, &possible_files_length1, &_possible_files_size_, _tmp16_);
	_g_free0 (_tmp15_);
	_tmp17_ = audience_settings;
	_tmp19_ = _tmp18_ = g_settings_get_strv (_tmp17_, "poster-names");
	{
		gchar** poster_name_collection = NULL;
		gint poster_name_collection_length1 = 0;
		gint _poster_name_collection_size_ = 0;
		gint poster_name_it = 0;
		poster_name_collection = _tmp19_;
		poster_name_collection_length1 = _vala_array_length (_tmp18_);
		for (poster_name_it = 0; poster_name_it < poster_name_collection_length1; poster_name_it = poster_name_it + 1) {
			gchar* _tmp20_;
			gchar* poster_name = NULL;
			_tmp20_ = g_strdup (poster_name_collection[poster_name_it]);
			poster_name = _tmp20_;
			{
				GFile* _tmp21_;
				const gchar* _tmp22_;
				GFile* _tmp23_;
				_tmp21_ = dir;
				_tmp22_ = poster_name;
				_tmp23_ = g_file_get_child (_tmp21_, _tmp22_);
				_vala_array_add7 (&possible_files, &possible_files_length1, &_possible_files_size_, _tmp23_);
				_g_free0 (poster_name);
			}
		}
		poster_name_collection = (_vala_array_free (poster_name_collection, poster_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp24_ = self->priv->thumbnail_large_path;
	_tmp25_ = g_file_new_for_path (_tmp24_);
	_vala_array_add8 (&possible_files, &possible_files_length1, &_possible_files_size_, _tmp25_);
	_tmp26_ = possible_files;
	_tmp26__length1 = possible_files_length1;
	{
		GFile** possible_file_collection = NULL;
		gint possible_file_collection_length1 = 0;
		gint _possible_file_collection_size_ = 0;
		gint possible_file_it = 0;
		possible_file_collection = _tmp26_;
		possible_file_collection_length1 = _tmp26__length1;
		for (possible_file_it = 0; possible_file_it < possible_file_collection_length1; possible_file_it = possible_file_it + 1) {
			GFile* _tmp27_;
			GFile* possible_file = NULL;
			_tmp27_ = _g_object_ref0 (possible_file_collection[possible_file_it]);
			possible_file = _tmp27_;
			{
				GFile* _tmp28_;
				_tmp28_ = possible_file;
				if (g_file_query_exists (_tmp28_, NULL)) {
					AudienceServicesLibraryManager* _tmp29_;
					GFile* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					GdkPixbuf* _tmp33_;
					GdkPixbuf* _tmp34_;
					AudienceObjectsMediaItem* _tmp35_;
					_tmp29_ = self->priv->manager;
					_tmp30_ = possible_file;
					_tmp31_ = g_file_get_path (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = audience_services_library_manager_get_poster_from_file (_tmp29_, _tmp32_);
					_tmp34_ = _tmp33_;
					audience_objects_media_item_set_poster (self, _tmp34_);
					_g_object_unref0 (_tmp34_);
					_g_free0 (_tmp32_);
					_tmp35_ = self->priv->_parent;
					if (_tmp35_ != NULL) {
						AudienceObjectsMediaItem* _tmp36_;
						GdkPixbuf* _tmp37_;
						_tmp36_ = self->priv->_parent;
						_tmp37_ = self->priv->_poster;
						audience_objects_media_item_update_poster (_tmp36_, _tmp37_);
					}
					result = TRUE;
					_g_object_unref0 (possible_file);
					_g_object_unref0 (dir);
					_g_object_unref0 (file);
					possible_files = (_vala_array_free (possible_files, possible_files_length1, (GDestroyNotify) g_object_unref), NULL);
					return result;
				}
				_g_object_unref0 (possible_file);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (dir);
	_g_object_unref0 (file);
	possible_files = (_vala_array_free (possible_files, possible_files_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AudienceObjectsMediaItem* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->item);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda6_ (Block5Data* _data5_)
{
	AudienceObjectsMediaItem* self;
	guint position = 0U;
	GListStore* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	self = _data5_->self;
	_tmp0_ = self->priv->_children;
	_tmp2_ = g_list_store_find (_tmp0_, (GObject*) _data5_->item, &_tmp1_);
	position = _tmp1_;
	if (_tmp2_) {
		GListStore* _tmp3_;
		_tmp3_ = self->priv->_children;
		g_list_store_remove (_tmp3_, position);
	}
}

static void
___lambda6__audience_objects_media_item_trashed (AudienceObjectsMediaItem* _sender,
                                                 gpointer self)
{
	__lambda6_ (self);
}

static gint
_audience_services_library_manager_library_item_sort_func_gcompare_data_func (gconstpointer a,
                                                                              gconstpointer b,
                                                                              gpointer self)
{
	gint result;
	result = audience_services_library_manager_library_item_sort_func ((GObject*) a, (GObject*) b);
	return result;
}

void
audience_objects_media_item_add_item (AudienceObjectsMediaItem* self,
                                      AudienceObjectsMediaItem* item)
{
	Block5Data* _data5_;
	AudienceObjectsMediaItem* _tmp0_;
	GListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (item);
	_g_object_unref0 (_data5_->item);
	_data5_->item = _tmp0_;
	g_signal_connect_data (_data5_->item, "trashed", (GCallback) ___lambda6__audience_objects_media_item_trashed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp1_ = self->priv->_children;
	g_list_store_insert_sorted (_tmp1_, (GObject*) _data5_->item, _audience_services_library_manager_library_item_sort_func_gcompare_data_func, NULL);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

void
audience_objects_media_item_update_poster (AudienceObjectsMediaItem* self,
                                           GdkPixbuf* new_poster)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_poster != NULL);
	_tmp0_ = self->priv->_poster;
	if (_tmp0_ != NULL) {
		return;
	}
	audience_objects_media_item_set_poster (self, new_poster);
}

static void
audience_objects_media_item_set_custom_poster_data_free (gpointer _data)
{
	AudienceObjectsMediaItemSetCustomPosterData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->new_poster_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceObjectsMediaItemSetCustomPosterData, _data_);
}

void
audience_objects_media_item_set_custom_poster (AudienceObjectsMediaItem* self,
                                               GFile* new_poster_file,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	AudienceObjectsMediaItemSetCustomPosterData* _data_;
	AudienceObjectsMediaItem* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_poster_file != NULL);
	_data_ = g_slice_new0 (AudienceObjectsMediaItemSetCustomPosterData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_objects_media_item_set_custom_poster_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_poster_file);
	_g_object_unref0 (_data_->new_poster_file);
	_data_->new_poster_file = _tmp1_;
	audience_objects_media_item_set_custom_poster_co (_data_);
}

void
audience_objects_media_item_set_custom_poster_finish (AudienceObjectsMediaItem* self,
                                                      GAsyncResult* _res_)
{
	AudienceObjectsMediaItemSetCustomPosterData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
audience_objects_media_item_set_custom_poster_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	AudienceObjectsMediaItemSetCustomPosterData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	audience_objects_media_item_set_custom_poster_co (_data_);
}

static gboolean
audience_objects_media_item_set_custom_poster_co (AudienceObjectsMediaItemSetCustomPosterData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->manager;
	_data_->_tmp1_ = g_file_get_path (_data_->new_poster_file);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = audience_services_library_manager_get_poster_from_file (_data_->_tmp0_, _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->new_poster = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->new_poster;
	if (_data_->_tmp5_ == NULL) {
		_g_object_unref0 (_data_->new_poster);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->new_poster;
	audience_objects_media_item_set_poster (_data_->self, _data_->_tmp6_);
	{
		_data_->_tmp7_ = _data_->self->priv->custom_poster_file;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->new_poster_file, _data_->_tmp7_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, audience_objects_media_item_set_custom_poster_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->new_poster_file, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("MediaItem.vala:129: Failed to copy custom poster: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->new_poster);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->new_poster);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
audience_objects_media_item_trash (AudienceObjectsMediaItem* self)
{
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				AudienceObjectsMediaItem* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_children;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->_children;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
				audience_objects_media_item_trash (_tmp5_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp6_ = self->priv->_uri;
	if (_tmp6_ != NULL) {
		{
			GFile* file = NULL;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			_tmp7_ = self->priv->_uri;
			_tmp8_ = g_file_new_for_uri (_tmp7_);
			file = _tmp8_;
			_tmp9_ = file;
			g_file_trash (_tmp9_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			_g_object_unref0 (file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("MediaItem.vala:143: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, audience_objects_media_item_signals[AUDIENCE_OBJECTS_MEDIA_ITEM_TRASHED_SIGNAL], 0);
}

AudienceObjectsMediaItem*
audience_objects_media_item_construct (GType object_type)
{
	AudienceObjectsMediaItem * self = NULL;
	self = (AudienceObjectsMediaItem*) g_object_new (object_type, NULL);
	return self;
}

AudienceObjectsMediaItem*
audience_objects_media_item_new (void)
{
	return audience_objects_media_item_construct (AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM);
}

const gchar*
audience_objects_media_item_get_uri (AudienceObjectsMediaItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
audience_objects_media_item_set_uri (AudienceObjectsMediaItem* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_media_item_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY]);
	}
}

AudienceObjectsMediaItem*
audience_objects_media_item_get_parent (AudienceObjectsMediaItem* self)
{
	AudienceObjectsMediaItem* result;
	AudienceObjectsMediaItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

static void
audience_objects_media_item_set_parent (AudienceObjectsMediaItem* self,
                                        AudienceObjectsMediaItem* value)
{
	AudienceObjectsMediaItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_media_item_get_parent (self);
	if (old_value != value) {
		AudienceObjectsMediaItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY]);
	}
}

GListStore*
audience_objects_media_item_get_children (AudienceObjectsMediaItem* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children;
	result = _tmp0_;
	return result;
}

static void
audience_objects_media_item_set_children (AudienceObjectsMediaItem* self,
                                          GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_media_item_get_children (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_children);
		self->priv->_children = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY]);
	}
}

const gchar*
audience_objects_media_item_get_title (AudienceObjectsMediaItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
audience_objects_media_item_set_title (AudienceObjectsMediaItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_media_item_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY]);
	}
}

GdkPixbuf*
audience_objects_media_item_get_poster (AudienceObjectsMediaItem* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_poster;
	result = _tmp0_;
	return result;
}

void
audience_objects_media_item_set_poster (AudienceObjectsMediaItem* self,
                                        GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_media_item_get_poster (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_poster);
		self->priv->_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY]);
	}
}

static void
_audience_objects_media_item___lambda8_ (AudienceObjectsMediaItem* self)
{
	audience_objects_media_item_set_best_poster (self);
}

static void
__audience_objects_media_item___lambda8__audience_services_dbus_thumbnailer_finished (AudienceServicesDbusThumbnailer* _sender,
                                                                                      guint handle,
                                                                                      gpointer self)
{
	_audience_objects_media_item___lambda8_ ((AudienceObjectsMediaItem*) self);
}

static void
_audience_objects_media_item___lambda9_ (AudienceObjectsMediaItem* self,
                                         const gchar* _uri)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (_uri != NULL);
	_tmp1_ = self->priv->_uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_uri;
		_tmp0_ = g_strcmp0 (_tmp2_, _uri) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, audience_objects_media_item_signals[AUDIENCE_OBJECTS_MEDIA_ITEM_TRASHED_SIGNAL], 0);
	}
}

static void
__audience_objects_media_item___lambda9__audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                               const gchar* uri,
                                                                                               gpointer self)
{
	_audience_objects_media_item___lambda9_ ((AudienceObjectsMediaItem*) self, uri);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GObject *
audience_objects_media_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceObjectsMediaItem * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	AudienceServicesLibraryManager* _tmp2_;
	AudienceServicesLibraryManager* _tmp3_;
	AudienceServicesDbusThumbnailer* _tmp4_;
	AudienceServicesDbusThumbnailer* _tmp5_;
	AudienceServicesLibraryManager* _tmp6_;
	GMatchInfo* info = NULL;
	AudienceServicesLibraryManager* _tmp7_;
	GRegex* _tmp8_;
	GRegex* _tmp9_;
	const gchar* _tmp10_;
	GMatchInfo* _tmp11_ = NULL;
	gboolean _tmp12_;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_;
	gchar* hash_file_poster = NULL;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GFile* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GFile* _tmp37_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (audience_objects_media_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	_tmp0_ = g_list_store_new (AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM);
	_tmp1_ = _tmp0_;
	audience_objects_media_item_set_children (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = audience_services_library_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	_tmp3_ = self->priv->manager;
	_tmp4_ = audience_services_library_manager_get_thumbler (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "finished", (GCallback) __audience_objects_media_item___lambda8__audience_services_dbus_thumbnailer_finished, self, 0);
	_tmp6_ = self->priv->manager;
	g_signal_connect_object (_tmp6_, "video-file-deleted", (GCallback) __audience_objects_media_item___lambda9__audience_services_library_manager_video_file_deleted, self, 0);
	_tmp7_ = self->priv->manager;
	_tmp8_ = audience_services_library_manager_get_regex_year (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_title;
	_tmp12_ = g_regex_match (_tmp9_, _tmp10_, 0, &_tmp11_);
	_g_match_info_unref0 (info);
	info = _tmp11_;
	if (_tmp12_) {
		const gchar* _tmp13_;
		GMatchInfo* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = self->priv->_title;
		_tmp14_ = info;
		_tmp15_ = g_match_info_fetch (_tmp14_, 0);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_replace (_tmp13_, _tmp18_, "");
		_tmp20_ = _tmp19_;
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		audience_objects_media_item_set_title (self, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	_tmp24_ = self->priv->_uri;
	_tmp23_ = _tmp24_;
	if (_tmp23_ == NULL) {
		const gchar* _tmp25_;
		_tmp25_ = self->priv->_title;
		_tmp23_ = _tmp25_;
	}
	_tmp26_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp23_, (gsize) -1);
	hash_file_poster = _tmp26_;
	_tmp27_ = g_get_user_data_dir ();
	_tmp28_ = hash_file_poster;
	_tmp29_ = g_strconcat (_tmp28_, ".jpg", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_file_new_build_filename (_tmp27_, _tmp30_, NULL);
	_g_object_unref0 (self->priv->custom_poster_file);
	self->priv->custom_poster_file = _tmp31_;
	_g_free0 (_tmp30_);
	_tmp32_ = g_get_user_cache_dir ();
	_tmp33_ = hash_file_poster;
	_tmp34_ = g_strconcat (_tmp33_, ".png", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_build_filename (_tmp32_, "thumbnails", "large", _tmp35_, NULL);
	_g_free0 (self->priv->thumbnail_large_path);
	self->priv->thumbnail_large_path = _tmp36_;
	_g_free0 (_tmp35_);
	_tmp37_ = self->priv->custom_poster_file;
	if (g_file_query_exists (_tmp37_, NULL)) {
		AudienceServicesLibraryManager* _tmp38_;
		GFile* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GdkPixbuf* _tmp42_;
		GdkPixbuf* _tmp43_;
		_tmp38_ = self->priv->manager;
		_tmp39_ = self->priv->custom_poster_file;
		_tmp40_ = g_file_get_path (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = audience_services_library_manager_get_poster_from_file (_tmp38_, _tmp41_);
		_tmp43_ = _tmp42_;
		audience_objects_media_item_set_poster (self, _tmp43_);
		_g_object_unref0 (_tmp43_);
		_g_free0 (_tmp41_);
	} else {
		gboolean _tmp44_ = FALSE;
		const gchar* _tmp45_;
		_tmp45_ = self->priv->_uri;
		if (_tmp45_ != NULL) {
			_tmp44_ = !audience_objects_media_item_set_best_poster (self);
		} else {
			_tmp44_ = FALSE;
		}
		if (_tmp44_) {
			GeeArrayList* uris = NULL;
			GeeArrayList* _tmp46_;
			GeeArrayList* mimes = NULL;
			GeeArrayList* _tmp47_;
			GeeArrayList* _tmp48_;
			const gchar* _tmp49_;
			AudienceServicesLibraryManager* _tmp60_;
			AudienceServicesDbusThumbnailer* _tmp61_;
			AudienceServicesDbusThumbnailer* _tmp62_;
			GeeArrayList* _tmp63_;
			GeeArrayList* _tmp64_;
			_tmp46_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
			uris = _tmp46_;
			_tmp47_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
			mimes = _tmp47_;
			_tmp48_ = uris;
			_tmp49_ = self->priv->_uri;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
			{
				GFileInfo* file_info = NULL;
				const gchar* _tmp50_;
				GFile* _tmp51_;
				GFile* _tmp52_;
				GFileInfo* _tmp53_;
				GFileInfo* _tmp54_;
				GeeArrayList* _tmp55_;
				GFileInfo* _tmp56_;
				const gchar* _tmp57_;
				_tmp50_ = self->priv->_uri;
				_tmp51_ = g_file_new_for_uri (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = g_file_query_info (_tmp52_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
				_tmp54_ = _tmp53_;
				_g_object_unref0 (_tmp52_);
				file_info = _tmp54_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp55_ = mimes;
				_tmp56_ = file_info;
				_tmp57_ = g_file_info_get_content_type (_tmp56_);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp55_, _tmp57_);
				_g_object_unref0 (file_info);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp58_;
				const gchar* _tmp59_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp58_ = e;
				_tmp59_ = _tmp58_->message;
				g_warning ("MediaItem.vala:64: Failed to query file info: %s", _tmp59_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (mimes);
				_g_object_unref0 (uris);
				_g_free0 (hash_file_poster);
				_g_match_info_unref0 (info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp60_ = self->priv->manager;
			_tmp61_ = audience_services_library_manager_get_thumbler (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = uris;
			_tmp64_ = mimes;
			audience_services_dbus_thumbnailer_instand (_tmp62_, _tmp63_, _tmp64_, "large");
			_g_object_unref0 (mimes);
			_g_object_unref0 (uris);
		}
	}
	_g_free0 (hash_file_poster);
	_g_match_info_unref0 (info);
	return obj;
}

static void
audience_objects_media_item_class_init (AudienceObjectsMediaItemClass * klass,
                                        gpointer klass_data)
{
	audience_objects_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceObjectsMediaItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_objects_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_objects_media_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_objects_media_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_objects_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY] = g_param_spec_object ("children", "children", "children", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY, audience_objects_media_item_properties[AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY] = g_param_spec_object ("poster", "poster", "poster", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	audience_objects_media_item_signals[AUDIENCE_OBJECTS_MEDIA_ITEM_TRASHED_SIGNAL] = g_signal_new ("trashed", AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
audience_objects_media_item_instance_init (AudienceObjectsMediaItem * self,
                                           gpointer klass)
{
	self->priv = audience_objects_media_item_get_instance_private (self);
	self->priv->_uri = NULL;
	self->priv->_poster = NULL;
}

static void
audience_objects_media_item_finalize (GObject * obj)
{
	AudienceObjectsMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->_parent);
	_g_object_unref0 (self->priv->_children);
	_g_free0 (self->priv->_title);
	_g_object_unref0 (self->priv->_poster);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->custom_poster_file);
	_g_free0 (self->priv->thumbnail_large_path);
	G_OBJECT_CLASS (audience_objects_media_item_parent_class)->finalize (obj);
}

static GType
audience_objects_media_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceObjectsMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_objects_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceObjectsMediaItem), 0, (GInstanceInitFunc) audience_objects_media_item_instance_init, NULL };
	GType audience_objects_media_item_type_id;
	audience_objects_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "AudienceObjectsMediaItem", &g_define_type_info, 0);
	AudienceObjectsMediaItem_private_offset = g_type_add_instance_private (audience_objects_media_item_type_id, sizeof (AudienceObjectsMediaItemPrivate));
	return audience_objects_media_item_type_id;
}

GType
audience_objects_media_item_get_type (void)
{
	static volatile gsize audience_objects_media_item_type_id__once = 0;
	if (g_once_init_enter (&audience_objects_media_item_type_id__once)) {
		GType audience_objects_media_item_type_id;
		audience_objects_media_item_type_id = audience_objects_media_item_get_type_once ();
		g_once_init_leave (&audience_objects_media_item_type_id__once, audience_objects_media_item_type_id);
	}
	return audience_objects_media_item_type_id__once;
}

static void
_vala_audience_objects_media_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	AudienceObjectsMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	switch (property_id) {
		case AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY:
		g_value_set_string (value, audience_objects_media_item_get_uri (self));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY:
		g_value_set_object (value, audience_objects_media_item_get_parent (self));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY:
		g_value_set_object (value, audience_objects_media_item_get_children (self));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY:
		g_value_set_string (value, audience_objects_media_item_get_title (self));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY:
		g_value_set_object (value, audience_objects_media_item_get_poster (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_objects_media_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	AudienceObjectsMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_OBJECTS_TYPE_MEDIA_ITEM, AudienceObjectsMediaItem);
	switch (property_id) {
		case AUDIENCE_OBJECTS_MEDIA_ITEM_URI_PROPERTY:
		audience_objects_media_item_set_uri (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_PARENT_PROPERTY:
		audience_objects_media_item_set_parent (self, g_value_get_object (value));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_CHILDREN_PROPERTY:
		audience_objects_media_item_set_children (self, g_value_get_object (value));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_TITLE_PROPERTY:
		audience_objects_media_item_set_title (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_MEDIA_ITEM_POSTER_PROPERTY:
		audience_objects_media_item_set_poster (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

