/* ffmpeg-post-processor.c generated by valac 0.56.17, the Vala compiler
 * generated from ffmpeg-post-processor.vala, do not modify */

/*
Peek Copyright (c) 2017-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PEEK_POST_PROCESSING_FFMPEG_POST_PROCESSOR_0_PROPERTY,
	PEEK_POST_PROCESSING_FFMPEG_POST_PROCESSOR_NUM_PROPERTIES
};
static GParamSpec* peek_post_processing_ffmpeg_post_processor_properties[PEEK_POST_PROCESSING_FFMPEG_POST_PROCESSOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PeekPostProcessingFfmpegPostProcessorProcessAsyncData PeekPostProcessingFfmpegPostProcessorProcessAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData;
typedef struct _PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData;

struct _PeekPostProcessingFfmpegPostProcessorPrivate {
	PeekRecordingRecordingConfig* config;
};

struct _PeekPostProcessingFfmpegPostProcessorProcessAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PeekPostProcessingFfmpegPostProcessor* self;
	GArray* files;
	GArray* result;
	GFile* input_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* palette_file;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* output_file;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GError* e;
	FILE* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GArray* _result_;
	GArray* _tmp13_;
	GArray* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GError* _inner_error0_;
};

struct _PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PeekPostProcessingFfmpegPostProcessor* self;
	GFile* file;
	GFile* result;
	gchar* palette_file;
	gchar* _tmp0_;
	gchar** args;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PeekRecordingRecordingConfig* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* e;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GError* _vala1_e;
	FILE* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	GError* _inner_error0_;
};

struct _PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PeekPostProcessingFfmpegPostProcessor* self;
	GFile* input_file;
	GFile* palette_file;
	GFile* result;
	gchar* extension;
	PeekRecordingRecordingConfig* _tmp0_;
	PeekOutputFormat _tmp1_;
	PeekOutputFormat _tmp2_;
	gchar* _tmp3_;
	gchar* output_file;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GArray* argv;
	GArray* _tmp6_;
	GArray* _tmp7_;
	gchar* _tmp8_;
	GArray* _tmp9_;
	gchar* _tmp10_;
	GArray* _tmp11_;
	gchar* _tmp12_;
	GArray* _tmp13_;
	gchar* _tmp14_;
	GArray* _tmp15_;
	gchar* _tmp16_;
	GArray* _tmp17_;
	gchar* _tmp18_;
	GArray* _tmp19_;
	gchar* _tmp20_;
	GArray* _tmp21_;
	PeekRecordingRecordingConfig* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_;
	PeekRecordingRecordingConfig* _tmp26_;
	PeekOutputFormat _tmp27_;
	PeekOutputFormat _tmp28_;
	GArray* _tmp29_;
	gchar* _tmp30_;
	GArray* _tmp31_;
	gchar* _tmp32_;
	GArray* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GArray* _tmp36_;
	gpointer* _tmp37_;
	gint _tmp37__length1;
	GError* e;
	const gchar* _tmp38_;
	GError* _tmp39_;
	GError* _tmp40_;
	const gchar* _tmp41_;
	GFile* _tmp42_;
	GError* _vala1_e;
	GError* _tmp43_;
	const gchar* _tmp44_;
	GError* _tmp45_;
	GError* _inner_error0_;
};

static gint PeekPostProcessingFfmpegPostProcessor_private_offset;
static gpointer peek_post_processing_ffmpeg_post_processor_parent_class = NULL;

static void peek_post_processing_ffmpeg_post_processor_real_process_async_data_free (gpointer _data);
static void peek_post_processing_ffmpeg_post_processor_real_process_async (PeekPostProcessingCliPostProcessor* base,
                                                                    GArray* files,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean peek_post_processing_ffmpeg_post_processor_real_process_async_co (PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_);
static void peek_post_processing_ffmpeg_post_processor_generate_palette_async (PeekPostProcessingFfmpegPostProcessor* self,
                                                                        GFile* file,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static GFile* peek_post_processing_ffmpeg_post_processor_generate_palette_finish (PeekPostProcessingFfmpegPostProcessor* self,
                                                                           GAsyncResult* _res_,
                                                                           GError** error);
static void peek_post_processing_ffmpeg_post_processor_process_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void peek_post_processing_ffmpeg_post_processor_generate_animation_async (PeekPostProcessingFfmpegPostProcessor* self,
                                                                          GFile* input_file,
                                                                          GFile* palette_file,
                                                                          GAsyncReadyCallback _callback_,
                                                                          gpointer _user_data_);
static GFile* peek_post_processing_ffmpeg_post_processor_generate_animation_finish (PeekPostProcessingFfmpegPostProcessor* self,
                                                                             GAsyncResult* _res_,
                                                                             GError** error);
static void _g_object_unref0_ (gpointer var);
static void _vala_GFile_free_function_content_of (gpointer data);
static void peek_post_processing_ffmpeg_post_processor_generate_palette_async_data_free (gpointer _data);
static gboolean peek_post_processing_ffmpeg_post_processor_generate_palette_async_co (PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_);
static void peek_post_processing_ffmpeg_post_processor_generate_palette_async_ready (GObject* source_object,
                                                                              GAsyncResult* _res_,
                                                                              gpointer _user_data_);
static void peek_post_processing_ffmpeg_post_processor_generate_animation_async_data_free (gpointer _data);
static gboolean peek_post_processing_ffmpeg_post_processor_generate_animation_async_co (PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static void peek_post_processing_ffmpeg_post_processor_generate_animation_async_ready (GObject* source_object,
                                                                                GAsyncResult* _res_,
                                                                                gpointer _user_data_);
static void peek_post_processing_ffmpeg_post_processor_finalize (GObject * obj);
static GType peek_post_processing_ffmpeg_post_processor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
peek_post_processing_ffmpeg_post_processor_get_instance_private (PeekPostProcessingFfmpegPostProcessor* self)
{
	return G_STRUCT_MEMBER_P (self, PeekPostProcessingFfmpegPostProcessor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PeekPostProcessingFfmpegPostProcessor*
peek_post_processing_ffmpeg_post_processor_construct (GType object_type,
                                                      PeekRecordingRecordingConfig* config)
{
	PeekPostProcessingFfmpegPostProcessor * self = NULL;
	PeekRecordingRecordingConfig* _tmp0_;
	g_return_val_if_fail (config != NULL, NULL);
	self = (PeekPostProcessingFfmpegPostProcessor*) peek_post_processing_cli_post_processor_construct (object_type);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	return self;
}

PeekPostProcessingFfmpegPostProcessor*
peek_post_processing_ffmpeg_post_processor_new (PeekRecordingRecordingConfig* config)
{
	return peek_post_processing_ffmpeg_post_processor_construct (PEEK_POST_PROCESSING_TYPE_FFMPEG_POST_PROCESSOR, config);
}

static void
peek_post_processing_ffmpeg_post_processor_real_process_async_data_free (gpointer _data)
{
	PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->files);
	_g_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PeekPostProcessingFfmpegPostProcessorProcessAsyncData, _data_);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
peek_post_processing_ffmpeg_post_processor_real_process_async (PeekPostProcessingCliPostProcessor* base,
                                                               GArray* files,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessor * self;
	PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_;
	PeekPostProcessingFfmpegPostProcessor* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (files != NULL);
	self = (PeekPostProcessingFfmpegPostProcessor*) base;
	_data_ = g_slice_new0 (PeekPostProcessingFfmpegPostProcessorProcessAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, peek_post_processing_ffmpeg_post_processor_real_process_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_array_ref0 (files);
	_g_array_unref0 (_data_->files);
	_data_->files = _tmp1_;
	peek_post_processing_ffmpeg_post_processor_real_process_async_co (_data_);
}

static GArray*
peek_post_processing_ffmpeg_post_processor_process_finish (PeekPostProcessingCliPostProcessor* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	GArray* result;
	PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
peek_post_processing_ffmpeg_post_processor_process_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	peek_post_processing_ffmpeg_post_processor_real_process_async_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_GFile_free_function_content_of (gpointer data)
{
	GFile* self;
	self = *((GFile**) data);
	_g_object_unref0_ (self);
}

static gboolean
peek_post_processing_ffmpeg_post_processor_real_process_async_co (PeekPostProcessingFfmpegPostProcessorProcessAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_array_index (_data_->files, GFile*, (guint) 0);
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->input_file = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->input_file;
	_data_->_state_ = 1;
	peek_post_processing_ffmpeg_post_processor_generate_palette_async (_data_->self, _data_->_tmp2_, peek_post_processing_ffmpeg_post_processor_process_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = peek_post_processing_ffmpeg_post_processor_generate_palette_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->palette_file = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->input_file);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->input_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp4_ = _data_->palette_file;
	if (_data_->_tmp4_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->input_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->input_file;
	_data_->_tmp6_ = _data_->palette_file;
	_data_->_state_ = 2;
	peek_post_processing_ffmpeg_post_processor_generate_animation_async (_data_->self, _data_->_tmp5_, _data_->_tmp6_, peek_post_processing_ffmpeg_post_processor_process_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp7_ = peek_post_processing_ffmpeg_post_processor_generate_animation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->output_file = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->palette_file);
			_g_object_unref0 (_data_->input_file);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->palette_file);
			_g_object_unref0 (_data_->input_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp8_ = _data_->palette_file;
		_data_->_state_ = 3;
		g_file_delete_async (_data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, peek_post_processing_ffmpeg_post_processor_process_async_ready, _data_);
		return FALSE;
		_state_3:
		g_file_delete_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = stderr;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		fprintf (_data_->_tmp9_, "Error deleting palette file: %s\n", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->output_file);
			_g_object_unref0 (_data_->palette_file);
			_g_object_unref0 (_data_->input_file);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->output_file);
			_g_object_unref0 (_data_->palette_file);
			_g_object_unref0 (_data_->input_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp12_ = _data_->output_file;
	if (_data_->_tmp12_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->output_file);
		_g_object_unref0 (_data_->palette_file);
		_g_object_unref0 (_data_->input_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = g_array_new (TRUE, TRUE, sizeof (GFile*));
	g_array_set_clear_func (_data_->_tmp13_, (GDestroyNotify) _vala_GFile_free_function_content_of);
	_data_->_result_ = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->_result_;
	_data_->_tmp15_ = _data_->output_file;
	_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
	g_array_append_val (_data_->_tmp14_, _data_->_tmp16_);
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->output_file);
	_g_object_unref0 (_data_->palette_file);
	_g_object_unref0 (_data_->input_file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
peek_post_processing_ffmpeg_post_processor_is_available (void)
{
	gboolean result;
	result = peek_utils_check_for_executable ("ffmpeg");
	return result;
}

static void
peek_post_processing_ffmpeg_post_processor_generate_palette_async_data_free (gpointer _data)
{
	PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData, _data_);
}

static void
peek_post_processing_ffmpeg_post_processor_generate_palette_async (PeekPostProcessingFfmpegPostProcessor* self,
                                                                   GFile* file,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_;
	PeekPostProcessingFfmpegPostProcessor* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, peek_post_processing_ffmpeg_post_processor_generate_palette_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	peek_post_processing_ffmpeg_post_processor_generate_palette_async_co (_data_);
}

static GFile*
peek_post_processing_ffmpeg_post_processor_generate_palette_finish (PeekPostProcessingFfmpegPostProcessor* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	GFile* result;
	PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
peek_post_processing_ffmpeg_post_processor_generate_palette_async_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	peek_post_processing_ffmpeg_post_processor_generate_palette_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
peek_post_processing_ffmpeg_post_processor_generate_palette_async_co (PeekPostProcessingFfmpegPostProcessorGeneratePaletteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = peek_utils_create_temp_file ("png", &_data_->_inner_error0_);
		_data_->palette_file = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp1_ = g_strdup ("ffmpeg");
		_data_->_tmp2_ = g_strdup ("-y");
		_data_->_tmp3_ = g_strdup ("-i");
		_data_->_tmp4_ = g_file_get_path (_data_->file);
		_data_->_tmp5_ = g_strdup ("-vf");
		_data_->_tmp6_ = _data_->self->priv->config;
		_data_->_tmp7_ = peek_recording_recording_config_get_framerate (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_strdup_printf ("fps=%d,palettegen", _data_->_tmp8_);
		_data_->_tmp10_ = _data_->palette_file;
		_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
		_data_->_tmp12_ = g_new0 (gchar*, 7 + 1);
		_data_->_tmp12_[0] = _data_->_tmp1_;
		_data_->_tmp12_[1] = _data_->_tmp2_;
		_data_->_tmp12_[2] = _data_->_tmp3_;
		_data_->_tmp12_[3] = _data_->_tmp4_;
		_data_->_tmp12_[4] = _data_->_tmp5_;
		_data_->_tmp12_[5] = _data_->_tmp9_;
		_data_->_tmp12_[6] = _data_->_tmp11_;
		_data_->args = _data_->_tmp12_;
		_data_->args_length1 = 7;
		_data_->_args_size_ = _data_->args_length1;
		{
			_data_->_tmp13_ = _data_->args;
			_data_->_tmp13__length1 = _data_->args_length1;
			_data_->_state_ = 1;
			peek_post_processing_cli_post_processor_spawn_command_async ((PeekPostProcessingCliPostProcessor*) _data_->self, _data_->_tmp13_, (gint) _data_->_tmp13__length1, peek_post_processing_ffmpeg_post_processor_generate_palette_async_ready, _data_);
			return FALSE;
			_state_1:
			peek_post_processing_cli_post_processor_spawn_command_finish ((PeekPostProcessingCliPostProcessor*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
					goto __catch1_peek_recording_error;
				}
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->palette_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_peek_recording_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->palette_file;
			g_remove (_data_->_tmp14_);
			_data_->_tmp15_ = _data_->e;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_data_->_inner_error0_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->palette_file);
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			goto __finally0;
		}
		_data_->_tmp17_ = _data_->palette_file;
		_data_->_tmp18_ = g_file_new_for_path (_data_->_tmp17_);
		_data_->result = _data_->_tmp18_;
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->palette_file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = stderr;
		_data_->_tmp20_ = _data_->_vala1_e;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		fprintf (_data_->_tmp19_, "Error: %s\n", _data_->_tmp21_);
		_data_->_tmp22_ = _data_->_vala1_e;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_POSTPROCESSING_ABORTED, _data_->_tmp23_);
		_data_->_inner_error0_ = _data_->_tmp24_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally0;
	}
	__finally0:
	if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
peek_post_processing_ffmpeg_post_processor_generate_animation_async_data_free (gpointer _data)
{
	PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->input_file);
	_g_object_unref0 (_data_->palette_file);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData, _data_);
}

static void
peek_post_processing_ffmpeg_post_processor_generate_animation_async (PeekPostProcessingFfmpegPostProcessor* self,
                                                                     GFile* input_file,
                                                                     GFile* palette_file,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_;
	PeekPostProcessingFfmpegPostProcessor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input_file != NULL);
	g_return_if_fail (palette_file != NULL);
	_data_ = g_slice_new0 (PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, peek_post_processing_ffmpeg_post_processor_generate_animation_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (input_file);
	_g_object_unref0 (_data_->input_file);
	_data_->input_file = _tmp1_;
	_tmp2_ = _g_object_ref0 (palette_file);
	_g_object_unref0 (_data_->palette_file);
	_data_->palette_file = _tmp2_;
	peek_post_processing_ffmpeg_post_processor_generate_animation_async_co (_data_);
}

static GFile*
peek_post_processing_ffmpeg_post_processor_generate_animation_finish (PeekPostProcessingFfmpegPostProcessor* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error)
{
	GFile* result;
	PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static void
peek_post_processing_ffmpeg_post_processor_generate_animation_async_ready (GObject* source_object,
                                                                           GAsyncResult* _res_,
                                                                           gpointer _user_data_)
{
	PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	peek_post_processing_ffmpeg_post_processor_generate_animation_async_co (_data_);
}

static gboolean
peek_post_processing_ffmpeg_post_processor_generate_animation_async_co (PeekPostProcessingFfmpegPostProcessorGenerateAnimationAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->config;
		_data_->_tmp1_ = peek_recording_recording_config_get_output_format (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = peek_utils_get_file_extension_for_format (_data_->_tmp2_);
		_data_->extension = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->extension;
		_data_->_tmp5_ = peek_utils_create_temp_file (_data_->_tmp4_, &_data_->_inner_error0_);
		_data_->output_file = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->extension);
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
		g_array_set_clear_func (_data_->_tmp6_, (GDestroyNotify) _vala_gchar_free_function_content_of);
		_data_->argv = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->argv;
		_data_->_tmp8_ = g_strdup ("ffmpeg");
		g_array_append_val (_data_->_tmp7_, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->argv;
		_data_->_tmp10_ = g_strdup ("-y");
		g_array_append_val (_data_->_tmp9_, _data_->_tmp10_);
		_data_->_tmp11_ = _data_->argv;
		_data_->_tmp12_ = g_strdup ("-i");
		g_array_append_val (_data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp13_ = _data_->argv;
		_data_->_tmp14_ = g_file_get_path (_data_->input_file);
		g_array_append_val (_data_->_tmp13_, _data_->_tmp14_);
		_data_->_tmp15_ = _data_->argv;
		_data_->_tmp16_ = g_strdup ("-i");
		g_array_append_val (_data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->argv;
		_data_->_tmp18_ = g_file_get_path (_data_->palette_file);
		g_array_append_val (_data_->_tmp17_, _data_->_tmp18_);
		_data_->_tmp19_ = _data_->argv;
		_data_->_tmp20_ = g_strdup ("-filter_complex");
		g_array_append_val (_data_->_tmp19_, _data_->_tmp20_);
		_data_->_tmp21_ = _data_->argv;
		_data_->_tmp22_ = _data_->self->priv->config;
		_data_->_tmp23_ = peek_recording_recording_config_get_framerate (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = g_strdup_printf ("fps=%d,paletteuse", _data_->_tmp24_);
		g_array_append_val (_data_->_tmp21_, _data_->_tmp25_);
		_data_->_tmp26_ = _data_->self->priv->config;
		_data_->_tmp27_ = peek_recording_recording_config_get_output_format (_data_->_tmp26_);
		_data_->_tmp28_ = _data_->_tmp27_;
		if (_data_->_tmp28_ == PEEK_OUTPUT_FORMAT_APNG) {
			_data_->_tmp29_ = _data_->argv;
			_data_->_tmp30_ = g_strdup ("-plays");
			g_array_append_val (_data_->_tmp29_, _data_->_tmp30_);
			_data_->_tmp31_ = _data_->argv;
			_data_->_tmp32_ = g_strdup ("0");
			g_array_append_val (_data_->_tmp31_, _data_->_tmp32_);
		}
		_data_->_tmp33_ = _data_->argv;
		_data_->_tmp34_ = _data_->output_file;
		_data_->_tmp35_ = g_strdup (_data_->_tmp34_);
		g_array_append_val (_data_->_tmp33_, _data_->_tmp35_);
		{
			_data_->_tmp36_ = _data_->argv;
			_data_->_tmp37_ = _data_->_tmp36_->data;
			_data_->_tmp37__length1 = _data_->_tmp36_->len;
			_data_->_state_ = 1;
			peek_post_processing_cli_post_processor_spawn_command_async ((PeekPostProcessingCliPostProcessor*) _data_->self, _data_->_tmp37_, (gint) _data_->_tmp37__length1, peek_post_processing_ffmpeg_post_processor_generate_animation_async_ready, _data_);
			return FALSE;
			_state_1:
			peek_post_processing_cli_post_processor_spawn_command_finish ((PeekPostProcessingCliPostProcessor*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
					goto __catch1_peek_recording_error;
				}
				_g_array_unref0 (_data_->argv);
				_g_free0 (_data_->output_file);
				_g_free0 (_data_->extension);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_peek_recording_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp38_ = _data_->output_file;
			g_remove (_data_->_tmp38_);
			_data_->_tmp39_ = _data_->e;
			_data_->_tmp40_ = _g_error_copy0 (_data_->_tmp39_);
			_data_->_inner_error0_ = _data_->_tmp40_;
			_g_error_free0 (_data_->e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_array_unref0 (_data_->argv);
			_g_free0 (_data_->output_file);
			_g_free0 (_data_->extension);
			if (_data_->_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			goto __finally0;
		}
		_data_->_tmp41_ = _data_->output_file;
		_data_->_tmp42_ = g_file_new_for_path (_data_->_tmp41_);
		_data_->result = _data_->_tmp42_;
		_g_array_unref0 (_data_->argv);
		_g_free0 (_data_->output_file);
		_g_free0 (_data_->extension);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp43_ = _data_->_vala1_e;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		_data_->_tmp45_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_POSTPROCESSING_ABORTED, _data_->_tmp44_);
		_data_->_inner_error0_ = _data_->_tmp45_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally0;
	}
	__finally0:
	if (_data_->_inner_error0_->domain == PEEK_RECORDING_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
peek_post_processing_ffmpeg_post_processor_class_init (PeekPostProcessingFfmpegPostProcessorClass * klass,
                                                       gpointer klass_data)
{
	peek_post_processing_ffmpeg_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekPostProcessingFfmpegPostProcessor_private_offset);
	((PeekPostProcessingCliPostProcessorClass *) klass)->process_async = (void (*) (PeekPostProcessingCliPostProcessor*, GArray*, GAsyncReadyCallback, gpointer)) peek_post_processing_ffmpeg_post_processor_real_process_async;
	((PeekPostProcessingCliPostProcessorClass *) klass)->process_finish = (GArray* (*) (PeekPostProcessingCliPostProcessor*, GAsyncResult*, GError**)) peek_post_processing_ffmpeg_post_processor_process_finish;
	G_OBJECT_CLASS (klass)->finalize = peek_post_processing_ffmpeg_post_processor_finalize;
}

static void
peek_post_processing_ffmpeg_post_processor_instance_init (PeekPostProcessingFfmpegPostProcessor * self,
                                                          gpointer klass)
{
	self->priv = peek_post_processing_ffmpeg_post_processor_get_instance_private (self);
}

static void
peek_post_processing_ffmpeg_post_processor_finalize (GObject * obj)
{
	PeekPostProcessingFfmpegPostProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_POST_PROCESSING_TYPE_FFMPEG_POST_PROCESSOR, PeekPostProcessingFfmpegPostProcessor);
	_g_object_unref0 (self->priv->config);
	G_OBJECT_CLASS (peek_post_processing_ffmpeg_post_processor_parent_class)->finalize (obj);
}

/**
  * Use FFmpeg to generate an optimized GIF from a video input
  */
static GType
peek_post_processing_ffmpeg_post_processor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekPostProcessingFfmpegPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_post_processing_ffmpeg_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekPostProcessingFfmpegPostProcessor), 0, (GInstanceInitFunc) peek_post_processing_ffmpeg_post_processor_instance_init, NULL };
	GType peek_post_processing_ffmpeg_post_processor_type_id;
	peek_post_processing_ffmpeg_post_processor_type_id = g_type_register_static (PEEK_POST_PROCESSING_TYPE_CLI_POST_PROCESSOR, "PeekPostProcessingFfmpegPostProcessor", &g_define_type_info, 0);
	PeekPostProcessingFfmpegPostProcessor_private_offset = g_type_add_instance_private (peek_post_processing_ffmpeg_post_processor_type_id, sizeof (PeekPostProcessingFfmpegPostProcessorPrivate));
	return peek_post_processing_ffmpeg_post_processor_type_id;
}

GType
peek_post_processing_ffmpeg_post_processor_get_type (void)
{
	static volatile gsize peek_post_processing_ffmpeg_post_processor_type_id__once = 0;
	if (g_once_init_enter (&peek_post_processing_ffmpeg_post_processor_type_id__once)) {
		GType peek_post_processing_ffmpeg_post_processor_type_id;
		peek_post_processing_ffmpeg_post_processor_type_id = peek_post_processing_ffmpeg_post_processor_get_type_once ();
		g_once_init_leave (&peek_post_processing_ffmpeg_post_processor_type_id__once, peek_post_processing_ffmpeg_post_processor_type_id);
	}
	return peek_post_processing_ffmpeg_post_processor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

