/* TransientDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from TransientDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <libbamf/libbamf.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "plank-internal.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define PLANK_TRANSIENT_DOCK_ITEM_ICON_UPDATE_DELAY 200U
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_TRANSIENT_DOCK_ITEM_0_PROPERTY,
	PLANK_TRANSIENT_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* plank_transient_dock_item_properties[PLANK_TRANSIENT_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PlankTransientDockItemPrivate {
	guint delayed_update_timer_id;
};

static gint PlankTransientDockItem_private_offset;
static gpointer plank_transient_dock_item_parent_class = NULL;

VALA_EXTERN PlankTransientDockItem* plank_transient_dock_item_new_with_application (BamfApplication* app);
VALA_EXTERN PlankTransientDockItem* plank_transient_dock_item_construct_with_application (GType object_type,
                                                                              BamfApplication* app);
static void plank_transient_dock_item_update_forced_pixbuf (PlankTransientDockItem* self);
VALA_EXTERN BamfApplication* plank_application_dock_item_get_App (PlankApplicationDockItem* self);
static gboolean __lambda14_ (PlankTransientDockItem* self);
static gboolean ___lambda14__gsource_func (gpointer self);
static gboolean plank_transient_dock_item_real_can_be_removed (PlankDockElement* base);
static gboolean plank_transient_dock_item_real_is_valid (PlankDockItem* base);
static GObject * plank_transient_dock_item_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void plank_transient_dock_item_finalize (GObject * obj);
static GType plank_transient_dock_item_get_type_once (void);

static inline gpointer
plank_transient_dock_item_get_instance_private (PlankTransientDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankTransientDockItem_private_offset);
}

PlankTransientDockItem*
plank_transient_dock_item_construct_with_application (GType object_type,
                                                      BamfApplication* app)
{
	PlankTransientDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new ();
	_tmp1_ = _tmp0_;
	self = (PlankTransientDockItem*) g_object_new (object_type, "Prefs", _tmp1_, "App", app, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PlankTransientDockItem*
plank_transient_dock_item_new_with_application (BamfApplication* app)
{
	return plank_transient_dock_item_construct_with_application (PLANK_TYPE_TRANSIENT_DOCK_ITEM, app);
}

PlankTransientDockItem*
plank_transient_dock_item_construct_with_launcher (GType object_type,
                                                   const gchar* launcher_uri)
{
	PlankTransientDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (launcher_uri != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_launcher (launcher_uri);
	_tmp1_ = _tmp0_;
	self = (PlankTransientDockItem*) g_object_new (object_type, "Prefs", _tmp1_, "App", NULL, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PlankTransientDockItem*
plank_transient_dock_item_new_with_launcher (const gchar* launcher_uri)
{
	return plank_transient_dock_item_construct_with_launcher (PLANK_TYPE_TRANSIENT_DOCK_ITEM, launcher_uri);
}

static gboolean
__lambda14_ (PlankTransientDockItem* self)
{
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	gboolean result;
	self->priv->delayed_update_timer_id = 0U;
	_tmp0_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		BamfApplication* _tmp2_;
		BamfApplication* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = plank_window_control_get_app_icon (_tmp3_);
		plank_dock_item_set_ForcePixbuf ((PlankDockItem*) self, _tmp4_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ ((PlankTransientDockItem*) self);
	return result;
}

static void
plank_transient_dock_item_update_forced_pixbuf (PlankTransientDockItem* self)
{
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->delayed_update_timer_id > 0U) {
		return;
	}
	_tmp0_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_window_control_get_app_icon (_tmp1_);
	plank_dock_item_set_ForcePixbuf ((PlankDockItem*) self, _tmp2_);
	_tmp3_ = plank_dock_item_get_ForcePixbuf ((PlankDockItem*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		return;
	}
	self->priv->delayed_update_timer_id = gdk_threads_add_timeout (PLANK_TRANSIENT_DOCK_ITEM_ICON_UPDATE_DELAY, ___lambda14__gsource_func, self);
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_transient_dock_item_real_can_be_removed (PlankDockElement* base)
{
	PlankTransientDockItem * self;
	gboolean result;
	self = (PlankTransientDockItem*) base;
	result = FALSE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_transient_dock_item_real_is_valid (PlankDockItem* base)
{
	PlankTransientDockItem * self;
	gboolean result;
	self = (PlankTransientDockItem*) base;
	result = TRUE;
	return result;
}

PlankTransientDockItem*
plank_transient_dock_item_construct (GType object_type)
{
	PlankTransientDockItem * self = NULL;
	self = (PlankTransientDockItem*) plank_application_dock_item_construct (object_type);
	return self;
}

PlankTransientDockItem*
plank_transient_dock_item_new (void)
{
	return plank_transient_dock_item_construct (PLANK_TYPE_TRANSIENT_DOCK_ITEM);
}

static GObject *
plank_transient_dock_item_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankTransientDockItem * self;
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	parent_class = G_OBJECT_CLASS (plank_transient_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_TRANSIENT_DOCK_ITEM, PlankTransientDockItem);
	_tmp0_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* launcher = NULL;
		BamfApplication* _tmp2_;
		BamfApplication* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp2_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = bamf_application_get_desktop_file (_tmp3_);
		launcher = _tmp4_;
		_tmp6_ = launcher;
		if (_tmp6_ == NULL) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = launcher;
			_tmp5_ = g_strcmp0 (_tmp7_, "") == 0;
		}
		if (_tmp5_) {
			BamfApplication* _tmp8_;
			BamfApplication* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = plank_application_dock_item_get_App ((PlankApplicationDockItem*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = bamf_view_get_name ((BamfView*) _tmp9_);
			_tmp11_ = _tmp10_;
			plank_dock_element_set_Text ((PlankDockElement*) self, _tmp11_);
			_g_free0 (_tmp11_);
			plank_transient_dock_item_update_forced_pixbuf (self);
		} else {
			PlankDockItemPreferences* _tmp12_;
			PlankDockItemPreferences* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = launcher;
			plank_dock_item_preferences_set_Launcher (_tmp13_, _tmp14_);
			plank_dock_item_load_from_launcher ((PlankDockItem*) self);
		}
	} else {
		PlankDockItemPreferences* _tmp15_;
		PlankDockItemPreferences* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = plank_dock_item_preferences_get_Launcher (_tmp16_);
		_tmp18_ = _tmp17_;
		if (g_strcmp0 (_tmp18_, "") != 0) {
			plank_dock_item_load_from_launcher ((PlankDockItem*) self);
		} else {
			g_critical ("TransientDockItem.vala:58: No source of information for this item avai" \
"lable");
		}
	}
	return obj;
}

static void
plank_transient_dock_item_class_init (PlankTransientDockItemClass * klass,
                                      gpointer klass_data)
{
	plank_transient_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankTransientDockItem_private_offset);
	((PlankDockElementClass *) klass)->can_be_removed = (gboolean (*) (PlankDockElement*)) plank_transient_dock_item_real_can_be_removed;
	((PlankDockItemClass *) klass)->is_valid = (gboolean (*) (PlankDockItem*)) plank_transient_dock_item_real_is_valid;
	G_OBJECT_CLASS (klass)->constructor = plank_transient_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_transient_dock_item_finalize;
}

static void
plank_transient_dock_item_instance_init (PlankTransientDockItem * self,
                                         gpointer klass)
{
	self->priv = plank_transient_dock_item_get_instance_private (self);
	self->priv->delayed_update_timer_id = 0U;
}

static void
plank_transient_dock_item_finalize (GObject * obj)
{
	PlankTransientDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_TRANSIENT_DOCK_ITEM, PlankTransientDockItem);
	if (self->priv->delayed_update_timer_id > 0U) {
		g_source_remove (self->priv->delayed_update_timer_id);
		self->priv->delayed_update_timer_id = 0U;
	}
	G_OBJECT_CLASS (plank_transient_dock_item_parent_class)->finalize (obj);
}

/**
 * A dock item for applications which aren't pinned or doesn't have a matched desktop-files.
 *
 * Usually this represents a running application while it is possible it is a virtual item
 * added through e.g. libunity-support to show specific application information.
 */
static GType
plank_transient_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankTransientDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_transient_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankTransientDockItem), 0, (GInstanceInitFunc) plank_transient_dock_item_instance_init, NULL };
	GType plank_transient_dock_item_type_id;
	plank_transient_dock_item_type_id = g_type_register_static (PLANK_TYPE_APPLICATION_DOCK_ITEM, "PlankTransientDockItem", &g_define_type_info, 0);
	PlankTransientDockItem_private_offset = g_type_add_instance_private (plank_transient_dock_item_type_id, sizeof (PlankTransientDockItemPrivate));
	return plank_transient_dock_item_type_id;
}

GType
plank_transient_dock_item_get_type (void)
{
	static volatile gsize plank_transient_dock_item_type_id__once = 0;
	if (g_once_init_enter (&plank_transient_dock_item_type_id__once)) {
		GType plank_transient_dock_item_type_id;
		plank_transient_dock_item_type_id = plank_transient_dock_item_get_type_once ();
		g_once_init_leave (&plank_transient_dock_item_type_id__once, plank_transient_dock_item_type_id);
	}
	return plank_transient_dock_item_type_id__once;
}

