/* Matcher.c generated by valac 0.56.17, the Vala compiler
 * generated from Matcher.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank-internal.h"
#include <gee.h>
#include <glib-object.h>
#include <libbamf/libbamf.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_MATCHER_0_PROPERTY,
	PLANK_MATCHER_NUM_PROPERTIES
};
static GParamSpec* plank_matcher_properties[PLANK_MATCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PLANK_MATCHER_ACTIVE_WINDOW_CHANGED_SIGNAL,
	PLANK_MATCHER_WINDOW_OPENED_SIGNAL,
	PLANK_MATCHER_WINDOW_CLOSED_SIGNAL,
	PLANK_MATCHER_ACTIVE_APPLICATION_CHANGED_SIGNAL,
	PLANK_MATCHER_APPLICATION_OPENED_SIGNAL,
	PLANK_MATCHER_APPLICATION_CLOSED_SIGNAL,
	PLANK_MATCHER_NUM_SIGNALS
};
static guint plank_matcher_signals[PLANK_MATCHER_NUM_SIGNALS] = {0};

struct _PlankMatcherPrivate {
	GeeHashSet* pending_views;
	BamfMatcher* bamf_matcher;
};

static gint PlankMatcher_private_offset;
static gpointer plank_matcher_parent_class = NULL;
static PlankMatcher* plank_matcher_matcher;
static PlankMatcher* plank_matcher_matcher = NULL;

static void plank_matcher_handle_view_user_visible_changed (PlankMatcher* self,
                                                     BamfView* view,
                                                     gboolean user_visible);
static void _plank_matcher_handle_view_user_visible_changed_bamf_view_user_visible_changed (BamfView* _sender,
                                                                                     gboolean user_visible,
                                                                                     gpointer self);
static void plank_matcher_handle_active_application_changed (PlankMatcher* self,
                                                      BamfApplication* arg1,
                                                      BamfApplication* arg2);
static void _plank_matcher_handle_active_application_changed_bamf_matcher_active_application_changed (BamfMatcher* _sender,
                                                                                               BamfApplication* object,
                                                                                               BamfApplication* p0,
                                                                                               gpointer self);
static void plank_matcher_handle_active_window_changed (PlankMatcher* self,
                                                 BamfWindow* arg1,
                                                 BamfWindow* arg2);
static void _plank_matcher_handle_active_window_changed_bamf_matcher_active_window_changed (BamfMatcher* _sender,
                                                                                     BamfWindow* object,
                                                                                     BamfWindow* p0,
                                                                                     gpointer self);
static void plank_matcher_handle_view_opened (PlankMatcher* self,
                                       BamfView* arg1);
static void _plank_matcher_handle_view_opened_bamf_matcher_view_opened (BamfMatcher* _sender,
                                                                 BamfView* object,
                                                                 gpointer self);
static void plank_matcher_handle_view_closed (PlankMatcher* self,
                                       BamfView* arg1);
static void _plank_matcher_handle_view_closed_bamf_matcher_view_closed (BamfMatcher* _sender,
                                                                 BamfView* object,
                                                                 gpointer self);
static PlankMatcher* plank_matcher_new (void);
static PlankMatcher* plank_matcher_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * plank_matcher_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void plank_matcher_finalize (GObject * obj);
static GType plank_matcher_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_matcher_get_instance_private (PlankMatcher* self)
{
	return G_STRUCT_MEMBER_P (self, PlankMatcher_private_offset);
}

static void
_plank_matcher_handle_view_user_visible_changed_bamf_view_user_visible_changed (BamfView* _sender,
                                                                                gboolean user_visible,
                                                                                gpointer self)
{
	plank_matcher_handle_view_user_visible_changed ((PlankMatcher*) self, _sender, user_visible);
}

static void
_plank_matcher_handle_active_application_changed_bamf_matcher_active_application_changed (BamfMatcher* _sender,
                                                                                          BamfApplication* object,
                                                                                          BamfApplication* p0,
                                                                                          gpointer self)
{
	plank_matcher_handle_active_application_changed ((PlankMatcher*) self, object, p0);
}

static void
_plank_matcher_handle_active_window_changed_bamf_matcher_active_window_changed (BamfMatcher* _sender,
                                                                                BamfWindow* object,
                                                                                BamfWindow* p0,
                                                                                gpointer self)
{
	plank_matcher_handle_active_window_changed ((PlankMatcher*) self, object, p0);
}

static void
_plank_matcher_handle_view_opened_bamf_matcher_view_opened (BamfMatcher* _sender,
                                                            BamfView* object,
                                                            gpointer self)
{
	plank_matcher_handle_view_opened ((PlankMatcher*) self, object);
}

static void
_plank_matcher_handle_view_closed_bamf_matcher_view_closed (BamfMatcher* _sender,
                                                            BamfView* object,
                                                            gpointer self)
{
	plank_matcher_handle_view_closed ((PlankMatcher*) self, object);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PlankMatcher*
plank_matcher_get_default (void)
{
	PlankMatcher* _tmp0_;
	PlankMatcher* _tmp2_;
	PlankMatcher* _tmp3_;
	PlankMatcher* result;
	_tmp0_ = plank_matcher_matcher;
	if (_tmp0_ == NULL) {
		PlankMatcher* _tmp1_;
		_tmp1_ = plank_matcher_new ();
		_g_object_unref0 (plank_matcher_matcher);
		plank_matcher_matcher = _tmp1_;
	}
	_tmp2_ = plank_matcher_matcher;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static PlankMatcher*
plank_matcher_construct (GType object_type)
{
	PlankMatcher * self = NULL;
	self = (PlankMatcher*) g_object_new (object_type, NULL);
	return self;
}

static PlankMatcher*
plank_matcher_new (void)
{
	return plank_matcher_construct (PLANK_TYPE_MATCHER);
}

static void
plank_matcher_handle_active_application_changed (PlankMatcher* self,
                                                 BamfApplication* arg1,
                                                 BamfApplication* arg2)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_ACTIVE_APPLICATION_CHANGED_SIGNAL], 0, arg1, arg2);
}

static void
plank_matcher_handle_active_window_changed (PlankMatcher* self,
                                            BamfWindow* arg1,
                                            BamfWindow* arg2)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_ACTIVE_WINDOW_CHANGED_SIGNAL], 0, arg1, arg2);
}

static void
plank_matcher_handle_view_user_visible_changed (PlankMatcher* self,
                                                BamfView* view,
                                                gboolean user_visible)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (!user_visible) {
		return;
	}
	plank_matcher_handle_view_opened (self, view);
}

static void
plank_matcher_handle_view_opened (PlankMatcher* self,
                                  BamfView* arg1)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg1 != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (arg1, bamf_application_get_type ())) {
		_tmp0_ = !bamf_view_is_user_visible (arg1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeHashSet* _tmp1_;
		_tmp1_ = self->priv->pending_views;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, arg1);
		g_signal_connect_object (arg1, "user-visible-changed", (GCallback) _plank_matcher_handle_view_user_visible_changed_bamf_view_user_visible_changed, self, G_CONNECT_AFTER);
		return;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (arg1, bamf_window_get_type ())) {
		g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_WINDOW_OPENED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (arg1, bamf_window_get_type (), BamfWindow));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (arg1, bamf_application_get_type ())) {
			g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_APPLICATION_OPENED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (arg1, bamf_application_get_type (), BamfApplication));
		}
	}
}

static void
plank_matcher_handle_view_closed (PlankMatcher* self,
                                  BamfView* arg1)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg1 != NULL);
	_tmp0_ = self->priv->pending_views;
	if (gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, arg1)) {
		guint _tmp1_;
		g_signal_parse_name ("user-visible-changed", bamf_view_get_type (), &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (arg1, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_matcher_handle_view_user_visible_changed_bamf_view_user_visible_changed, self);
		return;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (arg1, bamf_window_get_type ())) {
		g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_WINDOW_CLOSED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (arg1, bamf_window_get_type (), BamfWindow));
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (arg1, bamf_application_get_type ())) {
			g_signal_emit (self, plank_matcher_signals[PLANK_MATCHER_APPLICATION_CLOSED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (arg1, bamf_application_get_type (), BamfApplication));
		}
	}
}

GeeArrayList*
plank_matcher_active_launchers (PlankMatcher* self)
{
	GList* apps = NULL;
	BamfMatcher* _tmp0_;
	GList* _tmp1_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bamf_matcher;
	_tmp1_ = bamf_matcher_get_running_applications (_tmp0_);
	apps = _tmp1_;
	_tmp2_ = gee_array_list_new (bamf_application_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp2_;
	_tmp3_ = apps;
	g_warn_if_fail (_tmp3_ != NULL);
	_tmp4_ = apps;
	if (_tmp4_ == NULL) {
		result = list;
		(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
		return result;
	}
	_tmp5_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp5_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			BamfApplication* app = NULL;
			app = (BamfApplication*) app_it->data;
			{
				GeeArrayList* _tmp6_;
				BamfApplication* _tmp7_;
				_tmp6_ = list;
				_tmp7_ = app;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
		}
	}
	result = list;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	return result;
}

BamfApplication*
plank_matcher_app_for_uri (PlankMatcher* self,
                           const gchar* uri)
{
	gchar* launcher = NULL;
	BamfApplication* app = NULL;
	BamfMatcher* _tmp5_;
	const gchar* _tmp6_;
	BamfApplication* _tmp7_;
	BamfApplication* _tmp8_;
	BamfApplication* _tmp9_;
	BamfApplication* _tmp10_;
	GError* _inner_error0_ = NULL;
	BamfApplication* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_filename_from_uri (uri, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			_g_free0 (launcher);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (launcher);
		launcher = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Matcher.vala:140: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (launcher);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = self->priv->bamf_matcher;
	_tmp6_ = launcher;
	_tmp7_ = bamf_matcher_get_application_for_desktop_file (_tmp5_, _tmp6_, FALSE);
	app = _tmp7_;
	_tmp8_ = app;
	g_warn_if_fail (_tmp8_ != NULL);
	_tmp9_ = app;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_free0 (launcher);
	return result;
}

void
plank_matcher_set_favorites (PlankMatcher* self,
                             GeeArrayList* favs)
{
	gchar** paths = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint paths_length1;
	gint _paths_size_;
	BamfMatcher* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (favs != NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) favs);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar*, _tmp1_ + 1);
	paths = _tmp2_;
	paths_length1 = _tmp1_;
	_paths_size_ = paths_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gpointer _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) favs);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = paths;
				_tmp7__length1 = paths_length1;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) favs, i);
				_g_free0 (_tmp7_[i]);
				_tmp7_[i] = (gchar*) _tmp8_;
			}
		}
	}
	_tmp9_ = self->priv->bamf_matcher;
	_tmp10_ = paths;
	_tmp10__length1 = paths_length1;
	bamf_matcher_register_favorites (_tmp9_, _tmp10_);
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static GObject *
plank_matcher_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankMatcher * self;
	BamfMatcher* _tmp0_;
	BamfMatcher* _tmp1_;
	BamfMatcher* _tmp2_;
	BamfMatcher* _tmp3_;
	BamfMatcher* _tmp4_;
	GeeHashSet* _tmp5_;
	parent_class = G_OBJECT_CLASS (plank_matcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_MATCHER, PlankMatcher);
	_tmp0_ = bamf_matcher_get_default ();
	_g_object_unref0 (self->priv->bamf_matcher);
	self->priv->bamf_matcher = _tmp0_;
	_tmp1_ = self->priv->bamf_matcher;
	g_signal_connect_object (_tmp1_, "active-application-changed", (GCallback) _plank_matcher_handle_active_application_changed_bamf_matcher_active_application_changed, self, G_CONNECT_AFTER);
	_tmp2_ = self->priv->bamf_matcher;
	g_signal_connect_object (_tmp2_, "active-window-changed", (GCallback) _plank_matcher_handle_active_window_changed_bamf_matcher_active_window_changed, self, G_CONNECT_AFTER);
	_tmp3_ = self->priv->bamf_matcher;
	g_signal_connect_object (_tmp3_, "view-opened", (GCallback) _plank_matcher_handle_view_opened_bamf_matcher_view_opened, self, G_CONNECT_AFTER);
	_tmp4_ = self->priv->bamf_matcher;
	g_signal_connect_object (_tmp4_, "view-closed", (GCallback) _plank_matcher_handle_view_closed_bamf_matcher_view_closed, self, G_CONNECT_AFTER);
	_tmp5_ = gee_hash_set_new (bamf_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->pending_views);
	self->priv->pending_views = _tmp5_;
	return obj;
}

static void
plank_matcher_class_init (PlankMatcherClass * klass,
                          gpointer klass_data)
{
	plank_matcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankMatcher_private_offset);
	G_OBJECT_CLASS (klass)->constructor = plank_matcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_matcher_finalize;
	plank_matcher_signals[PLANK_MATCHER_ACTIVE_WINDOW_CHANGED_SIGNAL] = g_signal_new ("active-window-changed", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, bamf_window_get_type (), bamf_window_get_type ());
	plank_matcher_signals[PLANK_MATCHER_WINDOW_OPENED_SIGNAL] = g_signal_new ("window-opened", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, bamf_window_get_type ());
	plank_matcher_signals[PLANK_MATCHER_WINDOW_CLOSED_SIGNAL] = g_signal_new ("window-closed", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, bamf_window_get_type ());
	plank_matcher_signals[PLANK_MATCHER_ACTIVE_APPLICATION_CHANGED_SIGNAL] = g_signal_new ("active-application-changed", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, bamf_application_get_type (), bamf_application_get_type ());
	plank_matcher_signals[PLANK_MATCHER_APPLICATION_OPENED_SIGNAL] = g_signal_new ("application-opened", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, bamf_application_get_type ());
	plank_matcher_signals[PLANK_MATCHER_APPLICATION_CLOSED_SIGNAL] = g_signal_new ("application-closed", PLANK_TYPE_MATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, bamf_application_get_type ());
}

static void
plank_matcher_instance_init (PlankMatcher * self,
                             gpointer klass)
{
	self->priv = plank_matcher_get_instance_private (self);
}

static void
plank_matcher_finalize (GObject * obj)
{
	PlankMatcher * self;
	BamfMatcher* _tmp7_;
	guint _tmp8_;
	BamfMatcher* _tmp9_;
	guint _tmp10_;
	BamfMatcher* _tmp11_;
	guint _tmp12_;
	BamfMatcher* _tmp13_;
	guint _tmp14_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_MATCHER, PlankMatcher);
	{
		GeeIterator* _view_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->pending_views;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_view_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			BamfView* view = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			BamfView* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _view_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _view_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			view = (BamfView*) _tmp4_;
			_tmp5_ = view;
			g_signal_parse_name ("user-visible-changed", bamf_view_get_type (), &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_matcher_handle_view_user_visible_changed_bamf_view_user_visible_changed, self);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp7_ = self->priv->bamf_matcher;
	g_signal_parse_name ("active-application-changed", bamf_matcher_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _plank_matcher_handle_active_application_changed_bamf_matcher_active_application_changed, self);
	_tmp9_ = self->priv->bamf_matcher;
	g_signal_parse_name ("active-window-changed", bamf_matcher_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _plank_matcher_handle_active_window_changed_bamf_matcher_active_window_changed, self);
	_tmp11_ = self->priv->bamf_matcher;
	g_signal_parse_name ("view-opened", bamf_matcher_get_type (), &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _plank_matcher_handle_view_opened_bamf_matcher_view_opened, self);
	_tmp13_ = self->priv->bamf_matcher;
	g_signal_parse_name ("view-closed", bamf_matcher_get_type (), &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _plank_matcher_handle_view_closed_bamf_matcher_view_closed, self);
	_g_object_unref0 (self->priv->bamf_matcher);
	self->priv->bamf_matcher = NULL;
	_g_object_unref0 (self->priv->pending_views);
	_g_object_unref0 (self->priv->bamf_matcher);
	G_OBJECT_CLASS (plank_matcher_parent_class)->finalize (obj);
}

/**
 * Wrapper for Bamf.Matcher
 */
static GType
plank_matcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankMatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_matcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankMatcher), 0, (GInstanceInitFunc) plank_matcher_instance_init, NULL };
	GType plank_matcher_type_id;
	plank_matcher_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankMatcher", &g_define_type_info, 0);
	PlankMatcher_private_offset = g_type_add_instance_private (plank_matcher_type_id, sizeof (PlankMatcherPrivate));
	return plank_matcher_type_id;
}

GType
plank_matcher_get_type (void)
{
	static volatile gsize plank_matcher_type_id__once = 0;
	if (g_once_init_enter (&plank_matcher_type_id__once)) {
		GType plank_matcher_type_id;
		plank_matcher_type_id = plank_matcher_get_type_once ();
		g_once_init_leave (&plank_matcher_type_id__once, plank_matcher_type_id);
	}
	return plank_matcher_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

