/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 64 bit ELF emulation code for elf64lppc
   Copyright (C) 1991-2024 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_elf64lppc

#include "sysdep.h"
#include "bfd.h"
#include "libiberty.h"
#include "getopt.h"
#include "bfdlink.h"
#include "ctf-api.h"
#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf-bfd.h"
#include "ldelf.h"
#include "ldelfgen.h"

/* Declare functions used by various EXTRA_EM_FILEs.  */
static void gldelf64lppc_before_parse (void);
static void gldelf64lppc_before_plugin_all_symbols_read
  (void);
static void gldelf64lppc_after_open (void);
static void gldelf64lppc_before_allocation (void);
static void gldelf64lppc_after_allocation (void);


#include "ldctor.h"
#include "elf-bfd.h"
#include "elf64-ppc.h"
#include "ldlex.h"
#include "elf/ppc64.h"

static asection *ppc_add_stub_section (const char *, asection *);
static void ppc_layout_sections_again (void);
static void ppc_edit (void);

static struct ppc64_elf_params params = { NULL,
					  &ppc_add_stub_section,
					  &ppc_layout_sections_again,
					  &ppc_edit,
					  1, -1, -1, 0,
					  0, -1, 5,
					  -1, -1, 0, 0, -1, -1, 0};

/* Fake input file for stubs.  */
static lang_input_statement_type *stub_file;

/* Whether we need to call ppc_layout_sections_again.  */
static int need_laying_out = 0;

/* Whether to add ".foo" entries for each "foo" in a version script.  */
static int dotsyms = 1;

/* Whether to run tls optimization.  */
static int no_tls_opt = 0;

/* Whether to run opd optimization.  */
static int no_opd_opt = 0;

/* Whether to convert inline PLT calls to direct.  */
static int no_inline_opt = 0;

/* Whether to run toc optimization.  */
static int no_toc_opt = 0;

/* Whether to sort input toc and got sections.  */
static int no_toc_sort = 0;

/* Input .toc sections will be placed in this output section.  */
static const char *toc_section_name = ".got";
static asection *toc_section = 0;

/* This is called before the input files are opened.  We create a new
   fake input file to hold the stub sections.  */

static void
ppc_create_output_section_statements (void)
{
  if (!(bfd_get_flavour (link_info.output_bfd) == bfd_target_elf_flavour
	&& elf_object_id (link_info.output_bfd) == PPC64_ELF_DATA))
    return;

  link_info.wrap_char = '.';

  stub_file = lang_add_input_file ("linker stubs",
				   lang_input_file_is_fake_enum,
				   NULL);
  stub_file->the_bfd = bfd_create ("linker stubs", link_info.output_bfd);
  if (stub_file->the_bfd == NULL
      || !bfd_set_arch_mach (stub_file->the_bfd,
			     bfd_get_arch (link_info.output_bfd),
			     bfd_get_mach (link_info.output_bfd)))
    {
      einfo (_("%F%P: can not create BFD: %E\n"));
      return;
    }

  stub_file->the_bfd->flags |= BFD_LINKER_CREATED;
  ldlang_add_file (stub_file);
  params.stub_bfd = stub_file->the_bfd;
  if (params.save_restore_funcs < 0)
    params.save_restore_funcs = !bfd_link_relocatable (&link_info);
  if (!ppc64_elf_init_stub_bfd (&link_info, &params))
    einfo (_("%F%P: can not init BFD: %E\n"));
}

/* Called after opening files but before mapping sections.  */

static void
ppc_after_open (void)
{
  if (stub_file != NULL && link_info.relro && params.object_in_toc)
    {
      /* We have a .toc section that might be written to at run time.
	 Don't put .toc into the .got output section.  */
      lang_output_section_statement_type *got;

      got = lang_output_section_find (".got");
      if (got != NULL)
	{
	  lang_statement_union_type *s;
	  for (s = got->children.head; s != NULL; s = s->header.next)
	    if (s->header.type == lang_wild_statement_enum
		&& s->wild_statement.filename == NULL)
	      {
		struct wildcard_list **i = &s->wild_statement.section_list;
		while (*i != NULL)
		  if (strcmp ((*i)->spec.name, ".toc") == 0)
		    *i = (*i)->next;
		  else
		    i = &(*i)->next;
	      }
	  /* Instead, .toc input sections will be mapped to the
	     read/write .toc output section.  If user scripts don't
	     provide one then we'll lose toc sorting and multi-toc.  */
	  toc_section_name = ".toc";
	}
    }
  gldelf64lppc_after_open ();
}

/* Move the input section statement at *U which happens to be on LIST
   to be just before *TO.  */

static void
move_input_section (lang_statement_list_type *list,
		    lang_statement_union_type **u,
		    lang_statement_union_type **to)
{
  lang_statement_union_type *s = *u;
  asection *i = s->input_section.section;
  asection *p, *n;

  /* Snip the input section from the statement list.  If it was the
     last statement, fix the list tail pointer.  */
  *u = s->header.next;
  if (*u == NULL)
    list->tail = u;
  /* Add it back in the new position.  */
  s->header.next = *to;
  *to = s;
  if (list->tail == to)
    list->tail = &s->header.next;

  /* Trim I off the bfd map_head/map_tail doubly linked lists.  */
  n = i->map_head.s;
  p = i->map_tail.s;
  (p != NULL ? p : i->output_section)->map_head.s = n;
  (n != NULL ? n : i->output_section)->map_tail.s = p;

  /* Add I back on in its new position.  */
  if (s->header.next->header.type == lang_input_section_enum)
    {
      n = s->header.next->input_section.section;
      p = n->map_tail.s;
    }
  else
    {
      /* If the next statement is not an input section statement then
	 TO must point at the previous input section statement
	 header.next field.  */
      lang_input_section_type *prev = (lang_input_section_type *)
	((char *) to - offsetof (lang_statement_union_type, header.next));

      ASSERT (prev->header.type == lang_input_section_enum);
      p = prev->section;
      n = p->map_head.s;
    }
  i->map_head.s = n;
  i->map_tail.s = p;
  (p != NULL ? p : i->output_section)->map_head.s = i;
  (n != NULL ? n : i->output_section)->map_tail.s = i;
}

/* Sort input section statements in the linker script tree rooted at
   LIST so that those whose owning bfd happens to have a section
   called .init or .fini are placed first.  Place any TOC sections
   referenced by small TOC relocs next, with TOC sections referenced
   only by bigtoc relocs last.  */

static void
sort_toc_sections (lang_statement_list_type *list,
		   lang_statement_union_type **ini,
		   lang_statement_union_type **small)
{
  lang_statement_union_type *s, **u;
  asection *i;

  u = &list->head;
  while ((s = *u) != NULL)
    {
      switch (s->header.type)
	{
	case lang_wild_statement_enum:
	  sort_toc_sections (&s->wild_statement.children, ini, small);
	  break;

	case lang_group_statement_enum:
	  sort_toc_sections (&s->group_statement.children, ini, small);
	  break;

	case lang_input_section_enum:
	  i = s->input_section.section;
	  /* Leave the stub_file .got where it is.  We put the .got
	     header there.  */
	  if (i->owner == stub_file->the_bfd)
	    break;
	  if (bfd_get_section_by_name (i->owner, ".init") != NULL
	      || bfd_get_section_by_name (i->owner, ".fini") != NULL)
	    {
	      if (ini != NULL && *ini != s)
		{
		  move_input_section (list, u, ini);
		  if (small == ini)
		    small = &s->header.next;
		  ini = &s->header.next;
		  continue;
		}
	      if (small == ini)
		small = &s->header.next;
	      ini = &s->header.next;
	      break;
	    }
	  else if (ini == NULL)
	    ini = u;

	  if (ppc64_elf_has_small_toc_reloc (i))
	    {
	      if (small != NULL && *small != s)
		{
		  move_input_section (list, u, small);
		  small = &s->header.next;
		  continue;
		}
	      small = &s->header.next;
	    }
	  else if (small == NULL)
	    small = u;
	  break;

	default:
	  break;
	}
      u = &s->header.next;
    }
}

static void
prelim_size_sections (void)
{
  if (expld.phase != lang_mark_phase_enum)
    {
      expld.phase = lang_mark_phase_enum;
      expld.dataseg.phase = exp_seg_none;
      one_lang_size_sections_pass (NULL, false);
      /* We must not cache anything from the preliminary sizing.  */
      lang_reset_memory_regions ();
    }
}

static void
ppc_before_allocation (void)
{
  if (stub_file != NULL)
    {
      if (!no_opd_opt
	  && !ppc64_elf_edit_opd (&link_info))
	einfo (_("%X%P: can not edit %s: %E\n"), "opd");

      if (!no_inline_opt
	  && !bfd_link_relocatable (&link_info))
	{
	  prelim_size_sections ();

	  if (!ppc64_elf_inline_plt (&link_info))
	    einfo (_("%X%P: inline PLT: %E\n"));
	}

      if (!ppc64_elf_tls_setup (&link_info))
	einfo (_("%X%P: TLS problem %E\n"));
    }

  gldelf64lppc_before_allocation ();
}

static void
ppc_edit (void)
{
  if (stub_file != NULL)
    {
      if (elf_hash_table (&link_info)->tls_sec != NULL
	  && !no_tls_opt)
	{
	  /* Size the sections.  This is premature, but we want to know the
	     TLS segment layout so that certain optimizations can be done.  */
	  prelim_size_sections ();

	  if (!ppc64_elf_tls_optimize (&link_info))
	    einfo (_("%X%P: TLS problem %E\n"));
	}

      if (!no_toc_opt
	  && !bfd_link_relocatable (&link_info))
	{
	  prelim_size_sections ();

	  if (!ppc64_elf_edit_toc (&link_info))
	    einfo (_("%X%P: can not edit %s: %E\n"), "toc");
	}

      if (!no_toc_sort)
	{
	  lang_output_section_statement_type *toc_os;

	  toc_os = lang_output_section_find (toc_section_name);
	  if (toc_os != NULL)
	    sort_toc_sections (&toc_os->children, NULL, NULL);
	}
    }
}

struct hook_stub_info
{
  lang_statement_list_type add;
  asection *input_section;
};

/* Traverse the linker tree to find the spot where the stub goes.  */

static bool
hook_in_stub (struct hook_stub_info *info, lang_statement_union_type **lp)
{
  lang_statement_union_type *l;
  bool ret;

  for (; (l = *lp) != NULL; lp = &l->header.next)
    {
      switch (l->header.type)
	{
	case lang_constructors_statement_enum:
	  ret = hook_in_stub (info, &constructor_list.head);
	  if (ret)
	    return ret;
	  break;

	case lang_output_section_statement_enum:
	  ret = hook_in_stub (info,
			      &l->output_section_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_wild_statement_enum:
	  ret = hook_in_stub (info, &l->wild_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_group_statement_enum:
	  ret = hook_in_stub (info, &l->group_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_input_section_enum:
	  if (l->input_section.section == info->input_section)
	    {
	      /* We've found our section.  Insert the stub immediately
		 before its associated input section.  */
	      *lp = info->add.head;
	      *(info->add.tail) = l;
	      return true;
	    }
	  break;

	case lang_data_statement_enum:
	case lang_reloc_statement_enum:
	case lang_object_symbols_statement_enum:
	case lang_output_statement_enum:
	case lang_target_statement_enum:
	case lang_input_statement_enum:
	case lang_assignment_statement_enum:
	case lang_padding_statement_enum:
	case lang_address_statement_enum:
	case lang_fill_statement_enum:
	  break;

	default:
	  FAIL ();
	  break;
	}
    }
  return false;
}


/* Call-back for ppc64_elf_size_stubs.  */

/* Create a new stub section, and arrange for it to be linked
   immediately before INPUT_SECTION.  */

static asection *
ppc_add_stub_section (const char *stub_sec_name, asection *input_section)
{
  asection *stub_sec;
  flagword flags;
  asection *output_section;
  lang_output_section_statement_type *os;
  struct hook_stub_info info;

  flags = (SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_CODE
	   | SEC_HAS_CONTENTS | SEC_IN_MEMORY | SEC_KEEP);
  stub_sec = bfd_make_section_anyway_with_flags (stub_file->the_bfd,
						 stub_sec_name, flags);
  if (stub_sec == NULL
      || !bfd_set_section_alignment (stub_sec, (params.plt_stub_align > 5
						? params.plt_stub_align
						: params.plt_stub_align < -5
						? -params.plt_stub_align
						: 5)))
    goto err_ret;

  output_section = input_section->output_section;
  os = lang_output_section_get (output_section);

  info.input_section = input_section;
  lang_list_init (&info.add);
  lang_add_section (&info.add, stub_sec, NULL, NULL, os);

  if (info.add.head == NULL)
    goto err_ret;

  if (hook_in_stub (&info, &os->children.head))
    return stub_sec;

 err_ret:
  einfo (_("%X%P: can not make stub section: %E\n"));
  return NULL;
}


/* Another call-back for ppc64_elf_size_stubs.  */

static void
ppc_layout_sections_again (void)
{
  /* If we have changed sizes of the stub sections, then we need
     to recalculate all the section offsets.  This may mean we need to
     add even more stubs.  */
  ldelf_map_segments (true);

  if (!bfd_link_relocatable (&link_info))
    ppc64_elf_set_toc (&link_info, link_info.output_bfd);

  need_laying_out = -1;
}


static void
build_toc_list (lang_statement_union_type *statement)
{
  if (statement->header.type == lang_input_section_enum)
    {
      asection *i = statement->input_section.section;

      if (i->sec_info_type != SEC_INFO_TYPE_JUST_SYMS
	  && (i->flags & SEC_EXCLUDE) == 0
	  && i->output_section == toc_section)
	{
	  if (!ppc64_elf_next_toc_section (&link_info, i))
	    einfo (_("%X%P: linker script separates .got and .toc\n"));
	}
    }
}


static void
build_section_lists (lang_statement_union_type *statement)
{
  if (statement->header.type == lang_input_section_enum)
    {
      asection *i = statement->input_section.section;

      if (!bfd_input_just_syms (i->owner)
	  && (i->flags & SEC_EXCLUDE) == 0
	  && i->output_section != NULL
	  && i->output_section->owner == link_info.output_bfd)
	{
	  if (!ppc64_elf_next_input_section (&link_info, i))
	    einfo (_("%X%P: can not size stub section: %E\n"));
	}
    }
}


/* Call the back-end function to set TOC base after we have placed all
   the sections.  */
static void
gldelf64lppc_after_allocation (void)
{
  int ret;

  /* If generating a relocatable output file, then we don't have any
     stubs.  */
  if (stub_file != NULL && !bfd_link_relocatable (&link_info))
    {
      ret = ppc64_elf_setup_section_lists (&link_info);
      if (ret < 0)
	einfo (_("%X%P: can not size stub section: %E\n"));
      else
	{
	  ppc64_elf_start_multitoc_partition (&link_info);

	  if (!params.no_multi_toc)
	    {
	      toc_section = bfd_get_section_by_name (link_info.output_bfd,
						     toc_section_name);
	      if (toc_section != NULL)
		lang_for_each_statement (build_toc_list);
	    }

	  if (ppc64_elf_layout_multitoc (&link_info)
	      && !params.no_multi_toc
	      && toc_section != NULL)
	    lang_for_each_statement (build_toc_list);

	  ppc64_elf_finish_multitoc_partition (&link_info);

	  lang_for_each_statement (build_section_lists);

	  if (!ppc64_elf_check_init_fini (&link_info))
	    einfo (_("%P: .init/.fini fragments use differing TOC pointers\n"));

	  /* Call into the BFD backend to do the real work.  */
	  if (!ppc64_elf_size_stubs (&link_info))
	    einfo (_("%X%P: can not size stub section: %E\n"));
	}
    }

  /* We can't parse and merge .eh_frame until the glink .eh_frame has
     been generated.  Otherwise the glink .eh_frame CIE won't be
     merged with other CIEs, and worse, the glink .eh_frame FDEs won't
     be listed in .eh_frame_hdr.  */
  ret = bfd_elf_discard_info (link_info.output_bfd, &link_info);
  if (ret < 0)
    {
      einfo (_("%X%P: .eh_frame/.stab edit: %E\n"));
      return;
    }
  else if (ret > 0)
    need_laying_out = 1;

  /* Call map_segments regardless of the state of need_laying_out.
     need_laying_out set to -1 means we have just laid everything out,
     but ppc64_elf_size_stubs strips .branch_lt and .eh_frame if
     unneeded, after ppc_layout_sections_again.  Another call removes
     these sections from the segment map.  Their presence is
     innocuous except for confusing ELF_SECTION_IN_SEGMENT.  */
  ldelf_map_segments (need_laying_out > 0);

  if (need_laying_out != -1 && !bfd_link_relocatable (&link_info))
    ppc64_elf_set_toc (&link_info, link_info.output_bfd);
}


/* Final emulation specific call.  */

static void
gldelf64lppc_finish (void)
{
  char *msg = NULL;
  char *line, *endline;

  /* e_entry on PowerPC64 points to the function descriptor for
     _start.  If _start is missing, default to the first function
     descriptor in the .opd section.  */
  if (stub_file != NULL
      && (elf_elfheader (link_info.output_bfd)->e_flags & EF_PPC64_ABI) == 1)
    entry_section = ".opd";

  if (params.emit_stub_syms < 0)
    params.emit_stub_syms = 1;
  if (stub_file != NULL
      && !bfd_link_relocatable (&link_info)
      && !ppc64_elf_build_stubs (&link_info, config.stats ? &msg : NULL))
    einfo (_("%X%P: can not build stubs: %E\n"));

  fflush (stdout);
  for (line = msg; line != NULL; line = endline)
    {
      endline = strchr (line, '\n');
      if (endline != NULL)
	*endline++ = '\0';
      fprintf (stderr, "%s: %s\n", program_name, line);
    }
  fflush (stderr);
  free (msg);

  finish_default ();
}


/* Add a pattern matching ".foo" for every "foo" in a version script.

   The reason for doing this is that many shared library version
   scripts export a selected set of functions or data symbols, forcing
   others local.  eg.

   . VERS_1 {
   .       global:
   .               this; that; some; thing;
   .       local:
   .               *;
   .   };

   To make the above work for PowerPC64, we need to export ".this",
   ".that" and so on, otherwise only the function descriptor syms are
   exported.  Lack of an exported function code sym may cause a
   definition to be pulled in from a static library.  */

static struct bfd_elf_version_expr *
gldelf64lppc_new_vers_pattern (struct bfd_elf_version_expr *entry)
{
  struct bfd_elf_version_expr *dot_entry;
  unsigned int len;
  char *dot_pat;

  if (!dotsyms
      || entry->pattern[0] == '.'
      || (!entry->literal && entry->pattern[0] == '*'))
    return entry;

  dot_entry = xmalloc (sizeof *dot_entry);
  *dot_entry = *entry;
  dot_entry->next = entry;
  len = strlen (entry->pattern) + 2;
  dot_pat = xmalloc (len);
  dot_pat[0] = '.';
  memcpy (dot_pat + 1, entry->pattern, len - 1);
  dot_entry->pattern = dot_pat;
  dot_entry->script = 1;
  return dot_entry;
}


static void
gldelf64lppc_before_parse (void)
{
  ldfile_set_output_arch ("powerpc:common64", bfd_arch_powerpc);
  input_flags.dynamic = true;
  config.has_shared = true;
  config.separate_code = false;
  link_info.check_relocs_after_open_input = true;
  link_info.relro = DEFAULT_LD_Z_RELRO;
  link_info.separate_code = DEFAULT_LD_Z_SEPARATE_CODE;
  link_info.warn_execstack = DEFAULT_LD_WARN_EXECSTACK;
  link_info.no_warn_rwx_segments = ! DEFAULT_LD_WARN_RWX_SEGMENTS;
  link_info.default_execstack = DEFAULT_LD_EXECSTACK;
  link_info.error_execstack = DEFAULT_LD_ERROR_EXECSTACK;
  link_info.warn_is_error_for_rwx_segments = DEFAULT_LD_ERROR_RWX_SEGMENTS;
}


/* These variables are used to implement target options */

static char *audit; /* colon (typically) separated list of libs */
static char *depaudit; /* colon (typically) separated list of libs */


/* This is called before calling plugin 'all symbols read' hook.  */

static void
gldelf64lppc_before_plugin_all_symbols_read (void)
{
  ldelf_before_plugin_all_symbols_read (true, false,
				        false,
					false,
					64, "/usr");
}

/* This is called after all the input files have been opened.  */

static void
gldelf64lppc_after_open (void)
{
  ldelf_after_open (true, false,
		    false, false, 64, "/usr");
}


/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldelf64lppc_before_allocation (void)
{
  ldelf_before_allocation (audit, depaudit, NULL);
}


static char *
gldelf64lppc_get_script (int *isfile)
{
  *isfile = 0;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return
"/* Script for -Ur */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
 /* For some reason, the Solaris linker makes bad executables\n\
  if gld -r is used and the intermediate file has sections starting\n\
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld\n\
  bug.  But for now assigning the zero vmas works.  */\n\
SECTIONS\n\
{\n\
  .interp       0 : { *(.interp) }\n\
  .note.gnu.build-id 0: { *(.note.gnu.build-id) }\n\
  .hash         0 : { *(.hash) }\n\
  .gnu.hash     0 : { *(.gnu.hash) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .dynstr       0 : { *(.dynstr) }\n\
  .gnu.version  0 : { *(.gnu.version) }\n\
  .gnu.version_d 0: { *(.gnu.version_d) }\n\
  .gnu.version_r 0: { *(.gnu.version_r) }\n\
  .rela.opd	0 : { *(.rela.opd) }\n\
  .rela.init    0 : { *(.rela.init) }\n"
"  .rela.text    0 : { *(.rela.text) }\n\
  .rela.fini    0 : { *(.rela.fini) }\n\
  .rela.rodata  0 : { *(.rela.rodata) }\n\
  .rela.data.rel.ro 0 : { *(.rela.data.rel.ro) }\n\
  .rela.data    0 : { *(.rela.data) }\n\
  .rela.tdata	0 : { *(.rela.tdata) }\n\
  .rela.tbss	0 : { *(.rela.tbss) }\n\
  .rela.ctors   0 : { *(.rela.ctors) }\n\
  .rela.dtors   0 : { *(.rela.dtors) }\n\
  .rela.got     0 : { *(.rela.got) }\n\
  .rela.toc	0 : { *(.rela.toc) }\n\
  .rela.toc1	0 : { *(.rela.toc1) }\n\
  .rela.tocbss	0 : { *(.rela.tocbss) }\n\
  .rela.branch_lt	0 : { *(.rela.branch_lt) }\n\
  .rela.sdata   0 : { *(.rela.sdata) }\n\
  .rela.sbss    0 : { *(.rela.sbss) }\n\
  .rela.sdata2  0 : { *(.rela.sdata2) }\n\
  .rela.sbss2   0 : { *(.rela.sbss2) }\n\
  .rela.bss     0 : { *(.rela.bss) }\n\
  .rela.iplt    0 :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt     0 :\n\
    {\n"
"      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init         0 :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text         0 :\n\
  {\n\
    *(.text .stub)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
  }\n\
  .fini         0 :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  .rodata       0 : { *(.rodata) }\n\
  .rodata1      0 : { *(.rodata1) }\n\
  .sdata2       0 :\n\
  {\n\
    *(.sdata2)\n\
  }\n\
  .sbss2        0 : { *(.sbss2) }\n\
  .eh_frame_hdr 0 : { *(.eh_frame_hdr) }\n"
"  .eh_frame     0 : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .sframe       0 : ONLY_IF_RO { *(.sframe) }\n\
  .gcc_except_table 0 : ONLY_IF_RO { *(.gcc_except_table) }\n\
  .gnu_extab 0 : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges 0 : ONLY_IF_RO { *(.exception_ranges) }\n\
  /* Exception handling  */\n\
  .eh_frame     0 : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .sframe       0 : ONLY_IF_RW { *(.sframe) }\n\
  .gnu_extab    0 : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table 0 : ONLY_IF_RW { *(.gcc_except_table) }\n\
  .exception_ranges 0 : ONLY_IF_RW { *(.exception_ranges) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	0 :\n\
   {\n\
     *(.tdata)\n\
   }\n\
  .tbss		0 : { *(.tbss) }\n\
  .jcr          0 : { KEEP (*(.jcr)) }\n\
  .dynamic      0 : { *(.dynamic) }\n\
  .opd		0 : { KEEP (*(.opd)) }\n\
  .toc1		0 : { *(.toc1) }\n\
  .branch_lt	0 : { *(.branch_lt) }\n\
  .got		0 : { *(.got) }\n\
  .toc		0 : { *(.toc) }\n"
"  .toc		0 : { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata        0 :\n\
  {\n\
    *(.sdata)\n\
  }\n\
  .tocbss	0 : { *(.tocbss)}\n\
  .sbss         0 :\n\
  {\n\
    *(.sbss)\n\
  }\n\
  .plt          0 : { *(.plt) }\n\
  .iplt         0 : { *(.iplt) }\n\
  .data         0 :\n\
  {\n\
    *(.data)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1        0 : { *(.data1) }\n\
  .bss          0 :\n\
  {\n\
   *(.bss)\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else if (bfd_link_relocatable (&link_info)) return
"/* Script for -r */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
 /* For some reason, the Solaris linker makes bad executables\n\
  if gld -r is used and the intermediate file has sections starting\n\
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld\n\
  bug.  But for now assigning the zero vmas works.  */\n\
SECTIONS\n\
{\n\
  .interp       0 : { *(.interp) }\n\
  .note.gnu.build-id 0: { *(.note.gnu.build-id) }\n\
  .hash         0 : { *(.hash) }\n\
  .gnu.hash     0 : { *(.gnu.hash) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .dynstr       0 : { *(.dynstr) }\n\
  .gnu.version  0 : { *(.gnu.version) }\n\
  .gnu.version_d 0: { *(.gnu.version_d) }\n\
  .gnu.version_r 0: { *(.gnu.version_r) }\n\
  .rela.opd	0 : { *(.rela.opd) }\n\
  .rela.init    0 : { *(.rela.init) }\n"
"  .rela.text    0 : { *(.rela.text) }\n\
  .rela.fini    0 : { *(.rela.fini) }\n\
  .rela.rodata  0 : { *(.rela.rodata) }\n\
  .rela.data.rel.ro 0 : { *(.rela.data.rel.ro) }\n\
  .rela.data    0 : { *(.rela.data) }\n\
  .rela.tdata	0 : { *(.rela.tdata) }\n\
  .rela.tbss	0 : { *(.rela.tbss) }\n\
  .rela.ctors   0 : { *(.rela.ctors) }\n\
  .rela.dtors   0 : { *(.rela.dtors) }\n\
  .rela.got     0 : { *(.rela.got) }\n\
  .rela.toc	0 : { *(.rela.toc) }\n\
  .rela.toc1	0 : { *(.rela.toc1) }\n\
  .rela.tocbss	0 : { *(.rela.tocbss) }\n\
  .rela.branch_lt	0 : { *(.rela.branch_lt) }\n\
  .rela.sdata   0 : { *(.rela.sdata) }\n\
  .rela.sbss    0 : { *(.rela.sbss) }\n\
  .rela.sdata2  0 : { *(.rela.sdata2) }\n\
  .rela.sbss2   0 : { *(.rela.sbss2) }\n\
  .rela.bss     0 : { *(.rela.bss) }\n\
  .rela.iplt    0 :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt     0 :\n\
    {\n"
"      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init         0 :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text         0 :\n\
  {\n\
    *(.text .stub)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
  }\n\
  .fini         0 :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  .rodata       0 : { *(.rodata) }\n\
  .rodata1      0 : { *(.rodata1) }\n\
  .sdata2       0 :\n\
  {\n\
    *(.sdata2)\n\
  }\n\
  .sbss2        0 : { *(.sbss2) }\n\
  .eh_frame_hdr 0 : { *(.eh_frame_hdr) }\n"
"  .eh_frame     0 : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .sframe       0 : ONLY_IF_RO { *(.sframe) }\n\
  .gcc_except_table 0 : ONLY_IF_RO { *(.gcc_except_table) }\n\
  .gnu_extab 0 : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges 0 : ONLY_IF_RO { *(.exception_ranges) }\n\
  /* Exception handling  */\n\
  .eh_frame     0 : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .sframe       0 : ONLY_IF_RW { *(.sframe) }\n\
  .gnu_extab    0 : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table 0 : ONLY_IF_RW { *(.gcc_except_table) }\n\
  .exception_ranges 0 : ONLY_IF_RW { *(.exception_ranges) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	0 :\n\
   {\n\
     *(.tdata)\n\
   }\n\
  .tbss		0 : { *(.tbss) }\n\
  .jcr          0 : { KEEP (*(.jcr)) }\n\
  .dynamic      0 : { *(.dynamic) }\n\
  .opd		0 : { KEEP (*(.opd)) }\n\
  .toc1		0 : { *(.toc1) }\n\
  .branch_lt	0 : { *(.branch_lt) }\n\
  .got		0 : { *(.got) }\n\
  .toc		0 : { *(.toc) }\n"
"  .toc		0 : { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata        0 :\n\
  {\n\
    *(.sdata)\n\
  }\n\
  .tocbss	0 : { *(.tocbss)}\n\
  .sbss         0 :\n\
  {\n\
    *(.sbss)\n\
  }\n\
  .plt          0 : { *(.plt) }\n\
  .iplt         0 : { *(.iplt) }\n\
  .data         0 :\n\
  {\n\
    *(.data)\n\
  }\n\
  .data1        0 : { *(.data1) }\n\
  .bss          0 :\n\
  {\n\
   *(.bss)\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n"
"  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n"
"  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n"
"  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = .;\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n"
"  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n"
"  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n"
"  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n"
"  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n"
"  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)
             && link_info.combreloc
             && link_info.separate_code
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -pie -z combreloc -z separate-code -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n"
"  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n"
"  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)
             && link_info.combreloc
             && link_info.relro
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -pie -z combreloc -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n"
"      *(.rela.opd)\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n"
"    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n"
"   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)
             && link_info.separate_code
             && link_info.combreloc) return
"/* Script for -pie -z combreloc -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n"
"  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n"
"  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)
             && link_info.combreloc) return
"/* Script for -pie -z combreloc */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n"
"      *(.rela.opd)\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n"
"    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n"
"   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)
             && link_info.separate_code) return
"/* Script for -pie -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n"
"  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n"
"    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n"
"  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n"
"  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_pie (&link_info)) return
"/* Script for -pie */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0)); . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n"
"  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n"
"      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n"
"  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n"
"  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)
             && link_info.combreloc
             && link_info.separate_code
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -shared -z combreloc -z separate-code -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n\
      *(.rela.init)\n"
"      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n"
"  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n"
"  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n"
"   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)
             && link_info.combreloc
             && link_info.relro
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -shared -z combreloc -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n"
"  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n"
"  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n"
"    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)
             && link_info.combreloc
             && link_info.separate_code) return
"/* Script for -shared -z combreloc -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n\
      *(.rela.init)\n"
"      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n"
"  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n"
"  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n"
"   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)
             && link_info.combreloc) return
"/* Script for -shared -z combreloc */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n"
"  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n"
"  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n"
"    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)
             && link_info.separate_code) return
"/* Script for -shared -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rela.fini      : { *(.rela.fini) }\n"
"  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n"
"  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n"
"     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (bfd_link_dll (&link_info)) return
"/* Script for -shared */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = SEGMENT_START(\"text-segment\", 0) + SIZEOF_HEADERS;\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n"
"  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      *(.rela.iplt)\n\
    }\n\
  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n"
"    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n"
"  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n"
"  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
  }\n\
  .fini_array    :\n\
  {\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*)\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  PROVIDE (_edata = .); PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  PROVIDE (__bss_start = .);\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  PROVIDE (_end = .); PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (link_info.combreloc
             && link_info.separate_code
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -z combreloc -z separate-code -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n\
  .rela.plt       :\n\
    {\n"
"      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n"
"  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n"
"  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (link_info.combreloc
             && link_info.relro
             && (link_info.flags & DF_BIND_NOW)) return
"/* Script for -z combreloc -z relro -z now */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n"
"      *(.rela.opd)\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n\
  .rela.plt       :\n"
"    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n"
"  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n"
"  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt) + (-MAX(ALIGNOF(.plt),8) & (-SIZEOF(.plt) + (-MAX(ALIGNOF(.iplt),8) & -SIZEOF(.iplt)))))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (link_info.combreloc
             && link_info.separate_code) return
"/* Script for -z combreloc -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.opd)\n"
"      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n\
  .rela.plt       :\n\
    {\n"
"      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n"
"  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n"
"  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (link_info.combreloc) return
"/* Script for -z combreloc */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.dyn       :\n\
    {\n"
"      *(.rela.opd)\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.toc)\n\
      *(.rela.toc1)\n\
      *(.rela.tocbss)\n\
      *(.rela.branch_lt)\n\
      *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*)\n\
      *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*)\n\
      *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*)\n\
      *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n\
  .rela.plt       :\n"
"    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n\
  PROVIDE (__etext = .);\n"
"  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n"
"  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else if (link_info.separate_code) return
"/* Script for -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n"
"  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n\
  .rela.plt       :\n"
"    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n"
"  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  . = ALIGN(CONSTANT (MAXPAGESIZE));\n\
  /* Adjust the address for the rodata segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = SEGMENT_START(\"rodata-segment\", ALIGN(CONSTANT (MAXPAGESIZE)) + (. & (CONSTANT (MAXPAGESIZE) - 1)));\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n"
"  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-powerpcle\", \"elf64-powerpcle\",\n\
	      \"elf64-powerpcle\")\n\
OUTPUT_ARCH(powerpc:common64)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/ppc64le-elf/lib64\"); SEARCH_DIR(\"=/usr/local/lib64\"); SEARCH_DIR(\"=/lib64\"); SEARCH_DIR(\"=/usr/lib64\"); SEARCH_DIR(\"=/usr/ppc64le-elf/lib\"); SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = SEGMENT_START(\"text-segment\", 0x10000000)); . = SEGMENT_START(\"text-segment\", 0x10000000) + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .note.gnu.build-id  : { *(.note.gnu.build-id) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rela.opd	  : { *(.rela.opd) }\n\
  .rela.init      : { *(.rela.init) }\n"
"  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro .rela.data.rel.ro.* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rela.toc	  : { *(.rela.toc) }\n\
  .rela.toc1	  : { *(.rela.toc1) }\n\
  .rela.tocbss	  : { *(.rela.tocbss) }\n\
  .rela.branch_lt	  : { *(.rela.branch_lt) }\n\
  .rela.sdata     : { *(.rela.sdata .rela.sdata.* .rela.gnu.linkonce.s.*) }\n\
  .rela.sbss      : { *(.rela.sbss .rela.sbss.* .rela.gnu.linkonce.sb.*) }\n\
  .rela.sdata2    : { *(.rela.sdata2 .rela.sdata2.* .rela.gnu.linkonce.s2.*) }\n\
  .rela.sbss2     : { *(.rela.sbss2 .rela.sbss2.* .rela.gnu.linkonce.sb2.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rela.iplt      :\n\
    {\n\
      PROVIDE_HIDDEN (__rela_iplt_start = .);\n\
      *(.rela.iplt)\n\
      PROVIDE_HIDDEN (__rela_iplt_end = .);\n\
    }\n"
"  .rela.plt       :\n\
    {\n\
      *(.rela.plt)\n\
    }\n\
  .relr.dyn : { *(.relr.dyn) }\n\
  .init           :\n\
  {\n\
    KEEP (*(SORT_NONE(.init)))\n\
  }\n\
  .text           :\n\
  {\n\
    *(.text.unlikely .text.*_unlikely .text.unlikely.*)\n\
    *(.text.exit .text.exit.*)\n\
    *(.text.startup .text.startup.*)\n\
    *(.text.hot .text.hot.*)\n\
    *(SORT(.text.sorted.*))\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    /* .gnu.warning sections are handled specially by elf.em.  */\n\
    *(.gnu.warning)\n\
    *(.sfpr .glink)\n\
  }\n\
  .fini           :\n\
  {\n\
    KEEP (*(SORT_NONE(.fini)))\n\
  }\n"
"  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .sdata2         :\n\
  {\n\
    *(.sdata2 .sdata2.* .gnu.linkonce.s2.*)\n\
  }\n\
  .sbss2          : { *(.sbss2 .sbss2.* .gnu.linkonce.sb2.*) }\n\
  .eh_frame_hdr   : { *(.eh_frame_hdr) *(.eh_frame_entry .eh_frame_entry.*) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RO { *(.sframe) *(.sframe.*) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  .gnu_extab   : ONLY_IF_RO { *(.gnu_extab*) }\n\
  /* These sections are generated by the Sun/Oracle C++ compiler.  */\n\
  .exception_ranges   : ONLY_IF_RO { *(.exception_ranges*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) *(.eh_frame.*) }\n\
  .sframe         : ONLY_IF_RW { *(.sframe) *(.sframe.*) }\n\
  .gnu_extab      : ONLY_IF_RW { *(.gnu_extab) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n"
"  .exception_ranges   : ONLY_IF_RW { *(.exception_ranges*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  :\n\
   {\n\
     PROVIDE_HIDDEN (__tdata_start = .);\n\
     *(.tdata .tdata.* .gnu.linkonce.td.*)\n\
   }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__init_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*) SORT_BY_INIT_PRIORITY(.ctors.*)))\n\
    KEEP (*(.init_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .ctors))\n\
    PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array    :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*) SORT_BY_INIT_PRIORITY(.dtors.*)))\n\
    KEEP (*(.fini_array EXCLUDE_FILE (*crtbegin.o *crtbegin?.o *crtend.o *crtend?.o ) .dtors))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro .data.rel.ro.* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .opd		  : ALIGN(8) { KEEP (*(.opd)) }\n\
  .toc1		  : ALIGN(8) { *(.toc1) }\n\
  .branch_lt	 ALIGNOF(.branch_lt) < 256 && SIZEOF(.got) != 0 ? . + (((-MAX(ALIGNOF(.branch_lt),8) & (-SIZEOF(.branch_lt))) - .) & 255) : ALIGN(MAX(ALIGNOF(.branch_lt), SIZEOF(.got) != 0 ? 256 : 8)) : { *(.branch_lt) }\n\
  .got		: ALIGN(256) { *(.got .toc) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .toc		  : ALIGN(8) { *(.toc) }\n\
  /* We want the small data sections together, so single-instruction offsets\n\
     can access them all, and initialized data all before uninitialized, so\n\
     we can shorten the on-disk segment size.  */\n\
  .sdata          :\n\
  {\n\
    *(.sdata .sdata.* .gnu.linkonce.s.*)\n\
  }\n\
  .tocbss	  : ALIGN(8) { *(.tocbss)}\n\
  .sbss           :\n\
  {\n\
    *(.dynsbss)\n\
    *(.sbss .sbss.* .gnu.linkonce.sb.*)\n\
    *(.scommon)\n\
  }\n\
  .plt            : { *(.plt) }\n\
  .iplt           : { *(.iplt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  _edata = .; PROVIDE (edata = .);\n\
  . = ALIGN(ALIGNOF(NEXT_SECTION));\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we do not\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 64 / 8 : 1);\n\
  }\n\
  . = ALIGN(64 / 8);\n\
  . = SEGMENT_START(\"ldata-segment\", .);\n\
  . = ALIGN(64 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
  /DISCARD/ : { *(.note.GNU-stack) *(.gnu_debuglink) *(.gnu.lto_*) }\n\
}\n\n"
; }
 
#define OPTION_LD_GENERATED_UNWIND_INFO	301
#define OPTION_NO_LD_GENERATED_UNWIND_INFO 302

enum ppc64_opt
{
  OPTION_STUBGROUP_SIZE = 321,
  OPTION_PLT_STATIC_CHAIN,
  OPTION_NO_PLT_STATIC_CHAIN,
  OPTION_PLT_THREAD_SAFE,
  OPTION_NO_PLT_THREAD_SAFE,
  OPTION_PLT_ALIGN,
  OPTION_NO_PLT_ALIGN,
  OPTION_PLT_LOCALENTRY,
  OPTION_NO_PLT_LOCALENTRY,
  OPTION_POWER10_STUBS,
  OPTION_NO_POWER10_STUBS,
  OPTION_NO_PCREL_OPT,
  OPTION_STUBSYMS,
  OPTION_NO_STUBSYMS,
  OPTION_SAVRES,
  OPTION_NO_SAVRES,
  OPTION_DOTSYMS,
  OPTION_NO_DOTSYMS,
  OPTION_NO_TLS_OPT,
  OPTION_TLS_GET_ADDR_OPT,
  OPTION_NO_TLS_GET_ADDR_OPT,
  OPTION_TLS_GET_ADDR_REGSAVE,
  OPTION_NO_TLS_GET_ADDR_REGSAVE,
  OPTION_NO_OPD_OPT,
  OPTION_NO_INLINE_OPT,
  OPTION_NO_TOC_OPT,
  OPTION_NO_MULTI_TOC,
  OPTION_NO_TOC_SORT,
  OPTION_NON_OVERLAPPING_OPD
};


enum elf_options
{
  OPTION_DISABLE_NEW_DTAGS = 400,
  OPTION_ENABLE_NEW_DTAGS,
  OPTION_GROUP,
  OPTION_EH_FRAME_HDR,
  OPTION_NO_EH_FRAME_HDR,
  OPTION_EXCLUDE_LIBS,
  OPTION_HASH_STYLE,
  OPTION_BUILD_ID,
  OPTION_PACKAGE_METADATA,
  OPTION_AUDIT,
  OPTION_COMPRESS_DEBUG
};

static void
gldelf64lppc_add_options
  (int ns, char **shortopts, int nl, struct option **longopts,
   int nrl ATTRIBUTE_UNUSED, struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const char xtra_short[] = "z:P:";
  static const struct option xtra_long[] = {
    {"audit", required_argument, NULL, OPTION_AUDIT},
    {"Bgroup", no_argument, NULL, OPTION_GROUP},
    {"build-id", optional_argument, NULL, OPTION_BUILD_ID},
    {"package-metadata", optional_argument, NULL, OPTION_PACKAGE_METADATA},
    {"compress-debug-sections", required_argument, NULL, OPTION_COMPRESS_DEBUG},
    {"depaudit", required_argument, NULL, 'P'},
    {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
    {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
    {"eh-frame-hdr", no_argument, NULL, OPTION_EH_FRAME_HDR},
    {"no-eh-frame-hdr", no_argument, NULL, OPTION_NO_EH_FRAME_HDR},
    {"exclude-libs", required_argument, NULL, OPTION_EXCLUDE_LIBS},
    {"hash-style", required_argument, NULL, OPTION_HASH_STYLE},
    
  {"ld-generated-unwind-info", no_argument, NULL,
   OPTION_LD_GENERATED_UNWIND_INFO},
  {"no-ld-generated-unwind-info", no_argument, NULL,
   OPTION_NO_LD_GENERATED_UNWIND_INFO},

  { "stub-group-size", required_argument, NULL, OPTION_STUBGROUP_SIZE },
  { "plt-static-chain", no_argument, NULL, OPTION_PLT_STATIC_CHAIN },
  { "no-plt-static-chain", no_argument, NULL, OPTION_NO_PLT_STATIC_CHAIN },
  { "plt-thread-safe", no_argument, NULL, OPTION_PLT_THREAD_SAFE },
  { "no-plt-thread-safe", no_argument, NULL, OPTION_NO_PLT_THREAD_SAFE },
  { "plt-align", optional_argument, NULL, OPTION_PLT_ALIGN },
  { "no-plt-align", no_argument, NULL, OPTION_NO_PLT_ALIGN },
  { "plt-localentry", optional_argument, NULL, OPTION_PLT_LOCALENTRY },
  { "no-plt-localentry", no_argument, NULL, OPTION_NO_PLT_LOCALENTRY },
  { "power10-stubs", optional_argument, NULL, OPTION_POWER10_STUBS },
  { "no-pcrel-optimize", no_argument, NULL, OPTION_NO_PCREL_OPT },
  { "no-power10-stubs", no_argument, NULL, OPTION_NO_POWER10_STUBS },
  { "emit-stub-syms", no_argument, NULL, OPTION_STUBSYMS },
  { "no-emit-stub-syms", no_argument, NULL, OPTION_NO_STUBSYMS },
  { "dotsyms", no_argument, NULL, OPTION_DOTSYMS },
  { "no-dotsyms", no_argument, NULL, OPTION_NO_DOTSYMS },
  { "save-restore-funcs", no_argument, NULL, OPTION_SAVRES },
  { "no-save-restore-funcs", no_argument, NULL, OPTION_NO_SAVRES },
  { "no-tls-optimize", no_argument, NULL, OPTION_NO_TLS_OPT },
  { "tls-get-addr-optimize", no_argument, NULL, OPTION_TLS_GET_ADDR_OPT },
  { "no-tls-get-addr-optimize", no_argument, NULL, OPTION_NO_TLS_GET_ADDR_OPT },
  { "tls-get-addr-regsave", no_argument, NULL, OPTION_TLS_GET_ADDR_REGSAVE },
  { "no-tls-get-addr-regsave", no_argument, NULL, OPTION_NO_TLS_GET_ADDR_REGSAVE},
  { "no-opd-optimize", no_argument, NULL, OPTION_NO_OPD_OPT },
  { "no-inline-optimize", no_argument, NULL, OPTION_NO_INLINE_OPT },
  { "no-toc-optimize", no_argument, NULL, OPTION_NO_TOC_OPT },
  { "no-multi-toc", no_argument, NULL, OPTION_NO_MULTI_TOC },
  { "no-toc-sort", no_argument, NULL, OPTION_NO_TOC_SORT },
  { "non-overlapping-opd", no_argument, NULL, OPTION_NON_OVERLAPPING_OPD },

    {NULL, no_argument, NULL, 0}
  };

  *shortopts = (char *) xrealloc (*shortopts, ns + sizeof (xtra_short));
  memcpy (*shortopts + ns, &xtra_short, sizeof (xtra_short));
  *longopts = (struct option *)
    xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

#define DEFAULT_BUILD_ID_STYLE	"sha1"

static bool
gldelf64lppc_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return false;

    case OPTION_BUILD_ID:
      free ((char *) ldelf_emit_note_gnu_build_id);
      ldelf_emit_note_gnu_build_id = NULL;
      if (optarg == NULL)
	optarg = DEFAULT_BUILD_ID_STYLE;
      if (strcmp (optarg, "none"))
	ldelf_emit_note_gnu_build_id = xstrdup (optarg);
      break;

    case OPTION_PACKAGE_METADATA:
      free ((char *) ldelf_emit_note_fdo_package_metadata);
      ldelf_emit_note_fdo_package_metadata = NULL;
      if (optarg != NULL && strlen(optarg) > 0)
	ldelf_emit_note_fdo_package_metadata = xstrdup (optarg);
      break;

    case OPTION_COMPRESS_DEBUG:
      config.compress_debug = bfd_get_compression_algorithm (optarg);
      if (strcasecmp (optarg, "zstd") == 0)
	{
#ifndef HAVE_ZSTD
	  if (config.compress_debug == COMPRESS_DEBUG_ZSTD)
	    einfo (_ ("%F%P: --compress-debug-sections=zstd: ld is not built "
		  "with zstd support\n"));
#endif
	}
      if (config.compress_debug == COMPRESS_UNKNOWN)
	einfo (_("%F%P: invalid --compress-debug-sections option: `%s'\n"),
	       optarg);
      break;
    case OPTION_AUDIT:
	ldelf_append_to_separated_string (&audit, optarg);
	break;

    case 'P':
	ldelf_append_to_separated_string (&depaudit, optarg);
	break;

    case OPTION_DISABLE_NEW_DTAGS:
      link_info.new_dtags = false;
      break;

    case OPTION_ENABLE_NEW_DTAGS:
      link_info.new_dtags = true;
      break;

    case OPTION_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = DWARF2_EH_HDR;
      break;

    case OPTION_NO_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = 0;
      break;

    case OPTION_GROUP:
      link_info.flags_1 |= (bfd_vma) DF_1_GROUP;
      /* Groups must be self-contained.  */
      link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      link_info.unresolved_syms_in_shared_libs = RM_DIAGNOSE;
      break;

    case OPTION_EXCLUDE_LIBS:
      add_excluded_libs (optarg);
      break;

    case OPTION_HASH_STYLE:
      link_info.emit_hash = false;
      link_info.emit_gnu_hash = false;
      if (strcmp (optarg, "sysv") == 0)
	link_info.emit_hash = true;
      else if (strcmp (optarg, "gnu") == 0)
	link_info.emit_gnu_hash = true;
      else if (strcmp (optarg, "both") == 0)
	{
	  link_info.emit_hash = true;
	  link_info.emit_gnu_hash = true;
	}
      else
	einfo (_("%F%P: invalid hash style `%s'\n"), optarg);
      break;

    case 'z':
      if (strcmp (optarg, "defs") == 0)
	link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      else if (strcmp (optarg, "undefs") == 0)
	link_info.unresolved_syms_in_objects = RM_IGNORE;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = true;
      else if (startswith (optarg, "max-page-size="))
	{
	  char *end;

	  link_info.maxpagesize = strtoul (optarg + 14, &end, 0);
	  if (*end
	      || (link_info.maxpagesize & (link_info.maxpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid maximum page size `%s'\n"),
		   optarg + 14);
	  link_info.maxpagesize_is_set = true;
	}
      else if (startswith (optarg, "common-page-size="))
	{
	  char *end;
	  link_info.commonpagesize = strtoul (optarg + 17, &end, 0);
	  if (*end
	      || (link_info.commonpagesize & (link_info.commonpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid common page size `%s'\n"),
		   optarg + 17);
	  link_info.commonpagesize_is_set = true;
	}
      else if (startswith (optarg, "stack-size="))
	{
	  char *end;
	  link_info.stacksize = strtoul (optarg + 11, &end, 0);
	  if (*end || link_info.stacksize < 0)
	    einfo (_("%F%P: invalid stack size `%s'\n"), optarg + 11);
	  if (!link_info.stacksize)
	    /* Use -1 for explicit no-stack, because zero means
	       'default'.   */
	    link_info.stacksize = -1;
	}
      else if (strcmp (optarg, "execstack") == 0)
	{
	  link_info.execstack = true;
	  link_info.noexecstack = false;
	}
      else if (strcmp (optarg, "noexecstack") == 0)
	{
	  link_info.noexecstack = true;
	  link_info.execstack = false;
	}
      else if (strcmp (optarg, "unique-symbol") == 0)
	link_info.unique_symbol = true;
      else if (strcmp (optarg, "nounique-symbol") == 0)
	link_info.unique_symbol = false;
      else if (strcmp (optarg, "globalaudit") == 0)
	{
	  link_info.flags_1 |= DF_1_GLOBAUDIT;
	}
      else if (startswith (optarg, "start-stop-gc"))
	link_info.start_stop_gc = true;
      else if (startswith (optarg, "nostart-stop-gc"))
	link_info.start_stop_gc = false;
      else if (startswith (optarg, "start-stop-visibility="))
	{
	  if (strcmp (optarg, "start-stop-visibility=default") == 0)
	    link_info.start_stop_visibility = STV_DEFAULT;
	  else if (strcmp (optarg, "start-stop-visibility=internal") == 0)
	    link_info.start_stop_visibility = STV_INTERNAL;
	  else if (strcmp (optarg, "start-stop-visibility=hidden") == 0)
	    link_info.start_stop_visibility = STV_HIDDEN;
	  else if (strcmp (optarg, "start-stop-visibility=protected") == 0)
	    link_info.start_stop_visibility = STV_PROTECTED;
	  else
	    einfo (_("%F%P: invalid visibility in `-z %s'; "
		     "must be default, internal, hidden, or protected"),
		   optarg);
	}
      else if (strcmp (optarg, "sectionheader") == 0)
	config.no_section_header = false;
      else if (strcmp (optarg, "nosectionheader") == 0)
	config.no_section_header = true;
      else if (strcmp (optarg, "global") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_GLOBAL;
      else if (strcmp (optarg, "initfirst") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INITFIRST;
      else if (strcmp (optarg, "interpose") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INTERPOSE;
      else if (strcmp (optarg, "loadfltr") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_LOADFLTR;
      else if (strcmp (optarg, "nodefaultlib") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODEFLIB;
      else if (strcmp (optarg, "nodelete") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODELETE;
      else if (strcmp (optarg, "nodlopen") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NOOPEN;
      else if (strcmp (optarg, "nodump") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODUMP;
      else if (strcmp (optarg, "now") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 |= (bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "lazy") == 0)
	{
	  link_info.flags &= ~(bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 &= ~(bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "origin") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_ORIGIN;
	  link_info.flags_1 |= (bfd_vma) DF_1_ORIGIN;
	}
      else if (strcmp (optarg, "unique") == 0)
	link_info.gnu_flags_1 |= (bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "nounique") == 0)
	link_info.gnu_flags_1 &= ~(bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "combreloc") == 0)
	link_info.combreloc = true;
      else if (strcmp (optarg, "nocombreloc") == 0)
	link_info.combreloc = false;
      else if (strcmp (optarg, "nocopyreloc") == 0)
	link_info.nocopyreloc = true;
      else if (strcmp (optarg, "relro") == 0)
	link_info.relro = true;
      else if (strcmp (optarg, "norelro") == 0)
	link_info.relro = false;
      else if (strcmp (optarg, "separate-code") == 0)
	link_info.separate_code = true;
      else if (strcmp (optarg, "noseparate-code") == 0)
	link_info.separate_code = false;
      else if (strcmp (optarg, "common") == 0)
	link_info.elf_stt_common = elf_stt_common;
      else if (strcmp (optarg, "nocommon") == 0)
	link_info.elf_stt_common = no_elf_stt_common;
      else if (strcmp (optarg, "text") == 0)
	link_info.textrel_check = textrel_check_error;
      else if (strcmp (optarg, "notext") == 0)
	link_info.textrel_check = textrel_check_none;
      else if (strcmp (optarg, "textoff") == 0)
	link_info.textrel_check = textrel_check_none;
  
      else if (strcmp (optarg, "dynamic-undefined-weak") == 0)
	link_info.dynamic_undefined_weak = true;
      else if (strcmp (optarg, "nodynamic-undefined-weak") == 0)
	link_info.dynamic_undefined_weak = false;
 
      else if (strcmp (optarg, "pack-relative-relocs") == 0)
	link_info.enable_dt_relr = true;
      else if (strcmp (optarg, "nopack-relative-relocs") == 0)
	link_info.enable_dt_relr = false;

      else
	einfo (_("%P: warning: -z %s ignored\n"), optarg);
      break;
 
    case OPTION_LD_GENERATED_UNWIND_INFO:
      link_info.no_ld_generated_unwind_info = false;
      break;

    case OPTION_NO_LD_GENERATED_UNWIND_INFO:
      link_info.no_ld_generated_unwind_info = true;
      break;

    case OPTION_STUBGROUP_SIZE:
      {
	const char *end;
	params.group_size = bfd_scan_vma (optarg, &end, 0);
	if (*end)
	  einfo (_("%F%P: invalid number `%s'\n"), optarg);
      }
      break;

    case OPTION_PLT_STATIC_CHAIN:
      params.plt_static_chain = 1;
      break;

    case OPTION_NO_PLT_STATIC_CHAIN:
      params.plt_static_chain = 0;
      break;

    case OPTION_PLT_THREAD_SAFE:
      params.plt_thread_safe = 1;
      break;

    case OPTION_NO_PLT_THREAD_SAFE:
      params.plt_thread_safe = 0;
      break;

    case OPTION_PLT_ALIGN:
      if (optarg != NULL)
	{
	  char *end;
	  long val = strtol (optarg, &end, 0);
	  if (*end || (unsigned long) val + 8 > 16)
	    einfo (_("%F%P: invalid --plt-align `%s'\n"), optarg);
	  params.plt_stub_align = val;
	}
      else
	params.plt_stub_align = 5;
      break;

    case OPTION_NO_PLT_ALIGN:
      params.plt_stub_align = 0;
      break;

    case OPTION_PLT_LOCALENTRY:
      params.plt_localentry0 = 1;
      break;

    case OPTION_NO_PLT_LOCALENTRY:
      params.plt_localentry0 = 0;
      break;

    case OPTION_POWER10_STUBS:
      if (optarg != NULL)
	{
	  if (strcasecmp (optarg, "auto") == 0)
	    params.power10_stubs = -1;
	  else if (strcasecmp (optarg, "yes") == 0)
	    params.power10_stubs = 1;
	  else if (strcasecmp (optarg, "no") == 0)
	    params.power10_stubs = 0;
	  else
	    einfo (_("%F%P: invalid --power10-stubs argument `%s'\n"),
		   optarg);
	}
      else
	params.power10_stubs = 1;
      break;

    case OPTION_NO_POWER10_STUBS:
      params.power10_stubs = 0;
      break;

    case OPTION_NO_PCREL_OPT:
      params.no_pcrel_opt = 1;
      break;

    case OPTION_STUBSYMS:
      params.emit_stub_syms = 1;
      break;

    case OPTION_NO_STUBSYMS:
      params.emit_stub_syms = 0;
      break;

    case OPTION_DOTSYMS:
      dotsyms = 1;
      break;

    case OPTION_NO_DOTSYMS:
      dotsyms = 0;
      break;

    case OPTION_SAVRES:
      params.save_restore_funcs = 1;
      break;

    case OPTION_NO_SAVRES:
      params.save_restore_funcs = 0;
      break;

    case OPTION_NO_TLS_OPT:
      no_tls_opt = 1;
      break;

    case OPTION_TLS_GET_ADDR_OPT:
      params.tls_get_addr_opt = 1;
      break;

    case OPTION_NO_TLS_GET_ADDR_OPT:
      params.tls_get_addr_opt = 0;
      break;

    case OPTION_TLS_GET_ADDR_REGSAVE:
      params.no_tls_get_addr_regsave = 0;
      break;

    case OPTION_NO_TLS_GET_ADDR_REGSAVE:
      params.no_tls_get_addr_regsave = 1;
      break;

    case OPTION_NO_OPD_OPT:
      no_opd_opt = 1;
      break;

    case OPTION_NO_INLINE_OPT:
      no_inline_opt = 1;
      break;

    case OPTION_NO_TOC_OPT:
      no_toc_opt = 1;
      break;

    case OPTION_NO_MULTI_TOC:
      params.no_multi_toc = 1;
      break;

    case OPTION_NO_TOC_SORT:
      no_toc_sort = 1;
      break;

    case OPTION_NON_OVERLAPPING_OPD:
      params.non_overlapping_opd = 1;
      break;

    case OPTION_TRADITIONAL_FORMAT:
      no_tls_opt = 1;
      params.tls_get_addr_opt = 0;
      no_opd_opt = 1;
      no_toc_opt = 1;
      params.no_multi_toc = 1;
      no_toc_sort = 1;
      params.plt_static_chain = 1;
      params.no_pcrel_opt = 1;
      return false;

    }

  return true;
}


static void
gldelf64lppc_list_options (FILE * file)
{
  
  fprintf (file, _("\
  -z dynamic-undefined-weak   Make undefined weak symbols dynamic\n\
  -z nodynamic-undefined-weak Do not make undefined weak symbols dynamic\n"));
 
  fprintf (file, _("\
  -z pack-relative-relocs     Pack relative relocations\n"));
  fprintf (file, _("\
  -z nopack-relative-relocs   Do not pack relative relocations (default)\n"));

  fprintf (file, _("\
  --stub-group-size=N         Maximum size of a group of input sections that\n\
                                can be handled by one stub section.  A negative\n\
                                value locates all stubs before their branches\n\
                                (with a group size of -N), while a positive\n\
                                value allows two groups of input sections, one\n\
                                before, and one after each stub section.\n\
                                Values of +/-1 indicate the linker should\n\
                                choose suitable defaults.\n"
		   ));
  fprintf (file, _("\
  --plt-static-chain          PLT call stubs should load r11 (default)\n"
		   ));
  fprintf (file, _("\
  --no-plt-static-chain       PLT call stubs should not load r11\n"
		   ));
  fprintf (file, _("\
  --plt-thread-safe           PLT call stubs with load-load barrier\n"
		   ));
  fprintf (file, _("\
  --no-plt-thread-safe        PLT call stubs without barrier\n"
		   ));
  fprintf (file, _("\
  --plt-align [=<align>]      Align PLT call stubs to fit cache lines\n"
		   ));
  fprintf (file, _("\
  --no-plt-align              Dont't align individual PLT call stubs\n"
		   ));
  fprintf (file, _("\
  --plt-localentry            Optimize calls to ELFv2 localentry:0 functions\n"
		   ));
  fprintf (file, _("\
  --no-plt-localentry         Don't optimize ELFv2 calls\n"
		   ));
  fprintf (file, _("\
  --power10-stubs [=auto]     Use Power10 PLT call stubs (default auto)\n"
		   ));
  fprintf (file, _("\
  --no-pcrel-optimize         Don't perform R_PPC64_PCREL_OPT optimization\n"
		   ));
  fprintf (file, _("\
  --no-power10-stubs          Don't use Power10 PLT call stubs\n"
		   ));
  fprintf (file, _("\
  --emit-stub-syms            Label linker stubs with a symbol\n"
		   ));
  fprintf (file, _("\
  --no-emit-stub-syms         Don't label linker stubs with a symbol\n"
		   ));
  fprintf (file, _("\
  --dotsyms                   For every version pattern \"foo\" in a version\n\
                                script, add \".foo\" so that function code\n\
                                symbols are treated the same as function\n\
                                descriptor symbols.  Defaults to on.\n"
		   ));
  fprintf (file, _("\
  --no-dotsyms                Don't do anything special in version scripts\n"
		   ));
  fprintf (file, _("\
  --save-restore-funcs        Provide register save and restore routines used\n\
                                by gcc -Os code.  Defaults to on for normal\n\
                                final link, off for ld -r.\n"
		   ));
  fprintf (file, _("\
  --no-save-restore-funcs     Don't provide these routines\n"
		   ));
  fprintf (file, _("\
  --no-tls-optimize           Don't try to optimize TLS accesses\n"
		   ));
  fprintf (file, _("\
  --tls-get-addr-optimize     Force use of special __tls_get_addr call\n"
		   ));
  fprintf (file, _("\
  --no-tls-get-addr-optimize  Don't use a special __tls_get_addr call\n"
		   ));
  fprintf (file, _("\
  --tls-get-addr-regsave      Force register save __tls_get_addr stub\n"
		   ));
  fprintf (file, _("\
  --no-tls-get-addr-regsave   Don't use register save __tls_get_addr stub\n"
		   ));
  fprintf (file, _("\
  --no-opd-optimize           Don't optimize the OPD section\n"
		   ));
  fprintf (file, _("\
  --no-inline-optimize        Don't convert inline PLT to direct calls\n"
		   ));
  fprintf (file, _("\
  --no-toc-optimize           Don't optimize the TOC section\n"
		   ));
  fprintf (file, _("\
  --no-multi-toc              Disallow automatic multiple toc sections\n"
		   ));
  fprintf (file, _("\
  --no-toc-sort               Don't sort TOC and GOT sections\n"
		   ));
  fprintf (file, _("\
  --non-overlapping-opd       Canonicalize .opd, so that there are no\n\
                                overlapping .opd entries\n"
		   ));

}

struct ld_emulation_xfer_struct ld_elf64lppc_emulation =
{
  gldelf64lppc_before_parse,
  syslib_default,
  hll_default,
  ldelf_after_parse,
  gldelf64lppc_before_plugin_all_symbols_read,
  ppc_after_open,
  after_check_relocs_default,
  ldelf_before_place_orphans,
  gldelf64lppc_after_allocation,
  ldelf_set_output_arch,
  ldemul_default_target,
  ppc_before_allocation,
  gldelf64lppc_get_script,
  "elf64lppc",
  "elf64-powerpcle",
  gldelf64lppc_finish,
  ppc_create_output_section_statements,
  ldelf_open_dynamic_archive,
  ldelf_place_orphan,
  NULL,
  NULL,
  gldelf64lppc_add_options,
  gldelf64lppc_handle_option,
  NULL,
  gldelf64lppc_list_options,
  ldelf_load_symbols,
  NULL,
  gldelf64lppc_new_vers_pattern,
  NULL,
  ldelf_emit_ctf_early,
  ldelf_acquire_strings_for_ctf,
  ldelf_new_dynsym_for_ctf,
  NULL
};
