// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A3__F24

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_32_T_F_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1102)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x1bdebf1cu, 0x0e907486u, 0, 50 }, // 1bdebf1c0e907486 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx1102
    { 0x4344d5bfu, 0x2d1f6cb5u, 366, 83 }, // 4344d5bf2d1f6cb5 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1102
    { 0xd83aecc2u, 0x34d983a4u, 366, 202 }, // d83aecc234d983a4 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1102
    { 0xa7e414ccu, 0xf33c32a9u, 366, 16 }, // a7e414ccf33c32a9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx1102
    { 0xd6eeeef9u, 0xfb442a34u, 366, 33 }, // d6eeeef9fb442a34 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1102
    { 0x9eebc5ceu, 0xcbe54a24u, 366, 50 }, // 9eebc5cecbe54a24 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx1102
    { 0xc0433452u, 0x7f5c204au, 318, 16 }, // c04334527f5c204a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1102
    { 0x439d0b3cu, 0x0f84ccd1u, 318, 167 }, // 439d0b3c0f84ccd1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1102
    { 0xea75e9e5u, 0x6b8a86f1u, 381, 83 }, // ea75e9e56b8a86f1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp2_stg1--Arch_gfx1102
    { 0x04eef24au, 0x0116eecfu, 381, 202 }, // 04eef24a0116eecf = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1102
    { 0xab0100e6u, 0xc85c10e6u, 381, 16 }, // ab0100e6c85c10e6 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp2_stg1--Arch_gfx1102
    { 0x8f91a631u, 0x3092b0f6u, 381, 116 }, // 8f91a6313092b0f6 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1102
    { 0x030d4855u, 0x2f0f9d5du, 381, 33 }, // 030d48552f0f9d5d = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave3_warp2_stg1--Arch_gfx1102
    { 0x739f0479u, 0xdb352f4eu, 381, 167 }, // 739f0479db352f4e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1102
    { 0x0dac3ffdu, 0x24193124u, 381, 50 }, // 0dac3ffd24193124 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave4_warp2_stg1--Arch_gfx1102
    { 0x568da1b8u, 0x0e7e597fu, 381, 133 }, // 568da1b80e7e597f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1102
    { 0x2276bb12u, 0x07da8a4au, 67, 83 }, // 2276bb1207da8a4a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_False__CO__wave1_warp2_stg1--Arch_gfx1102
    { 0xe21f9769u, 0xa50efe8bu, 67, 202 }, // e21f9769a50efe8b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1102
    { 0x75881193u, 0xf35e2185u, 67, 116 }, // 75881193f35e2185 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1102
    { 0x73f541f5u, 0x072b9b74u, 67, 167 }, // 73f541f5072b9b74 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1102
    { 0xe98b8b4cu, 0x2c3c67fdu, 67, 50 }, // e98b8b4c2c3c67fd = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx1102
    { 0x37bbc8feu, 0xcaa729e0u, 396, 83 }, // 37bbc8fecaa729e0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_True__CO__wave1_warp2_stg1--Arch_gfx1102
    { 0x07a22c25u, 0x33901ae8u, 396, 202 }, // 07a22c2533901ae8 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_True__CO__wave1_warp4_stg1--Arch_gfx1102
    { 0x6bd7c406u, 0xfefb2abfu, 396, 116 }, // 6bd7c406fefb2abf = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx1102
    { 0x188766eau, 0x11dc2ffbu, 396, 167 }, // 188766ea11dc2ffb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_True__CO__wave3_warp4_stg1--Arch_gfx1102
    { 0x6c086699u, 0x296c9681u, 396, 133 }, // 6c086699296c9681 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_32_T_F_0_0___gfx11xx__P__0_2_64_32_True__CO__wave4_warp4_stg1--Arch_gfx1102
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1102_mod0
{{ 2, 9, 7,13, 9, 9, 9,11,13, 9},
 {15,19,18,14,12,12,12,14, 8,14},
 { 3, 1, 6,10,12, 8, 8,10,22,23},
 { 1, 0, 5,23,25,23,22,24,24,24},
 {24, 5, 4,24,25,23,22,23,23,17},
 { 4, 3, 4, 4,24,22,25,17,17,22},
 { 1, 3, 1, 4,25,23,17,20,22,22},
 { 4, 3, 5, 1,16,16,20,22,25,22},
 {16, 1, 5, 5,16,23,20,23,22,23},
 {21, 3, 3, 4,23,22,22,22,20,20}}
// End of GPU gfx1102_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A3__F24 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 6;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 6;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 32 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = False AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

