// gpu/ipc/common/gpu_feature_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_feature_info.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_feature_info.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_feature_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/buffer_types.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {








class BLINK_PLATFORM_EXPORT GpuFeatureInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuFeatureInfo, T>::value>;
  using DataView = GpuFeatureInfoDataView;
  using Data_ = internal::GpuFeatureInfo_Data;

  template <typename... Args>
  static GpuFeatureInfoPtr New(Args&&... args) {
    return GpuFeatureInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuFeatureInfoPtr From(const U& u) {
    return mojo::TypeConverter<GpuFeatureInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuFeatureInfo>::Convert(*this);
  }


  GpuFeatureInfo();

  GpuFeatureInfo(
      WTF::Vector<GpuFeatureStatus> status_values,
      WTF::Vector<int32_t> enabled_gpu_driver_bug_workarounds,
      const WTF::String& disabled_extensions,
      const WTF::String& disabled_webgl_extensions,
      WTF::Vector<uint32_t> applied_gpu_blocklist_entries,
      WTF::Vector<uint32_t> applied_gpu_driver_bug_list_entries,
      WTF::Vector<::gfx::BufferFormat> supported_buffer_formats_for_allocation_and_texturing);


  ~GpuFeatureInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuFeatureInfoPtr>
  GpuFeatureInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuFeatureInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuFeatureInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuFeatureInfo_UnserializedMessageContext<
            UserType, GpuFeatureInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuFeatureInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuFeatureInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuFeatureInfo_UnserializedMessageContext<
            UserType, GpuFeatureInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuFeatureInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<GpuFeatureStatus> status_values;
  
  WTF::Vector<int32_t> enabled_gpu_driver_bug_workarounds;
  
  WTF::String disabled_extensions;
  
  WTF::String disabled_webgl_extensions;
  
  WTF::Vector<uint32_t> applied_gpu_blocklist_entries;
  
  WTF::Vector<uint32_t> applied_gpu_driver_bug_list_entries;
  
  WTF::Vector<::gfx::BufferFormat> supported_buffer_formats_for_allocation_and_texturing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuFeatureInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GpuFeatureInfoPtr GpuFeatureInfo::Clone() const {
  return New(
      mojo::Clone(status_values),
      mojo::Clone(enabled_gpu_driver_bug_workarounds),
      mojo::Clone(disabled_extensions),
      mojo::Clone(disabled_webgl_extensions),
      mojo::Clone(applied_gpu_blocklist_entries),
      mojo::Clone(applied_gpu_driver_bug_list_entries),
      mojo::Clone(supported_buffer_formats_for_allocation_and_texturing)
  );
}

template <typename T, GpuFeatureInfo::EnableIfSame<T>*>
bool GpuFeatureInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status_values, other_struct.status_values))
    return false;
  if (!mojo::Equals(this->enabled_gpu_driver_bug_workarounds, other_struct.enabled_gpu_driver_bug_workarounds))
    return false;
  if (!mojo::Equals(this->disabled_extensions, other_struct.disabled_extensions))
    return false;
  if (!mojo::Equals(this->disabled_webgl_extensions, other_struct.disabled_webgl_extensions))
    return false;
  if (!mojo::Equals(this->applied_gpu_blocklist_entries, other_struct.applied_gpu_blocklist_entries))
    return false;
  if (!mojo::Equals(this->applied_gpu_driver_bug_list_entries, other_struct.applied_gpu_driver_bug_list_entries))
    return false;
  if (!mojo::Equals(this->supported_buffer_formats_for_allocation_and_texturing, other_struct.supported_buffer_formats_for_allocation_and_texturing))
    return false;
  return true;
}

template <typename T, GpuFeatureInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status_values < rhs.status_values)
    return true;
  if (rhs.status_values < lhs.status_values)
    return false;
  if (lhs.enabled_gpu_driver_bug_workarounds < rhs.enabled_gpu_driver_bug_workarounds)
    return true;
  if (rhs.enabled_gpu_driver_bug_workarounds < lhs.enabled_gpu_driver_bug_workarounds)
    return false;
  if (lhs.disabled_extensions < rhs.disabled_extensions)
    return true;
  if (rhs.disabled_extensions < lhs.disabled_extensions)
    return false;
  if (lhs.disabled_webgl_extensions < rhs.disabled_webgl_extensions)
    return true;
  if (rhs.disabled_webgl_extensions < lhs.disabled_webgl_extensions)
    return false;
  if (lhs.applied_gpu_blocklist_entries < rhs.applied_gpu_blocklist_entries)
    return true;
  if (rhs.applied_gpu_blocklist_entries < lhs.applied_gpu_blocklist_entries)
    return false;
  if (lhs.applied_gpu_driver_bug_list_entries < rhs.applied_gpu_driver_bug_list_entries)
    return true;
  if (rhs.applied_gpu_driver_bug_list_entries < lhs.applied_gpu_driver_bug_list_entries)
    return false;
  if (lhs.supported_buffer_formats_for_allocation_and_texturing < rhs.supported_buffer_formats_for_allocation_and_texturing)
    return true;
  if (rhs.supported_buffer_formats_for_allocation_and_texturing < lhs.supported_buffer_formats_for_allocation_and_texturing)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::GpuFeatureInfo::DataView,
                                         ::gpu::mojom::blink::GpuFeatureInfoPtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuFeatureInfoPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::status_values)& status_values(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->status_values;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::enabled_gpu_driver_bug_workarounds)& enabled_gpu_driver_bug_workarounds(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->enabled_gpu_driver_bug_workarounds;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::disabled_extensions)& disabled_extensions(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->disabled_extensions;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::disabled_webgl_extensions)& disabled_webgl_extensions(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->disabled_webgl_extensions;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::applied_gpu_blocklist_entries)& applied_gpu_blocklist_entries(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->applied_gpu_blocklist_entries;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::applied_gpu_driver_bug_list_entries)& applied_gpu_driver_bug_list_entries(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->applied_gpu_driver_bug_list_entries;
  }

  static const decltype(::gpu::mojom::blink::GpuFeatureInfo::supported_buffer_formats_for_allocation_and_texturing)& supported_buffer_formats_for_allocation_and_texturing(
      const ::gpu::mojom::blink::GpuFeatureInfoPtr& input) {
    return input->supported_buffer_formats_for_allocation_and_texturing;
  }

  static bool Read(::gpu::mojom::blink::GpuFeatureInfo::DataView input, ::gpu::mojom::blink::GpuFeatureInfoPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_BLINK_H_