// gpu/ipc/common/vulkan_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_types.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_types.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_types.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "gpu/ipc/common/vulkan_types_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {





class GPU_EXPORT VkExtensionProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkExtensionProperties, T>::value>;
  using DataView = VkExtensionPropertiesDataView;
  using Data_ = internal::VkExtensionProperties_Data;

  template <typename... Args>
  static VkExtensionPropertiesPtr New(Args&&... args) {
    return VkExtensionPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkExtensionPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VkExtensionPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkExtensionProperties>::Convert(*this);
  }


  VkExtensionProperties();

  VkExtensionProperties(
      const std::string& extensionName,
      uint32_t specVersion);


  ~VkExtensionProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkExtensionPropertiesPtr>
  VkExtensionPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkExtensionProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkExtensionProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkExtensionProperties_UnserializedMessageContext<
            UserType, VkExtensionProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkExtensionProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkExtensionProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkExtensionProperties_UnserializedMessageContext<
            UserType, VkExtensionProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkExtensionProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string extensionName;
  
  uint32_t specVersion;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkExtensionProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT VkLayerProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkLayerProperties, T>::value>;
  using DataView = VkLayerPropertiesDataView;
  using Data_ = internal::VkLayerProperties_Data;

  template <typename... Args>
  static VkLayerPropertiesPtr New(Args&&... args) {
    return VkLayerPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkLayerPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VkLayerPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkLayerProperties>::Convert(*this);
  }


  VkLayerProperties();

  VkLayerProperties(
      const std::string& layerName,
      uint32_t specVersion,
      uint32_t implementationVersion,
      const std::string& description);


  ~VkLayerProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkLayerPropertiesPtr>
  VkLayerPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkLayerProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkLayerProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkLayerProperties_UnserializedMessageContext<
            UserType, VkLayerProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkLayerProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkLayerProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkLayerProperties_UnserializedMessageContext<
            UserType, VkLayerProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkLayerProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string layerName;
  
  uint32_t specVersion;
  
  uint32_t implementationVersion;
  
  std::string description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkLayerProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class GPU_EXPORT VkExtent3D {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkExtent3D, T>::value>;
  using DataView = VkExtent3DDataView;
  using Data_ = internal::VkExtent3D_Data;

  template <typename... Args>
  static VkExtent3DPtr New(Args&&... args) {
    return VkExtent3DPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkExtent3DPtr From(const U& u) {
    return mojo::TypeConverter<VkExtent3DPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkExtent3D>::Convert(*this);
  }


  VkExtent3D();

  VkExtent3D(
      uint32_t width,
      uint32_t height,
      uint32_t depth);


  ~VkExtent3D();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkExtent3DPtr>
  VkExtent3DPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkExtent3D::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkExtent3D::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkExtent3D_UnserializedMessageContext<
            UserType, VkExtent3D::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkExtent3D::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkExtent3D::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkExtent3D_UnserializedMessageContext<
            UserType, VkExtent3D::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkExtent3D::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t width;
  
  uint32_t height;
  
  uint32_t depth;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkExtent3D::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class GPU_EXPORT VkPhysicalDeviceLimits {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkPhysicalDeviceLimits, T>::value>;
  using DataView = VkPhysicalDeviceLimitsDataView;
  using Data_ = internal::VkPhysicalDeviceLimits_Data;

  template <typename... Args>
  static VkPhysicalDeviceLimitsPtr New(Args&&... args) {
    return VkPhysicalDeviceLimitsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkPhysicalDeviceLimitsPtr From(const U& u) {
    return mojo::TypeConverter<VkPhysicalDeviceLimitsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkPhysicalDeviceLimits>::Convert(*this);
  }


  VkPhysicalDeviceLimits();

  VkPhysicalDeviceLimits(
      uint32_t maxImageDimension1D,
      uint32_t maxImageDimension2D,
      uint32_t maxImageDimension3D,
      uint32_t maxImageDimensionCube,
      uint32_t maxImageArrayLayers,
      uint32_t maxTexelBufferElements,
      uint32_t maxUniformBufferRange,
      uint32_t maxStorageBufferRange,
      uint32_t maxPushConstantsSize,
      uint32_t maxMemoryAllocationCount,
      uint32_t maxSamplerAllocationCount,
      uint64_t bufferImageGranularity,
      uint64_t sparseAddressSpaceSize,
      uint32_t maxBoundDescriptorSets,
      uint32_t maxPerStageDescriptorSamplers,
      uint32_t maxPerStageDescriptorUniformBuffers,
      uint32_t maxPerStageDescriptorStorageBuffers,
      uint32_t maxPerStageDescriptorSampledImages,
      uint32_t maxPerStageDescriptorStorageImages,
      uint32_t maxPerStageDescriptorInputAttachments,
      uint32_t maxPerStageResources,
      uint32_t maxDescriptorSetSamplers,
      uint32_t maxDescriptorSetUniformBuffers,
      uint32_t maxDescriptorSetUniformBuffersDynamic,
      uint32_t maxDescriptorSetStorageBuffers,
      uint32_t maxDescriptorSetStorageBuffersDynamic,
      uint32_t maxDescriptorSetSampledImages,
      uint32_t maxDescriptorSetStorageImages,
      uint32_t maxDescriptorSetInputAttachments,
      uint32_t maxVertexInputAttributes,
      uint32_t maxVertexInputBindings,
      uint32_t maxVertexInputAttributeOffset,
      uint32_t maxVertexInputBindingStride,
      uint32_t maxVertexOutputComponents,
      uint32_t maxTessellationGenerationLevel,
      uint32_t maxTessellationPatchSize,
      uint32_t maxTessellationControlPerVertexInputComponents,
      uint32_t maxTessellationControlPerVertexOutputComponents,
      uint32_t maxTessellationControlPerPatchOutputComponents,
      uint32_t maxTessellationControlTotalOutputComponents,
      uint32_t maxTessellationEvaluationInputComponents,
      uint32_t maxTessellationEvaluationOutputComponents,
      uint32_t maxGeometryShaderInvocations,
      uint32_t maxGeometryInputComponents,
      uint32_t maxGeometryOutputComponents,
      uint32_t maxGeometryOutputVertices,
      uint32_t maxGeometryTotalOutputComponents,
      uint32_t maxFragmentInputComponents,
      uint32_t maxFragmentOutputAttachments,
      uint32_t maxFragmentDualSrcAttachments,
      uint32_t maxFragmentCombinedOutputResources,
      uint32_t maxComputeSharedMemorySize,
      std::vector<uint32_t> maxComputeWorkGroupCount,
      uint32_t maxComputeWorkGroupInvocations,
      std::vector<uint32_t> maxComputeWorkGroupSize,
      uint32_t subPixelPrecisionBits,
      uint32_t subTexelPrecisionBits,
      uint32_t mipmapPrecisionBits,
      uint32_t maxDrawIndexedIndexValue,
      uint32_t maxDrawIndirectCount,
      float maxSamplerLodBias,
      float maxSamplerAnisotropy,
      uint32_t maxViewports,
      std::vector<uint32_t> maxViewportDimensions,
      std::vector<float> viewportBoundsRange,
      uint32_t viewportSubPixelBits,
      uint64_t minMemoryMapAlignment,
      uint64_t minTexelBufferOffsetAlignment,
      uint64_t minUniformBufferOffsetAlignment,
      uint64_t minStorageBufferOffsetAlignment,
      int32_t minTexelOffset,
      uint32_t maxTexelOffset,
      int32_t minTexelGatherOffset,
      uint32_t maxTexelGatherOffset,
      float minInterpolationOffset,
      float maxInterpolationOffset,
      uint32_t subPixelInterpolationOffsetBits,
      uint32_t maxFramebufferWidth,
      uint32_t maxFramebufferHeight,
      uint32_t maxFramebufferLayers,
      uint32_t framebufferColorSampleCounts,
      uint32_t framebufferDepthSampleCounts,
      uint32_t framebufferStencilSampleCounts,
      uint32_t framebufferNoAttachmentsSampleCounts,
      uint32_t maxColorAttachments,
      uint32_t sampledImageColorSampleCounts,
      uint32_t sampledImageIntegerSampleCounts,
      uint32_t sampledImageDepthSampleCounts,
      uint32_t sampledImageStencilSampleCounts,
      uint32_t storageImageSampleCounts,
      uint32_t maxSampleMaskWords,
      bool timestampComputeAndGraphics,
      float timestampPeriod,
      uint32_t maxClipDistances,
      uint32_t maxCullDistances,
      uint32_t maxCombinedClipAndCullDistances,
      uint32_t discreteQueuePriorities,
      std::vector<float> pointSizeRange,
      std::vector<float> lineWidthRange,
      float pointSizeGranularity,
      float lineWidthGranularity,
      bool strictLines,
      bool standardSampleLocations,
      uint64_t optimalBufferCopyOffsetAlignment,
      uint64_t optimalBufferCopyRowPitchAlignment,
      uint64_t nonCoherentAtomSize);


  ~VkPhysicalDeviceLimits();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkPhysicalDeviceLimitsPtr>
  VkPhysicalDeviceLimitsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkPhysicalDeviceLimits::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkPhysicalDeviceLimits::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkPhysicalDeviceLimits_UnserializedMessageContext<
            UserType, VkPhysicalDeviceLimits::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceLimits::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkPhysicalDeviceLimits::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkPhysicalDeviceLimits_UnserializedMessageContext<
            UserType, VkPhysicalDeviceLimits::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceLimits::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t maxImageDimension1D;
  
  uint32_t maxImageDimension2D;
  
  uint32_t maxImageDimension3D;
  
  uint32_t maxImageDimensionCube;
  
  uint32_t maxImageArrayLayers;
  
  uint32_t maxTexelBufferElements;
  
  uint32_t maxUniformBufferRange;
  
  uint32_t maxStorageBufferRange;
  
  uint32_t maxPushConstantsSize;
  
  uint32_t maxMemoryAllocationCount;
  
  uint32_t maxSamplerAllocationCount;
  
  uint64_t bufferImageGranularity;
  
  uint64_t sparseAddressSpaceSize;
  
  uint32_t maxBoundDescriptorSets;
  
  uint32_t maxPerStageDescriptorSamplers;
  
  uint32_t maxPerStageDescriptorUniformBuffers;
  
  uint32_t maxPerStageDescriptorStorageBuffers;
  
  uint32_t maxPerStageDescriptorSampledImages;
  
  uint32_t maxPerStageDescriptorStorageImages;
  
  uint32_t maxPerStageDescriptorInputAttachments;
  
  uint32_t maxPerStageResources;
  
  uint32_t maxDescriptorSetSamplers;
  
  uint32_t maxDescriptorSetUniformBuffers;
  
  uint32_t maxDescriptorSetUniformBuffersDynamic;
  
  uint32_t maxDescriptorSetStorageBuffers;
  
  uint32_t maxDescriptorSetStorageBuffersDynamic;
  
  uint32_t maxDescriptorSetSampledImages;
  
  uint32_t maxDescriptorSetStorageImages;
  
  uint32_t maxDescriptorSetInputAttachments;
  
  uint32_t maxVertexInputAttributes;
  
  uint32_t maxVertexInputBindings;
  
  uint32_t maxVertexInputAttributeOffset;
  
  uint32_t maxVertexInputBindingStride;
  
  uint32_t maxVertexOutputComponents;
  
  uint32_t maxTessellationGenerationLevel;
  
  uint32_t maxTessellationPatchSize;
  
  uint32_t maxTessellationControlPerVertexInputComponents;
  
  uint32_t maxTessellationControlPerVertexOutputComponents;
  
  uint32_t maxTessellationControlPerPatchOutputComponents;
  
  uint32_t maxTessellationControlTotalOutputComponents;
  
  uint32_t maxTessellationEvaluationInputComponents;
  
  uint32_t maxTessellationEvaluationOutputComponents;
  
  uint32_t maxGeometryShaderInvocations;
  
  uint32_t maxGeometryInputComponents;
  
  uint32_t maxGeometryOutputComponents;
  
  uint32_t maxGeometryOutputVertices;
  
  uint32_t maxGeometryTotalOutputComponents;
  
  uint32_t maxFragmentInputComponents;
  
  uint32_t maxFragmentOutputAttachments;
  
  uint32_t maxFragmentDualSrcAttachments;
  
  uint32_t maxFragmentCombinedOutputResources;
  
  uint32_t maxComputeSharedMemorySize;
  
  std::vector<uint32_t> maxComputeWorkGroupCount;
  
  uint32_t maxComputeWorkGroupInvocations;
  
  std::vector<uint32_t> maxComputeWorkGroupSize;
  
  uint32_t subPixelPrecisionBits;
  
  uint32_t subTexelPrecisionBits;
  
  uint32_t mipmapPrecisionBits;
  
  uint32_t maxDrawIndexedIndexValue;
  
  uint32_t maxDrawIndirectCount;
  
  float maxSamplerLodBias;
  
  float maxSamplerAnisotropy;
  
  uint32_t maxViewports;
  
  std::vector<uint32_t> maxViewportDimensions;
  
  std::vector<float> viewportBoundsRange;
  
  uint32_t viewportSubPixelBits;
  
  uint64_t minMemoryMapAlignment;
  
  uint64_t minTexelBufferOffsetAlignment;
  
  uint64_t minUniformBufferOffsetAlignment;
  
  uint64_t minStorageBufferOffsetAlignment;
  
  int32_t minTexelOffset;
  
  uint32_t maxTexelOffset;
  
  int32_t minTexelGatherOffset;
  
  uint32_t maxTexelGatherOffset;
  
  float minInterpolationOffset;
  
  float maxInterpolationOffset;
  
  uint32_t subPixelInterpolationOffsetBits;
  
  uint32_t maxFramebufferWidth;
  
  uint32_t maxFramebufferHeight;
  
  uint32_t maxFramebufferLayers;
  
  uint32_t framebufferColorSampleCounts;
  
  uint32_t framebufferDepthSampleCounts;
  
  uint32_t framebufferStencilSampleCounts;
  
  uint32_t framebufferNoAttachmentsSampleCounts;
  
  uint32_t maxColorAttachments;
  
  uint32_t sampledImageColorSampleCounts;
  
  uint32_t sampledImageIntegerSampleCounts;
  
  uint32_t sampledImageDepthSampleCounts;
  
  uint32_t sampledImageStencilSampleCounts;
  
  uint32_t storageImageSampleCounts;
  
  uint32_t maxSampleMaskWords;
  
  bool timestampComputeAndGraphics;
  
  float timestampPeriod;
  
  uint32_t maxClipDistances;
  
  uint32_t maxCullDistances;
  
  uint32_t maxCombinedClipAndCullDistances;
  
  uint32_t discreteQueuePriorities;
  
  std::vector<float> pointSizeRange;
  
  std::vector<float> lineWidthRange;
  
  float pointSizeGranularity;
  
  float lineWidthGranularity;
  
  bool strictLines;
  
  bool standardSampleLocations;
  
  uint64_t optimalBufferCopyOffsetAlignment;
  
  uint64_t optimalBufferCopyRowPitchAlignment;
  
  uint64_t nonCoherentAtomSize;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT VkPhysicalDeviceSparseProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkPhysicalDeviceSparseProperties, T>::value>;
  using DataView = VkPhysicalDeviceSparsePropertiesDataView;
  using Data_ = internal::VkPhysicalDeviceSparseProperties_Data;

  template <typename... Args>
  static VkPhysicalDeviceSparsePropertiesPtr New(Args&&... args) {
    return VkPhysicalDeviceSparsePropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkPhysicalDeviceSparsePropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VkPhysicalDeviceSparsePropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkPhysicalDeviceSparseProperties>::Convert(*this);
  }


  VkPhysicalDeviceSparseProperties();

  VkPhysicalDeviceSparseProperties(
      bool residencyStandard2DBlockShape,
      bool residencyStandard2DMultisampleBlockShape,
      bool residencyStandard3DBlockShape,
      bool residencyAlignedMipSize,
      bool residencyNonResidentStrict);


  ~VkPhysicalDeviceSparseProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkPhysicalDeviceSparsePropertiesPtr>
  VkPhysicalDeviceSparsePropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkPhysicalDeviceSparseProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkPhysicalDeviceSparseProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkPhysicalDeviceSparseProperties_UnserializedMessageContext<
            UserType, VkPhysicalDeviceSparseProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceSparseProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkPhysicalDeviceSparseProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkPhysicalDeviceSparseProperties_UnserializedMessageContext<
            UserType, VkPhysicalDeviceSparseProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceSparseProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool residencyStandard2DBlockShape;
  
  bool residencyStandard2DMultisampleBlockShape;
  
  bool residencyStandard3DBlockShape;
  
  bool residencyAlignedMipSize;
  
  bool residencyNonResidentStrict;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT VkPhysicalDeviceProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkPhysicalDeviceProperties, T>::value>;
  using DataView = VkPhysicalDevicePropertiesDataView;
  using Data_ = internal::VkPhysicalDeviceProperties_Data;

  template <typename... Args>
  static VkPhysicalDevicePropertiesPtr New(Args&&... args) {
    return VkPhysicalDevicePropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkPhysicalDevicePropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VkPhysicalDevicePropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkPhysicalDeviceProperties>::Convert(*this);
  }


  VkPhysicalDeviceProperties();

  VkPhysicalDeviceProperties(
      uint32_t apiVersion,
      uint32_t driverVersion,
      uint32_t vendorID,
      uint32_t deviceID,
      ::VkPhysicalDeviceType deviceType,
      const std::string& deviceName,
      std::vector<uint8_t> pipelineCacheUUID,
      const ::VkPhysicalDeviceLimits& limits,
      const ::VkPhysicalDeviceSparseProperties& sparseProperties);


  ~VkPhysicalDeviceProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkPhysicalDevicePropertiesPtr>
  VkPhysicalDevicePropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkPhysicalDeviceProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkPhysicalDeviceProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkPhysicalDeviceProperties_UnserializedMessageContext<
            UserType, VkPhysicalDeviceProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkPhysicalDeviceProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkPhysicalDeviceProperties_UnserializedMessageContext<
            UserType, VkPhysicalDeviceProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t apiVersion;
  
  uint32_t driverVersion;
  
  uint32_t vendorID;
  
  uint32_t deviceID;
  
  ::VkPhysicalDeviceType deviceType;
  
  std::string deviceName;
  
  std::vector<uint8_t> pipelineCacheUUID;
  
  ::VkPhysicalDeviceLimits limits;
  
  ::VkPhysicalDeviceSparseProperties sparseProperties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT VkPhysicalDeviceFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkPhysicalDeviceFeatures, T>::value>;
  using DataView = VkPhysicalDeviceFeaturesDataView;
  using Data_ = internal::VkPhysicalDeviceFeatures_Data;

  template <typename... Args>
  static VkPhysicalDeviceFeaturesPtr New(Args&&... args) {
    return VkPhysicalDeviceFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkPhysicalDeviceFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<VkPhysicalDeviceFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkPhysicalDeviceFeatures>::Convert(*this);
  }


  VkPhysicalDeviceFeatures();

  VkPhysicalDeviceFeatures(
      bool robustBufferAccess,
      bool fullDrawIndexUint32,
      bool imageCubeArray,
      bool independentBlend,
      bool geometryShader,
      bool tessellationShader,
      bool sampleRateShading,
      bool dualSrcBlend,
      bool logicOp,
      bool multiDrawIndirect,
      bool drawIndirectFirstInstance,
      bool depthClamp,
      bool depthBiasClamp,
      bool fillModeNonSolid,
      bool depthBounds,
      bool wideLines,
      bool largePoints,
      bool alphaToOne,
      bool multiViewport,
      bool samplerAnisotropy,
      bool textureCompressionETC2,
      bool textureCompressionASTC_LDR,
      bool textureCompressionBC,
      bool occlusionQueryPrecise,
      bool pipelineStatisticsQuery,
      bool vertexPipelineStoresAndAtomics,
      bool fragmentStoresAndAtomics,
      bool shaderTessellationAndGeometryPointSize,
      bool shaderImageGatherExtended,
      bool shaderStorageImageExtendedFormats,
      bool shaderStorageImageMultisample,
      bool shaderStorageImageReadWithoutFormat,
      bool shaderStorageImageWriteWithoutFormat,
      bool shaderUniformBufferArrayDynamicIndexing,
      bool shaderSampledImageArrayDynamicIndexing,
      bool shaderStorageBufferArrayDynamicIndexing,
      bool shaderStorageImageArrayDynamicIndexing,
      bool shaderClipDistance,
      bool shaderCullDistance,
      bool shaderFloat64,
      bool shaderInt64,
      bool shaderInt16,
      bool shaderResourceResidency,
      bool shaderResourceMinLod,
      bool sparseBinding,
      bool sparseResidencyBuffer,
      bool sparseResidencyImage2D,
      bool sparseResidencyImage3D,
      bool sparseResidency2Samples,
      bool sparseResidency4Samples,
      bool sparseResidency8Samples,
      bool sparseResidency16Samples,
      bool sparseResidencyAliased,
      bool variableMultisampleRate,
      bool inheritedQueries);


  ~VkPhysicalDeviceFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkPhysicalDeviceFeaturesPtr>
  VkPhysicalDeviceFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkPhysicalDeviceFeatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkPhysicalDeviceFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkPhysicalDeviceFeatures_UnserializedMessageContext<
            UserType, VkPhysicalDeviceFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkPhysicalDeviceFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkPhysicalDeviceFeatures_UnserializedMessageContext<
            UserType, VkPhysicalDeviceFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkPhysicalDeviceFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool robustBufferAccess;
  
  bool fullDrawIndexUint32;
  
  bool imageCubeArray;
  
  bool independentBlend;
  
  bool geometryShader;
  
  bool tessellationShader;
  
  bool sampleRateShading;
  
  bool dualSrcBlend;
  
  bool logicOp;
  
  bool multiDrawIndirect;
  
  bool drawIndirectFirstInstance;
  
  bool depthClamp;
  
  bool depthBiasClamp;
  
  bool fillModeNonSolid;
  
  bool depthBounds;
  
  bool wideLines;
  
  bool largePoints;
  
  bool alphaToOne;
  
  bool multiViewport;
  
  bool samplerAnisotropy;
  
  bool textureCompressionETC2;
  
  bool textureCompressionASTC_LDR;
  
  bool textureCompressionBC;
  
  bool occlusionQueryPrecise;
  
  bool pipelineStatisticsQuery;
  
  bool vertexPipelineStoresAndAtomics;
  
  bool fragmentStoresAndAtomics;
  
  bool shaderTessellationAndGeometryPointSize;
  
  bool shaderImageGatherExtended;
  
  bool shaderStorageImageExtendedFormats;
  
  bool shaderStorageImageMultisample;
  
  bool shaderStorageImageReadWithoutFormat;
  
  bool shaderStorageImageWriteWithoutFormat;
  
  bool shaderUniformBufferArrayDynamicIndexing;
  
  bool shaderSampledImageArrayDynamicIndexing;
  
  bool shaderStorageBufferArrayDynamicIndexing;
  
  bool shaderStorageImageArrayDynamicIndexing;
  
  bool shaderClipDistance;
  
  bool shaderCullDistance;
  
  bool shaderFloat64;
  
  bool shaderInt64;
  
  bool shaderInt16;
  
  bool shaderResourceResidency;
  
  bool shaderResourceMinLod;
  
  bool sparseBinding;
  
  bool sparseResidencyBuffer;
  
  bool sparseResidencyImage2D;
  
  bool sparseResidencyImage3D;
  
  bool sparseResidency2Samples;
  
  bool sparseResidency4Samples;
  
  bool sparseResidency8Samples;
  
  bool sparseResidency16Samples;
  
  bool sparseResidencyAliased;
  
  bool variableMultisampleRate;
  
  bool inheritedQueries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class GPU_EXPORT VkQueueFamilyProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VkQueueFamilyProperties, T>::value>;
  using DataView = VkQueueFamilyPropertiesDataView;
  using Data_ = internal::VkQueueFamilyProperties_Data;

  template <typename... Args>
  static VkQueueFamilyPropertiesPtr New(Args&&... args) {
    return VkQueueFamilyPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VkQueueFamilyPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VkQueueFamilyPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VkQueueFamilyProperties>::Convert(*this);
  }


  VkQueueFamilyProperties();

  VkQueueFamilyProperties(
      uint32_t queueFlags,
      uint32_t queueCount,
      uint32_t timestampValidBits,
      const ::VkExtent3D& minImageTransferGranularity);


  ~VkQueueFamilyProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VkQueueFamilyPropertiesPtr>
  VkQueueFamilyPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VkQueueFamilyProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VkQueueFamilyProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VkQueueFamilyProperties_UnserializedMessageContext<
            UserType, VkQueueFamilyProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VkQueueFamilyProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VkQueueFamilyProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VkQueueFamilyProperties_UnserializedMessageContext<
            UserType, VkQueueFamilyProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VkQueueFamilyProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t queueFlags;
  
  uint32_t queueCount;
  
  uint32_t timestampValidBits;
  
  ::VkExtent3D minImageTransferGranularity;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VkQueueFamilyProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VkExtensionPropertiesPtr VkExtensionProperties::Clone() const {
  return New(
      mojo::Clone(extensionName),
      mojo::Clone(specVersion)
  );
}

template <typename T, VkExtensionProperties::EnableIfSame<T>*>
bool VkExtensionProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->extensionName, other_struct.extensionName))
    return false;
  if (!mojo::Equals(this->specVersion, other_struct.specVersion))
    return false;
  return true;
}

template <typename T, VkExtensionProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.extensionName < rhs.extensionName)
    return true;
  if (rhs.extensionName < lhs.extensionName)
    return false;
  if (lhs.specVersion < rhs.specVersion)
    return true;
  if (rhs.specVersion < lhs.specVersion)
    return false;
  return false;
}
template <typename StructPtrType>
VkLayerPropertiesPtr VkLayerProperties::Clone() const {
  return New(
      mojo::Clone(layerName),
      mojo::Clone(specVersion),
      mojo::Clone(implementationVersion),
      mojo::Clone(description)
  );
}

template <typename T, VkLayerProperties::EnableIfSame<T>*>
bool VkLayerProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layerName, other_struct.layerName))
    return false;
  if (!mojo::Equals(this->specVersion, other_struct.specVersion))
    return false;
  if (!mojo::Equals(this->implementationVersion, other_struct.implementationVersion))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, VkLayerProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layerName < rhs.layerName)
    return true;
  if (rhs.layerName < lhs.layerName)
    return false;
  if (lhs.specVersion < rhs.specVersion)
    return true;
  if (rhs.specVersion < lhs.specVersion)
    return false;
  if (lhs.implementationVersion < rhs.implementationVersion)
    return true;
  if (rhs.implementationVersion < lhs.implementationVersion)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  return false;
}
template <typename StructPtrType>
VkPhysicalDeviceLimitsPtr VkPhysicalDeviceLimits::Clone() const {
  return New(
      mojo::Clone(maxImageDimension1D),
      mojo::Clone(maxImageDimension2D),
      mojo::Clone(maxImageDimension3D),
      mojo::Clone(maxImageDimensionCube),
      mojo::Clone(maxImageArrayLayers),
      mojo::Clone(maxTexelBufferElements),
      mojo::Clone(maxUniformBufferRange),
      mojo::Clone(maxStorageBufferRange),
      mojo::Clone(maxPushConstantsSize),
      mojo::Clone(maxMemoryAllocationCount),
      mojo::Clone(maxSamplerAllocationCount),
      mojo::Clone(bufferImageGranularity),
      mojo::Clone(sparseAddressSpaceSize),
      mojo::Clone(maxBoundDescriptorSets),
      mojo::Clone(maxPerStageDescriptorSamplers),
      mojo::Clone(maxPerStageDescriptorUniformBuffers),
      mojo::Clone(maxPerStageDescriptorStorageBuffers),
      mojo::Clone(maxPerStageDescriptorSampledImages),
      mojo::Clone(maxPerStageDescriptorStorageImages),
      mojo::Clone(maxPerStageDescriptorInputAttachments),
      mojo::Clone(maxPerStageResources),
      mojo::Clone(maxDescriptorSetSamplers),
      mojo::Clone(maxDescriptorSetUniformBuffers),
      mojo::Clone(maxDescriptorSetUniformBuffersDynamic),
      mojo::Clone(maxDescriptorSetStorageBuffers),
      mojo::Clone(maxDescriptorSetStorageBuffersDynamic),
      mojo::Clone(maxDescriptorSetSampledImages),
      mojo::Clone(maxDescriptorSetStorageImages),
      mojo::Clone(maxDescriptorSetInputAttachments),
      mojo::Clone(maxVertexInputAttributes),
      mojo::Clone(maxVertexInputBindings),
      mojo::Clone(maxVertexInputAttributeOffset),
      mojo::Clone(maxVertexInputBindingStride),
      mojo::Clone(maxVertexOutputComponents),
      mojo::Clone(maxTessellationGenerationLevel),
      mojo::Clone(maxTessellationPatchSize),
      mojo::Clone(maxTessellationControlPerVertexInputComponents),
      mojo::Clone(maxTessellationControlPerVertexOutputComponents),
      mojo::Clone(maxTessellationControlPerPatchOutputComponents),
      mojo::Clone(maxTessellationControlTotalOutputComponents),
      mojo::Clone(maxTessellationEvaluationInputComponents),
      mojo::Clone(maxTessellationEvaluationOutputComponents),
      mojo::Clone(maxGeometryShaderInvocations),
      mojo::Clone(maxGeometryInputComponents),
      mojo::Clone(maxGeometryOutputComponents),
      mojo::Clone(maxGeometryOutputVertices),
      mojo::Clone(maxGeometryTotalOutputComponents),
      mojo::Clone(maxFragmentInputComponents),
      mojo::Clone(maxFragmentOutputAttachments),
      mojo::Clone(maxFragmentDualSrcAttachments),
      mojo::Clone(maxFragmentCombinedOutputResources),
      mojo::Clone(maxComputeSharedMemorySize),
      mojo::Clone(maxComputeWorkGroupCount),
      mojo::Clone(maxComputeWorkGroupInvocations),
      mojo::Clone(maxComputeWorkGroupSize),
      mojo::Clone(subPixelPrecisionBits),
      mojo::Clone(subTexelPrecisionBits),
      mojo::Clone(mipmapPrecisionBits),
      mojo::Clone(maxDrawIndexedIndexValue),
      mojo::Clone(maxDrawIndirectCount),
      mojo::Clone(maxSamplerLodBias),
      mojo::Clone(maxSamplerAnisotropy),
      mojo::Clone(maxViewports),
      mojo::Clone(maxViewportDimensions),
      mojo::Clone(viewportBoundsRange),
      mojo::Clone(viewportSubPixelBits),
      mojo::Clone(minMemoryMapAlignment),
      mojo::Clone(minTexelBufferOffsetAlignment),
      mojo::Clone(minUniformBufferOffsetAlignment),
      mojo::Clone(minStorageBufferOffsetAlignment),
      mojo::Clone(minTexelOffset),
      mojo::Clone(maxTexelOffset),
      mojo::Clone(minTexelGatherOffset),
      mojo::Clone(maxTexelGatherOffset),
      mojo::Clone(minInterpolationOffset),
      mojo::Clone(maxInterpolationOffset),
      mojo::Clone(subPixelInterpolationOffsetBits),
      mojo::Clone(maxFramebufferWidth),
      mojo::Clone(maxFramebufferHeight),
      mojo::Clone(maxFramebufferLayers),
      mojo::Clone(framebufferColorSampleCounts),
      mojo::Clone(framebufferDepthSampleCounts),
      mojo::Clone(framebufferStencilSampleCounts),
      mojo::Clone(framebufferNoAttachmentsSampleCounts),
      mojo::Clone(maxColorAttachments),
      mojo::Clone(sampledImageColorSampleCounts),
      mojo::Clone(sampledImageIntegerSampleCounts),
      mojo::Clone(sampledImageDepthSampleCounts),
      mojo::Clone(sampledImageStencilSampleCounts),
      mojo::Clone(storageImageSampleCounts),
      mojo::Clone(maxSampleMaskWords),
      mojo::Clone(timestampComputeAndGraphics),
      mojo::Clone(timestampPeriod),
      mojo::Clone(maxClipDistances),
      mojo::Clone(maxCullDistances),
      mojo::Clone(maxCombinedClipAndCullDistances),
      mojo::Clone(discreteQueuePriorities),
      mojo::Clone(pointSizeRange),
      mojo::Clone(lineWidthRange),
      mojo::Clone(pointSizeGranularity),
      mojo::Clone(lineWidthGranularity),
      mojo::Clone(strictLines),
      mojo::Clone(standardSampleLocations),
      mojo::Clone(optimalBufferCopyOffsetAlignment),
      mojo::Clone(optimalBufferCopyRowPitchAlignment),
      mojo::Clone(nonCoherentAtomSize)
  );
}

template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>*>
bool VkPhysicalDeviceLimits::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->maxImageDimension1D, other_struct.maxImageDimension1D))
    return false;
  if (!mojo::Equals(this->maxImageDimension2D, other_struct.maxImageDimension2D))
    return false;
  if (!mojo::Equals(this->maxImageDimension3D, other_struct.maxImageDimension3D))
    return false;
  if (!mojo::Equals(this->maxImageDimensionCube, other_struct.maxImageDimensionCube))
    return false;
  if (!mojo::Equals(this->maxImageArrayLayers, other_struct.maxImageArrayLayers))
    return false;
  if (!mojo::Equals(this->maxTexelBufferElements, other_struct.maxTexelBufferElements))
    return false;
  if (!mojo::Equals(this->maxUniformBufferRange, other_struct.maxUniformBufferRange))
    return false;
  if (!mojo::Equals(this->maxStorageBufferRange, other_struct.maxStorageBufferRange))
    return false;
  if (!mojo::Equals(this->maxPushConstantsSize, other_struct.maxPushConstantsSize))
    return false;
  if (!mojo::Equals(this->maxMemoryAllocationCount, other_struct.maxMemoryAllocationCount))
    return false;
  if (!mojo::Equals(this->maxSamplerAllocationCount, other_struct.maxSamplerAllocationCount))
    return false;
  if (!mojo::Equals(this->bufferImageGranularity, other_struct.bufferImageGranularity))
    return false;
  if (!mojo::Equals(this->sparseAddressSpaceSize, other_struct.sparseAddressSpaceSize))
    return false;
  if (!mojo::Equals(this->maxBoundDescriptorSets, other_struct.maxBoundDescriptorSets))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorSamplers, other_struct.maxPerStageDescriptorSamplers))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorUniformBuffers, other_struct.maxPerStageDescriptorUniformBuffers))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorStorageBuffers, other_struct.maxPerStageDescriptorStorageBuffers))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorSampledImages, other_struct.maxPerStageDescriptorSampledImages))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorStorageImages, other_struct.maxPerStageDescriptorStorageImages))
    return false;
  if (!mojo::Equals(this->maxPerStageDescriptorInputAttachments, other_struct.maxPerStageDescriptorInputAttachments))
    return false;
  if (!mojo::Equals(this->maxPerStageResources, other_struct.maxPerStageResources))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetSamplers, other_struct.maxDescriptorSetSamplers))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetUniformBuffers, other_struct.maxDescriptorSetUniformBuffers))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetUniformBuffersDynamic, other_struct.maxDescriptorSetUniformBuffersDynamic))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetStorageBuffers, other_struct.maxDescriptorSetStorageBuffers))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetStorageBuffersDynamic, other_struct.maxDescriptorSetStorageBuffersDynamic))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetSampledImages, other_struct.maxDescriptorSetSampledImages))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetStorageImages, other_struct.maxDescriptorSetStorageImages))
    return false;
  if (!mojo::Equals(this->maxDescriptorSetInputAttachments, other_struct.maxDescriptorSetInputAttachments))
    return false;
  if (!mojo::Equals(this->maxVertexInputAttributes, other_struct.maxVertexInputAttributes))
    return false;
  if (!mojo::Equals(this->maxVertexInputBindings, other_struct.maxVertexInputBindings))
    return false;
  if (!mojo::Equals(this->maxVertexInputAttributeOffset, other_struct.maxVertexInputAttributeOffset))
    return false;
  if (!mojo::Equals(this->maxVertexInputBindingStride, other_struct.maxVertexInputBindingStride))
    return false;
  if (!mojo::Equals(this->maxVertexOutputComponents, other_struct.maxVertexOutputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationGenerationLevel, other_struct.maxTessellationGenerationLevel))
    return false;
  if (!mojo::Equals(this->maxTessellationPatchSize, other_struct.maxTessellationPatchSize))
    return false;
  if (!mojo::Equals(this->maxTessellationControlPerVertexInputComponents, other_struct.maxTessellationControlPerVertexInputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationControlPerVertexOutputComponents, other_struct.maxTessellationControlPerVertexOutputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationControlPerPatchOutputComponents, other_struct.maxTessellationControlPerPatchOutputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationControlTotalOutputComponents, other_struct.maxTessellationControlTotalOutputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationEvaluationInputComponents, other_struct.maxTessellationEvaluationInputComponents))
    return false;
  if (!mojo::Equals(this->maxTessellationEvaluationOutputComponents, other_struct.maxTessellationEvaluationOutputComponents))
    return false;
  if (!mojo::Equals(this->maxGeometryShaderInvocations, other_struct.maxGeometryShaderInvocations))
    return false;
  if (!mojo::Equals(this->maxGeometryInputComponents, other_struct.maxGeometryInputComponents))
    return false;
  if (!mojo::Equals(this->maxGeometryOutputComponents, other_struct.maxGeometryOutputComponents))
    return false;
  if (!mojo::Equals(this->maxGeometryOutputVertices, other_struct.maxGeometryOutputVertices))
    return false;
  if (!mojo::Equals(this->maxGeometryTotalOutputComponents, other_struct.maxGeometryTotalOutputComponents))
    return false;
  if (!mojo::Equals(this->maxFragmentInputComponents, other_struct.maxFragmentInputComponents))
    return false;
  if (!mojo::Equals(this->maxFragmentOutputAttachments, other_struct.maxFragmentOutputAttachments))
    return false;
  if (!mojo::Equals(this->maxFragmentDualSrcAttachments, other_struct.maxFragmentDualSrcAttachments))
    return false;
  if (!mojo::Equals(this->maxFragmentCombinedOutputResources, other_struct.maxFragmentCombinedOutputResources))
    return false;
  if (!mojo::Equals(this->maxComputeSharedMemorySize, other_struct.maxComputeSharedMemorySize))
    return false;
  if (!mojo::Equals(this->maxComputeWorkGroupCount, other_struct.maxComputeWorkGroupCount))
    return false;
  if (!mojo::Equals(this->maxComputeWorkGroupInvocations, other_struct.maxComputeWorkGroupInvocations))
    return false;
  if (!mojo::Equals(this->maxComputeWorkGroupSize, other_struct.maxComputeWorkGroupSize))
    return false;
  if (!mojo::Equals(this->subPixelPrecisionBits, other_struct.subPixelPrecisionBits))
    return false;
  if (!mojo::Equals(this->subTexelPrecisionBits, other_struct.subTexelPrecisionBits))
    return false;
  if (!mojo::Equals(this->mipmapPrecisionBits, other_struct.mipmapPrecisionBits))
    return false;
  if (!mojo::Equals(this->maxDrawIndexedIndexValue, other_struct.maxDrawIndexedIndexValue))
    return false;
  if (!mojo::Equals(this->maxDrawIndirectCount, other_struct.maxDrawIndirectCount))
    return false;
  if (!mojo::Equals(this->maxSamplerLodBias, other_struct.maxSamplerLodBias))
    return false;
  if (!mojo::Equals(this->maxSamplerAnisotropy, other_struct.maxSamplerAnisotropy))
    return false;
  if (!mojo::Equals(this->maxViewports, other_struct.maxViewports))
    return false;
  if (!mojo::Equals(this->maxViewportDimensions, other_struct.maxViewportDimensions))
    return false;
  if (!mojo::Equals(this->viewportBoundsRange, other_struct.viewportBoundsRange))
    return false;
  if (!mojo::Equals(this->viewportSubPixelBits, other_struct.viewportSubPixelBits))
    return false;
  if (!mojo::Equals(this->minMemoryMapAlignment, other_struct.minMemoryMapAlignment))
    return false;
  if (!mojo::Equals(this->minTexelBufferOffsetAlignment, other_struct.minTexelBufferOffsetAlignment))
    return false;
  if (!mojo::Equals(this->minUniformBufferOffsetAlignment, other_struct.minUniformBufferOffsetAlignment))
    return false;
  if (!mojo::Equals(this->minStorageBufferOffsetAlignment, other_struct.minStorageBufferOffsetAlignment))
    return false;
  if (!mojo::Equals(this->minTexelOffset, other_struct.minTexelOffset))
    return false;
  if (!mojo::Equals(this->maxTexelOffset, other_struct.maxTexelOffset))
    return false;
  if (!mojo::Equals(this->minTexelGatherOffset, other_struct.minTexelGatherOffset))
    return false;
  if (!mojo::Equals(this->maxTexelGatherOffset, other_struct.maxTexelGatherOffset))
    return false;
  if (!mojo::Equals(this->minInterpolationOffset, other_struct.minInterpolationOffset))
    return false;
  if (!mojo::Equals(this->maxInterpolationOffset, other_struct.maxInterpolationOffset))
    return false;
  if (!mojo::Equals(this->subPixelInterpolationOffsetBits, other_struct.subPixelInterpolationOffsetBits))
    return false;
  if (!mojo::Equals(this->maxFramebufferWidth, other_struct.maxFramebufferWidth))
    return false;
  if (!mojo::Equals(this->maxFramebufferHeight, other_struct.maxFramebufferHeight))
    return false;
  if (!mojo::Equals(this->maxFramebufferLayers, other_struct.maxFramebufferLayers))
    return false;
  if (!mojo::Equals(this->framebufferColorSampleCounts, other_struct.framebufferColorSampleCounts))
    return false;
  if (!mojo::Equals(this->framebufferDepthSampleCounts, other_struct.framebufferDepthSampleCounts))
    return false;
  if (!mojo::Equals(this->framebufferStencilSampleCounts, other_struct.framebufferStencilSampleCounts))
    return false;
  if (!mojo::Equals(this->framebufferNoAttachmentsSampleCounts, other_struct.framebufferNoAttachmentsSampleCounts))
    return false;
  if (!mojo::Equals(this->maxColorAttachments, other_struct.maxColorAttachments))
    return false;
  if (!mojo::Equals(this->sampledImageColorSampleCounts, other_struct.sampledImageColorSampleCounts))
    return false;
  if (!mojo::Equals(this->sampledImageIntegerSampleCounts, other_struct.sampledImageIntegerSampleCounts))
    return false;
  if (!mojo::Equals(this->sampledImageDepthSampleCounts, other_struct.sampledImageDepthSampleCounts))
    return false;
  if (!mojo::Equals(this->sampledImageStencilSampleCounts, other_struct.sampledImageStencilSampleCounts))
    return false;
  if (!mojo::Equals(this->storageImageSampleCounts, other_struct.storageImageSampleCounts))
    return false;
  if (!mojo::Equals(this->maxSampleMaskWords, other_struct.maxSampleMaskWords))
    return false;
  if (!mojo::Equals(this->timestampComputeAndGraphics, other_struct.timestampComputeAndGraphics))
    return false;
  if (!mojo::Equals(this->timestampPeriod, other_struct.timestampPeriod))
    return false;
  if (!mojo::Equals(this->maxClipDistances, other_struct.maxClipDistances))
    return false;
  if (!mojo::Equals(this->maxCullDistances, other_struct.maxCullDistances))
    return false;
  if (!mojo::Equals(this->maxCombinedClipAndCullDistances, other_struct.maxCombinedClipAndCullDistances))
    return false;
  if (!mojo::Equals(this->discreteQueuePriorities, other_struct.discreteQueuePriorities))
    return false;
  if (!mojo::Equals(this->pointSizeRange, other_struct.pointSizeRange))
    return false;
  if (!mojo::Equals(this->lineWidthRange, other_struct.lineWidthRange))
    return false;
  if (!mojo::Equals(this->pointSizeGranularity, other_struct.pointSizeGranularity))
    return false;
  if (!mojo::Equals(this->lineWidthGranularity, other_struct.lineWidthGranularity))
    return false;
  if (!mojo::Equals(this->strictLines, other_struct.strictLines))
    return false;
  if (!mojo::Equals(this->standardSampleLocations, other_struct.standardSampleLocations))
    return false;
  if (!mojo::Equals(this->optimalBufferCopyOffsetAlignment, other_struct.optimalBufferCopyOffsetAlignment))
    return false;
  if (!mojo::Equals(this->optimalBufferCopyRowPitchAlignment, other_struct.optimalBufferCopyRowPitchAlignment))
    return false;
  if (!mojo::Equals(this->nonCoherentAtomSize, other_struct.nonCoherentAtomSize))
    return false;
  return true;
}

template <typename T, VkPhysicalDeviceLimits::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.maxImageDimension1D < rhs.maxImageDimension1D)
    return true;
  if (rhs.maxImageDimension1D < lhs.maxImageDimension1D)
    return false;
  if (lhs.maxImageDimension2D < rhs.maxImageDimension2D)
    return true;
  if (rhs.maxImageDimension2D < lhs.maxImageDimension2D)
    return false;
  if (lhs.maxImageDimension3D < rhs.maxImageDimension3D)
    return true;
  if (rhs.maxImageDimension3D < lhs.maxImageDimension3D)
    return false;
  if (lhs.maxImageDimensionCube < rhs.maxImageDimensionCube)
    return true;
  if (rhs.maxImageDimensionCube < lhs.maxImageDimensionCube)
    return false;
  if (lhs.maxImageArrayLayers < rhs.maxImageArrayLayers)
    return true;
  if (rhs.maxImageArrayLayers < lhs.maxImageArrayLayers)
    return false;
  if (lhs.maxTexelBufferElements < rhs.maxTexelBufferElements)
    return true;
  if (rhs.maxTexelBufferElements < lhs.maxTexelBufferElements)
    return false;
  if (lhs.maxUniformBufferRange < rhs.maxUniformBufferRange)
    return true;
  if (rhs.maxUniformBufferRange < lhs.maxUniformBufferRange)
    return false;
  if (lhs.maxStorageBufferRange < rhs.maxStorageBufferRange)
    return true;
  if (rhs.maxStorageBufferRange < lhs.maxStorageBufferRange)
    return false;
  if (lhs.maxPushConstantsSize < rhs.maxPushConstantsSize)
    return true;
  if (rhs.maxPushConstantsSize < lhs.maxPushConstantsSize)
    return false;
  if (lhs.maxMemoryAllocationCount < rhs.maxMemoryAllocationCount)
    return true;
  if (rhs.maxMemoryAllocationCount < lhs.maxMemoryAllocationCount)
    return false;
  if (lhs.maxSamplerAllocationCount < rhs.maxSamplerAllocationCount)
    return true;
  if (rhs.maxSamplerAllocationCount < lhs.maxSamplerAllocationCount)
    return false;
  if (lhs.bufferImageGranularity < rhs.bufferImageGranularity)
    return true;
  if (rhs.bufferImageGranularity < lhs.bufferImageGranularity)
    return false;
  if (lhs.sparseAddressSpaceSize < rhs.sparseAddressSpaceSize)
    return true;
  if (rhs.sparseAddressSpaceSize < lhs.sparseAddressSpaceSize)
    return false;
  if (lhs.maxBoundDescriptorSets < rhs.maxBoundDescriptorSets)
    return true;
  if (rhs.maxBoundDescriptorSets < lhs.maxBoundDescriptorSets)
    return false;
  if (lhs.maxPerStageDescriptorSamplers < rhs.maxPerStageDescriptorSamplers)
    return true;
  if (rhs.maxPerStageDescriptorSamplers < lhs.maxPerStageDescriptorSamplers)
    return false;
  if (lhs.maxPerStageDescriptorUniformBuffers < rhs.maxPerStageDescriptorUniformBuffers)
    return true;
  if (rhs.maxPerStageDescriptorUniformBuffers < lhs.maxPerStageDescriptorUniformBuffers)
    return false;
  if (lhs.maxPerStageDescriptorStorageBuffers < rhs.maxPerStageDescriptorStorageBuffers)
    return true;
  if (rhs.maxPerStageDescriptorStorageBuffers < lhs.maxPerStageDescriptorStorageBuffers)
    return false;
  if (lhs.maxPerStageDescriptorSampledImages < rhs.maxPerStageDescriptorSampledImages)
    return true;
  if (rhs.maxPerStageDescriptorSampledImages < lhs.maxPerStageDescriptorSampledImages)
    return false;
  if (lhs.maxPerStageDescriptorStorageImages < rhs.maxPerStageDescriptorStorageImages)
    return true;
  if (rhs.maxPerStageDescriptorStorageImages < lhs.maxPerStageDescriptorStorageImages)
    return false;
  if (lhs.maxPerStageDescriptorInputAttachments < rhs.maxPerStageDescriptorInputAttachments)
    return true;
  if (rhs.maxPerStageDescriptorInputAttachments < lhs.maxPerStageDescriptorInputAttachments)
    return false;
  if (lhs.maxPerStageResources < rhs.maxPerStageResources)
    return true;
  if (rhs.maxPerStageResources < lhs.maxPerStageResources)
    return false;
  if (lhs.maxDescriptorSetSamplers < rhs.maxDescriptorSetSamplers)
    return true;
  if (rhs.maxDescriptorSetSamplers < lhs.maxDescriptorSetSamplers)
    return false;
  if (lhs.maxDescriptorSetUniformBuffers < rhs.maxDescriptorSetUniformBuffers)
    return true;
  if (rhs.maxDescriptorSetUniformBuffers < lhs.maxDescriptorSetUniformBuffers)
    return false;
  if (lhs.maxDescriptorSetUniformBuffersDynamic < rhs.maxDescriptorSetUniformBuffersDynamic)
    return true;
  if (rhs.maxDescriptorSetUniformBuffersDynamic < lhs.maxDescriptorSetUniformBuffersDynamic)
    return false;
  if (lhs.maxDescriptorSetStorageBuffers < rhs.maxDescriptorSetStorageBuffers)
    return true;
  if (rhs.maxDescriptorSetStorageBuffers < lhs.maxDescriptorSetStorageBuffers)
    return false;
  if (lhs.maxDescriptorSetStorageBuffersDynamic < rhs.maxDescriptorSetStorageBuffersDynamic)
    return true;
  if (rhs.maxDescriptorSetStorageBuffersDynamic < lhs.maxDescriptorSetStorageBuffersDynamic)
    return false;
  if (lhs.maxDescriptorSetSampledImages < rhs.maxDescriptorSetSampledImages)
    return true;
  if (rhs.maxDescriptorSetSampledImages < lhs.maxDescriptorSetSampledImages)
    return false;
  if (lhs.maxDescriptorSetStorageImages < rhs.maxDescriptorSetStorageImages)
    return true;
  if (rhs.maxDescriptorSetStorageImages < lhs.maxDescriptorSetStorageImages)
    return false;
  if (lhs.maxDescriptorSetInputAttachments < rhs.maxDescriptorSetInputAttachments)
    return true;
  if (rhs.maxDescriptorSetInputAttachments < lhs.maxDescriptorSetInputAttachments)
    return false;
  if (lhs.maxVertexInputAttributes < rhs.maxVertexInputAttributes)
    return true;
  if (rhs.maxVertexInputAttributes < lhs.maxVertexInputAttributes)
    return false;
  if (lhs.maxVertexInputBindings < rhs.maxVertexInputBindings)
    return true;
  if (rhs.maxVertexInputBindings < lhs.maxVertexInputBindings)
    return false;
  if (lhs.maxVertexInputAttributeOffset < rhs.maxVertexInputAttributeOffset)
    return true;
  if (rhs.maxVertexInputAttributeOffset < lhs.maxVertexInputAttributeOffset)
    return false;
  if (lhs.maxVertexInputBindingStride < rhs.maxVertexInputBindingStride)
    return true;
  if (rhs.maxVertexInputBindingStride < lhs.maxVertexInputBindingStride)
    return false;
  if (lhs.maxVertexOutputComponents < rhs.maxVertexOutputComponents)
    return true;
  if (rhs.maxVertexOutputComponents < lhs.maxVertexOutputComponents)
    return false;
  if (lhs.maxTessellationGenerationLevel < rhs.maxTessellationGenerationLevel)
    return true;
  if (rhs.maxTessellationGenerationLevel < lhs.maxTessellationGenerationLevel)
    return false;
  if (lhs.maxTessellationPatchSize < rhs.maxTessellationPatchSize)
    return true;
  if (rhs.maxTessellationPatchSize < lhs.maxTessellationPatchSize)
    return false;
  if (lhs.maxTessellationControlPerVertexInputComponents < rhs.maxTessellationControlPerVertexInputComponents)
    return true;
  if (rhs.maxTessellationControlPerVertexInputComponents < lhs.maxTessellationControlPerVertexInputComponents)
    return false;
  if (lhs.maxTessellationControlPerVertexOutputComponents < rhs.maxTessellationControlPerVertexOutputComponents)
    return true;
  if (rhs.maxTessellationControlPerVertexOutputComponents < lhs.maxTessellationControlPerVertexOutputComponents)
    return false;
  if (lhs.maxTessellationControlPerPatchOutputComponents < rhs.maxTessellationControlPerPatchOutputComponents)
    return true;
  if (rhs.maxTessellationControlPerPatchOutputComponents < lhs.maxTessellationControlPerPatchOutputComponents)
    return false;
  if (lhs.maxTessellationControlTotalOutputComponents < rhs.maxTessellationControlTotalOutputComponents)
    return true;
  if (rhs.maxTessellationControlTotalOutputComponents < lhs.maxTessellationControlTotalOutputComponents)
    return false;
  if (lhs.maxTessellationEvaluationInputComponents < rhs.maxTessellationEvaluationInputComponents)
    return true;
  if (rhs.maxTessellationEvaluationInputComponents < lhs.maxTessellationEvaluationInputComponents)
    return false;
  if (lhs.maxTessellationEvaluationOutputComponents < rhs.maxTessellationEvaluationOutputComponents)
    return true;
  if (rhs.maxTessellationEvaluationOutputComponents < lhs.maxTessellationEvaluationOutputComponents)
    return false;
  if (lhs.maxGeometryShaderInvocations < rhs.maxGeometryShaderInvocations)
    return true;
  if (rhs.maxGeometryShaderInvocations < lhs.maxGeometryShaderInvocations)
    return false;
  if (lhs.maxGeometryInputComponents < rhs.maxGeometryInputComponents)
    return true;
  if (rhs.maxGeometryInputComponents < lhs.maxGeometryInputComponents)
    return false;
  if (lhs.maxGeometryOutputComponents < rhs.maxGeometryOutputComponents)
    return true;
  if (rhs.maxGeometryOutputComponents < lhs.maxGeometryOutputComponents)
    return false;
  if (lhs.maxGeometryOutputVertices < rhs.maxGeometryOutputVertices)
    return true;
  if (rhs.maxGeometryOutputVertices < lhs.maxGeometryOutputVertices)
    return false;
  if (lhs.maxGeometryTotalOutputComponents < rhs.maxGeometryTotalOutputComponents)
    return true;
  if (rhs.maxGeometryTotalOutputComponents < lhs.maxGeometryTotalOutputComponents)
    return false;
  if (lhs.maxFragmentInputComponents < rhs.maxFragmentInputComponents)
    return true;
  if (rhs.maxFragmentInputComponents < lhs.maxFragmentInputComponents)
    return false;
  if (lhs.maxFragmentOutputAttachments < rhs.maxFragmentOutputAttachments)
    return true;
  if (rhs.maxFragmentOutputAttachments < lhs.maxFragmentOutputAttachments)
    return false;
  if (lhs.maxFragmentDualSrcAttachments < rhs.maxFragmentDualSrcAttachments)
    return true;
  if (rhs.maxFragmentDualSrcAttachments < lhs.maxFragmentDualSrcAttachments)
    return false;
  if (lhs.maxFragmentCombinedOutputResources < rhs.maxFragmentCombinedOutputResources)
    return true;
  if (rhs.maxFragmentCombinedOutputResources < lhs.maxFragmentCombinedOutputResources)
    return false;
  if (lhs.maxComputeSharedMemorySize < rhs.maxComputeSharedMemorySize)
    return true;
  if (rhs.maxComputeSharedMemorySize < lhs.maxComputeSharedMemorySize)
    return false;
  if (lhs.maxComputeWorkGroupCount < rhs.maxComputeWorkGroupCount)
    return true;
  if (rhs.maxComputeWorkGroupCount < lhs.maxComputeWorkGroupCount)
    return false;
  if (lhs.maxComputeWorkGroupInvocations < rhs.maxComputeWorkGroupInvocations)
    return true;
  if (rhs.maxComputeWorkGroupInvocations < lhs.maxComputeWorkGroupInvocations)
    return false;
  if (lhs.maxComputeWorkGroupSize < rhs.maxComputeWorkGroupSize)
    return true;
  if (rhs.maxComputeWorkGroupSize < lhs.maxComputeWorkGroupSize)
    return false;
  if (lhs.subPixelPrecisionBits < rhs.subPixelPrecisionBits)
    return true;
  if (rhs.subPixelPrecisionBits < lhs.subPixelPrecisionBits)
    return false;
  if (lhs.subTexelPrecisionBits < rhs.subTexelPrecisionBits)
    return true;
  if (rhs.subTexelPrecisionBits < lhs.subTexelPrecisionBits)
    return false;
  if (lhs.mipmapPrecisionBits < rhs.mipmapPrecisionBits)
    return true;
  if (rhs.mipmapPrecisionBits < lhs.mipmapPrecisionBits)
    return false;
  if (lhs.maxDrawIndexedIndexValue < rhs.maxDrawIndexedIndexValue)
    return true;
  if (rhs.maxDrawIndexedIndexValue < lhs.maxDrawIndexedIndexValue)
    return false;
  if (lhs.maxDrawIndirectCount < rhs.maxDrawIndirectCount)
    return true;
  if (rhs.maxDrawIndirectCount < lhs.maxDrawIndirectCount)
    return false;
  if (lhs.maxSamplerLodBias < rhs.maxSamplerLodBias)
    return true;
  if (rhs.maxSamplerLodBias < lhs.maxSamplerLodBias)
    return false;
  if (lhs.maxSamplerAnisotropy < rhs.maxSamplerAnisotropy)
    return true;
  if (rhs.maxSamplerAnisotropy < lhs.maxSamplerAnisotropy)
    return false;
  if (lhs.maxViewports < rhs.maxViewports)
    return true;
  if (rhs.maxViewports < lhs.maxViewports)
    return false;
  if (lhs.maxViewportDimensions < rhs.maxViewportDimensions)
    return true;
  if (rhs.maxViewportDimensions < lhs.maxViewportDimensions)
    return false;
  if (lhs.viewportBoundsRange < rhs.viewportBoundsRange)
    return true;
  if (rhs.viewportBoundsRange < lhs.viewportBoundsRange)
    return false;
  if (lhs.viewportSubPixelBits < rhs.viewportSubPixelBits)
    return true;
  if (rhs.viewportSubPixelBits < lhs.viewportSubPixelBits)
    return false;
  if (lhs.minMemoryMapAlignment < rhs.minMemoryMapAlignment)
    return true;
  if (rhs.minMemoryMapAlignment < lhs.minMemoryMapAlignment)
    return false;
  if (lhs.minTexelBufferOffsetAlignment < rhs.minTexelBufferOffsetAlignment)
    return true;
  if (rhs.minTexelBufferOffsetAlignment < lhs.minTexelBufferOffsetAlignment)
    return false;
  if (lhs.minUniformBufferOffsetAlignment < rhs.minUniformBufferOffsetAlignment)
    return true;
  if (rhs.minUniformBufferOffsetAlignment < lhs.minUniformBufferOffsetAlignment)
    return false;
  if (lhs.minStorageBufferOffsetAlignment < rhs.minStorageBufferOffsetAlignment)
    return true;
  if (rhs.minStorageBufferOffsetAlignment < lhs.minStorageBufferOffsetAlignment)
    return false;
  if (lhs.minTexelOffset < rhs.minTexelOffset)
    return true;
  if (rhs.minTexelOffset < lhs.minTexelOffset)
    return false;
  if (lhs.maxTexelOffset < rhs.maxTexelOffset)
    return true;
  if (rhs.maxTexelOffset < lhs.maxTexelOffset)
    return false;
  if (lhs.minTexelGatherOffset < rhs.minTexelGatherOffset)
    return true;
  if (rhs.minTexelGatherOffset < lhs.minTexelGatherOffset)
    return false;
  if (lhs.maxTexelGatherOffset < rhs.maxTexelGatherOffset)
    return true;
  if (rhs.maxTexelGatherOffset < lhs.maxTexelGatherOffset)
    return false;
  if (lhs.minInterpolationOffset < rhs.minInterpolationOffset)
    return true;
  if (rhs.minInterpolationOffset < lhs.minInterpolationOffset)
    return false;
  if (lhs.maxInterpolationOffset < rhs.maxInterpolationOffset)
    return true;
  if (rhs.maxInterpolationOffset < lhs.maxInterpolationOffset)
    return false;
  if (lhs.subPixelInterpolationOffsetBits < rhs.subPixelInterpolationOffsetBits)
    return true;
  if (rhs.subPixelInterpolationOffsetBits < lhs.subPixelInterpolationOffsetBits)
    return false;
  if (lhs.maxFramebufferWidth < rhs.maxFramebufferWidth)
    return true;
  if (rhs.maxFramebufferWidth < lhs.maxFramebufferWidth)
    return false;
  if (lhs.maxFramebufferHeight < rhs.maxFramebufferHeight)
    return true;
  if (rhs.maxFramebufferHeight < lhs.maxFramebufferHeight)
    return false;
  if (lhs.maxFramebufferLayers < rhs.maxFramebufferLayers)
    return true;
  if (rhs.maxFramebufferLayers < lhs.maxFramebufferLayers)
    return false;
  if (lhs.framebufferColorSampleCounts < rhs.framebufferColorSampleCounts)
    return true;
  if (rhs.framebufferColorSampleCounts < lhs.framebufferColorSampleCounts)
    return false;
  if (lhs.framebufferDepthSampleCounts < rhs.framebufferDepthSampleCounts)
    return true;
  if (rhs.framebufferDepthSampleCounts < lhs.framebufferDepthSampleCounts)
    return false;
  if (lhs.framebufferStencilSampleCounts < rhs.framebufferStencilSampleCounts)
    return true;
  if (rhs.framebufferStencilSampleCounts < lhs.framebufferStencilSampleCounts)
    return false;
  if (lhs.framebufferNoAttachmentsSampleCounts < rhs.framebufferNoAttachmentsSampleCounts)
    return true;
  if (rhs.framebufferNoAttachmentsSampleCounts < lhs.framebufferNoAttachmentsSampleCounts)
    return false;
  if (lhs.maxColorAttachments < rhs.maxColorAttachments)
    return true;
  if (rhs.maxColorAttachments < lhs.maxColorAttachments)
    return false;
  if (lhs.sampledImageColorSampleCounts < rhs.sampledImageColorSampleCounts)
    return true;
  if (rhs.sampledImageColorSampleCounts < lhs.sampledImageColorSampleCounts)
    return false;
  if (lhs.sampledImageIntegerSampleCounts < rhs.sampledImageIntegerSampleCounts)
    return true;
  if (rhs.sampledImageIntegerSampleCounts < lhs.sampledImageIntegerSampleCounts)
    return false;
  if (lhs.sampledImageDepthSampleCounts < rhs.sampledImageDepthSampleCounts)
    return true;
  if (rhs.sampledImageDepthSampleCounts < lhs.sampledImageDepthSampleCounts)
    return false;
  if (lhs.sampledImageStencilSampleCounts < rhs.sampledImageStencilSampleCounts)
    return true;
  if (rhs.sampledImageStencilSampleCounts < lhs.sampledImageStencilSampleCounts)
    return false;
  if (lhs.storageImageSampleCounts < rhs.storageImageSampleCounts)
    return true;
  if (rhs.storageImageSampleCounts < lhs.storageImageSampleCounts)
    return false;
  if (lhs.maxSampleMaskWords < rhs.maxSampleMaskWords)
    return true;
  if (rhs.maxSampleMaskWords < lhs.maxSampleMaskWords)
    return false;
  if (lhs.timestampComputeAndGraphics < rhs.timestampComputeAndGraphics)
    return true;
  if (rhs.timestampComputeAndGraphics < lhs.timestampComputeAndGraphics)
    return false;
  if (lhs.timestampPeriod < rhs.timestampPeriod)
    return true;
  if (rhs.timestampPeriod < lhs.timestampPeriod)
    return false;
  if (lhs.maxClipDistances < rhs.maxClipDistances)
    return true;
  if (rhs.maxClipDistances < lhs.maxClipDistances)
    return false;
  if (lhs.maxCullDistances < rhs.maxCullDistances)
    return true;
  if (rhs.maxCullDistances < lhs.maxCullDistances)
    return false;
  if (lhs.maxCombinedClipAndCullDistances < rhs.maxCombinedClipAndCullDistances)
    return true;
  if (rhs.maxCombinedClipAndCullDistances < lhs.maxCombinedClipAndCullDistances)
    return false;
  if (lhs.discreteQueuePriorities < rhs.discreteQueuePriorities)
    return true;
  if (rhs.discreteQueuePriorities < lhs.discreteQueuePriorities)
    return false;
  if (lhs.pointSizeRange < rhs.pointSizeRange)
    return true;
  if (rhs.pointSizeRange < lhs.pointSizeRange)
    return false;
  if (lhs.lineWidthRange < rhs.lineWidthRange)
    return true;
  if (rhs.lineWidthRange < lhs.lineWidthRange)
    return false;
  if (lhs.pointSizeGranularity < rhs.pointSizeGranularity)
    return true;
  if (rhs.pointSizeGranularity < lhs.pointSizeGranularity)
    return false;
  if (lhs.lineWidthGranularity < rhs.lineWidthGranularity)
    return true;
  if (rhs.lineWidthGranularity < lhs.lineWidthGranularity)
    return false;
  if (lhs.strictLines < rhs.strictLines)
    return true;
  if (rhs.strictLines < lhs.strictLines)
    return false;
  if (lhs.standardSampleLocations < rhs.standardSampleLocations)
    return true;
  if (rhs.standardSampleLocations < lhs.standardSampleLocations)
    return false;
  if (lhs.optimalBufferCopyOffsetAlignment < rhs.optimalBufferCopyOffsetAlignment)
    return true;
  if (rhs.optimalBufferCopyOffsetAlignment < lhs.optimalBufferCopyOffsetAlignment)
    return false;
  if (lhs.optimalBufferCopyRowPitchAlignment < rhs.optimalBufferCopyRowPitchAlignment)
    return true;
  if (rhs.optimalBufferCopyRowPitchAlignment < lhs.optimalBufferCopyRowPitchAlignment)
    return false;
  if (lhs.nonCoherentAtomSize < rhs.nonCoherentAtomSize)
    return true;
  if (rhs.nonCoherentAtomSize < lhs.nonCoherentAtomSize)
    return false;
  return false;
}
template <typename StructPtrType>
VkPhysicalDeviceSparsePropertiesPtr VkPhysicalDeviceSparseProperties::Clone() const {
  return New(
      mojo::Clone(residencyStandard2DBlockShape),
      mojo::Clone(residencyStandard2DMultisampleBlockShape),
      mojo::Clone(residencyStandard3DBlockShape),
      mojo::Clone(residencyAlignedMipSize),
      mojo::Clone(residencyNonResidentStrict)
  );
}

template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>*>
bool VkPhysicalDeviceSparseProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->residencyStandard2DBlockShape, other_struct.residencyStandard2DBlockShape))
    return false;
  if (!mojo::Equals(this->residencyStandard2DMultisampleBlockShape, other_struct.residencyStandard2DMultisampleBlockShape))
    return false;
  if (!mojo::Equals(this->residencyStandard3DBlockShape, other_struct.residencyStandard3DBlockShape))
    return false;
  if (!mojo::Equals(this->residencyAlignedMipSize, other_struct.residencyAlignedMipSize))
    return false;
  if (!mojo::Equals(this->residencyNonResidentStrict, other_struct.residencyNonResidentStrict))
    return false;
  return true;
}

template <typename T, VkPhysicalDeviceSparseProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.residencyStandard2DBlockShape < rhs.residencyStandard2DBlockShape)
    return true;
  if (rhs.residencyStandard2DBlockShape < lhs.residencyStandard2DBlockShape)
    return false;
  if (lhs.residencyStandard2DMultisampleBlockShape < rhs.residencyStandard2DMultisampleBlockShape)
    return true;
  if (rhs.residencyStandard2DMultisampleBlockShape < lhs.residencyStandard2DMultisampleBlockShape)
    return false;
  if (lhs.residencyStandard3DBlockShape < rhs.residencyStandard3DBlockShape)
    return true;
  if (rhs.residencyStandard3DBlockShape < lhs.residencyStandard3DBlockShape)
    return false;
  if (lhs.residencyAlignedMipSize < rhs.residencyAlignedMipSize)
    return true;
  if (rhs.residencyAlignedMipSize < lhs.residencyAlignedMipSize)
    return false;
  if (lhs.residencyNonResidentStrict < rhs.residencyNonResidentStrict)
    return true;
  if (rhs.residencyNonResidentStrict < lhs.residencyNonResidentStrict)
    return false;
  return false;
}
template <typename StructPtrType>
VkPhysicalDevicePropertiesPtr VkPhysicalDeviceProperties::Clone() const {
  return New(
      mojo::Clone(apiVersion),
      mojo::Clone(driverVersion),
      mojo::Clone(vendorID),
      mojo::Clone(deviceID),
      mojo::Clone(deviceType),
      mojo::Clone(deviceName),
      mojo::Clone(pipelineCacheUUID),
      mojo::Clone(limits),
      mojo::Clone(sparseProperties)
  );
}

template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>*>
bool VkPhysicalDeviceProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->apiVersion, other_struct.apiVersion))
    return false;
  if (!mojo::Equals(this->driverVersion, other_struct.driverVersion))
    return false;
  if (!mojo::Equals(this->vendorID, other_struct.vendorID))
    return false;
  if (!mojo::Equals(this->deviceID, other_struct.deviceID))
    return false;
  if (!mojo::Equals(this->deviceType, other_struct.deviceType))
    return false;
  if (!mojo::Equals(this->deviceName, other_struct.deviceName))
    return false;
  if (!mojo::Equals(this->pipelineCacheUUID, other_struct.pipelineCacheUUID))
    return false;
  if (!mojo::Equals(this->limits, other_struct.limits))
    return false;
  if (!mojo::Equals(this->sparseProperties, other_struct.sparseProperties))
    return false;
  return true;
}

template <typename T, VkPhysicalDeviceProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.apiVersion < rhs.apiVersion)
    return true;
  if (rhs.apiVersion < lhs.apiVersion)
    return false;
  if (lhs.driverVersion < rhs.driverVersion)
    return true;
  if (rhs.driverVersion < lhs.driverVersion)
    return false;
  if (lhs.vendorID < rhs.vendorID)
    return true;
  if (rhs.vendorID < lhs.vendorID)
    return false;
  if (lhs.deviceID < rhs.deviceID)
    return true;
  if (rhs.deviceID < lhs.deviceID)
    return false;
  if (lhs.deviceType < rhs.deviceType)
    return true;
  if (rhs.deviceType < lhs.deviceType)
    return false;
  if (lhs.deviceName < rhs.deviceName)
    return true;
  if (rhs.deviceName < lhs.deviceName)
    return false;
  if (lhs.pipelineCacheUUID < rhs.pipelineCacheUUID)
    return true;
  if (rhs.pipelineCacheUUID < lhs.pipelineCacheUUID)
    return false;
  if (lhs.limits < rhs.limits)
    return true;
  if (rhs.limits < lhs.limits)
    return false;
  if (lhs.sparseProperties < rhs.sparseProperties)
    return true;
  if (rhs.sparseProperties < lhs.sparseProperties)
    return false;
  return false;
}
template <typename StructPtrType>
VkPhysicalDeviceFeaturesPtr VkPhysicalDeviceFeatures::Clone() const {
  return New(
      mojo::Clone(robustBufferAccess),
      mojo::Clone(fullDrawIndexUint32),
      mojo::Clone(imageCubeArray),
      mojo::Clone(independentBlend),
      mojo::Clone(geometryShader),
      mojo::Clone(tessellationShader),
      mojo::Clone(sampleRateShading),
      mojo::Clone(dualSrcBlend),
      mojo::Clone(logicOp),
      mojo::Clone(multiDrawIndirect),
      mojo::Clone(drawIndirectFirstInstance),
      mojo::Clone(depthClamp),
      mojo::Clone(depthBiasClamp),
      mojo::Clone(fillModeNonSolid),
      mojo::Clone(depthBounds),
      mojo::Clone(wideLines),
      mojo::Clone(largePoints),
      mojo::Clone(alphaToOne),
      mojo::Clone(multiViewport),
      mojo::Clone(samplerAnisotropy),
      mojo::Clone(textureCompressionETC2),
      mojo::Clone(textureCompressionASTC_LDR),
      mojo::Clone(textureCompressionBC),
      mojo::Clone(occlusionQueryPrecise),
      mojo::Clone(pipelineStatisticsQuery),
      mojo::Clone(vertexPipelineStoresAndAtomics),
      mojo::Clone(fragmentStoresAndAtomics),
      mojo::Clone(shaderTessellationAndGeometryPointSize),
      mojo::Clone(shaderImageGatherExtended),
      mojo::Clone(shaderStorageImageExtendedFormats),
      mojo::Clone(shaderStorageImageMultisample),
      mojo::Clone(shaderStorageImageReadWithoutFormat),
      mojo::Clone(shaderStorageImageWriteWithoutFormat),
      mojo::Clone(shaderUniformBufferArrayDynamicIndexing),
      mojo::Clone(shaderSampledImageArrayDynamicIndexing),
      mojo::Clone(shaderStorageBufferArrayDynamicIndexing),
      mojo::Clone(shaderStorageImageArrayDynamicIndexing),
      mojo::Clone(shaderClipDistance),
      mojo::Clone(shaderCullDistance),
      mojo::Clone(shaderFloat64),
      mojo::Clone(shaderInt64),
      mojo::Clone(shaderInt16),
      mojo::Clone(shaderResourceResidency),
      mojo::Clone(shaderResourceMinLod),
      mojo::Clone(sparseBinding),
      mojo::Clone(sparseResidencyBuffer),
      mojo::Clone(sparseResidencyImage2D),
      mojo::Clone(sparseResidencyImage3D),
      mojo::Clone(sparseResidency2Samples),
      mojo::Clone(sparseResidency4Samples),
      mojo::Clone(sparseResidency8Samples),
      mojo::Clone(sparseResidency16Samples),
      mojo::Clone(sparseResidencyAliased),
      mojo::Clone(variableMultisampleRate),
      mojo::Clone(inheritedQueries)
  );
}

template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>*>
bool VkPhysicalDeviceFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->robustBufferAccess, other_struct.robustBufferAccess))
    return false;
  if (!mojo::Equals(this->fullDrawIndexUint32, other_struct.fullDrawIndexUint32))
    return false;
  if (!mojo::Equals(this->imageCubeArray, other_struct.imageCubeArray))
    return false;
  if (!mojo::Equals(this->independentBlend, other_struct.independentBlend))
    return false;
  if (!mojo::Equals(this->geometryShader, other_struct.geometryShader))
    return false;
  if (!mojo::Equals(this->tessellationShader, other_struct.tessellationShader))
    return false;
  if (!mojo::Equals(this->sampleRateShading, other_struct.sampleRateShading))
    return false;
  if (!mojo::Equals(this->dualSrcBlend, other_struct.dualSrcBlend))
    return false;
  if (!mojo::Equals(this->logicOp, other_struct.logicOp))
    return false;
  if (!mojo::Equals(this->multiDrawIndirect, other_struct.multiDrawIndirect))
    return false;
  if (!mojo::Equals(this->drawIndirectFirstInstance, other_struct.drawIndirectFirstInstance))
    return false;
  if (!mojo::Equals(this->depthClamp, other_struct.depthClamp))
    return false;
  if (!mojo::Equals(this->depthBiasClamp, other_struct.depthBiasClamp))
    return false;
  if (!mojo::Equals(this->fillModeNonSolid, other_struct.fillModeNonSolid))
    return false;
  if (!mojo::Equals(this->depthBounds, other_struct.depthBounds))
    return false;
  if (!mojo::Equals(this->wideLines, other_struct.wideLines))
    return false;
  if (!mojo::Equals(this->largePoints, other_struct.largePoints))
    return false;
  if (!mojo::Equals(this->alphaToOne, other_struct.alphaToOne))
    return false;
  if (!mojo::Equals(this->multiViewport, other_struct.multiViewport))
    return false;
  if (!mojo::Equals(this->samplerAnisotropy, other_struct.samplerAnisotropy))
    return false;
  if (!mojo::Equals(this->textureCompressionETC2, other_struct.textureCompressionETC2))
    return false;
  if (!mojo::Equals(this->textureCompressionASTC_LDR, other_struct.textureCompressionASTC_LDR))
    return false;
  if (!mojo::Equals(this->textureCompressionBC, other_struct.textureCompressionBC))
    return false;
  if (!mojo::Equals(this->occlusionQueryPrecise, other_struct.occlusionQueryPrecise))
    return false;
  if (!mojo::Equals(this->pipelineStatisticsQuery, other_struct.pipelineStatisticsQuery))
    return false;
  if (!mojo::Equals(this->vertexPipelineStoresAndAtomics, other_struct.vertexPipelineStoresAndAtomics))
    return false;
  if (!mojo::Equals(this->fragmentStoresAndAtomics, other_struct.fragmentStoresAndAtomics))
    return false;
  if (!mojo::Equals(this->shaderTessellationAndGeometryPointSize, other_struct.shaderTessellationAndGeometryPointSize))
    return false;
  if (!mojo::Equals(this->shaderImageGatherExtended, other_struct.shaderImageGatherExtended))
    return false;
  if (!mojo::Equals(this->shaderStorageImageExtendedFormats, other_struct.shaderStorageImageExtendedFormats))
    return false;
  if (!mojo::Equals(this->shaderStorageImageMultisample, other_struct.shaderStorageImageMultisample))
    return false;
  if (!mojo::Equals(this->shaderStorageImageReadWithoutFormat, other_struct.shaderStorageImageReadWithoutFormat))
    return false;
  if (!mojo::Equals(this->shaderStorageImageWriteWithoutFormat, other_struct.shaderStorageImageWriteWithoutFormat))
    return false;
  if (!mojo::Equals(this->shaderUniformBufferArrayDynamicIndexing, other_struct.shaderUniformBufferArrayDynamicIndexing))
    return false;
  if (!mojo::Equals(this->shaderSampledImageArrayDynamicIndexing, other_struct.shaderSampledImageArrayDynamicIndexing))
    return false;
  if (!mojo::Equals(this->shaderStorageBufferArrayDynamicIndexing, other_struct.shaderStorageBufferArrayDynamicIndexing))
    return false;
  if (!mojo::Equals(this->shaderStorageImageArrayDynamicIndexing, other_struct.shaderStorageImageArrayDynamicIndexing))
    return false;
  if (!mojo::Equals(this->shaderClipDistance, other_struct.shaderClipDistance))
    return false;
  if (!mojo::Equals(this->shaderCullDistance, other_struct.shaderCullDistance))
    return false;
  if (!mojo::Equals(this->shaderFloat64, other_struct.shaderFloat64))
    return false;
  if (!mojo::Equals(this->shaderInt64, other_struct.shaderInt64))
    return false;
  if (!mojo::Equals(this->shaderInt16, other_struct.shaderInt16))
    return false;
  if (!mojo::Equals(this->shaderResourceResidency, other_struct.shaderResourceResidency))
    return false;
  if (!mojo::Equals(this->shaderResourceMinLod, other_struct.shaderResourceMinLod))
    return false;
  if (!mojo::Equals(this->sparseBinding, other_struct.sparseBinding))
    return false;
  if (!mojo::Equals(this->sparseResidencyBuffer, other_struct.sparseResidencyBuffer))
    return false;
  if (!mojo::Equals(this->sparseResidencyImage2D, other_struct.sparseResidencyImage2D))
    return false;
  if (!mojo::Equals(this->sparseResidencyImage3D, other_struct.sparseResidencyImage3D))
    return false;
  if (!mojo::Equals(this->sparseResidency2Samples, other_struct.sparseResidency2Samples))
    return false;
  if (!mojo::Equals(this->sparseResidency4Samples, other_struct.sparseResidency4Samples))
    return false;
  if (!mojo::Equals(this->sparseResidency8Samples, other_struct.sparseResidency8Samples))
    return false;
  if (!mojo::Equals(this->sparseResidency16Samples, other_struct.sparseResidency16Samples))
    return false;
  if (!mojo::Equals(this->sparseResidencyAliased, other_struct.sparseResidencyAliased))
    return false;
  if (!mojo::Equals(this->variableMultisampleRate, other_struct.variableMultisampleRate))
    return false;
  if (!mojo::Equals(this->inheritedQueries, other_struct.inheritedQueries))
    return false;
  return true;
}

template <typename T, VkPhysicalDeviceFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.robustBufferAccess < rhs.robustBufferAccess)
    return true;
  if (rhs.robustBufferAccess < lhs.robustBufferAccess)
    return false;
  if (lhs.fullDrawIndexUint32 < rhs.fullDrawIndexUint32)
    return true;
  if (rhs.fullDrawIndexUint32 < lhs.fullDrawIndexUint32)
    return false;
  if (lhs.imageCubeArray < rhs.imageCubeArray)
    return true;
  if (rhs.imageCubeArray < lhs.imageCubeArray)
    return false;
  if (lhs.independentBlend < rhs.independentBlend)
    return true;
  if (rhs.independentBlend < lhs.independentBlend)
    return false;
  if (lhs.geometryShader < rhs.geometryShader)
    return true;
  if (rhs.geometryShader < lhs.geometryShader)
    return false;
  if (lhs.tessellationShader < rhs.tessellationShader)
    return true;
  if (rhs.tessellationShader < lhs.tessellationShader)
    return false;
  if (lhs.sampleRateShading < rhs.sampleRateShading)
    return true;
  if (rhs.sampleRateShading < lhs.sampleRateShading)
    return false;
  if (lhs.dualSrcBlend < rhs.dualSrcBlend)
    return true;
  if (rhs.dualSrcBlend < lhs.dualSrcBlend)
    return false;
  if (lhs.logicOp < rhs.logicOp)
    return true;
  if (rhs.logicOp < lhs.logicOp)
    return false;
  if (lhs.multiDrawIndirect < rhs.multiDrawIndirect)
    return true;
  if (rhs.multiDrawIndirect < lhs.multiDrawIndirect)
    return false;
  if (lhs.drawIndirectFirstInstance < rhs.drawIndirectFirstInstance)
    return true;
  if (rhs.drawIndirectFirstInstance < lhs.drawIndirectFirstInstance)
    return false;
  if (lhs.depthClamp < rhs.depthClamp)
    return true;
  if (rhs.depthClamp < lhs.depthClamp)
    return false;
  if (lhs.depthBiasClamp < rhs.depthBiasClamp)
    return true;
  if (rhs.depthBiasClamp < lhs.depthBiasClamp)
    return false;
  if (lhs.fillModeNonSolid < rhs.fillModeNonSolid)
    return true;
  if (rhs.fillModeNonSolid < lhs.fillModeNonSolid)
    return false;
  if (lhs.depthBounds < rhs.depthBounds)
    return true;
  if (rhs.depthBounds < lhs.depthBounds)
    return false;
  if (lhs.wideLines < rhs.wideLines)
    return true;
  if (rhs.wideLines < lhs.wideLines)
    return false;
  if (lhs.largePoints < rhs.largePoints)
    return true;
  if (rhs.largePoints < lhs.largePoints)
    return false;
  if (lhs.alphaToOne < rhs.alphaToOne)
    return true;
  if (rhs.alphaToOne < lhs.alphaToOne)
    return false;
  if (lhs.multiViewport < rhs.multiViewport)
    return true;
  if (rhs.multiViewport < lhs.multiViewport)
    return false;
  if (lhs.samplerAnisotropy < rhs.samplerAnisotropy)
    return true;
  if (rhs.samplerAnisotropy < lhs.samplerAnisotropy)
    return false;
  if (lhs.textureCompressionETC2 < rhs.textureCompressionETC2)
    return true;
  if (rhs.textureCompressionETC2 < lhs.textureCompressionETC2)
    return false;
  if (lhs.textureCompressionASTC_LDR < rhs.textureCompressionASTC_LDR)
    return true;
  if (rhs.textureCompressionASTC_LDR < lhs.textureCompressionASTC_LDR)
    return false;
  if (lhs.textureCompressionBC < rhs.textureCompressionBC)
    return true;
  if (rhs.textureCompressionBC < lhs.textureCompressionBC)
    return false;
  if (lhs.occlusionQueryPrecise < rhs.occlusionQueryPrecise)
    return true;
  if (rhs.occlusionQueryPrecise < lhs.occlusionQueryPrecise)
    return false;
  if (lhs.pipelineStatisticsQuery < rhs.pipelineStatisticsQuery)
    return true;
  if (rhs.pipelineStatisticsQuery < lhs.pipelineStatisticsQuery)
    return false;
  if (lhs.vertexPipelineStoresAndAtomics < rhs.vertexPipelineStoresAndAtomics)
    return true;
  if (rhs.vertexPipelineStoresAndAtomics < lhs.vertexPipelineStoresAndAtomics)
    return false;
  if (lhs.fragmentStoresAndAtomics < rhs.fragmentStoresAndAtomics)
    return true;
  if (rhs.fragmentStoresAndAtomics < lhs.fragmentStoresAndAtomics)
    return false;
  if (lhs.shaderTessellationAndGeometryPointSize < rhs.shaderTessellationAndGeometryPointSize)
    return true;
  if (rhs.shaderTessellationAndGeometryPointSize < lhs.shaderTessellationAndGeometryPointSize)
    return false;
  if (lhs.shaderImageGatherExtended < rhs.shaderImageGatherExtended)
    return true;
  if (rhs.shaderImageGatherExtended < lhs.shaderImageGatherExtended)
    return false;
  if (lhs.shaderStorageImageExtendedFormats < rhs.shaderStorageImageExtendedFormats)
    return true;
  if (rhs.shaderStorageImageExtendedFormats < lhs.shaderStorageImageExtendedFormats)
    return false;
  if (lhs.shaderStorageImageMultisample < rhs.shaderStorageImageMultisample)
    return true;
  if (rhs.shaderStorageImageMultisample < lhs.shaderStorageImageMultisample)
    return false;
  if (lhs.shaderStorageImageReadWithoutFormat < rhs.shaderStorageImageReadWithoutFormat)
    return true;
  if (rhs.shaderStorageImageReadWithoutFormat < lhs.shaderStorageImageReadWithoutFormat)
    return false;
  if (lhs.shaderStorageImageWriteWithoutFormat < rhs.shaderStorageImageWriteWithoutFormat)
    return true;
  if (rhs.shaderStorageImageWriteWithoutFormat < lhs.shaderStorageImageWriteWithoutFormat)
    return false;
  if (lhs.shaderUniformBufferArrayDynamicIndexing < rhs.shaderUniformBufferArrayDynamicIndexing)
    return true;
  if (rhs.shaderUniformBufferArrayDynamicIndexing < lhs.shaderUniformBufferArrayDynamicIndexing)
    return false;
  if (lhs.shaderSampledImageArrayDynamicIndexing < rhs.shaderSampledImageArrayDynamicIndexing)
    return true;
  if (rhs.shaderSampledImageArrayDynamicIndexing < lhs.shaderSampledImageArrayDynamicIndexing)
    return false;
  if (lhs.shaderStorageBufferArrayDynamicIndexing < rhs.shaderStorageBufferArrayDynamicIndexing)
    return true;
  if (rhs.shaderStorageBufferArrayDynamicIndexing < lhs.shaderStorageBufferArrayDynamicIndexing)
    return false;
  if (lhs.shaderStorageImageArrayDynamicIndexing < rhs.shaderStorageImageArrayDynamicIndexing)
    return true;
  if (rhs.shaderStorageImageArrayDynamicIndexing < lhs.shaderStorageImageArrayDynamicIndexing)
    return false;
  if (lhs.shaderClipDistance < rhs.shaderClipDistance)
    return true;
  if (rhs.shaderClipDistance < lhs.shaderClipDistance)
    return false;
  if (lhs.shaderCullDistance < rhs.shaderCullDistance)
    return true;
  if (rhs.shaderCullDistance < lhs.shaderCullDistance)
    return false;
  if (lhs.shaderFloat64 < rhs.shaderFloat64)
    return true;
  if (rhs.shaderFloat64 < lhs.shaderFloat64)
    return false;
  if (lhs.shaderInt64 < rhs.shaderInt64)
    return true;
  if (rhs.shaderInt64 < lhs.shaderInt64)
    return false;
  if (lhs.shaderInt16 < rhs.shaderInt16)
    return true;
  if (rhs.shaderInt16 < lhs.shaderInt16)
    return false;
  if (lhs.shaderResourceResidency < rhs.shaderResourceResidency)
    return true;
  if (rhs.shaderResourceResidency < lhs.shaderResourceResidency)
    return false;
  if (lhs.shaderResourceMinLod < rhs.shaderResourceMinLod)
    return true;
  if (rhs.shaderResourceMinLod < lhs.shaderResourceMinLod)
    return false;
  if (lhs.sparseBinding < rhs.sparseBinding)
    return true;
  if (rhs.sparseBinding < lhs.sparseBinding)
    return false;
  if (lhs.sparseResidencyBuffer < rhs.sparseResidencyBuffer)
    return true;
  if (rhs.sparseResidencyBuffer < lhs.sparseResidencyBuffer)
    return false;
  if (lhs.sparseResidencyImage2D < rhs.sparseResidencyImage2D)
    return true;
  if (rhs.sparseResidencyImage2D < lhs.sparseResidencyImage2D)
    return false;
  if (lhs.sparseResidencyImage3D < rhs.sparseResidencyImage3D)
    return true;
  if (rhs.sparseResidencyImage3D < lhs.sparseResidencyImage3D)
    return false;
  if (lhs.sparseResidency2Samples < rhs.sparseResidency2Samples)
    return true;
  if (rhs.sparseResidency2Samples < lhs.sparseResidency2Samples)
    return false;
  if (lhs.sparseResidency4Samples < rhs.sparseResidency4Samples)
    return true;
  if (rhs.sparseResidency4Samples < lhs.sparseResidency4Samples)
    return false;
  if (lhs.sparseResidency8Samples < rhs.sparseResidency8Samples)
    return true;
  if (rhs.sparseResidency8Samples < lhs.sparseResidency8Samples)
    return false;
  if (lhs.sparseResidency16Samples < rhs.sparseResidency16Samples)
    return true;
  if (rhs.sparseResidency16Samples < lhs.sparseResidency16Samples)
    return false;
  if (lhs.sparseResidencyAliased < rhs.sparseResidencyAliased)
    return true;
  if (rhs.sparseResidencyAliased < lhs.sparseResidencyAliased)
    return false;
  if (lhs.variableMultisampleRate < rhs.variableMultisampleRate)
    return true;
  if (rhs.variableMultisampleRate < lhs.variableMultisampleRate)
    return false;
  if (lhs.inheritedQueries < rhs.inheritedQueries)
    return true;
  if (rhs.inheritedQueries < lhs.inheritedQueries)
    return false;
  return false;
}
template <typename StructPtrType>
VkExtent3DPtr VkExtent3D::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(depth)
  );
}

template <typename T, VkExtent3D::EnableIfSame<T>*>
bool VkExtent3D::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->depth, other_struct.depth))
    return false;
  return true;
}

template <typename T, VkExtent3D::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.depth < rhs.depth)
    return true;
  if (rhs.depth < lhs.depth)
    return false;
  return false;
}
template <typename StructPtrType>
VkQueueFamilyPropertiesPtr VkQueueFamilyProperties::Clone() const {
  return New(
      mojo::Clone(queueFlags),
      mojo::Clone(queueCount),
      mojo::Clone(timestampValidBits),
      mojo::Clone(minImageTransferGranularity)
  );
}

template <typename T, VkQueueFamilyProperties::EnableIfSame<T>*>
bool VkQueueFamilyProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->queueFlags, other_struct.queueFlags))
    return false;
  if (!mojo::Equals(this->queueCount, other_struct.queueCount))
    return false;
  if (!mojo::Equals(this->timestampValidBits, other_struct.timestampValidBits))
    return false;
  if (!mojo::Equals(this->minImageTransferGranularity, other_struct.minImageTransferGranularity))
    return false;
  return true;
}

template <typename T, VkQueueFamilyProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.queueFlags < rhs.queueFlags)
    return true;
  if (rhs.queueFlags < lhs.queueFlags)
    return false;
  if (lhs.queueCount < rhs.queueCount)
    return true;
  if (rhs.queueCount < lhs.queueCount)
    return false;
  if (lhs.timestampValidBits < rhs.timestampValidBits)
    return true;
  if (rhs.timestampValidBits < lhs.timestampValidBits)
    return false;
  if (lhs.minImageTransferGranularity < rhs.minImageTransferGranularity)
    return true;
  if (rhs.minImageTransferGranularity < lhs.minImageTransferGranularity)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkExtensionProperties::DataView,
                                         ::gpu::mojom::VkExtensionPropertiesPtr> {
  static bool IsNull(const ::gpu::mojom::VkExtensionPropertiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkExtensionPropertiesPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::VkExtensionProperties::extensionName)& extensionName(
      const ::gpu::mojom::VkExtensionPropertiesPtr& input) {
    return input->extensionName;
  }

  static decltype(::gpu::mojom::VkExtensionProperties::specVersion) specVersion(
      const ::gpu::mojom::VkExtensionPropertiesPtr& input) {
    return input->specVersion;
  }

  static bool Read(::gpu::mojom::VkExtensionProperties::DataView input, ::gpu::mojom::VkExtensionPropertiesPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkLayerProperties::DataView,
                                         ::gpu::mojom::VkLayerPropertiesPtr> {
  static bool IsNull(const ::gpu::mojom::VkLayerPropertiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkLayerPropertiesPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::VkLayerProperties::layerName)& layerName(
      const ::gpu::mojom::VkLayerPropertiesPtr& input) {
    return input->layerName;
  }

  static decltype(::gpu::mojom::VkLayerProperties::specVersion) specVersion(
      const ::gpu::mojom::VkLayerPropertiesPtr& input) {
    return input->specVersion;
  }

  static decltype(::gpu::mojom::VkLayerProperties::implementationVersion) implementationVersion(
      const ::gpu::mojom::VkLayerPropertiesPtr& input) {
    return input->implementationVersion;
  }

  static const decltype(::gpu::mojom::VkLayerProperties::description)& description(
      const ::gpu::mojom::VkLayerPropertiesPtr& input) {
    return input->description;
  }

  static bool Read(::gpu::mojom::VkLayerProperties::DataView input, ::gpu::mojom::VkLayerPropertiesPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkPhysicalDeviceLimits::DataView,
                                         ::gpu::mojom::VkPhysicalDeviceLimitsPtr> {
  static bool IsNull(const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkPhysicalDeviceLimitsPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxImageDimension1D) maxImageDimension1D(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxImageDimension1D;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxImageDimension2D) maxImageDimension2D(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxImageDimension2D;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxImageDimension3D) maxImageDimension3D(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxImageDimension3D;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxImageDimensionCube) maxImageDimensionCube(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxImageDimensionCube;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxImageArrayLayers) maxImageArrayLayers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxImageArrayLayers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTexelBufferElements) maxTexelBufferElements(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTexelBufferElements;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxUniformBufferRange) maxUniformBufferRange(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxUniformBufferRange;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxStorageBufferRange) maxStorageBufferRange(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxStorageBufferRange;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPushConstantsSize) maxPushConstantsSize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPushConstantsSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxMemoryAllocationCount) maxMemoryAllocationCount(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxMemoryAllocationCount;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxSamplerAllocationCount) maxSamplerAllocationCount(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxSamplerAllocationCount;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::bufferImageGranularity) bufferImageGranularity(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->bufferImageGranularity;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::sparseAddressSpaceSize) sparseAddressSpaceSize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->sparseAddressSpaceSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxBoundDescriptorSets) maxBoundDescriptorSets(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxBoundDescriptorSets;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorSamplers) maxPerStageDescriptorSamplers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorSamplers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorUniformBuffers) maxPerStageDescriptorUniformBuffers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorUniformBuffers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorStorageBuffers) maxPerStageDescriptorStorageBuffers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorStorageBuffers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorSampledImages) maxPerStageDescriptorSampledImages(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorSampledImages;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorStorageImages) maxPerStageDescriptorStorageImages(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorStorageImages;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageDescriptorInputAttachments) maxPerStageDescriptorInputAttachments(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageDescriptorInputAttachments;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxPerStageResources) maxPerStageResources(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxPerStageResources;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetSamplers) maxDescriptorSetSamplers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetSamplers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffers) maxDescriptorSetUniformBuffers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetUniformBuffers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetUniformBuffersDynamic) maxDescriptorSetUniformBuffersDynamic(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetUniformBuffersDynamic;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffers) maxDescriptorSetStorageBuffers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetStorageBuffers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetStorageBuffersDynamic) maxDescriptorSetStorageBuffersDynamic(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetStorageBuffersDynamic;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetSampledImages) maxDescriptorSetSampledImages(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetSampledImages;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetStorageImages) maxDescriptorSetStorageImages(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetStorageImages;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDescriptorSetInputAttachments) maxDescriptorSetInputAttachments(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDescriptorSetInputAttachments;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxVertexInputAttributes) maxVertexInputAttributes(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxVertexInputAttributes;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxVertexInputBindings) maxVertexInputBindings(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxVertexInputBindings;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxVertexInputAttributeOffset) maxVertexInputAttributeOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxVertexInputAttributeOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxVertexInputBindingStride) maxVertexInputBindingStride(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxVertexInputBindingStride;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxVertexOutputComponents) maxVertexOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxVertexOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationGenerationLevel) maxTessellationGenerationLevel(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationGenerationLevel;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationPatchSize) maxTessellationPatchSize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationPatchSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationControlPerVertexInputComponents) maxTessellationControlPerVertexInputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationControlPerVertexInputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationControlPerVertexOutputComponents) maxTessellationControlPerVertexOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationControlPerVertexOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationControlPerPatchOutputComponents) maxTessellationControlPerPatchOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationControlPerPatchOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationControlTotalOutputComponents) maxTessellationControlTotalOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationControlTotalOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationEvaluationInputComponents) maxTessellationEvaluationInputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationEvaluationInputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTessellationEvaluationOutputComponents) maxTessellationEvaluationOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTessellationEvaluationOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxGeometryShaderInvocations) maxGeometryShaderInvocations(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxGeometryShaderInvocations;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxGeometryInputComponents) maxGeometryInputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxGeometryInputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxGeometryOutputComponents) maxGeometryOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxGeometryOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxGeometryOutputVertices) maxGeometryOutputVertices(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxGeometryOutputVertices;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxGeometryTotalOutputComponents) maxGeometryTotalOutputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxGeometryTotalOutputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFragmentInputComponents) maxFragmentInputComponents(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFragmentInputComponents;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFragmentOutputAttachments) maxFragmentOutputAttachments(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFragmentOutputAttachments;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFragmentDualSrcAttachments) maxFragmentDualSrcAttachments(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFragmentDualSrcAttachments;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFragmentCombinedOutputResources) maxFragmentCombinedOutputResources(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFragmentCombinedOutputResources;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxComputeSharedMemorySize) maxComputeSharedMemorySize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxComputeSharedMemorySize;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxComputeWorkGroupCount)& maxComputeWorkGroupCount(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxComputeWorkGroupCount;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxComputeWorkGroupInvocations) maxComputeWorkGroupInvocations(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxComputeWorkGroupInvocations;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxComputeWorkGroupSize)& maxComputeWorkGroupSize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxComputeWorkGroupSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::subPixelPrecisionBits) subPixelPrecisionBits(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->subPixelPrecisionBits;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::subTexelPrecisionBits) subTexelPrecisionBits(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->subTexelPrecisionBits;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::mipmapPrecisionBits) mipmapPrecisionBits(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->mipmapPrecisionBits;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDrawIndexedIndexValue) maxDrawIndexedIndexValue(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDrawIndexedIndexValue;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxDrawIndirectCount) maxDrawIndirectCount(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxDrawIndirectCount;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxSamplerLodBias) maxSamplerLodBias(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxSamplerLodBias;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxSamplerAnisotropy) maxSamplerAnisotropy(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxSamplerAnisotropy;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxViewports) maxViewports(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxViewports;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxViewportDimensions)& maxViewportDimensions(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxViewportDimensions;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::viewportBoundsRange)& viewportBoundsRange(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->viewportBoundsRange;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::viewportSubPixelBits) viewportSubPixelBits(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->viewportSubPixelBits;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minMemoryMapAlignment) minMemoryMapAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minMemoryMapAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment) minTexelBufferOffsetAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minTexelBufferOffsetAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment) minUniformBufferOffsetAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minUniformBufferOffsetAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment) minStorageBufferOffsetAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minStorageBufferOffsetAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minTexelOffset) minTexelOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minTexelOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTexelOffset) maxTexelOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTexelOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minTexelGatherOffset) minTexelGatherOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minTexelGatherOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxTexelGatherOffset) maxTexelGatherOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxTexelGatherOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::minInterpolationOffset) minInterpolationOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->minInterpolationOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxInterpolationOffset) maxInterpolationOffset(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxInterpolationOffset;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::subPixelInterpolationOffsetBits) subPixelInterpolationOffsetBits(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->subPixelInterpolationOffsetBits;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFramebufferWidth) maxFramebufferWidth(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFramebufferWidth;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFramebufferHeight) maxFramebufferHeight(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFramebufferHeight;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxFramebufferLayers) maxFramebufferLayers(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxFramebufferLayers;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::framebufferColorSampleCounts) framebufferColorSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->framebufferColorSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::framebufferDepthSampleCounts) framebufferDepthSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->framebufferDepthSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::framebufferStencilSampleCounts) framebufferStencilSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->framebufferStencilSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts) framebufferNoAttachmentsSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->framebufferNoAttachmentsSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxColorAttachments) maxColorAttachments(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxColorAttachments;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::sampledImageColorSampleCounts) sampledImageColorSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->sampledImageColorSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::sampledImageIntegerSampleCounts) sampledImageIntegerSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->sampledImageIntegerSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::sampledImageDepthSampleCounts) sampledImageDepthSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->sampledImageDepthSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::sampledImageStencilSampleCounts) sampledImageStencilSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->sampledImageStencilSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::storageImageSampleCounts) storageImageSampleCounts(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->storageImageSampleCounts;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxSampleMaskWords) maxSampleMaskWords(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxSampleMaskWords;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::timestampComputeAndGraphics) timestampComputeAndGraphics(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->timestampComputeAndGraphics;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::timestampPeriod) timestampPeriod(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->timestampPeriod;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxClipDistances) maxClipDistances(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxClipDistances;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxCullDistances) maxCullDistances(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxCullDistances;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::maxCombinedClipAndCullDistances) maxCombinedClipAndCullDistances(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->maxCombinedClipAndCullDistances;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::discreteQueuePriorities) discreteQueuePriorities(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->discreteQueuePriorities;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::pointSizeRange)& pointSizeRange(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->pointSizeRange;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceLimits::lineWidthRange)& lineWidthRange(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->lineWidthRange;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::pointSizeGranularity) pointSizeGranularity(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->pointSizeGranularity;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::lineWidthGranularity) lineWidthGranularity(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->lineWidthGranularity;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::strictLines) strictLines(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->strictLines;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::standardSampleLocations) standardSampleLocations(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->standardSampleLocations;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::optimalBufferCopyOffsetAlignment) optimalBufferCopyOffsetAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->optimalBufferCopyOffsetAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::optimalBufferCopyRowPitchAlignment) optimalBufferCopyRowPitchAlignment(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->optimalBufferCopyRowPitchAlignment;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceLimits::nonCoherentAtomSize) nonCoherentAtomSize(
      const ::gpu::mojom::VkPhysicalDeviceLimitsPtr& input) {
    return input->nonCoherentAtomSize;
  }

  static bool Read(::gpu::mojom::VkPhysicalDeviceLimits::DataView input, ::gpu::mojom::VkPhysicalDeviceLimitsPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkPhysicalDeviceSparseProperties::DataView,
                                         ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr> {
  static bool IsNull(const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkPhysicalDeviceSparseProperties::residencyStandard2DBlockShape) residencyStandard2DBlockShape(
      const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) {
    return input->residencyStandard2DBlockShape;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceSparseProperties::residencyStandard2DMultisampleBlockShape) residencyStandard2DMultisampleBlockShape(
      const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) {
    return input->residencyStandard2DMultisampleBlockShape;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceSparseProperties::residencyStandard3DBlockShape) residencyStandard3DBlockShape(
      const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) {
    return input->residencyStandard3DBlockShape;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceSparseProperties::residencyAlignedMipSize) residencyAlignedMipSize(
      const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) {
    return input->residencyAlignedMipSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceSparseProperties::residencyNonResidentStrict) residencyNonResidentStrict(
      const ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr& input) {
    return input->residencyNonResidentStrict;
  }

  static bool Read(::gpu::mojom::VkPhysicalDeviceSparseProperties::DataView input, ::gpu::mojom::VkPhysicalDeviceSparsePropertiesPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkPhysicalDeviceProperties::DataView,
                                         ::gpu::mojom::VkPhysicalDevicePropertiesPtr> {
  static bool IsNull(const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkPhysicalDevicePropertiesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkPhysicalDeviceProperties::apiVersion) apiVersion(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->apiVersion;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceProperties::driverVersion) driverVersion(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->driverVersion;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceProperties::vendorID) vendorID(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->vendorID;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceProperties::deviceID) deviceID(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->deviceID;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceProperties::deviceType) deviceType(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->deviceType;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceProperties::deviceName)& deviceName(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->deviceName;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceProperties::pipelineCacheUUID)& pipelineCacheUUID(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->pipelineCacheUUID;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceProperties::limits)& limits(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->limits;
  }

  static const decltype(::gpu::mojom::VkPhysicalDeviceProperties::sparseProperties)& sparseProperties(
      const ::gpu::mojom::VkPhysicalDevicePropertiesPtr& input) {
    return input->sparseProperties;
  }

  static bool Read(::gpu::mojom::VkPhysicalDeviceProperties::DataView input, ::gpu::mojom::VkPhysicalDevicePropertiesPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkPhysicalDeviceFeatures::DataView,
                                         ::gpu::mojom::VkPhysicalDeviceFeaturesPtr> {
  static bool IsNull(const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkPhysicalDeviceFeaturesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::robustBufferAccess) robustBufferAccess(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->robustBufferAccess;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::fullDrawIndexUint32) fullDrawIndexUint32(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->fullDrawIndexUint32;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::imageCubeArray) imageCubeArray(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->imageCubeArray;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::independentBlend) independentBlend(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->independentBlend;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::geometryShader) geometryShader(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->geometryShader;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::tessellationShader) tessellationShader(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->tessellationShader;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sampleRateShading) sampleRateShading(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sampleRateShading;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::dualSrcBlend) dualSrcBlend(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->dualSrcBlend;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::logicOp) logicOp(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->logicOp;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::multiDrawIndirect) multiDrawIndirect(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->multiDrawIndirect;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::drawIndirectFirstInstance) drawIndirectFirstInstance(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->drawIndirectFirstInstance;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::depthClamp) depthClamp(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->depthClamp;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::depthBiasClamp) depthBiasClamp(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->depthBiasClamp;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::fillModeNonSolid) fillModeNonSolid(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->fillModeNonSolid;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::depthBounds) depthBounds(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->depthBounds;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::wideLines) wideLines(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->wideLines;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::largePoints) largePoints(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->largePoints;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::alphaToOne) alphaToOne(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->alphaToOne;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::multiViewport) multiViewport(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->multiViewport;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::samplerAnisotropy) samplerAnisotropy(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->samplerAnisotropy;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::textureCompressionETC2) textureCompressionETC2(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->textureCompressionETC2;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::textureCompressionASTC_LDR) textureCompressionASTC_LDR(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->textureCompressionASTC_LDR;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::textureCompressionBC) textureCompressionBC(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->textureCompressionBC;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::occlusionQueryPrecise) occlusionQueryPrecise(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->occlusionQueryPrecise;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::pipelineStatisticsQuery) pipelineStatisticsQuery(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->pipelineStatisticsQuery;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::vertexPipelineStoresAndAtomics) vertexPipelineStoresAndAtomics(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->vertexPipelineStoresAndAtomics;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::fragmentStoresAndAtomics) fragmentStoresAndAtomics(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->fragmentStoresAndAtomics;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderTessellationAndGeometryPointSize) shaderTessellationAndGeometryPointSize(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderTessellationAndGeometryPointSize;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderImageGatherExtended) shaderImageGatherExtended(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderImageGatherExtended;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageImageExtendedFormats) shaderStorageImageExtendedFormats(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageImageExtendedFormats;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageImageMultisample) shaderStorageImageMultisample(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageImageMultisample;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageImageReadWithoutFormat) shaderStorageImageReadWithoutFormat(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageImageReadWithoutFormat;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageImageWriteWithoutFormat) shaderStorageImageWriteWithoutFormat(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageImageWriteWithoutFormat;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderUniformBufferArrayDynamicIndexing) shaderUniformBufferArrayDynamicIndexing(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderUniformBufferArrayDynamicIndexing;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderSampledImageArrayDynamicIndexing) shaderSampledImageArrayDynamicIndexing(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderSampledImageArrayDynamicIndexing;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageBufferArrayDynamicIndexing) shaderStorageBufferArrayDynamicIndexing(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageBufferArrayDynamicIndexing;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderStorageImageArrayDynamicIndexing) shaderStorageImageArrayDynamicIndexing(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderStorageImageArrayDynamicIndexing;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderClipDistance) shaderClipDistance(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderClipDistance;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderCullDistance) shaderCullDistance(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderCullDistance;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderFloat64) shaderFloat64(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderFloat64;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderInt64) shaderInt64(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderInt64;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderInt16) shaderInt16(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderInt16;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderResourceResidency) shaderResourceResidency(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderResourceResidency;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::shaderResourceMinLod) shaderResourceMinLod(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->shaderResourceMinLod;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseBinding) sparseBinding(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseBinding;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidencyBuffer) sparseResidencyBuffer(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidencyBuffer;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidencyImage2D) sparseResidencyImage2D(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidencyImage2D;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidencyImage3D) sparseResidencyImage3D(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidencyImage3D;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidency2Samples) sparseResidency2Samples(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidency2Samples;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidency4Samples) sparseResidency4Samples(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidency4Samples;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidency8Samples) sparseResidency8Samples(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidency8Samples;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidency16Samples) sparseResidency16Samples(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidency16Samples;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::sparseResidencyAliased) sparseResidencyAliased(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->sparseResidencyAliased;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::variableMultisampleRate) variableMultisampleRate(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->variableMultisampleRate;
  }

  static decltype(::gpu::mojom::VkPhysicalDeviceFeatures::inheritedQueries) inheritedQueries(
      const ::gpu::mojom::VkPhysicalDeviceFeaturesPtr& input) {
    return input->inheritedQueries;
  }

  static bool Read(::gpu::mojom::VkPhysicalDeviceFeatures::DataView input, ::gpu::mojom::VkPhysicalDeviceFeaturesPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkExtent3D::DataView,
                                         ::gpu::mojom::VkExtent3DPtr> {
  static bool IsNull(const ::gpu::mojom::VkExtent3DPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkExtent3DPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkExtent3D::width) width(
      const ::gpu::mojom::VkExtent3DPtr& input) {
    return input->width;
  }

  static decltype(::gpu::mojom::VkExtent3D::height) height(
      const ::gpu::mojom::VkExtent3DPtr& input) {
    return input->height;
  }

  static decltype(::gpu::mojom::VkExtent3D::depth) depth(
      const ::gpu::mojom::VkExtent3DPtr& input) {
    return input->depth;
  }

  static bool Read(::gpu::mojom::VkExtent3D::DataView input, ::gpu::mojom::VkExtent3DPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VkQueueFamilyProperties::DataView,
                                         ::gpu::mojom::VkQueueFamilyPropertiesPtr> {
  static bool IsNull(const ::gpu::mojom::VkQueueFamilyPropertiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VkQueueFamilyPropertiesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VkQueueFamilyProperties::queueFlags) queueFlags(
      const ::gpu::mojom::VkQueueFamilyPropertiesPtr& input) {
    return input->queueFlags;
  }

  static decltype(::gpu::mojom::VkQueueFamilyProperties::queueCount) queueCount(
      const ::gpu::mojom::VkQueueFamilyPropertiesPtr& input) {
    return input->queueCount;
  }

  static decltype(::gpu::mojom::VkQueueFamilyProperties::timestampValidBits) timestampValidBits(
      const ::gpu::mojom::VkQueueFamilyPropertiesPtr& input) {
    return input->timestampValidBits;
  }

  static const decltype(::gpu::mojom::VkQueueFamilyProperties::minImageTransferGranularity)& minImageTransferGranularity(
      const ::gpu::mojom::VkQueueFamilyPropertiesPtr& input) {
    return input->minImageTransferGranularity;
  }

  static bool Read(::gpu::mojom::VkQueueFamilyProperties::DataView input, ::gpu::mojom::VkQueueFamilyPropertiesPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_H_