// media/mojo/mojom/renderer_extensions.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_EXTENSIONS_MOJOM_H_
#define MEDIA_MOJO_MOJOM_RENDERER_EXTENSIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/renderer_extensions.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer_extensions.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/renderer_extensions.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class MediaPlayerRendererClientExtensionProxy;

template <typename ImplRefTraits>
class MediaPlayerRendererClientExtensionStub;

class MediaPlayerRendererClientExtensionRequestValidator;


class MediaPlayerRendererClientExtension
    : public MediaPlayerRendererClientExtensionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerRendererClientExtensionInterfaceBase;
  using Proxy_ = MediaPlayerRendererClientExtensionProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerRendererClientExtensionStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerRendererClientExtensionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnVideoSizeChangeMinVersion = 0,
    kOnDurationChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnVideoSizeChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDurationChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayerRendererClientExtension() = default;

  
  virtual void OnVideoSizeChange(const ::gfx::Size& size) = 0;

  
  virtual void OnDurationChange(::base::TimeDelta duration) = 0;
};

class MediaPlayerRendererExtensionProxy;

template <typename ImplRefTraits>
class MediaPlayerRendererExtensionStub;

class MediaPlayerRendererExtensionRequestValidator;
class MediaPlayerRendererExtensionResponseValidator;


class MediaPlayerRendererExtension
    : public MediaPlayerRendererExtensionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaPlayerRendererExtensionInterfaceBase;
  using Proxy_ = MediaPlayerRendererExtensionProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaPlayerRendererExtensionStub<ImplRefTraits>;

  using RequestValidator_ = MediaPlayerRendererExtensionRequestValidator;
  using ResponseValidator_ = MediaPlayerRendererExtensionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitiateScopedSurfaceRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitiateScopedSurfaceRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaPlayerRendererExtension() = default;


  using InitiateScopedSurfaceRequestCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  
  virtual void InitiateScopedSurfaceRequest(InitiateScopedSurfaceRequestCallback callback) = 0;
};

class FlingingRendererClientExtensionProxy;

template <typename ImplRefTraits>
class FlingingRendererClientExtensionStub;

class FlingingRendererClientExtensionRequestValidator;


class FlingingRendererClientExtension
    : public FlingingRendererClientExtensionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FlingingRendererClientExtensionInterfaceBase;
  using Proxy_ = FlingingRendererClientExtensionProxy;

  template <typename ImplRefTraits>
  using Stub_ = FlingingRendererClientExtensionStub<ImplRefTraits>;

  using RequestValidator_ = FlingingRendererClientExtensionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRemotePlayStateChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRemotePlayStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FlingingRendererClientExtension() = default;

  
  virtual void OnRemotePlayStateChange(::media::MediaStatus::State state) = 0;
};

class MediaFoundationRendererObserverProxy;

template <typename ImplRefTraits>
class MediaFoundationRendererObserverStub;

class MediaFoundationRendererObserverRequestValidator;


class MediaFoundationRendererObserver
    : public MediaFoundationRendererObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaFoundationRendererObserverInterfaceBase;
  using Proxy_ = MediaFoundationRendererObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaFoundationRendererObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaFoundationRendererObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaFoundationRendererObserver() = default;
};

class MediaFoundationRendererNotifierProxy;

template <typename ImplRefTraits>
class MediaFoundationRendererNotifierStub;

class MediaFoundationRendererNotifierRequestValidator;


class MediaFoundationRendererNotifier
    : public MediaFoundationRendererNotifierInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaFoundationRendererNotifierInterfaceBase;
  using Proxy_ = MediaFoundationRendererNotifierProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaFoundationRendererNotifierStub<ImplRefTraits>;

  using RequestValidator_ = MediaFoundationRendererNotifierRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMediaFoundationRendererCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MediaFoundationRendererCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaFoundationRendererNotifier() = default;

  
  virtual void MediaFoundationRendererCreated(::mojo::PendingReceiver<MediaFoundationRendererObserver> observer) = 0;
};



class  MediaPlayerRendererClientExtensionProxy
    : public MediaPlayerRendererClientExtension {
 public:
  using InterfaceType = MediaPlayerRendererClientExtension;

  explicit MediaPlayerRendererClientExtensionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnVideoSizeChange(const ::gfx::Size& size) final;
  
  void OnDurationChange(::base::TimeDelta duration) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaPlayerRendererExtensionProxy
    : public MediaPlayerRendererExtension {
 public:
  using InterfaceType = MediaPlayerRendererExtension;

  explicit MediaPlayerRendererExtensionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitiateScopedSurfaceRequest(InitiateScopedSurfaceRequestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FlingingRendererClientExtensionProxy
    : public FlingingRendererClientExtension {
 public:
  using InterfaceType = FlingingRendererClientExtension;

  explicit FlingingRendererClientExtensionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRemotePlayStateChange(::media::MediaStatus::State state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaFoundationRendererObserverProxy
    : public MediaFoundationRendererObserver {
 public:
  using InterfaceType = MediaFoundationRendererObserver;

  explicit MediaFoundationRendererObserverProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaFoundationRendererNotifierProxy
    : public MediaFoundationRendererNotifier {
 public:
  using InterfaceType = MediaFoundationRendererNotifier;

  explicit MediaFoundationRendererNotifierProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MediaFoundationRendererCreated(::mojo::PendingReceiver<MediaFoundationRendererObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaPlayerRendererClientExtensionStubDispatch {
 public:
  static bool Accept(MediaPlayerRendererClientExtension* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayerRendererClientExtension* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayerRendererClientExtension>>
class MediaPlayerRendererClientExtensionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerRendererClientExtensionStub() = default;
  ~MediaPlayerRendererClientExtensionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerRendererClientExtensionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerRendererClientExtensionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerRendererExtensionStubDispatch {
 public:
  static bool Accept(MediaPlayerRendererExtension* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaPlayerRendererExtension* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaPlayerRendererExtension>>
class MediaPlayerRendererExtensionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaPlayerRendererExtensionStub() = default;
  ~MediaPlayerRendererExtensionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerRendererExtensionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaPlayerRendererExtensionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FlingingRendererClientExtensionStubDispatch {
 public:
  static bool Accept(FlingingRendererClientExtension* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FlingingRendererClientExtension* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FlingingRendererClientExtension>>
class FlingingRendererClientExtensionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FlingingRendererClientExtensionStub() = default;
  ~FlingingRendererClientExtensionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FlingingRendererClientExtensionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FlingingRendererClientExtensionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaFoundationRendererObserverStubDispatch {
 public:
  static bool Accept(MediaFoundationRendererObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaFoundationRendererObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaFoundationRendererObserver>>
class MediaFoundationRendererObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaFoundationRendererObserverStub() = default;
  ~MediaFoundationRendererObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaFoundationRendererObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaFoundationRendererObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaFoundationRendererNotifierStubDispatch {
 public:
  static bool Accept(MediaFoundationRendererNotifier* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaFoundationRendererNotifier* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaFoundationRendererNotifier>>
class MediaFoundationRendererNotifierStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaFoundationRendererNotifierStub() = default;
  ~MediaFoundationRendererNotifierStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaFoundationRendererNotifierStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaFoundationRendererNotifierStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaPlayerRendererClientExtensionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerRendererExtensionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FlingingRendererClientExtensionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaFoundationRendererObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaFoundationRendererNotifierRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaPlayerRendererExtensionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_RENDERER_EXTENSIONS_MOJOM_H_