// third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AGGREGATION_SERVICE_AGGREGATABLE_REPORT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AGGREGATION_SERVICE_AGGREGATABLE_REPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared-internal.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class AggregatableReportHistogramContributionDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AggregatableReportHistogramContributionDataView> {
  using Data = ::blink::mojom::internal::AggregatableReportHistogramContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class AggregationServiceMode : int32_t {
  
  kTeeBased = 0,
  
  kExperimentalPoplar = 1,
  
  kDefault = 0,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AggregationServiceMode value);
inline bool IsKnownEnumValue(AggregationServiceMode value) {
  return internal::AggregationServiceMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AggregatableReportHistogramContributionDataView {
 public:
  AggregatableReportHistogramContributionDataView() = default;

  AggregatableReportHistogramContributionDataView(
      internal::AggregatableReportHistogramContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = data_->bucket.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  int32_t value() const {
    return data_->value;
  }
  std::optional<uint64_t> filtering_id() const {

    return data_->filtering_id_$flag
        ? std::make_optional(data_->filtering_id_$value)
        : std::nullopt;
  }
 private:
  internal::AggregatableReportHistogramContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::AggregationServiceMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AggregationServiceMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AggregationServiceMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AggregationServiceMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AggregationServiceMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AggregatableReportHistogramContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AggregatableReportHistogramContributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AggregatableReportHistogramContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bucket)::BaseType> bucket_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
        in_bucket, bucket_fragment);
    fragment->bucket.Set(
        bucket_fragment.is_null() ? nullptr : bucket_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bucket.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket in AggregatableReportHistogramContribution struct");
    fragment->value = Traits::value(input);
    fragment->filtering_id_$flag = Traits::filtering_id(input).has_value();
    if (Traits::filtering_id(input).has_value()) {
      fragment->filtering_id_$value = Traits::filtering_id(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::AggregatableReportHistogramContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AggregatableReportHistogramContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AggregatableReportHistogramContributionDataView::GetBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->bucket.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AggregationServiceMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AggregationServiceMode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AGGREGATION_SERVICE_AGGREGATABLE_REPORT_MOJOM_SHARED_H_