/* database-cursor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from database-cursor.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-db.h"
#include <sqlite3.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_DATABASE_CURSOR_0_PROPERTY,
	RYGEL_DATABASE_CURSOR_NUM_PROPERTIES
};
static GParamSpec* rygel_database_cursor_properties[RYGEL_DATABASE_CURSOR_NUM_PROPERTIES];
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelDatabaseCursorParamSpecIterator RygelDatabaseCursorParamSpecIterator;

struct _RygelDatabaseCursorPrivate {
	sqlite3_stmt* statement;
	gint current_state;
	gboolean dirty;
	sqlite3* db;
};

struct _RygelDatabaseCursorParamSpecIterator {
	GParamSpec parent_instance;
};

static gint RygelDatabaseCursor_private_offset;
static gpointer rygel_database_cursor_parent_class = NULL;
static gpointer rygel_database_cursor_iterator_parent_class = NULL;

static void rygel_database_cursor_iterator_finalize (RygelDatabaseCursorIterator * obj);
static GType rygel_database_cursor_iterator_get_type_once (void);
static void rygel_database_cursor_finalize (GObject * obj);
static GType rygel_database_cursor_get_type_once (void);

static inline gpointer
rygel_database_cursor_get_instance_private (RygelDatabaseCursor* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDatabaseCursor_private_offset);
}

/**
     * Prepare a SQLite statement from a SQL string
     *
     * If @arguments is non-null, it will call bind()
     *
     * @param db SQLite database this cursor belongs to
     * @param sql statement to execute
     * @param arguments array of values to bind to the SQL statement or null if
     * none
     */
RygelDatabaseCursor*
rygel_database_cursor_construct (GType object_type,
                                 sqlite3* db,
                                 const gchar* sql,
                                 GValue* arguments,
                                 gint arguments_length1,
                                 GError** error)
{
	RygelDatabaseCursor * self = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelDatabaseCursor*) g_object_new (object_type, NULL);
	self->priv->db = db;
	_tmp1_ = sqlite3_prepare_v2 (db, sql, -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (self->priv->statement);
	self->priv->statement = _tmp0_;
	rygel_database_cursor_throw_if_code_is_error (self, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (arguments == NULL) {
		return self;
	}
	rygel_database_cursor_bind (self, arguments, (gint) arguments_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

RygelDatabaseCursor*
rygel_database_cursor_new (sqlite3* db,
                           const gchar* sql,
                           GValue* arguments,
                           gint arguments_length1,
                           GError** error)
{
	return rygel_database_cursor_construct (RYGEL_DATABASE_TYPE_CURSOR, db, sql, arguments, arguments_length1, error);
}

/**
     * Bind new values to a cursor.
     *
     * The cursor will be reset.
     *
     * This function uses the type of the GValue passed in values to determine
     * which _bind function to use.
     *
     * Supported types are: int, long, int64, uint64, string and pointer.
     * Note: The only pointer supported is the null pointer as provided by
     * Database.@null. This is a special value to bind a column to NULL
     * @param arguments array of values to bind to the SQL statement or null if
     * none
     */
void
rygel_database_cursor_bind (RygelDatabaseCursor* self,
                            GValue* arguments,
                            gint arguments_length1,
                            GError** error)
{
	sqlite3_stmt* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statement;
	sqlite3_reset (_tmp0_);
	self->priv->dirty = TRUE;
	self->priv->current_state = -1;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GValue current_value = {0};
				GValue _tmp3_;
				sqlite3* _tmp16_;
				if (!_tmp1_) {
					gint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				if (!(i <= arguments_length1)) {
					break;
				}
				_tmp3_ = arguments[i - 1];
				current_value = _tmp3_;
				if (G_VALUE_HOLDS (&current_value, G_TYPE_INT)) {
					sqlite3_stmt* _tmp4_;
					_tmp4_ = self->priv->statement;
					sqlite3_bind_int (_tmp4_, i, g_value_get_int (&current_value));
				} else {
					if (G_VALUE_HOLDS (&current_value, G_TYPE_INT64)) {
						sqlite3_stmt* _tmp5_;
						_tmp5_ = self->priv->statement;
						sqlite3_bind_int64 (_tmp5_, i, g_value_get_int64 (&current_value));
					} else {
						if (G_VALUE_HOLDS (&current_value, G_TYPE_UINT64)) {
							sqlite3_stmt* _tmp6_;
							_tmp6_ = self->priv->statement;
							sqlite3_bind_int64 (_tmp6_, i, (gint64) g_value_get_uint64 (&current_value));
						} else {
							if (G_VALUE_HOLDS (&current_value, G_TYPE_LONG)) {
								sqlite3_stmt* _tmp7_;
								_tmp7_ = self->priv->statement;
								sqlite3_bind_int64 (_tmp7_, i, (gint64) g_value_get_long (&current_value));
							} else {
								if (G_VALUE_HOLDS (&current_value, G_TYPE_UINT)) {
									sqlite3_stmt* _tmp8_;
									_tmp8_ = self->priv->statement;
									sqlite3_bind_int64 (_tmp8_, i, (gint64) g_value_get_uint (&current_value));
								} else {
									if (G_VALUE_HOLDS (&current_value, G_TYPE_STRING)) {
										sqlite3_stmt* _tmp9_;
										const gchar* _tmp10_;
										gchar* _tmp11_;
										GDestroyNotify _tmp12_;
										_tmp9_ = self->priv->statement;
										_tmp10_ = g_value_get_string (&current_value);
										_tmp11_ = g_strdup (_tmp10_);
										_tmp12_ = g_free;
										sqlite3_bind_text (_tmp9_, i, _tmp11_, -1, _tmp12_);
									} else {
										if (G_VALUE_HOLDS (&current_value, G_TYPE_POINTER)) {
											void* _tmp13_;
											_tmp13_ = g_value_peek_pointer (&current_value);
											if (_tmp13_ == NULL) {
												sqlite3_stmt* _tmp14_;
												_tmp14_ = self->priv->statement;
												sqlite3_bind_null (_tmp14_, i);
											} else {
												g_assert_not_reached ();
											}
										} else {
											GType type = 0UL;
											const gchar* _tmp15_;
											type = G_VALUE_TYPE (&current_value);
											_tmp15_ = g_type_name (type);
											g_warning (_ ("Unsupported type %s"), _tmp15_);
											g_assert_not_reached ();
										}
									}
								}
							}
						}
					}
				}
				_tmp16_ = self->priv->db;
				if (sqlite3_errcode (_tmp16_) != SQLITE_OK) {
					sqlite3_stmt* _tmp17_;
					const gchar* _tmp18_;
					sqlite3* _tmp19_;
					const gchar* _tmp20_;
					GError* _tmp21_;
					_tmp17_ = self->priv->statement;
					_tmp18_ = sqlite3_sql (_tmp17_);
					_tmp19_ = self->priv->db;
					_tmp20_ = sqlite3_errmsg (_tmp19_);
					_tmp21_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_BIND, "Failed to bind value %d in %s: %s", i, _tmp18_, _tmp20_);
					_inner_error0_ = _tmp21_;
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
}

/**
     * Check if the cursor has more rows left
     *
     * @return true if more rows left, false otherwise
     */
gboolean
rygel_database_cursor_has_next (RygelDatabaseCursor* self,
                                GError** error)
{
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->dirty) {
		sqlite3_stmt* _tmp0_;
		_tmp0_ = self->priv->statement;
		self->priv->current_state = sqlite3_step (_tmp0_);
		self->priv->dirty = FALSE;
	}
	rygel_database_cursor_throw_if_code_is_error (self, self->priv->current_state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	if (self->priv->current_state == SQLITE_ROW) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->current_state == -1;
	}
	result = _tmp3_;
	return result;
}

/**
     * Get the next row of this cursor.
     *
     * This function uses pointers instead of unowned because var doesn't work
     * with unowned.
     *
     * @return a pointer to the current row
     */
sqlite3_stmt*
rygel_database_cursor_next (RygelDatabaseCursor* self,
                            GError** error)
{
	sqlite3_stmt* _tmp0_;
	GError* _inner_error0_ = NULL;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	rygel_database_cursor_has_next (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	rygel_database_cursor_throw_if_code_is_error (self, self->priv->current_state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->priv->dirty = TRUE;
	_tmp0_ = self->priv->statement;
	result = _tmp0_;
	return result;
}

/**
     * Return an iterator to the cursor to use with foreach
     *
     * @return an iterator wrapping the cursor
     */
RygelDatabaseCursorIterator*
rygel_database_cursor_iterator (RygelDatabaseCursor* self)
{
	RygelDatabaseCursorIterator* _tmp0_;
	RygelDatabaseCursorIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_database_cursor_iterator_new (self);
	result = _tmp0_;
	return result;
}

/**
     * Convert a SQLite return code to a DatabaseError
     */
void
rygel_database_cursor_throw_if_code_is_error (RygelDatabaseCursor* self,
                                              gint sqlite_error,
                                              GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	switch (sqlite_error) {
		case SQLITE_OK:
		case SQLITE_DONE:
		case SQLITE_ROW:
		{
			return;
		}
		default:
		{
			sqlite3* _tmp0_;
			const gchar* _tmp1_;
			GError* _tmp2_;
			_tmp0_ = self->priv->db;
			_tmp1_ = sqlite3_errmsg (_tmp0_);
			_tmp2_ = g_error_new (RYGEL_DATABASE_DATABASE_ERROR, RYGEL_DATABASE_DATABASE_ERROR_SQLITE_ERROR, "SQLite error %d: %s", sqlite_error, _tmp1_);
			_inner_error0_ = _tmp2_;
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

/**
     * Check if the last operation on the database was an error
     */
void
rygel_database_cursor_throw_if_db_has_error (RygelDatabaseCursor* self,
                                             GError** error)
{
	sqlite3* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->db;
	rygel_database_cursor_throw_if_code_is_error (self, sqlite3_errcode (_tmp0_), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelDatabaseCursorIterator*
rygel_database_cursor_iterator_construct (GType object_type,
                                          RygelDatabaseCursor* cursor)
{
	RygelDatabaseCursorIterator* self = NULL;
	RygelDatabaseCursor* _tmp0_;
	g_return_val_if_fail (cursor != NULL, NULL);
	self = (RygelDatabaseCursorIterator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (cursor);
	_g_object_unref0 (self->cursor);
	self->cursor = _tmp0_;
	return self;
}

RygelDatabaseCursorIterator*
rygel_database_cursor_iterator_new (RygelDatabaseCursor* cursor)
{
	return rygel_database_cursor_iterator_construct (RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, cursor);
}

gboolean
rygel_database_cursor_iterator_next (RygelDatabaseCursorIterator* self,
                                     GError** error)
{
	gboolean _tmp0_ = FALSE;
	RygelDatabaseCursor* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->cursor;
	_tmp0_ = rygel_database_cursor_has_next (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	result = _tmp0_;
	return result;
}

sqlite3_stmt*
rygel_database_cursor_iterator_get (RygelDatabaseCursorIterator* self,
                                    GError** error)
{
	sqlite3_stmt* _tmp0_ = NULL;
	RygelDatabaseCursor* _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError* _inner_error0_ = NULL;
	sqlite3_stmt* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->cursor;
	_tmp2_ = rygel_database_cursor_next (_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = _tmp0_;
	return result;
}

static void
rygel_database_cursor_value_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_database_cursor_value_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_database_cursor_iterator_unref (value->data[0].v_pointer);
	}
}

static void
rygel_database_cursor_value_iterator_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_database_cursor_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_database_cursor_value_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_database_cursor_value_iterator_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelDatabaseCursorIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_database_cursor_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_database_cursor_value_iterator_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	RygelDatabaseCursorIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_database_cursor_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_database_cursor_param_spec_iterator (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	RygelDatabaseCursorParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_database_cursor_value_get_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

void
rygel_database_cursor_value_set_iterator (GValue* value,
                                          gpointer v_object)
{
	RygelDatabaseCursorIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_database_cursor_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_database_cursor_iterator_unref (old);
	}
}

void
rygel_database_cursor_value_take_iterator (GValue* value,
                                           gpointer v_object)
{
	RygelDatabaseCursorIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_database_cursor_iterator_unref (old);
	}
}

static void
rygel_database_cursor_iterator_class_init (RygelDatabaseCursorIteratorClass * klass,
                                           gpointer klass_data)
{
	rygel_database_cursor_iterator_parent_class = g_type_class_peek_parent (klass);
	((RygelDatabaseCursorIteratorClass *) klass)->finalize = rygel_database_cursor_iterator_finalize;
}

static void
rygel_database_cursor_iterator_instance_init (RygelDatabaseCursorIterator * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_database_cursor_iterator_finalize (RygelDatabaseCursorIterator * obj)
{
	RygelDatabaseCursorIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_DATABASE_CURSOR_TYPE_ITERATOR, RygelDatabaseCursorIterator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->cursor);
}

 G_GNUC_NO_INLINE static GType
rygel_database_cursor_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_database_cursor_value_iterator_init, rygel_database_cursor_value_iterator_free_value, rygel_database_cursor_value_iterator_copy_value, rygel_database_cursor_value_iterator_peek_pointer, "p", rygel_database_cursor_value_iterator_collect_value, "p", rygel_database_cursor_value_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseCursorIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_cursor_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabaseCursorIterator), 0, (GInstanceInitFunc) rygel_database_cursor_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_database_cursor_iterator_type_id;
	rygel_database_cursor_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDatabaseCursorIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return rygel_database_cursor_iterator_type_id;
}

GType
rygel_database_cursor_iterator_get_type (void)
{
	static volatile gsize rygel_database_cursor_iterator_type_id__once = 0;
	if (g_once_init_enter (&rygel_database_cursor_iterator_type_id__once)) {
		GType rygel_database_cursor_iterator_type_id;
		rygel_database_cursor_iterator_type_id = rygel_database_cursor_iterator_get_type_once ();
		g_once_init_leave (&rygel_database_cursor_iterator_type_id__once, rygel_database_cursor_iterator_type_id);
	}
	return rygel_database_cursor_iterator_type_id__once;
}

gpointer
rygel_database_cursor_iterator_ref (gpointer instance)
{
	RygelDatabaseCursorIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_database_cursor_iterator_unref (gpointer instance)
{
	RygelDatabaseCursorIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DATABASE_CURSOR_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
rygel_database_cursor_class_init (RygelDatabaseCursorClass * klass,
                                  gpointer klass_data)
{
	rygel_database_cursor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDatabaseCursor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_database_cursor_finalize;
}

static void
rygel_database_cursor_instance_init (RygelDatabaseCursor * self,
                                     gpointer klass)
{
	self->priv = rygel_database_cursor_get_instance_private (self);
	self->priv->current_state = -1;
	self->priv->dirty = TRUE;
}

static void
rygel_database_cursor_finalize (GObject * obj)
{
	RygelDatabaseCursor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_DATABASE_TYPE_CURSOR, RygelDatabaseCursor);
	_sqlite3_finalize0 (self->priv->statement);
	G_OBJECT_CLASS (rygel_database_cursor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_database_cursor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabaseCursor), 0, (GInstanceInitFunc) rygel_database_cursor_instance_init, NULL };
	GType rygel_database_cursor_type_id;
	rygel_database_cursor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDatabaseCursor", &g_define_type_info, 0);
	RygelDatabaseCursor_private_offset = g_type_add_instance_private (rygel_database_cursor_type_id, sizeof (RygelDatabaseCursorPrivate));
	return rygel_database_cursor_type_id;
}

GType
rygel_database_cursor_get_type (void)
{
	static volatile gsize rygel_database_cursor_type_id__once = 0;
	if (g_once_init_enter (&rygel_database_cursor_type_id__once)) {
		GType rygel_database_cursor_type_id;
		rygel_database_cursor_type_id = rygel_database_cursor_get_type_once ();
		g_once_init_leave (&rygel_database_cursor_type_id__once, rygel_database_cursor_type_id);
	}
	return rygel_database_cursor_type_id__once;
}

