/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_dssetup.h"
#include "bin/default/librpc/gen_ndr/ndr_dssetup_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* dssetup - dcerpc server boilerplate generated by pidl */
static NTSTATUS dssetup__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DSSETUP_BIND
	return DCESRV_INTERFACE_DSSETUP_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void dssetup__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DSSETUP_UNBIND
	DCESRV_INTERFACE_DSSETUP_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS dssetup__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_dssetup.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_dssetup.calls[opnum].struct_size, "struct %s", ndr_table_dssetup.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_dssetup.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS dssetup__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* dssetup_DsRoleGetPrimaryDomainInformation */
		struct dssetup_DsRoleGetPrimaryDomainInformation *r2 = (struct dssetup_DsRoleGetPrimaryDomainInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetPrimaryDomainInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union dssetup_DsRoleInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _dssetup_DsRoleGetPrimaryDomainInformation(p, r2);
		break;
	}
	case 1: { /* dssetup_DsRoleDnsNameToFlatName */
		struct dssetup_DsRoleDnsNameToFlatName *r2 = (struct dssetup_DsRoleDnsNameToFlatName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDnsNameToFlatName, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleDnsNameToFlatName(p, r2);
		break;
	}
	case 2: { /* dssetup_DsRoleDcAsDc */
		struct dssetup_DsRoleDcAsDc *r2 = (struct dssetup_DsRoleDcAsDc *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDcAsDc, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleDcAsDc(p, r2);
		break;
	}
	case 3: { /* dssetup_DsRoleDcAsReplica */
		struct dssetup_DsRoleDcAsReplica *r2 = (struct dssetup_DsRoleDcAsReplica *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDcAsReplica, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleDcAsReplica(p, r2);
		break;
	}
	case 4: { /* dssetup_DsRoleDemoteDc */
		struct dssetup_DsRoleDemoteDc *r2 = (struct dssetup_DsRoleDemoteDc *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDemoteDc, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleDemoteDc(p, r2);
		break;
	}
	case 5: { /* dssetup_DsRoleGetDcOperationProgress */
		struct dssetup_DsRoleGetDcOperationProgress *r2 = (struct dssetup_DsRoleGetDcOperationProgress *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetDcOperationProgress, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleGetDcOperationProgress(p, r2);
		break;
	}
	case 6: { /* dssetup_DsRoleGetDcOperationResults */
		struct dssetup_DsRoleGetDcOperationResults *r2 = (struct dssetup_DsRoleGetDcOperationResults *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetDcOperationResults, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleGetDcOperationResults(p, r2);
		break;
	}
	case 7: { /* dssetup_DsRoleCancel */
		struct dssetup_DsRoleCancel *r2 = (struct dssetup_DsRoleCancel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleCancel, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleCancel(p, r2);
		break;
	}
	case 8: { /* dssetup_DsRoleServerSaveStateForUpgrade */
		struct dssetup_DsRoleServerSaveStateForUpgrade *r2 = (struct dssetup_DsRoleServerSaveStateForUpgrade *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleServerSaveStateForUpgrade, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleServerSaveStateForUpgrade(p, r2);
		break;
	}
	case 9: { /* dssetup_DsRoleUpgradeDownlevelServer */
		struct dssetup_DsRoleUpgradeDownlevelServer *r2 = (struct dssetup_DsRoleUpgradeDownlevelServer *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleUpgradeDownlevelServer, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleUpgradeDownlevelServer(p, r2);
		break;
	}
	case 10: { /* dssetup_DsRoleAbortDownlevelServerUpgrade */
		struct dssetup_DsRoleAbortDownlevelServerUpgrade *r2 = (struct dssetup_DsRoleAbortDownlevelServerUpgrade *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleAbortDownlevelServerUpgrade, NDR_IN, r2);
		}
		r2->out.result = _dssetup_DsRoleAbortDownlevelServerUpgrade(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS dssetup__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return dssetup__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS dssetup__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* dssetup_DsRoleGetPrimaryDomainInformation */
		struct dssetup_DsRoleGetPrimaryDomainInformation *r2 = (struct dssetup_DsRoleGetPrimaryDomainInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleGetPrimaryDomainInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetPrimaryDomainInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleGetPrimaryDomainInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* dssetup_DsRoleDnsNameToFlatName */
		struct dssetup_DsRoleDnsNameToFlatName *r2 = (struct dssetup_DsRoleDnsNameToFlatName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleDnsNameToFlatName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDnsNameToFlatName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleDnsNameToFlatName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* dssetup_DsRoleDcAsDc */
		struct dssetup_DsRoleDcAsDc *r2 = (struct dssetup_DsRoleDcAsDc *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleDcAsDc replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDcAsDc, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleDcAsDc\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* dssetup_DsRoleDcAsReplica */
		struct dssetup_DsRoleDcAsReplica *r2 = (struct dssetup_DsRoleDcAsReplica *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleDcAsReplica replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDcAsReplica, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleDcAsReplica\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* dssetup_DsRoleDemoteDc */
		struct dssetup_DsRoleDemoteDc *r2 = (struct dssetup_DsRoleDemoteDc *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleDemoteDc replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleDemoteDc, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleDemoteDc\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* dssetup_DsRoleGetDcOperationProgress */
		struct dssetup_DsRoleGetDcOperationProgress *r2 = (struct dssetup_DsRoleGetDcOperationProgress *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleGetDcOperationProgress replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetDcOperationProgress, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleGetDcOperationProgress\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* dssetup_DsRoleGetDcOperationResults */
		struct dssetup_DsRoleGetDcOperationResults *r2 = (struct dssetup_DsRoleGetDcOperationResults *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleGetDcOperationResults replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleGetDcOperationResults, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleGetDcOperationResults\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* dssetup_DsRoleCancel */
		struct dssetup_DsRoleCancel *r2 = (struct dssetup_DsRoleCancel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleCancel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleCancel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleCancel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* dssetup_DsRoleServerSaveStateForUpgrade */
		struct dssetup_DsRoleServerSaveStateForUpgrade *r2 = (struct dssetup_DsRoleServerSaveStateForUpgrade *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleServerSaveStateForUpgrade replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleServerSaveStateForUpgrade, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleServerSaveStateForUpgrade\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* dssetup_DsRoleUpgradeDownlevelServer */
		struct dssetup_DsRoleUpgradeDownlevelServer *r2 = (struct dssetup_DsRoleUpgradeDownlevelServer *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleUpgradeDownlevelServer replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleUpgradeDownlevelServer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleUpgradeDownlevelServer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* dssetup_DsRoleAbortDownlevelServerUpgrade */
		struct dssetup_DsRoleAbortDownlevelServerUpgrade *r2 = (struct dssetup_DsRoleAbortDownlevelServerUpgrade *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dssetup_DsRoleAbortDownlevelServerUpgrade replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dssetup_DsRoleAbortDownlevelServerUpgrade, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dssetup_DsRoleAbortDownlevelServerUpgrade\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS dssetup__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_dssetup.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS dssetup__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return dssetup__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_dssetup_interface = {
	.name      = "dssetup",
	.syntax_id = {{0x3919286a,0xb10c,0x11d0,{0x9b,0xa8},{0x00,0xc0,0x4f,0xd9,0x2e,0xf5}},0.0},
	.bind      = dssetup__op_bind,
	.unbind    = dssetup__op_unbind,
	.ndr_pull  = dssetup__op_ndr_pull,
	.dispatch  = dssetup__op_dispatch,
	.reply     = dssetup__op_reply,
	.ndr_push  = dssetup__op_ndr_push,
	.local     = dssetup__op_local,
#ifdef DCESRV_INTERFACE_DSSETUP_FLAGS
	.flags     = DCESRV_INTERFACE_DSSETUP_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS dssetup__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_DSSETUP_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_DSSETUP_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_dssetup.endpoints->count;i++) {
		const char *name = ndr_table_dssetup.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_dssetup_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS dssetup__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool dssetup__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_dssetup_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_dssetup_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_dssetup_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool dssetup__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_dssetup_interface.name, name)==0) {
		memcpy(iface, &dcesrv_dssetup_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server dssetup_ep_server = {
	/* fill in our name */
	.name = "dssetup",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_DSSETUP_INIT_SERVER
	.init_server = DCESRV_INTERFACE_DSSETUP_INIT_SERVER,
#else
	.init_server = dssetup__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_DSSETUP_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_DSSETUP_SHUTDOWN_SERVER,
#else
	.shutdown_server = dssetup__op_shutdown_server,
#endif
	.interface_by_uuid = dssetup__op_interface_by_uuid,
	.interface_by_name = dssetup__op_interface_by_name
};

const struct dcesrv_endpoint_server *dssetup_get_ep_server(void)
{
	return &dssetup_ep_server;
}
