#ifndef __SOURCE4_DSDB_COMMON_PROTO_H__
#define __SOURCE4_DSDB_COMMON_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/dsdb/common/util.c  */

int samdb_search_domain(struct ldb_context *sam_ldb,
			TALLOC_CTX *mem_ctx,
			struct ldb_dn *basedn,
			struct ldb_message ***res,
			const char * const *attrs,
			const struct dom_sid *domain_sid,
			const char *format, ...)  _PRINTF_ATTRIBUTE(7,8);
const char *samdb_search_string_v(struct ldb_context *sam_ldb,
				  TALLOC_CTX *mem_ctx,
				  struct ldb_dn *basedn,
				  const char *attr_name,
				  const char *format, va_list ap) _PRINTF_ATTRIBUTE(5,0);
const char *samdb_search_string(struct ldb_context *sam_ldb,
				TALLOC_CTX *mem_ctx,
				struct ldb_dn *basedn,
				const char *attr_name,
				const char *format, ...) _PRINTF_ATTRIBUTE(5,6);
struct ldb_dn *samdb_search_dn(struct ldb_context *sam_ldb,
			       TALLOC_CTX *mem_ctx,
			       struct ldb_dn *basedn,
			       const char *format, ...) _PRINTF_ATTRIBUTE(4,5);
struct dom_sid *samdb_search_dom_sid(struct ldb_context *sam_ldb,
				     TALLOC_CTX *mem_ctx,
				     struct ldb_dn *basedn,
				     const char *attr_name,
				     const char *format, ...) _PRINTF_ATTRIBUTE(5,6);
unsigned int samdb_search_uint(struct ldb_context *sam_ldb,
			 TALLOC_CTX *mem_ctx,
			 unsigned int default_value,
			 struct ldb_dn *basedn,
			 const char *attr_name,
			 const char *format, ...) _PRINTF_ATTRIBUTE(6,7);
int64_t samdb_search_int64(struct ldb_context *sam_ldb,
			   TALLOC_CTX *mem_ctx,
			   int64_t default_value,
			   struct ldb_dn *basedn,
			   const char *attr_name,
			   const char *format, ...) _PRINTF_ATTRIBUTE(6,7);
int samdb_search_string_multiple(struct ldb_context *sam_ldb,
				 TALLOC_CTX *mem_ctx,
				 struct ldb_dn *basedn,
				 const char ***strs,
				 const char *attr_name,
				 const char *format, ...) _PRINTF_ATTRIBUTE(6,7);
struct ldb_dn *samdb_result_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
			       const char *attr, struct ldb_dn *default_value);
uint32_t samdb_result_rid_from_sid(TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
				   const char *attr, uint32_t default_value);
struct dom_sid *samdb_result_dom_sid(TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
				     const char *attr);

/**
 * Makes an auth_SidAttr structure from a objectSid in a result set and a
 * supplied attribute value.
 *
 * @param [in] mem_ctx	Talloc memory context on which to allocate the auth_SidAttr.
 * @param [in] msg	The message from which to take the objectSid.
 * @param [in] attr	The attribute name, usually "objectSid".
 * @param [in] attrs	SE_GROUP_* flags to go with the SID.
 * @returns A pointer to the auth_SidAttr structure, or NULL on failure.
 */
struct auth_SidAttr *samdb_result_dom_sid_attrs(TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
						const char *attr, uint32_t attrs);
int samdb_result_dom_sid_buf(const struct ldb_message *msg,
			     const char *attr,
			     struct dom_sid *sid);
struct GUID samdb_result_guid(const struct ldb_message *msg, const char *attr);
struct dom_sid *samdb_result_sid_prefix(TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
					const char *attr);
NTTIME samdb_result_nttime(const struct ldb_message *msg, const char *attr,
			   NTTIME default_value);
NTTIME samdb_result_last_logoff(const struct ldb_message *msg);
NTTIME samdb_result_account_expires(const struct ldb_message *msg);
NTTIME samdb_result_allow_password_change(struct ldb_context *sam_ldb,
					  TALLOC_CTX *mem_ctx,
					  struct ldb_dn *domain_dn,
					  const struct ldb_message *msg,
					  const char *attr);
struct samr_Password *samdb_result_hash(TALLOC_CTX *mem_ctx, const struct ldb_message *msg, const char *attr);
unsigned int samdb_result_hashes(TALLOC_CTX *mem_ctx, const struct ldb_message *msg,
			   const char *attr, struct samr_Password **hashes);
NTSTATUS samdb_result_passwords_from_history(TALLOC_CTX *mem_ctx,
					     struct loadparm_context *lp_ctx,
					     const struct ldb_message *msg,
					     unsigned int idx,
					     const struct samr_Password **lm_pwd,
					     const struct samr_Password **nt_pwd);
NTSTATUS samdb_result_passwords_no_lockout(TALLOC_CTX *mem_ctx,
					   struct loadparm_context *lp_ctx,
					   const struct ldb_message *msg,
					   struct samr_Password **nt_pwd);
NTSTATUS samdb_result_passwords(TALLOC_CTX *mem_ctx,
				struct loadparm_context *lp_ctx,
				const struct ldb_message *msg,
				struct samr_Password **nt_pwd);
struct samr_LogonHours samdb_result_logon_hours(TALLOC_CTX *mem_ctx, struct ldb_message *msg, const char *attr);
uint32_t samdb_result_acct_flags(const struct ldb_message *msg, const char *attr);
NTSTATUS samdb_result_parameters(TALLOC_CTX *mem_ctx,
				 struct ldb_message *msg,
				 const char *attr,
				 struct lsa_BinaryString *s);
struct ldb_message_element *samdb_find_attribute(struct ldb_context *ldb,
						 const struct ldb_message *msg,
						 const char *name, const char *value);
int samdb_find_or_add_attribute(struct ldb_context *ldb, struct ldb_message *msg, const char *name, const char *set_value);
int samdb_msg_add_dom_sid(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			  const char *attr_name, const struct dom_sid *sid);
int samdb_msg_add_delete(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			 const char *attr_name);
int samdb_msg_add_addval(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx,
			 struct ldb_message *msg, const char *attr_name,
			 const char *value);
int samdb_msg_add_delval(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx,
			 struct ldb_message *msg, const char *attr_name,
			 const char *value);
int samdb_msg_add_int(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
		       const char *attr_name, int v);
int samdb_msg_add_int_flags(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			    const char *attr_name, int v, int flags);
int samdb_msg_add_uint(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
		       const char *attr_name, unsigned int v);
int samdb_msg_add_uint_flags(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			     const char *attr_name, unsigned int v, int flags);
int samdb_msg_add_int64(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			const char *attr_name, int64_t v);
int samdb_msg_add_uint64(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			const char *attr_name, uint64_t v);
int samdb_msg_append_int(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
		      const char *attr_name, int v, int flags);
int samdb_msg_append_uint(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			  const char *attr_name, unsigned int v, int flags);
int samdb_msg_append_int64(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			   const char *attr_name, int64_t v, int flags);
int samdb_msg_append_uint64(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			    const char *attr_name, uint64_t v, int flags);
int samdb_msg_add_hash(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
		       const char *attr_name, const struct samr_Password *hash);
int samdb_msg_add_hashes(struct ldb_context *ldb,
			 TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			 const char *attr_name, struct samr_Password *hashes,
			 unsigned int count);
int samdb_msg_add_acct_flags(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			     const char *attr_name, uint32_t v);
int samdb_msg_add_logon_hours(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			      const char *attr_name, struct samr_LogonHours *hours);
int samdb_msg_add_parameters(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx, struct ldb_message *msg,
			     const char *attr_name, struct lsa_BinaryString *parameters);
int samdb_msg_set_uint(struct ldb_context *sam_ldb, TALLOC_CTX *mem_ctx,
		       struct ldb_message *msg, const char *attr_name,
		       unsigned int v);
int dsdb_autotransaction_request(struct ldb_context *sam_ldb,
				 struct ldb_request *req);
struct security_descriptor *samdb_default_security_descriptor(TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_aggregate_schema_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_partitions_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_infrastructure_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_system_container_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_sites_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_extended_rights_dn(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_configuration_dn(struct ldb_context *sam_ctx,
				      TALLOC_CTX *mem_ctx,
				      const char *dn_str);
struct ldb_dn *samdb_gkdi_root_key_container_dn(struct ldb_context *sam_ctx,
						TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_gkdi_root_key_dn(struct ldb_context *sam_ctx,
				      TALLOC_CTX *mem_ctx,
				      const struct GUID *root_key_id);
const struct dom_sid *samdb_domain_sid(struct ldb_context *ldb);
const struct dom_sid *samdb_domain_sid_cache_only(struct ldb_context *ldb);
bool samdb_set_domain_sid(struct ldb_context *ldb, const struct dom_sid *dom_sid_in);
const struct GUID *samdb_domain_guid(struct ldb_context *ldb);
bool samdb_set_ntds_settings_dn(struct ldb_context *ldb, struct ldb_dn *ntds_settings_dn_in);
struct ldb_dn *samdb_ntds_settings_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
const struct GUID *samdb_ntds_objectGUID(struct ldb_context *ldb);
const struct GUID *samdb_ntds_invocation_id(struct ldb_context *ldb);
bool samdb_set_ntds_objectGUID(struct ldb_context *ldb, const struct GUID *ntds_guid_in);
bool samdb_set_ntds_invocation_id(struct ldb_context *ldb, const struct GUID *invocation_id_in);
struct ldb_dn *samdb_server_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
struct ldb_dn *samdb_server_site_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
int samdb_find_site_for_computer(struct ldb_context *ldb,
				 TALLOC_CTX *mem_ctx, struct ldb_dn *computer_dn,
				 const char **site_name);
int samdb_find_ntdsguid_for_computer(struct ldb_context *ldb, struct ldb_dn *computer_dn,
				     struct GUID *ntds_guid);
int samdb_reference_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct ldb_dn *base,
		       const char *attribute, struct ldb_dn **dn);
int samdb_dn_is_our_ntdsa(struct ldb_context *ldb, struct ldb_dn *dn, bool *is_ntdsa);
int samdb_reference_dn_is_our_ntdsa(struct ldb_context *ldb, struct ldb_dn *base,
				    const char *attribute, bool *is_ntdsa);
int samdb_server_reference_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct ldb_dn **dn);
int samdb_rid_manager_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct ldb_dn **dn);
int samdb_rid_set_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct ldb_dn **dn);
const char *samdb_server_site_name(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
const char *samdb_client_site_name(struct ldb_context *ldb, TALLOC_CTX *mem_ctx,
				   const char *ip_address, char **subnet_name,
				   bool fallback);
bool samdb_is_pdc(struct ldb_context *ldb);
bool samdb_is_gc(struct ldb_context *ldb);
int samdb_search_for_parent_domain(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, struct ldb_dn *dn,
				   struct ldb_dn **parent_dn, const char **errstring);
enum samr_ValidationStatus samdb_check_password(TALLOC_CTX *mem_ctx,
						struct loadparm_context *lp_ctx,
						const char *account_name,
						const char *user_principal_name,
						const char *full_name,
						const DATA_BLOB *utf8_blob,
						const uint32_t pwdProperties,
						const uint32_t minPwdLength);
int samdb_set_password_callback(struct ldb_request *req, struct ldb_reply *ares);
NTSTATUS samdb_set_password(struct ldb_context *ldb, TALLOC_CTX *mem_ctx,
			    struct ldb_dn *user_dn,
			    const DATA_BLOB *new_password,
			    const struct samr_Password *ntNewHash,
			    enum dsdb_password_checked old_password_checked,
			    enum samPwdChangeReason *reject_reason,
			    struct samr_DomInfo1 **_dominfo);
NTSTATUS samdb_set_password_sid(struct ldb_context *ldb, TALLOC_CTX *mem_ctx,
				const struct dom_sid *user_sid,
				const uint32_t *new_version, /* optional for trusts */
				const DATA_BLOB *new_password,
				const struct samr_Password *ntNewHash,
				enum dsdb_password_checked old_password_checked,
				enum samPwdChangeReason *reject_reason,
				struct samr_DomInfo1 **_dominfo);
NTSTATUS samdb_create_foreign_security_principal(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx,
						 struct dom_sid *sid, struct ldb_dn **ret_dn);
struct ldb_dn *samdb_dns_domain_to_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx, const char *dns_domain);
char *samdb_dn_to_dns_domain(TALLOC_CTX *mem_ctx, struct ldb_dn *dn);
char *samdb_ntds_msdcs_dns_name(struct ldb_context *samdb,
				TALLOC_CTX *mem_ctx,
				const struct GUID *ntds_guid);
struct ldb_dn *samdb_domain_to_dn(struct ldb_context *ldb, TALLOC_CTX *mem_ctx,
				  const char *domain_name);
int dsdb_find_dn_by_guid(struct ldb_context *ldb,
			 TALLOC_CTX *mem_ctx,
			 const struct GUID *guid,
			 uint32_t dsdb_flags,
			 struct ldb_dn **dn);
int dsdb_find_guid_attr_by_dn(struct ldb_context *ldb,
			      struct ldb_dn *dn, const char *attribute,
			      struct GUID *guid);
int dsdb_find_guid_by_dn(struct ldb_context *ldb,
			 struct ldb_dn *dn, struct GUID *guid);
int dsdb_msg_add_guid(struct ldb_message *msg,
		struct GUID *guid,
		const char *attr_name);
int dsdb_find_sid_by_dn(struct ldb_context *ldb,
			struct ldb_dn *dn, struct dom_sid *sid);
int dsdb_find_dn_by_sid(struct ldb_context *ldb,
			TALLOC_CTX *mem_ctx,
			struct dom_sid *sid, struct ldb_dn **dn);
WERROR dsdb_loadreps(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx, struct ldb_dn *dn,
		     const char *attr, struct repsFromToBlob **r, uint32_t *count);
WERROR dsdb_savereps(struct ldb_context *sam_ctx, TALLOC_CTX *mem_ctx, struct ldb_dn *dn,
		     const char *attr, struct repsFromToBlob *r, uint32_t count);
int dsdb_load_partition_usn(struct ldb_context *ldb, struct ldb_dn *dn,
				uint64_t *uSN, uint64_t *urgent_uSN);
int drsuapi_DsReplicaCursor2_compare(const struct drsuapi_DsReplicaCursor2 *c1,
						   const struct drsuapi_DsReplicaCursor2 *c2);
int drsuapi_DsReplicaCursor_compare(const struct drsuapi_DsReplicaCursor *c1,
				    const struct drsuapi_DsReplicaCursor *c2);
int samdb_get_ntds_obj_by_guid(TALLOC_CTX *mem_ctx,
			       struct ldb_context *sam_ctx,
			       const struct GUID *objectGUID,
			       const char **attrs,
			       struct ldb_message **msg);
int samdb_is_rodc(struct ldb_context *sam_ctx, const struct GUID *objectGUID, bool *is_rodc);
int samdb_rodc(struct ldb_context *sam_ctx, bool *am_rodc);
int samdb_dns_host_name(struct ldb_context *sam_ctx, const char **host_name);
bool samdb_set_am_rodc(struct ldb_context *ldb, bool am_rodc);
int samdb_ntds_site_settings_options(struct ldb_context *ldb_ctx,
					uint32_t *options);
int samdb_ntds_options(struct ldb_context *ldb, uint32_t *options);
const char* samdb_ntds_object_category(TALLOC_CTX *tmp_ctx, struct ldb_context *ldb);
const char *samdb_cn_to_lDAPDisplayName(TALLOC_CTX *mem_ctx, const char *cn);
int dsdb_functional_level(struct ldb_context *ldb);
int dsdb_forest_functional_level(struct ldb_context *ldb);
int dsdb_dc_functional_level(struct ldb_context *ldb);
const char *dsdb_dc_operatingSystemVersion(int dc_functional_level);
int dsdb_check_and_update_fl(struct ldb_context *ldb_ctx, struct loadparm_context *lp_ctx);
int dsdb_set_extended_dn_guid(struct ldb_dn *dn, const struct GUID *guid, const char *component_name);
NTSTATUS dsdb_get_extended_dn_guid(struct ldb_dn *dn, struct GUID *guid, const char *component_name);
NTSTATUS dsdb_get_extended_dn_uint64(struct ldb_dn *dn, uint64_t *val, const char *component_name);
NTSTATUS dsdb_get_extended_dn_nttime(struct ldb_dn *dn, NTTIME *nttime, const char *component_name);
NTSTATUS dsdb_get_extended_dn_uint32(struct ldb_dn *dn, uint32_t *val, const char *component_name);
NTSTATUS dsdb_get_extended_dn_sid(struct ldb_dn *dn, struct dom_sid *sid, const char *component_name);
uint32_t dsdb_dn_rmd_flags(struct ldb_dn *dn);
uint32_t dsdb_dn_val_rmd_flags(const struct ldb_val *val);
bool dsdb_dn_is_deleted_val(const struct ldb_val *val);
bool dsdb_dn_is_upgraded_link_val(const struct ldb_val *val);
int dsdb_wellknown_dn(struct ldb_context *samdb, TALLOC_CTX *mem_ctx,
		      struct ldb_dn *nc_root, const char *wk_guid,
		      struct ldb_dn **wkguid_dn);
int dsdb_normalise_dn_and_find_nc_root(struct ldb_context *samdb,
				       TALLOC_CTX *mem_ctx,
				       struct ldb_dn *dn,
				       struct ldb_dn **normalised_dn,
				       struct ldb_dn **nc_root);
int dsdb_find_nc_root(struct ldb_context *samdb,
		      TALLOC_CTX *mem_ctx,
		      struct ldb_dn *dn,
		      struct ldb_dn **nc_root);
int dsdb_get_deleted_objects_dn(struct ldb_context *ldb,
				TALLOC_CTX *mem_ctx, struct ldb_dn *obj_dn,
				struct ldb_dn **do_dn);
int dsdb_tombstone_lifetime(struct ldb_context *ldb, uint32_t *lifetime);
int samdb_ldb_val_case_cmp(const char *s, struct ldb_val *v);
int dsdb_load_udv_v2(struct ldb_context *samdb, struct ldb_dn *dn, TALLOC_CTX *mem_ctx,
		     struct drsuapi_DsReplicaCursor2 **cursors, uint32_t *count);
int dsdb_load_udv_v1(struct ldb_context *samdb, struct ldb_dn *dn, TALLOC_CTX *mem_ctx,
		     struct drsuapi_DsReplicaCursor **cursors, uint32_t *count);
int dsdb_request_add_controls(struct ldb_request *req, uint32_t dsdb_flags);
bool dsdb_request_has_control(struct ldb_request *req, const char *oid);
int dsdb_add(struct ldb_context *ldb, const struct ldb_message *message,
	     uint32_t dsdb_flags);
int dsdb_modify(struct ldb_context *ldb, const struct ldb_message *message,
		uint32_t dsdb_flags);
int dsdb_delete(struct ldb_context *ldb, struct ldb_dn *dn,
		uint32_t dsdb_flags);
int dsdb_replace(struct ldb_context *ldb, struct ldb_message *msg, uint32_t dsdb_flags);
const char *dsdb_search_scope_as_string(enum ldb_scope scope);
int dsdb_search_dn(struct ldb_context *ldb,
		   TALLOC_CTX *mem_ctx,
		   struct ldb_result **_result,
		   struct ldb_dn *basedn,
		   const char * const *attrs,
		   uint32_t dsdb_flags);
int dsdb_search_by_dn_guid(struct ldb_context *ldb,
			   TALLOC_CTX *mem_ctx,
			   struct ldb_result **_result,
			   const struct GUID *guid,
			   const char * const *attrs,
			   uint32_t dsdb_flags);
NTSTATUS gmsa_system_password_update_request(
	struct ldb_context *ldb,
	TALLOC_CTX *mem_ctx,
	struct ldb_dn *dn,
	const uint8_t
		password_buf[static const GMSA_PASSWORD_NULL_TERMINATED_LEN],
	struct ldb_request **request_out);
int dsdb_search(struct ldb_context *ldb,
		TALLOC_CTX *mem_ctx,
		struct ldb_result **_result,
		struct ldb_dn *basedn,
		enum ldb_scope scope,
		const char * const *attrs,
		uint32_t dsdb_flags,
		const char *exp_fmt, ...) _PRINTF_ATTRIBUTE(8, 9);
int dsdb_search_one(struct ldb_context *ldb,
		    TALLOC_CTX *mem_ctx,
		    struct ldb_message **msg,
		    struct ldb_dn *basedn,
		    enum ldb_scope scope,
		    const char * const *attrs,
		    uint32_t dsdb_flags,
		    const char *exp_fmt, ...) _PRINTF_ATTRIBUTE(8, 9);
const char *samdb_forest_name(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
const char *samdb_default_domain_name(struct ldb_context *ldb, TALLOC_CTX *mem_ctx);
int dsdb_validate_dsa_guid(struct ldb_context *ldb,
			   const struct GUID *dsa_guid,
			   const struct dom_sid *sid);
bool dsdb_attr_in_rodc_fas(const struct dsdb_attribute *sa);
WERROR dsdb_get_fsmo_role_info(TALLOC_CTX *tmp_ctx,
			       struct ldb_context *ldb,
			       uint32_t role,
			       struct ldb_dn **fsmo_role_dn,
			       struct ldb_dn **role_owner_dn);
const char *samdb_dn_to_dnshostname(struct ldb_context *ldb,
				    TALLOC_CTX *mem_ctx,
				    struct ldb_dn *server_dn);
bool dsdb_attr_in_parse_tree(struct ldb_parse_tree *tree,
			     const char *attr);
int dsdb_werror_at(struct ldb_context *ldb, int ldb_ecode, WERROR werr,
		   const char *location, const char *func,
		   const char *reason);
NTSTATUS dsdb_ldb_err_to_ntstatus(int err);
int dsdb_create_partial_replica_NC(struct ldb_context *ldb,  struct ldb_dn *dn);
int dsdb_effective_badPwdCount(const struct ldb_message *user_msg,
			       int64_t lockOutObservationWindow,
			       NTTIME now);
int64_t samdb_result_msds_LockoutObservationWindow(
	struct ldb_context *sam_ldb,
	TALLOC_CTX *mem_ctx,
	struct ldb_dn *domain_dn,
	const struct ldb_message *user_msg);
int samdb_result_effective_badPwdCount(struct ldb_context *sam_ldb,
				       TALLOC_CTX *mem_ctx,
				       struct ldb_dn *domain_dn,
				       const struct ldb_message *user_msg);
NTSTATUS dsdb_update_bad_pwd_count(TALLOC_CTX *mem_ctx,
				   struct ldb_context *sam_ctx,
				   struct ldb_message *user_msg,
				   struct ldb_message *domain_msg,
				   struct ldb_message *pso_msg,
				   struct ldb_message **_mod_msg);

/**
 * Sets defaults for a User object
 * List of default attributes set:
 * 	accountExpires, badPasswordTime, badPwdCount,
 * 	codePage, countryCode, lastLogoff, lastLogon
 * 	logonCount, pwdLastSet
 */
int dsdb_user_obj_set_defaults(struct ldb_context *ldb,
			       struct ldb_message *usr_obj,
			       struct ldb_request *req);

/**
 * Sets 'sAMAccountType on user object based on userAccountControl.
 * This function is used in processing both 'add' and 'modify' requests.
 * @param ldb Current ldb_context
 * @param usr_obj ldb_message representing User object
 * @param user_account_control Value for userAccountControl flags
 * @param account_type_p Optional pointer to account_type to return
 * @return LDB_SUCCESS or LDB_ERR* code on failure
 */
int dsdb_user_obj_set_account_type(struct ldb_context *ldb, struct ldb_message *usr_obj,
				   uint32_t user_account_control, uint32_t *account_type_p);

/**
 * Determine and set primaryGroupID based on userAccountControl value.
 * This function is used in processing both 'add' and 'modify' requests.
 * @param ldb Current ldb_context
 * @param usr_obj ldb_message representing User object
 * @param user_account_control Value for userAccountControl flags
 * @param group_rid_p Optional pointer to group RID to return
 * @return LDB_SUCCESS or LDB_ERR* code on failure
 */
int dsdb_user_obj_set_primary_group_id(struct ldb_context *ldb, struct ldb_message *usr_obj,
				       uint32_t user_account_control, uint32_t *group_rid_p);

/**
 * Returns True if the source and target DNs both have the same naming context,
 * i.e. they're both in the same partition.
 */
bool dsdb_objects_have_same_nc(struct ldb_context *ldb,
			       TALLOC_CTX *mem_ctx,
			       struct ldb_dn *source_dn,
			       struct ldb_dn *target_dn);
int PRINTF_ATTRIBUTE(6, 7) dsdb_domain_count(
	struct ldb_context *ldb,
	size_t *count,
	struct ldb_dn *base,
	struct dom_sid *dom_sid,
	enum ldb_scope scope,
	const char *exp_fmt, ...);
int dsdb_is_protected_user(struct ldb_context *ldb,
			   const struct auth_SidAttr *sids,
			   uint32_t num_sids);
bool dsdb_account_is_trust(const struct ldb_message *msg);

/* The following definitions come from ../../source4/dsdb/common/util_trusts.c  */

NTSTATUS dsdb_trust_local_tdo_info(TALLOC_CTX *mem_ctx,
				   struct ldb_context *sam_ctx,
				   struct lsa_TrustDomainInfoInfoEx **_tdo);
NTSTATUS dsdb_trust_xref_tdo_info(TALLOC_CTX *mem_ctx,
				  struct ldb_context *sam_ctx,
				  struct lsa_TrustDomainInfoInfoEx **_tdo);
NTSTATUS dsdb_trust_xref_forest_info(TALLOC_CTX *mem_ctx,
				     struct ldb_context *sam_ctx,
				     struct lsa_ForestTrustInformation2 **_info);
NTSTATUS dsdb_trust_parse_tdo_info(TALLOC_CTX *mem_ctx,
				   struct ldb_message *m,
				   struct lsa_TrustDomainInfoInfoEx **_tdo);
NTSTATUS dsdb_trust_parse_forest_info(TALLOC_CTX *mem_ctx,
				      struct ldb_message *m,
				      struct ForestTrustInfo **_fti);
NTSTATUS dsdb_trust_default_forest_info(TALLOC_CTX *mem_ctx,
					const struct dom_sid *sid,
					const char *dns_name,
					const char *nbt_name,
					NTTIME now,
					struct ForestTrustInfo **_fti);
NTSTATUS dsdb_trust_normalize_forest_info_step1(TALLOC_CTX *mem_ctx,
				const struct lsa_ForestTrustInformation2 *gfti,
				struct lsa_ForestTrustInformation2 **_nfti);
NTSTATUS dsdb_trust_normalize_forest_info_step2(TALLOC_CTX *mem_ctx,
				const struct lsa_ForestTrustInformation2 *gfti,
				struct lsa_ForestTrustInformation2 **_nfti);
NTSTATUS dsdb_trust_verify_forest_info(const struct lsa_TrustDomainInfoInfoEx *ref_tdo,
				const struct lsa_ForestTrustInformation2 *ref_fti,
				enum lsa_ForestTrustCollisionRecordType collision_type,
				struct lsa_ForestTrustCollisionInfo *c_info,
				struct lsa_ForestTrustInformation2 *new_fti);
NTSTATUS dsdb_trust_merge_forest_info(TALLOC_CTX *mem_ctx,
				const struct lsa_TrustDomainInfoInfoEx *tdo,
				const struct lsa_ForestTrustInformation2 *ofti,
				const struct lsa_ForestTrustInformation2 *nfti,
				struct lsa_ForestTrustInformation2 **_mfti);
NTSTATUS dsdb_trust_search_tdo(struct ldb_context *sam_ctx,
			       const char *netbios, const char *dns,
			       const char * const *attrs,
			       TALLOC_CTX *mem_ctx,
			       struct ldb_message **msg);
NTSTATUS dsdb_trust_search_tdo_by_type(struct ldb_context *sam_ctx,
				       enum netr_SchannelType type,
				       const char *name,
				       const char * const *attrs,
				       TALLOC_CTX *mem_ctx,
				       struct ldb_message **msg);
NTSTATUS dsdb_trust_search_tdo_by_sid(struct ldb_context *sam_ctx,
				      const struct dom_sid *sid,
				      const char * const *attrs,
				      TALLOC_CTX *mem_ctx,
				      struct ldb_message **msg);
NTSTATUS dsdb_trust_get_incoming_passwords(const struct ldb_message *msg,
					   TALLOC_CTX *mem_ctx,
					   struct samr_Password **_current,
					   struct samr_Password **_previous);
NTSTATUS dsdb_trust_search_tdos(struct ldb_context *sam_ctx,
				const char *exclude,
				const char * const *attrs,
				TALLOC_CTX *mem_ctx,
				struct ldb_result **res);
NTSTATUS dsdb_trust_routing_table_load(struct ldb_context *sam_ctx,
				       TALLOC_CTX *mem_ctx,
				       struct dsdb_trust_routing_table **_table);
const struct lsa_TrustDomainInfoInfoEx *dsdb_trust_routing_by_name(
		const struct dsdb_trust_routing_table *table,
		const char *name);
const struct lsa_TrustDomainInfoInfoEx *dsdb_trust_domain_by_sid(
		const struct dsdb_trust_routing_table *table,
		const struct dom_sid *sid,
		const struct lsa_ForestTrustDomainInfo **pdi);
const struct lsa_TrustDomainInfoInfoEx *dsdb_trust_domain_by_name(
		const struct dsdb_trust_routing_table *table,
		const char *name,
		const struct lsa_ForestTrustDomainInfo **pdi);
NTSTATUS dsdb_trust_get_claims_tf_policy(struct ldb_context *samldb,
					 const struct ldb_message *tdo_msg,
					 const char *tdo_attr,
					 TALLOC_CTX *mem_ctx,
					 struct claims_tf_rule_set **_rule_set);

/* The following definitions come from ../../source4/dsdb/common/util_groups.c  */

NTSTATUS dsdb_expand_nested_groups(struct ldb_context *sam_ctx,
				   struct ldb_val *dn_val, const bool only_childs, const char *filter,
				   TALLOC_CTX *res_sids_ctx, struct auth_SidAttr **res_sids,
				   uint32_t *num_res_sids);

/* The following definitions come from ../../source4/dsdb/common/util_samr.c  */

NTSTATUS dsdb_add_user(struct ldb_context *ldb,
		       TALLOC_CTX *mem_ctx,
		       const char *account_name,
		       uint32_t acct_flags,
		       const struct dom_sid *forced_sid,
		       struct dom_sid **sid,
		       struct ldb_dn **dn);
NTSTATUS dsdb_add_domain_group(struct ldb_context *ldb,
			       TALLOC_CTX *mem_ctx,
			       const char *groupname,
			       struct dom_sid **sid,
			       struct ldb_dn **dn);
NTSTATUS dsdb_add_domain_alias(struct ldb_context *ldb,
			       TALLOC_CTX *mem_ctx,
			       const char *alias_name,
			       struct dom_sid **sid,
			       struct ldb_dn **dn);
NTSTATUS dsdb_enum_group_mem(struct ldb_context *ldb,
			     TALLOC_CTX *mem_ctx,
			     struct ldb_dn *dn,
			     struct dom_sid **members_out,
			     unsigned int *pnum_members);
NTSTATUS dsdb_lookup_rids(struct ldb_context *ldb,
			  TALLOC_CTX *mem_ctx,
			  const struct dom_sid *domain_sid,
			  unsigned int num_rids,
			  uint32_t *rids,
			  const char **names,
			  enum lsa_SidType *lsa_attrs);

/* The following definitions come from ../../source4/dsdb/common/dsdb_dn.c  */

enum dsdb_dn_format dsdb_dn_oid_to_format(const char *oid) ;
struct dsdb_dn *dsdb_dn_construct(TALLOC_CTX *mem_ctx, struct ldb_dn *dn, DATA_BLOB extra_part, 
				  const char *oid) ;
struct dsdb_dn *dsdb_dn_parse_trusted(TALLOC_CTX *mem_ctx, struct ldb_context *ldb, 
				      const struct ldb_val *dn_blob, const char *dn_oid);
struct dsdb_dn *dsdb_dn_parse(TALLOC_CTX *mem_ctx, struct ldb_context *ldb, 
			      const struct ldb_val *dn_blob, const char *dn_oid);
char *dsdb_dn_get_linearized(TALLOC_CTX *mem_ctx, 
			      struct dsdb_dn *dsdb_dn);
char *dsdb_dn_get_casefold(TALLOC_CTX *mem_ctx, 
			   struct dsdb_dn *dsdb_dn) ;
char *dsdb_dn_get_extended_linearized(TALLOC_CTX *mem_ctx, 
				      struct dsdb_dn *dsdb_dn,
				      int mode);
int dsdb_dn_binary_canonicalise(struct ldb_context *ldb, void *mem_ctx,
				const struct ldb_val *in, struct ldb_val *out);
int dsdb_dn_binary_comparison(struct ldb_context *ldb, void *mem_ctx,
				     const struct ldb_val *v1,
				     const struct ldb_val *v2);
int dsdb_dn_string_canonicalise(struct ldb_context *ldb, void *mem_ctx,
				const struct ldb_val *in, struct ldb_val *out);
int dsdb_dn_string_comparison(struct ldb_context *ldb, void *mem_ctx,
				     const struct ldb_val *v1,
				     const struct ldb_val *v2);
char *drs_ObjectIdentifier_to_debug_string(TALLOC_CTX *mem_ctx,
					   struct drsuapi_DsReplicaObjectIdentifier *nc);
int drs_ObjectIdentifier_to_dn_and_nc_root(TALLOC_CTX *mem_ctx,
					   struct ldb_context *ldb,
					   struct drsuapi_DsReplicaObjectIdentifier *nc,
					   struct ldb_dn **normalised_dn,
					   struct ldb_dn **nc_root);

/* The following definitions come from ../../source4/dsdb/common/dsdb_access.c  */

void dsdb_acl_debug(struct security_descriptor *sd,
		      struct security_token *token,
		      struct ldb_dn *dn,
		      bool denied,
		      int level);
int dsdb_get_sd_from_ldb_message(struct ldb_context *ldb,
				 TALLOC_CTX *mem_ctx,
				 struct ldb_message *acl_res,
				 struct security_descriptor **sd);
int dsdb_check_access_on_dn_internal(struct ldb_context *ldb,
				     struct ldb_result *acl_res,
				     TALLOC_CTX *mem_ctx,
				     struct security_token *token,
				     struct ldb_dn *dn,
				     uint32_t access_mask,
				     const struct GUID *guid);
int dsdb_check_access_on_dn(struct ldb_context *ldb,
			    TALLOC_CTX *mem_ctx,
			    struct ldb_dn *dn,
			    struct security_token *token,
			    uint32_t access_mask,
			    const char *ext_right);

/* The following definitions come from ../../source4/dsdb/common/util_links.c  */

int ndr_guid_compare(const struct GUID *guid1, const struct GUID *guid2);
int really_parse_trusted_dn(TALLOC_CTX *mem_ctx, struct ldb_context *ldb,
				   struct parsed_dn *pdn, const char *ldap_oid);
int get_parsed_dns_trusted(TALLOC_CTX *mem_ctx, struct ldb_message_element *el,
				  struct parsed_dn **pdn);
int parsed_dn_find(struct ldb_context *ldb, struct parsed_dn *pdn,
		   unsigned int count,
		   const struct GUID *guid,
		   struct ldb_dn *target_dn,
		   DATA_BLOB extra_part,
		   size_t partial_extra_part_length,
		   struct parsed_dn **exact,
		   struct parsed_dn **next,
		   const char *ldap_oid,
		   bool compare_extra_part);

/* The following definitions come from ../../source4/dsdb/common/rodc_helper.c  */

WERROR samdb_result_sid_array_dn(struct ldb_context *sam_ctx,
				 const struct ldb_message *msg,
				 TALLOC_CTX *mem_ctx,
				 const char *attr,
				 uint32_t *num_sids,
				 struct dom_sid **sids);
WERROR samdb_confirm_rodc_allowed_to_repl_to_sid_list(struct ldb_context *sam_ctx,
						      const struct dom_sid *rodc_machine_account_sid,
						      const struct ldb_message *rodc_msg,
						      const struct ldb_message *obj_msg,
						      uint32_t num_token_sids,
						      const struct dom_sid *token_sids);
WERROR samdb_confirm_rodc_allowed_to_repl_to(struct ldb_context *sam_ctx,
					     const struct dom_sid *rodc_machine_account_sid,
					     struct ldb_message *rodc_msg,
					     struct ldb_message *obj_msg);

/* The following definitions come from ../../source4/dsdb/gmsa/gkdi.c  */

NTSTATUS gkdi_root_key_from_msg(TALLOC_CTX *mem_ctx,
				const struct GUID root_key_id,
				const struct ldb_message *const msg,
				const struct ProvRootKey **const root_key_out);
NTTIME gkdi_root_key_use_start_time(const NTTIME current_time);
int gkdi_new_root_key(TALLOC_CTX *mem_ctx,
		      struct ldb_context *const ldb,
		      const NTTIME current_time,
		      const NTTIME use_start_time,
		      struct GUID *const root_key_id_out,
		      const struct ldb_message **const root_key_out);
int gkdi_root_key_from_id(TALLOC_CTX *mem_ctx,
			  struct ldb_context *const ldb,
			  const struct GUID *const root_key_id,
			  const struct ldb_message **const root_key_out);
int gkdi_most_recently_created_root_key(
	TALLOC_CTX *mem_ctx,
	struct ldb_context *const ldb,
	_UNUSED_ const NTTIME current_time,
	const NTTIME not_after,
	struct GUID *const root_key_id_out,
	const struct ldb_message **const root_key_out);

/* The following definitions come from ../../source4/dsdb/gmsa/util.c  */

int gmsa_allowed_to_view_managed_password(TALLOC_CTX *mem_ctx,
					  struct ldb_context *ldb,
					  const struct ldb_message *msg,
					  const struct dom_sid *account_sid,
					  bool *allowed_out);
void gmsa_update_managed_pwd_id(struct KeyEnvelope *pwd_id,
				const struct gmsa_update_pwd_part *new_pwd);
NTSTATUS gmsa_pack_managed_pwd_id(TALLOC_CTX *mem_ctx,
				  const struct KeyEnvelope *pwd_id,
				  DATA_BLOB *pwd_id_out);
int gmsa_generate_blobs(struct ldb_context *ldb,
			TALLOC_CTX *mem_ctx,
			const NTTIME current_time,
			const struct dom_sid *const account_sid,
			DATA_BLOB *pwd_id_blob_out,
			struct gmsa_null_terminated_password **password_out);
NTSTATUS gmsa_pack_managed_pwd(TALLOC_CTX *mem_ctx,
			       const uint8_t *new_password,
			       const uint8_t *old_password,
			       uint64_t query_interval,
			       uint64_t unchanged_interval,
			       DATA_BLOB *managed_pwd_out);
bool dsdb_account_is_gmsa(struct ldb_context *ldb,
			  const struct ldb_message *msg);
const struct KeyEnvelopeId *gmsa_get_managed_pwd_id(
	const struct ldb_message *msg,
	struct KeyEnvelopeId *key_env_out);
bool samdb_gmsa_key_is_recent(const struct ldb_message *msg,
			      const NTTIME current_time);
int gmsa_recalculate_managed_pwd(TALLOC_CTX *mem_ctx,
				 struct ldb_context *ldb,
				 const struct ldb_message *msg,
				 const NTTIME current_time,
				 struct gmsa_update **update_out,
				 struct gmsa_return_pwd *return_out);
int dsdb_update_gmsa_entry_keys(TALLOC_CTX *mem_ctx,
				struct ldb_context *ldb,
				const struct gmsa_update *gmsa_update);
int dsdb_update_gmsa_keys(TALLOC_CTX *mem_ctx,
			  struct ldb_context *ldb,
			  const struct ldb_result *res,
			  bool *retry_out);
bool dsdb_gmsa_current_time(struct ldb_context *ldb, NTTIME *current_time_out);
bool dsdb_gmsa_set_current_time(struct ldb_context *ldb, unsigned long long *current_time_talloc);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_DSDB_COMMON_PROTO_H__ */

