/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkBinaryReconstructionByDilationImageFilter.h"
#include "itkBinaryReconstructionByDilationImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
BinaryReconstructionByDilationImageFilter::BinaryReconstructionByDilationImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
BinaryReconstructionByDilationImageFilter::~BinaryReconstructionByDilationImageFilter() = default;



//
// ToString
//
std::string BinaryReconstructionByDilationImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::BinaryReconstructionByDilationImageFilter\n";
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  ForegroundValue: ";
  this->ToStringHelper(out, this->m_ForegroundValue);
  out << std::endl;
  out << "  FullyConnected: ";
  this->ToStringHelper(out, this->m_FullyConnected);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image BinaryReconstructionByDilationImageFilter::Execute ( const Image & markerImage, const Image & maskImage )
{
  const PixelIDValueEnum type = markerImage.GetPixelID();
  const unsigned int dimension = markerImage.GetDimension();
  CheckImageMatchingDimension(  markerImage, maskImage, "maskImage" );
  CheckImageMatchingSize(  markerImage, maskImage, "maskImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &markerImage, &maskImage );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image BinaryReconstructionByDilationImageFilter::ExecuteInternal ( const Image * inMarkerImage, const Image * inMaskImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::BinaryReconstructionByDilationImageFilter<InputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inMarkerImage != nullptr );
  filter->SetMarkerImage( this->CastImageToITK<typename FilterType::InputImageType>(*inMarkerImage) );
  assert( inMaskImage != nullptr );
  filter->SetMaskImage( this->CastImageToITK<typename FilterType::InputImageType>(*inMaskImage) );


  filter->SetBackgroundValue ( static_cast< typename InputImageType::PixelType> ( this->m_BackgroundValue ) );
  filter->SetForegroundValue ( static_cast< typename InputImageType::PixelType> ( this->m_ForegroundValue ) );
  filter->SetFullyConnected ( this->m_FullyConnected );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image BinaryReconstructionByDilation ( const Image & markerImage, const Image & maskImage, double backgroundValue, double foregroundValue, bool fullyConnected )
{
  BinaryReconstructionByDilationImageFilter filter;
  filter.SetBackgroundValue( backgroundValue );  filter.SetForegroundValue( foregroundValue );  filter.SetFullyConnected( fullyConnected );
  return filter.Execute ( markerImage, maskImage );
}


}
