/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkFastMarchingUpwindGradientImageFilter.h"
#include "itkFastMarchingUpwindGradientImageFilter.h"

// Additional include files
#include "sitkImageConvert.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
FastMarchingUpwindGradientImageFilter::FastMarchingUpwindGradientImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
FastMarchingUpwindGradientImageFilter::~FastMarchingUpwindGradientImageFilter() = default;



//
// ToString
//
std::string FastMarchingUpwindGradientImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::FastMarchingUpwindGradientImageFilter\n";
  out << "  TrialPoints: ";
  out << "[ ";
  for (unsigned int i = 0; i + 1 < m_TrialPoints.size(); ++i)
    {
    this->ToStringHelper(out, this->m_TrialPoints[i]);
    out << ", ";
    }
  if ( !this->m_TrialPoints.empty() ) out << this->m_TrialPoints.back() << ' ';
  out << "]";  out << std::endl;
  out << "  NumberOfTargets: ";
  this->ToStringHelper(out, this->m_NumberOfTargets);
  out << std::endl;
  out << "  TargetPoints: ";
  out << "[ ";
  for (unsigned int i = 0; i + 1 < m_TargetPoints.size(); ++i)
    {
    this->ToStringHelper(out, this->m_TargetPoints[i]);
    out << ", ";
    }
  if ( !this->m_TargetPoints.empty() ) out << this->m_TargetPoints.back() << ' ';
  out << "]";  out << std::endl;
  out << "  TargetOffset: ";
  this->ToStringHelper(out, this->m_TargetOffset);
  out << std::endl;
  out << "  NormalizationFactor: ";
  this->ToStringHelper(out, this->m_NormalizationFactor);
  out << std::endl;
  out << "  InitialTrialValues: ";
  this->ToStringHelper(out, this->m_InitialTrialValues);
  out << std::endl;
  out << "  TargetValue: " << this->m_TargetValue << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image FastMarchingUpwindGradientImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image FastMarchingUpwindGradientImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< typename itk::NumericTraits<typename InputImageType::PixelType>::RealType, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType = itk::FastMarchingUpwindGradientImageFilter<OutputImageType,InputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  using NodeType = typename FilterType::NodeType;
  using NodeContainerType = typename FilterType::NodeContainer;

  typename NodeContainerType::Pointer trialPoints = NodeContainerType::New();
  trialPoints->reserve( m_TrialPoints.size() );

  for (unsigned int i = 0; i < m_TrialPoints.size(); ++i)
    {
    NodeType node;

    typename NodeType::IndexType index = sitkSTLVectorToITK<typename NodeType::IndexType>( m_TrialPoints[i] );
    node.SetIndex( index );
    node.SetValue( 0.0 );
    if (m_TrialPoints[i].size() > NodeType::SetDimension)
      node.SetValue(m_TrialPoints[i][NodeType::SetDimension]);

    trialPoints->push_back( node );
    }
  filter->SetTrialPoints( trialPoints );
  
  using NodeType = typename FilterType::NodeType;
  using NodeContainerType = typename FilterType::NodeContainer;

  typename NodeContainerType::Pointer targetPoints = NodeContainerType::New();
  targetPoints->reserve( m_TargetPoints.size() );

  for (unsigned int i = 0; i < m_TargetPoints.size(); ++i)
    {
    NodeType node;

    typename NodeType::IndexType index = sitkSTLVectorToITK<typename NodeType::IndexType>( m_TargetPoints[i] );
    node.SetIndex( index );
    node.SetValue( 0.0 );

    targetPoints->push_back( node );
    }
  filter->SetTargetPoints( targetPoints );
  if (this->m_NumberOfTargets==0) {filter->SetTargetReachedModeToNoTargets();}
  else if (this->m_NumberOfTargets==1) {filter->SetTargetReachedModeToOneTarget();}
 else {filter->SetTargetReachedModeToSomeTargets(std::min<size_t>(this->m_TargetPoints.size(), this->m_NumberOfTargets));}
  filter->SetTargetOffset ( this->m_TargetOffset );
  filter->SetNormalizationFactor ( this->m_NormalizationFactor );
  auto nodes = filter->GetTrialPoints();
  for( size_t i = 0; i < nodes->Size(); ++i )
  {
   if ( i < m_InitialTrialValues.size()) nodes->ElementAt(i).SetValue(m_InitialTrialValues[i]);
  }




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->CastITKToImage(filter->GetGradientImage().GetPointer());  this->m_TargetValue = filter->GetTargetValue();


  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image FastMarchingUpwindGradient ( const Image& image1, std::vector< std::vector<unsigned int> > trialPoints, unsigned int numberOfTargets, std::vector< std::vector<unsigned int> > targetPoints, double targetOffset, double normalizationFactor, std::vector<double> initialTrialValues )
{
  FastMarchingUpwindGradientImageFilter filter;
  filter.SetTrialPoints( trialPoints );  filter.SetNumberOfTargets( numberOfTargets );  filter.SetTargetPoints( targetPoints );  filter.SetTargetOffset( targetOffset );  filter.SetNormalizationFactor( normalizationFactor );  filter.SetInitialTrialValues( initialTrialValues );
  return filter.Execute ( image1 );
}


}
