/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelOverlayImageFilter.h"
#include "itkLabelOverlayImageFilter.h"

// Additional include files
#include "sitkLabelFunctorUtils.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelOverlayImageFilter::LabelOverlayImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = IntegerPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
LabelOverlayImageFilter::~LabelOverlayImageFilter() = default;

//
// ToString
//
std::string LabelOverlayImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelOverlayImageFilter\n";
  out << "  Opacity: ";
  this->ToStringHelper(out, this->m_Opacity);
  out << std::endl;
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  Colormap: ";
  this->ToStringHelper(out, this->m_Colormap);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}



//
// Execute
//
Image LabelOverlayImageFilter::Execute ( const Image & image, const Image & labelImage )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, labelImage, "labelImage" );
  CheckImageMatchingSize(  image, labelImage, "labelImage" );
  const PixelIDValueType type2 = labelImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &labelImage );
}

Image LabelOverlayImageFilter::Execute ( Image && image, const Image & labelImage )
{
  Image &temp = image;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image, labelImage );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image LabelOverlayImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inLabelImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  //Define output image type
  using OutputImageType = itk::VectorImage< typename InputImageType::PixelType, InputImageType::ImageDimension >;



  using FilterType = itk::LabelOverlayImageFilter<InputImageType, InputImageType2, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inLabelImage != nullptr );
  typename FilterType::LabelImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::LabelImageType>( *inLabelImage );
  filter->SetLabelImage( image2 );


  filter->SetOpacity ( this->m_Opacity );
  filter->SetBackgroundValue(static_cast< typename InputImageType2::PixelType>( m_BackgroundValue ) );
  SetLabelFunctorFromColormap(filter->GetFunctor(),this->m_Colormap);
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}




//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image LabelOverlay ( const Image & image, const Image & labelImage, double opacity, double backgroundValue, std::vector<uint8_t> colormap )
{
  LabelOverlayImageFilter filter;
  filter.SetOpacity( opacity );  filter.SetBackgroundValue( backgroundValue );  filter.SetColormap( colormap );
  return filter.Execute ( image, labelImage );
}
//
// Function to run the Execute method of this filter
//
Image LabelOverlay ( Image && image, const Image & labelImage, double opacity, double backgroundValue, std::vector<uint8_t> colormap )
{
  LabelOverlayImageFilter filter;
  filter.SetOpacity( opacity );  filter.SetBackgroundValue( backgroundValue );  filter.SetColormap( colormap );
  return filter.Execute ( std::move(image), labelImage );
}

}
