/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkResampleImageFilter.h"
#include "itkResampleImageFilter.h"

// Additional include files
#include "sitkCreateInterpolator.hxx"
#include "sitkTransform.h"
#include "itkNearestNeighborExtrapolateImageFunction.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
ResampleImageFilter::ResampleImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = BasicPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();


  using VectorByComponentsPixelIDTypeList = VectorPixelIDTypeList;
  using VectorByComponentsPixelIDTypeList2 = VectorPixelIDTypeList;
  using VectorAddressorType = detail::DualExecuteInternalVectorAddressor<MemberFunctionType>;
  this->m_DualMemberFactory->RegisterMemberFunctions< VectorByComponentsPixelIDTypeList, VectorByComponentsPixelIDTypeList2, 3, VectorAddressorType> ();
  this->m_DualMemberFactory->RegisterMemberFunctions< VectorByComponentsPixelIDTypeList, VectorByComponentsPixelIDTypeList2, 2, VectorAddressorType> ();


}

//
// Destructor
//
ResampleImageFilter::~ResampleImageFilter() = default;

//
// ToString
//
std::string ResampleImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::ResampleImageFilter\n";
  out << "  Size: ";
  this->ToStringHelper(out, this->m_Size);
  out << std::endl;

  out << "  Interpolator: ";
  this->ToStringHelper(out, this->m_Interpolator);
  out << std::endl;
  out << "  OutputOrigin: ";
  this->ToStringHelper(out, this->m_OutputOrigin);
  out << std::endl;
  out << "  OutputSpacing: ";
  this->ToStringHelper(out, this->m_OutputSpacing);
  out << std::endl;
  out << "  OutputDirection: ";
  this->ToStringHelper(out, this->m_OutputDirection);
  out << std::endl;
  out << "  DefaultPixelValue: ";
  this->ToStringHelper(out, this->m_DefaultPixelValue);
  out << std::endl;
  out << "  OutputPixelType: ";
  this->ToStringHelper(out, this->m_OutputPixelType);
  out << std::endl;
  out << "  UseNearestNeighborExtrapolator: ";
  this->ToStringHelper(out, this->m_UseNearestNeighborExtrapolator);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

void ResampleImageFilter::SetReferenceImage(const Image & refImage )
{
  this->SetSize( refImage.GetSize() ); this->SetOutputOrigin( refImage.GetOrigin() ); this->SetOutputSpacing( refImage.GetSpacing() );this->SetOutputDirection( refImage.GetDirection() );
}


//
// Execute
//
Image ResampleImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type1 = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();
  PixelIDValueEnum type2 = (m_OutputPixelType != sitkUnknown) ? m_OutputPixelType : type1;

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( image1 );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image ResampleImageFilter::DualExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  //Define output image type
  using OutputImageType = InputImageType2;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType = itk::ResampleImageFilter<InputImageType, OutputImageType, double>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  typename FilterType::SizeType itkVecSize = sitkSTLVectorToITK<typename FilterType::SizeType>( this->GetSize() );
  filter->SetSize( itkVecSize );
  const typename FilterType::TransformType *itkTx;
    if ( !(itkTx = dynamic_cast<const typename FilterType::TransformType *>(this->m_Transform.GetITKBase() )) ) {
      if( this->m_Transform.GetITKBase()->GetNameOfClass() != std::string("IdentityTransform") )
      sitkExceptionMacro( "Unexpected error converting transform! Possible miss matching dimensions!" );
     }
    else { filter->SetTransform( itkTx ); }
  filter->SetInterpolator( CreateInterpolator( image1.GetPointer(), m_Interpolator ) );
  typename FilterType::OriginPointType itkVecOutputOrigin = sitkSTLVectorToITK<typename FilterType::OriginPointType>( this->GetOutputOrigin() );
  filter->SetOutputOrigin( itkVecOutputOrigin );
  typename FilterType::SpacingType itkVecOutputSpacing = sitkSTLVectorToITK<typename FilterType::SpacingType>( this->GetOutputSpacing() );
  filter->SetOutputSpacing( itkVecOutputSpacing );
  filter->SetOutputDirection( sitkSTLToITKDirection<typename FilterType::DirectionType>( this->m_OutputDirection ) );
  filter->SetDefaultPixelValue ( static_cast< typename OutputImageType::PixelType> ( this->m_DefaultPixelValue ) );
  
  if (m_UseNearestNeighborExtrapolator) {filter->SetExtrapolator(itk::NearestNeighborExtrapolateImageFunction<InputImageType, double>::New());}




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

//
// Dispatched methods to call DualExecuteInternal on each component of the VectorImage
//
template <class TImageType, class TImageType2> Image
ResampleImageFilter::DualExecuteInternalVector ( const Image& inImage1 )
{
  using VectorInputImageType =  TImageType;
  using ComponentType = typename VectorInputImageType::InternalPixelType;
  using ComponentImageType = typename itk::Image<ComponentType, VectorInputImageType::ImageDimension>;
  // we must define the input and output image types
  // they should be the same as the scalar execute internal method
  using InputImageType = ComponentImageType;
  using VectorInputImageType2 = TImageType2;
  using ComponentType2 = typename VectorInputImageType2::InternalPixelType;
  using ComponentImageType2 = typename itk::Image<ComponentType2, VectorInputImageType2::ImageDimension>;
  using InputImageType2 = ComponentImageType2;  //Define output image type
  using OutputImageType = InputImageType2;
  // Get the pointer to the ITK image contained in image1
  typename VectorInputImageType::ConstPointer image1 =
    this->CastImageToITK<VectorInputImageType>( inImage1 );

  using ComponentExtractorType = itk::VectorIndexSelectionCastImageFilter< VectorInputImageType, ComponentImageType >;
  typename ComponentExtractorType::Pointer extractor = ComponentExtractorType::New();
  extractor->SetInput( image1 );

  using ToVectorFilterType = itk::ComposeImageFilter<OutputImageType>;
  typename ToVectorFilterType::Pointer toVector = ToVectorFilterType::New();

  unsigned int numComps = image1->GetNumberOfComponentsPerPixel();
  for ( unsigned int i = 0; i < numComps; ++i )
    {
    extractor->SetIndex( i );
    extractor->UpdateLargestPossibleRegion();
    Image tmp = this->DualExecuteInternal<InputImageType,InputImageType2>( Image( extractor->GetOutput() ) );
    typename OutputImageType::ConstPointer tempITKImage = this->CastImageToITK<OutputImageType>( tmp );

    toVector->SetInput( i, tempITKImage );
    }

  toVector->Update();

  return Image( toVector->GetOutput() );
}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------



}
