/* WifiMenuItem.c generated by valac 0.56.17, the Vala compiler
 * generated from WifiMenuItem.vala, do not modify */

/*-
 * Copyright (c) 2015-2018 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "network.h"
#include <glib.h>
#include <NetworkManager.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIFI_MENU_ITEM_0_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_AP_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL,
	NETWORK_WIFI_MENU_ITEM_SETTINGS_REQUEST_SIGNAL,
	NETWORK_WIFI_MENU_ITEM_NUM_SIGNALS
};
static guint network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_NUM_SIGNALS] = {0};

struct _NetworkWifiMenuItemPrivate {
	gboolean _is_secured;
	gboolean _active;
	NMDeviceState _state;
	NMAccessPoint* _tmp_ap;
	GeeLinkedList* _ap;
	GtkImage* _img_strength;
	GtkLabel* _ssid_label;
	GtkLabel* _status_label;
	GtkBox* button_box;
	GtkButton* connect_button;
	GtkImage* lock_img;
	GtkImage* error_img;
	GtkRevealer* settings_button_revealer;
	GtkSpinner* spinner;
};

static gint NetworkWifiMenuItem_private_offset;
static gpointer network_wifi_menu_item_parent_class = NULL;
static GtkSizeGroup* network_wifi_menu_item_button_sizegroup;
static GtkSizeGroup* network_wifi_menu_item_button_sizegroup = NULL;

static void network_wifi_menu_item_set_img_strength (NetworkWifiMenuItem* self,
                                              GtkImage* value);
static void network_wifi_menu_item_set_ssid_label (NetworkWifiMenuItem* self,
                                            GtkLabel* value);
static void network_wifi_menu_item_set_status_label (NetworkWifiMenuItem* self,
                                              GtkLabel* value);
static void network_wifi_menu_item_update (NetworkWifiMenuItem* self);
static void _network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void __lambda21_ (NetworkWifiMenuItem* self);
static void ___lambda21__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda22_ (NetworkWifiMenuItem* self);
static void ___lambda22__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void network_wifi_menu_item_update_tmp_ap (NetworkWifiMenuItem* self);
static gchar* network_wifi_menu_item_strength_to_string (NetworkWifiMenuItem* self,
                                                  guint8 strength);
static guint8 network_wifi_menu_item_get_strength (NetworkWifiMenuItem* self);
static void network_wifi_menu_item_set_is_secured (NetworkWifiMenuItem* self,
                                            gboolean value);
static void network_wifi_menu_item_hide_item (NetworkWifiMenuItem* self,
                                       GtkWidget* w);
static void network_wifi_menu_item_show_item (NetworkWifiMenuItem* self,
                                       GtkWidget* w);
static void network_wifi_menu_item_finalize (GObject * obj);
static GType network_wifi_menu_item_get_type_once (void);
static void _vala_network_wifi_menu_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_menu_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_menu_item_get_instance_private (NetworkWifiMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiMenuItem_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	network_wifi_menu_item_update ((NetworkWifiMenuItem*) self);
}

static void
__lambda21_ (NetworkWifiMenuItem* self)
{
	g_signal_emit (self, network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL], 0);
}

static void
___lambda21__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda21_ ((NetworkWifiMenuItem*) self);
}

static void
__lambda22_ (NetworkWifiMenuItem* self)
{
	g_signal_emit (self, network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_SETTINGS_REQUEST_SIGNAL], 0);
}

static void
___lambda22__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda22_ ((NetworkWifiMenuItem*) self);
}

NetworkWifiMenuItem*
network_wifi_menu_item_construct (GType object_type,
                                  NMAccessPoint* ap)
{
	NetworkWifiMenuItem * self = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkSpinner* _tmp8_;
	GtkButton* settings_button = NULL;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkSizeGroup* _tmp11_;
	GtkButton* _tmp12_;
	GtkWidget* _tmp13_;
	GtkRevealer* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkBox* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkBox* _tmp18_;
	GtkButton* _tmp19_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkImage* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkImage* _tmp24_;
	GtkImage* _tmp25_;
	GtkSpinner* _tmp26_;
	GtkBox* _tmp27_;
	GeeLinkedList* _tmp28_;
	GtkButton* _tmp29_;
	g_return_val_if_fail (ap != NULL, NULL);
	self = (NetworkWifiMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_icon_size (_tmp0_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	network_wifi_menu_item_set_img_strength (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp2_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	network_wifi_menu_item_set_ssid_label (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_use_markup (_tmp4_, TRUE);
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	network_wifi_menu_item_set_status_label (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("channel-insecure-symbolic");
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->lock_img);
	self->priv->lock_img = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("process-error-symbolic");
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->error_img);
	self->priv->error_img = _tmp7_;
	_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp8_;
	_tmp9_ = (GtkButton*) gtk_button_new_with_label (_ ("Settings…"));
	g_object_ref_sink (_tmp9_);
	settings_button = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->connect_button);
	self->priv->connect_button = _tmp10_;
	_tmp11_ = network_wifi_menu_item_button_sizegroup;
	_tmp12_ = self->priv->connect_button;
	gtk_size_group_add_widget (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = _g_object_ref0 ((GtkWidget*) settings_button);
	_tmp14_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_widget_set_overflow ((GtkWidget*) _tmp14_, GTK_OVERFLOW_VISIBLE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->settings_button_revealer);
	self->priv->settings_button_revealer = _tmp14_;
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_END);
	gtk_box_set_homogeneous (_tmp15_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->button_box);
	self->priv->button_box = _tmp15_;
	_tmp16_ = self->priv->button_box;
	_tmp17_ = self->priv->settings_button_revealer;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->button_box;
	_tmp19_ = self->priv->connect_button;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	gtk_grid_set_column_spacing (_tmp20_, 6);
	g_object_ref_sink (_tmp20_);
	grid = _tmp20_;
	_tmp21_ = self->priv->_img_strength;
	gtk_grid_attach (grid, (GtkWidget*) _tmp21_, 0, 0, 1, 2);
	_tmp22_ = self->priv->_ssid_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp22_, 1, 0, 1, 1);
	_tmp23_ = self->priv->_status_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp23_, 1, 1, 2, 1);
	_tmp24_ = self->priv->lock_img;
	gtk_grid_attach (grid, (GtkWidget*) _tmp24_, 2, 0, 1, 1);
	_tmp25_ = self->priv->error_img;
	gtk_grid_attach (grid, (GtkWidget*) _tmp25_, 3, 0, 1, 2);
	_tmp26_ = self->priv->spinner;
	gtk_grid_attach (grid, (GtkWidget*) _tmp26_, 4, 0, 1, 2);
	_tmp27_ = self->priv->button_box;
	gtk_grid_attach (grid, (GtkWidget*) _tmp27_, 5, 0, 1, 2);
	_tmp28_ = gee_linked_list_new (nm_access_point_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_ap);
	self->priv->_ap = _tmp28_;
	network_wifi_menu_item_add_ap (self, ap);
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) grid);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _network_wifi_menu_item_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::active", (GCallback) _network_wifi_menu_item_update_g_object_notify, self, 0);
	_tmp29_ = self->priv->connect_button;
	g_signal_connect_object (_tmp29_, "clicked", (GCallback) ___lambda21__gtk_button_clicked, self, 0);
	g_signal_connect_object (settings_button, "clicked", (GCallback) ___lambda22__gtk_button_clicked, self, 0);
	network_wifi_menu_item_update (self);
	_g_object_unref0 (grid);
	_g_object_unref0 (settings_button);
	return self;
}

NetworkWifiMenuItem*
network_wifi_menu_item_new (NMAccessPoint* ap)
{
	return network_wifi_menu_item_construct (NETWORK_TYPE_WIFI_MENU_ITEM, ap);
}

static void
network_wifi_menu_item_update_tmp_ap (NetworkWifiMenuItem* self)
{
	guint8 strength = 0U;
	g_return_if_fail (self != NULL);
	strength = (guint8) 0;
	{
		GeeLinkedList* _ap_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _ap_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _ap_index = 0;
		_tmp0_ = self->priv->_ap;
		_ap_list = _tmp0_;
		_tmp1_ = _ap_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_ap_size = _tmp3_;
		_ap_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			NMAccessPoint* ap = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			NMAccessPoint* _tmp8_ = NULL;
			NMAccessPoint* _tmp9_;
			guint8 _tmp10_;
			guint8 _tmp11_;
			NMAccessPoint* _tmp14_;
			NMAccessPoint* _tmp15_;
			guint8 _tmp16_;
			guint8 _tmp17_;
			_ap_index = _ap_index + 1;
			_tmp4_ = _ap_index;
			_tmp5_ = _ap_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _ap_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _ap_index);
			ap = (NMAccessPoint*) _tmp7_;
			_tmp9_ = ap;
			_tmp10_ = nm_access_point_get_strength (_tmp9_);
			_tmp11_ = _tmp10_;
			if (strength > _tmp11_) {
				NMAccessPoint* _tmp12_;
				_tmp12_ = self->priv->_tmp_ap;
				_tmp8_ = _tmp12_;
			} else {
				NMAccessPoint* _tmp13_;
				_tmp13_ = ap;
				_tmp8_ = _tmp13_;
			}
			_tmp14_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (self->priv->_tmp_ap);
			self->priv->_tmp_ap = _tmp14_;
			_tmp15_ = ap;
			_tmp16_ = nm_access_point_get_strength (_tmp15_);
			_tmp17_ = _tmp16_;
			strength = MAX (strength, _tmp17_);
			_g_object_unref0 (ap);
		}
	}
}

static void
network_wifi_menu_item_update (NetworkWifiMenuItem* self)
{
	GtkLabel* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMAccessPoint* _tmp2_;
	GBytes* _tmp3_;
	gsize _tmp4_ = 0;
	guint8* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* state_string = NULL;
	GtkImage* _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	NM80211ApSecurityFlags flags = 0U;
	NMAccessPoint* _tmp15_;
	NMAccessPoint* _tmp16_;
	NMAccessPoint* _tmp17_;
	NMAccessPoint* _tmp18_;
	GtkImage* _tmp19_;
	gboolean _tmp20_;
	GtkImage* _tmp21_;
	GtkSpinner* _tmp22_;
	GtkBox* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkButton* _tmp25_;
	NMDeviceState _tmp26_;
	GtkLabel* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ssid_label;
	_tmp1_ = network_wifi_menu_item_get_ap (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = nm_access_point_get_ssid (_tmp2_);
	_tmp5_ = g_bytes_get_data (_tmp3_, &_tmp4_);
	_tmp6_ = nm_utils_ssid_to_utf8 (_tmp5_, (gsize) _tmp4_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->_img_strength;
	_tmp9_ = network_wifi_menu_item_get_strength (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = network_wifi_menu_item_strength_to_string (self, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("network-wireless-signal-", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_object_set (_tmp8_, "icon-name", _tmp14_, NULL);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp15_ = network_wifi_menu_item_get_ap (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = network_wifi_menu_item_get_ap (self);
	_tmp18_ = _tmp17_;
	flags = nm_access_point_get_wpa_flags (_tmp16_) | nm_access_point_get_rsn_flags (_tmp18_);
	network_wifi_menu_item_set_is_secured (self, FALSE);
	if ((flags & NM_802_11_AP_SEC_GROUP_WEP40) == NM_802_11_AP_SEC_GROUP_WEP40) {
		network_wifi_menu_item_set_is_secured (self, TRUE);
		state_string = _ ("40/64-bit WEP encrypted");
	} else {
		if ((flags & NM_802_11_AP_SEC_GROUP_WEP104) == NM_802_11_AP_SEC_GROUP_WEP104) {
			network_wifi_menu_item_set_is_secured (self, TRUE);
			state_string = _ ("104/128-bit WEP encrypted");
		} else {
			if ((flags & NM_802_11_AP_SEC_KEY_MGMT_SAE) == NM_802_11_AP_SEC_KEY_MGMT_SAE) {
				network_wifi_menu_item_set_is_secured (self, TRUE);
				state_string = _ ("WPA3 encrypted");
			} else {
				if ((flags & NM_802_11_AP_SEC_KEY_MGMT_PSK) == NM_802_11_AP_SEC_KEY_MGMT_PSK) {
					network_wifi_menu_item_set_is_secured (self, TRUE);
					state_string = _ ("WPA encrypted");
				} else {
					if ((flags & NM_802_11_AP_SEC_KEY_MGMT_OWE) == NM_802_11_AP_SEC_KEY_MGMT_OWE) {
						network_wifi_menu_item_set_is_secured (self, TRUE);
						state_string = _ ("Passwordless encrypted");
					} else {
						if (flags != NM_802_11_AP_SEC_NONE) {
							network_wifi_menu_item_set_is_secured (self, TRUE);
							state_string = _ ("Encrypted");
						} else {
							state_string = _ ("Unsecured");
						}
					}
				}
			}
		}
	}
	_tmp19_ = self->priv->lock_img;
	_tmp20_ = self->priv->_is_secured;
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, !_tmp20_);
	_tmp21_ = self->priv->error_img;
	network_wifi_menu_item_hide_item (self, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->spinner;
	gtk_spinner_set_spinning (_tmp22_, FALSE);
	_tmp23_ = self->priv->button_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->priv->settings_button_revealer;
	gtk_revealer_set_reveal_child (_tmp24_, FALSE);
	_tmp25_ = self->priv->connect_button;
	gtk_button_set_label (_tmp25_, _ ("Connect"));
	_tmp26_ = self->priv->_state;
	switch (_tmp26_) {
		case NM_DEVICE_STATE_FAILED:
		{
			GtkImage* _tmp27_;
			_tmp27_ = self->priv->error_img;
			network_wifi_menu_item_show_item (self, (GtkWidget*) _tmp27_);
			state_string = _ ("Could not be connected to");
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		{
			GtkSpinner* _tmp28_;
			GtkBox* _tmp29_;
			_tmp28_ = self->priv->spinner;
			gtk_spinner_set_spinning (_tmp28_, TRUE);
			_tmp29_ = self->priv->button_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp29_, FALSE);
			state_string = _ ("Connecting");
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			GtkRevealer* _tmp30_;
			GtkButton* _tmp31_;
			_tmp30_ = self->priv->settings_button_revealer;
			gtk_revealer_set_reveal_child (_tmp30_, TRUE);
			_tmp31_ = self->priv->connect_button;
			gtk_button_set_label (_tmp31_, _ ("Disconnect"));
			break;
		}
		default:
		break;
	}
	_tmp32_ = self->priv->_status_label;
	_tmp33_ = state_string;
	_tmp34_ = g_markup_printf_escaped ("<span font_size='small'>%s</span>", _tmp33_);
	_tmp35_ = _tmp34_;
	gtk_label_set_label (_tmp32_, _tmp35_);
	_g_free0 (_tmp35_);
}

static void
network_wifi_menu_item_show_item (NetworkWifiMenuItem* self,
                                  GtkWidget* w)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, TRUE);
}

static void
network_wifi_menu_item_hide_item (NetworkWifiMenuItem* self,
                                  GtkWidget* w)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, FALSE);
}

void
network_wifi_menu_item_add_ap (NetworkWifiMenuItem* self,
                               NMAccessPoint* ap)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap != NULL);
	_tmp0_ = self->priv->_ap;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, ap);
	network_wifi_menu_item_update_tmp_ap (self);
	network_wifi_menu_item_update (self);
}

static gchar*
network_wifi_menu_item_strength_to_string (NetworkWifiMenuItem* self,
                                           guint8 strength)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (((gint) strength) < 30) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("weak");
		result = _tmp0_;
		return result;
	} else {
		if (((gint) strength) < 55) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ok");
			result = _tmp1_;
			return result;
		} else {
			if (((gint) strength) < 80) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("good");
				result = _tmp2_;
				return result;
			} else {
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("excellent");
				result = _tmp3_;
				return result;
			}
		}
	}
}

gboolean
network_wifi_menu_item_remove_ap (NetworkWifiMenuItem* self,
                                  NMAccessPoint* ap)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ap != NULL, FALSE);
	_tmp0_ = self->priv->_ap;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, ap);
	network_wifi_menu_item_update_tmp_ap (self);
	_tmp1_ = self->priv->_ap;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = !_tmp3_;
	return result;
}

gboolean
network_wifi_menu_item_get_is_secured (NetworkWifiMenuItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_secured;
	return result;
}

static void
network_wifi_menu_item_set_is_secured (NetworkWifiMenuItem* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_is_secured (self);
	if (old_value != value) {
		self->priv->_is_secured = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY]);
	}
}

gboolean
network_wifi_menu_item_get_active (NetworkWifiMenuItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
network_wifi_menu_item_set_active (NetworkWifiMenuItem* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY]);
	}
}

NMDeviceState
network_wifi_menu_item_get_state (NetworkWifiMenuItem* self)
{
	NMDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
network_wifi_menu_item_set_state (NetworkWifiMenuItem* self,
                                  NMDeviceState value)
{
	NMDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY]);
	}
}

NMAccessPoint*
network_wifi_menu_item_get_ap (NetworkWifiMenuItem* self)
{
	NMAccessPoint* result;
	NMAccessPoint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tmp_ap;
	result = _tmp0_;
	return result;
}

GBytes*
network_wifi_menu_item_get_ssid (NetworkWifiMenuItem* self)
{
	GBytes* result;
	NMAccessPoint* _tmp0_;
	GBytes* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tmp_ap;
	_tmp1_ = nm_access_point_get_ssid (_tmp0_);
	result = _tmp1_;
	return result;
}

static guint8
network_wifi_menu_item_get_strength (NetworkWifiMenuItem* self)
{
	guint8 result;
	guint8 strength = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	strength = (guint8) 0;
	{
		GeeLinkedList* _ap_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _ap_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _ap_index = 0;
		_tmp0_ = self->priv->_ap;
		_ap_list = _tmp0_;
		_tmp1_ = _ap_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_ap_size = _tmp3_;
		_ap_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			NMAccessPoint* ap = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			NMAccessPoint* _tmp8_;
			_ap_index = _ap_index + 1;
			_tmp4_ = _ap_index;
			_tmp5_ = _ap_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _ap_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _ap_index);
			ap = (NMAccessPoint*) _tmp7_;
			_tmp8_ = ap;
			strength = MAX (strength, nm_access_point_get_strength (_tmp8_));
			_g_object_unref0 (ap);
		}
	}
	result = strength;
	return result;
}

GtkImage*
network_wifi_menu_item_get_img_strength (NetworkWifiMenuItem* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_img_strength;
	result = _tmp0_;
	return result;
}

static void
network_wifi_menu_item_set_img_strength (NetworkWifiMenuItem* self,
                                         GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_img_strength (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_img_strength);
		self->priv->_img_strength = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY]);
	}
}

GtkLabel*
network_wifi_menu_item_get_ssid_label (NetworkWifiMenuItem* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ssid_label;
	result = _tmp0_;
	return result;
}

static void
network_wifi_menu_item_set_ssid_label (NetworkWifiMenuItem* self,
                                       GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_ssid_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ssid_label);
		self->priv->_ssid_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY]);
	}
}

GtkLabel*
network_wifi_menu_item_get_status_label (NetworkWifiMenuItem* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status_label;
	result = _tmp0_;
	return result;
}

static void
network_wifi_menu_item_set_status_label (NetworkWifiMenuItem* self,
                                         GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_status_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_status_label);
		self->priv->_status_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY]);
	}
}

static void
network_wifi_menu_item_class_init (NetworkWifiMenuItemClass * klass,
                                   gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	network_wifi_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_menu_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY] = g_param_spec_boolean ("is-secured", "is-secured", "is-secured", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", nm_device_state_get_type (), NM_DEVICE_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_AP_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_AP_PROPERTY] = g_param_spec_object ("ap", "ap", "ap", nm_access_point_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY] = g_param_spec_boxed ("ssid", "ssid", "ssid", G_TYPE_BYTES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY] = g_param_spec_object ("img-strength", "img-strength", "img-strength", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY] = g_param_spec_object ("ssid-label", "ssid-label", "ssid-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY] = g_param_spec_object ("status-label", "status-label", "status-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL] = g_signal_new ("user-action", NETWORK_TYPE_WIFI_MENU_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_SETTINGS_REQUEST_SIGNAL] = g_signal_new ("settings-request", NETWORK_TYPE_WIFI_MENU_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (network_wifi_menu_item_button_sizegroup);
	network_wifi_menu_item_button_sizegroup = _tmp0_;
}

static void
network_wifi_menu_item_instance_init (NetworkWifiMenuItem * self,
                                      gpointer klass)
{
	self->priv = network_wifi_menu_item_get_instance_private (self);
	self->priv->_state = NM_DEVICE_STATE_DISCONNECTED;
}

static void
network_wifi_menu_item_finalize (GObject * obj)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	_g_object_unref0 (self->priv->_tmp_ap);
	_g_object_unref0 (self->priv->_ap);
	_g_object_unref0 (self->priv->_img_strength);
	_g_object_unref0 (self->priv->_ssid_label);
	_g_object_unref0 (self->priv->_status_label);
	_g_object_unref0 (self->priv->button_box);
	_g_object_unref0 (self->priv->connect_button);
	_g_object_unref0 (self->priv->lock_img);
	_g_object_unref0 (self->priv->error_img);
	_g_object_unref0 (self->priv->settings_button_revealer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (network_wifi_menu_item_parent_class)->finalize (obj);
}

static GType
network_wifi_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiMenuItem), 0, (GInstanceInitFunc) network_wifi_menu_item_instance_init, NULL };
	GType network_wifi_menu_item_type_id;
	network_wifi_menu_item_type_id = g_type_register_static (gtk_list_box_row_get_type (), "NetworkWifiMenuItem", &g_define_type_info, 0);
	NetworkWifiMenuItem_private_offset = g_type_add_instance_private (network_wifi_menu_item_type_id, sizeof (NetworkWifiMenuItemPrivate));
	return network_wifi_menu_item_type_id;
}

GType
network_wifi_menu_item_get_type (void)
{
	static volatile gsize network_wifi_menu_item_type_id__once = 0;
	if (g_once_init_enter (&network_wifi_menu_item_type_id__once)) {
		GType network_wifi_menu_item_type_id;
		network_wifi_menu_item_type_id = network_wifi_menu_item_get_type_once ();
		g_once_init_leave (&network_wifi_menu_item_type_id__once, network_wifi_menu_item_type_id);
	}
	return network_wifi_menu_item_type_id__once;
}

static void
_vala_network_wifi_menu_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY:
		g_value_set_boolean (value, network_wifi_menu_item_get_is_secured (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY:
		g_value_set_boolean (value, network_wifi_menu_item_get_active (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, network_wifi_menu_item_get_state (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_AP_PROPERTY:
		g_value_set_object (value, network_wifi_menu_item_get_ap (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY:
		g_value_set_boxed (value, network_wifi_menu_item_get_ssid (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY:
		g_value_set_object (value, network_wifi_menu_item_get_img_strength (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY:
		g_value_set_object (value, network_wifi_menu_item_get_ssid_label (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY:
		g_value_set_object (value, network_wifi_menu_item_get_status_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_menu_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_IS_SECURED_PROPERTY:
		network_wifi_menu_item_set_is_secured (self, g_value_get_boolean (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_ACTIVE_PROPERTY:
		network_wifi_menu_item_set_active (self, g_value_get_boolean (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		network_wifi_menu_item_set_state (self, g_value_get_enum (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_IMG_STRENGTH_PROPERTY:
		network_wifi_menu_item_set_img_strength (self, g_value_get_object (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_LABEL_PROPERTY:
		network_wifi_menu_item_set_ssid_label (self, g_value_get_object (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_STATUS_LABEL_PROPERTY:
		network_wifi_menu_item_set_status_label (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

