/* Device.c generated by valac 0.56.17, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include "power.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>

#define POWER_DEVICE_UPOWER_NAME "org.freedesktop.UPower"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_UPOWER_DEVICE_CHANGED_SIGNAL,
	POWER_UPOWER_DEVICE_NUM_SIGNALS
};
static guint power_upower_device_signals[POWER_UPOWER_DEVICE_NUM_SIGNALS] = {0};
typedef GDBusProxy PowerUpowerDeviceProxy;
typedef GDBusProxyClass PowerUpowerDeviceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	POWER_DEVICE_0_PROPERTY,
	POWER_DEVICE_PATH_PROPERTY,
	POWER_DEVICE_POWER_SUPPLY_PROPERTY,
	POWER_DEVICE_PERCENTAGE_PROPERTY,
	POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY,
	POWER_DEVICE_DESCRIPTION_PROPERTY,
	POWER_DEVICE_ICON_NAME_PROPERTY,
	POWER_DEVICE_MODEL_PROPERTY,
	POWER_DEVICE_STATE_PROPERTY,
	POWER_DEVICE_DEVICE_TYPE_PROPERTY,
	POWER_DEVICE_NUM_PROPERTIES
};
static GParamSpec* power_device_properties[POWER_DEVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PowerDevicePrivate {
	gchar* _path;
	gboolean _power_supply;
	gdouble _percentage;
	gboolean _coarse_battery_level;
	gchar* _description;
	gchar* _icon_name;
	gchar* _model;
	PowerDeviceState _state;
	PowerDeviceType _device_type;
	PowerUpowerDevice* upower_device;
};

static gint PowerDevice_private_offset;
static gpointer power_device_parent_class = NULL;

static GType power_upower_device_get_type_once (void);
static void power_upower_device_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void _dbus_handle_power_upower_device_changed (PowerUpowerDevice* self,
                                               GVariant* parameters);
static void power_upower_device_proxy_refresh (PowerUpowerDevice* self,
                                        GError** error);
static gboolean power_upower_device_dbus_proxy_get_is_present (PowerUpowerDevice* self);
static gboolean power_upower_device_dbus_proxy_get_online (PowerUpowerDevice* self);
static gboolean power_upower_device_dbus_proxy_get_power_supply (PowerUpowerDevice* self);
static gdouble power_upower_device_dbus_proxy_get_percentage (PowerUpowerDevice* self);
static gchar* power_upower_device_dbus_proxy_get_model (PowerUpowerDevice* self);
static guint32 power_upower_device_dbus_proxy_get_battery_level (PowerUpowerDevice* self);
static PowerDeviceState power_upower_device_dbus_proxy_get_state (PowerUpowerDevice* self);
static PowerDeviceType power_upower_device_dbus_proxy_get_device_type (PowerUpowerDevice* self);
static void power_upower_device_proxy_power_upower_device_interface_init (PowerUpowerDeviceIface* iface);
static void _dbus_power_upower_device_refresh (PowerUpowerDevice* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void power_upower_device_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* power_upower_device_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_power_upower_device_get_is_present (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_online (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_power_supply (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_percentage (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_model (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_battery_level (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_state (PowerUpowerDevice* self);
static GVariant* _dbus_power_upower_device_get_device_type (PowerUpowerDevice* self);
static gboolean power_upower_device_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_power_upower_device_changed (GObject* _sender,
                                        gpointer* _data);
static void _power_upower_device_unregister_object (gpointer user_data);
static void power_device_update_properties (PowerDevice* self);
static void power_device_set_coarse_battery_level (PowerDevice* self,
                                            gboolean value);
static void power_device_set_model (PowerDevice* self,
                             const gchar* value);
static void power_device_set_percentage (PowerDevice* self,
                                  gdouble value);
static void power_device_set_state (PowerDevice* self,
                             PowerDeviceState value);
static void power_device_set_icon_name (PowerDevice* self,
                                 const gchar* value);
static void power_device_update_description (PowerDevice* self);
static void power_device_set_description (PowerDevice* self,
                                   const gchar* value);
static void power_device_set_power_supply (PowerDevice* self,
                                    gboolean value);
static void power_device_set_device_type (PowerDevice* self,
                                   PowerDeviceType value);
static GObject * power_device_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _power_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                        GVariant* changed_properties,
                                                                        gchar** invalidated_properties,
                                                                        gpointer self);
static void _power_device_update_description_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void power_device_finalize (GObject * obj);
static GType power_device_get_type_once (void);
static void _vala_power_device_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_power_device_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static const GDBusArgInfo * const _power_upower_device_dbus_arg_info_refresh_in[] = {NULL};
static const GDBusArgInfo * const _power_upower_device_dbus_arg_info_refresh_out[] = {NULL};
static const GDBusMethodInfo _power_upower_device_dbus_method_info_refresh = {-1, "Refresh", (GDBusArgInfo **) (&_power_upower_device_dbus_arg_info_refresh_in), (GDBusArgInfo **) (&_power_upower_device_dbus_arg_info_refresh_out), NULL};
static const GDBusMethodInfo * const _power_upower_device_dbus_method_info[] = {&_power_upower_device_dbus_method_info_refresh, NULL};
static const GDBusArgInfo * const _power_upower_device_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _power_upower_device_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_power_upower_device_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _power_upower_device_dbus_signal_info[] = {&_power_upower_device_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_is_present = {-1, "IsPresent", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_online = {-1, "Online", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_power_supply = {-1, "PowerSupply", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_percentage = {-1, "Percentage", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_model = {-1, "Model", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_battery_level = {-1, "BatteryLevel", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_upower_device_dbus_property_info_device_type = {-1, "Type", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _power_upower_device_dbus_property_info[] = {&_power_upower_device_dbus_property_info_is_present, &_power_upower_device_dbus_property_info_online, &_power_upower_device_dbus_property_info_power_supply, &_power_upower_device_dbus_property_info_percentage, &_power_upower_device_dbus_property_info_model, &_power_upower_device_dbus_property_info_battery_level, &_power_upower_device_dbus_property_info_state, &_power_upower_device_dbus_property_info_device_type, NULL};
static const GDBusInterfaceInfo _power_upower_device_dbus_interface_info = {-1, "org.freedesktop.UPower.Device", (GDBusMethodInfo **) (&_power_upower_device_dbus_method_info), (GDBusSignalInfo **) (&_power_upower_device_dbus_signal_info), (GDBusPropertyInfo **) (&_power_upower_device_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_upower_device_dbus_interface_vtable = {power_upower_device_dbus_interface_method_call, power_upower_device_dbus_interface_get_property, power_upower_device_dbus_interface_set_property};

void
power_upower_device_refresh (PowerUpowerDevice* self,
                             GError** error)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->refresh) {
		_iface_->refresh (self, error);
	}
}

gboolean
power_upower_device_get_is_present (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_is_present) {
		return _iface_->get_is_present (self);
	}
	return FALSE;
}

gboolean
power_upower_device_get_online (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_online) {
		return _iface_->get_online (self);
	}
	return FALSE;
}

gboolean
power_upower_device_get_power_supply (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_power_supply) {
		return _iface_->get_power_supply (self);
	}
	return FALSE;
}

gdouble
power_upower_device_get_percentage (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_percentage) {
		return _iface_->get_percentage (self);
	}
	return -1.0;
}

gchar*
power_upower_device_get_model (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_model) {
		return _iface_->get_model (self);
	}
	return NULL;
}

guint32
power_upower_device_get_battery_level (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_battery_level) {
		return _iface_->get_battery_level (self);
	}
	return 0U;
}

PowerDeviceState
power_upower_device_get_state (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_state) {
		return _iface_->get_state (self);
	}
	return 0;
}

PowerDeviceType
power_upower_device_get_device_type (PowerUpowerDevice* self)
{
	PowerUpowerDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = POWER_UPOWER_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_device_type) {
		return _iface_->get_device_type (self);
	}
	return 0;
}

static void
power_upower_device_default_init (PowerUpowerDeviceIface * iface,
                                  gpointer iface_data)
{
	power_upower_device_signals[POWER_UPOWER_DEVICE_CHANGED_SIGNAL] = g_signal_new ("changed", POWER_TYPE_UPOWER_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
power_upower_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerUpowerDeviceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_upower_device_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType power_upower_device_type_id;
	power_upower_device_type_id = g_type_register_static (G_TYPE_INTERFACE, "PowerUpowerDevice", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_upower_device_type_id, g_dbus_proxy_get_type ());
	g_type_set_qdata (power_upower_device_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_upower_device_proxy_get_type);
	g_type_set_qdata (power_upower_device_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.UPower.Device");
	g_type_set_qdata (power_upower_device_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_upower_device_dbus_interface_info));
	g_type_set_qdata (power_upower_device_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_upower_device_register_object);
	return power_upower_device_type_id;
}

GType
power_upower_device_get_type (void)
{
	static volatile gsize power_upower_device_type_id__once = 0;
	if (g_once_init_enter (&power_upower_device_type_id__once)) {
		GType power_upower_device_type_id;
		power_upower_device_type_id = power_upower_device_get_type_once ();
		g_once_init_leave (&power_upower_device_type_id__once, power_upower_device_type_id);
	}
	return power_upower_device_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PowerUpowerDeviceProxy, power_upower_device_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (POWER_TYPE_UPOWER_DEVICE, power_upower_device_proxy_power_upower_device_interface_init) )
static void
power_upower_device_proxy_class_init (PowerUpowerDeviceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_upower_device_proxy_g_signal;
}

static void
_dbus_handle_power_upower_device_changed (PowerUpowerDevice* self,
                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
power_upower_device_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_power_upower_device_changed ((PowerUpowerDevice*) proxy, parameters);
	}
}

static void
power_upower_device_proxy_init (PowerUpowerDeviceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_upower_device_dbus_interface_info));
}

static void
power_upower_device_proxy_refresh (PowerUpowerDevice* self,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.UPower.Device", "Refresh");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
power_upower_device_dbus_proxy_get_is_present (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IsPresent");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IsPresent"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp0_ = FALSE;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
power_upower_device_dbus_proxy_get_online (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Online");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Online"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp1_ = FALSE;
			return _tmp1_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
power_upower_device_dbus_proxy_get_power_supply (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PowerSupply");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PowerSupply"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp2_ = FALSE;
			return _tmp2_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gdouble
power_upower_device_dbus_proxy_get_percentage (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Percentage");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Percentage"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gdouble _tmp3_ = 0.0;
			return _tmp3_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
power_upower_device_dbus_proxy_get_model (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Model");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Model"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint32
power_upower_device_dbus_proxy_get_battery_level (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BatteryLevel");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BatteryLevel"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp4_ = 0U;
			return _tmp4_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static PowerDeviceState
power_upower_device_dbus_proxy_get_state (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	PowerDeviceState _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static PowerDeviceType
power_upower_device_dbus_proxy_get_device_type (PowerUpowerDevice* self)
{
	GVariant *_inner_reply;
	PowerDeviceType _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Type");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.UPower.Device"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Type"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_upower_device_proxy_power_upower_device_interface_init (PowerUpowerDeviceIface* iface)
{
	iface->refresh = power_upower_device_proxy_refresh;
	iface->get_is_present = power_upower_device_dbus_proxy_get_is_present;
	iface->get_online = power_upower_device_dbus_proxy_get_online;
	iface->get_power_supply = power_upower_device_dbus_proxy_get_power_supply;
	iface->get_percentage = power_upower_device_dbus_proxy_get_percentage;
	iface->get_model = power_upower_device_dbus_proxy_get_model;
	iface->get_battery_level = power_upower_device_dbus_proxy_get_battery_level;
	iface->get_state = power_upower_device_dbus_proxy_get_state;
	iface->get_device_type = power_upower_device_dbus_proxy_get_device_type;
}

static void
_dbus_power_upower_device_refresh (PowerUpowerDevice* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	power_upower_device_refresh (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
power_upower_device_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Refresh") == 0) {
		_dbus_power_upower_device_refresh (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_power_upower_device_get_is_present (PowerUpowerDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_device_get_is_present (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_online (PowerUpowerDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_device_get_online (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_power_supply (PowerUpowerDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = power_upower_device_get_power_supply (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_percentage (PowerUpowerDevice* self)
{
	gdouble result;
	GVariant* _reply;
	result = power_upower_device_get_percentage (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_model (PowerUpowerDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = power_upower_device_get_model (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_battery_level (PowerUpowerDevice* self)
{
	guint32 result;
	GVariant* _reply;
	result = power_upower_device_get_battery_level (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_state (PowerUpowerDevice* self)
{
	PowerDeviceState result;
	GVariant* _reply;
	result = power_upower_device_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_power_upower_device_get_device_type (PowerUpowerDevice* self)
{
	PowerDeviceType result;
	GVariant* _reply;
	result = power_upower_device_get_device_type (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
power_upower_device_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "IsPresent") == 0) {
		return _dbus_power_upower_device_get_is_present (object);
	} else if (strcmp (property_name, "Online") == 0) {
		return _dbus_power_upower_device_get_online (object);
	} else if (strcmp (property_name, "PowerSupply") == 0) {
		return _dbus_power_upower_device_get_power_supply (object);
	} else if (strcmp (property_name, "Percentage") == 0) {
		return _dbus_power_upower_device_get_percentage (object);
	} else if (strcmp (property_name, "Model") == 0) {
		return _dbus_power_upower_device_get_model (object);
	} else if (strcmp (property_name, "BatteryLevel") == 0) {
		return _dbus_power_upower_device_get_battery_level (object);
	} else if (strcmp (property_name, "State") == 0) {
		return _dbus_power_upower_device_get_state (object);
	} else if (strcmp (property_name, "Type") == 0) {
		return _dbus_power_upower_device_get_device_type (object);
	}
	return NULL;
}

static gboolean
power_upower_device_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_power_upower_device_changed (GObject* _sender,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower.Device", "Changed", _arguments, NULL);
}

guint
power_upower_device_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_upower_device_dbus_interface_info), &_power_upower_device_dbus_interface_vtable, data, _power_upower_device_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_power_upower_device_changed, data);
	return result;
}

static void
_power_upower_device_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_power_upower_device_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
power_device_get_instance_private (PowerDevice* self)
{
	return G_STRUCT_MEMBER_P (self, PowerDevice_private_offset);
}

GIcon*
power_device_state_to_icon (PowerDeviceState self)
{
	GIcon* result;
	switch (self) {
		case POWER_DEVICE_STATE_CHARGING:
		{
			GThemedIcon* _tmp0_;
			_tmp0_ = (GThemedIcon*) g_themed_icon_new ("device-charging-symbolic");
			result = (GIcon*) _tmp0_;
			return result;
		}
		case POWER_DEVICE_STATE_PENDING_CHARGE:
		case POWER_DEVICE_STATE_PENDING_DISCHARGE:
		{
			GThemedIcon* _tmp1_;
			_tmp1_ = (GThemedIcon*) g_themed_icon_new ("device-charging-paused-symbolic");
			result = (GIcon*) _tmp1_;
			return result;
		}
		case POWER_DEVICE_STATE_EMPTY:
		case POWER_DEVICE_STATE_UNKNOWN:
		{
			GThemedIcon* _tmp2_;
			_tmp2_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning-symbolic");
			result = (GIcon*) _tmp2_;
			return result;
		}
		default:
		case POWER_DEVICE_STATE_DISCHARGING:
		case POWER_DEVICE_STATE_FULLY_CHARGED:
		{
			result = NULL;
			return result;
		}
	}
}

gchar*
power_device_state_to_string (PowerDeviceState self)
{
	gchar* result;
	switch (self) {
		case POWER_DEVICE_STATE_CHARGING:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Charging"));
			result = _tmp0_;
			return result;
		}
		case POWER_DEVICE_STATE_DISCHARGING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Using battery power"));
			result = _tmp1_;
			return result;
		}
		case POWER_DEVICE_STATE_EMPTY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Empty"));
			result = _tmp2_;
			return result;
		}
		case POWER_DEVICE_STATE_FULLY_CHARGED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Fully charged"));
			result = _tmp3_;
			return result;
		}
		case POWER_DEVICE_STATE_PENDING_CHARGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Waiting to charge"));
			result = _tmp4_;
			return result;
		}
		case POWER_DEVICE_STATE_PENDING_DISCHARGE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Waiting to use battery power"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Unknown"));
			result = _tmp6_;
			return result;
		}
	}
}

static GType
power_device_state_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_DEVICE_STATE_UNKNOWN, "POWER_DEVICE_STATE_UNKNOWN", "unknown"}, {POWER_DEVICE_STATE_CHARGING, "POWER_DEVICE_STATE_CHARGING", "charging"}, {POWER_DEVICE_STATE_DISCHARGING, "POWER_DEVICE_STATE_DISCHARGING", "discharging"}, {POWER_DEVICE_STATE_EMPTY, "POWER_DEVICE_STATE_EMPTY", "empty"}, {POWER_DEVICE_STATE_FULLY_CHARGED, "POWER_DEVICE_STATE_FULLY_CHARGED", "fully-charged"}, {POWER_DEVICE_STATE_PENDING_CHARGE, "POWER_DEVICE_STATE_PENDING_CHARGE", "pending-charge"}, {POWER_DEVICE_STATE_PENDING_DISCHARGE, "POWER_DEVICE_STATE_PENDING_DISCHARGE", "pending-discharge"}, {0, NULL, NULL}};
	GType power_device_state_type_id;
	power_device_state_type_id = g_enum_register_static ("PowerDeviceState", values);
	return power_device_state_type_id;
}

GType
power_device_state_get_type (void)
{
	static volatile gsize power_device_state_type_id__once = 0;
	if (g_once_init_enter (&power_device_state_type_id__once)) {
		GType power_device_state_type_id;
		power_device_state_type_id = power_device_state_get_type_once ();
		g_once_init_leave (&power_device_state_type_id__once, power_device_state_type_id);
	}
	return power_device_state_type_id__once;
}

static GType
power_device_type_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_DEVICE_TYPE_UNKNOWN, "POWER_DEVICE_TYPE_UNKNOWN", "unknown"}, {POWER_DEVICE_TYPE_LINE_POWER, "POWER_DEVICE_TYPE_LINE_POWER", "line-power"}, {POWER_DEVICE_TYPE_BATTERY, "POWER_DEVICE_TYPE_BATTERY", "battery"}, {POWER_DEVICE_TYPE_UPS, "POWER_DEVICE_TYPE_UPS", "ups"}, {POWER_DEVICE_TYPE_MONITOR, "POWER_DEVICE_TYPE_MONITOR", "monitor"}, {POWER_DEVICE_TYPE_MOUSE, "POWER_DEVICE_TYPE_MOUSE", "mouse"}, {POWER_DEVICE_TYPE_KEYBOARD, "POWER_DEVICE_TYPE_KEYBOARD", "keyboard"}, {POWER_DEVICE_TYPE_PDA, "POWER_DEVICE_TYPE_PDA", "pda"}, {POWER_DEVICE_TYPE_PHONE, "POWER_DEVICE_TYPE_PHONE", "phone"}, {POWER_DEVICE_TYPE_MEDIA_PLAYER, "POWER_DEVICE_TYPE_MEDIA_PLAYER", "media-player"}, {POWER_DEVICE_TYPE_TABLET, "POWER_DEVICE_TYPE_TABLET", "tablet"}, {POWER_DEVICE_TYPE_COMPUTER, "POWER_DEVICE_TYPE_COMPUTER", "computer"}, {POWER_DEVICE_TYPE_GAMING_INPUT, "POWER_DEVICE_TYPE_GAMING_INPUT", "gaming-input"}, {POWER_DEVICE_TYPE_PEN, "POWER_DEVICE_TYPE_PEN", "pen"}, {0, NULL, NULL}};
	GType power_device_type_type_id;
	power_device_type_type_id = g_enum_register_static ("PowerDeviceType", values);
	return power_device_type_type_id;
}

GType
power_device_type_get_type (void)
{
	static volatile gsize power_device_type_type_id__once = 0;
	if (g_once_init_enter (&power_device_type_type_id__once)) {
		GType power_device_type_type_id;
		power_device_type_type_id = power_device_type_get_type_once ();
		g_once_init_leave (&power_device_type_type_id__once, power_device_type_type_id);
	}
	return power_device_type_type_id__once;
}

PowerDevice*
power_device_construct (GType object_type,
                        const gchar* path)
{
	PowerDevice * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (PowerDevice*) g_object_new (object_type, "path", path, NULL);
	return self;
}

PowerDevice*
power_device_new (const gchar* path)
{
	return power_device_construct (POWER_TYPE_DEVICE, path);
}

static void
power_device_update_properties (PowerDevice* self)
{
	PowerUpowerDevice* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	PowerUpowerDevice* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PowerUpowerDevice* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	PowerUpowerDevice* _tmp10_;
	PowerDeviceState _tmp11_;
	PowerDeviceState _tmp12_;
	PowerDeviceType _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upower_device;
	_tmp1_ = power_upower_device_get_battery_level (_tmp0_);
	_tmp2_ = _tmp1_;
	power_device_set_coarse_battery_level (self, _tmp2_ != ((guint32) 1));
	_tmp3_ = self->priv->upower_device;
	_tmp4_ = power_upower_device_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	power_device_set_model (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->upower_device;
	_tmp8_ = power_upower_device_get_percentage (_tmp7_);
	_tmp9_ = _tmp8_;
	power_device_set_percentage (self, _tmp9_);
	_tmp10_ = self->priv->upower_device;
	_tmp11_ = power_upower_device_get_state (_tmp10_);
	_tmp12_ = _tmp11_;
	power_device_set_state (self, _tmp12_);
	_tmp13_ = self->priv->_device_type;
	switch (_tmp13_) {
		case POWER_DEVICE_TYPE_UPS:
		{
			power_device_set_icon_name (self, "uninterruptible-power-supply");
			break;
		}
		case POWER_DEVICE_TYPE_MOUSE:
		{
			power_device_set_icon_name (self, "input-mouse");
			break;
		}
		case POWER_DEVICE_TYPE_KEYBOARD:
		{
			power_device_set_icon_name (self, "input-keyboard");
			break;
		}
		case POWER_DEVICE_TYPE_PDA:
		case POWER_DEVICE_TYPE_PHONE:
		{
			power_device_set_icon_name (self, "phone");
			break;
		}
		case POWER_DEVICE_TYPE_MEDIA_PLAYER:
		{
			power_device_set_icon_name (self, "multimedia-player");
			break;
		}
		case POWER_DEVICE_TYPE_TABLET:
		{
			power_device_set_icon_name (self, "input-touchpad");
			break;
		}
		case POWER_DEVICE_TYPE_PEN:
		{
			power_device_set_icon_name (self, "input-tablet");
			break;
		}
		case POWER_DEVICE_TYPE_GAMING_INPUT:
		{
			power_device_set_icon_name (self, "input-gaming");
			break;
		}
		case POWER_DEVICE_TYPE_COMPUTER:
		{
			const gchar* _tmp14_;
			_tmp14_ = self->priv->_model;
			if (g_strcmp0 (_tmp14_, "iPad") == 0) {
				power_device_set_icon_name (self, "computer-tablet");
			} else {
				power_device_set_icon_name (self, "computer-laptop");
			}
			break;
		}
		case POWER_DEVICE_TYPE_MONITOR:
		{
			power_device_set_icon_name (self, "video-display");
			break;
		}
		case POWER_DEVICE_TYPE_LINE_POWER:
		{
			power_device_set_icon_name (self, "battery-ac-adapter");
			break;
		}
		default:
		{
			power_device_set_icon_name (self, "battery");
			break;
		}
	}
}

static void
power_device_update_description (PowerDevice* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_coarse_battery_level;
	if (_tmp0_) {
		gdouble _tmp1_;
		_tmp1_ = self->priv->_percentage;
		if (_tmp1_ < ((gdouble) 20)) {
			power_device_set_description (self, C_ ("battery-level", "Critical"));
		} else {
			gdouble _tmp2_;
			_tmp2_ = self->priv->_percentage;
			if (_tmp2_ < ((gdouble) 40)) {
				power_device_set_description (self, C_ ("battery-level", "Low"));
			} else {
				gdouble _tmp3_;
				_tmp3_ = self->priv->_percentage;
				if (_tmp3_ < ((gdouble) 60)) {
					power_device_set_description (self, C_ ("battery-level", "Good"));
				} else {
					gdouble _tmp4_;
					_tmp4_ = self->priv->_percentage;
					if (_tmp4_ < ((gdouble) 80)) {
						power_device_set_description (self, C_ ("battery-level", "High"));
					} else {
						power_device_set_description (self, C_ ("battery-level", "Full"));
					}
				}
			}
		}
	} else {
		gboolean _tmp5_ = FALSE;
		gdouble _tmp6_;
		_tmp6_ = self->priv->_percentage;
		if (_tmp6_ == ((gdouble) 0)) {
			PowerDeviceState _tmp7_;
			_tmp7_ = self->priv->_state;
			_tmp5_ = _tmp7_ == POWER_DEVICE_STATE_UNKNOWN;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			power_device_set_description (self, _ ("Unknown. Device may be locked."));
		} else {
			gdouble _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->_percentage;
			_tmp9_ = g_strdup_printf ("%.0f%%", _tmp8_);
			_tmp10_ = _tmp9_;
			power_device_set_description (self, _tmp10_);
			_g_free0 (_tmp10_);
		}
	}
}

gboolean
power_device_equal_func (PowerDevice* self,
                         PowerDevice* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	if (self == other) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_path;
		_tmp2_ = other->priv->_path;
		_tmp0_ = g_strcmp0 (_tmp1_, _tmp2_) == 0;
	}
	result = _tmp0_;
	return result;
}

const gchar*
power_device_get_path (PowerDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

static void
power_device_set_path (PowerDevice* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_PATH_PROPERTY]);
	}
}

gboolean
power_device_get_power_supply (PowerDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_power_supply;
	return result;
}

static void
power_device_set_power_supply (PowerDevice* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_power_supply (self);
	if (old_value != value) {
		self->priv->_power_supply = value;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_POWER_SUPPLY_PROPERTY]);
	}
}

gdouble
power_device_get_percentage (PowerDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percentage;
	return result;
}

static void
power_device_set_percentage (PowerDevice* self,
                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_percentage (self);
	if (old_value != value) {
		self->priv->_percentage = value;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_PERCENTAGE_PROPERTY]);
	}
}

gboolean
power_device_get_coarse_battery_level (PowerDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coarse_battery_level;
	return result;
}

static void
power_device_set_coarse_battery_level (PowerDevice* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_coarse_battery_level (self);
	if (old_value != value) {
		self->priv->_coarse_battery_level = value;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY]);
	}
}

const gchar*
power_device_get_description (PowerDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
power_device_set_description (PowerDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
power_device_get_icon_name (PowerDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
power_device_set_icon_name (PowerDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_ICON_NAME_PROPERTY]);
	}
}

const gchar*
power_device_get_model (PowerDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
power_device_set_model (PowerDevice* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_model (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_MODEL_PROPERTY]);
	}
}

PowerDeviceState
power_device_get_state (PowerDevice* self)
{
	PowerDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
power_device_set_state (PowerDevice* self,
                        PowerDeviceState value)
{
	PowerDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_STATE_PROPERTY]);
	}
}

PowerDeviceType
power_device_get_device_type (PowerDevice* self)
{
	PowerDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_device_type;
	return result;
}

static void
power_device_set_device_type (PowerDevice* self,
                              PowerDeviceType value)
{
	PowerDeviceType old_value;
	g_return_if_fail (self != NULL);
	old_value = power_device_get_device_type (self);
	if (old_value != value) {
		self->priv->_device_type = value;
		g_object_notify_by_pspec ((GObject *) self, power_device_properties[POWER_DEVICE_DEVICE_TYPE_PROPERTY]);
	}
}

static void
_power_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                   GVariant* changed_properties,
                                                                   gchar** invalidated_properties,
                                                                   gpointer self)
{
	power_device_update_properties ((PowerDevice*) self);
}

static void
_power_device_update_description_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	power_device_update_description ((PowerDevice*) self);
}

static GObject *
power_device_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerDevice * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (power_device_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_DEVICE, PowerDevice);
	{
		PowerUpowerDevice* _tmp0_ = NULL;
		const gchar* _tmp1_;
		PowerUpowerDevice* _tmp2_;
		PowerUpowerDevice* _tmp3_;
		PowerUpowerDevice* _tmp4_;
		PowerDeviceType _tmp5_;
		PowerDeviceType _tmp6_;
		PowerUpowerDevice* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		PowerUpowerDevice* _tmp10_;
		_tmp1_ = self->priv->_path;
		_tmp2_ = (PowerUpowerDevice*) g_initable_new (POWER_TYPE_UPOWER_DEVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", POWER_DEVICE_UPOWER_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp1_, "g-interface-name", "org.freedesktop.UPower.Device", NULL);
		_tmp0_ = (PowerUpowerDevice*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->upower_device);
		self->priv->upower_device = _tmp3_;
		_tmp4_ = self->priv->upower_device;
		_tmp5_ = power_upower_device_get_device_type (_tmp4_);
		_tmp6_ = _tmp5_;
		power_device_set_device_type (self, _tmp6_);
		_tmp7_ = self->priv->upower_device;
		_tmp8_ = power_upower_device_get_power_supply (_tmp7_);
		_tmp9_ = _tmp8_;
		power_device_set_power_supply (self, _tmp9_);
		power_device_update_properties (self);
		_tmp10_ = self->priv->upower_device;
		g_signal_connect_object ((GDBusProxy*) _tmp10_, "g-properties-changed", (GCallback) _power_device_update_properties_g_dbus_proxy_g_properties_changed, self, 0);
		power_device_update_description (self);
		g_signal_connect_object ((GObject*) self, "notify::percentage", (GCallback) _power_device_update_description_g_object_notify, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("Device.vala:132: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
power_device_class_init (PowerDeviceClass * klass,
                         gpointer klass_data)
{
	power_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_device_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_device_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_PATH_PROPERTY, power_device_properties[POWER_DEVICE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_POWER_SUPPLY_PROPERTY, power_device_properties[POWER_DEVICE_POWER_SUPPLY_PROPERTY] = g_param_spec_boolean ("power-supply", "power-supply", "power-supply", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_PERCENTAGE_PROPERTY, power_device_properties[POWER_DEVICE_PERCENTAGE_PROPERTY] = g_param_spec_double ("percentage", "percentage", "percentage", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY, power_device_properties[POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY] = g_param_spec_boolean ("coarse-battery-level", "coarse-battery-level", "coarse-battery-level", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_DESCRIPTION_PROPERTY, power_device_properties[POWER_DEVICE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_ICON_NAME_PROPERTY, power_device_properties[POWER_DEVICE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_MODEL_PROPERTY, power_device_properties[POWER_DEVICE_MODEL_PROPERTY] = g_param_spec_string ("model", "model", "model", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_STATE_PROPERTY, power_device_properties[POWER_DEVICE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", POWER_DEVICE_TYPE_STATE, POWER_DEVICE_STATE_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICE_DEVICE_TYPE_PROPERTY, power_device_properties[POWER_DEVICE_DEVICE_TYPE_PROPERTY] = g_param_spec_enum ("device-type", "device-type", "device-type", POWER_DEVICE_TYPE_TYPE, POWER_DEVICE_TYPE_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
power_device_instance_init (PowerDevice * self,
                            gpointer klass)
{
	self->priv = power_device_get_instance_private (self);
	self->priv->_percentage = (gdouble) -1;
	self->priv->_coarse_battery_level = FALSE;
	self->priv->_state = POWER_DEVICE_STATE_UNKNOWN;
	self->priv->_device_type = POWER_DEVICE_TYPE_UNKNOWN;
}

static void
power_device_finalize (GObject * obj)
{
	PowerDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_DEVICE, PowerDevice);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_model);
	_g_object_unref0 (self->priv->upower_device);
	G_OBJECT_CLASS (power_device_parent_class)->finalize (obj);
}

static GType
power_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerDevice), 0, (GInstanceInitFunc) power_device_instance_init, NULL };
	GType power_device_type_id;
	power_device_type_id = g_type_register_static (G_TYPE_OBJECT, "PowerDevice", &g_define_type_info, 0);
	PowerDevice_private_offset = g_type_add_instance_private (power_device_type_id, sizeof (PowerDevicePrivate));
	return power_device_type_id;
}

GType
power_device_get_type (void)
{
	static volatile gsize power_device_type_id__once = 0;
	if (g_once_init_enter (&power_device_type_id__once)) {
		GType power_device_type_id;
		power_device_type_id = power_device_get_type_once ();
		g_once_init_leave (&power_device_type_id__once, power_device_type_id);
	}
	return power_device_type_id__once;
}

static void
_vala_power_device_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	PowerDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_DEVICE, PowerDevice);
	switch (property_id) {
		case POWER_DEVICE_PATH_PROPERTY:
		g_value_set_string (value, power_device_get_path (self));
		break;
		case POWER_DEVICE_POWER_SUPPLY_PROPERTY:
		g_value_set_boolean (value, power_device_get_power_supply (self));
		break;
		case POWER_DEVICE_PERCENTAGE_PROPERTY:
		g_value_set_double (value, power_device_get_percentage (self));
		break;
		case POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY:
		g_value_set_boolean (value, power_device_get_coarse_battery_level (self));
		break;
		case POWER_DEVICE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, power_device_get_description (self));
		break;
		case POWER_DEVICE_ICON_NAME_PROPERTY:
		g_value_set_string (value, power_device_get_icon_name (self));
		break;
		case POWER_DEVICE_MODEL_PROPERTY:
		g_value_set_string (value, power_device_get_model (self));
		break;
		case POWER_DEVICE_STATE_PROPERTY:
		g_value_set_enum (value, power_device_get_state (self));
		break;
		case POWER_DEVICE_DEVICE_TYPE_PROPERTY:
		g_value_set_enum (value, power_device_get_device_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_device_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	PowerDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_DEVICE, PowerDevice);
	switch (property_id) {
		case POWER_DEVICE_PATH_PROPERTY:
		power_device_set_path (self, g_value_get_string (value));
		break;
		case POWER_DEVICE_POWER_SUPPLY_PROPERTY:
		power_device_set_power_supply (self, g_value_get_boolean (value));
		break;
		case POWER_DEVICE_PERCENTAGE_PROPERTY:
		power_device_set_percentage (self, g_value_get_double (value));
		break;
		case POWER_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY:
		power_device_set_coarse_battery_level (self, g_value_get_boolean (value));
		break;
		case POWER_DEVICE_DESCRIPTION_PROPERTY:
		power_device_set_description (self, g_value_get_string (value));
		break;
		case POWER_DEVICE_ICON_NAME_PROPERTY:
		power_device_set_icon_name (self, g_value_get_string (value));
		break;
		case POWER_DEVICE_MODEL_PROPERTY:
		power_device_set_model (self, g_value_get_string (value));
		break;
		case POWER_DEVICE_STATE_PROPERTY:
		power_device_set_state (self, g_value_get_enum (value));
		break;
		case POWER_DEVICE_DEVICE_TYPE_PROPERTY:
		power_device_set_device_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

