/* vinagre-utils.c generated by valac 0.56.18, the Vala compiler
 * generated from vinagre-utils.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "vinagre-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <glib-object.h>
#include <config.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _Block1Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	gchar* messages;
};

struct _Block3Data {
	int _ref_count_;
	GtkButton* ok_button;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
};

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GtkDialog* d,
                 gint response);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 const gchar* message);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_);
static void ___lambda6__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self);
static void __lambda7_ (Block3Data* _data3_);
static void ___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self);

gboolean
vinagre_utils_parse_boolean (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (str, "1") == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

void
vinagre_utils_set_widget_visible (GtkWidget* widget,
                                  gboolean visible)
{
	g_return_if_fail (widget != NULL);
	if (visible) {
		gtk_widget_show_all (widget);
	} else {
		gtk_widget_hide (widget);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dialog);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GtkDialog* d,
            gint response)
{
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (d != NULL);
	_tmp0_ = _data1_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda4_ (self, _sender, response_id);
}

void
vinagre_utils_show_error_dialog (const gchar* title,
                                 const gchar* message,
                                 GtkWindow* parent)
{
	Block1Data* _data1_;
	GtkMessageDialog* _tmp0_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	if (title == NULL) {
		title = _ ("An error occurred");
	}
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", title);
	g_object_ref_sink (_tmp0_);
	_data1_->dialog = _tmp0_;
	if (message != NULL) {
		GtkMessageDialog* _tmp1_;
		_tmp1_ = _data1_->dialog;
		gtk_message_dialog_format_secondary_markup (_tmp1_, "%s", message);
	}
	_tmp2_ = _data1_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp2_, "response", (GCallback) ___lambda4__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp3_ = _data1_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->messages);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda5_ (Block2Data* _data2_,
            const gchar* message)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = g_strdup_printf ("%s\n", message);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_data2_->messages, _tmp1_, NULL);
	_g_free0 (_data2_->messages);
	_data2_->messages = _tmp2_;
	_g_free0 (_tmp1_);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (const gchar*) data);
}

void
vinagre_utils_show_many_errors (const gchar* title,
                                GSList* items,
                                GtkWindow* parent)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	g_return_if_fail (parent != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_strdup ("");
	_data2_->messages = _tmp0_;
	g_slist_foreach (items, ___lambda5__gfunc, _data2_);
	vinagre_utils_show_error_dialog (title, _data2_->messages, parent);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

gboolean
vinagre_utils_create_dir_for_file (const gchar* filename,
                                   GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* parent = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* parent_path = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (filename);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_get_parent (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = parent;
	_tmp4_ = g_file_get_path (_tmp3_);
	parent_path = _tmp4_;
	_tmp5_ = parent_path;
	if (!g_file_test (_tmp5_, G_FILE_TEST_EXISTS)) {
		gboolean _tmp6_ = FALSE;
		GFile* _tmp7_;
		_tmp7_ = parent;
		_tmp6_ = g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (parent_path);
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			return _tmp8_;
		}
		result = _tmp6_;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	} else {
		result = TRUE;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	}
}

GtkBuilder*
vinagre_utils_get_builder (void)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_;
	GError* _inner_error0_ = NULL;
	GtkBuilder* result;
	_tmp0_ = vinagre_dirs_get_package_data_file ("vinagre.ui");
	filename = _tmp0_;
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		gtk_builder_add_from_file (builder, filename, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* subtitle = NULL;
		gchar* _tmp2_;
		gchar* closing = NULL;
		gchar* _tmp3_;
		gchar* message = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = g_strdup (_ ("Vinagre failed to open a UI file, with the error message:"));
		subtitle = _tmp2_;
		_tmp3_ = g_strdup (_ ("Please check your installation."));
		closing = _tmp3_;
		_tmp4_ = subtitle;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = closing;
		_tmp8_ = g_strdup_printf ("%s\n\n%s\n\n%s", _tmp4_, _tmp6_, _tmp7_);
		message = _tmp8_;
		_tmp9_ = message;
		vinagre_utils_show_error_dialog (_ ("Error loading UI file"), _tmp9_, NULL);
		_g_free0 (message);
		_g_free0 (closing);
		_g_free0 (subtitle);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (builder);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = builder;
	_g_free0 (filename);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->password_entry);
		_g_object_unref0 (_data3_->username_entry);
		_g_object_unref0 (_data3_->ok_button);
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (Block3Data* _data3_)
{
	gboolean enabled = FALSE;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEntry* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkButton* _tmp14_;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp4_;
			guint _tmp5_;
			guint _tmp6_;
			_tmp4_ = _data3_->username_entry;
			_tmp5_ = gtk_entry_get_text_length (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		enabled = _tmp3_;
	}
	_tmp7_ = _data3_->password_entry;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			_tmp11_ = _data3_->password_entry;
			_tmp12_ = gtk_entry_get_text_length (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp10_ = _tmp13_ > ((guint) 0);
		} else {
			_tmp10_ = FALSE;
		}
		enabled = _tmp10_;
	}
	_tmp14_ = _data3_->ok_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, enabled);
}

static void
___lambda6__gtk_editable_changed (GtkEditable* _sender,
                                  gpointer self)
{
	__lambda6_ (self);
}

static void
__lambda7_ (Block3Data* _data3_)
{
	gboolean enabled = FALSE;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEntry* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkButton* _tmp14_;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp4_;
			guint _tmp5_;
			guint _tmp6_;
			_tmp4_ = _data3_->username_entry;
			_tmp5_ = gtk_entry_get_text_length (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		enabled = _tmp3_;
	}
	_tmp7_ = _data3_->password_entry;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			_tmp11_ = _data3_->password_entry;
			_tmp12_ = gtk_entry_get_text_length (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp10_ = _tmp13_ > ((guint) 0);
		} else {
			_tmp10_ = FALSE;
		}
		enabled = _tmp10_;
	}
	_tmp14_ = _data3_->ok_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, enabled);
}

static void
___lambda7__gtk_editable_changed (GtkEditable* _sender,
                                  gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda8_ (Block3Data* _data3_)
{
	gboolean enabled = FALSE;
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkEntry* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkButton* _tmp14_;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp4_;
			guint _tmp5_;
			guint _tmp6_;
			_tmp4_ = _data3_->username_entry;
			_tmp5_ = gtk_entry_get_text_length (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		enabled = _tmp3_;
	}
	_tmp7_ = _data3_->password_entry;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		if (enabled) {
			GtkEntry* _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			_tmp11_ = _data3_->password_entry;
			_tmp12_ = gtk_entry_get_text_length (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp10_ = _tmp13_ > ((guint) 0);
		} else {
			_tmp10_ = FALSE;
		}
		enabled = _tmp10_;
	}
	_tmp14_ = _data3_->ok_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, enabled);
}

static void
___lambda8__gtk_editable_changed (GtkEditable* _sender,
                                  gpointer self)
{
	__lambda8_ (self);
}

gboolean
vinagre_utils_request_credential (GtkWindow* parent,
                                  const gchar* protocol,
                                  const gchar* host,
                                  const gchar* default_domain,
                                  const gchar* default_username,
                                  gboolean need_domain,
                                  gboolean need_username,
                                  gboolean need_password,
                                  gint password_limit,
                                  gchar** domain,
                                  gchar** username,
                                  gchar** password,
                                  gboolean* save_in_keyring)
{
	gchar* _vala_domain = NULL;
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gboolean _vala_save_in_keyring = FALSE;
	Block3Data* _data3_;
	GtkBuilder* xml = NULL;
	GtkBuilder* _tmp0_;
	GtkDialog* password_dialog = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkLabel* auth_label = NULL;
	GtkBuilder* _tmp5_;
	GObject* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* host_label = NULL;
	GtkBuilder* _tmp11_;
	GObject* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* password_label = NULL;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* username_label = NULL;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* domain_label = NULL;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GtkLabel* _tmp23_;
	GtkCheckButton* save_credential_check = NULL;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_;
	GtkCheckButton* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_;
	GtkButton* _tmp29_;
	GtkImage* image = NULL;
	GtkImage* _tmp30_;
	GtkButton* _tmp31_;
	GtkImage* _tmp32_;
	GtkEntry* domain_entry = NULL;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_;
	GtkEntry* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_;
	GtkEntry* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_;
	GtkEntry* _tmp41_;
	GtkEntry* _tmp42_;
	GtkEntry* _tmp46_;
	GtkEntry* _tmp51_;
	gint _result_ = 0;
	GtkDialog* _tmp55_;
	GtkDialog* _tmp80_;
	gboolean result;
	g_return_val_if_fail (parent != NULL, FALSE);
	g_return_val_if_fail (protocol != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = vinagre_utils_get_builder ();
	xml = _tmp0_;
	_tmp1_ = xml;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "auth_required_dialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
	password_dialog = _tmp3_;
	_tmp4_ = password_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, parent);
	_tmp5_ = xml;
	_tmp6_ = gtk_builder_get_object (_tmp5_, "auth_required_label");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp6_) : NULL);
	auth_label = _tmp7_;
	_tmp8_ = auth_label;
	_tmp9_ = g_strdup_printf (_ ("%s authentication is required"), protocol);
	_tmp10_ = _tmp9_;
	gtk_label_set_label (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = xml;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "host_label");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp12_) : NULL);
	host_label = _tmp13_;
	_tmp14_ = host_label;
	gtk_label_set_label (_tmp14_, host);
	_tmp15_ = xml;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "password_label");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp16_) : NULL);
	password_label = _tmp17_;
	_tmp18_ = xml;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "username_label");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp19_) : NULL);
	username_label = _tmp20_;
	_tmp21_ = xml;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "domain_label");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp22_) : NULL);
	domain_label = _tmp23_;
	_tmp24_ = xml;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "save_credential_check");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp25_) : NULL);
	save_credential_check = _tmp26_;
	_tmp27_ = xml;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "ok_button");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_button_get_type ()) ? ((GtkButton*) _tmp28_) : NULL);
	_data3_->ok_button = _tmp29_;
	_tmp30_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_AUTHENTICATION, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp30_);
	image = _tmp30_;
	_tmp31_ = _data3_->ok_button;
	_tmp32_ = image;
	gtk_button_set_image (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = xml;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "domain_entry");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp34_) : NULL);
	domain_entry = _tmp35_;
	_tmp36_ = xml;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "username_entry");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp37_) : NULL);
	_data3_->username_entry = _tmp38_;
	_tmp39_ = xml;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "password_entry");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp40_) : NULL);
	_data3_->password_entry = _tmp41_;
	_tmp42_ = domain_entry;
	g_signal_connect_data ((GtkEditable*) _tmp42_, "changed", (GCallback) ___lambda6__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	if (!need_domain) {
		GtkLabel* _tmp43_;
		GtkEntry* _tmp44_;
		_tmp43_ = domain_label;
		gtk_widget_hide ((GtkWidget*) _tmp43_);
		_tmp44_ = domain_entry;
		gtk_widget_hide ((GtkWidget*) _tmp44_);
	} else {
		if (default_domain != NULL) {
			GtkEntry* _tmp45_;
			_tmp45_ = domain_entry;
			gtk_entry_set_text (_tmp45_, default_domain);
		}
	}
	_tmp46_ = _data3_->username_entry;
	g_signal_connect_data ((GtkEditable*) _tmp46_, "changed", (GCallback) ___lambda7__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	if (!need_username) {
		GtkLabel* _tmp47_;
		GtkEntry* _tmp48_;
		_tmp47_ = username_label;
		gtk_widget_hide ((GtkWidget*) _tmp47_);
		_tmp48_ = _data3_->username_entry;
		gtk_widget_hide ((GtkWidget*) _tmp48_);
	} else {
		if (default_username != NULL) {
			GtkEntry* _tmp49_;
			GtkEntry* _tmp50_;
			_tmp49_ = _data3_->username_entry;
			gtk_entry_set_text (_tmp49_, default_username);
			_tmp50_ = _data3_->password_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp50_);
		}
	}
	_tmp51_ = _data3_->password_entry;
	g_signal_connect_data ((GtkEditable*) _tmp51_, "changed", (GCallback) ___lambda8__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	if (need_password) {
		GtkEntry* _tmp52_;
		_tmp52_ = _data3_->password_entry;
		gtk_entry_set_max_length (_tmp52_, password_limit);
	} else {
		GtkLabel* _tmp53_;
		GtkEntry* _tmp54_;
		_tmp53_ = password_label;
		gtk_widget_hide ((GtkWidget*) _tmp53_);
		_tmp54_ = _data3_->password_entry;
		gtk_widget_hide ((GtkWidget*) _tmp54_);
	}
	_tmp55_ = password_dialog;
	_result_ = gtk_dialog_run (_tmp55_);
	if (_result_ == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp56_;
		guint _tmp57_;
		guint _tmp58_;
		GtkEntry* _tmp63_;
		guint _tmp64_;
		guint _tmp65_;
		GtkEntry* _tmp70_;
		guint _tmp71_;
		guint _tmp72_;
		GtkCheckButton* _tmp77_;
		gboolean _tmp78_;
		gboolean _tmp79_;
		_tmp56_ = domain_entry;
		_tmp57_ = gtk_entry_get_text_length (_tmp56_);
		_tmp58_ = _tmp57_;
		if (_tmp58_ > ((guint) 0)) {
			GtkEntry* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp59_ = domain_entry;
			_tmp60_ = gtk_entry_get_text (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = g_strdup (_tmp61_);
			_g_free0 (_vala_domain);
			_vala_domain = _tmp62_;
		}
		_tmp63_ = _data3_->username_entry;
		_tmp64_ = gtk_entry_get_text_length (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_ > ((guint) 0)) {
			GtkEntry* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			_tmp66_ = _data3_->username_entry;
			_tmp67_ = gtk_entry_get_text (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strdup (_tmp68_);
			_g_free0 (_vala_username);
			_vala_username = _tmp69_;
		}
		_tmp70_ = _data3_->password_entry;
		_tmp71_ = gtk_entry_get_text_length (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_tmp72_ > ((guint) 0)) {
			GtkEntry* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			gchar* _tmp76_;
			_tmp73_ = _data3_->password_entry;
			_tmp74_ = gtk_entry_get_text (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strdup (_tmp75_);
			_g_free0 (_vala_password);
			_vala_password = _tmp76_;
		}
		_tmp77_ = save_credential_check;
		_tmp78_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp77_);
		_tmp79_ = _tmp78_;
		_vala_save_in_keyring = _tmp79_;
	}
	_tmp80_ = password_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp80_);
	result = _result_ == ((gint) GTK_RESPONSE_OK);
	_g_object_unref0 (domain_entry);
	_g_object_unref0 (image);
	_g_object_unref0 (save_credential_check);
	_g_object_unref0 (domain_label);
	_g_object_unref0 (username_label);
	_g_object_unref0 (password_label);
	_g_object_unref0 (host_label);
	_g_object_unref0 (auth_label);
	_g_object_unref0 (password_dialog);
	_g_object_unref0 (xml);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	if (domain) {
		*domain = _vala_domain;
	} else {
		_g_free0 (_vala_domain);
	}
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
	if (save_in_keyring) {
		*save_in_keyring = _vala_save_in_keyring;
	}
	return result;
}

void
vinagre_utils_show_help (GtkWindow* window,
                         const gchar* page)
{
	gchar* uri = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (window != NULL);
	if (page != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat ("help:" PACKAGE_TARNAME "/", page, NULL);
		_g_free0 (uri);
		uri = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("help:" PACKAGE_TARNAME);
		_g_free0 (uri);
		uri = _tmp1_;
	}
	{
		GdkScreen* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = gtk_window_get_screen (window);
		_tmp3_ = uri;
		gtk_show_uri (_tmp2_, _tmp3_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		vinagre_utils_show_error_dialog (_ ("Error showing help"), _tmp5_, window);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (uri);
}

void
vinagre_utils_show_help_about (GtkWindow* parent)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkAboutDialog* dialog = NULL;
	GObject* _tmp1_;
	GtkAboutDialog* _tmp2_;
	g_return_if_fail (parent != NULL);
	_tmp0_ = vinagre_utils_get_builder ();
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "about_dialog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_about_dialog_get_type ()) ? ((GtkAboutDialog*) _tmp1_) : NULL);
	dialog = _tmp2_;
	gtk_about_dialog_set_logo_icon_name (dialog, PACKAGE_TARNAME);
	gtk_about_dialog_set_version (dialog, PACKAGE_VERSION);
	gtk_about_dialog_set_website (dialog, PACKAGE_URL);
	gtk_window_set_transient_for ((GtkWindow*) dialog, parent);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (builder);
}

