// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkIOParallelXdmf3ObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkPXdmf3Writer.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkIOParallelXdmf3ObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkPXdmf3Writer)


vtkIOParallelXdmf3ObjectFactory::vtkIOParallelXdmf3ObjectFactory()
{
this->RegisterOverride("vtkXdmf3Writer", "vtkPXdmf3Writer", "Override for VTK::IOParallelXdmf3 module", 1, vtkObjectFactoryCreatevtkPXdmf3Writer);

}

const char * vtkIOParallelXdmf3ObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkIOParallelXdmf3ObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkIOParallelXdmf3Count = 0;

VTKIOPARALLELXDMF3_EXPORT void vtkIOParallelXdmf3_AutoInit_Construct()
{
  if(++vtkIOParallelXdmf3Count == 1)
  {


    vtkIOParallelXdmf3ObjectFactory* factory = vtkIOParallelXdmf3ObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
