// java wrapper for vtkTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkLinearTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTransform",dType)) { return me; }
  if ((res= vtkLinearTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Identity_14(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Inverse_15(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Translate_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Translate_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Translate_18(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateWXYZ_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateWXYZ_110(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateWXYZ_111(JNIEnv* env, jobject obj,jdouble id0,jfloatArray id1)
{
  double   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateX_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateX(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateY_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateY(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_RotateZ_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateZ(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Scale_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Scale_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Scale_117(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_SetMatrix_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_SetMatrix_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Concatenate_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Concatenate_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Concatenate_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLinearTransform * temp0;
  temp0 = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_PreMultiply_123(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreMultiply();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_PostMultiply_124(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PostMultiply();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform_GetNumberOfConcatenatedTransforms_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConcatenatedTransforms();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetConcatenatedTransform_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkLinearTransform * temp20;
  temp0 = id0;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConcatenatedTransform(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetOrientation_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetOrientation_128(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientation(temp0);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransform_GetOrientation_129(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetOrientation_130(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkMatrix4x4 * temp1;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientation(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetOrientationWXYZ_131(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientationWXYZ(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetOrientationWXYZ_132(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrientationWXYZ(temp0);
  env->SetFloatArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransform_GetOrientationWXYZ_133(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationWXYZ();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetPosition_134(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetPosition_135(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransform_GetPosition_136(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetScale_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScale(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetScale_138(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScale(temp0);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransform_GetScale_139(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetInverse_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetInverse(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_GetTranspose_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTranspose(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_SetInput_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLinearTransform * temp0;
  temp0 = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetInput_143(JNIEnv* env, jobject obj)
{
  vtkLinearTransform * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform_GetInverseFlag_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Push_145(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Push();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_Pop_146(JNIEnv* env, jobject obj)
{

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pop();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform_CircuitCheck_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CircuitCheck(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetInverse_148(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverse();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_MakeTransform_149(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform_GetMTime_150(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_MultiplyPoint_151(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[4];
  float temp1[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform_MultiplyPoint_152(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[4];
  double temp1[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkTransform* op = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTransform::New());
}
