// java wrapper for vtkOpenGLBufferObject object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLBufferObject.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLBufferObject_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLBufferObject",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLBufferObject_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLBufferObject_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLBufferObject_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLBufferObject_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLBufferObject_GetType_14(JNIEnv* env, jobject obj)
{
  vtkOpenGLBufferObject::ObjectType   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetType();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLBufferObject_SetType_15(JNIEnv* env, jobject obj,jint id0)
{
  vtkOpenGLBufferObject::ObjectType   temp0;
  temp0 = static_cast<vtkOpenGLBufferObject::ObjectType>(id0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLBufferObject_GetUsage_16(JNIEnv* env, jobject obj)
{
  vtkOpenGLBufferObject::ObjectUsage   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUsage();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLBufferObject_SetUsage_17(JNIEnv* env, jobject obj,jint id0)
{
  vtkOpenGLBufferObject::ObjectUsage   temp0;
  temp0 = static_cast<vtkOpenGLBufferObject::ObjectUsage>(id0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUsage(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLBufferObject_GetHandle_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandle();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLBufferObject_IsReady_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsReady();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLBufferObject_FlagBufferAsDirty_110(JNIEnv* env, jobject obj)
{

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->FlagBufferAsDirty();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLBufferObject_GenerateBuffer_111(JNIEnv* env, jobject obj,jint id0)
{
  vtkOpenGLBufferObject::ObjectType   temp0;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLBufferObject::ObjectType>(id0);

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GenerateBuffer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLBufferObject_Bind_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Bind();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLBufferObject_BindShaderStorage_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BindShaderStorage(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLBufferObject_Release_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Release();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLBufferObject_ReleaseGraphicsResources_115(JNIEnv* env, jobject obj)
{

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLBufferObject_GetError_116(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkOpenGLBufferObject* op = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetError();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenGLBufferObject_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenGLBufferObject::New());
}
