// java wrapper for vtkOpenXRRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenXRRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkVRRenderWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenXRRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenXRRenderWindow",dType)) { return me; }
  if ((res= vtkVRRenderWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenXRRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenXRRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRRenderWindow_MakeRenderWindowInteractor_14(JNIEnv* env, jobject obj)
{
  vtkRenderWindowInteractor * temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeRenderWindowInteractor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_AddRenderer_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_StereoUpdate_16(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoUpdate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_StereoMidpoint_17(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoMidpoint();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_StereoRenderComplete_18(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoRenderComplete();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_Render_19(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_Initialize_110(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_Finalize_111(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenXRRenderWindow_ReportCapabilities_112(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetSizeFromAPI_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSizeFromAPI();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetEventPending_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPending();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_SetModelActiveState_115(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelActiveState(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_UpdateHMDMatrixPose_116(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateHMDMatrixPose();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_RenderModels_117(JNIEnv* env, jobject obj)
{

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderModels();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetModelsManifestDirectory_118(JNIEnv* env, jobject obj)
{
  std::string * temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetModelsManifestDirectory();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_SetModelsManifestDirectory_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelsManifestDirectory(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_SetUseDepthExtension_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDepthExtension(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetUseDepthExtension_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDepthExtension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRRenderWindow_SetEnableSceneUnderstanding_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableSceneUnderstanding(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetEnableSceneUnderstanding_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableSceneUnderstanding();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRRenderWindow_GetSceneObserver_124(JNIEnv* env, jobject obj)
{
  vtkOpenXRSceneObserver * temp20;

  vtkOpenXRRenderWindow* op = static_cast<vtkOpenXRRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSceneObserver();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenXRRenderWindow_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenXRRenderWindow::New());
}
