/* EtherInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from EtherInterface.vala, do not modify */

/*
* Copyright 2015-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "network.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <granite.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_ETHER_INTERFACE_0_PROPERTY,
	NETWORK_ETHER_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_ether_interface_properties[NETWORK_ETHER_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _NetworkEtherInterfacePrivate {
	GtkToggleButton* ethernet_item;
};

struct _Block2Data {
	int _ref_count_;
	NetworkEtherInterface* self;
	NMClient* nm_client;
};

static gint NetworkEtherInterface_private_offset;
static gpointer network_ether_interface_parent_class = NULL;
static GtkCssProvider* network_ether_interface_provider;
static GtkCssProvider* network_ether_interface_provider = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_);
static void ____lambda7_ (NetworkEtherInterface* self);
static void _____lambda7__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void network_ether_interface_update (NetworkEtherInterface* self);
static void _network_ether_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                              guint new_state,
                                                              guint old_state,
                                                              guint reason,
                                                              gpointer self);
static void network_ether_interface_finalize (GObject * obj);
static GType network_ether_interface_get_type_once (void);

static inline gpointer
network_ether_interface_get_instance_private (NetworkEtherInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkEtherInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NetworkEtherInterface* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
____lambda7_ (NetworkEtherInterface* self)
{
	g_debug ("EtherInterface.vala:64: Successfully disconnected.");
}

static void
_____lambda7__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda7_ ((NetworkEtherInterface*) self);
	g_object_unref (self);
}

static void
__lambda6_ (Block2Data* _data2_)
{
	NetworkEtherInterface* self;
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	g_debug ("EtherInterface.vala:53: update");
	_tmp1_ = self->priv->ethernet_item;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		NMDevice* _tmp4_;
		NMDevice* _tmp5_;
		_tmp4_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp5_ = _tmp4_;
		_tmp0_ = nm_device_get_state (_tmp5_) == NM_DEVICE_STATE_DISCONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMConnection* connection = NULL;
		NMConnection* _tmp6_;
		GPtrArray* remote_array = NULL;
		NMDevice* _tmp7_;
		NMDevice* _tmp8_;
		GPtrArray* _tmp9_;
		GPtrArray* _tmp10_;
		GPtrArray* _tmp11_;
		_tmp6_ = nm_simple_connection_new ();
		connection = _tmp6_;
		_tmp7_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = nm_device_get_available_connections (_tmp8_);
		_tmp10_ = _g_ptr_array_ref0 (_tmp9_);
		remote_array = _tmp10_;
		_tmp11_ = remote_array;
		if (_tmp11_ == NULL) {
			g_critical ("EtherInterface.vala:58: Unable to find an ethernet connection to activ" \
"ate");
		} else {
			NMConnection* _tmp12_;
			GPtrArray* _tmp13_;
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			NMConnection* _tmp16_;
			NMDevice* _tmp17_;
			NMDevice* _tmp18_;
			_tmp12_ = connection;
			_tmp13_ = remote_array;
			_tmp14_ = g_ptr_array_index (_tmp13_, (guint) 0);
			_tmp15_ = nm_connection_get_path ((NMConnection*) ((NMRemoteConnection*) _tmp14_));
			nm_connection_set_path (_tmp12_, _tmp15_);
			_tmp16_ = connection;
			_tmp17_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp18_ = _tmp17_;
			nm_client_activate_connection_async (_data2_->nm_client, _tmp16_, _tmp18_, NULL, NULL, NULL, NULL);
		}
		_g_ptr_array_unref0 (remote_array);
		_g_object_unref0 (connection);
	} else {
		gboolean _tmp19_ = FALSE;
		GtkToggleButton* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->ethernet_item;
		_tmp21_ = gtk_toggle_button_get_active (_tmp20_);
		_tmp22_ = _tmp21_;
		if (!_tmp22_) {
			NMDevice* _tmp23_;
			NMDevice* _tmp24_;
			_tmp23_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp24_ = _tmp23_;
			_tmp19_ = nm_device_get_state (_tmp24_) == NM_DEVICE_STATE_ACTIVATED;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			NMDevice* _tmp25_;
			NMDevice* _tmp26_;
			_tmp25_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
			_tmp26_ = _tmp25_;
			nm_device_disconnect_async (_tmp26_, NULL, _____lambda7__gasync_ready_callback, g_object_ref (self));
		}
	}
}

static void
___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda6_ (self);
}

static void
_network_ether_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                         guint new_state,
                                                         guint old_state,
                                                         guint reason,
                                                         gpointer self)
{
	network_ether_interface_update ((NetworkEtherInterface*) self);
}

NetworkEtherInterface*
network_ether_interface_construct (GType object_type,
                                   NMClient* nm_client,
                                   NMDevice* _device)
{
	NetworkEtherInterface * self = NULL;
	Block2Data* _data2_;
	NMClient* _tmp0_;
	GtkImage* _tmp1_;
	GtkToggleButton* _tmp2_ = NULL;
	GtkToggleButton* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkCssProvider* _tmp7_;
	GtkLabel* label = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkLabel* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_;
	GtkToggleButton* _tmp12_;
	GtkToggleButton* _tmp13_;
	NMDevice* _tmp14_;
	NMDevice* _tmp15_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data2_->nm_client);
	_data2_->nm_client = _tmp0_;
	self = (NetworkEtherInterface*) network_widget_nm_interface_construct (object_type);
	_data2_->self = g_object_ref (self);
	network_widget_nm_interface_set_device ((NetworkWidgetNMInterface*) self, _device);
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-network-wired-connected-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	gtk_button_set_image ((GtkButton*) _tmp2_, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->ethernet_item);
	self->priv->ethernet_item = _tmp2_;
	_tmp3_ = self->priv->ethernet_item;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "circular");
	_tmp5_ = self->priv->ethernet_item;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = network_ether_interface_provider;
	gtk_style_context_add_provider (_tmp6_, (GtkStyleProvider*) _tmp7_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp8_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_max_width_chars (_tmp10_, 16);
	g_object_ref_sink (_tmp10_);
	label = _tmp10_;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_add_class (_tmp11_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 3);
	_tmp12_ = self->priv->ethernet_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	g_object_bind_property_with_closures ((GObject*) self, "display-title", (GObject*) label, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = self->priv->ethernet_item;
	g_signal_connect_data (_tmp13_, "toggled", (GCallback) ___lambda6__gtk_toggle_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	network_ether_interface_update (self);
	_tmp14_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "state-changed", (GCallback) _network_ether_interface_update_nm_device_state_changed, self, 0);
	_g_object_unref0 (label);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

NetworkEtherInterface*
network_ether_interface_new (NMClient* nm_client,
                             NMDevice* _device)
{
	return network_ether_interface_construct (NETWORK_TYPE_ETHER_INTERFACE, nm_client, _device);
}

static void
network_ether_interface_update (NetworkEtherInterface* self)
{
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_device ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	switch (nm_device_get_state (_tmp1_)) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_DEACTIVATING:
		case NM_DEVICE_STATE_FAILED:
		{
			GtkToggleButton* _tmp2_;
			GtkToggleButton* _tmp3_;
			GtkWidget* _tmp4_;
			GtkWidget* _tmp5_;
			gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
			_tmp2_ = self->priv->ethernet_item;
			gtk_toggle_button_set_active (_tmp2_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED);
			_tmp3_ = self->priv->ethernet_item;
			_tmp4_ = gtk_button_get_image ((GtkButton*) _tmp3_);
			_tmp5_ = _tmp4_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-wired-error-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			GtkToggleButton* _tmp6_;
			GtkToggleButton* _tmp7_;
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
			_tmp6_ = self->priv->ethernet_item;
			gtk_toggle_button_set_active (_tmp6_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_WIRED_UNPLUGGED);
			_tmp7_ = self->priv->ethernet_item;
			_tmp8_ = gtk_button_get_image ((GtkButton*) _tmp7_);
			_tmp9_ = _tmp8_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-wired-no-route-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			GtkToggleButton* _tmp10_;
			GtkToggleButton* _tmp11_;
			GtkWidget* _tmp12_;
			GtkWidget* _tmp13_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp10_ = self->priv->ethernet_item;
			gtk_toggle_button_set_active (_tmp10_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_WIRED_UNPLUGGED);
			_tmp11_ = self->priv->ethernet_item;
			_tmp12_ = gtk_button_get_image ((GtkButton*) _tmp11_);
			_tmp13_ = _tmp12_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-wired-offline-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			GtkToggleButton* _tmp14_;
			GtkToggleButton* _tmp15_;
			GtkWidget* _tmp16_;
			GtkWidget* _tmp17_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp14_ = self->priv->ethernet_item;
			gtk_toggle_button_set_active (_tmp14_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_WIRED);
			_tmp15_ = self->priv->ethernet_item;
			_tmp16_ = gtk_button_get_image ((GtkButton*) _tmp15_);
			_tmp17_ = _tmp16_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-wired-acquiring-symbolic", NULL);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			GtkToggleButton* _tmp18_;
			GtkToggleButton* _tmp19_;
			GtkWidget* _tmp20_;
			GtkWidget* _tmp21_;
			gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
			_tmp18_ = self->priv->ethernet_item;
			gtk_toggle_button_set_active (_tmp18_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTED_WIRED);
			_tmp19_ = self->priv->ethernet_item;
			_tmp20_ = gtk_button_get_image ((GtkButton*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_image_get_type (), GtkImage), "icon-name", "panel-network-wired-connected-symbolic-symbolic", NULL);
			break;
		}
		default:
		break;
	}
}

static void
network_ether_interface_class_init (NetworkEtherInterfaceClass * klass,
                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	network_ether_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkEtherInterface_private_offset);
	G_OBJECT_CLASS (klass)->finalize = network_ether_interface_finalize;
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (network_ether_interface_provider);
	network_ether_interface_provider = _tmp0_;
	_tmp1_ = network_ether_interface_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/wingpanel/network/Indicator.css");
}

static void
network_ether_interface_instance_init (NetworkEtherInterface * self,
                                       gpointer klass)
{
	self->priv = network_ether_interface_get_instance_private (self);
}

static void
network_ether_interface_finalize (GObject * obj)
{
	NetworkEtherInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ETHER_INTERFACE, NetworkEtherInterface);
	_g_object_unref0 (self->priv->ethernet_item);
	G_OBJECT_CLASS (network_ether_interface_parent_class)->finalize (obj);
}

static GType
network_ether_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkEtherInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_ether_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkEtherInterface), 0, (GInstanceInitFunc) network_ether_interface_instance_init, NULL };
	GType network_ether_interface_type_id;
	network_ether_interface_type_id = g_type_register_static (NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkEtherInterface", &g_define_type_info, 0);
	NetworkEtherInterface_private_offset = g_type_add_instance_private (network_ether_interface_type_id, sizeof (NetworkEtherInterfacePrivate));
	return network_ether_interface_type_id;
}

GType
network_ether_interface_get_type (void)
{
	static volatile gsize network_ether_interface_type_id__once = 0;
	if (g_once_init_enter (&network_ether_interface_type_id__once)) {
		GType network_ether_interface_type_id;
		network_ether_interface_type_id = network_ether_interface_get_type_once ();
		g_once_init_leave (&network_ether_interface_type_id__once, network_ether_interface_type_id);
	}
	return network_ether_interface_type_id__once;
}

