/* sound.h generated by valac 0.56.18, the Vala compiler, do not modify */

#ifndef __SOUND_H__
#define __SOUND_H__

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <wingpanel.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS

#define GETTEXT_PACKAGE "sound-indicator"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SOUND_TYPE_DEVICE (sound_device_get_type ())
#define SOUND_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_TYPE_DEVICE, SoundDevice))
#define SOUND_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_TYPE_DEVICE, SoundDeviceClass))
#define SOUND_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_TYPE_DEVICE))
#define SOUND_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_TYPE_DEVICE))
#define SOUND_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_TYPE_DEVICE, SoundDeviceClass))

typedef struct _SoundDevice SoundDevice;
typedef struct _SoundDeviceClass SoundDeviceClass;
typedef struct _SoundDevicePrivate SoundDevicePrivate;

#define SOUND_DEVICE_TYPE_PORT (sound_device_port_get_type ())
#define SOUND_DEVICE_PORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_DEVICE_TYPE_PORT, SoundDevicePort))
#define SOUND_DEVICE_PORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_DEVICE_TYPE_PORT, SoundDevicePortClass))
#define SOUND_DEVICE_IS_PORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_DEVICE_TYPE_PORT))
#define SOUND_DEVICE_IS_PORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_DEVICE_TYPE_PORT))
#define SOUND_DEVICE_PORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_DEVICE_TYPE_PORT, SoundDevicePortClass))

typedef struct _SoundDevicePort SoundDevicePort;
typedef struct _SoundDevicePortClass SoundDevicePortClass;
typedef struct _SoundDevicePortPrivate SoundDevicePortPrivate;

#define SOUND_TYPE_INDICATOR (sound_indicator_get_type ())
#define SOUND_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_TYPE_INDICATOR, SoundIndicator))
#define SOUND_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_TYPE_INDICATOR, SoundIndicatorClass))
#define SOUND_IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_TYPE_INDICATOR))
#define SOUND_IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_TYPE_INDICATOR))
#define SOUND_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_TYPE_INDICATOR, SoundIndicatorClass))

typedef struct _SoundIndicator SoundIndicator;
typedef struct _SoundIndicatorClass SoundIndicatorClass;
typedef struct _SoundIndicatorPrivate SoundIndicatorPrivate;

#define TYPE_DISPLAY_WIDGET (display_widget_get_type ())
#define DISPLAY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISPLAY_WIDGET, DisplayWidget))
#define DISPLAY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISPLAY_WIDGET, DisplayWidgetClass))
#define IS_DISPLAY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISPLAY_WIDGET))
#define IS_DISPLAY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISPLAY_WIDGET))
#define DISPLAY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISPLAY_WIDGET, DisplayWidgetClass))

typedef struct _DisplayWidget DisplayWidget;
typedef struct _DisplayWidgetClass DisplayWidgetClass;
typedef struct _DisplayWidgetPrivate DisplayWidgetPrivate;

#define SOUND_WIDGETS_TYPE_SCALE (sound_widgets_scale_get_type ())
#define SOUND_WIDGETS_SCALE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_WIDGETS_TYPE_SCALE, SoundWidgetsScale))
#define SOUND_WIDGETS_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_WIDGETS_TYPE_SCALE, SoundWidgetsScaleClass))
#define SOUND_WIDGETS_IS_SCALE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_WIDGETS_TYPE_SCALE))
#define SOUND_WIDGETS_IS_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_WIDGETS_TYPE_SCALE))
#define SOUND_WIDGETS_SCALE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_WIDGETS_TYPE_SCALE, SoundWidgetsScaleClass))

typedef struct _SoundWidgetsScale SoundWidgetsScale;
typedef struct _SoundWidgetsScaleClass SoundWidgetsScaleClass;
typedef struct _SoundWidgetsScalePrivate SoundWidgetsScalePrivate;

#define SOUND_WIDGETS_TYPE_PLAYER_ROW (sound_widgets_player_row_get_type ())
#define SOUND_WIDGETS_PLAYER_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRow))
#define SOUND_WIDGETS_PLAYER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRowClass))
#define SOUND_WIDGETS_IS_PLAYER_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_WIDGETS_TYPE_PLAYER_ROW))
#define SOUND_WIDGETS_IS_PLAYER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_WIDGETS_TYPE_PLAYER_ROW))
#define SOUND_WIDGETS_PLAYER_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_WIDGETS_TYPE_PLAYER_ROW, SoundWidgetsPlayerRowClass))

typedef struct _SoundWidgetsPlayerRow SoundWidgetsPlayerRow;
typedef struct _SoundWidgetsPlayerRowClass SoundWidgetsPlayerRowClass;
typedef struct _SoundWidgetsPlayerRowPrivate SoundWidgetsPlayerRowPrivate;

#define SOUND_SERVICES_TYPE_MPRIS_CLIENT (sound_services_mpris_client_get_type ())
#define SOUND_SERVICES_MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_MPRIS_CLIENT, SoundServicesMprisClient))
#define SOUND_SERVICES_MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_SERVICES_TYPE_MPRIS_CLIENT, SoundServicesMprisClientClass))
#define SOUND_SERVICES_IS_MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_MPRIS_CLIENT))
#define SOUND_SERVICES_IS_MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_SERVICES_TYPE_MPRIS_CLIENT))
#define SOUND_SERVICES_MPRIS_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_SERVICES_TYPE_MPRIS_CLIENT, SoundServicesMprisClientClass))

typedef struct _SoundServicesMprisClient SoundServicesMprisClient;
typedef struct _SoundServicesMprisClientClass SoundServicesMprisClientClass;

#define SOUND_SERVICES_TYPE_MEDIA_PLAYER (sound_services_media_player_get_type ())
#define SOUND_SERVICES_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_MEDIA_PLAYER, SoundServicesMediaPlayer))
#define SOUND_SERVICES_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_MEDIA_PLAYER))
#define SOUND_SERVICES_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_MEDIA_PLAYER, SoundServicesMediaPlayerIface))

typedef struct _SoundServicesMediaPlayer SoundServicesMediaPlayer;
typedef struct _SoundServicesMediaPlayerIface SoundServicesMediaPlayerIface;

#define SOUND_SERVICES_TYPE_MEDIA_PLAYER_PROXY (sound_services_media_player_proxy_get_type ())

#define SOUND_WIDGETS_TYPE_PLAYER_LIST (sound_widgets_player_list_get_type ())
#define SOUND_WIDGETS_PLAYER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_WIDGETS_TYPE_PLAYER_LIST, SoundWidgetsPlayerList))
#define SOUND_WIDGETS_PLAYER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_WIDGETS_TYPE_PLAYER_LIST, SoundWidgetsPlayerListClass))
#define SOUND_WIDGETS_IS_PLAYER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_WIDGETS_TYPE_PLAYER_LIST))
#define SOUND_WIDGETS_IS_PLAYER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_WIDGETS_TYPE_PLAYER_LIST))
#define SOUND_WIDGETS_PLAYER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_WIDGETS_TYPE_PLAYER_LIST, SoundWidgetsPlayerListClass))

typedef struct _SoundWidgetsPlayerList SoundWidgetsPlayerList;
typedef struct _SoundWidgetsPlayerListClass SoundWidgetsPlayerListClass;
typedef struct _SoundWidgetsPlayerListPrivate SoundWidgetsPlayerListPrivate;

#define SOUND_SERVICES_TYPE_OBJECT_MANAGER (sound_services_object_manager_get_type ())
#define SOUND_SERVICES_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_OBJECT_MANAGER, SoundServicesObjectManager))
#define SOUND_SERVICES_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_SERVICES_TYPE_OBJECT_MANAGER, SoundServicesObjectManagerClass))
#define SOUND_SERVICES_IS_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_OBJECT_MANAGER))
#define SOUND_SERVICES_IS_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_SERVICES_TYPE_OBJECT_MANAGER))
#define SOUND_SERVICES_OBJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_SERVICES_TYPE_OBJECT_MANAGER, SoundServicesObjectManagerClass))

typedef struct _SoundServicesObjectManager SoundServicesObjectManager;
typedef struct _SoundServicesObjectManagerClass SoundServicesObjectManagerClass;

#define SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET (sound_widgets_device_manager_widget_get_type ())
#define SOUND_WIDGETS_DEVICE_MANAGER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidget))
#define SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidgetClass))
#define SOUND_WIDGETS_IS_DEVICE_MANAGER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET))
#define SOUND_WIDGETS_IS_DEVICE_MANAGER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET))
#define SOUND_WIDGETS_DEVICE_MANAGER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_WIDGETS_TYPE_DEVICE_MANAGER_WIDGET, SoundWidgetsDeviceManagerWidgetClass))

typedef struct _SoundWidgetsDeviceManagerWidget SoundWidgetsDeviceManagerWidget;
typedef struct _SoundWidgetsDeviceManagerWidgetClass SoundWidgetsDeviceManagerWidgetClass;
typedef struct _SoundWidgetsDeviceManagerWidgetPrivate SoundWidgetsDeviceManagerWidgetPrivate;

#define SOUND_WIDGETS_TYPE_DEVICE_ITEM (sound_widgets_device_item_get_type ())
#define SOUND_WIDGETS_DEVICE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_WIDGETS_TYPE_DEVICE_ITEM, SoundWidgetsDeviceItem))
#define SOUND_WIDGETS_DEVICE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_WIDGETS_TYPE_DEVICE_ITEM, SoundWidgetsDeviceItemClass))
#define SOUND_WIDGETS_IS_DEVICE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_WIDGETS_TYPE_DEVICE_ITEM))
#define SOUND_WIDGETS_IS_DEVICE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_WIDGETS_TYPE_DEVICE_ITEM))
#define SOUND_WIDGETS_DEVICE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_WIDGETS_TYPE_DEVICE_ITEM, SoundWidgetsDeviceItemClass))

typedef struct _SoundWidgetsDeviceItem SoundWidgetsDeviceItem;
typedef struct _SoundWidgetsDeviceItemClass SoundWidgetsDeviceItemClass;
typedef struct _SoundWidgetsDeviceItemPrivate SoundWidgetsDeviceItemPrivate;

#define SOUND_TYPE_PULSE_AUDIO_MANAGER (sound_pulse_audio_manager_get_type ())
#define SOUND_PULSE_AUDIO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManager))
#define SOUND_PULSE_AUDIO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManagerClass))
#define SOUND_IS_PULSE_AUDIO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_TYPE_PULSE_AUDIO_MANAGER))
#define SOUND_IS_PULSE_AUDIO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_TYPE_PULSE_AUDIO_MANAGER))
#define SOUND_PULSE_AUDIO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_TYPE_PULSE_AUDIO_MANAGER, SoundPulseAudioManagerClass))

typedef struct _SoundPulseAudioManager SoundPulseAudioManager;
typedef struct _SoundPulseAudioManagerClass SoundPulseAudioManagerClass;
typedef struct _SoundPulseAudioManagerPrivate SoundPulseAudioManagerPrivate;
typedef struct _SoundServicesMprisClientPrivate SoundServicesMprisClientPrivate;

#define SOUND_SERVICES_TYPE_PLAYER_IFACE (sound_services_player_iface_get_type ())
#define SOUND_SERVICES_PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_PLAYER_IFACE, SoundServicesPlayerIface))
#define SOUND_SERVICES_IS_PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_PLAYER_IFACE))
#define SOUND_SERVICES_PLAYER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_PLAYER_IFACE, SoundServicesPlayerIfaceIface))

typedef struct _SoundServicesPlayerIface SoundServicesPlayerIface;
typedef struct _SoundServicesPlayerIfaceIface SoundServicesPlayerIfaceIface;

#define SOUND_SERVICES_TYPE_MPRIS_IFACE (sound_services_mpris_iface_get_type ())
#define SOUND_SERVICES_MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_MPRIS_IFACE, SoundServicesMprisIface))
#define SOUND_SERVICES_IS_MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_MPRIS_IFACE))
#define SOUND_SERVICES_MPRIS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_MPRIS_IFACE, SoundServicesMprisIfaceIface))

typedef struct _SoundServicesMprisIface SoundServicesMprisIface;
typedef struct _SoundServicesMprisIfaceIface SoundServicesMprisIfaceIface;

#define SOUND_SERVICES_TYPE_MPRIS_IFACE_PROXY (sound_services_mpris_iface_proxy_get_type ())

#define SOUND_SERVICES_TYPE_PLAYER_IFACE_PROXY (sound_services_player_iface_proxy_get_type ())

#define SOUND_SERVICES_TYPE_DBUS_PROP_IFACE (sound_services_dbus_prop_iface_get_type ())
#define SOUND_SERVICES_DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_DBUS_PROP_IFACE, SoundServicesDbusPropIface))
#define SOUND_SERVICES_IS_DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_DBUS_PROP_IFACE))
#define SOUND_SERVICES_DBUS_PROP_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_DBUS_PROP_IFACE, SoundServicesDbusPropIfaceIface))

typedef struct _SoundServicesDbusPropIface SoundServicesDbusPropIface;
typedef struct _SoundServicesDbusPropIfaceIface SoundServicesDbusPropIfaceIface;

#define SOUND_SERVICES_TYPE_DBUS_PROP_IFACE_PROXY (sound_services_dbus_prop_iface_proxy_get_type ())

#define SOUND_SERVICES_TYPE_DBUS_IMPL (sound_services_dbus_impl_get_type ())
#define SOUND_SERVICES_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_DBUS_IMPL, SoundServicesDBusImpl))
#define SOUND_SERVICES_IS_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_DBUS_IMPL))
#define SOUND_SERVICES_DBUS_IMPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_DBUS_IMPL, SoundServicesDBusImplIface))

typedef struct _SoundServicesDBusImpl SoundServicesDBusImpl;
typedef struct _SoundServicesDBusImplIface SoundServicesDBusImplIface;

#define SOUND_SERVICES_TYPE_DBUS_IMPL_PROXY (sound_services_dbus_impl_proxy_get_type ())

#define SOUND_SERVICES_TYPE_VOLUME_CONTROL (sound_services_volume_control_get_type ())
#define SOUND_SERVICES_VOLUME_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL, SoundServicesVolumeControl))
#define SOUND_SERVICES_VOLUME_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_SERVICES_TYPE_VOLUME_CONTROL, SoundServicesVolumeControlClass))
#define SOUND_SERVICES_IS_VOLUME_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL))
#define SOUND_SERVICES_IS_VOLUME_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_SERVICES_TYPE_VOLUME_CONTROL))
#define SOUND_SERVICES_VOLUME_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL, SoundServicesVolumeControlClass))

typedef struct _SoundServicesVolumeControl SoundServicesVolumeControl;
typedef struct _SoundServicesVolumeControlClass SoundServicesVolumeControlClass;
typedef struct _SoundServicesVolumeControlPrivate SoundServicesVolumeControlPrivate;

#define SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME (sound_services_volume_control_volume_get_type ())
#define SOUND_SERVICES_VOLUME_CONTROL_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME, SoundServicesVolumeControlVolume))
#define SOUND_SERVICES_VOLUME_CONTROL_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME, SoundServicesVolumeControlVolumeClass))
#define SOUND_SERVICES_VOLUME_CONTROL_IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME))
#define SOUND_SERVICES_VOLUME_CONTROL_IS_VOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME))
#define SOUND_SERVICES_VOLUME_CONTROL_VOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME, SoundServicesVolumeControlVolumeClass))

typedef struct _SoundServicesVolumeControlVolume SoundServicesVolumeControlVolume;
typedef struct _SoundServicesVolumeControlVolumeClass SoundServicesVolumeControlVolumeClass;
typedef enum  {
	SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_PULSE_CHANGE,
	SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_ACCOUNTS_SERVICE_SET,
	SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_DEVICE_OUTPUT_CHANGE,
	SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_USER_KEYPRESS,
	SOUND_SERVICES_VOLUME_CONTROL_VOLUME_REASONS_VOLUME_STREAM_CHANGE
} SoundServicesVolumeControlVolumeReasons;

#define SOUND_SERVICES_VOLUME_CONTROL_TYPE_VOLUME_REASONS (sound_services_volume_control_volume_reasons_get_type ())
typedef struct _SoundServicesVolumeControlVolumePrivate SoundServicesVolumeControlVolumePrivate;

#define SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE (sound_services_volume_control_pulse_get_type ())
#define SOUND_SERVICES_VOLUME_CONTROL_PULSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE, SoundServicesVolumeControlPulse))
#define SOUND_SERVICES_VOLUME_CONTROL_PULSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE, SoundServicesVolumeControlPulseClass))
#define SOUND_SERVICES_IS_VOLUME_CONTROL_PULSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE))
#define SOUND_SERVICES_IS_VOLUME_CONTROL_PULSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE))
#define SOUND_SERVICES_VOLUME_CONTROL_PULSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUND_SERVICES_TYPE_VOLUME_CONTROL_PULSE, SoundServicesVolumeControlPulseClass))

typedef struct _SoundServicesVolumeControlPulse SoundServicesVolumeControlPulse;
typedef struct _SoundServicesVolumeControlPulseClass SoundServicesVolumeControlPulseClass;
typedef struct _SoundServicesVolumeControlPulsePrivate SoundServicesVolumeControlPulsePrivate;
typedef struct _SoundServicesObjectManagerPrivate SoundServicesObjectManagerPrivate;

#define SOUND_SERVICES_TYPE_DEVICE (sound_services_device_get_type ())
#define SOUND_SERVICES_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUND_SERVICES_TYPE_DEVICE, SoundServicesDevice))
#define SOUND_SERVICES_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUND_SERVICES_TYPE_DEVICE))
#define SOUND_SERVICES_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUND_SERVICES_TYPE_DEVICE, SoundServicesDeviceIface))

typedef struct _SoundServicesDevice SoundServicesDevice;
typedef struct _SoundServicesDeviceIface SoundServicesDeviceIface;

#define SOUND_SERVICES_TYPE_DEVICE_PROXY (sound_services_device_proxy_get_type ())
typedef enum  {
	ACTION_MODE_NONE = 0,
	ACTION_MODE_NORMAL = 1 << 0,
	ACTION_MODE_OVERVIEW = 1 << 1,
	ACTION_MODE_LOCK_SCREEN = 1 << 2,
	ACTION_MODE_UNLOCK_SCREEN = 1 << 3,
	ACTION_MODE_LOGIN_SCREEN = 1 << 4,
	ACTION_MODE_SYSTEM_MODAL = 1 << 5,
	ACTION_MODE_LOOKING_GLASS = 1 << 6,
	ACTION_MODE_POPUP = 1 << 7
} ActionMode;

#define TYPE_ACTION_MODE (action_mode_get_type ())
typedef enum  {
	META_KEY_BINDING_FLAGS_NONE = 0,
	META_KEY_BINDING_FLAGS_PER_WINDOW = 1 << 0,
	META_KEY_BINDING_FLAGS_BUILTIN = 1 << 1,
	META_KEY_BINDING_FLAGS_IS_REVERSED = 1 << 2,
	META_KEY_BINDING_FLAGS_NON_MASKABLE = 1 << 3,
	META_KEY_BINDING_FLAGS_IGNORE_AUTOREPEAT = 1 << 4
} MetaKeyBindingFlags;

#define META_TYPE_KEY_BINDING_FLAGS (meta_key_binding_flags_get_type ())

#define TYPE_ACCELERATOR (accelerator_get_type ())
typedef struct _Accelerator Accelerator;

#define TYPE_SHELL_KEY_GRABBER (shell_key_grabber_get_type ())
#define SHELL_KEY_GRABBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHELL_KEY_GRABBER, ShellKeyGrabber))
#define IS_SHELL_KEY_GRABBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHELL_KEY_GRABBER))
#define SHELL_KEY_GRABBER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SHELL_KEY_GRABBER, ShellKeyGrabberIface))

typedef struct _ShellKeyGrabber ShellKeyGrabber;
typedef struct _ShellKeyGrabberIface ShellKeyGrabberIface;

#define TYPE_SHELL_KEY_GRABBER_PROXY (shell_key_grabber_proxy_get_type ())

struct _SoundDevice {
	GObject parent_instance;
	SoundDevicePrivate * priv;
};

struct _SoundDeviceClass {
	GObjectClass parent_class;
};

struct _SoundDevicePort {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SoundDevicePortPrivate * priv;
	gchar* name;
	gchar* description;
	guint32 priority;
};

struct _SoundDevicePortClass {
	GTypeClass parent_class;
	void (*finalize) (SoundDevicePort *self);
};

struct _SoundIndicator {
	WingpanelIndicator parent_instance;
	SoundIndicatorPrivate * priv;
};

struct _SoundIndicatorClass {
	WingpanelIndicatorClass parent_class;
};

struct _DisplayWidget {
	GtkBox parent_instance;
	DisplayWidgetPrivate * priv;
};

struct _DisplayWidgetClass {
	GtkBoxClass parent_class;
};

struct _SoundWidgetsScale {
	GtkEventBox parent_instance;
	SoundWidgetsScalePrivate * priv;
};

struct _SoundWidgetsScaleClass {
	GtkEventBoxClass parent_class;
};

struct _SoundWidgetsPlayerRow {
	GtkBox parent_instance;
	SoundWidgetsPlayerRowPrivate * priv;
	gchar* mpris_name;
};

struct _SoundWidgetsPlayerRowClass {
	GtkBoxClass parent_class;
};

struct _SoundServicesMediaPlayerIface {
	GTypeInterface parent_iface;
	void (*play) (SoundServicesMediaPlayer* self, GError** error);
	void (*pause) (SoundServicesMediaPlayer* self, GError** error);
	void (*stop) (SoundServicesMediaPlayer* self, GError** error);
	void (*next) (SoundServicesMediaPlayer* self, GError** error);
	void (*previous) (SoundServicesMediaPlayer* self, GError** error);
	void (*fast_forward) (SoundServicesMediaPlayer* self, GError** error);
	void (*rewind) (SoundServicesMediaPlayer* self, GError** error);
	gchar* (*get_name) (SoundServicesMediaPlayer* self);
	gchar* (*get_mediaplayer_type) (SoundServicesMediaPlayer* self);
	gchar* (*get_subtype) (SoundServicesMediaPlayer* self);
	guint (*get_position) (SoundServicesMediaPlayer* self);
	gchar* (*get_status) (SoundServicesMediaPlayer* self);
	gchar* (*get_equalizer) (SoundServicesMediaPlayer* self);
	void (*set_equalizer) (SoundServicesMediaPlayer* self, const gchar* value);
	gchar* (*get_repeat) (SoundServicesMediaPlayer* self);
	void (*set_repeat) (SoundServicesMediaPlayer* self, const gchar* value);
	gchar* (*get_shuffle) (SoundServicesMediaPlayer* self);
	void (*set_shuffle) (SoundServicesMediaPlayer* self, const gchar* value);
	gchar* (*get_scan) (SoundServicesMediaPlayer* self);
	void (*set_scan) (SoundServicesMediaPlayer* self, const gchar* value);
	GHashTable* (*get_track) (SoundServicesMediaPlayer* self);
	char* (*get_device) (SoundServicesMediaPlayer* self);
	gboolean (*get_browsable) (SoundServicesMediaPlayer* self);
	gboolean (*get_searchable) (SoundServicesMediaPlayer* self);
	char* (*get_playlist) (SoundServicesMediaPlayer* self);
};

struct _SoundWidgetsPlayerList {
	GtkBox parent_instance;
	SoundWidgetsPlayerListPrivate * priv;
	SoundServicesObjectManager* object_manager;
};

struct _SoundWidgetsPlayerListClass {
	GtkBoxClass parent_class;
};

struct _SoundWidgetsDeviceManagerWidget {
	GtkBox parent_instance;
	SoundWidgetsDeviceManagerWidgetPrivate * priv;
	gboolean is_input_manager;
};

struct _SoundWidgetsDeviceManagerWidgetClass {
	GtkBoxClass parent_class;
};

struct _SoundWidgetsDeviceItem {
	GtkListBoxRow parent_instance;
	SoundWidgetsDeviceItemPrivate * priv;
};

struct _SoundWidgetsDeviceItemClass {
	GtkListBoxRowClass parent_class;
};

struct _SoundPulseAudioManager {
	GObject parent_instance;
	SoundPulseAudioManagerPrivate * priv;
};

struct _SoundPulseAudioManagerClass {
	GObjectClass parent_class;
};

struct _SoundServicesMprisClient {
	GObject parent_instance;
	SoundServicesMprisClientPrivate * priv;
};

struct _SoundServicesMprisClientClass {
	GObjectClass parent_class;
};

struct _SoundServicesMprisIfaceIface {
	GTypeInterface parent_iface;
	void (*raise) (SoundServicesMprisIface* self, GError** error);
	gboolean (*get_can_raise) (SoundServicesMprisIface* self);
	gchar* (*get_desktop_entry) (SoundServicesMprisIface* self);
};

struct _SoundServicesPlayerIfaceIface {
	GTypeInterface parent_iface;
	void (*next) (SoundServicesPlayerIface* self, GError** error);
	void (*previous) (SoundServicesPlayerIface* self, GError** error);
	void (*pause) (SoundServicesPlayerIface* self, GError** error);
	void (*play_pause) (SoundServicesPlayerIface* self, GError** error);
	void (*stop) (SoundServicesPlayerIface* self, GError** error);
	void (*play) (SoundServicesPlayerIface* self, GError** error);
	gchar* (*get_playback_status) (SoundServicesPlayerIface* self);
	GHashTable* (*get_metadata) (SoundServicesPlayerIface* self);
	gboolean (*get_can_go_next) (SoundServicesPlayerIface* self);
	gboolean (*get_can_go_previous) (SoundServicesPlayerIface* self);
	gboolean (*get_can_play) (SoundServicesPlayerIface* self);
	gboolean (*get_can_pause) (SoundServicesPlayerIface* self);
};

struct _SoundServicesDbusPropIfaceIface {
	GTypeInterface parent_iface;
};

struct _SoundServicesDBusImplIface {
	GTypeInterface parent_iface;
	gchar** (*list_names) (SoundServicesDBusImpl* self, gint* result_length1, GError** error);
};

struct _SoundServicesVolumeControl {
	GObject parent_instance;
	SoundServicesVolumeControlPrivate * priv;
};

struct _SoundServicesVolumeControlClass {
	GObjectClass parent_class;
	void (*set_mute) (SoundServicesVolumeControl* self, gboolean mute);
	const gchar* (*get_stream) (SoundServicesVolumeControl* self);
	gboolean (*get_ready) (SoundServicesVolumeControl* self);
	void (*set_ready) (SoundServicesVolumeControl* self, gboolean value);
	gboolean (*get_active_mic) (SoundServicesVolumeControl* self);
	void (*set_active_mic) (SoundServicesVolumeControl* self, gboolean value);
	gboolean (*get_high_volume) (SoundServicesVolumeControl* self);
	gboolean (*get_mute) (SoundServicesVolumeControl* self);
	gboolean (*get_mic_mute) (SoundServicesVolumeControl* self);
	gboolean (*get_is_playing) (SoundServicesVolumeControl* self);
	gboolean (*get_is_listening) (SoundServicesVolumeControl* self);
	SoundServicesVolumeControlVolume* (*get_volume) (SoundServicesVolumeControl* self);
	void (*set_volume) (SoundServicesVolumeControl* self, SoundServicesVolumeControlVolume* value);
	gdouble (*get_mic_volume) (SoundServicesVolumeControl* self);
	void (*set_mic_volume) (SoundServicesVolumeControl* self, gdouble value);
};

struct _SoundServicesVolumeControlVolume {
	GObject parent_instance;
	SoundServicesVolumeControlVolumePrivate * priv;
	gdouble volume;
	SoundServicesVolumeControlVolumeReasons reason;
};

struct _SoundServicesVolumeControlVolumeClass {
	GObjectClass parent_class;
};

struct _SoundServicesVolumeControlPulse {
	SoundServicesVolumeControl parent_instance;
	SoundServicesVolumeControlPulsePrivate * priv;
};

struct _SoundServicesVolumeControlPulseClass {
	SoundServicesVolumeControlClass parent_class;
};

struct _SoundServicesObjectManager {
	GObject parent_instance;
	SoundServicesObjectManagerPrivate * priv;
};

struct _SoundServicesObjectManagerClass {
	GObjectClass parent_class;
};

struct _SoundServicesDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (SoundServicesDevice* self, GError** error);
	void (*connect) (SoundServicesDevice* self, GError** error);
	void (*connect_profile) (SoundServicesDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (SoundServicesDevice* self, GError** error);
	void (*disconnect_profile) (SoundServicesDevice* self, const gchar* UUID, GError** error);
	void (*pair) (SoundServicesDevice* self, GError** error);
	gchar** (*get_UUIDs) (SoundServicesDevice* self, gint* result_length1);
	gboolean (*get_blocked) (SoundServicesDevice* self);
	void (*set_blocked) (SoundServicesDevice* self, gboolean value);
	gboolean (*get_connected) (SoundServicesDevice* self);
	gboolean (*get_legacy_pairing) (SoundServicesDevice* self);
	gboolean (*get_paired) (SoundServicesDevice* self);
	gboolean (*get_trusted) (SoundServicesDevice* self);
	void (*set_trusted) (SoundServicesDevice* self, gboolean value);
	gint16 (*get_RSSI) (SoundServicesDevice* self);
	char* (*get_adapter) (SoundServicesDevice* self);
	gchar* (*get_address) (SoundServicesDevice* self);
	gchar* (*get_alias) (SoundServicesDevice* self);
	void (*set_alias) (SoundServicesDevice* self, const gchar* value);
	gchar* (*get_icon) (SoundServicesDevice* self);
	gchar* (*get_modalias) (SoundServicesDevice* self);
	gchar* (*get_name) (SoundServicesDevice* self);
	guint16 (*get_appearance) (SoundServicesDevice* self);
	guint32 (*get_class) (SoundServicesDevice* self);
};

struct _Accelerator {
	gchar* name;
	ActionMode mode_flags;
	MetaKeyBindingFlags grab_flags;
};

struct _ShellKeyGrabberIface {
	GTypeInterface parent_iface;
	guint (*grab_accelerator) (ShellKeyGrabber* self, const gchar* accelerator, ActionMode mode_flags, MetaKeyBindingFlags grab_flags, GError** error);
	guint* (*grab_accelerators) (ShellKeyGrabber* self, Accelerator* accelerators, gint accelerators_length1, gint* result_length1, GError** error);
	gboolean (*ungrab_accelerator) (ShellKeyGrabber* self, guint action, GError** error);
	gboolean (*ungrab_accelerators) (ShellKeyGrabber* self, guint* actions, gint actions_length1, GError** error);
	void (*show_osd) (ShellKeyGrabber* self, GHashTable* parameters_dict, GError** error);
};

VALA_EXTERN GType sound_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundDevice, g_object_unref)
VALA_EXTERN SoundDevice* sound_device_new (const gchar* id,
                               guint32 card_index,
                               const gchar* port_name);
VALA_EXTERN SoundDevice* sound_device_construct (GType object_type,
                                     const gchar* id,
                                     guint32 card_index,
                                     const gchar* port_name);
VALA_EXTERN gchar* sound_device_get_matching_profile (SoundDevice* self,
                                          SoundDevice* other_device);
VALA_EXTERN gboolean sound_device_get_input (SoundDevice* self);
VALA_EXTERN void sound_device_set_input (SoundDevice* self,
                             gboolean value);
VALA_EXTERN const gchar* sound_device_get_id (SoundDevice* self);
VALA_EXTERN guint32 sound_device_get_card_index (SoundDevice* self);
VALA_EXTERN const gchar* sound_device_get_port_name (SoundDevice* self);
VALA_EXTERN const gchar* sound_device_get_display_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_display_name (SoundDevice* self,
                                    const gchar* value);
VALA_EXTERN const gchar* sound_device_get_form_factor (SoundDevice* self);
VALA_EXTERN void sound_device_set_form_factor (SoundDevice* self,
                                   const gchar* value);
VALA_EXTERN const gchar* sound_device_get_icon_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_icon_name (SoundDevice* self,
                                 const gchar* value);
VALA_EXTERN GeeArrayList* sound_device_get_profiles (SoundDevice* self);
VALA_EXTERN void sound_device_set_profiles (SoundDevice* self,
                                GeeArrayList* value);
VALA_EXTERN const gchar* sound_device_get_card_active_profile_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_active_profile_name (SoundDevice* self,
                                                const gchar* value);
VALA_EXTERN const gchar* sound_device_get_sink_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_sink_name (SoundDevice* self,
                                 const gchar* value);
VALA_EXTERN gint sound_device_get_sink_index (SoundDevice* self);
VALA_EXTERN void sound_device_set_sink_index (SoundDevice* self,
                                  gint value);
VALA_EXTERN const gchar* sound_device_get_card_sink_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_sink_name (SoundDevice* self,
                                      const gchar* value);
VALA_EXTERN const gchar* sound_device_get_card_sink_port_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_sink_port_name (SoundDevice* self,
                                           const gchar* value);
VALA_EXTERN gint sound_device_get_card_sink_index (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_sink_index (SoundDevice* self,
                                       gint value);
VALA_EXTERN const gchar* sound_device_get_source_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_source_name (SoundDevice* self,
                                   const gchar* value);
VALA_EXTERN gint sound_device_get_source_index (SoundDevice* self);
VALA_EXTERN void sound_device_set_source_index (SoundDevice* self,
                                    gint value);
VALA_EXTERN const gchar* sound_device_get_card_source_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_source_name (SoundDevice* self,
                                        const gchar* value);
VALA_EXTERN const gchar* sound_device_get_card_source_port_name (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_source_port_name (SoundDevice* self,
                                             const gchar* value);
VALA_EXTERN gint sound_device_get_card_source_index (SoundDevice* self);
VALA_EXTERN void sound_device_set_card_source_index (SoundDevice* self,
                                         gint value);
VALA_EXTERN gboolean sound_device_get_is_default (SoundDevice* self);
VALA_EXTERN void sound_device_set_is_default (SoundDevice* self,
                                  gboolean value);
VALA_EXTERN gboolean sound_device_get_is_priority (SoundDevice* self);
VALA_EXTERN void sound_device_set_is_priority (SoundDevice* self,
                                   gboolean value);
VALA_EXTERN gpointer sound_device_port_ref (gpointer instance);
VALA_EXTERN void sound_device_port_unref (gpointer instance);
VALA_EXTERN GParamSpec* sound_device_param_spec_port (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void sound_device_value_set_port (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void sound_device_value_take_port (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer sound_device_value_get_port (const GValue* value);
VALA_EXTERN GType sound_device_port_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundDevicePort, sound_device_port_unref)
VALA_EXTERN SoundDevicePort* sound_device_port_new (void);
VALA_EXTERN SoundDevicePort* sound_device_port_construct (GType object_type);
VALA_EXTERN GType sound_indicator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundIndicator, g_object_unref)
VALA_EXTERN GSettings* sound_indicator_settings;
VALA_EXTERN SoundIndicator* sound_indicator_new (gboolean is_in_session);
VALA_EXTERN SoundIndicator* sound_indicator_construct (GType object_type,
                                           gboolean is_in_session);
VALA_EXTERN gboolean sound_indicator_get_is_in_session (SoundIndicator* self);
VALA_EXTERN gboolean sound_indicator_get_natural_scroll_touchpad (SoundIndicator* self);
VALA_EXTERN void sound_indicator_set_natural_scroll_touchpad (SoundIndicator* self,
                                                  gboolean value);
VALA_EXTERN gboolean sound_indicator_get_natural_scroll_mouse (SoundIndicator* self);
VALA_EXTERN void sound_indicator_set_natural_scroll_mouse (SoundIndicator* self,
                                               gboolean value);
VALA_EXTERN gint sound_indicator_get_volume_step (SoundIndicator* self);
VALA_EXTERN void sound_indicator_set_volume_step (SoundIndicator* self,
                                      gint value);
VALA_EXTERN WingpanelIndicator* get_indicator (GModule* module,
                                   WingpanelIndicatorManagerServerType server_type);
VALA_EXTERN GType display_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DisplayWidget, g_object_unref)
VALA_EXTERN DisplayWidget* display_widget_new (void);
VALA_EXTERN DisplayWidget* display_widget_construct (GType object_type);
VALA_EXTERN gboolean display_widget_get_show_mic (DisplayWidget* self);
VALA_EXTERN void display_widget_set_show_mic (DisplayWidget* self,
                                  gboolean value);
VALA_EXTERN gboolean display_widget_get_mic_muted (DisplayWidget* self);
VALA_EXTERN void display_widget_set_mic_muted (DisplayWidget* self,
                                   gboolean value);
VALA_EXTERN const gchar* display_widget_get_icon_name (DisplayWidget* self);
VALA_EXTERN void display_widget_set_icon_name (DisplayWidget* self,
                                   const gchar* value);
VALA_EXTERN GType sound_widgets_scale_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundWidgetsScale, g_object_unref)
VALA_EXTERN SoundWidgetsScale* sound_widgets_scale_new (const gchar* icon,
                                            gboolean active,
                                            gdouble min,
                                            gdouble max,
                                            gdouble step);
VALA_EXTERN SoundWidgetsScale* sound_widgets_scale_construct (GType object_type,
                                                  const gchar* icon,
                                                  gboolean active,
                                                  gdouble min,
                                                  gdouble max,
                                                  gdouble step);
VALA_EXTERN const gchar* sound_widgets_scale_get_icon (SoundWidgetsScale* self);
VALA_EXTERN void sound_widgets_scale_set_icon (SoundWidgetsScale* self,
                                   const gchar* value);
VALA_EXTERN gboolean sound_widgets_scale_get_active (SoundWidgetsScale* self);
VALA_EXTERN void sound_widgets_scale_set_active (SoundWidgetsScale* self,
                                     gboolean value);
VALA_EXTERN gdouble sound_widgets_scale_get_max (SoundWidgetsScale* self);
VALA_EXTERN gdouble sound_widgets_scale_get_min (SoundWidgetsScale* self);
VALA_EXTERN gdouble sound_widgets_scale_get_step (SoundWidgetsScale* self);
VALA_EXTERN GtkScale* sound_widgets_scale_get_scale_widget (SoundWidgetsScale* self);
VALA_EXTERN GtkSwitch* sound_widgets_scale_get_switch_widget (SoundWidgetsScale* self);
VALA_EXTERN GType sound_widgets_player_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundWidgetsPlayerRow, g_object_unref)
VALA_EXTERN GType sound_services_mpris_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesMprisClient, g_object_unref)
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_new (SoundServicesMprisClient* mpris_client);
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_construct (GType object_type,
                                                           SoundServicesMprisClient* mpris_client);
VALA_EXTERN GType sound_services_media_player_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_media_player_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType sound_services_media_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesMediaPlayer, g_object_unref)
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_new_bluetooth (SoundServicesMediaPlayer* media_player_client,
                                                               const gchar* name,
                                                               const gchar* icon);
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_construct_bluetooth (GType object_type,
                                                                     SoundServicesMediaPlayer* media_player_client,
                                                                     const gchar* name,
                                                                     const gchar* icon);
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_new_default (GAppInfo* info);
VALA_EXTERN SoundWidgetsPlayerRow* sound_widgets_player_row_construct_default (GType object_type,
                                                                   GAppInfo* info);
VALA_EXTERN void sound_widgets_player_row_update_from_meta (SoundWidgetsPlayerRow* self);
VALA_EXTERN void sound_widgets_player_row_update_play (SoundWidgetsPlayerRow* self,
                                           const gchar* playing,
                                           const gchar* title,
                                           const gchar* artist);
VALA_EXTERN GAppInfo* sound_widgets_player_row_get_app_info (SoundWidgetsPlayerRow* self);
VALA_EXTERN void sound_widgets_player_row_set_app_info (SoundWidgetsPlayerRow* self,
                                            GAppInfo* value);
VALA_EXTERN SoundServicesMprisClient* sound_widgets_player_row_get_client (SoundWidgetsPlayerRow* self);
VALA_EXTERN void sound_widgets_player_row_set_client (SoundWidgetsPlayerRow* self,
                                          SoundServicesMprisClient* value);
VALA_EXTERN GType sound_widgets_player_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundWidgetsPlayerList, g_object_unref)
VALA_EXTERN GType sound_services_object_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesObjectManager, g_object_unref)
VALA_EXTERN void sound_widgets_player_list_update_default_player (SoundWidgetsPlayerList* self);
VALA_EXTERN void sound_widgets_player_list_pause_all (SoundWidgetsPlayerList* self);
VALA_EXTERN void sound_widgets_player_list_setup_dbus (SoundWidgetsPlayerList* self);
VALA_EXTERN SoundServicesMprisClient* sound_widgets_player_list_new_iface (SoundWidgetsPlayerList* self,
                                                               const gchar* busname);
VALA_EXTERN SoundWidgetsPlayerList* sound_widgets_player_list_new (void);
VALA_EXTERN SoundWidgetsPlayerList* sound_widgets_player_list_construct (GType object_type);
VALA_EXTERN GType sound_widgets_device_manager_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundWidgetsDeviceManagerWidget, g_object_unref)
VALA_EXTERN SoundWidgetsDeviceManagerWidget* sound_widgets_device_manager_widget_new (void);
VALA_EXTERN SoundWidgetsDeviceManagerWidget* sound_widgets_device_manager_widget_construct (GType object_type);
VALA_EXTERN GType sound_widgets_device_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundWidgetsDeviceItem, g_object_unref)
VALA_EXTERN SoundWidgetsDeviceItem* sound_widgets_device_item_new (SoundDevice* device,
                                                       GtkListBoxRow* row);
VALA_EXTERN SoundWidgetsDeviceItem* sound_widgets_device_item_construct (GType object_type,
                                                             SoundDevice* device,
                                                             GtkListBoxRow* row);
VALA_EXTERN void sound_widgets_device_item_set_default (SoundWidgetsDeviceItem* self);
VALA_EXTERN SoundDevice* sound_widgets_device_item_get_device (SoundWidgetsDeviceItem* self);
VALA_EXTERN GtkListBoxRow* sound_widgets_device_item_get_row (SoundWidgetsDeviceItem* self);
VALA_EXTERN GType sound_pulse_audio_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundPulseAudioManager, g_object_unref)
VALA_EXTERN SoundPulseAudioManager* sound_pulse_audio_manager_get_default (void);
VALA_EXTERN void sound_pulse_audio_manager_start (SoundPulseAudioManager* self);
VALA_EXTERN void sound_pulse_audio_manager_set_default_device (SoundPulseAudioManager* self,
                                                   SoundDevice* device,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void sound_pulse_audio_manager_set_default_device_finish (SoundPulseAudioManager* self,
                                                          GAsyncResult* _res_);
VALA_EXTERN SoundDevice* sound_pulse_audio_manager_get_default_output (SoundPulseAudioManager* self);
VALA_EXTERN SoundDevice* sound_pulse_audio_manager_get_default_input (SoundPulseAudioManager* self);
VALA_EXTERN GType sound_services_mpris_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_mpris_iface_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN GType sound_services_mpris_iface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesMprisIface, g_object_unref)
VALA_EXTERN GType sound_services_player_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_player_iface_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType sound_services_player_iface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sound_services_dbus_prop_iface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesDbusPropIface, g_object_unref)
VALA_EXTERN GType sound_services_dbus_prop_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_dbus_prop_iface_register_object (void* object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error);
VALA_EXTERN SoundServicesMprisClient* sound_services_mpris_client_new (SoundServicesPlayerIface* player,
                                                           SoundServicesDbusPropIface* prop);
VALA_EXTERN SoundServicesMprisClient* sound_services_mpris_client_construct (GType object_type,
                                                                 SoundServicesPlayerIface* player,
                                                                 SoundServicesDbusPropIface* prop);
VALA_EXTERN SoundServicesPlayerIface* sound_services_mpris_client_get_player (SoundServicesMprisClient* self);
VALA_EXTERN void sound_services_mpris_client_set_player (SoundServicesMprisClient* self,
                                             SoundServicesPlayerIface* value);
VALA_EXTERN SoundServicesDbusPropIface* sound_services_mpris_client_get_prop (SoundServicesMprisClient* self);
VALA_EXTERN void sound_services_mpris_client_set_prop (SoundServicesMprisClient* self,
                                           SoundServicesDbusPropIface* value);
VALA_EXTERN GType sound_services_dbus_impl_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_dbus_impl_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GType sound_services_dbus_impl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesDBusImpl, g_object_unref)
VALA_EXTERN gchar** sound_services_dbus_impl_list_names (SoundServicesDBusImpl* self,
                                             gint* result_length1,
                                             GError** error);
VALA_EXTERN void sound_services_mpris_iface_raise (SoundServicesMprisIface* self,
                                       GError** error);
VALA_EXTERN gboolean sound_services_mpris_iface_get_can_raise (SoundServicesMprisIface* self);
VALA_EXTERN gchar* sound_services_mpris_iface_get_desktop_entry (SoundServicesMprisIface* self);
VALA_EXTERN void sound_services_player_iface_next (SoundServicesPlayerIface* self,
                                       GError** error);
VALA_EXTERN void sound_services_player_iface_previous (SoundServicesPlayerIface* self,
                                           GError** error);
VALA_EXTERN void sound_services_player_iface_pause (SoundServicesPlayerIface* self,
                                        GError** error);
VALA_EXTERN void sound_services_player_iface_play_pause (SoundServicesPlayerIface* self,
                                             GError** error);
VALA_EXTERN void sound_services_player_iface_stop (SoundServicesPlayerIface* self,
                                       GError** error);
VALA_EXTERN void sound_services_player_iface_play (SoundServicesPlayerIface* self,
                                       GError** error);
VALA_EXTERN gchar* sound_services_player_iface_get_playback_status (SoundServicesPlayerIface* self);
VALA_EXTERN GHashTable* sound_services_player_iface_get_metadata (SoundServicesPlayerIface* self);
VALA_EXTERN gboolean sound_services_player_iface_get_can_go_next (SoundServicesPlayerIface* self);
VALA_EXTERN gboolean sound_services_player_iface_get_can_go_previous (SoundServicesPlayerIface* self);
VALA_EXTERN gboolean sound_services_player_iface_get_can_play (SoundServicesPlayerIface* self);
VALA_EXTERN gboolean sound_services_player_iface_get_can_pause (SoundServicesPlayerIface* self);
VALA_EXTERN GType sound_services_volume_control_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesVolumeControl, g_object_unref)
VALA_EXTERN GType sound_services_volume_control_volume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesVolumeControlVolume, g_object_unref)
VALA_EXTERN GType sound_services_volume_control_volume_reasons_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sound_services_volume_control_set_mute (SoundServicesVolumeControl* self,
                                             gboolean mute);
VALA_EXTERN SoundServicesVolumeControl* sound_services_volume_control_construct (GType object_type);
VALA_EXTERN const gchar* sound_services_volume_control_get_stream (SoundServicesVolumeControl* self);
VALA_EXTERN gboolean sound_services_volume_control_get_ready (SoundServicesVolumeControl* self);
VALA_EXTERN void sound_services_volume_control_set_ready (SoundServicesVolumeControl* self,
                                              gboolean value);
VALA_EXTERN gboolean sound_services_volume_control_get_active_mic (SoundServicesVolumeControl* self);
VALA_EXTERN void sound_services_volume_control_set_active_mic (SoundServicesVolumeControl* self,
                                                   gboolean value);
VALA_EXTERN gboolean sound_services_volume_control_get_high_volume (SoundServicesVolumeControl* self);
VALA_EXTERN gboolean sound_services_volume_control_get_mute (SoundServicesVolumeControl* self);
VALA_EXTERN gboolean sound_services_volume_control_get_mic_mute (SoundServicesVolumeControl* self);
VALA_EXTERN gboolean sound_services_volume_control_get_is_playing (SoundServicesVolumeControl* self);
VALA_EXTERN gboolean sound_services_volume_control_get_is_listening (SoundServicesVolumeControl* self);
VALA_EXTERN SoundServicesVolumeControlVolume* sound_services_volume_control_get_volume (SoundServicesVolumeControl* self);
VALA_EXTERN void sound_services_volume_control_set_volume (SoundServicesVolumeControl* self,
                                               SoundServicesVolumeControlVolume* value);
VALA_EXTERN gdouble sound_services_volume_control_get_mic_volume (SoundServicesVolumeControl* self);
VALA_EXTERN void sound_services_volume_control_set_mic_volume (SoundServicesVolumeControl* self,
                                                   gdouble value);
VALA_EXTERN gboolean sound_services_volume_control_get_headphone_plugged (SoundServicesVolumeControl* self);
VALA_EXTERN void sound_services_volume_control_set_headphone_plugged (SoundServicesVolumeControl* self,
                                                          gboolean value);
VALA_EXTERN SoundServicesVolumeControlVolume* sound_services_volume_control_volume_new (void);
VALA_EXTERN SoundServicesVolumeControlVolume* sound_services_volume_control_volume_construct (GType object_type);
VALA_EXTERN GType sound_services_volume_control_pulse_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesVolumeControlPulse, g_object_unref)
VALA_EXTERN SoundServicesVolumeControlPulse* sound_services_volume_control_pulse_new (void);
VALA_EXTERN SoundServicesVolumeControlPulse* sound_services_volume_control_pulse_construct (GType object_type);
VALA_EXTERN void sound_services_volume_control_pulse_toggle_mute (SoundServicesVolumeControlPulse* self);
VALA_EXTERN void sound_services_volume_control_pulse_set_mic_mute (SoundServicesVolumeControlPulse* self,
                                                       gboolean m);
VALA_EXTERN void sound_services_volume_control_pulse_toggle_mic_mute (SoundServicesVolumeControlPulse* self);
VALA_EXTERN gboolean sound_services_volume_control_pulse_get_micMute (SoundServicesVolumeControlPulse* self);
VALA_EXTERN SoundServicesObjectManager* sound_services_object_manager_new (void);
VALA_EXTERN SoundServicesObjectManager* sound_services_object_manager_construct (GType object_type);
VALA_EXTERN GeeCollection* sound_services_object_manager_get_media_players (SoundServicesObjectManager* self);
VALA_EXTERN gboolean sound_services_object_manager_get_has_object (SoundServicesObjectManager* self);
VALA_EXTERN const gchar* sound_services_object_manager_get_media_player_status (SoundServicesObjectManager* self);
VALA_EXTERN const gchar* sound_services_object_manager_get_current_track_title (SoundServicesObjectManager* self);
VALA_EXTERN const gchar* sound_services_object_manager_get_current_track_artist (SoundServicesObjectManager* self);
VALA_EXTERN GType sound_services_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint sound_services_device_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType sound_services_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SoundServicesDevice, g_object_unref)
VALA_EXTERN void sound_services_device_cancel_pairing (SoundServicesDevice* self,
                                           GError** error);
VALA_EXTERN void sound_services_device_connect (SoundServicesDevice* self,
                                    GError** error);
VALA_EXTERN void sound_services_device_connect_profile (SoundServicesDevice* self,
                                            const gchar* UUID,
                                            GError** error);
VALA_EXTERN void sound_services_device_disconnect (SoundServicesDevice* self,
                                       GError** error);
VALA_EXTERN void sound_services_device_disconnect_profile (SoundServicesDevice* self,
                                               const gchar* UUID,
                                               GError** error);
VALA_EXTERN void sound_services_device_pair (SoundServicesDevice* self,
                                 GError** error);
VALA_EXTERN gchar** sound_services_device_get_UUIDs (SoundServicesDevice* self,
                                         gint* result_length1);
VALA_EXTERN gboolean sound_services_device_get_blocked (SoundServicesDevice* self);
VALA_EXTERN void sound_services_device_set_blocked (SoundServicesDevice* self,
                                        gboolean value);
VALA_EXTERN gboolean sound_services_device_get_connected (SoundServicesDevice* self);
VALA_EXTERN gboolean sound_services_device_get_legacy_pairing (SoundServicesDevice* self);
VALA_EXTERN gboolean sound_services_device_get_paired (SoundServicesDevice* self);
VALA_EXTERN gboolean sound_services_device_get_trusted (SoundServicesDevice* self);
VALA_EXTERN void sound_services_device_set_trusted (SoundServicesDevice* self,
                                        gboolean value);
VALA_EXTERN gint16 sound_services_device_get_RSSI (SoundServicesDevice* self);
VALA_EXTERN char* sound_services_device_get_adapter (SoundServicesDevice* self);
VALA_EXTERN gchar* sound_services_device_get_address (SoundServicesDevice* self);
VALA_EXTERN gchar* sound_services_device_get_alias (SoundServicesDevice* self);
VALA_EXTERN void sound_services_device_set_alias (SoundServicesDevice* self,
                                      const gchar* value);
VALA_EXTERN gchar* sound_services_device_get_icon (SoundServicesDevice* self);
VALA_EXTERN gchar* sound_services_device_get_modalias (SoundServicesDevice* self);
VALA_EXTERN gchar* sound_services_device_get_name (SoundServicesDevice* self);
VALA_EXTERN guint16 sound_services_device_get_appearance (SoundServicesDevice* self);
VALA_EXTERN guint32 sound_services_device_get_class (SoundServicesDevice* self);
VALA_EXTERN void sound_services_media_player_play (SoundServicesMediaPlayer* self,
                                       GError** error);
VALA_EXTERN void sound_services_media_player_pause (SoundServicesMediaPlayer* self,
                                        GError** error);
VALA_EXTERN void sound_services_media_player_stop (SoundServicesMediaPlayer* self,
                                       GError** error);
VALA_EXTERN void sound_services_media_player_next (SoundServicesMediaPlayer* self,
                                       GError** error);
VALA_EXTERN void sound_services_media_player_previous (SoundServicesMediaPlayer* self,
                                           GError** error);
VALA_EXTERN void sound_services_media_player_fast_forward (SoundServicesMediaPlayer* self,
                                               GError** error);
VALA_EXTERN void sound_services_media_player_rewind (SoundServicesMediaPlayer* self,
                                         GError** error);
VALA_EXTERN gchar* sound_services_media_player_get_name (SoundServicesMediaPlayer* self);
VALA_EXTERN gchar* sound_services_media_player_get_mediaplayer_type (SoundServicesMediaPlayer* self);
VALA_EXTERN gchar* sound_services_media_player_get_subtype (SoundServicesMediaPlayer* self);
VALA_EXTERN guint sound_services_media_player_get_position (SoundServicesMediaPlayer* self);
VALA_EXTERN gchar* sound_services_media_player_get_status (SoundServicesMediaPlayer* self);
VALA_EXTERN gchar* sound_services_media_player_get_equalizer (SoundServicesMediaPlayer* self);
VALA_EXTERN void sound_services_media_player_set_equalizer (SoundServicesMediaPlayer* self,
                                                const gchar* value);
VALA_EXTERN gchar* sound_services_media_player_get_repeat (SoundServicesMediaPlayer* self);
VALA_EXTERN void sound_services_media_player_set_repeat (SoundServicesMediaPlayer* self,
                                             const gchar* value);
VALA_EXTERN gchar* sound_services_media_player_get_shuffle (SoundServicesMediaPlayer* self);
VALA_EXTERN void sound_services_media_player_set_shuffle (SoundServicesMediaPlayer* self,
                                              const gchar* value);
VALA_EXTERN gchar* sound_services_media_player_get_scan (SoundServicesMediaPlayer* self);
VALA_EXTERN void sound_services_media_player_set_scan (SoundServicesMediaPlayer* self,
                                           const gchar* value);
VALA_EXTERN GHashTable* sound_services_media_player_get_track (SoundServicesMediaPlayer* self);
VALA_EXTERN char* sound_services_media_player_get_device (SoundServicesMediaPlayer* self);
VALA_EXTERN gboolean sound_services_media_player_get_browsable (SoundServicesMediaPlayer* self);
VALA_EXTERN gboolean sound_services_media_player_get_searchable (SoundServicesMediaPlayer* self);
VALA_EXTERN char* sound_services_media_player_get_playlist (SoundServicesMediaPlayer* self);
VALA_EXTERN GType action_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType meta_key_binding_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType accelerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Accelerator* accelerator_dup (const Accelerator* self);
VALA_EXTERN void accelerator_free (Accelerator* self);
VALA_EXTERN void accelerator_copy (const Accelerator* self,
                       Accelerator* dest);
VALA_EXTERN void accelerator_destroy (Accelerator* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (Accelerator, accelerator_destroy)
VALA_EXTERN GType shell_key_grabber_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint shell_key_grabber_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType shell_key_grabber_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShellKeyGrabber, g_object_unref)
VALA_EXTERN guint shell_key_grabber_grab_accelerator (ShellKeyGrabber* self,
                                          const gchar* accelerator,
                                          ActionMode mode_flags,
                                          MetaKeyBindingFlags grab_flags,
                                          GError** error);
VALA_EXTERN guint* shell_key_grabber_grab_accelerators (ShellKeyGrabber* self,
                                            Accelerator* accelerators,
                                            gint accelerators_length1,
                                            gint* result_length1,
                                            GError** error);
VALA_EXTERN gboolean shell_key_grabber_ungrab_accelerator (ShellKeyGrabber* self,
                                               guint action,
                                               GError** error);
VALA_EXTERN gboolean shell_key_grabber_ungrab_accelerators (ShellKeyGrabber* self,
                                                guint* actions,
                                                gint actions_length1,
                                                GError** error);
VALA_EXTERN void shell_key_grabber_show_osd (ShellKeyGrabber* self,
                                 GHashTable* parameters_dict,
                                 GError** error);

G_END_DECLS

#endif
