/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.Comm;
import mpi.MPIException;

public class Group
implements Allocable {
    public static final int MPI_PROC_NULL = -1;
    public static final int MPI_IDENT = 0;
    public static final int MPI_CONGRUENT = 1;
    public static final int MPI_SIMILAR = 2;
    public static final int MPI_UNEQUAL = 3;
    public static final Group WORLD = new Group();
    private long handle;

    public long getHandle() {
        return this.handle;
    }

    void setHandle(long l) {
        this.handle = l;
    }

    public Group() {
        this.init();
        AllocablePool.add(this);
    }

    private native void init();

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.MPI_Group_free();
    }

    private native void MPI_Group_free();

    public void group(Comm comm) {
        this.MPI_Comm_group(comm.getHandle(), this.getHandle());
    }

    private native void MPI_Comm_group(long var1, long var3);

    public int getSize() throws MPIException {
        return this.MPI_Group_size(this.getHandle());
    }

    public int getRank() throws MPIException {
        return this.MPI_Group_rank(this.handle);
    }

    private native int MPI_Group_size(long var1);

    private native int MPI_Group_rank(long var1);

    public int MPI_Group_translate_ranks(int[] nArray, Group group, int[] nArray2) {
        return Group.MPI_Group_translate_ranks(this.handle, nArray.length, nArray, group.getHandle(), nArray2);
    }

    public static int MPI_Group_translate_ranks(Group group, int[] nArray, Group group2, int[] nArray2) {
        return Group.MPI_Group_translate_ranks(group.getHandle(), nArray.length, nArray, group2.getHandle(), nArray2);
    }

    private static native int MPI_Group_translate_ranks(long var0, int var2, int[] var3, long var4, int[] var6);

    public int MPI_Group_compare(Group group) {
        return this.MPI_Group_compare(this.handle, group.getHandle());
    }

    private native int MPI_Group_compare(long var1, long var3);

    public int MPI_Group_union(Group group, Group group2) {
        return this.MPI_Group_union(group.getHandle(), group2.getHandle(), this.handle);
    }

    private native int MPI_Group_union(long var1, long var3, long var5);

    private native int MPI_Group_intersection(long var1, long var3, long var5);

    public int MPI_Group_intersection(Group group, Group group2) {
        return this.MPI_Group_intersection(group.getHandle(), group2.getHandle(), this.handle);
    }

    public int MPI_Group_difference(Group group, Group group2) {
        return this.MPI_Group_difference(group.getHandle(), group2.getHandle(), this.handle);
    }

    private native int MPI_Group_difference(long var1, long var3, long var5);

    public int MPI_Group_incl(Group group, int n, int[] nArray) {
        return this.MPI_Group_incl(group.getHandle(), nArray.length, nArray, this.handle);
    }

    private native int MPI_Group_incl(long var1, int var3, int[] var4, long var5);

    public int MPI_Group_excl(Group group, int n, int[] nArray) {
        return this.MPI_Group_excl(group.getHandle(), nArray.length, nArray, this.handle);
    }

    private native int MPI_Group_excl(long var1, int var3, int[] var4, long var5);

    static {
        WORLD.group(Comm.WORLD);
    }
}

