<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt"
  exclude-result-prefixes="msxsl"
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:str="http://exslt.org/strings"
  xmlns:exsl="http://exslt.org/common">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="id"/>
  <xsl:param name="displayName"/>
  <xsl:param name="description"/>
  <xsl:param name="forcePlatformTabDescription">false</xsl:param>
  <xsl:param name="globalEventAreaName"/>
  <xsl:param name="headerMode">regular</xsl:param>
  <xsl:param name="cpuDataQuery"/>
  <xsl:param name="samplePointsQuery">none</xsl:param>
  <xsl:param name="samplePointsTooltipQuery">none</xsl:param>
  <xsl:param name="samplePointsLayerName">none</xsl:param>
  <xsl:param name="cpuDataByThreadQuery">
    <xsl:value-of select="$cpuDataQuery"/>
  </xsl:param>
  <xsl:param name="cpuDataCumulativeQuery">
    <xsl:value-of select="$cpuDataQuery"/>
  </xsl:param>
  <xsl:param name="taskQuery">Task</xsl:param>
  <xsl:param name="helpKeyword"/>
  <xsl:param name="frameMode">frameSimple</xsl:param>
  <xsl:param name="contextSwitches">true</xsl:param>
  <xsl:param name="hwFeedbackClasses">true</xsl:param>
  <xsl:param name="waits">false</xsl:param>
  <xsl:param name="gpu">false</xsl:param>
  <xsl:param name="tasksAndFrames">false</xsl:param>
  <xsl:param name="platform">
    <xsl:value-of select="$tasksAndFrames='true'"/>
  </xsl:param>
  <xsl:param name="openmpAnalysis">false</xsl:param>
  <xsl:param name="visibleSeriesCount">-1</xsl:param>
  <xsl:param name="cpuOverheadAndSpinTimeQuery">none</xsl:param>
  <xsl:param name="cpuOverheadAndSpinTimeCumulativeQuery">none</xsl:param>
  <xsl:param name="sortByCPUData">false</xsl:param>
  <xsl:param name="rowByPrefix">PMU</xsl:param>
  <xsl:param name="rawEventCount">false</xsl:param>
  <xsl:param name="rawEventSampleCount">false</xsl:param>
  <xsl:param name="uncoreEvents">false</xsl:param>
  <xsl:param name="io">false</xsl:param>
  <xsl:param name="contextCounter">false</xsl:param>
  <xsl:param name="spdkio">false</xsl:param>
  <xsl:param name="dpdkio">false</xsl:param>
  <xsl:param name="pcie">false</xsl:param>
  <xsl:param name="cxl">false</xsl:param>
  <xsl:param name="gpuPCIeBandwidth">false</xsl:param>
  <xsl:param name="pcieLegacy">false</xsl:param>
  <xsl:param name="fpga">false</xsl:param>
  <xsl:param name="cat">false</xsl:param>
  <xsl:param name="cpuUsageByCS">false</xsl:param>
  <xsl:param name="threadsLifetime">true</xsl:param>
  <xsl:param name="showAcceleratorOCL">false</xsl:param>
  <xsl:param name="iptData">false</xsl:param>
  <xsl:param name="rawIptData">false</xsl:param>
  <xsl:param name="packetsColorByVM">false</xsl:param>
  <xsl:param name="showCpuPerThread">true</xsl:param>
  <xsl:param name="showIptModules">false</xsl:param>
  <xsl:param name="packetsType">true</xsl:param>
  <xsl:param name="memoryConsumption">false</xsl:param>
  <xsl:param name="showOnlyGPUThreads">false</xsl:param>
  <xsl:param name="cpuGpuInteration">false</xsl:param>
  <xsl:param name="inKernelProfiling">false</xsl:param>
  <xsl:param name="showThreadArea">true</xsl:param>
  <xsl:param name="FPGAisVPU">false</xsl:param>
  <xsl:param name="tasksOnly">false</xsl:param>
  <xsl:param name="showNPUDMA">false</xsl:param>
  <xsl:variable name="showGlobalEvents" select="$rawEventSampleCount='false' and $rawEventCount='false' and $io='false' and $memoryConsumption='false'"/>
  <xsl:variable name="showSystemBandwidth" select="$tasksAndFrames='false'"/>
  <xsl:variable name="timelineBlocksParams">
    <params
      headerMode="{$headerMode}"
      packetsType="{$packetsType}"
      packetsColorByVM="{$packetsColorByVM}"
      FPGAisVPU="{$FPGAisVPU}"
        />
  </xsl:variable>
  <xsl:variable name="timelineBlocksFileName">
    <xsl:text>config://viewpoint/include/timelineblocks.xsl?</xsl:text>
    <xsl:for-each select="exsl:node-set($timelineBlocksParams)//@*">
      <xsl:value-of select="concat(name(), '=', .)"/>
      <xsl:text>&amp;</xsl:text>
    </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="timelineblocks" select="document($timelineBlocksFileName)"/>
  <xsl:variable name="gpuCfg" select="document('config://viewpoint/include/gpu.xsl')"/>
  <xsl:template match="/">
    <xsl:if test="not(exsl:is_compare_mode())">
      <html id="{$id}">
        <xsl:call-template name="paneAttributes"/>
        <application name="timeline"/>
        <filter handleList="selection,global"/>
        <event handleList="KnobChangedEvent"/>
        <additionalParams boolean:showInDiff="false"/>
        <config>
          <xsl:call-template name="config"/>
        </config>
      </html>
    </xsl:if>
  </xsl:template>
  <xsl:template name="paneAttributes">
    <xsl:attribute name="displayName">
      <xsl:choose>
        <xsl:when test="$tasksAndFrames">%PlatformTimelineWindow</xsl:when>
        <xsl:otherwise>
          %<xsl:value-of select="$displayName"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <helpKeywordF1>
      <xsl:choose>
        <xsl:when test="$tasksAndFrames">intel.phe.configs.platform_view_f1179</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$helpKeyword"/>
        </xsl:otherwise>
      </xsl:choose>
    </helpKeywordF1>
    <description>
      <xsl:choose>
        <xsl:when test="$tasksAndFrames and ($forcePlatformTabDescription='false')">%PlatformTimelineWindowDescription</xsl:when>
        <xsl:otherwise>
          <xsl:text>%</xsl:text>
          <xsl:value-of select="$description"/>
        </xsl:otherwise>
      </xsl:choose>
    </description>
    <icon file="client.dat#zip:images.xrc" image="tab_timeline"/>
  </xsl:template>
  <xsl:template name="config">
    <xsl:variable name="isGPUComputeJoinRequired" select="$tasksAndFrames='false' or $platform='true'"/>
    <xsl:variable name="isGPUJoinRequired" select="($gpu='true') or ($platform='true')"/>
    <xsl:variable name="isTaskHierarchical" select="($isGPUJoinRequired='true') or ($tasksAndFrames='true')"/>
    <xsl:variable name="isRegionRowByJoinRequied" select="exsl:is_non_empty_table_exist('dd_region')"/>
    <xsl:variable name="isBarrierRowByJoinRequired" select="exsl:is_non_empty_table_exist('dd_barrier')"/>
    <xsl:variable name="preciseClockticsCollected" select="exsl:ctx('collectPreciseClockticks')"/>
    <ruler>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='mark']/configRulerLayers/*"/>
      <xsl:copy-of select="$timelineblocks//bag/config[@id=$frameMode]/configRulerLayers/*"/>
    </ruler>
    <xsl:variable name="pmuConditionsExtended" select="document('config://include/pmu_variables_extended.xsl')"/>
    <xsl:variable name="isExtendedIsaSupport" select="$pmuConditionsExtended//variables/isExtendedIsaSupport"/>
    <xsl:if test="$tasksOnly='false'">
      <xsl:copy-of select="$timelineblocks//bag/config[@id=$frameMode]/configAreas/*"/>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='GPUSchedulerAndQueueArea']/*"/>
      <xsl:if test="$showNPUDMA='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='NPUQueueArea']/*"/>
      </xsl:if>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineBottom/area[@id='gpu_operator_queue']"/>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineBottom/area[@id='draw_call_queue']"/>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineBottom/area[@id='gpu_computing_task_and_queue']"/>
      <area headerMode="{$headerMode}" id="metrics_by_object">
        <rowSet>
          <rowBy>
            <vectorQueryInsert>
              <xsl:text>/</xsl:text>
              <xsl:value-of select="$rowByPrefix"/>
              <xsl:text>TimelineRowBy</xsl:text>
            </vectorQueryInsert>
            <xsl:choose>
              <xsl:when test="$isGPUJoinRequired='true'">
                <sort>
                  <xsl:choose>
                    <xsl:when test="exsl:is_non_empty_table_exist('gpu_scheduler_data')">
                      <queryRef>/GPUSchedTime</queryRef>
                    </xsl:when>
                    <xsl:otherwise>
                      <queryRef>/GPUDXTime</queryRef>
                    </xsl:otherwise>
                  </xsl:choose>
                </sort>
              </xsl:when>
              <xsl:when test="$sortByCPUData='true'">
                <sort>
                  <xsl:choose>
                    <xsl:when test="$preciseClockticsCollected">
                      <queryRef>/PreciseClockticks</queryRef>
                    </xsl:when>
                    <xsl:otherwise>
                      <queryRef>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="$cpuDataQuery"/>
                      </queryRef>
                    </xsl:otherwise>
                  </xsl:choose>
                </sort>
              </xsl:when>
            </xsl:choose>
          </rowBy>
          <columnBy>
              <xsl:choose>
                <xsl:when test="$showOnlyGPUThreads='true'">
                  <queryRef>/GPUDXTime</queryRef>
                  <queryRef>/GPUSchedTime</queryRef>
                  <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
                  <queryRef>/DrawCallTime</queryRef>
                  <queryRef>/TaskTime</queryRef>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="$cpuDataQuery">
                    <queryRef>
                      <xsl:text>/</xsl:text>
                      <xsl:value-of select="$cpuDataQuery"/>
                    </queryRef>
                  </xsl:if>
                  <queryRef>/PreciseClockticks</queryRef>
                  <xsl:if test="$rowByPrefix">
                    <queryRef>
                      <xsl:text>/</xsl:text>
                      <xsl:value-of select="$rowByPrefix"/>
                      <xsl:text>UserTime</xsl:text>
                    </queryRef>
                  </xsl:if>
                  <xsl:if test="$waits='true'">
                    <queryRef>/WaitTime</queryRef>
                  </xsl:if>
                  <queryRef>/TaskTime</queryRef>
                  <queryRef>/CounterMetrics</queryRef>
                  <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
                  <queryRef>/DrawCallTime</queryRef>
                  <queryRef>/GPUDXTime</queryRef>
                  <queryRef>/GPUSchedTime</queryRef>
                  <queryRef>/RegionTime</queryRef>
                  <queryRef>/BarrierInstanceCount</queryRef>
                  <queryRef>/SchedTime</queryRef>
                  <queryRef>/ContextSwitchCount</queryRef>
                  <queryRef>/FPGAComputeTaskTime</queryRef>
                  <queryRef>/HWFeedbackClassTime</queryRef>
                </xsl:otherwise>
              </xsl:choose>
          </columnBy>
            <xsl:if test="$showOnlyGPUThreads='false'">
          <queryMode>allRows</queryMode>
            </xsl:if>
          <xsl:if test="$threadsLifetime='true'">
            <layer>
              <drawBy>
                <queryRef>/ThreadLifeTime</queryRef>
              </drawBy>
            </layer>
          </xsl:if>
          <xsl:if test="$waits='true'">
            <layer type="RowInterval" visibleOnLevels="Thread">
              <drawBy>
                <queryRef>/Waits</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/WaitSyncObj</queryRef>
                <queryRef>/WaitSourceFile</queryRef>
                <queryRef>/WaitSourceLine</queryRef>
                <queryRef>/WaitSignalSourceFile</queryRef>
                <queryRef>/WaitSignalSourceLine</queryRef>
              </tooltipBy>
              <diveBy>
                <queryRef>/WaitCS</queryRef>
              </diveBy>
            </layer>
          </xsl:if>
          <xsl:if test="$contextSwitches='true'">
            <layer type="RowInterval" visibleOnLevels="Thread" boolean:showColoringAsLegendItems="true">
              <drawBy>
                <queryRef>/ContextSwitches</queryRef>
              </drawBy>
              <xsl:if test="not(exsl:ctx('hideContextSwitchesType',0))">
                <colorBy>
                  <queryRef>/ContextSwitchReason</queryRef>
                </colorBy>
              </xsl:if>
              <tooltipBy>
                <queryRef>/ContextSwitchCpu</queryRef>
                <xsl:if test="not(exsl:ctx('hideContextSwitchesType',0))">
                  <queryRef>/ContextSwitchReason</queryRef>
                </xsl:if>
                <queryRef>/ContextSwitchSourceFile</queryRef>
                <queryRef>/ContextSwitchSourceLine</queryRef>
              </tooltipBy>
              <diveBy>
                <queryRef>/ContextSwitchCS</queryRef>
              </diveBy>
            </layer>
          </xsl:if>
          <xsl:if test="$showIptModules='true'">
            <layer type="RowInterval" boolean:explicitShowText="true" boolean:showText="true" boolean:showColoringAsLegendItems="true">
              <drawBy>
                <queryRef>/IptModuleTask</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/IPTModuleModule</queryRef>
                <queryRef>/IptModuleTaskFunction</queryRef>
                <queryRef>/IPTModuleSourceFileAndLine</queryRef>
              </tooltipBy>
              <colorBy>
                <queryRef>/IPTModuleModule</queryRef>
              </colorBy>
            </layer>
            <layer type="EventMarker" boolean:visible="true">
              <drawBy>
                <queryRef>/TIPSample</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/IPTTIPModule</queryRef>
                <queryRef>/IPTTIPFunctionFull</queryRef>
                <queryRef>/IPTTIPSourceFileAndLine</queryRef>
              </tooltipBy>
              <colorBy>
                <queryRef>/IPTTIPFunction</queryRef>
              </colorBy>
            </layer>
          </xsl:if>
          <xsl:if test="$showCpuPerThread='true'">
            <layer>
              <xsl:attribute name="visibleSeriesCount">
                <xsl:value-of select="$visibleSeriesCount"/>
              </xsl:attribute>
              <xsl:attribute name="boolean:visible">
                <xsl:value-of select="not($preciseClockticsCollected)"/>
              </xsl:attribute>
              <xsl:if test="$cpuOverheadAndSpinTimeQuery!='none' and $isExtendedIsaSupport='false'">
                <xsl:attribute name="boolean:scaleGroupStart">true</xsl:attribute>
              </xsl:if>
              <drawBy>
                <xsl:if test="$cpuDataQuery">
                  <queryRef>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$cpuDataByThreadQuery"/>
                  </queryRef>
                </xsl:if>
              </drawBy>
            </layer>
          </xsl:if>
          <xsl:if test="$cat='true'">
            <xsl:if test="exsl:ctx('isL3CATAvailable', '')='true'">
              <layer boolean:visible="false">
                <drawBy>
                  <queryRef>/L3CATPercentageAvailability</queryRef>
                </drawBy>
              </layer>
            </xsl:if>
            <xsl:if test="exsl:ctx('isL2CATAvailable', '')='true'">
              <layer boolean:visible="false">
                <drawBy>
                  <queryRef>/L2CATPercentageAvailability</queryRef>
                </drawBy>
              </layer>
            </xsl:if>
            <xsl:if test="exsl:ctx('isL3CacheOccupancyAvailable', '')='true'">
              <layer boolean:visible="false">
                <drawBy>
                  <queryRef>/L3CacheOccupancy</queryRef>
                </drawBy>
              </layer>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$cpuOverheadAndSpinTimeQuery!='none' and $isExtendedIsaSupport='false'">
            <layer>
              <xsl:attribute name="boolean:visible">
                <xsl:value-of select="not($preciseClockticsCollected)"/>
              </xsl:attribute>
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$cpuOverheadAndSpinTimeQuery"/>
                </queryRef>
              </drawBy>
            </layer>
            <layer displayModes="rich,regular" boolean:scaleGroupEnd="true">
              <xsl:attribute name="boolean:visible">
                <xsl:value-of select="not($preciseClockticsCollected)"/>
              </xsl:attribute>
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$rowByPrefix"/>
                  <xsl:text>SpinBusyWaitOnMPISpinningTimeForTimeline</xsl:text>
                </queryRef>
              </drawBy>
            </layer>
            <layer displayModes="super_tiny">
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$rowByPrefix"/>
                  <xsl:text>UserTime</xsl:text>
                </queryRef>
              </drawBy>
            </layer>
            <layer displayModes="super_tiny" boolean:visible="false">
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$rowByPrefix"/>
                  <xsl:text>OverheadAndSpinTime</xsl:text>
                </queryRef>
              </drawBy>
            </layer>
            <layer displayModes="super_tiny">
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$rowByPrefix"/>
                  <xsl:text>SpinBusyWaitOnMPISpinningTimeForTimeline</xsl:text>
                </queryRef>
              </drawBy>
            </layer>
          </xsl:if>
          <layer>
            <xsl:attribute name="boolean:visible">
              <xsl:value-of select="$preciseClockticsCollected"/>
            </xsl:attribute>
            <drawBy>
              <queryRef>/PreciseClockticks</queryRef>
            </drawBy>
          </layer>
          <xsl:if test="$samplePointsQuery!='none'">
            <layer type="EventMarker" boolean:visible="false">
              <xsl:if test="$samplePointsLayerName!='none'">
                <xsl:attribute name="displayName">
                  <xsl:value-of select="concat('%',$samplePointsLayerName)"/>
                </xsl:attribute>
              </xsl:if>
              <drawBy>
                <queryRef>
                  <xsl:text>/</xsl:text>
                  <xsl:value-of select="$samplePointsQuery"/>
                </queryRef>
              </drawBy>
              <xsl:if test="$samplePointsTooltipQuery!='none'">
                <tooltipBy>
                  <queryRef>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$samplePointsTooltipQuery"/>
                  </queryRef>
                </tooltipBy>
              </xsl:if>
            </layer>
          </xsl:if>
          <xsl:if test="$isGPUJoinRequired='true'">
            <layer type="InstanceCountOverTime">
              <drawBy>
                <instanceCountQuery>
                  <queryInherit>/GPUUsageForGridRow</queryInherit>
                  <maxEval>exsl:ctx('logicalGPUCount', 0) + 1</maxEval>
                </instanceCountQuery>
              </drawBy>
            </layer>
          </xsl:if>
          <layer type="InstanceCountOverTime">
            <drawBy>
              <instanceCountQuery>
                <queryInherit>/GPUSchedUsageForGridRow</queryInherit>
                <maxEval>exsl:ctx('logicalGPUCount', 0) + 1</maxEval>
              </instanceCountQuery>
            </drawBy>
          </layer>
          <xsl:copy-of select="$timelineblocks//bag/config[@id='counters']/*"/>
          <layer visibleOnLevels="Thread" boolean:showText="true">
            <xsl:if test="$showAcceleratorOCL='true'">
              <xsl:attribute name="type">RowIntervalNested</xsl:attribute>
            </xsl:if>
            <drawBy>
              <queryRef>
                <xsl:choose>
                  <xsl:when test="$isTaskHierarchical='true'">
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$taskQuery"/>
                    <xsl:text>Hierarchical</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$taskQuery"/>
                  </xsl:otherwise>
                </xsl:choose>
              </queryRef>
            </drawBy>
            <tooltipBy>
              <queryRef>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="$taskQuery"/>
                <xsl:text>Type</xsl:text>
              </queryRef>
              <queryRef>/TaskMetadata</queryRef>
              <queryRef>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="$taskQuery"/>
                <xsl:text>DurationType</xsl:text>
              </queryRef>
              <queryRef>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="$taskQuery"/>
                <xsl:text>EndCallStack</xsl:text>
              </queryRef>
            </tooltipBy>
            <colorBy>
              <queryRef>/TaskType</queryRef>
            </colorBy>
            <highlightBy int:groupId="3">
              <queryRef>/TaskGroupKey</queryRef>
            </highlightBy>
          </layer>
          <layer type="EventMarker" visibleOnLevels="Thread" boolean:visible="false">
            <drawBy>
              <queryRef>/SlowTaskMarker/TaskDurationType[%SlowTask]</queryRef>
            </drawBy>
          </layer>
          <xsl:if test="$dpdkio='true'">
            <layer visibleOnLevels="Thread">
              <drawBy>
                <queryRef>/DpdkRxSpinTime</queryRef>
              </drawBy>
            </layer>
            <layer visibleOnLevels="Thread">
              <drawBy>
                <queryRef>/DpdkDequeueSpinTime</queryRef>
              </drawBy>
            </layer>
          </xsl:if>
          <xsl:if test="$contextCounter='true'">
            <xsl:if test="exsl:is_non_empty_table_exist('counter_extended_data')">
              <xsl:for-each select="str:split(exsl:group_by_list('/CounterMetadataDomain', '/CounterMetadataTimeCount', '@$$@'), '@$$@')">
                <xsl:variable name="domainName" select="."/>
                <xsl:variable name="queryDomain" select="concat('/CounterMetadataTime', str:replace(str:replace(., ' ', ''), '%', ''))"/>
                <xsl:for-each select="str:split(exsl:group_by_list('/CounterMetadataName', $queryDomain, '@$$@'), '@$$@')">
                  <layer visibleOnLevels="Thread">
                    <xsl:attribute name="displayName">
                      <xsl:value-of select="concat($domainName, ' ', .)"/>
                    </xsl:attribute>
                    <drawBy>
                      <queryRef>
                        <xsl:value-of select="concat($queryDomain, str:replace(., ' ', ''))"/>
                      </queryRef>
                    </drawBy>
                  </layer>
                </xsl:for-each>
              </xsl:for-each>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$spdkio='true'">
            <layer visibleOnLevels="Thread">
              <drawBy>
                <queryRef>/SpdkIoEffectiveTime</queryRef>
              </drawBy>
            </layer>
            <layer visibleOnLevels="Thread" boolean:allowToHideSeries="true" boolean:showColoringAsLegendItems="true">
              <drawBy>
                <queryRef>/SpdkIoOperation/SpdkIOBinValueType</queryRef>
              </drawBy>
              <colorBy>
                <queryRef>/SpdkIOBinValueType</queryRef>
              </colorBy>
            </layer>
            <layer visibleOnLevels="Thread" boolean:allowToHideSeries="true" boolean:visible="false" boolean:showColoringAsLegendItems="true">
              <drawBy>
                <queryRef>/SpdkIoOperationLatency/SpdkIOLatencyBinValueType</queryRef>
              </drawBy>
              <colorBy>
                <queryRef>/SpdkIOLatencyBinValueType</queryRef>
              </colorBy>
            </layer>
          </xsl:if>
          <layer type="Transition" boolean:visible="false" visibleOnLevels="Thread">
            <drawBy>
              <queryRef>/TaskTransition</queryRef>
            </drawBy>
          </layer>
          <xsl:if test="$waits='true'">
            <layer type="Transition" boolean:visible="false" visibleOnLevels="Thread">
              <drawBy>
                <queryRef>/Transitions</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/WaitSyncObj</queryRef>
                <queryRef>/WaitsSourceFile</queryRef>
                <queryRef>/WaitsSourceLine</queryRef>
                <queryRef>/WaitSignalSourceFile</queryRef>
                <queryRef>/WaitSignalSourceLine</queryRef>
              </tooltipBy>
              <diveBy>
                <queryRef>/WaitSignalCS</queryRef>
              </diveBy>
            </layer>
          </xsl:if>
          <xsl:if test="$isGPUComputeJoinRequired='true'">
            <xsl:choose>
              <xsl:when test="$inKernelProfiling='true'">
                <layer visibleOnLevels="GPUComputeSubmitThread">
                  <drawBy>
                    <queryRef>/GPUComputeTask</queryRef>
                  </drawBy>
                  <tooltipBy>
                    <queryRef>/GPUComputeTask</queryRef>
                    <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
                    <queryRef>/GPUComputeGlobalDim</queryRef>
                    <queryRef>/GPUComputeLocalDim</queryRef>
                    <queryRef>/GPUComputeSimdWidth</queryRef>
                  </tooltipBy>
                  <highlightBy int:groupId="2">
                    <queryRef>/GPUComputeTask</queryRef>
                  </highlightBy>
                  <hatchBy>
                    <queryRef>/GPUComputeTaskPurpose</queryRef>
                  </hatchBy>
                </layer>
                <layer visibleOnLevels="GPUDrawCallThread">
                  <drawBy>
                    <queryRef>/DrawCallName</queryRef>
                  </drawBy>
                  <tooltipBy>
                    <queryRef>/DrawCallName</queryRef>
                    <queryRef>/DrawCallPurpose</queryRef>
                  </tooltipBy>
                  <highlightBy>
                    <queryRef>/DrawCallName</queryRef>
                  </highlightBy>
                </layer>
              </xsl:when>
              <xsl:when test="$cpuGpuInteration='true'">
                <layer visibleOnLevels="GPUComputeSubmitThread">
                  <drawBy>
                    <queryRef>/GPUComputeTask</queryRef>
                  </drawBy>
                  <highlightBy int:groupId="2">
                    <queryRef>/GPUComputeTask</queryRef>
                  </highlightBy>
                  <tooltipBy>
                    <queryRef>/GPUComputeTask</queryRef>
                    <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
                    <queryRef>/GPUComputeSubmitThread</queryRef>
                    <queryRef>/GPUComputeGlobalDim</queryRef>
                    <queryRef>/GPUComputeLocalDim</queryRef>
                    <queryRef>/GPUComputeSimdWidth</queryRef>
                  </tooltipBy>
                  <hatchBy>
                    <queryRef>/GPUComputeTaskPurpose</queryRef>
                  </hatchBy>
                </layer>
                <layer visibleOnLevels="GPUDrawCallThread">
                  <drawBy>
                    <queryRef>/DrawCallName</queryRef>
                  </drawBy>
                  <tooltipBy>
                    <queryRef>/DrawCallName</queryRef>
                    <queryRef>/DrawCallPurpose</queryRef>
                  </tooltipBy>
                  <highlightBy>
                    <queryRef>/DrawCallName</queryRef>
                  </highlightBy>
                </layer>
              </xsl:when>
            </xsl:choose>
          </xsl:if>
          <xsl:if test="$showAcceleratorOCL='true'">
            <layer>
              <drawBy>
                <queryRef>/FPGAComputeTask</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/FPGAComputeTask</queryRef>
                <queryRef>/FPGAComputeTaskPurposeShortName</queryRef>
                <queryRef>/FPGAComputeGlobalDim</queryRef>
                <queryRef>/FPGAComputeLocalDim</queryRef>
                <queryRef>/FPGAComputeSimdWidth</queryRef>
              </tooltipBy>
            </layer>
          </xsl:if>
          <xsl:if test="$isRegionRowByJoinRequied='true'">
            <layer visibleOnLevels="Process" type="EventMarker">
              <drawBy>
                <queryRef>/Region</queryRef>
              </drawBy>
              <colorBy>
                <queryRef>/RegionDomain</queryRef>
              </colorBy>
              <tooltipBy>
                <queryRef>/RegionDomain</queryRef>
                <queryRef>/RegionType</queryRef>
              </tooltipBy>
            </layer>
          </xsl:if>
          <xsl:if test="$isBarrierRowByJoinRequired='true'">
            <layer visibleOnLevels="Process,BarrierProcess" type="EventMarker" boolean:visible="false">
              <drawBy>
                <queryRef>/Barrier</queryRef>
              </drawBy>
              <colorBy>
                <queryRef>/BarrierDomain</queryRef>
              </colorBy>
              <tooltipBy>
                <queryRef>/BarrierDomain</queryRef>
              </tooltipBy>
            </layer>
          </xsl:if>
          <xsl:if test ="$iptData='true'">
            <layer>
              <drawBy>
                <queryRef>/IptRegion</queryRef>
              </drawBy>
            </layer>
            <layer>
              <drawBy>
                <queryRef>/CbrFrequency</queryRef>
              </drawBy>
            </layer>
          </xsl:if>
          <xsl:if test ="$rawIptData='true'">
            <layer>
              <drawBy>
                <queryRef>/RawIptRegion</queryRef>
              </drawBy>
            </layer>
            <layer>
              <drawBy>
                <queryRef>/RawCbrFrequency</queryRef>
              </drawBy>
            </layer>
          </xsl:if>
          <xsl:if test="$hwFeedbackClasses='true'">
            <layer type="EventMarker" displayName="%HWFeedbackClass0">
              <drawBy>
                <queryRef>/HWFeedbackClass0/HWFeedbackClassName[Class_0]</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/HWFeedbackClassCPU</queryRef>
              </tooltipBy>
            </layer>
            <layer type="EventMarker" displayName="%HWFeedbackClass1">
              <drawBy>
                <queryRef>/HWFeedbackClass1/HWFeedbackClassName[Class_1]</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/HWFeedbackClassCPU</queryRef>
              </tooltipBy>
            </layer>
            <layer type="EventMarker" displayName="%HWFeedbackClass2">
              <drawBy>
                <queryRef>/HWFeedbackClass2/HWFeedbackClassName[Class_2]</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/HWFeedbackClassCPU</queryRef>
              </tooltipBy>
            </layer>
            <layer type="EventMarker" displayName="%HWFeedbackClass3">
              <drawBy>
                <queryRef>/HWFeedbackClass3/HWFeedbackClassName[Class_3]</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/HWFeedbackClassCPU</queryRef>
              </tooltipBy>
            </layer>
            <layer type="EventMarker" displayName="%HWFeedbackClassInvalid">
              <drawBy>
                <queryRef>/HWFeedbackClassInvalid/HWFeedbackClassName[Invalid]</queryRef>
              </drawBy>
              <tooltipBy>
                <queryRef>/HWFeedbackClassCPU</queryRef>
              </tooltipBy>
            </layer>
          </xsl:if>
        </rowSet>
      </area>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='ParallelFsReadWriteBytesArea']/*"/>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='ParallelFsSumSamplesCountArea']/*"/>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='VPU_BW_Metrics']/*"/>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='VPU_Freq_Metrics']/*"/>
      <xsl:if test="$cpuUsageByCS='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='cpuUsageByCSArea']/*"/>
      </xsl:if>
      <xsl:if test="$rawEventCount='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='rawEventCountArea']/*"/>
      </xsl:if>
      <xsl:if test="$rawEventSampleCount='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='rawEventSampleCountArea']/*"/>
      </xsl:if>
      <xsl:if test="$gpu!='true' or $platform='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='globalCounters']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='deviceCounters']/*"/>
      </xsl:if>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='FPGA_Device_Metrics']/*"/>
      <xsl:if test="$fpga='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='FPGA_QPI_BandwidthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='FPGA_PCIE_BandwidthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='FPGARatiosArea']/*"/>
      </xsl:if>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineCommonBasic/*"/>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineCommonBasicExt/*"/>
      <xsl:copy-of select="$gpuCfg//cpugpuInteractionTimeline/*"/>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineBWs/*"/>
      <xsl:if test="$showAcceleratorOCL='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='FPGAComputingTaskUtilizationArea']/*"/>
      </xsl:if>
      <xsl:if test="$platform='false' or $cpuGpuInteration='true'">
          <xsl:copy-of select="$gpuCfg//graphicsTimelineCommon/*"/>
          <xsl:copy-of select="$gpuCfg//graphicsTimelineOverview/*"/>
          <xsl:copy-of select="$gpuCfg//graphicsTimelineComputeBasic/*"/>
          <xsl:copy-of select="$gpuCfg//graphicsTimelineComputeExtended/*"/>
        <xsl:if test="$inKernelProfiling!='true' and $cpuGpuInteration!='true'">
          <xsl:copy-of select="$gpuCfg//graphicsTimelineBottom/*"/>
        </xsl:if>
      </xsl:if>
      <xsl:if test="$tasksAndFrames='false' or $platform='true'">
        <xsl:choose>
          <xsl:when test="exsl:is_non_empty_table_exist('dma_packet_data') or
                          exsl:is_non_empty_table_exist('gpu_scheduler_data')">
            <xsl:copy-of select="$gpuCfg//timeline/*"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="$gpuCfg//timelineNoPackets/*"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:copy-of select="$gpuCfg//gpuEnginesNoPackets/*"/>
      <xsl:copy-of select="$gpuCfg//copyEngine/*"/>
      <xsl:if test="$showGlobalEvents='true'">
        <area>
          <rowSet displayName="%{$globalEventAreaName}">
            <layer>
              <xsl:attribute name="visibleSeriesCount">
                <xsl:value-of select="$visibleSeriesCount"/>
              </xsl:attribute>
              <xsl:attribute name="boolean:visible">
                <xsl:value-of select="not($preciseClockticsCollected)"/>
              </xsl:attribute>
              <drawBy>
                <xsl:if test="$cpuDataQuery">
                  <queryRef>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$cpuDataCumulativeQuery"/>
                  </queryRef>
                </xsl:if>
              </drawBy>
            </layer>
            <xsl:if test="$cpuOverheadAndSpinTimeCumulativeQuery!='none' and $isExtendedIsaSupport='false'">
              <layer>
                <xsl:attribute name="boolean:visible">
                  <xsl:value-of select="not($preciseClockticsCollected)"/>
                </xsl:attribute>
                <drawBy>
                  <queryRef>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$cpuOverheadAndSpinTimeCumulativeQuery"/>
                  </queryRef>
                </drawBy>
              </layer>
              <layer>
                <xsl:attribute name="boolean:visible">
                  <xsl:value-of select="not($preciseClockticsCollected)"/>
                </xsl:attribute>
                <drawBy>
                  <queryRef>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="$rowByPrefix"/>
                    <xsl:text>SpinBusyWaitOnMPISpinningTimeGlobal</xsl:text>
                  </queryRef>
                </drawBy>
              </layer>
            </xsl:if>
            <layer>
              <drawBy>
                <queryRef>/CPUGPUConcurrency</queryRef>
              </drawBy>
            </layer>
            <layer>
              <xsl:attribute name="boolean:visible">
                <xsl:value-of select="$preciseClockticsCollected"/>
              </xsl:attribute>
              <drawBy>
                <queryRef>/PreciseClockticks</queryRef>
              </drawBy>
            </layer>
          </rowSet>
        </area>
      </xsl:if>
      <xsl:if test="$uncoreEvents='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='uncoreEvents']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='uncoreGpuEvents']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='uncoreGpuMediaEvents']/*"/>
      </xsl:if>
      <xsl:if test="$pcieLegacy='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='legacyPCIeBandwidthArea']/*"/>
      </xsl:if>
      <xsl:if test="$pcie='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='InboundPCIeBandwidthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='OutboundPCIeBandwidthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='LocalOrRemotePCIeP2PBandwidthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='RemotePCIeP2PBandwidthArea']/*"/>
      </xsl:if>
      <xsl:if test="$cxl='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='CxlTimeline']/*"/>
      </xsl:if>
      <xsl:if test="$gpuPCIeBandwidth='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='GPUPCIeBandwidthArea']/*"/>
      </xsl:if>
      <xsl:copy-of select="$timelineblocks//bag/config[@id='eDRAMBandwidthTimeline']/*"/>
      <xsl:choose>
        <xsl:when test="$platform='true' or $openmpAnalysis='true' or $gpu='true'">
          <xsl:copy-of select="$timelineblocks//bag/config[@id='bandwidthTimelineAreas']/*"/>
          <xsl:if test="$showAcceleratorOCL!='true'">
            <xsl:copy-of select="$timelineblocks//bag/config[@id='QPIBandwidthTimeline']/*"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test="$showSystemBandwidth='true' and $io='false'">
          <xsl:copy-of select="$timelineblocks//bag/config[@id='SystemBandwidthArea']/*"/>
        </xsl:when>
      </xsl:choose>
      <xsl:if test="$io='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='IOQueueDepthArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='PageFaultStatArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='IOOperationArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='IOBytesArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='IOThroughputArea']/*"/>
      </xsl:if>
      <xsl:if test="$contextCounter='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='contextCounterTimelineArea']/*"/>
      </xsl:if>
      <xsl:if test="$spdkio='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='spdkIoArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='spdkIoBytesArea']/*"/>
      </xsl:if>
      <xsl:if test="$io='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='CPUIoStatePercentageArea']/*"/>
      </xsl:if>
      <xsl:if test="$platform='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='cpuThrottling']/*"/>
      </xsl:if>
      <xsl:if test="$platform='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='aperfMperfFreq']/*"/>
      </xsl:if>
      <area boolean:maxLabels="false">
        <rowSet displayName="%XelinkTrafficGridHeader">
          <rowBy>
            <queryRef>/XelinkFromGPUName/XelinkFromStackDisplayName/FabricLinkName</queryRef>
            <sort>
              <queryRef>/XelinkFromGPUName</queryRef>
            </sort>
          </rowBy>
          <columnBy>
            <queryRef>/FabricBWOutgoing</queryRef>
          </columnBy>
          <layer boolean:scaleGroupStart="true">
            <drawBy>
              <queryRef>/FabricBWOutgoing</queryRef>
              <displayAttributes>
                <minimumResolutionms>0</minimumResolutionms>
                <timeScalems>1000</timeScalems>
                <timelineFormat>area</timelineFormat>
                <timelineGraphColor>117,219,203</timelineGraphColor>
              </displayAttributes>
            </drawBy>
          </layer>
          <layer>
            <drawBy>
              <queryRef>/FabricBWIncoming</queryRef>
              <displayAttributes>
                <minimumResolutionms>0</minimumResolutionms>
                <timeScalems>1000</timeScalems>
                <timelineFormat>area</timelineFormat>
                <timelinePenWidth>1</timelinePenWidth>
                <timelineGraphColor>55,101,193</timelineGraphColor>
              </displayAttributes>
            </drawBy>
          </layer>
        </rowSet>
      </area>
      <xsl:copy-of select="$gpuCfg//graphicsTimelineMedia/*"/>
      <xsl:copy-of select="$gpuCfg//gpuCoreFrequency/*"/>
      <xsl:if test="$tasksAndFrames='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='PStateArea']/*"/>
        <xsl:copy-of select="$timelineblocks//bag/config[@id='CStateArea']/*"/>
      </xsl:if>
      <xsl:if test="$memoryConsumption='true'">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='memoryConsumption']/*"/>
      </xsl:if>
      <xsl:if test="exsl:is_non_empty_table_exist('package_power_data') or exsl:is_non_empty_table_exist('dram_power_data') or exsl:is_non_empty_table_exist('discrete_graphics_power_data')">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='energyConsumption']/*"/>
      </xsl:if>
      <xsl:if test="exsl:is_non_empty_table_exist('discrete_graphics_hbm_bandwidth_data')">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='dgfxHBMBandwidth']/*"/>
      </xsl:if>
      <xsl:if test="exsl:is_non_empty_table_exist('discrete_graphics_cross_tile_hops_data')">
        <xsl:copy-of select="$timelineblocks//bag/config[@id='dgfxMDFBandwidth']/*"/>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$tasksOnly='true'">
      <area headerMode="{$headerMode}" id="metrics_by_object" boolean:expandBandsByDefault="true">
        <rowSet>
          <rowBy>
            <vectorQueryInsert>/TaskTimelineRowBy</vectorQueryInsert>
          </rowBy>
          <columnBy>
            <queryRef>/GPUComputeTaskTimeGPUName</queryRef>
            <queryRef>/TaskTime</queryRef>
          </columnBy>
          <layer visibleOnLevels="Thread,TaskDomain" boolean:showText="true" boolean:showColoringAsLegendItems="true">
            <xsl:attribute name="type">RowIntervalNested</xsl:attribute>
            <drawBy>
              <xsl:choose>
                <xsl:when test="$isTaskHierarchical='true'">
                  <queryRef>/TaskHierarchical</queryRef>
                </xsl:when>
                <xsl:otherwise>
                  <queryRef>/Task</queryRef>
                </xsl:otherwise>
              </xsl:choose>
            </drawBy>
            <tooltipBy>
              <queryRef>/TaskType</queryRef>
              <queryRef>/TaskMetadata</queryRef>
              <queryRef>/TaskDurationType</queryRef>
              <queryRef>/TaskEndCallStack</queryRef>
              <queryRef>/TaskDomain</queryRef>
            </tooltipBy>
            <colorBy>
              <queryRef>/TaskDomain</queryRef>
            </colorBy>
            <correlateBy int:groupId="4">
              <queryRef>/TaskId</queryRef>
            </correlateBy>
          </layer>
          <layer visibleOnLevels="GPUAdapterAlias,GPUTileName" boolean:showColoringAsLegendItems="true" boolean:showText="true">
            <xsl:attribute name="type">RowIntervalParallel</xsl:attribute>
            <drawBy>
              <queryRef>/GPUComputeTask</queryRef>
            </drawBy>
            <tooltipBy>
              <queryRef>/GPUComputeTask</queryRef>
              <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
              <queryRef>/GPUComputeGlobalDim</queryRef>
              <queryRef>/GPUComputeLocalDim</queryRef>
              <queryRef>/GPUComputeSimdWidth</queryRef>
            </tooltipBy>
            <colorBy>
              <queryRef>/GPUComputeTaskPurposeShortName</queryRef>
            </colorBy>
            <correlateBy int:groupId="4">
              <queryRef>/GPUComputeTaskId</queryRef>
            </correlateBy>
          </layer>
        </rowSet>
      </area>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
