/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.verilog;

import firrtl.CircuitForm;
import firrtl.CircuitState;
import firrtl.DependencyAPIMigration;
import firrtl.Dshlw$;
import firrtl.Mappers;
import firrtl.Mappers$;
import firrtl.Mappers$ExprMagnet$;
import firrtl.Mappers$ExprMap$;
import firrtl.Mappers$ModuleMagnet$;
import firrtl.Mappers$ModuleMap$;
import firrtl.PrimOps$AsSInt$;
import firrtl.PrimOps$Bits$;
import firrtl.PrimOps$Dshl$;
import firrtl.PrimOps$Head$;
import firrtl.PrimOps$Neg$;
import firrtl.PrimOps$Rem$;
import firrtl.PrimOps$Shr$;
import firrtl.PrimOps$Sub$;
import firrtl.PrimOps$Tail$;
import firrtl.Transform;
import firrtl.Utils$;
import firrtl.bitWidth$;
import firrtl.ir.Circuit;
import firrtl.ir.DefModule;
import firrtl.ir.DoPrim;
import firrtl.ir.Expression;
import firrtl.ir.Info;
import firrtl.ir.IntWidth;
import firrtl.ir.IntWidth$;
import firrtl.ir.PrimOp;
import firrtl.ir.SIntLiteral;
import firrtl.ir.SIntType;
import firrtl.ir.Statement;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.Width;
import firrtl.options.Dependency;
import firrtl.options.DependencyAPI;
import firrtl.passes.PadWidths$;
import firrtl.passes.Pass;
import firrtl.passes.SplitExpressions$;
import firrtl.stage.Forms$;
import firrtl.transforms.ConstantPropagation$;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class LegalizeVerilog$
implements Pass {
    public static final LegalizeVerilog$ MODULE$ = new LegalizeVerilog$();
    private static LinkedHashSet<Dependency<Transform>> firrtl$Transform$$fullCompilerSet;
    private static LinkedHashSet<Dependency<Transform>> firrtl$Transform$$highOutputInvalidates;
    private static LinkedHashSet<Dependency<Transform>> firrtl$Transform$$midOutputInvalidates;
    private static LinkedHashSet<Dependency<Transform>> _prerequisites;
    private static LinkedHashSet<Dependency<Transform>> _optionalPrerequisites;
    private static LinkedHashSet<Dependency<Transform>> _optionalPrerequisiteOf;
    private static Logger logger;
    private static volatile byte bitmap$0;

    static {
        LazyLogging.$init$(MODULE$);
        DependencyAPI.$init$(MODULE$);
        Transform.$init$(MODULE$);
        DependencyAPIMigration.$init$(MODULE$);
        Pass.$init$(MODULE$);
    }

    @Override
    public CircuitState execute(CircuitState state) {
        return Pass.execute$(this, state);
    }

    @Override
    public final CircuitForm inputForm() {
        return DependencyAPIMigration.inputForm$(this);
    }

    @Override
    public final CircuitForm outputForm() {
        return DependencyAPIMigration.outputForm$(this);
    }

    @Override
    public String name() {
        return Transform.name$(this);
    }

    @Override
    public CircuitState transform(CircuitState state) {
        return Transform.transform$(this, state);
    }

    @Override
    public CircuitState prepare(CircuitState state) {
        return Transform.prepare$(this, state);
    }

    @Override
    public final CircuitState runTransform(CircuitState state) {
        return Transform.runTransform$(this, state);
    }

    @Override
    public Seq<Dependency<Transform>> dependents() {
        return DependencyAPI.dependents$(this);
    }

    @Override
    public Logger getLogger() {
        return LazyLogging.getLogger$(this);
    }

    private LinkedHashSet<Dependency<Transform>> firrtl$Transform$$fullCompilerSet$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                firrtl$Transform$$fullCompilerSet = Transform.firrtl$Transform$$fullCompilerSet$(this);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return firrtl$Transform$$fullCompilerSet;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> firrtl$Transform$$fullCompilerSet() {
        return (byte)(bitmap$0 & 1) == 0 ? this.firrtl$Transform$$fullCompilerSet$lzycompute() : firrtl$Transform$$fullCompilerSet;
    }

    private LinkedHashSet<Dependency<Transform>> firrtl$Transform$$highOutputInvalidates$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                firrtl$Transform$$highOutputInvalidates = Transform.firrtl$Transform$$highOutputInvalidates$(this);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return firrtl$Transform$$highOutputInvalidates;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> firrtl$Transform$$highOutputInvalidates() {
        return (byte)(bitmap$0 & 2) == 0 ? this.firrtl$Transform$$highOutputInvalidates$lzycompute() : firrtl$Transform$$highOutputInvalidates;
    }

    private LinkedHashSet<Dependency<Transform>> firrtl$Transform$$midOutputInvalidates$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                firrtl$Transform$$midOutputInvalidates = Transform.firrtl$Transform$$midOutputInvalidates$(this);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return firrtl$Transform$$midOutputInvalidates;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> firrtl$Transform$$midOutputInvalidates() {
        return (byte)(bitmap$0 & 4) == 0 ? this.firrtl$Transform$$midOutputInvalidates$lzycompute() : firrtl$Transform$$midOutputInvalidates;
    }

    private LinkedHashSet<Dependency<Transform>> _prerequisites$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                _prerequisites = DependencyAPI._prerequisites$(this);
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return _prerequisites;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> _prerequisites() {
        return (byte)(bitmap$0 & 8) == 0 ? this._prerequisites$lzycompute() : _prerequisites;
    }

    private LinkedHashSet<Dependency<Transform>> _optionalPrerequisites$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                _optionalPrerequisites = DependencyAPI._optionalPrerequisites$(this);
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return _optionalPrerequisites;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> _optionalPrerequisites() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this._optionalPrerequisites$lzycompute() : _optionalPrerequisites;
    }

    private LinkedHashSet<Dependency<Transform>> _optionalPrerequisiteOf$lzycompute() {
        LegalizeVerilog$ legalizeVerilog$ = this;
        synchronized (legalizeVerilog$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                _optionalPrerequisiteOf = DependencyAPI._optionalPrerequisiteOf$(this);
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return _optionalPrerequisiteOf;
    }

    @Override
    public LinkedHashSet<Dependency<Transform>> _optionalPrerequisiteOf() {
        return (byte)(bitmap$0 & 0x20) == 0 ? this._optionalPrerequisiteOf$lzycompute() : _optionalPrerequisiteOf;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public Seq<Dependency<Transform>> prerequisites() {
        return Forms$.MODULE$.LowForm();
    }

    @Override
    public Seq<Nothing$> optionalPrerequisites() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Seq<Nothing$> optionalPrerequisiteOf() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public boolean invalidates(Transform a) {
        Transform transform2 = a;
        boolean bl = SplitExpressions$.MODULE$.equals(transform2);
        return bl;
    }

    private Expression legalizeBitExtract(DoPrim expr) {
        Expression expression = (Expression)expr.args().head();
        boolean bl = expression instanceof UIntLiteral ? true : expression instanceof SIntLiteral;
        Expression expression2 = bl ? ConstantPropagation$.MODULE$.constPropBitExtract(expr) : expr;
        return expression2;
    }

    private Expression legalizeNeg(DoPrim expr) {
        DoPrim doPrim;
        Expression arg = (Expression)expr.args().head();
        Type type = arg.tpe();
        if (type instanceof SIntType) {
            SIntType sIntType = (SIntType)type;
            Expression zero = Utils$.MODULE$.getGroundZero(sIntType);
            doPrim = new DoPrim(PrimOps$Sub$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{zero, arg})), package$.MODULE$.Nil(), expr.tpe());
        } else if (type instanceof UIntType) {
            UIntType uIntType = (UIntType)type;
            Expression zero = Utils$.MODULE$.getGroundZero(uIntType);
            DoPrim sub = new DoPrim(PrimOps$Sub$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{zero, arg})), package$.MODULE$.Nil(), new UIntType(uIntType.width().$plus(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1)))));
            doPrim = new DoPrim(PrimOps$AsSInt$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DoPrim[]{sub})), package$.MODULE$.Nil(), expr.tpe());
        } else {
            throw new MatchError(type);
        }
        return doPrim;
    }

    private int getWidth(Expression e) {
        return bitWidth$.MODULE$.apply(e.tpe()).toInt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression legalizeRem(Expression e) {
        Expression expression;
        int bwidth;
        Expression expression2 = e;
        if (!(expression2 instanceof DoPrim)) return e;
        DoPrim doPrim = (DoPrim)expression2;
        PrimOp primOp = doPrim.op();
        Seq<Expression> seq = doPrim.args();
        Type tpe = doPrim.tpe();
        if (!PrimOps$Rem$.MODULE$.equals(primOp)) return e;
        if (seq == null) return e;
        SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
        if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return e;
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return e;
        if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return e;
        Expression a = (Expression)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        Expression b = (Expression)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        int awidth = this.getWidth(a);
        if (awidth == (bwidth = this.getWidth(b))) {
            expression = doPrim;
            return expression;
        } else {
            int maxWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(awidth), bwidth);
            Type newType = tpe.mapWidth((Function1<Width, Width>)(Function1<Width, IntWidth> & Serializable)x$1 -> IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(maxWidth)));
            Expression paddedRem = Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(doPrim), (Function1<Expression, Expression> & Serializable)x$2 -> PadWidths$.MODULE$.forceWidth(maxWidth, (Expression)x$2), (Function1<Function1, Mappers.ExprMagnet> & Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f)).mapType((Function1<Type, Type> & Serializable)x$3 -> newType);
            int minWidth = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(awidth), bwidth);
            expression = PadWidths$.MODULE$.forceWidth(minWidth, paddedRem);
        }
        return expression;
    }

    private Expression onExpr(Expression expr2) {
        Expression expression;
        Expression expression2 = Mappers$ExprMap$.MODULE$.map$extension(Mappers$.MODULE$.ExprMap(expr2), (Function1<Expression, Expression> & Serializable)expr -> MODULE$.onExpr((Expression)expr), (Function1<Function1, Mappers.ExprMagnet> & Serializable)f -> Mappers$ExprMagnet$.MODULE$.forExpr((Function1<Expression, Expression>)f));
        if (expression2 instanceof DoPrim) {
            boolean bl;
            DoPrim doPrim = (DoPrim)expression2;
            PrimOp primOp = doPrim.op();
            Expression expression3 = PrimOps$Shr$.MODULE$.equals(primOp) ? ConstantPropagation$.MODULE$.foldShiftRight(doPrim) : ((bl = PrimOps$Bits$.MODULE$.equals(primOp) ? true : (PrimOps$Head$.MODULE$.equals(primOp) ? true : PrimOps$Tail$.MODULE$.equals(primOp))) ? this.legalizeBitExtract(doPrim) : (PrimOps$Neg$.MODULE$.equals(primOp) ? this.legalizeNeg(doPrim) : (PrimOps$Rem$.MODULE$.equals(primOp) ? this.legalizeRem(doPrim) : (PrimOps$Dshl$.MODULE$.equals(primOp) ? doPrim.copy(Dshlw$.MODULE$, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{PadWidths$.MODULE$.forceWidth(this.getWidth(doPrim), (Expression)doPrim.args().head()), (Expression)doPrim.args().apply(true)})), doPrim.copy$default$3(), doPrim.copy$default$4()) : doPrim))));
            expression = expression3;
        } else {
            expression = expression2;
        }
        return expression;
    }

    @Override
    public Circuit run(Circuit c) {
        Seq x$1 = (Seq)c.modules().map((Function1<DefModule, DefModule> & Serializable)x$4 -> Mappers$ModuleMap$.MODULE$.map$extension(Mappers$.MODULE$.ModuleMap((DefModule)x$4), (Function1<Statement, Statement> & Serializable)s -> LegalizeVerilog$.legalizeS$1(s), (Function1<Function1, Mappers.ModuleMagnet> & Serializable)f -> Mappers$ModuleMagnet$.MODULE$.forStmt((Function1<Statement, Statement>)f)));
        Info x$2 = c.copy$default$1();
        String x$3 = c.copy$default$3();
        return c.copy(x$2, x$1, x$3);
    }

    private static final Statement legalizeS$1(Statement s2) {
        return s2.mapStmt((Function1<Statement, Statement> & Serializable)s -> LegalizeVerilog$.legalizeS$1(s)).mapExpr((Function1<Expression, Expression> & Serializable)expr -> MODULE$.onExpr((Expression)expr));
    }

    private LegalizeVerilog$() {
    }
}

