module cade_id
#( 
  parameter WIDTH=32
)
(
   input clk,
   input resetn,

   // Agent port
   input agent_address,  // Word address
   input [WIDTH-1:0] agent_writedata,
   input agent_read,
   input agent_write,
   input [WIDTH/8-1:0] agent_byteenable,
   output [WIDTH-1:0] agent_readdata,
   output reg agent_readdatavalid,
   output agent_waitrequest,

   output reg [31:0]      probe
);

reg [31:0] cade_id;

always@(posedge clk)
  if (agent_write) begin
    cade_id <= {agent_byteenable[3] ? agent_writedata[31:24] : cade_id[31:24],
			agent_byteenable[2] ? agent_writedata[23:16] : cade_id[23:16],
			agent_byteenable[1] ? agent_writedata[15:8] : cade_id[15:8],
			agent_byteenable[0] ? agent_writedata[7:0] : cade_id[7:0]};
  end

//pipeline the register to system probe
always@(posedge clk) probe[31:0] <= cade_id[31:0];

// rddata valid
always@(posedge clk) agent_readdatavalid <= agent_read;

assign agent_waitrequest = 1'b0; 
assign agent_readdata[31:0] = cade_id[31:0];
  
endmodule

