<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="Light_OperationsGroup">
                                <queryInherit>/Light_Operations</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Light_OperationsGroupExpanded">
                                        <derivedQuery id="FP_ArithGroup">
                                            <queryInherit>/FP_Arith</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="FP_ArithGroupExpanded">
                                                    <queryRef>/FP_x87</queryRef>
                                                    <queryRef>/FP_Scalar</queryRef>
                                                    <derivedQuery id="FP_VectorGroup">
                                                        <queryInherit>/FP_Vector</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="FP_VectorGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="Heavy_OperationsGroup">
                                <queryInherit>/Heavy_Operations</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="Heavy_OperationsGroupExpanded">
                                        <derivedQuery id="MicroSequencerGroup">
                                            <queryInherit>/MicroSequencer</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MicroSequencerGroupExpanded" />
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ITLBOverhead</queryRef>
                                        <derivedQuery id="BranchResteersGroup">
                                            <queryInherit>/BranchResteers</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="BranchResteersGroupExpanded" />
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/DSBtoMITESwitchCost</queryRef>
                                        <queryRef>/LCP</queryRef>
                                        <queryRef>/MSSwitches</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/DSB_Coverage</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>/BranchMispredict</queryRef>
                            <queryRef>/MachineClears</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <derivedQuery id="L3BoundGroup">
                                            <queryInherit>/L3Bound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L3BoundGroupExpanded" />
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="DRAMBoundGroup">
                                            <queryInherit>/DRAMBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="DRAMBoundGroupExpanded">
                                                    <derivedQuery id="MEMBandwidthGroup">
                                                        <queryInherit>/MEMBandwidth</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="MEMBandwidthGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="MEMLatencyGroup">
                                                        <queryInherit>/MEMLatency</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="MEMLatencyGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="StoresBoundGroup">
                                            <queryInherit>/StoresBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="StoresBoundGroupExpanded" />
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="CoreBoundGroup">
                                <queryInherit>/CoreBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="CoreBoundGroupExpanded">
                                        <queryRef>/DIVActive</queryRef>
                                        <derivedQuery id="PortUtilGroup">
                                            <queryInherit>/PortUtil</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="PortUtilGroupExpanded" />
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="Light_Operations">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/RetiredPipelineSlots") - query("/Heavy_Operations") ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Light_Operations") > 0.6 ) ) && ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.6 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_x87") + query("/FP_Scalar") + query("/FP_Vector") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="FP_x87">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots") * query("/PMUEventCount/PMUEventType[FP_COMP_OPS_EXE.X87]") / query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD]") ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_x87") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="FP_Scalar">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar") / query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD]") ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Scalar") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Vector") > 0.1) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="FP_Vector">
                    <queryInherit>/GeMetricBaseUops</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector") / query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD]") ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FP_Vector") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/FP_Scalar") > 0.1) ) && ( ( ( query("/FP_Arith") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/Light_Operations") > 0.6 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="Heavy_Operations">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MicroSequencer") ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Heavy_Operations") > 0.1 ) ) && ( ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retire_Fraction") * query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MicroSequencer") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MSSwitches") > 0.05) ) && ( ( query("/Heavy_Operations") > 0.1 ) && ( ( query("/RetiredPipelineSlots") > 0.7 ) || ( queryOptional("/Heavy_Operations") > 0.1 ) ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width") * query("/Frontend_Latency_Cycles") / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) else ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ITLB_Miss_Cycles") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/ITLBOverhead") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.STLB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.WALK_DURATION]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BAClear_Cost") * ( query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") + query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") + query("/PMUEventCount/PMUEventType[BACLEARS.ANY]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchResteers") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[BACLEARS.ANY]") >= 10 ) ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispredicts_Resteers" id="Mispredicts_Resteers">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Clears_Resteers" id="Clears_Resteers">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="DSBtoMITESwitchCost">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DSBtoMITESwitchCost") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/LCP") > 0.05) || ( queryOptional("/FEBandwidth") > 0.1) ) && ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="LCP">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ILD_STALL.LCP]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/LCP") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) || ( queryOptional("/FEBandwidth") > 0.1) ) && ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ILD_STALL.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="MSSwitches">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MS_Switches_Cost") * query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MSSwitches") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MicroSequencer") > 0.05) ) && ( ( ( query("/FELatency") > 0.10 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/FrontendBoundPipelineSlots") - query("/FELatency") ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/FEBandwidth") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) || ( queryOptional("/LCP") > 0.05) ) && ( ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) else ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthMITE" id="FEBandwidthMITE">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="DSB_Coverage">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]") / query("/Fetched_Uops") ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DSB_Coverage") < 0.7 ) ) && ( ( ( query("/FEBandwidth") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/DSBtoMITESwitchCost") > 0.05) || ( queryOptional("/LCP") > 0.05) && ( query("/FrontendBoundPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.7 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) && ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]") - query("/Retired_Slots") + query("/Pipeline_Width") * query("/Recovery_Cycles") ) / query("/SLOTS") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction") * query("/CancelledPipelineSlots") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/BranchMispredict") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/CancelledPipelineSlots") - query("/BranchMispredict") ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MachineClears") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/CancelledPipelineSlots") > 0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 1 - ( query("/FrontendBoundPipelineSlots") + query("/CancelledPipelineSlots") + query("/RetiredPipelineSlots") ) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound") > 0.2 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Bound_Fraction") * query("/BackendBound") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) || (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="DTLBOverhead">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Mem_STLB_Hit_Cost") * query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]") + query("/PMUEventCount/PMUEventType[DTLB_LOAD_MISSES.WALK_DURATION]") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DTLBOverhead") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/L1Bound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) || ( queryOptional("/MachineClears") > 0.1) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.STLB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[DTLB_LOAD_MISSES.WALK_DURATION]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LockLatency" id="LockLatency">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FBFull" id="FBFull">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_L3_Hit_Fraction") * query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_PENDING]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/L3Bound") > 0.05 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") >= 10 ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_PENDING]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ContestedAccesses" id="ContestedAccesses">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DataSharing" id="DataSharing">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Latency" id="L3Latency">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SQFull" id="SQFull">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 1 - query("/Mem_L3_Hit_Fraction") ) * query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_PENDING]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( (  ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") >= 10 ) ) ) ) ) || ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L2_PENDING]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="MEMBandwidth">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_BW_Cycles") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMBandwidth") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="MEMLatency">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_Any_Cycles") / query("/DerivedClockticks") - query("/MEMBandwidth") ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/MEMLatency") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/DRAMBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RemoteCache" id="RemoteCache">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SB]") / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/StoresBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/MemBound") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoreLatency" id="StoreLatency">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FalseSharing" id="FalseSharing">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SplitStores" id="SplitStores">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBStoreOverhead" id="DTLBStoreOverhead">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound") - query("/MemBound") ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.1 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) || (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="DIVActive">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[ARITH.FPU_DIV_ACTIVE]") / query("/CORE_CLKS") ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/DIVActive") > 0.2 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.2 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ARITH.FPU_DIV_ACTIVE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="PortUtil">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/Backend_Bound_Cycles") - query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SB]") - query("/STALLS_MEM_ANY") ) / query("/DerivedClockticks") ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( ( query("/PortUtil") > 0.15 ) && ( query("/PMUHotspot") > 0.05 ) ) ) && ( ( ( query("/CoreBound") > 0.1 ) && ( query("/PMUHotspot") > 0.05 ) ) && ( query("/BackendBound") > 0.2 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles1PortUtilized" id="Cycles1PortUtilized">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Cycles2PortsUtilized" id="Cycles2PortsUtilized">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port0" id="Port0">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port1" id="Port1">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port5" id="Port5">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port6" id="Port6">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Port4" id="Port4">
                    <valueEval>0</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS">
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width") * query("/CORE_CLKS") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="CORE_CLKS">
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( ( query("/DerivedClockticks") / 2 ) * ( 1 + query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.ONE_THREAD_ACTIVE]") / query("/PMUEventCount/PMUEventType[CPU_CLK_UNHALTED.REF_XCLK]") ) ) if query("/SMT_on") else query("/DerivedClockticks") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.ONE_THREAD_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_XCLK]") >= 10 ) ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="Backend_Bound_Cycles">
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/STALLS_TOTAL") + query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") - query("/Few_Uops_Executed_Threshold") - query("/Frontend_RS_Empty_Cycles") + query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SB]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="Fetched_Uops">
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]") + query("/PMUEventCount/PMUEventType[LSD.UOPS]") + query("/PMUEventCount/PMUEventType[IDQ.MITE_UOPS]") + query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="Few_Uops_Executed_Threshold">
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") if ( query("/IPC") > 1.8 ) else query("/PMUEventCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="FP_Arith_Scalar">
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") + query("/PMUEventCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="FP_Arith_Vector">
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") + query("/PMUEventCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") + query("/PMUEventCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") + query("/PMUEventCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Frontend_RS_Empty_Cycles" id="Frontend_RS_Empty_Cycles">
                    <description>%Frontend_RS_Empty_CyclesDescriptionAll</description>
                    <helpKeyword>configs.frontend_rs_empty_cycles_frontend_rs_empty_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") if ( query("/FELatency") > 0.1 ) else 0 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Frontend_Latency_Cycles" id="Frontend_Latency_Cycles">
                    <description>%Frontend_Latency_CyclesDescriptionAll</description>
                    <helpKeyword>configs.frontend_latency_cycles_frontend_latency_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) else ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLB_Miss_Cycles" id="ITLB_Miss_Cycles">
                    <description>%ITLB_Miss_CyclesDescriptionAll</description>
                    <helpKeyword>configs.itlb_miss_cycles_itlb_miss_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( 12 * query("/PMUEventCount/PMUEventType[ITLB_MISSES.STLB_HIT]") + query("/PMUEventCount/PMUEventType[ITLB_MISSES.WALK_DURATION]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.STLB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.WALK_DURATION]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L3_Hit_Fraction" id="Mem_L3_Hit_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mem_L3_Hit_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_l3_hit_fraction_mem_l3_hit_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") / ( query("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") + query("/Mem_L3_Weight") * query("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="Memory_Bound_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/STALLS_MEM_ANY") + query("/PMUEventCount/PMUEventType[RESOURCE_STALLS.SB]") ) / query("/Backend_Bound_Cycles") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="Mispred_Clears_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") / ( query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") + query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="ORO_DRD_Any_Cycles">
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="ORO_DRD_BW_Cycles">
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>4</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Recovery_Cycles" id="Recovery_Cycles">
                    <description>%Recovery_CyclesDescriptionAll</description>
                    <helpKeyword>configs.recovery_cycles_recovery_cyclesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="Retire_Fraction">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots") / query("/PMUEventCount/PMUEventType[UOPS_ISSUED.ANY]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="Retired_Slots">
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%STALLS_MEM_ANY" id="STALLS_MEM_ANY">
                    <description>%STALLS_MEM_ANYDescriptionAll</description>
                    <helpKeyword>configs.stalls_mem_any_stalls_mem_anydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%STALLS_TOTAL" id="STALLS_TOTAL">
                    <description>%STALLS_TOTALDescriptionAll</description>
                    <helpKeyword>configs.stalls_total_stalls_totaldescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/DerivedClockticks") < query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ? query("/DerivedClockticks") : query("/PMUEventCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L3_Weight" id="Mem_L3_Weight">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_L3_WeightDescriptionAll</description>
                    <helpKeyword>configs.mem_l3_weight_mem_l3_weightdescriptionall</helpKeyword>
                    <valueEval>7</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_STLB_Hit_Cost" id="Mem_STLB_Hit_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%Mem_STLB_Hit_CostDescriptionAll</description>
                    <helpKeyword>configs.mem_stlb_hit_cost_mem_stlb_hit_costdescriptionall</helpKeyword>
                    <valueEval>7</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%BAClear_Cost" id="BAClear_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%BAClear_CostDescriptionAll</description>
                    <helpKeyword>configs.baclear_cost_baclear_costdescriptionall</helpKeyword>
                    <valueEval>12</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MS_Switches_Cost" id="MS_Switches_Cost">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%MS_Switches_CostDescriptionAll</description>
                    <helpKeyword>configs.ms_switches_cost_ms_switches_costdescriptionall</helpKeyword>
                    <valueEval>3</valueEval>
                </derivedQuery>
                <derivedQuery displayName="%SMT_on" id="SMT_on">
                    <queryInherit>/GeMetricBaseNumber</queryInherit>
                    <description>%SMT_onDescriptionAll</description>
                    <helpKeyword>configs.smt_on_smt_ondescriptionall</helpKeyword>
                    <valueEval>$isHTEnabled</valueEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorLight_OperationsGroup">
                                            <queryInherit>/locatorLight_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorLight_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorFP_ArithGroup">
                                                        <queryInherit>/locatorFP_Arith</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorFP_ArithGroupExpanded">
                                                                <queryRef>/locatorFP_x87</queryRef>
                                                                <queryRef>/locatorFP_Scalar</queryRef>
                                                                <derivedQuery id="locatorFP_VectorGroup">
                                                                    <queryInherit>/locatorFP_Vector</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorFP_VectorGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorHeavy_OperationsGroup">
                                            <queryInherit>/locatorHeavy_Operations</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorHeavy_OperationsGroupExpanded">
                                                    <derivedQuery id="locatorMicroSequencerGroup">
                                                        <queryInherit>/locatorMicroSequencer</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMicroSequencerGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorITLBOverhead</queryRef>
                                                    <derivedQuery id="locatorBranchResteersGroup">
                                                        <queryInherit>/locatorBranchResteers</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorBranchResteersGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorDSBtoMITESwitchCost</queryRef>
                                                    <queryRef>/locatorLCP</queryRef>
                                                    <queryRef>/locatorMSSwitches</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorDSB_Coverage</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>/locatorBranchMispredict</queryRef>
                                        <queryRef>/locatorMachineClears</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <derivedQuery id="locatorL3BoundGroup">
                                                        <queryInherit>/locatorL3Bound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL3BoundGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorDRAMBoundGroup">
                                                        <queryInherit>/locatorDRAMBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorDRAMBoundGroupExpanded">
                                                                <derivedQuery id="locatorMEMBandwidthGroup">
                                                                    <queryInherit>/locatorMEMBandwidth</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMBandwidthGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                                <derivedQuery id="locatorMEMLatencyGroup">
                                                                    <queryInherit>/locatorMEMLatency</queryInherit>
                                                                    <displayAttributes>
                                                                        <boolean:expand>false</boolean:expand>
                                                                        <boolean:allowCollapse>true</boolean:allowCollapse>
                                                                    </displayAttributes>
                                                                    <expand>
                                                                        <vectorQuery id="locatorMEMLatencyGroupExpanded" />
                                                                    </expand>
                                                                </derivedQuery>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <derivedQuery id="locatorStoresBoundGroup">
                                                        <queryInherit>/locatorStoresBound</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorStoresBoundGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorCoreBoundGroup">
                                            <queryInherit>/locatorCoreBound</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorCoreBoundGroupExpanded">
                                                    <queryRef>/locatorDIVActive</queryRef>
                                                    <derivedQuery id="locatorPortUtilGroup">
                                                        <queryInherit>/locatorPortUtil</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorPortUtilGroupExpanded" />
                                                        </expand>
                                                    </derivedQuery>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") / queryAll("/PMUEventCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]", true)) * queryAll("/RetiredPipelineSlots", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") > 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Light_Operations" id="locatorLight_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Light_OperationsDescriptionAll</description>
                    <helpKeyword>configs.light_operations_light_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[INST_RETIRED.PREC_DIST]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[INST_RETIRED.PREC_DIST]") / queryAll("/PMUEventCount/PMUEventType[INST_RETIRED.PREC_DIST]", true)) * queryAll("/Light_Operations", true) ) ]]></valueEval>
                    <issueText>%Light_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLight_Operations") > 0.6 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_x87" id="locatorFP_x87">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_x87DescriptionAll</description>
                    <helpKeyword>configs.fp_x87_fp_x87descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.X87]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_x87") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]", true) ) ]]></valueEval>
                    <issueText>%FP_x87IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_x87") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Scalar" id="locatorFP_Scalar">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_scalar_fp_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Scalar") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]", true) ) ]]></valueEval>
                    <issueText>%FP_ScalarIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Scalar") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Vector" id="locatorFP_Vector">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_vector_fp_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Vector") * query("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]")) / queryAll("/PMUEventCount/PMUEventType[UOPS_EXECUTED.THREAD]", true) ) ]]></valueEval>
                    <issueText>%FP_VectorIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Vector") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Heavy_Operations" id="locatorHeavy_Operations">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Heavy_OperationsDescriptionAll</description>
                    <helpKeyword>configs.heavy_operations_heavy_operationsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Heavy_Operations") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%Heavy_OperationsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorHeavy_Operations") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]") / queryAll("/PMUEventCount/PMUEventType[IDQ.MS_UOPS]", true)) * queryAll("/MicroSequencer", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_END]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[RS_EVENTS.EMPTY_END]") / queryAll("/PMUEventCount/PMUEventType[RS_EVENTS.EMPTY_END]", true)) * queryAll("/FELatency", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") > 0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.WALK_COMPLETED]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ITLB_MISSES.WALK_COMPLETED]") / queryAll("/PMUEventCount/PMUEventType[ITLB_MISSES.WALK_COMPLETED]", true)) * queryAll("/ITLBOverhead", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") / queryAll("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]", true)) * queryAll("/BranchResteers", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSBtoMITESwitchCost" id="locatorDSBtoMITESwitchCost">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSBtoMITESwitchCostDescriptionAll</description>
                    <helpKeyword>configs.dsbtomiteswitchcost_dsbtomiteswitchcostdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[DSB2MITE_SWITCHES.PENALTY_CYCLES]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/DSBtoMITESwitchCost") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%DSBtoMITESwitchCostIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSBtoMITESwitchCost") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LCP" id="locatorLCP">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LCPDescriptionAll</description>
                    <helpKeyword>configs.lcp_lcpdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[ILD_STALL.LCP]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/LCP") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%LCPIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLCP") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MSSwitches" id="locatorMSSwitches">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MSSwitchesDescriptionAll</description>
                    <helpKeyword>configs.msswitches_msswitchesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.MS_SWITCHES]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]") / queryAll("/PMUEventCount/PMUEventType[IDQ.MS_SWITCHES]", true)) * queryAll("/MSSwitches", true) ) ]]></valueEval>
                    <issueText>%MSSwitchesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMSSwitches") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( (  ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) else ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidth") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DSB_Coverage" id="locatorDSB_Coverage">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DSB_CoverageDescriptionAll</description>
                    <helpKeyword>configs.dsb_coverage_dsb_coveragedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]") / queryAll("/PMUEventCount/PMUEventType[IDQ.DSB_UOPS]", true)) * queryAll("/DSB_Coverage", true) ) ]]></valueEval>
                    <issueText>%DSB_CoverageIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDSB_Coverage") < 0.7 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES_PS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES_PS]") / queryAll("/PMUEventCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES_PS]", true)) * queryAll("/BranchMispredict", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]") / queryAll("/PMUEventCount/PMUEventType[MACHINE_CLEARS.COUNT]", true)) * queryAll("/MachineClears", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]") / queryAll("/PMUEventCount/PMUEventType[TOPDOWN.MEMORY_BOUND_SLOTS]", true)) * queryAll("/MemBound", true) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DTLBOverhead" id="locatorDTLBOverhead">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DTLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.dtlboverhead_dtlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.STLB_MISS_LOADS_PS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.STLB_MISS_LOADS_PS]") / queryAll("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.STLB_MISS_LOADS_PS]", true)) * queryAll("/DTLBOverhead", true) ) ]]></valueEval>
                    <issueText>%DTLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDTLBOverhead") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]", true)) * queryAll("/L3Bound", true) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") > 0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") / queryAll("/PMUEventCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]", true)) * queryAll("/DRAMBound", true) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMBandwidth" id="locatorMEMBandwidth">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMBandwidthDescriptionAll</description>
                    <helpKeyword>configs.membandwidth_membandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMBandwidth") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%MEMBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMBandwidth") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEMLatency" id="locatorMEMLatency">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEMLatencyDescriptionAll</description>
                    <helpKeyword>configs.memlatency_memlatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MEMLatency") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%MEMLatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMEMLatency") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES_PS]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES_PS]") / queryAll("/PMUEventCount/PMUEventType[MEM_UOPS_RETIRED.ALL_STORES_PS]", true)) * queryAll("/StoresBound", true) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) || (  ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CORE]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) || (  ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CoreBound") * query("/SLOTS")) / queryAll("/SLOTS", true) ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") > 0.1 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DIVActive" id="locatorDIVActive">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DIVActiveDescriptionAll</description>
                    <helpKeyword>configs.divactive_divactivedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( query("/PMUSampleCount/PMUEventType[ARITH.FPU_DIV_ACTIVE]") >= 10 ) )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PMUEventCount/PMUEventType[ARITH.FPU_DIV_ACTIVE]") / queryAll("/PMUEventCount/PMUEventType[ARITH.FPU_DIV_ACTIVE]", true)) * queryAll("/DIVActive", true) ) ]]></valueEval>
                    <issueText>%DIVActiveIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDIVActive") > 0.2 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PortUtil" id="locatorPortUtil">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PortUtilDescriptionAll</description>
                    <helpKeyword>configs.portutil_portutildescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PortUtil") * query("/DerivedClockticks")) / queryAll("/DerivedClockticks", true) ) ]]></valueEval>
                    <issueText>%PortUtilIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPortUtil") > 0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%CORE_CLKS" id="locatorCORE_CLKS">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CORE_CLKSDescriptionAll</description>
                    <helpKeyword>configs.core_clks_core_clksdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 )  ) || (  ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.ONE_THREAD_ACTIVE]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.REF_XCLK]") >= 10 ) ) ) ) ) if ( 111 ) else ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/CORE_CLKS") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Backend_Bound_Cycles" id="locatorBackend_Bound_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Backend_Bound_CyclesDescriptionAll</description>
                    <helpKeyword>configs.backend_bound_cycles_backend_bound_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Backend_Bound_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Fetched_Uops" id="locatorFetched_Uops">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Fetched_UopsDescriptionAll</description>
                    <helpKeyword>configs.fetched_uops_fetched_uopsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[IDQ.DSB_UOPS]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LSD.UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MITE_UOPS]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[IDQ.MS_UOPS]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Fetched_Uops") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Few_Uops_Executed_Threshold" id="locatorFew_Uops_Executed_Threshold">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Few_Uops_Executed_ThresholdDescriptionAll</description>
                    <helpKeyword>configs.few_uops_executed_threshold_few_uops_executed_thresholddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Few_Uops_Executed_Threshold") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Scalar" id="locatorFP_Arith_Scalar">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_ScalarDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_scalar_fp_arith_scalardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_SINGLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_SCALAR_DOUBLE]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Scalar") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith_Vector" id="locatorFP_Arith_Vector">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_Arith_VectorDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_vector_fp_arith_vectordescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_DOUBLE]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[FP_COMP_OPS_EXE.SSE_PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_SINGLE]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[SIMD_FP_256.PACKED_DOUBLE]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FP_Arith_Vector") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Frontend_RS_Empty_Cycles" id="locatorFrontend_RS_Empty_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Frontend_RS_Empty_CyclesDescriptionAll</description>
                    <helpKeyword>configs.frontend_rs_empty_cycles_frontend_rs_empty_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Frontend_RS_Empty_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Frontend_Latency_Cycles" id="locatorFrontend_Latency_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Frontend_Latency_CyclesDescriptionAll</description>
                    <helpKeyword>configs.frontend_latency_cycles_frontend_latency_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) else ( query("/PMUSampleCount/PMUEventType[IDQ_UOPS_NOT_DELIVERED.CYCLES_0_UOPS_DELIV.CORE]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Frontend_Latency_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLB_Miss_Cycles" id="locatorITLB_Miss_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLB_Miss_CyclesDescriptionAll</description>
                    <helpKeyword>configs.itlb_miss_cycles_itlb_miss_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( (  ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.STLB_HIT]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[ITLB_MISSES.WALK_DURATION]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ITLB_Miss_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mem_L3_Hit_Fraction" id="locatorMem_L3_Hit_Fraction">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mem_L3_Hit_FractionDescriptionAll</description>
                    <helpKeyword>configs.mem_l3_hit_fraction_mem_l3_hit_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_RETIRED.LLC_HIT_PS]") >= 10 ) || (  ( query("/PMUSampleCount/PMUEventType[MEM_LOAD_UOPS_MISC_RETIRED.LLC_MISS_PS]") >= 10 ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mem_L3_Hit_Fraction") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Memory_Bound_Fraction" id="locatorMemory_Bound_Fraction">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Memory_Bound_FractionDescriptionAll</description>
                    <helpKeyword>configs.memory_bound_fraction_memory_bound_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) && ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=1]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=3]") >= 10 ) ) if ( ( query("/IPC") > 1.8 ) ) else ( ( query("/PMUSampleCount/PMUEventType[UOPS_DISPATCHED.THREAD:cmask=2]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[RS_EVENTS.EMPTY_CYCLES]") >= 10 ) ) if ( ( query("/FELatency") > 0.1 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[RESOURCE_STALLS.SB]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Memory_Bound_Fraction") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Mispred_Clears_Fraction" id="locatorMispred_Clears_Fraction">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Mispred_Clears_FractionDescriptionAll</description>
                    <helpKeyword>configs.mispred_clears_fraction_mispred_clears_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) && ( ( query("/PMUSampleCount/PMUEventType[BR_MISP_RETIRED.ALL_BRANCHES]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.COUNT]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Mispred_Clears_Fraction") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_Any_Cycles" id="locatorORO_DRD_Any_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_Any_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_any_cycles_oro_drd_any_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.CYCLES_WITH_DATA_RD]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_Any_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%ORO_DRD_BW_Cycles" id="locatorORO_DRD_BW_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ORO_DRD_BW_CyclesDescriptionAll</description>
                    <helpKeyword>configs.oro_drd_bw_cycles_oro_drd_bw_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) else ( query("/PMUSampleCount/PMUEventType[OFFCORE_REQUESTS_OUTSTANDING.ALL_DATA_RD:cmask=6]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/ORO_DRD_BW_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Recovery_Cycles" id="locatorRecovery_Cycles">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Recovery_CyclesDescriptionAll</description>
                    <helpKeyword>configs.recovery_cycles_recovery_cyclesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[INT_MISC.RECOVERY_CYCLES]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Recovery_Cycles") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retire_Fraction" id="locatorRetire_Fraction">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retire_FractionDescriptionAll</description>
                    <helpKeyword>configs.retire_fraction_retire_fractiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[UOPS_ISSUED.ANY]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Retire_Fraction") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Retired_Slots" id="locatorRetired_Slots">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Retired_SlotsDescriptionAll</description>
                    <helpKeyword>configs.retired_slots_retired_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.RETIRE_SLOTS]") >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Retired_Slots") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%STALLS_MEM_ANY" id="locatorSTALLS_MEM_ANY">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%STALLS_MEM_ANYDescriptionAll</description>
                    <helpKeyword>configs.stalls_mem_any_stalls_mem_anydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.STALLS_L1D_PENDING]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/STALLS_MEM_ANY") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%STALLS_TOTAL" id="locatorSTALLS_TOTAL">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%STALLS_TOTALDescriptionAll</description>
                    <helpKeyword>configs.stalls_total_stalls_totaldescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) >= 10 if ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]") ) < ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) else ( query("/PMUSampleCount/PMUEventType[CYCLE_ACTIVITY.CYCLES_NO_DISPATCH]") ) >= 10 ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/STALLS_TOTAL") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
