/****
    Copyright (C) 2019 Intel Corporation.  All Rights Reserved.

    This file is part of SEP Development Kit.

    SEP Development Kit is free software; you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    SEP Development Kit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SEP Development Kit; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    As a special exception, you may use this file as part of a free software
    library without restriction.  Specifically, if other files instantiate
    templates or use macros or inline functions from this file, or you compile
    this file and link it with other files to produce an executable, this
    file does not by itself cause the resulting executable to be covered by
    the GNU General Public License.  This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
****/





#ifndef _PMU_INFO_MMIO_H_INC_
#define _PMU_INFO_MMIO_H_INC_

static U32 mmio_client_pmu1_common_offset[] = {
	0x5040, 0x5044, 0x5048, 0x5050, 0x5054, 0x5058, 0x0
};

static U32 mmio_pmu2_offset[] = {
	0x250, 0x254, 0x258, 0x25c, 0x260, 0x264, 0x268, 0x0
};

static U32 mmio_pmu3_common_offset[] = {
	0x3008, 0x3010, 0x3018, 0x3020, 0x3028, 0x1008, 0x1010, 0x1018, 0x2008, 0x0
};

static U32 mmio_pmu4_offset[] = {
	0x91B8, 0x91B9, 0x91BA, 0x91BB, 0x91bc, 0x91c0, 0x91c4, 0x0
};

static U32 mmio_pmu5_common_offset[] = {
	0x500, 0x508, 0x400, 0x408, 0x418, 0x420, 0x428, 0x430, 0x438, 0x440, 0x448,
	0x450, 0x458, 0x460, 0x468, 0x470, 0x478, 0x480, 0x488, 0x490, 0x498, 0x4a0,
	0x0
};

static U32 mmio_pmu6_offset_1[] = {
	0x5C,    0x28,    0x20,    0x18,    0x10,    0x8,     0x50,
	0x4C,    0x48,     0x44,   0x40,    0x405C,  0x4000,  0x4028,  0x4020,
	0x4018,  0x4010,  0x4008,  0x4050,  0x404C,  0x4048,  0x4044,  0x4040,
	0x805C,  0x8000,  0x8028,  0x8020,  0x8018,  0x8010,  0x8008,  0x8050,
	0x804C,  0x8048,  0x8044,  0x8040,  0xC05C,  0xC000,  0xC028,  0xC020,
	0xC018,  0xC010,  0xC008,  0xC050,  0xC04C,  0xC048,  0xC044,  0xC040,
	0x1005C, 0x10000, 0x10028, 0x10020, 0x10018, 0x10010, 0x10008, 0x10050,
	0x1004C, 0x10048, 0x10044, 0x10040, 0x1405C, 0x14000, 0x14028, 0x14020,
	0x14018, 0x14010, 0x14008, 0x14050, 0x1404C, 0x14048, 0x14044, 0x14040,
	0x1805C, 0x18000, 0x18028, 0x18020, 0x18018, 0x18010, 0x18008, 0x18050,
	0x1804C, 0x18048, 0x18044, 0x18040, 0x1C05C, 0x1C000, 0x1C028, 0x1C020,
	0x1C018, 0x1C010, 0x1C008, 0x1C050, 0x1C04C, 0x1C048, 0x1C044, 0x1C040,
	0x2005C, 0x20000, 0x20028, 0x20020, 0x20018, 0x20010, 0x20008, 0x20050,
	0x2004C, 0x20048, 0x20044, 0x20040, 0x2405C, 0x24000, 0x24028, 0x24020,
	0x24018, 0x24010, 0x24008, 0x24050, 0x2404C, 0x24048, 0x24044, 0x24040,
	0x2805C, 0x28000, 0x28028, 0x28020, 0x28018, 0x28010, 0x28008, 0x28050,
	0x2804C, 0x28048, 0x28044, 0x28040, 0x2C05C, 0x2C000, 0x2C028, 0x2C020,
	0x2C018, 0x2C010, 0x2C008, 0x2C050, 0x2C04C, 0x2C048, 0x2C044, 0x2C040,
	0x0
};

static U32 mmio_bxt_dvt_pmu1_offset[] = { 0x6868, 0x686C, 0x0 };

static U32 mmio_pmu1_offset[] = {
	0x22800, 0x26800, 0x2A800, 0x22840, 0x22844, 0x22848, 0x2284c, 0x22850,
	0x26840, 0x26844, 0x26848, 0x2684c, 0x26850, 0x2A840, 0x2A844, 0x2A848,
	0x2A84c, 0x2A850, 0x2285c, 0x2685c, 0x2A85c, 0x22808, 0x22810, 0x22818,
	0x22820, 0x22828, 0x26808, 0x26810, 0x26818, 0x26820, 0x26828, 0x2A808,
	0x2A810, 0x2A818, 0x2A820, 0x2A828, 0x22854, 0x26854, 0x2A854, 0x22838,
	0x26838, 0x2A838, 0x2290,  0x2298,  0x22A0,  0x22A8,  0x22B0,  0x4000,
	0x8,     0x40,    0x4008,  0x8000,  0x8008,  0x4040,  0x4044,  0x8040,
	0x8044,  0x54,    0x4054,  0x8054,  0x4038,  0x38,    0x8038,  0xF8,
	0x44,    0x48,    0x10,    0x4010,  0x8010,  0x4C,    0x4048,  0x8048,
	0x404C,  0x804C,  0x18,    0x20,    0x4018,  0x4020,  0x8018,  0x8020,
	0xC,	 0x0
};

static U32 mmio_pmu1_offset_2[] = {
	0x4000,	 0x8000,  0xC000,  0x10000, 0x14000, 0x18000, 0x1C000, 0x20000,
	0x24000, 0x28000, 0x2C000, 0x40,    0x4040,  0x8040,  0xC040,  0x10040,
	0x14040, 0x18040, 0x1C040, 0x20040, 0x24040, 0x28040, 0x2C040, 0x44,
	0x4044,	 0x8044,  0xC044,  0x10044, 0x14044, 0x18044, 0x1C044, 0x20044,
	0x24044, 0x28044, 0x2C044, 0x48,    0x4048,  0x8048,  0xC048,  0x10048,
	0x14048, 0x18048, 0x1C048, 0x20048, 0x24048, 0x28048, 0x2C048, 0x4C,
	0x404C,	 0x804C,  0xC04C,  0x1004C, 0x1404C, 0x1804C, 0x1C04C, 0x2004C,
	0x2404C, 0x2804C, 0x2C04C, 0x8,	    0x4008,  0x8008,  0xC008,  0x10008,
	0x14008, 0x18008, 0x1C008, 0x20008, 0x24008, 0x28008, 0x2C008, 0x10,
	0x4010,	 0x8010,  0xC010,  0x10010, 0x14010, 0x18010, 0x1C010, 0x20010,
	0x24010, 0x28010, 0x2C010, 0x18,    0x4018,  0x8018,  0xC018,  0x10018,
	0x14018, 0x18018, 0x1C018, 0x20018, 0x24018, 0x28018, 0x2C018, 0x20,
	0x4020,	 0x8020,  0xC020,  0x10020, 0x14020, 0x18020, 0x1C020, 0x20020,
	0x24020, 0x28020, 0x2C020, 0xC, 0x10, 0x0
};

static U32 mmio_pmu1_offset_3[] = {
	0x5c,   0x28,   0x20,   0x18,   0x10,   0x8,    0x50,   0x4c,   0x48,
	0x44,   0x40,   0x405c, 0x4000, 0x4028, 0x4020, 0x4018, 0x4010, 0x4008,
	0x4050, 0x404c, 0x4048, 0x4044, 0x4040, 0x0
};

static U32 mmio_pmu1_offset_4[] = {
	0x1C8, 0x1D0, 0x1D4, 0x1D8, 0x1DC, 0x1E0, 0x1E8, 0x1F0, 0x1F8, 0x200, 0x208, 0x158, 0x1A0, 0x140, 0x0
};

static U32 mmio_pmu_common_offset_0[] = {
	0x700,   0x0
};

static U32 mmio_pmu6_offset[] = {
	0x4000,  0x9000,  0xD000,  0x12000, 0x16000, 0x1B000, 0x1F000, 0x24000,
	0x28000, 0x2D000, 0x31000, 0x36000, 0x3A000, 0x3F000, 0x43000, 0x48000,
	0x4C000, 0x51000, 0x55000, 0x5A000, 0x5E000, 0x63000, 0x67000, 0x6C000,
	0x70000, 0x75000, 0x79000, 0x7E000, 0x82000, 0x87000, 0x8B000, 0x40,
	0x4040,  0x9040,  0xD040,  0x12040, 0x16040, 0x1B040, 0x1F040, 0x24040,
	0x28040, 0x2D040, 0x31040, 0x36040, 0x3A040, 0x3F040, 0x43040, 0x48040,
	0x4C040, 0x51040, 0x55040, 0x5A040, 0x5E040, 0x63040, 0x67040, 0x6C040,
	0x70040, 0x75040, 0x79040, 0x7E040, 0x82040, 0x87040, 0x8B040, 0x44,
	0x4044,  0x9044,  0xD044,  0x12044, 0x16044, 0x1B044, 0x1F044, 0x24044,
	0x28044, 0x2D044, 0x31044, 0x36044, 0x3A044, 0x3F044, 0x43044, 0x48044,
	0x4C044, 0x51044, 0x55044, 0x5A044, 0x5E044, 0x63044, 0x67044, 0x6C044,
	0x70044, 0x75044, 0x79044, 0x7E044, 0x82044, 0x87044, 0x8B044, 0x48,
	0x4048,  0x9048,  0xD048,  0x12048, 0x16048, 0x1B048, 0x1F048, 0x24048,
	0x28048, 0x2D048, 0x31048, 0x36048, 0x3A048, 0x3F048, 0x43048, 0x48048,
	0x4C048, 0x51048, 0x55048, 0x5A048, 0x5E048, 0x63048, 0x67048, 0x6C048,
	0x70048, 0x75048, 0x79048, 0x7E048, 0x82048, 0x87048, 0x8B048, 0x4C,
	0x404C,  0x904C,  0xD04C,  0x1204C, 0x1604C, 0x1B04C, 0x1F04C, 0x2404C,
	0x2804C, 0x2D04C, 0x3104C, 0x3604C, 0x3A04C, 0x3F04C, 0x4304C, 0x4804C,
	0x4C04C, 0x5104C, 0x5504C, 0x5A04C, 0x5E04C, 0x6304C, 0x6704C, 0x6C04C,
	0x7004C, 0x7504C, 0x7904C, 0x7E04C, 0x8204C, 0x8704C, 0x8B04C, 0x8,
	0x4008,  0x9008,  0xD008,  0x12008, 0x16008, 0x1B008, 0x1F008, 0x24008,
	0x28008, 0x2D008, 0x31008, 0x36008, 0x3A008, 0x3F008, 0x43008, 0x48008,
	0x4C008, 0x51008, 0x55008, 0x5A008, 0x5E008, 0x63008, 0x67008, 0x6C008,
	0x70008, 0x75008, 0x79008, 0x7E008, 0x82008, 0x87008, 0x8B008, 0x10,
	0x4010,  0x9010,  0xD010,  0x12010, 0x16010, 0x1B010, 0x1F010, 0x24010,
	0x28010, 0x2D010, 0x31010, 0x36010, 0x3A010, 0x3F010, 0x43010, 0x48010,
	0x4C010, 0x51010, 0x55010, 0x5A010, 0x5E010, 0x63010, 0x67010, 0x6C010,
	0x70010, 0x75010, 0x79010, 0x7E010, 0x82010, 0x87010, 0x8B010, 0x18,
	0x4018,  0x9018,  0xD018,  0x12018, 0x16018, 0x1B018, 0x1F018, 0x24018,
	0x28018, 0x2D018, 0x31018, 0x36018, 0x3A018, 0x3F018, 0x43018, 0x48018,
	0x4C018, 0x51018, 0x55018, 0x5A018, 0x5E018, 0x63018, 0x67018, 0x6C018,
	0x70018, 0x75018, 0x79018, 0x7E018, 0x82018, 0x87018, 0x8B018, 0x20,
	0x4020,  0x9020,  0xD020,  0x12020, 0x16020, 0x1B020, 0x1F020, 0x24020,
	0x28020, 0x2D020, 0x31020, 0x36020, 0x3A020, 0x3F020, 0x43020, 0x48020,
	0x4C020, 0x51020, 0x55020, 0x5A020, 0x5E020, 0x63020, 0x67020, 0x6C020,
	0x70020, 0x75020, 0x79020, 0x7E020, 0x82020, 0x87020, 0x8B020, 0x0
};

static U32 mmio_tgl_pmu1_offset[] = {
	0x5040,  0x5058,  0x50A0,  0x50A8,  0x50B0,  0x40D8,  0x40E0,
	0x40E8,  0x40F0,  0x44D8,  0x44E0,  0x44E8,  0x44F0,  0x4300,
	0x4308,  0x4310,  0x4318,  0x4700,  0x4708,  0x4710,  0x4718,
	0x15040, 0x15058, 0x150A0, 0x150A8, 0x150B0, 0x140D8, 0x140E0,
	0x140E8, 0x140F0, 0x144D8, 0x144E0, 0x144E8, 0x144F0, 0x14300,
	0x14308, 0x14310, 0x14700, 0x14708, 0x14710, 0x14718, 0x0
};

static U32 mmio_tgl_h_pmu1_offset[] = {
	0xD840,  0xD858,  0xD8A0,  0xD8A8,  0xD8B0,  0xE0D8,  0xE0E0,  0xE0E8,
	0xE0F0,  0xE8D8,  0xE8E0,  0xE8E8,  0xE8F0,  0xE500,  0xE508,  0xE510,
	0xE518,  0xED00,  0xED08,  0xED10,  0xED18,  0x1D840, 0x1D858, 0x1D8A0,
	0x1D8A8, 0x1D8B0, 0x1E0D8, 0x1E0E0, 0x1E0E8, 0x1E0F0, 0x1E8D8, 0x1E8E0,
	0x1E8E8, 0x1E8F0, 0x1E500, 0x1E508, 0x1E510, 0x1E518, 0x1ED00, 0x1ED08,
	0x1ED10, 0x1ED18, 0x0
};

static U32 mmio_plat5_pmu1_offset[] = {
	0x1C0,  0x1C4,   0x101C0, 0x101C4, 0x1D0,   0x1D4,   0x1D8,   0x1DC,
	0x1E0,  0x101D0, 0x101D4, 0x101D8, 0x101DC, 0x101E0, 0xD9E8,  0xD9F0,
	0xD9F8, 0xDA00,  0xDA08,  0x1D9E8, 0x1D9F0, 0x1D9F8, 0x1DA00, 0x1DA08,
	0xD840, 0xD858,  0xD8A0,  0x1D840, 0x1D858, 0x1D8A0, 0
};

static U32 mmio_plat6_offset_0[] = {
	0x41b210, 0x39b210, 0x28b210, 0x293210, 0x317a08, 0x29b210, 0x40b210, 0x413210, 0x38b210, 0x393210,
	0x30b210, 0x313210, 0x41b218, 0x39b218, 0x28b218, 0x293218, 0x31b218, 0x29b218, 0x40b218, 0x413218,
	0x38b218, 0x393218, 0x30b218, 0x313218, 0x41b200, 0x39b200, 0x28b200, 0x293200, 0x31b200, 0x29b200,
	0x40b200, 0x413200, 0x38b200, 0x393200, 0x30b200, 0x313200, 0
};


static U32 mmio_pmu7_offset[] = {
	0x80,   0xC0,   0x140,  0x180,  0x1C0,  0x200,  0x240,  0x280,  0x2C0,
	0x300,  0x340,  0x380,  0x3C0,  0x1000, 0x1080, 0x10C0, 0x1140, 0x1180,
	0x11C0, 0x1200, 0x1240, 0x1280, 0x12C0, 0x1300, 0x1340, 0x1380, 0x13C0,
	0x2000, 0x2080, 0x20C0, 0x2140, 0x2180, 0x21C0, 0x2200, 0x2240, 0x2280,
	0x22C0, 0x2300, 0x2340, 0x2380, 0x23C0, 0x3000, 0x3080, 0x30C0, 0x3140,
	0x3180, 0x31C0, 0x3200, 0x3240, 0x3280, 0x32C0, 0x3300, 0x3340, 0x3380,
	0x33C0, 0x4000, 0x4080, 0x40C0, 0x4140, 0x4180, 0x41C0, 0x4200, 0x4240,
	0x4280, 0x42C0, 0x4300, 0x4340, 0x4380, 0x43C0, 0x5000, 0x5080, 0x50C0,
	0x5140, 0x5180, 0x51C0, 0x5200, 0x5240, 0x5280, 0x52C0, 0x5300, 0x5340,
	0x5380, 0x53C0, 0x6000, 0x6080, 0x60C0, 0x6140, 0x6180, 0x61C0, 0x6200,
	0x6240, 0x6280, 0x62C0, 0x6300, 0x6340, 0x6380, 0x63C0, 0x7000, 0x7080,
	0x70C0, 0x7140, 0x7180, 0x71C0, 0x7200, 0x7240, 0x7280, 0x72C0, 0x7300,
	0x7340, 0x7380, 0x73C0, 0x0
};

static U32 mmio_pmu8_offset[] = {
	0x80,   0xC0,   0x100,  0x140,  0x180,  0x1C0,  0x200,  0x240,  0x280,
	0x1000, 0x1080, 0x10C0, 0x1100, 0x1140, 0x1180, 0x11C0, 0x1200, 0x1240,
	0x1280, 0x2000, 0x2080, 0x20C0, 0x2100, 0x2140, 0x2180, 0x21C0, 0x2200,
	0x2240, 0x2280, 0x3000, 0x3080, 0x30C0, 0x3100, 0x3140, 0x3180, 0x31C0,
	0x3200, 0x3240, 0x3280, 0x4000, 0x4080, 0x40C0, 0x4100, 0x4140, 0x4180,
	0x41C0, 0x4200, 0x4240, 0x4280, 0x5000, 0x5080, 0x50C0, 0x5100, 0x5140,
	0x5180, 0x51C0, 0x5200, 0x5240, 0x5280, 0x6000, 0x6080, 0x60C0, 0x6100,
	0x6140, 0x6180, 0x61C0, 0x6200, 0x6240, 0x6280, 0x7000, 0x7080, 0x70C0,
	0x7100, 0x7140, 0x7180, 0x71C0, 0x7200, 0x7240, 0x7280, 0x0
};

static U32 mmio_pmu10_offset[] = {
	0x9048,  0x9000,  0x9020,  0x9018,  0x9010,  0x9008,  0x9040,  0x9038,  0x9030,  0x9028,
	0x16048, 0x16000, 0x16020, 0x16018, 0x16010, 0x16008, 0x16040, 0x16038, 0x16030, 0x16028,
	0xA048,  0xA000,  0xA020,  0xA018,  0xA010,  0xA008,  0xA040,  0xA038,  0xA030,  0xA028,
	0x48,    0x20,    0x18,    0x10,    0x8,     0x40,    0x38,    0x30,    0x28,    0x1048,
	0x1000,  0x1020,  0x1018,  0x1010,  0x1008,  0x1040,  0x1038,  0x1030,  0x1028,  0xB048,
	0xB000,  0xB020,  0xB018,  0xB010,  0xB008,  0xB040,  0xB038,  0xB030,  0xB028,  0x17048,
	0x17000, 0x17020, 0x17018, 0x17010, 0x17008, 0x17040, 0x17038, 0x17030, 0x17028, 0xC048,
	0xC000,  0xC020,  0xC018,  0xC010,  0xC008,  0xC040,  0xC038,  0xC030,  0xC028,  0x10048,
	0x10000, 0x10020, 0x10018, 0x10010, 0x10008, 0x10040, 0x10038, 0x10030, 0x10028, 0x19048,
	0x19000, 0x19020, 0x19018, 0x19010, 0x19008, 0x19040, 0x19038, 0x19030, 0x19028, 0xF048,
	0xF000,  0xF020,  0xF018,  0xF010,  0xF008,  0xF040,  0xF038,  0xF030,  0xF028,  0x3048,
	0x3000,  0x3020,  0x3018,  0x3010,  0x3008,  0x3040,  0x3038,  0x3030,  0x3028,  0x2048,
	0x2000,  0x2020,  0x2018,  0x2010,  0x2008,  0x2040,  0x2038,  0x2030,  0x2028,  0xE048,
	0xE000,  0xE020,  0xE018,  0xE010,  0xE008,  0xE040,  0xE038,  0xE030,  0xE028,  0x18048,
	0x18000, 0x18020, 0x18018, 0x18010, 0x18008, 0x18040, 0x18038, 0x18030, 0x18028, 0xD048,
	0xD000,  0xD020,  0xD018,  0xD010,  0xD008,  0xD040,  0xD038,  0xD030,  0xD028,  0x0
};

static U32 mmio_pmu10_offset_1[] = {
	0x2048, 0x2000, 0x2020, 0x2018, 0x2010, 0x2008, 0x2040, 0x2038, 0x2030, 0x2028, 0x1048,
	0x1000, 0x1020, 0x1018, 0x1010, 0x1008, 0x1040, 0x1038, 0x1030, 0x1028, 0x48,   0x20,
	0x18,   0x10,   0x8,    0x40,   0x38,   0x30,   0x28,   0x0
};

static U32 mmio_pmu10_offset_3[] = {
	0x20, 0x18, 0x10, 0x8, 0x40, 0x38, 0x30, 0x28,
	0xA000, 0xA020, 0xA018, 0xA010, 0xA008, 0xA040, 0xA038, 0xA030, 0xA028,
	0xB000, 0xB020, 0xB018, 0xB010, 0xB008, 0xB040, 0xB038, 0xB030, 0xB028,
	0x4000, 0x4020, 0x4018, 0x4010, 0x4008, 0x4040, 0x4038, 0x4030, 0x4028,
	0x5000, 0x5020, 0x5018, 0x5010, 0x5008, 0x5040, 0x5038, 0x5030, 0x5028,
	0x2000, 0x2020, 0x2018, 0x2010, 0x2008, 0x2040, 0x2038, 0x2030, 0x2028,
	0x6000, 0x6020, 0x6018, 0x6010, 0x6008, 0x6040, 0x6038, 0x6030, 0x6028,
	0x9000, 0x9020, 0x9018, 0x9010, 0x9008, 0x9040, 0x9038, 0x9030, 0x9028,
	0x3000, 0x3020, 0x3018, 0x3010, 0x3008, 0x3040, 0x3038, 0x3030, 0x3028,
	0x8000, 0x8020, 0x8018, 0x8010, 0x8008, 0x8040, 0x8038, 0x8030, 0x8028,
	0x7000, 0x7020, 0x7018, 0x7010, 0x7008, 0x7040, 0x7038, 0x7030, 0x7028,
	0xD000, 0xD020, 0xD018, 0xD010, 0xD008, 0xD040, 0xD038, 0xD030, 0xD028,
	0xC000, 0xC020, 0xC018, 0xC010, 0xC008, 0xC040, 0xC038, 0xC030, 0xC028,
	0x1000, 0x1020, 0x1018, 0x1010, 0x1008, 0x1040, 0x1038, 0x1030, 0x1028,
	0x0
};

static PMU_MMIO_UNIT_INFO_NODE client_common_mmio_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000ULL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0                },
	  mmio_client_pmu1_common_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFFF000ULL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0                },
	  mmio_pmu2_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  mmio_pmu4_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE skx_mmio_list[] = {
	{
	  { { { 0, 0, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x3FFFFFFF8000ULL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_pmu3_common_offset
	},
	{
	  { { { 0, 0, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x3ffffffff0000ULL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0                },
	  mmio_pmu5_common_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE server_common_mmio_list[] = {
	{
	  { { { 0, 0, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x3ffffffff0000ULL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0                },
	  mmio_pmu5_common_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE bxt_dvt_mmio_info_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_bxt_dvt_pmu1_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFFF000 },
	  { { { 0, 0, 0, 0x0  } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0             },
	  mmio_pmu2_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  { { { 0, 0, 0, 0x0  } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  mmio_pmu4_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE icx_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD8 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xDC } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xE0 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xE4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE snr_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD8 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xDC } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 0, 0x0 } }, 0, MMIO_DUAL_BAR_TYPE, 0, 0x0 },
	  { { { 0, 0, 0, 0x0 } }, 0, MMIO_DUAL_BAR_TYPE, 0, 0x0 },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat6_mmio_info_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_plat5_pmu1_offset
	},
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL},
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x3FFFF0000000LL},
	  mmio_plat6_offset_0
	},
	{
		{{{0, 0, 0, 0}}, 0, 0, 0, 0x0},
		{{{0, 0, 0, 0}}, 0, 0, 0, 0x0},
		NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE tgl_mmio_info_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_tgl_pmu1_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFFF000 },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0             },
	  mmio_pmu2_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  mmio_pmu4_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE tgl_h_mmio_info_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_tgl_h_pmu1_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFFF000 },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0             },
	  mmio_pmu2_offset
	},
	{
	  { { { 0, 2, 0, 0x10 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0 },
	  mmio_pmu4_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat3_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu6_offset_1
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset_2
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu10_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat4_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu6_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD8 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xDC } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xE0 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xE4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset
	},
	{
	  { { { 0, 29, 1, 0x298 } }, 26, MMIO_SINGLE_BAR_TYPE, 0, 0x3FFFFFFULL },
	  { { { 0, 0, 0, 0      } }, 0,  MMIO_SINGLE_BAR_TYPE, 0, 0x0          },
	  mmio_pmu7_offset
	},
	{
	  { { { 0, 29, 1, 0x298 } }, 26, MMIO_DUAL_BAR_TYPE, 0, 0x3FFFFFFULL },
	  { { { 0, 29, 1, 0x600 } }, 0,  MMIO_DUAL_BAR_TYPE, 0, 0x0          },
	  mmio_pmu8_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat5_mmio_info_list[] = {
	{
	  { { { 0, 0, 0, 0x48 } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0007FFFFF8000LL },
	  { { { 0, 0, 0, 0    } }, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0               },
	  mmio_plat5_pmu1_offset
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat7_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset_3
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu10_offset_1
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat9_mmio_info_list[] = {
	{
	  {{{0, 0, 0, 0x48}}, 0, MMIO_SINGLE_BAR_TYPE, 0,	0x0007FFFFF8000LL},
	  {{{0, 0, 0, 0}}, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0},
	  mmio_pmu1_offset_4
	},
	{
	  {{{0, 0, 0, 0x68}}, 0, MMIO_SINGLE_BAR_TYPE, 0, 0xff000000ULL},
	  {{{0, 0, 0, 0}}, 0, MMIO_SINGLE_BAR_TYPE, 0, 0x0},
	  mmio_pmu_common_offset_0
	},
	{
	  {{{0, 0, 0, 0}}, 0, 0, 0, 0x0},
	  {{{0, 0, 0, 0}}, 0, 0, 0, 0x0},
	  NULL
	}
};

static PMU_MMIO_UNIT_INFO_NODE plat10_mmio_info_list[] = {
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu1_offset_2
	},
	{
	  { { { 0, 0, 1, 0xD0 } }, 23, MMIO_DUAL_BAR_TYPE, 0, 0x1FFFFFFFULL },
	  { { { 0, 0, 1, 0xD4 } }, 12, MMIO_DUAL_BAR_TYPE, 0, 0x7FFULL      },
	  mmio_pmu10_offset_3
	},
	{
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  { { { 0, 0, 0, 0 } }, 0, 0, 0, 0x0 },
	  NULL
	}
};

#endif

