/*******************************************************************************
* Copyright 2016 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

#if !defined( __IPP_RESIZE_IW__ )
#define __IPP_RESIZE_IW__

#include "ipp/iw/iw.h"
#include "base_proc.h"

class ResizeIW: public ResizeBase
{
public:
    ResizeIW(ParallelInterface parallel = PARALLEL_NONE)
    {
        m_pResizeSpec = NULL;
        m_className   = "ResizeIW";
        SetParallelInterface(parallel);
    }

    ~ResizeIW()
    {
        if(m_pResizeSpec)
        {
            iwiResize_Free(m_pResizeSpec);
            m_pResizeSpec = NULL;
        }
    }

    Status Init(Image &src, Image &dst, IppiInterpolationType interpolation)
    {
        IppStatus ippStatus;

        IwiSize     srcSize  = ImageSizeToIpp(src.m_size);
        IwiSize     dstSize  = ImageSizeToIpp(dst.m_size);
        IppDataType dataType = ImageFormatToIpp(src.m_sampleFormat);

        ippStatus = iwiResize_InitAlloc(&m_pResizeSpec, srcSize, dstSize, dataType, src.m_samples, interpolation, NULL, ippBorderRepl);
        CHECK_STATUS_PRINT_AC(ippStatus, "iwiResizeInitAlloc()", iwGetStatusString(ippStatus), return STS_ERR_FAILED);

        return STS_OK;
    }

    Status Run(Image &src, Image &dst, Rect roi)
    {
        IppStatus ippStatus;

        IwiImage iwSrc = ImageToIwImage(src);
        IwiImage iwDst = ImageToIwImage(dst);

        IwiTile iwRoi = iwiTile_SetRoi(ImageRectToIpp(roi));
        ippStatus = iwiResize_Process(m_pResizeSpec, &iwSrc, &iwDst, ippBorderRepl, NULL, &iwRoi);
        CHECK_STATUS_PRINT_AC(ippStatus, "iwiResize()", iwGetStatusString(ippStatus), return STS_ERR_FAILED);

        return STS_OK;
    }

protected:
    IwiResizeSpec *m_pResizeSpec;
};

#endif
