/*******************************************************************************
* Copyright 2016 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

#ifndef OWNDEFSL_H__
#define OWNDEFSL_H__

/* Define NULL pointer value */
#ifndef NULL
#ifdef  __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

#include "ippdefs_l.h"
#ifdef __cplusplus
extern "C" {
#endif

int IPP_CDECL ownGetNumThreads_LT( void );

#define IPP_GET_NUM_THREADS() ( ownGetNumThreads_LT() )
#define IPP_NUM_THREADS() num_threads( IPP_GET_NUM_THREADS() )
#define IPP_LIMIT_MAX_NUM_THREADS(n)  num_threads( IPP_MIN(IPP_GET_NUM_THREADS(),(n)))
#define IPP_ALIGN_TYPE(type, align) ((align)/sizeof(type)-1)
#define IPP_BYTES_TO_ALIGN(ptr, align) ((-(IPP_INT_PTR(ptr)&((align)-1)))&((align)-1))
#define IPP_ALIGNED_PTR(ptr, align) (void*)( (unsigned char*)(ptr) + (IPP_BYTES_TO_ALIGN( ptr, align )) )

#define IPP_ALIGNED_SIZE(size, align) (((size)+(align)-1)&~((align)-1))

#define IPP_MAX( a, b ) ( ((a) > (b)) ? (a) : (b) )
#define IPP_MIN( a, b ) ( ((a) < (b)) ? (a) : (b) )

#define IPP_ABS( a ) ( ((a) < 0) ? (-(a)) : (a) )

#define   IPPFUN(type,name,arg)                extern type IPP_STDCALL name arg

#define IPP_MALLOC_ALIGNED_BYTES 64
#if defined(__INTEL_COMPILER) || defined(_MSC_VER)
#define IPP_INLINE static __inline
#elif defined( __GNUC__ )
#define IPP_INLINE static __inline__
#else
#define IPP_INLINE static
#endif

#define UNREFERENCED_PARAMETER(p) (p)=(p)

IPP_INLINE
IppSizeL IPP_INT_PTR(const void* ptr)  {
    union {
        void*   Ptr;
        IppSizeL  Int;
    } dd;
    dd.Ptr = (void*)ptr;
    return dd.Int;
}

IPP_INLINE
IppSizeL IPP_UINT_PTR(const void* ptr)  {
    union {
        void*    Ptr;
        IppSizeL   Int;
    } dd;
    dd.Ptr = (void*)ptr;
    return dd.Int;
}
#ifdef __cplusplus
}
#endif
#endif /* OWNDEFSL_H__ */

