<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                xmlns:fnc="urn:functions"
                syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
    <variables>
      <isSupportedPMU>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'haswell'
              or exsl:ctx('PMU') = 'haswell_server'
              or exsl:ctx('PMU') = 'silvermont'
              or exsl:ctx('PMU') = 'airmont'
              or exsl:ctx('PMU') = 'crystalwell'
              or exsl:ctx('PMU') = 'airmont'
              or exsl:ctx('PMU') = 'broadwell'
              or exsl:ctx('PMU') = 'skylake'
              or exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'
              or exsl:ctx('PMU') = 'broadwell_de'
              or exsl:ctx('PMU') = 'broadwell_server'
              or exsl:ctx('PMU') = 'knl'
              or exsl:ctx('PMU') = 'goldmont'
              or exsl:ctx('PMU') = 'goldmont_plus'
              or exsl:ctx('PMU') = 'icelake'
              or exsl:ctx('PMU') = 'snowridge'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'elkhartlake'
              or exsl:ctx('PMU') = 'tigerlake'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'alderlake_goldencove'
              or exsl:ctx('PMU') = 'alderlake_gracemont'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              or exsl:ctx('PMU') = 'graniterapids_server'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isSupportedPMU>
      <is4thGenPcoreXeonOrLater>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </is4thGenPcoreXeonOrLater>
      <is12thGenClientOrLater>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'alderlake_goldencove'
              or exsl:ctx('PMU') = 'alderlake_gracemont'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </is12thGenClientOrLater>
      <isPcorePMU>
        <xsl:choose>
          <xsl:when test="(
            exsl:ctx('PMU') = 'haswell'
            or exsl:ctx('PMU') = 'haswell_server'
            or exsl:ctx('PMU') = 'crystalwell'
            or exsl:ctx('PMU') = 'broadwell'
            or exsl:ctx('PMU') = 'skylake'
            or exsl:ctx('PMU') = 'skylake_server'
            or exsl:ctx('PMU') = 'cascadelake_server'
            or exsl:ctx('PMU') = 'broadwell_de'
            or exsl:ctx('PMU') = 'broadwell_server'
            or exsl:ctx('PMU') = 'knl'
            or exsl:ctx('PMU') = 'icelake'
            or exsl:ctx('PMU') = 'icelake_server'
            or exsl:ctx('PMU') = 'tigerlake'
            or exsl:ctx('PMU') = 'sapphirerapids_server'
            or exsl:ctx('PMU') = 'emeraldrapids_server'
            or exsl:ctx('PMU') = 'graniterapids_server'
            )">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPcorePMU>
      <NoSMTOnPcore>
        <xsl:choose>
          <xsl:when test="(
            exsl:ctx('PMU') = 'lunarlake'
            or exsl:ctx('PMU') = 'arrowlake'
            )">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </NoSMTOnPcore>
      <isEcorePMU>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'silvermont'
              or exsl:ctx('PMU') = 'airmont'
              or exsl:ctx('PMU') = 'goldmont'
              or exsl:ctx('PMU') = 'goldmont_plus'
              or exsl:ctx('PMU') = 'snowridge'
              or exsl:ctx('PMU') = 'elkhartlake'
              or exsl:ctx('PMU') = 'alderlake_gracemont'
              or exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isEcorePMU>
      <isEcoreServerPMU>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'snowridge'
              or exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isEcoreServerPMU>
      <isHybridPMU>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isHybridPMU>
      <isTimedPEBSCollectionAvailable>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isTimedPEBSCollectionAvailable>
      <isEcoreFlopsAvailable>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isEcoreFlopsAvailable>
      <isPcoreFlopsAvailable>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'broadwell'
              or exsl:ctx('PMU') = 'broadwell_de'
              or exsl:ctx('PMU') = 'broadwell_server'
              or exsl:ctx('PMU') = 'skylake'
              or exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'
              or exsl:ctx('PMU') = 'icelake'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'tigerlake'
              or exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'alderlake_goldencove'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPcoreFlopsAvailable>
      <isAVX512Supported>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'
              or exsl:ctx('PMU') = 'icelake'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'tigerlake'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isAVX512Supported>
      <isAMXSupported>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isAMXSupported>
      <isPerfmetricsSupported>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'icelake'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'tigerlake'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'alderlake_goldencove'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPerfmetricsSupported>
      <isTMAUnsupported>
        <xsl:text>false</xsl:text>
      </isTMAUnsupported>
      <isFixedTopdownUnsupported>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('Hypervisor', 'None') = 'Microsoft Hv'
              and exsl:ctx('HypervisorType', 'None') = 'Hyper-V'
              and (exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              ))">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isFixedTopdownUnsupported>
      <isNewEcoreTMAMetric>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('tmamVersion', '0') = '4_801'
              and (exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              ))">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isNewEcoreTMAMetric>
      <isPCIeBWSupported>
        <xsl:choose>
          <xsl:when test="(
              exsl:ctx('PMU') = 'haswell_server'
              or exsl:ctx('PMU') = 'broadwell_server'
              or exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'
              or exsl:ctx('PMU') = 'snowridge'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              or exsl:ctx('PMU') = 'graniterapids_server'
              )">
              <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isPCIeBWSupported>
      <isLbrStackAvailable>
        <xsl:choose>
          <xsl:when test="(
              not(contains(exsl:ctx('Hypervisor', 'None'),'KVM')
              or contains(exsl:ctx('Hypervisor', 'None'),'VMware'))
              and (exsl:ctx('PMU') = 'haswell'
              or exsl:ctx('PMU') = 'haswell_server'
              or exsl:ctx('PMU') = 'crystalwell'
              or exsl:ctx('PMU') = 'broadwell'
              or exsl:ctx('PMU') = 'skylake'
              or exsl:ctx('PMU') = 'skylake_server'
              or exsl:ctx('PMU') = 'cascadelake_server'
              or exsl:ctx('PMU') = 'broadwell_de'
              or exsl:ctx('PMU') = 'broadwell_server'
              or exsl:ctx('PMU') = 'goldmont'
              or exsl:ctx('PMU') = 'goldmont_plus'
              or exsl:ctx('PMU') = 'icelake'
              or exsl:ctx('PMU') = 'snowridge'
              or exsl:ctx('PMU') = 'icelake_server'
              or exsl:ctx('PMU') = 'elkhartlake'
              or exsl:ctx('PMU') = 'tigerlake'
              or exsl:ctx('PMU') = 'sapphirerapids_server'
              or exsl:ctx('PMU') = 'alderlake'
              or exsl:ctx('PMU') = 'alderlake_goldencove'
              or exsl:ctx('PMU') = 'alderlake_gracemont'
              or exsl:ctx('PMU') = 'meteorlake'
              or exsl:ctx('PMU') = 'emeraldrapids_server'
              or exsl:ctx('PMU') = 'grandridge'
              or exsl:ctx('PMU') = 'sierraforest_server'
              or exsl:ctx('PMU') = 'lunarlake'
              or exsl:ctx('PMU') = 'arrowlake'
              or exsl:ctx('PMU') = 'graniterapids_server'
              ))">
            <xsl:text>true</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </isLbrStackAvailable>
    </variables>
  </xsl:template>
</xsl:stylesheet>
