<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common">
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
    <html id="gpuDiagramPane" displayName="%gpuDiagramPane">
      <description>%gpuDiagramPaneDescription</description>
      <helpKeywordF1>configs.caller_f1048</helpKeywordF1>
      <icon file="client.dat#zip:images.xrc" image="tab_timeline"/>
      <additionalParams boolean:showInDiff="false"/>
      <application name="diagram"/>
      <filter handleList="selection"/>
      <config>
        <graphIds>
          <rowBy>
            <queryRef>/GPUPCIID</queryRef>
          </rowBy>
          <columnBy>
            <queryRef>/GPUEventCount</queryRef>
            <queryRef>/GPUDataCount</queryRef>
          </columnBy>
          <selectionColumnBy>
            <queryRef>/GPUEventCount</queryRef>
            <queryRef>/GPUDMAPacketCountNode</queryRef>
            <xsl:choose>
              <xsl:when test="exsl:is_experimental('gpu-data-transfer') and exsl:is_non_empty_table_exist('gpu_host_compute_transfer_data')">
                <queryRef>/GPUHostComputeTransferCount</queryRef>
            </xsl:when>
              <xsl:otherwise>
                <queryRef>/GPUComputeTaskCount</queryRef>
              </xsl:otherwise>
            </xsl:choose>
                <queryRef>/DrawCallCount</queryRef>
          </selectionColumnBy>
        </graphIds>
        <xsl:variable name="diagramBlocksFileNameBMG">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameBMG)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x3x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=3&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x3x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x4x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=4&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x4x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x1x18x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=1&amp;dssCount=18&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x1x18x8)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x5x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=5&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x5x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x7x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=7&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x7x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameBMG1x8x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_bmg.xsl?tCount=1&amp;sCount=8&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameBMG1x8x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameLNL">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_lnl.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameLNL)"/>
        <xsl:variable name="diagramBlocksFileNameLNL1x2x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_lnl.xsl?tCount=1&amp;sCount=2&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
	<xsl:copy-of select="document($diagramBlocksFileNameLNL1x2x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameLNL1x1x4x8">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_lnl.xsl?tCount=1&amp;sCount=1&amp;dssCount=4&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameLNL1x1x4x8)"/>
        <xsl:variable name="diagramBlocksFileNameARL">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x1x2x16">
         <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=1&amp;dssCount=2&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x1x2x16)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x1x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=1&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x1x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x2x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=2&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x2x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x2x3x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=2&amp;dssCount=3&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x2x3x16)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x3x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=3&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x3x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameARL1x6x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_arl.xsl?tCount=1&amp;sCount=6&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameARL1x6x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameGen9">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen9)"/>
        <xsl:variable name="diagramBlocksFileNameGen91x2x6">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=1&amp;ssCount=2&amp;euCount=6&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen91x2x6)"/>
        <xsl:variable name="diagramBlocksFileNameGen91x3x6">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=1&amp;ssCount=3&amp;euCount=6&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen91x3x6)"/>
        <xsl:variable name="diagramBlocksFileNameGen91x3x6eDram">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=1&amp;ssCount=3&amp;euCount=6&amp;mod=EDRAM&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen91x3x6eDram)"/>
        <xsl:variable name="diagramBlocksFileNameGen91x3x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=1&amp;ssCount=3&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen91x3x8)"/>
        <xsl:variable name="diagramBlocksFileNameGen92x3x8eDram">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=2&amp;ssCount=3&amp;euCount=8&amp;mod=EDRAM</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen92x3x8eDram)"/>
        <xsl:variable name="diagramBlocksFileNameGen93x3x8eDram">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_gen9.xsl?sCount=3&amp;ssCount=3&amp;euCount=8&amp;mod=EDRAM</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGen93x3x8eDram)"/>
        <xsl:variable name="diagramBlocksFileNameTGLLP">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_tgllp.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameTGLLP)"/>
        <xsl:variable name="diagramBlocksFileNameTGLLPSS1">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_tgllp.xsl?mod=SS1&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameTGLLPSS1)"/>
        <xsl:variable name="diagramBlocksFileNameTGLLPSS2">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_tgllp.xsl?mod=SS2&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameTGLLPSS2)"/>
        <xsl:variable name="diagramBlocksFileNameTGLLPSS3">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_tgllp.xsl?mod=SS3&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameTGLLPSS3)"/>
        <xsl:variable name="diagramBlocksFileNameTGLLPSS6">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_tgllp.xsl?mod=SS6&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameTGLLPSS6)"/>
        <xsl:variable name="diagramBlocksFileNamDG1">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg1.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamDG1)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x2x8x128">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=2&amp;dssCount=8&amp;euCount=128&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x2x8x128)"/>
        <xsl:variable name="diagramBlocksFileNameATS2x4x16x256">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=2&amp;sCount=4&amp;dssCount=16&amp;euCount=256&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS2x4x16x256)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x4x16x256">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=4&amp;dssCount=16&amp;euCount=256&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x4x16x256)"/>
        <xsl:variable name="diagramBlocksFileNameATS2x8x32x512">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=2&amp;sCount=8&amp;dssCount=32&amp;euCount=512&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS2x8x32x512)"/>
        <xsl:variable name="diagramBlocksFileNameATS4x16x64x1024">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=4&amp;sCount=16&amp;dssCount=64&amp;euCount=1024&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS4x16x64x1024)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x5x20x320">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=5&amp;dssCount=20&amp;euCount=320&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x5x20x320)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x6x24x384">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=6&amp;dssCount=24&amp;euCount=384&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x6x24x384)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x7x28x448">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=7&amp;dssCount=28&amp;euCount=448&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x7x28x448)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x8x30x480">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=8&amp;dssCount=30&amp;euCount=480&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x8x30x480)"/>
        <xsl:variable name="diagramBlocksFileNameATS2x16x60x960">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=2&amp;sCount=16&amp;dssCount=60&amp;euCount=960&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS2x16x60x960)"/>
        <xsl:variable name="diagramBlocksFileNameATS4x32x120x1920">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=4&amp;sCount=32&amp;dssCount=120&amp;euCount=1920&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS4x32x120x1920)"/>
        <xsl:variable name="diagramBlocksFileNameATS1x8x32x512">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=1&amp;sCount=8&amp;dssCount=32&amp;euCount=512&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS1x8x32x512)"/>
        <xsl:variable name="diagramBlocksFileNameATS4x32x128x2048">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=4&amp;sCount=32&amp;dssCount=128&amp;euCount=2048&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS4x32x128x2048)"/>
        <xsl:variable name="diagramBlocksFileNameATS2x12x48x768">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=2&amp;sCount=12&amp;dssCount=48&amp;euCount=768&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS2x12x48x768)"/>
        <xsl:variable name="diagramBlocksFileNameATS4x24x96x1536">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=4&amp;sCount=24&amp;dssCount=96&amp;euCount=1536&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS4x24x96x1536)"/>
        <xsl:variable name="diagramBlocksFileNameATS2x16x64x1024">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_ats.xsl?tCount=2&amp;sCount=16&amp;dssCount=64&amp;euCount=1024&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameATS2x16x64x1024)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x2x3x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=2&amp;dssCount=3&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x2x3x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x2x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=2&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x2x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x3x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=3&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x3x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x4x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=4&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x4x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x6x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=6&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x6x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x7x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=7&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x7x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x8x4x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=8&amp;dssCount=4&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x8x4x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x8x3x16">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=8&amp;dssCount=3&amp;euCount=16&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x8x3x16)"/>
        <xsl:variable name="diagramBlocksFileNameDG21x8x28x448t">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_dg2.xsl?tCount=1&amp;sCount=8&amp;dssCount=28&amp;euCount=448&amp;isTotal=1&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameDG21x8x28x448t)"/>
        <xsl:variable name="diagramBlocksFileNamePVC">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC)"/>
        <xsl:variable name="diagramBlocksFileNamePVC2x8x8x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?tCount=2&amp;sCount=8&amp;ssCount=8&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC2x8x8x8)"/>
        <xsl:variable name="diagramBlocksFileNamePVC2x8x7x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?tCount=2&amp;sCount=8&amp;ssCount=7&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC2x8x7x8)"/>
        <xsl:variable name="diagramBlocksFileNamePVC2x8x6x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?tCount=2&amp;sCount=8&amp;ssCount=6&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC2x8x6x8)"/>
        <xsl:variable name="diagramBlocksFileNamePVC1x8x8x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?tCount=1&amp;sCount=8&amp;ssCount=8&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC1x8x8x8)"/>
        <xsl:variable name="diagramBlocksFileNamePVC1x8x7x8">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?tCount=1&amp;sCount=8&amp;ssCount=7&amp;euCount=8&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNamePVC1x8x7x8)"/>
        <xsl:variable name="diagramBlocksFileNameGeneric">
          <xsl:text>config://viewpoint/include/gpu_gen_blocks/diagramblocks_pvc.xsl?arch=GENERIC&amp;</xsl:text>
        </xsl:variable>
        <xsl:copy-of select="document($diagramBlocksFileNameGeneric)"/>
      </config>
    </html>
  </xsl:template>
</xsl:stylesheet>
