/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.opensearch.script.GeneralScriptException;
import org.opensearch.script.ScoreScript;

class ExpressionScoreScript
implements ScoreScript.LeafFactory {
    private final Expression exprScript;
    private final DoubleValuesSource source;
    private final boolean needsScores;

    ExpressionScoreScript(Expression e, SimpleBindings b, boolean needsScores) {
        this.exprScript = e;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)b);
        this.needsScores = needsScores;
    }

    public boolean needs_score() {
        return this.needsScores;
    }

    public ScoreScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new ScoreScript(null, null, null, null){
            DoubleValues values;
            {
                super(arg0, arg1, arg2, arg3);
                this.values = ExpressionScoreScript.this.source.getValues(leaf, new DoubleValues(){

                    public double doubleValue() throws IOException {
                        return this.get_score();
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                });
            }

            public double execute(ScoreScript.ExplanationHolder explanation) {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + String.valueOf(ExpressionScoreScript.this.exprScript), (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + String.valueOf(ExpressionScoreScript.this.exprScript), e);
                }
            }
        };
    }
}

