/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SplitProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, SplitProcessor> {
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Boolean preserveTrailing;
    @Nonnull
    private final String separator;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<SplitProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SplitProcessor::setupSplitProcessorDeserializer);

    private SplitProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.preserveTrailing = builder.preserveTrailing;
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
        this.targetField = builder.targetField;
    }

    public static SplitProcessor of(Function<Builder, ObjectBuilder<SplitProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Split;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Boolean preserveTrailing() {
        return this.preserveTrailing;
    }

    @Nonnull
    public final String separator() {
        return this.separator;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.preserveTrailing != null) {
            generator.writeKey("preserve_trailing");
            generator.write(this.preserveTrailing.booleanValue());
        }
        generator.writeKey("separator");
        generator.write(this.separator);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSplitProcessorDeserializer(ObjectDeserializer<Builder> op) {
        SplitProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::preserveTrailing, JsonpDeserializer.booleanDeserializer(), "preserve_trailing");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.preserveTrailing);
        result = 31 * result + this.separator.hashCode();
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitProcessor other = (SplitProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.preserveTrailing, other.preserveTrailing) && this.separator.equals(other.separator) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SplitProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Boolean preserveTrailing;
        private String separator;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(SplitProcessor o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.preserveTrailing = o.preserveTrailing;
            this.separator = o.separator;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.preserveTrailing = o.preserveTrailing;
            this.separator = o.separator;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder preserveTrailing(@Nullable Boolean value) {
            this.preserveTrailing = value;
            return this;
        }

        @Nonnull
        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public SplitProcessor build() {
            this._checkSingleUse();
            return new SplitProcessor(this);
        }
    }
}

