/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class WildcardType
extends AstType {
    public static final TokenRole WILDCARD_TOKEN_ROLE = new TokenRole("?");
    public static final TokenRole EXTENDS_KEYWORD_ROLE = Roles.EXTENDS_KEYWORD;
    public static final TokenRole SUPER_KEYWORD_ROLE = new TokenRole("super", 1);

    public final JavaTokenNode getWildcardToken() {
        return this.getChildByRole(WILDCARD_TOKEN_ROLE);
    }

    public final AstNodeCollection<AstType> getExtendsBounds() {
        return this.getChildrenByRole(Roles.EXTENDS_BOUND);
    }

    public final AstNodeCollection<AstType> getSuperBounds() {
        return this.getChildrenByRole(Roles.SUPER_BOUND);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitWildcardType(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof WildcardType) {
            WildcardType otherWildcard = (WildcardType)other;
            return this.getExtendsBounds().matches(otherWildcard.getExtendsBounds(), match) && this.getSuperBounds().matches(otherWildcard.getSuperBounds(), match);
        }
        return false;
    }
}

