const char convertconf[] = 
    "#! /usr/bin/lua\n"
    "\n"
    "local usage = [[\n"
    "Usage: convert.lua old_conkyrc [new_conkyrc]\n"
    "\n"
    "Tries to convert conkyrc from the old v1.x format to the new, lua-based format.\n"
    "\n"
    "Keep in mind that there is no guarantee that the output will work correctly\n"
    "with conky, or that it will be able to convert every conkyrc. However, it\n"
    "should provide a good starting point.\n"
    "\n"
    "Although you can use this script with only 1 arg and let it overwrite the old\n"
    "config, it's suggested to use 2 args so that the new config is written in a new\n"
    "file (so that you have backup if something went wrong).\n"
    "\n"
    "Optional: Install dos2unix. We will attempt to use this if it is available\n"
    "because Conky configs downloaded from Internet sometimes are created on DOS/Windows\n"
    "machines with different line endings than Conky configs created on Unix/Linux.\n"
    "\n"
    "For more information about the new format, read the wiki page\n"
    "<https://github.com/brndnmtthws/conky/wiki>\n"
    "]];\n"
    "\n"
    "local function quote(s)\n"
    "    if not s:find(\"[\\n'\\\\]\") then\n"
    "        return \"'\" .. s .. \"'\";\n"
    "    end;\n"
    "    local q = '';\n"
    "    while s:find(']' .. q .. ']', 1, true) do\n"
    "        q = q .. '=';\n"
    "    end;\n"
    "    return string.format('[%s[\\n%s]%s]', q, s, q);\n"
    "end;\n"
    "\n"
    "local bool_setting = {\n"
    "    background = true, disable_auto_reload = true, double_buffer = true, draw_borders = true,\n"
    "    draw_graph_borders = true, draw_outline = true, draw_shades = true, extra_newline = true,\n"
    "    format_human_readable = true, no_buffers = true, out_to_console = true,\n"
    "    out_to_wayland = true,\n"
    "    out_to_ncurses = true, out_to_stderr = true, out_to_x = true, override_utf8_locale = true,\n"
    "    own_window = true, own_window_argb_visual = true, own_window_transparent = true,\n"
    "    short_units = true, show_graph_range = true, show_graph_scale = true,\n"
    "    times_in_seconds = true, top_cpu_separate = true, uppercase = true, use_xft = true,\n"
    "    draw_blended = true, forced_redraw = true\n"
    "};\n"
    "\n"
    "local num_setting = {\n"
    "    border_inner_margin = true, border_outer_margin = true, border_width = true,\n"
    "    cpu_avg_samples = true, diskio_avg_samples = true, gap_x = true, gap_y = true,\n"
    "    imlib_cache_flush_interval = true, imlib_cache_size = true,\n"
    "    max_port_monitor_connections = true, max_text_width = true, max_user_text = true,\n"
    "    maximum_width = true, mpd_port = true, music_player_interval = true, net_avg_samples = true,\n"
    "    own_window_argb_value = true, pad_percents = true, stippled_borders = true,\n"
    "    text_buffer_size = true, top_name_width = true, total_run_times = true,\n"
    "    update_interval = true, update_interval_on_battery = true, xftalpha = true,\n"
    "    xinerama_head = true,\n"
    "};\n"
    "\n"
    "local split_setting = {\n"
    "    default_bar_size = true, default_gauge_size = true, default_graph_size = true,\n"
    "    minimum_size = true\n"
    "};\n"
    "\n"
    "local colour_setting = {\n"
    "    color0 = true, color1 = true, color2 = true, color3 = true, color4 = true, color5 = true,\n"
    "    color6 = true, color7 = true, color8 = true, color9 = true, default_color = true,\n"
    "    default_outline_color = true, default_shade_color = true, own_window_colour = true\n"
    "};\n"
    "\n"
    "local function alignment_map(value)\n"
    "    local map = { m = 'middle', t = 'top', b = 'bottom', r = 'right', l = 'left' };\n"
    "    if map[value] == nil then\n"
    "        return value;\n"
    "    else\n"
    "        return map[value];\n"
    "    end;\n"
    "end;\n"
    "\n"
    "local function handle(setting, value)\n"
    "    setting = setting:lower();\n"
    "    if setting == '' then\n"
    "        return '';\n"
    "    end;\n"
    "    if split_setting[setting] then\n"
    "        local x, y = value:match('^(%S+)%s*(%S*)$');\n"
    "        local ret = setting:gsub('_size', '_width = ') .. x .. ',';\n"
    "        if y ~= '' then\n"
    "            ret = ret .. ' ' .. setting:gsub('_size', '_height = ') .. y .. ',';\n"
    "        end;\n"
    "        return '\\t' .. ret;\n"
    "    end;\n"
    "    if bool_setting[setting] then\n"
    "        value = value:lower();\n"
    "        if value == 'yes' or value == 'true' or value == '1' or value == '' then\n"
    "            value = 'true';\n"
    "        else\n"
    "            value = 'false';\n"
    "        end;\n"
    "    elseif not num_setting[setting] then\n"
    "        if setting == 'alignment' and value:len() == 2 then\n"
    "            value = alignment_map(value:sub(1,1)) .. '_' .. alignment_map(value:sub(2,2));\n"
    "        elseif colour_setting[setting] and value:match('^[0-9a-fA-F]+$') then\n"
    "            value = '#' .. value;\n"
    "        elseif setting == 'xftfont' then\n"
    "            setting = 'font';\n"
    "        end;\n"
    "        value = quote(value);\n"
    "    end;\n"
    "    return '\\t' .. setting .. ' = ' .. value .. ',';\n"
    "end;\n"
    "\n"
    "local function convert(s)\n"
    "    local setting, comment = s:match('^([^#]*)#?(.*)\\n$');\n"
    "    if comment ~= '' then\n"
    "        comment = '--' .. comment;\n"
    "    end;\n"
    "    comment = comment .. '\\n';\n"
    "    return handle(setting:match('^%s*(%S*)%s*(.-)%s*$')) ..  comment;\n"
    "end;\n"
    "\n"
    "local input;\n"
    "local output;\n"
    "\n"
    "if conky == nil then --> standalone program\n"
    "    -- 1 arg: arg is input and outputfile\n"
    "    -- 2 args: 1st is inputfile, 2nd is outputfile\n"
    "    -- 0, 3 or more args: print usage to STDERR and quit\n"
    "    if #arg == 1 or #arg == 2 then\n"
    "        if os.execute('command -v dos2unix 2>&1 >/dev/null') == 0 then\n"
    "            os.execute('dos2unix ' .. arg[1]);\n"
    "        end\n"
    "        input = io.input(arg[1]);\n"
    "    else\n"
    "        io.stderr:write(usage);\n"
    "        return;\n"
    "    end;\n"
    "else\n"
    "    -- we are called from conky, the filename is the first argument\n"
    "    input = io.open(..., 'r');\n"
    "end;\n"
    "\n"
    "\n"
    "local config = input:read('*a');\n"
    "input:close();\n"
    "\n"
    "local settings, text = config:match('^(.-)TEXT\\n(.*)$');\n"
    "\n"
    "local converted = 'conky.config = {\\n' .. settings:gsub('.-\\n', convert) .. '};\\n\\nconky.text = ' ..\n"
    "                quote(text) .. ';\\n';\n"
    "\n"
    "if conky == nil then\n"
    "    if #arg == 2 then\n"
    "        output = io.output(arg[2]);\n"
    "    else\n"
    "        output = io.output(arg[1]);\n"
    "    end\n"
    "    output:write(converted);\n"
    "    output:close();\n"
    "else\n"
    "    return assert(load(converted, 'converted config'));\n"
    "end;\n";
