/* encoding_button.c generated by valac 0.56.17, the Vala compiler
 * generated from encoding_button.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_ENCODING_BUTTON (widgets_encoding_button_get_type ())
#define WIDGETS_ENCODING_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButton))
#define WIDGETS_ENCODING_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButtonClass))
#define WIDGETS_IS_ENCODING_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENCODING_BUTTON))
#define WIDGETS_IS_ENCODING_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENCODING_BUTTON))
#define WIDGETS_ENCODING_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButtonClass))

typedef struct _WidgetsEncodingButton WidgetsEncodingButton;
typedef struct _WidgetsEncodingButtonClass WidgetsEncodingButtonClass;
typedef struct _WidgetsEncodingButtonPrivate WidgetsEncodingButtonPrivate;
enum  {
	WIDGETS_ENCODING_BUTTON_0_PROPERTY,
	WIDGETS_ENCODING_BUTTON_NUM_PROPERTIES
};
static GParamSpec* widgets_encoding_button_properties[WIDGETS_ENCODING_BUTTON_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WIDGETS_TYPE_ENCODING_LIST (widgets_encoding_list_get_type ())
#define WIDGETS_ENCODING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingList))
#define WIDGETS_ENCODING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingListClass))
#define WIDGETS_IS_ENCODING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENCODING_LIST))
#define WIDGETS_IS_ENCODING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENCODING_LIST))
#define WIDGETS_ENCODING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingListClass))

typedef struct _WidgetsEncodingList WidgetsEncodingList;
typedef struct _WidgetsEncodingListClass WidgetsEncodingListClass;
typedef struct _WidgetsEncodingListPrivate WidgetsEncodingListPrivate;
enum  {
	WIDGETS_ENCODING_LIST_0_PROPERTY,
	WIDGETS_ENCODING_LIST_NUM_PROPERTIES
};
static GParamSpec* widgets_encoding_list_properties[WIDGETS_ENCODING_LIST_NUM_PROPERTIES];
typedef struct _Block12Data Block12Data;
enum  {
	WIDGETS_ENCODING_LIST_ACTIVE_ENCODING_SIGNAL,
	WIDGETS_ENCODING_LIST_NUM_SIGNALS
};
static guint widgets_encoding_list_signals[WIDGETS_ENCODING_LIST_NUM_SIGNALS] = {0};

struct _WidgetsEncodingButton {
	GtkEventBox parent_instance;
	WidgetsEncodingButtonPrivate * priv;
	cairo_surface_t* active_theme_border_surface;
	cairo_surface_t* dark_theme_border_surface;
	cairo_surface_t* light_theme_border_surface;
	GdkRGBA background_color;
	GdkRGBA content_color;
	GdkRGBA foreground_color;
	GKeyFile* theme_file;
	gboolean is_active;
	gboolean is_light_color;
	gint background_padding;
	gint border_padding;
	gint button_radius;
	gint content_font_size;
	gint content_padding_x;
	gint content_padding_y;
	gchar* encoding_name;
};

struct _WidgetsEncodingButtonClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _WidgetsEncodingList {
	GtkVBox parent_instance;
	WidgetsEncodingListPrivate * priv;
	gint encoding_button_padding;
	GeeHashMap* encoding_button_map;
	WidgetsEncodingButton* active_encoding_button;
};

struct _WidgetsEncodingListClass {
	GtkVBoxClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	WidgetsEncodingList* self;
	gchar* encoding_name;
};

static gpointer widgets_encoding_button_parent_class = NULL;
VALA_EXTERN gint constant_ENCODING_BUTTON_WIDTH;
VALA_EXTERN gint constant_ENCODING_BUTTON_HEIGHT;
VALA_EXTERN gint constant_ENCODING_SLIDER_WIDTH;
static gpointer widgets_encoding_list_parent_class = NULL;
VALA_EXTERN gint constant_ENCODING_BUTTON_PADDING;

VALA_EXTERN GType widgets_encoding_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEncodingButton, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN WidgetsEncodingButton* widgets_encoding_button_new (const gchar* name,
                                                    WidgetsWorkspace* space);
VALA_EXTERN WidgetsEncodingButton* widgets_encoding_button_construct (GType object_type,
                                                          const gchar* name,
                                                          WidgetsWorkspace* space);
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN gchar* utils_get_theme_path (const gchar* theme_name);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN gboolean utils_is_light_color (const gchar* color_string);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
static gboolean widgets_encoding_button_on_draw (WidgetsEncodingButton* self,
                                          GtkWidget* widget,
                                          cairo_t* cr);
static gboolean _widgets_encoding_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                           cairo_t* cr,
                                                           gpointer self);
VALA_EXTERN void widgets_encoding_button_active (WidgetsEncodingButton* self);
VALA_EXTERN void widgets_encoding_button_inactive (WidgetsEncodingButton* self);
VALA_EXTERN void draw_fill_rounded_rectangle (cairo_t* cr,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gdouble r);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
static void widgets_encoding_button_finalize (GObject * obj);
static GType widgets_encoding_button_get_type_once (void);
VALA_EXTERN GType widgets_encoding_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEncodingList, g_object_unref)
VALA_EXTERN WidgetsEncodingList* widgets_encoding_list_new (const gchar* temrinal_encoding,
                                                GeeArrayList* encoding_names,
                                                WidgetsWorkspace* space);
VALA_EXTERN WidgetsEncodingList* widgets_encoding_list_construct (GType object_type,
                                                      const gchar* temrinal_encoding,
                                                      GeeArrayList* encoding_names,
                                                      WidgetsWorkspace* space);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean ____lambda111_ (Block12Data* _data12_,
                         GtkWidget* w,
                         GdkEventButton* e);
VALA_EXTERN gboolean utils_is_left_button (GdkEventButton* event);
VALA_EXTERN void widgets_encoding_list_active_button (WidgetsEncodingList* self,
                                          const gchar* encoding_name);
static gboolean _____lambda111__gtk_widget_button_press_event (GtkWidget* _sender,
                                                        GdkEventButton* event,
                                                        gpointer self);
static void widgets_encoding_list_finalize (GObject * obj);
static GType widgets_encoding_list_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
_widgets_encoding_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                  cairo_t* cr,
                                                  gpointer self)
{
	gboolean result;
	result = widgets_encoding_button_on_draw ((WidgetsEncodingButton*) self, _sender, cr);
	return result;
}

WidgetsEncodingButton*
widgets_encoding_button_construct (GType object_type,
                                   const gchar* name,
                                   WidgetsWorkspace* space)
{
	WidgetsEncodingButton * self = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (space != NULL, NULL);
	self = (WidgetsEncodingButton*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->encoding_name);
	self->encoding_name = _tmp0_;
	{
		WidgetsConfigWindow* parent_window = NULL;
		GtkWidget* _tmp1_;
		WidgetsConfigWindow* _tmp2_;
		gchar* theme_name = NULL;
		WidgetsConfigWindow* _tmp3_;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		GKeyFile* _tmp7_;
		GKeyFile* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		GKeyFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GdkRGBA _tmp17_ = {0};
		gchar* _tmp18_ = NULL;
		GKeyFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		GKeyFile* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GdkRGBA _tmp28_ = {0};
		gchar* _tmp29_ = NULL;
		GKeyFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GdkRGBA _tmp34_ = {0};
		cairo_surface_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		cairo_surface_t* _tmp37_;
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) space);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
		parent_window = _tmp2_;
		_tmp3_ = parent_window;
		_tmp4_ = _tmp3_->config;
		_tmp5_ = _tmp4_->config_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "general", "theme", &_inner_error0_);
		theme_name = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp7_ = g_key_file_new ();
		_g_key_file_unref0 (self->theme_file);
		self->theme_file = _tmp7_;
		_tmp8_ = self->theme_file;
		_tmp9_ = theme_name;
		_tmp10_ = utils_get_theme_path (_tmp9_);
		_tmp11_ = _tmp10_;
		g_key_file_load_from_file (_tmp8_, _tmp11_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (theme_name);
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp13_ = self->theme_file;
		_tmp14_ = g_key_file_get_string (_tmp13_, "theme", "background", &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (theme_name);
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp15_ = string_strip (_tmp12_);
		_tmp16_ = _tmp15_;
		utils_hex_to_rgba (_tmp16_, 1.0, &_tmp17_);
		self->background_color = _tmp17_;
		_g_free0 (_tmp16_);
		_tmp19_ = self->theme_file;
		_tmp20_ = g_key_file_get_string (_tmp19_, "theme", "background", &_inner_error0_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_free0 (theme_name);
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp21_ = string_strip (_tmp18_);
		_tmp22_ = _tmp21_;
		self->is_light_color = utils_is_light_color (_tmp22_);
		_g_free0 (_tmp22_);
		self->background_color.alpha = 0.8;
		_tmp24_ = self->theme_file;
		_tmp25_ = g_key_file_get_string (_tmp24_, "theme", "foreground", &_inner_error0_);
		_tmp23_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp18_);
			_g_free0 (_tmp12_);
			_g_free0 (theme_name);
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp26_ = string_strip (_tmp23_);
		_tmp27_ = _tmp26_;
		utils_hex_to_rgba (_tmp27_, 1.0, &_tmp28_);
		self->foreground_color = _tmp28_;
		_g_free0 (_tmp27_);
		_tmp30_ = self->theme_file;
		_tmp31_ = g_key_file_get_string (_tmp30_, "theme", "color_2", &_inner_error0_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp23_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp12_);
			_g_free0 (theme_name);
			_g_object_unref0 (parent_window);
			goto __catch0_g_error;
		}
		_tmp32_ = string_strip (_tmp29_);
		_tmp33_ = _tmp32_;
		utils_hex_to_rgba (_tmp33_, 1.0, &_tmp34_);
		self->content_color = _tmp34_;
		_g_free0 (_tmp33_);
		_tmp35_ = utils_create_image_surface ("dark_theme_border.svg");
		_cairo_surface_destroy0 (self->dark_theme_border_surface);
		self->dark_theme_border_surface = _tmp35_;
		_tmp36_ = utils_create_image_surface ("light_theme_border.svg");
		_cairo_surface_destroy0 (self->light_theme_border_surface);
		self->light_theme_border_surface = _tmp36_;
		_tmp37_ = utils_create_image_surface ("active_theme_border.svg");
		_cairo_surface_destroy0 (self->active_theme_border_surface);
		self->active_theme_border_surface = _tmp37_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp12_);
		_g_free0 (theme_name);
		_g_object_unref0 (parent_window);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_print ("EncodingButton: %s\n", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) self, constant_ENCODING_BUTTON_WIDTH, constant_ENCODING_BUTTON_HEIGHT);
	gtk_widget_set_margin_start ((GtkWidget*) self, (constant_ENCODING_SLIDER_WIDTH - constant_ENCODING_BUTTON_WIDTH) / 2);
	gtk_widget_set_margin_end ((GtkWidget*) self, (constant_ENCODING_SLIDER_WIDTH - constant_ENCODING_BUTTON_WIDTH) / 2);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_encoding_button_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsEncodingButton*
widgets_encoding_button_new (const gchar* name,
                             WidgetsWorkspace* space)
{
	return widgets_encoding_button_construct (WIDGETS_TYPE_ENCODING_BUTTON, name, space);
}

void
widgets_encoding_button_active (WidgetsEncodingButton* self)
{
	g_return_if_fail (self != NULL);
	self->is_active = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
widgets_encoding_button_inactive (WidgetsEncodingButton* self)
{
	g_return_if_fail (self != NULL);
	self->is_active = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
widgets_encoding_button_on_draw (WidgetsEncodingButton* self,
                                 GtkWidget* widget,
                                 cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GtkAllocation _tmp5_;
	GtkAllocation _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	const gchar* _tmp11_;
	GtkAllocation _tmp12_;
	GtkAllocation _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = self->background_color;
	_tmp2_ = self->background_color;
	_tmp3_ = self->background_color;
	_tmp4_ = self->background_color;
	cairo_set_source_rgba (cr, _tmp1_.red, _tmp2_.green, _tmp3_.blue, _tmp4_.alpha);
	_tmp5_ = rect;
	_tmp6_ = rect;
	draw_fill_rounded_rectangle (cr, self->background_padding, self->background_padding, _tmp5_.width - (self->background_padding * 2), _tmp6_.height - (self->background_padding * 2), (gdouble) self->button_radius);
	_tmp7_ = self->content_color;
	_tmp8_ = self->content_color;
	_tmp9_ = self->content_color;
	_tmp10_ = self->content_color;
	cairo_set_source_rgba (cr, _tmp7_.red, _tmp8_.green, _tmp9_.blue, _tmp10_.alpha);
	_tmp11_ = self->encoding_name;
	_tmp12_ = rect;
	_tmp13_ = rect;
	draw_draw_text (cr, _tmp11_, self->content_padding_x, self->content_padding_y, _tmp12_.width, _tmp13_.height, self->content_font_size, PANGO_ALIGN_LEFT, "top", NULL);
	if (self->is_active) {
		cairo_surface_t* _tmp14_;
		_tmp14_ = self->active_theme_border_surface;
		draw_draw_surface (cr, _tmp14_, 0, 0, 0, 0);
	} else {
		if (self->is_light_color) {
			cairo_surface_t* _tmp15_;
			_tmp15_ = self->light_theme_border_surface;
			draw_draw_surface (cr, _tmp15_, self->border_padding, self->border_padding, 0, 0);
		} else {
			cairo_surface_t* _tmp16_;
			_tmp16_ = self->dark_theme_border_surface;
			draw_draw_surface (cr, _tmp16_, self->border_padding, self->border_padding, 0, 0);
		}
	}
	result = TRUE;
	return result;
}

static void
widgets_encoding_button_class_init (WidgetsEncodingButtonClass * klass,
                                    gpointer klass_data)
{
	widgets_encoding_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_encoding_button_finalize;
}

static void
widgets_encoding_button_instance_init (WidgetsEncodingButton * self,
                                       gpointer klass)
{
	self->is_active = FALSE;
	self->background_padding = 2;
	self->border_padding = 1;
	self->button_radius = 5;
	self->content_font_size = 11;
	self->content_padding_x = 24;
	self->content_padding_y = 15;
}

static void
widgets_encoding_button_finalize (GObject * obj)
{
	WidgetsEncodingButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButton);
	_cairo_surface_destroy0 (self->active_theme_border_surface);
	_cairo_surface_destroy0 (self->dark_theme_border_surface);
	_cairo_surface_destroy0 (self->light_theme_border_surface);
	_g_key_file_unref0 (self->theme_file);
	_g_free0 (self->encoding_name);
	G_OBJECT_CLASS (widgets_encoding_button_parent_class)->finalize (obj);
}

static GType
widgets_encoding_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsEncodingButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_encoding_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsEncodingButton), 0, (GInstanceInitFunc) widgets_encoding_button_instance_init, NULL };
	GType widgets_encoding_button_type_id;
	widgets_encoding_button_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsEncodingButton", &g_define_type_info, 0);
	return widgets_encoding_button_type_id;
}

GType
widgets_encoding_button_get_type (void)
{
	static volatile gsize widgets_encoding_button_type_id__once = 0;
	if (g_once_init_enter (&widgets_encoding_button_type_id__once)) {
		GType widgets_encoding_button_type_id;
		widgets_encoding_button_type_id = widgets_encoding_button_get_type_once ();
		g_once_init_leave (&widgets_encoding_button_type_id__once, widgets_encoding_button_type_id);
	}
	return widgets_encoding_button_type_id__once;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		WidgetsEncodingList* self;
		self = _data12_->self;
		_g_free0 (_data12_->encoding_name);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
____lambda111_ (Block12Data* _data12_,
                GtkWidget* w,
                GdkEventButton* e)
{
	WidgetsEncodingList* self;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (utils_is_left_button (e)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = _data12_->encoding_name;
		widgets_encoding_list_active_button (self, _tmp0_);
		_tmp1_ = _data12_->encoding_name;
		g_signal_emit (self, widgets_encoding_list_signals[WIDGETS_ENCODING_LIST_ACTIVE_ENCODING_SIGNAL], 0, _tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda111__gtk_widget_button_press_event (GtkWidget* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	gboolean result;
	result = ____lambda111_ (self, _sender, event);
	return result;
}

WidgetsEncodingList*
widgets_encoding_list_construct (GType object_type,
                                 const gchar* temrinal_encoding,
                                 GeeArrayList* encoding_names,
                                 WidgetsWorkspace* space)
{
	WidgetsEncodingList * self = NULL;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (temrinal_encoding != NULL, NULL);
	g_return_val_if_fail (encoding_names != NULL, NULL);
	g_return_val_if_fail (space != NULL, NULL);
	self = (WidgetsEncodingList*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WIDGETS_TYPE_ENCODING_BUTTON, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->encoding_button_map);
	self->encoding_button_map = _tmp0_;
	{
		GeeArrayList* _encoding_name_list = NULL;
		gint _encoding_name_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _encoding_name_index = 0;
		_encoding_name_list = encoding_names;
		_tmp1_ = _encoding_name_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_encoding_name_size = _tmp3_;
		_encoding_name_index = -1;
		while (TRUE) {
			Block12Data* _data12_;
			gint _tmp4_;
			gint _tmp5_;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			WidgetsEncodingButton* button = NULL;
			const gchar* _tmp8_;
			WidgetsEncodingButton* _tmp9_;
			WidgetsEncodingButton* _tmp10_;
			WidgetsEncodingButton* _tmp11_;
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			WidgetsEncodingButton* _tmp14_;
			_data12_ = g_slice_new0 (Block12Data);
			_data12_->_ref_count_ = 1;
			_data12_->self = g_object_ref (self);
			_encoding_name_index = _encoding_name_index + 1;
			_tmp4_ = _encoding_name_index;
			_tmp5_ = _encoding_name_size;
			if (!(_tmp4_ < _tmp5_)) {
				block12_data_unref (_data12_);
				_data12_ = NULL;
				break;
			}
			_tmp6_ = _encoding_name_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _encoding_name_index);
			_data12_->encoding_name = (gchar*) _tmp7_;
			_tmp8_ = _data12_->encoding_name;
			_tmp9_ = widgets_encoding_button_new (_tmp8_, space);
			g_object_ref_sink (_tmp9_);
			button = _tmp9_;
			_tmp10_ = button;
			gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) self->encoding_button_padding);
			_tmp11_ = button;
			g_signal_connect_data ((GtkWidget*) _tmp11_, "button-press-event", (GCallback) _____lambda111__gtk_widget_button_press_event, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
			_tmp12_ = self->encoding_button_map;
			_tmp13_ = _data12_->encoding_name;
			_tmp14_ = button;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp14_);
			_g_object_unref0 (button);
			block12_data_unref (_data12_);
			_data12_ = NULL;
		}
	}
	widgets_encoding_list_active_button (self, temrinal_encoding);
	return self;
}

WidgetsEncodingList*
widgets_encoding_list_new (const gchar* temrinal_encoding,
                           GeeArrayList* encoding_names,
                           WidgetsWorkspace* space)
{
	return widgets_encoding_list_construct (WIDGETS_TYPE_ENCODING_LIST, temrinal_encoding, encoding_names, space);
}

void
widgets_encoding_list_active_button (WidgetsEncodingList* self,
                                     const gchar* encoding_name)
{
	WidgetsEncodingButton* _tmp0_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	WidgetsEncodingButton* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (encoding_name != NULL);
	_tmp0_ = self->active_encoding_button;
	if (_tmp0_ != NULL) {
		WidgetsEncodingButton* _tmp1_;
		_tmp1_ = self->active_encoding_button;
		widgets_encoding_button_inactive (_tmp1_);
	}
	_tmp2_ = self->encoding_button_map;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, encoding_name);
	_g_object_unref0 (self->active_encoding_button);
	self->active_encoding_button = (WidgetsEncodingButton*) _tmp3_;
	_tmp4_ = self->active_encoding_button;
	widgets_encoding_button_active (_tmp4_);
}

static void
widgets_encoding_list_class_init (WidgetsEncodingListClass * klass,
                                  gpointer klass_data)
{
	widgets_encoding_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_encoding_list_finalize;
	widgets_encoding_list_signals[WIDGETS_ENCODING_LIST_ACTIVE_ENCODING_SIGNAL] = g_signal_new ("active-encoding", WIDGETS_TYPE_ENCODING_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
widgets_encoding_list_instance_init (WidgetsEncodingList * self,
                                     gpointer klass)
{
	self->encoding_button_padding = constant_ENCODING_BUTTON_PADDING;
	self->active_encoding_button = NULL;
}

static void
widgets_encoding_list_finalize (GObject * obj)
{
	WidgetsEncodingList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingList);
	_g_object_unref0 (self->encoding_button_map);
	_g_object_unref0 (self->active_encoding_button);
	G_OBJECT_CLASS (widgets_encoding_list_parent_class)->finalize (obj);
}

static GType
widgets_encoding_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsEncodingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_encoding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsEncodingList), 0, (GInstanceInitFunc) widgets_encoding_list_instance_init, NULL };
	GType widgets_encoding_list_type_id;
	widgets_encoding_list_type_id = g_type_register_static (gtk_vbox_get_type (), "WidgetsEncodingList", &g_define_type_info, 0);
	return widgets_encoding_list_type_id;
}

GType
widgets_encoding_list_get_type (void)
{
	static volatile gsize widgets_encoding_list_type_id__once = 0;
	if (g_once_init_enter (&widgets_encoding_list_type_id__once)) {
		GType widgets_encoding_list_type_id;
		widgets_encoding_list_type_id = widgets_encoding_list_get_type_once ();
		g_once_init_leave (&widgets_encoding_list_type_id__once, widgets_encoding_list_type_id);
	}
	return widgets_encoding_list_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

