/* window_button.c generated by valac 0.56.17, the Vala compiler
 * generated from window_button.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;
typedef struct _WidgetsClickEventBoxPrivate WidgetsClickEventBoxPrivate;

#define WIDGETS_TYPE_WINDOW_BUTTON (widgets_window_button_get_type ())
#define WIDGETS_WINDOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButton))
#define WIDGETS_WINDOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButtonClass))
#define WIDGETS_IS_WINDOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WINDOW_BUTTON))
#define WIDGETS_IS_WINDOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WINDOW_BUTTON))
#define WIDGETS_WINDOW_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButtonClass))

typedef struct _WidgetsWindowButton WidgetsWindowButton;
typedef struct _WidgetsWindowButtonClass WidgetsWindowButtonClass;
typedef struct _WidgetsWindowButtonPrivate WidgetsWindowButtonPrivate;
enum  {
	WIDGETS_WINDOW_BUTTON_0_PROPERTY,
	WIDGETS_WINDOW_BUTTON_NUM_PROPERTIES
};
static GParamSpec* widgets_window_button_properties[WIDGETS_WINDOW_BUTTON_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;
typedef struct _WidgetsDialogPrivate WidgetsDialogPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

struct _WidgetsClickEventBox {
	GtkEventBox parent_instance;
	WidgetsClickEventBoxPrivate * priv;
	gboolean is_press;
};

struct _WidgetsClickEventBoxClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsWindowButton {
	WidgetsClickEventBox parent_instance;
	WidgetsWindowButtonPrivate * priv;
	cairo_surface_t* hover_dark_surface;
	cairo_surface_t* hover_light_surface;
	cairo_surface_t* normal_dark_surface;
	cairo_surface_t* normal_light_surface;
	cairo_surface_t* press_dark_surface;
	cairo_surface_t* press_light_surface;
	gboolean is_hover;
	gboolean is_theme_button;
	gint surface_y;
};

struct _WidgetsWindowButtonClass {
	WidgetsClickEventBoxClass parent_class;
};

struct _WidgetsDialog {
	GtkWindow parent_instance;
	WidgetsDialogPrivate * priv;
	GdkScreen* screen_monitor;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsConfigWindow* transient_window;
	gint option_widget_margin_end;
	gint option_widget_margin_top;
	gint window_frame_margin_bottom;
	gint window_frame_margin_end;
	gint window_frame_margin_start;
	gint window_frame_margin_top;
	gint window_frame_radius;
	gint window_init_height;
	gint window_init_width;
};

struct _WidgetsDialogClass {
	GtkWindowClass parent_class;
	void (*draw_window_above) (WidgetsDialog* self, cairo_t* cr);
};

static gpointer widgets_window_button_parent_class = NULL;
VALA_EXTERN gint constant_WINDOW_BUTTON_WIDHT;
VALA_EXTERN gint constant_CLOSE_BUTTON_MARGIN_RIGHT;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;

VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_window_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWindowButton, g_object_unref)
VALA_EXTERN WidgetsWindowButton* widgets_window_button_new (const gchar* image_path,
                                                gboolean theme_button,
                                                gint width,
                                                gint height);
VALA_EXTERN WidgetsWindowButton* widgets_window_button_construct (GType object_type,
                                                      const gchar* image_path,
                                                      gboolean theme_button,
                                                      gint width,
                                                      gint height);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_new (void);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_construct (GType object_type);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
static gboolean widgets_window_button_on_draw (WidgetsWindowButton* self,
                                        GtkWidget* widget,
                                        cairo_t* cr);
static gboolean _widgets_window_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                         cairo_t* cr,
                                                         gpointer self);
static gboolean __lambda77_ (WidgetsWindowButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda77__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda78_ (WidgetsWindowButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda78__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda79_ (WidgetsWindowButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda79__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda80_ (WidgetsWindowButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda80__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
static void widgets_window_button_finalize (GObject * obj);
static GType widgets_window_button_get_type_once (void);
VALA_EXTERN WidgetsWindowButton* widgets_create_close_button (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_window_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self)
{
	gboolean result;
	result = widgets_window_button_on_draw ((WidgetsWindowButton*) self, _sender, cr);
	return result;
}

static gboolean
__lambda77_ (WidgetsWindowButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, GDK_HAND1);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	result = FALSE;
	return result;
}

static gboolean
___lambda77__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda77_ ((WidgetsWindowButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda78_ (WidgetsWindowButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda78__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda78_ ((WidgetsWindowButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda79_ (WidgetsWindowButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda79__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda79_ ((WidgetsWindowButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda80_ (WidgetsWindowButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda80__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda80_ ((WidgetsWindowButton*) self, _sender, event);
	return result;
}

WidgetsWindowButton*
widgets_window_button_construct (GType object_type,
                                 const gchar* image_path,
                                 gboolean theme_button,
                                 gint width,
                                 gint height)
{
	WidgetsWindowButton * self = NULL;
	cairo_surface_t* _tmp27_;
	g_return_val_if_fail (image_path != NULL, NULL);
	self = (WidgetsWindowButton*) widgets_click_event_box_construct (object_type);
	self->is_theme_button = theme_button;
	if (self->is_theme_button) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		cairo_surface_t* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		cairo_surface_t* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		cairo_surface_t* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		cairo_surface_t* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		cairo_surface_t* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		cairo_surface_t* _tmp17_;
		_tmp0_ = g_strconcat (image_path, "_dark_normal.svg", NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = utils_create_image_surface (_tmp1_);
		_cairo_surface_destroy0 (self->normal_dark_surface);
		self->normal_dark_surface = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp3_ = g_strconcat (image_path, "_dark_hover.svg", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = utils_create_image_surface (_tmp4_);
		_cairo_surface_destroy0 (self->hover_dark_surface);
		self->hover_dark_surface = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = g_strconcat (image_path, "_dark_press.svg", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = utils_create_image_surface (_tmp7_);
		_cairo_surface_destroy0 (self->press_dark_surface);
		self->press_dark_surface = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp9_ = g_strconcat (image_path, "_light_normal.svg", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = utils_create_image_surface (_tmp10_);
		_cairo_surface_destroy0 (self->normal_light_surface);
		self->normal_light_surface = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp12_ = g_strconcat (image_path, "_light_hover.svg", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = utils_create_image_surface (_tmp13_);
		_cairo_surface_destroy0 (self->hover_light_surface);
		self->hover_light_surface = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp15_ = g_strconcat (image_path, "_light_press.svg", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = utils_create_image_surface (_tmp16_);
		_cairo_surface_destroy0 (self->press_light_surface);
		self->press_light_surface = _tmp17_;
		_g_free0 (_tmp16_);
	} else {
		gchar* _tmp18_;
		gchar* _tmp19_;
		cairo_surface_t* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		cairo_surface_t* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		cairo_surface_t* _tmp26_;
		_tmp18_ = g_strconcat (image_path, "_normal.svg", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = utils_create_image_surface (_tmp19_);
		_cairo_surface_destroy0 (self->normal_dark_surface);
		self->normal_dark_surface = _tmp20_;
		_g_free0 (_tmp19_);
		_tmp21_ = g_strconcat (image_path, "_hover.svg", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = utils_create_image_surface (_tmp22_);
		_cairo_surface_destroy0 (self->hover_dark_surface);
		self->hover_dark_surface = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp24_ = g_strconcat (image_path, "_press.svg", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = utils_create_image_surface (_tmp25_);
		_cairo_surface_destroy0 (self->press_dark_surface);
		self->press_dark_surface = _tmp26_;
		_g_free0 (_tmp25_);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, width, height);
	_tmp27_ = self->normal_dark_surface;
	self->surface_y = (height - (cairo_image_surface_get_height (_tmp27_) / gtk_widget_get_scale_factor ((GtkWidget*) self))) / 2;
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_window_button_on_draw_gtk_widget_draw, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda77__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) ___lambda78__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda79__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda80__gtk_widget_button_release_event, self, 0);
	return self;
}

WidgetsWindowButton*
widgets_window_button_new (const gchar* image_path,
                           gboolean theme_button,
                           gint width,
                           gint height)
{
	return widgets_window_button_construct (WIDGETS_TYPE_WINDOW_BUTTON, image_path, theme_button, width, height);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
widgets_window_button_on_draw (WidgetsWindowButton* self,
                               GtkWidget* widget,
                               cairo_t* cr)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* top_level = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	is_light_theme = FALSE;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	top_level = _tmp1_;
	_tmp2_ = top_level;
	if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_), WIDGETS_TYPE_DIALOG)) {
		GtkWidget* _tmp3_;
		WidgetsConfigWindow* _tmp4_;
		_tmp3_ = top_level;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, WIDGETS_TYPE_DIALOG, WidgetsDialog)->transient_window;
		is_light_theme = widgets_config_window_is_light_theme (_tmp4_);
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	}
	if (self->is_hover) {
		if (((WidgetsClickEventBox*) self)->is_press) {
			gboolean _tmp6_ = FALSE;
			if (self->is_theme_button) {
				_tmp6_ = is_light_theme;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				cairo_surface_t* _tmp7_;
				_tmp7_ = self->press_light_surface;
				draw_draw_surface (cr, _tmp7_, 0, self->surface_y, 0, 0);
			} else {
				cairo_surface_t* _tmp8_;
				_tmp8_ = self->press_dark_surface;
				draw_draw_surface (cr, _tmp8_, 0, self->surface_y, 0, 0);
			}
		} else {
			gboolean _tmp9_ = FALSE;
			if (self->is_theme_button) {
				_tmp9_ = is_light_theme;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				cairo_surface_t* _tmp10_;
				_tmp10_ = self->hover_light_surface;
				draw_draw_surface (cr, _tmp10_, 0, self->surface_y, 0, 0);
			} else {
				cairo_surface_t* _tmp11_;
				_tmp11_ = self->hover_dark_surface;
				draw_draw_surface (cr, _tmp11_, 0, self->surface_y, 0, 0);
			}
		}
	} else {
		gboolean _tmp12_ = FALSE;
		if (self->is_theme_button) {
			_tmp12_ = is_light_theme;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			cairo_surface_t* _tmp13_;
			_tmp13_ = self->normal_light_surface;
			draw_draw_surface (cr, _tmp13_, 0, self->surface_y, 0, 0);
		} else {
			cairo_surface_t* _tmp14_;
			_tmp14_ = self->normal_dark_surface;
			draw_draw_surface (cr, _tmp14_, 0, self->surface_y, 0, 0);
		}
	}
	result = TRUE;
	_g_object_unref0 (top_level);
	return result;
}

static void
widgets_window_button_class_init (WidgetsWindowButtonClass * klass,
                                  gpointer klass_data)
{
	widgets_window_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_window_button_finalize;
}

static void
widgets_window_button_instance_init (WidgetsWindowButton * self,
                                     gpointer klass)
{
	self->is_hover = FALSE;
}

static void
widgets_window_button_finalize (GObject * obj)
{
	WidgetsWindowButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButton);
	_cairo_surface_destroy0 (self->hover_dark_surface);
	_cairo_surface_destroy0 (self->hover_light_surface);
	_cairo_surface_destroy0 (self->normal_dark_surface);
	_cairo_surface_destroy0 (self->normal_light_surface);
	_cairo_surface_destroy0 (self->press_dark_surface);
	_cairo_surface_destroy0 (self->press_light_surface);
	G_OBJECT_CLASS (widgets_window_button_parent_class)->finalize (obj);
}

static GType
widgets_window_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsWindowButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_window_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsWindowButton), 0, (GInstanceInitFunc) widgets_window_button_instance_init, NULL };
	GType widgets_window_button_type_id;
	widgets_window_button_type_id = g_type_register_static (WIDGETS_TYPE_CLICK_EVENT_BOX, "WidgetsWindowButton", &g_define_type_info, 0);
	return widgets_window_button_type_id;
}

GType
widgets_window_button_get_type (void)
{
	static volatile gsize widgets_window_button_type_id__once = 0;
	if (g_once_init_enter (&widgets_window_button_type_id__once)) {
		GType widgets_window_button_type_id;
		widgets_window_button_type_id = widgets_window_button_get_type_once ();
		g_once_init_leave (&widgets_window_button_type_id__once, widgets_window_button_type_id);
	}
	return widgets_window_button_type_id__once;
}

WidgetsWindowButton*
widgets_create_close_button (void)
{
	WidgetsWindowButton* close_button = NULL;
	WidgetsWindowButton* _tmp0_;
	WidgetsWindowButton* result;
	_tmp0_ = widgets_window_button_new ("titlebar_close", FALSE, constant_WINDOW_BUTTON_WIDHT + constant_CLOSE_BUTTON_MARGIN_RIGHT, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp0_);
	close_button = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) close_button, GTK_ALIGN_END);
	result = close_button;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

