
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "toolbutton_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_ToolButton_Type = nullptr;
static PyTypeObject *Sbk_ToolButton_TypeF(void)
{
    return _Sbk_ToolButton_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ToolButtonWrapper::pysideInitQtMetaTypes()
{
}

void ToolButtonWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ToolButtonWrapper::ToolButtonWrapper(::QWidget * parent) : ToolButton(parent)
{
}

void ToolButtonWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::actionEvent(arg__1);
    }
    WebViewWrapper::sbk_o_actionEvent("ToolButton", funcName, gil, pyOverride, arg__1);
}

void ToolButtonWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("ToolButton", funcName, gil, pyOverride, arg__1);
}

void ToolButtonWrapper::checkStateSet()
{
    static const char *funcName = "checkStateSet";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::checkStateSet();
    }
    WebViewWrapper::sbk_o_closeView("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ToolButton", funcName, gil, pyOverride, signal);
}

void ToolButtonWrapper::contextMenuEvent(::QContextMenuEvent * e)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::ToolButton::contextMenuEvent(e);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("ToolButton", funcName, gil, pyOverride, event);
}

int ToolButtonWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ToolButton", funcName, gil, pyOverride, signal);
}

void ToolButtonWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::enterEvent(arg__1);
    }
    WebViewWrapper::sbk_o_enterEvent("ToolButton", funcName, gil, pyOverride, arg__1);
}

bool ToolButtonWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::event(e);
    }
    return WebViewWrapper::sbk_o_event("ToolButton", funcName, gil, pyOverride, e);
}

bool ToolButtonWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("ToolButton", funcName, gil, pyOverride, watched, event);
}

void ToolButtonWrapper::focusInEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::focusInEvent(e);
    }
    WebViewWrapper::sbk_o_focusInEvent("ToolButton", funcName, gil, pyOverride, e);
}

bool ToolButtonWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("ToolButton", funcName, gil, pyOverride, next);
}

void ToolButtonWrapper::focusOutEvent(::QFocusEvent * e)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::focusOutEvent(e);
    }
    WebViewWrapper::sbk_o_focusOutEvent("ToolButton", funcName, gil, pyOverride, e);
}

bool ToolButtonWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("ToolButton", funcName, gil, pyOverride);
}

int ToolButtonWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("ToolButton", funcName, gil, pyOverride, arg__1);
}

void ToolButtonWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("ToolButton", funcName, gil, pyOverride, event);
}

bool ToolButtonWrapper::hitButton(const ::QPoint & pos) const
{
    static const char *funcName = "hitButton";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::hitButton(pos);
    }
    return sbk_o_hitButton("ToolButton", funcName, gil, pyOverride, pos);
}

bool ToolButtonWrapper::sbk_o_hitButton(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QPoint & pos)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &pos)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &pos)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void ToolButtonWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("ToolButton", funcName, gil, pyOverride, painter);
}

void ToolButtonWrapper::initStyleOption(::QStyleOptionToolButton * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::initStyleOption(option);
    }
    sbk_o_initStyleOption("ToolButton", funcName, gil, pyOverride, option);
}

void ToolButtonWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionToolButton * option)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionToolButton_IDX]), option)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionToolButton_IDX]), option)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void ToolButtonWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("ToolButton", funcName, gil, pyOverride, event);
}

::QVariant ToolButtonWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("ToolButton", funcName, gil, pyOverride, arg__1);
}

void ToolButtonWrapper::keyPressEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyPressEvent(e);
    }
    WebViewWrapper::sbk_o_keyPressEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::keyReleaseEvent(e);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::leaveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_leaveEvent("ToolButton", funcName, gil, pyOverride, arg__1);
}

int ToolButtonWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("ToolButton", funcName, gil, pyOverride, arg__1);
}

::QSize ToolButtonWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::mouseDoubleClickEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::ToolButton::mouseDoubleClickEvent(e);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::mouseMoveEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractButton::mouseMoveEvent(e);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::mousePressEvent(::QMouseEvent * e)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::ToolButton::mousePressEvent(e);
    }
    WebViewWrapper::sbk_o_mousePressEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::ToolButton::mouseReleaseEvent(e);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("ToolButton", funcName, gil, pyOverride, e);
}

void ToolButtonWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("ToolButton", funcName, gil, pyOverride, event);
}

bool ToolButtonWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("ToolButton", funcName, gil, pyOverride, eventType, message, result);
}

void ToolButtonWrapper::nextCheckState()
{
    static const char *funcName = "nextCheckState";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::nextCheckState();
    }
    WebViewWrapper::sbk_o_closeView("ToolButton", funcName, gil, pyOverride);
}

::QPaintEngine * ToolButtonWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::paintEvent(::QPaintEvent * e)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::ToolButton::paintEvent(e);
    }
    WebViewWrapper::sbk_o_paintEvent("ToolButton", funcName, gil, pyOverride, e);
}

::QPaintDevice * ToolButtonWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("ToolButton", funcName, gil, pyOverride, offset);
}

void ToolButtonWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("ToolButton", funcName, gil, pyOverride, visible);
}

::QPainter * ToolButtonWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("ToolButton", funcName, gil, pyOverride, event);
}

::QSize ToolButtonWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ToolButton", funcName, gil, pyOverride);
}

void ToolButtonWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("ToolButton", funcName, gil, pyOverride, event);
}

void ToolButtonWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QToolButton::timerEvent(arg__1);
    }
    WebViewWrapper::sbk_o_timerEvent("ToolButton", funcName, gil, pyOverride, arg__1);
}

void ToolButtonWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ToolButton_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("ToolButton", funcName, gil, pyOverride, event);
}

const QMetaObject *ToolButtonWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return ToolButton::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ToolButtonWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = ToolButton::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ToolButtonWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ToolButtonWrapper *>(this));
    }
    return ToolButton::qt_metacast(_clname);
}

ToolButtonWrapper::~ToolButtonWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_ToolButton_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_ToolButton_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::ToolButton >()))
        return -1;

    ToolButtonWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:ToolButton", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: ToolButton::ToolButton(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // ToolButton(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ToolButton(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ToolButton(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) ToolButtonWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new ToolButtonWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ToolButton >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ToolButtonFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QContextMenuEvent_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contextMenuEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QContextMenuEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // contextMenuEvent(QContextMenuEvent*)
            static_cast<ToolButtonWrapper *>(cppSelf)->ToolButtonWrapper::contextMenuEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_fallbackIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fallbackIcon()const
        QIcon cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->fallbackIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_menu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // menu()const
        QMenu * cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->menu();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseDoubleClickEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseDoubleClickEvent(QMouseEvent*)
            static_cast<ToolButtonWrapper *>(cppSelf)->ToolButtonWrapper::mouseDoubleClickEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePressEvent(QMouseEvent*)
            static_cast<ToolButtonWrapper *>(cppSelf)->ToolButtonWrapper::mousePressEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mouseReleaseEvent(QMouseEvent*)
            static_cast<ToolButtonWrapper *>(cppSelf)->ToolButtonWrapper::mouseReleaseEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_multiIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // multiIcon()const
        QImage cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->multiIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            static_cast<ToolButtonWrapper *>(cppSelf)->ToolButtonWrapper::paintEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setFallbackIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setFallbackIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setFallbackIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFallbackIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setFallbackIcon(QIcon)
            cppSelf->setFallbackIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QToolButton::setMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // setMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMenu", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMenu(QMenu*)
            cppSelf->setMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setMultiIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setMultiIcon(QImage)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QImage_IDX]), (pyArg)))) {
        overloadId = 0; // setMultiIcon(QImage)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMultiIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setMultiIcon(QImage)
            cppSelf->setMultiIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setShowMenuInside(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setShowMenuInside(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowMenuInside(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowMenuInside", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowMenuInside(bool)
            cppSelf->setShowMenuInside(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setShowMenuOnRightClick(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setShowMenuOnRightClick(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowMenuOnRightClick(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowMenuOnRightClick", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowMenuOnRightClick(bool)
            cppSelf->setShowMenuOnRightClick(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setThemeIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setThemeIcon(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setThemeIcon(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setThemeIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setThemeIcon(QString)
            cppSelf->setThemeIcon(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_setToolbarButtonLook(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ToolButton::setToolbarButtonLook(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setToolbarButtonLook(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolbarButtonLook", errInfo, SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolbarButtonLook(bool)
            cppSelf->setToolbarButtonLook(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_showMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("showMenu()");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ToolButtonFunc_showMenuInside(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showMenuInside()const
        bool cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->showMenuInside();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_showMenuOnRightClick(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showMenuOnRightClick()const
        bool cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->showMenuOnRightClick();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_themeIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // themeIcon()const
        QString cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->themeIcon();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ToolButtonFunc_toolbarButtonLook(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ToolButtonWrapper *>(reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolbarButtonLook()const
        bool cppResult = const_cast<const ToolButtonWrapper *>(cppSelf)->toolbarButtonLook();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_ToolButton_PropertyStrings[] = {
    "fallbackIcon::",
    "fixedheight:height:setFixedHeight",
    "fixedsize:size:setFixedSize",
    "fixedwidth:width:setFixedWidth",
    "icon::",
    "multiIcon::",
    "themeIcon::",
    nullptr // Sentinel
};

static const char *Sbk_ToolButton_EnumFlagInfo[] = {
    "Options:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_ToolButton_methods[] = {
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_contextMenuEvent), METH_O, nullptr},
    {"fallbackIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_fallbackIcon), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_icon), METH_NOARGS, nullptr},
    {"menu", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_menu), METH_NOARGS, nullptr},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_mouseDoubleClickEvent), METH_O, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_mousePressEvent), METH_O, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_mouseReleaseEvent), METH_O, nullptr},
    {"multiIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_multiIcon), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_paintEvent), METH_O, nullptr},
    {"setFallbackIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setFallbackIcon), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setIcon), METH_O, nullptr},
    {"setMenu", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setMenu), METH_O, nullptr},
    {"setMultiIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setMultiIcon), METH_O, nullptr},
    {"setShowMenuInside", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setShowMenuInside), METH_O, nullptr},
    {"setShowMenuOnRightClick", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setShowMenuOnRightClick), METH_O, nullptr},
    {"setThemeIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setThemeIcon), METH_O, nullptr},
    {"setToolbarButtonLook", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_setToolbarButtonLook), METH_O, nullptr},
    {"showMenu", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_showMenu), METH_NOARGS, nullptr},
    {"showMenuInside", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_showMenuInside), METH_NOARGS, nullptr},
    {"showMenuOnRightClick", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_showMenuOnRightClick), METH_NOARGS, nullptr},
    {"themeIcon", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_themeIcon), METH_NOARGS, nullptr},
    {"toolbarButtonLook", reinterpret_cast<PyCFunction>(Sbk_ToolButtonFunc_toolbarButtonLook), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_ToolButton_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::ToolButton *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ToolButton_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ToolButtonWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_ToolButton_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_ToolButton_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_ToolButtonSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::ToolButton *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX]))
        return static_cast< ::QToolButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractButton_IDX]))
        return static_cast< ::QAbstractButton *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_ToolButton_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_ToolButton_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_ToolButton_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_ToolButton_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_ToolButton_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_ToolButton_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_ToolButton_spec = {
    "1:PyFalkon.ToolButton",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_ToolButton_slots
};

} //extern "C"

static void *Sbk_ToolButton_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::ToolButton *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::ToolButton *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::ToolButton *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ToolButton_PythonToCpp_ToolButton_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_ToolButton_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ToolButton_PythonToCpp_ToolButton_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_ToolButton_TypeF()))
        return ToolButton_PythonToCpp_ToolButton_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ToolButton_PTR_CppToPython_ToolButton(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::ToolButton *>(const_cast<void *>(cppIn)), Sbk_ToolButton_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *ToolButton_SignatureStrings[] = {
    "PyFalkon.ToolButton(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,fixedsize:QSize=None,fixedwidth:int=None,fixedheight:int=None,multiIcon:QImage=None,icon:QIcon=None,themeIcon:QString=None,fallbackIcon:QIcon=None)",
    "PyFalkon.ToolButton.contextMenuEvent(self,e:PySide6.QtGui.QContextMenuEvent)",
    "PyFalkon.ToolButton.fallbackIcon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.ToolButton.icon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.ToolButton.menu(self)->PySide6.QtWidgets.QMenu",
    "PyFalkon.ToolButton.mouseDoubleClickEvent(self,e:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.ToolButton.mousePressEvent(self,e:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.ToolButton.mouseReleaseEvent(self,e:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.ToolButton.multiIcon(self)->PySide6.QtGui.QImage",
    "PyFalkon.ToolButton.paintEvent(self,e:PySide6.QtGui.QPaintEvent)",
    "PyFalkon.ToolButton.setFallbackIcon(self,fallbackIcon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.ToolButton.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.ToolButton.setMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.ToolButton.setMultiIcon(self,image:PySide6.QtGui.QImage)",
    "PyFalkon.ToolButton.setShowMenuInside(self,enable:bool)",
    "PyFalkon.ToolButton.setShowMenuOnRightClick(self,enable:bool)",
    "PyFalkon.ToolButton.setThemeIcon(self,icon:QString)",
    "PyFalkon.ToolButton.setToolbarButtonLook(self,enable:bool)",
    "PyFalkon.ToolButton.showMenu(self)",
    "PyFalkon.ToolButton.showMenuInside(self)->bool",
    "PyFalkon.ToolButton.showMenuOnRightClick(self)->bool",
    "PyFalkon.ToolButton.themeIcon(self)->QString",
    "PyFalkon.ToolButton.toolbarButtonLook(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t ToolButton_SignatureByteSize = 419;
static constexpr uint8_t ToolButton_SignatureBytes[419] = {
    0x78, 0xda, 0xb5, 0x54, 0xc1, 0x4e, 0xc2, 0x40, 0x10, 0xbd, 0xfb, 0x15, 0x1e, 0xc5, 0xd4, 0x1e,
    0x3d, 0x34, 0xc1, 0x83, 0x28, 0x86, 0x28, 0xd2, 0x52, 0x8c, 0x07, 0xe3, 0x61, 0xa1, 0x03, 0x9d,
    0xb0, 0xdd, 0x6d, 0xda, 0xa9, 0x50, 0xbf, 0xde, 0x5d, 0xda, 0x42, 0x81, 0x6d, 0x25, 0x18, 0x2f,
    0x9b, 0x76, 0xf6, 0xbd, 0x37, 0xfb, 0x76, 0x5e, 0xd6, 0xcd, 0xfb, 0x8c, 0x2f, 0xa5, 0xb0, 0x27,
    0x52, 0xf2, 0xfb, 0x8c, 0x48, 0x8a, 0xab, 0x14, 0xf8, 0xdc, 0x8a, 0x59, 0x02, 0x82, 0x1c, 0x37,
    0xf7, 0x31, 0x80, 0x5b, 0xdb, 0xa3, 0x77, 0x0c, 0x16, 0x40, 0xa9, 0xed, 0x15, 0x1f, 0x5d, 0x91,
    0x71, 0x1e, 0x53, 0x62, 0x5d, 0x3b, 0xcf, 0x90, 0xaf, 0x64, 0x12, 0x8c, 0x04, 0xcf, 0xbb, 0xaf,
    0x52, 0x80, 0x35, 0xc7, 0x35, 0x04, 0x29, 0x7e, 0x83, 0xe3, 0xf9, 0x6a, 0xad, 0x15, 0x57, 0x18,
    0x50, 0xe8, 0xa0, 0xa0, 0x5a, 0x2d, 0x04, 0x5c, 0x84, 0xb4, 0x2b, 0x46, 0x19, 0x27, 0x1c, 0xcc,
    0xa4, 0x70, 0xbc, 0x41, 0xc4, 0x16, 0x25, 0x1d, 0x8b, 0x82, 0x5a, 0x8b, 0x7f, 0x0a, 0x21, 0x82,
    0x02, 0xe5, 0x53, 0x82, 0x62, 0x51, 0x2a, 0x32, 0xce, 0xa7, 0x6c, 0xb6, 0x1c, 0xec, 0xc3, 0x3b,
    0x17, 0xee, 0xb1, 0x51, 0x5b, 0xed, 0x12, 0xac, 0x69, 0x08, 0x22, 0x7b, 0xfc, 0x52, 0x6e, 0x0b,
    0xe7, 0x50, 0x33, 0xfd, 0x94, 0xa1, 0xed, 0xf5, 0x0e, 0x60, 0x66, 0xb1, 0x7a, 0xe7, 0x8d, 0x50,
    0xe7, 0xe6, 0xee, 0x40, 0x48, 0x6f, 0x19, 0xb9, 0x78, 0x06, 0x27, 0x52, 0xc7, 0x39, 0xe6, 0x6c,
    0xa7, 0xa4, 0x4f, 0x6b, 0xe6, 0xc9, 0x2c, 0x85, 0x07, 0x99, 0x4d, 0x39, 0xf4, 0x38, 0xce, 0x96,
    0x6d, 0xce, 0x87, 0x1a, 0xdb, 0xe2, 0x79, 0xa3, 0xe5, 0x26, 0x90, 0xa6, 0x7f, 0x56, 0x19, 0x03,
    0x07, 0x56, 0xc2, 0xce, 0xd5, 0xa9, 0x82, 0xd3, 0x74, 0x95, 0x3a, 0x4d, 0x46, 0x66, 0xcc, 0x54,
    0xfa, 0xda, 0x5a, 0xbb, 0x5b, 0x80, 0xb9, 0x75, 0x0a, 0xd4, 0x3f, 0x9c, 0xff, 0x7e, 0x16, 0x29,
    0x8f, 0x55, 0x48, 0xed, 0x37, 0x81, 0x52, 0x7c, 0x18, 0x66, 0x6c, 0x5d, 0x1e, 0xb6, 0xc4, 0x75,
    0xc4, 0xe2, 0xcf, 0xc6, 0x7e, 0xbb, 0x3e, 0xf8, 0x2f, 0xfa, 0xc3, 0x2a, 0x5f, 0x96, 0x4e, 0x9a,
    0xd3, 0x10, 0xb1, 0x66, 0xfa, 0xde, 0x30, 0x2c, 0xd4, 0x77, 0xef, 0x98, 0x06, 0xd2, 0xa8, 0xe0,
    0x87, 0x72, 0xa5, 0x5b, 0x0c, 0x44, 0xaa, 0x48, 0xe5, 0x60, 0x04, 0x53, 0xb9, 0x75, 0xa6, 0x0a,
    0xf8, 0x2b, 0x6f, 0x24, 0xc6, 0xfa, 0x61, 0xd9, 0x84, 0xfc, 0x74, 0xf6, 0xa4, 0x7a, 0x57, 0x6a,
    0x77, 0x5b, 0xbe, 0x30, 0xcd, 0x1c, 0xf5, 0x37, 0x65, 0x49, 0x51, 0x78, 0x91, 0xf2, 0xe4, 0x76,
    0xe5, 0x49, 0x8b, 0xbc, 0xb6, 0x42, 0x6a, 0x97, 0xa0, 0x82, 0xad, 0x25, 0x5b, 0xe1, 0x47, 0xde,
    0xdb, 0x48, 0xb4, 0x67, 0x59, 0x21, 0x4b, 0xbf, 0x66, 0xb0, 0xd1, 0x6b, 0x25, 0xff, 0x03, 0x21,
    0x8c, 0x50, 0xc3
};
#endif

PyTypeObject *init_ToolButton(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_ToolButton_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_ToolButton_IDX].type;

    Shiboken::AutoDecRef Sbk_ToolButton_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX]))));

    _Sbk_ToolButton_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "ToolButton",
        "ToolButton*",
        &Sbk_ToolButton_spec,
        &Shiboken::callCppDestructor< ToolButton >,
        Sbk_ToolButton_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_ToolButton_TypeF(); // references _Sbk_ToolButton_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, ToolButton_SignatureStrings);
#else
    InitSignatureBytes(pyType, ToolButton_SignatureBytes, ToolButton_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_ToolButton_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_ToolButton_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ToolButton_PythonToCpp_ToolButton_PTR,
        is_ToolButton_PythonToCpp_ToolButton_PTR_Convertible,
        ToolButton_PTR_CppToPython_ToolButton);

    Shiboken::Conversions::registerConverterName(converter, "ToolButton");
    Shiboken::Conversions::registerConverterName(converter, "ToolButton*");
    Shiboken::Conversions::registerConverterName(converter, "ToolButton&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::ToolButton).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ToolButtonWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_ToolButton_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_ToolButton_TypeF(), &Sbk_ToolButtonSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_ToolButton_TypeF(), &Sbk_ToolButton_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_ToolButton_EnumFlagInfo);

    PySide::Signal::registerSignals(pyType, &::ToolButton::staticMetaObject);
    ToolButtonWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::ToolButton::staticMetaObject, sizeof(ToolButtonWrapper));

    return pyType;
}
