#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_CHTTRANS_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_CHTTRANS_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-chttrans", _Chttrans_)

static void*
__fcitx_Chttrans_function_S2T(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxChttrans*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FcitxChttrans* self = __self;
    FCITX_UNUSED(self);
    char* res = (ConvertGBKSimple2Tradition(self, arg0));
    FCITX_RETURN_AS_PTR(char*, res);
}

static void*
__fcitx_Chttrans_function_T2S(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxChttrans*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FcitxChttrans* self = __self;
    FCITX_UNUSED(self);
    char* res = (ConvertGBKTradition2Simple(self, arg0));
    FCITX_RETURN_AS_PTR(char*, res);
}

static void
FcitxChttransAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Chttrans_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Chttrans_addon_functions_table[] = {
        __fcitx_Chttrans_function_S2T,
        __fcitx_Chttrans_function_T2S,
    };
    for (i = 0;i < 2;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Chttrans_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
