//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PFileSystemRequest_h
#define PFileSystemRequest_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/dom/IPCBlob.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemFileResponse|
//
namespace mozilla {
namespace dom {
class FileSystemFileResponse final
{
private:
    typedef ::mozilla::dom::IPCBlob IPCBlob;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemFileResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemFileResponse(const IPCBlob& _blob) :
        blob_(_blob)
    {
    }

    MOZ_IMPLICIT FileSystemFileResponse(IPCBlob&& _blob) :
        blob_(std::move(_blob))
    {
    }

    IPCBlob&
    blob()
    {
        return blob_;
    }
    const IPCBlob&
    blob() const
    {
        return blob_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCBlob> blob_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemFileResponse>
{
    typedef ::mozilla::dom::FileSystemFileResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemDirectoryResponse|
//
namespace mozilla {
namespace dom {
class FileSystemDirectoryResponse final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemDirectoryResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemDirectoryResponse(const nsString& _realPath) :
        realPath_(_realPath)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryResponse(nsString&& _realPath) :
        realPath_(std::move(_realPath))
    {
    }

    nsString&
    realPath()
    {
        return realPath_;
    }
    const nsString&
    realPath() const
    {
        return realPath_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> realPath_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemDirectoryResponse>
{
    typedef ::mozilla::dom::FileSystemDirectoryResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemDirectoryListingResponseFile|
//
namespace mozilla {
namespace dom {
class FileSystemDirectoryListingResponseFile final
{
private:
    typedef ::mozilla::dom::IPCBlob IPCBlob;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemDirectoryListingResponseFile() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemDirectoryListingResponseFile(const IPCBlob& _blob) :
        blob_(_blob)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryListingResponseFile(IPCBlob&& _blob) :
        blob_(std::move(_blob))
    {
    }

    IPCBlob&
    blob()
    {
        return blob_;
    }
    const IPCBlob&
    blob() const
    {
        return blob_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPCBlob> blob_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemDirectoryListingResponseFile>
{
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseFile paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemDirectoryListingResponseDirectory|
//
namespace mozilla {
namespace dom {
class FileSystemDirectoryListingResponseDirectory final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemDirectoryListingResponseDirectory() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemDirectoryListingResponseDirectory(const nsString& _directoryRealPath) :
        directoryRealPath_(_directoryRealPath)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryListingResponseDirectory(nsString&& _directoryRealPath) :
        directoryRealPath_(std::move(_directoryRealPath))
    {
    }

    nsString&
    directoryRealPath()
    {
        return directoryRealPath_;
    }
    const nsString&
    directoryRealPath() const
    {
        return directoryRealPath_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> directoryRealPath_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemDirectoryListingResponseDirectory>
{
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseDirectory paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemDirectoryListingResponseData|
//
namespace mozilla {
namespace dom {
class FileSystemDirectoryListingResponseData final
{
public:
    enum Type {
        T__None,
        TFileSystemDirectoryListingResponseFile = 1,
        TFileSystemDirectoryListingResponseDirectory,
        T__Last = TFileSystemDirectoryListingResponseDirectory
    };

private:
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseFile FileSystemDirectoryListingResponseFile;
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseDirectory FileSystemDirectoryListingResponseDirectory;
    typedef FileSystemDirectoryListingResponseFile FileSystemDirectoryListingResponseFile__tdef;
    typedef FileSystemDirectoryListingResponseDirectory FileSystemDirectoryListingResponseDirectory__tdef;

    FileSystemDirectoryListingResponseFile*
    ptr_FileSystemDirectoryListingResponseFile()
    {
        return (&(mVFileSystemDirectoryListingResponseFile));
    }
    const FileSystemDirectoryListingResponseFile*
    constptr_FileSystemDirectoryListingResponseFile() const
    {
        return (&(mVFileSystemDirectoryListingResponseFile));
    }
    FileSystemDirectoryListingResponseDirectory*
    ptr_FileSystemDirectoryListingResponseDirectory()
    {
        return (&(mVFileSystemDirectoryListingResponseDirectory));
    }
    const FileSystemDirectoryListingResponseDirectory*
    constptr_FileSystemDirectoryListingResponseDirectory() const
    {
        return (&(mVFileSystemDirectoryListingResponseDirectory));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemDirectoryListingResponseData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(const FileSystemDirectoryListingResponseFile& aOther);

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(FileSystemDirectoryListingResponseFile&& aOther);

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(const FileSystemDirectoryListingResponseDirectory& aOther);

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(FileSystemDirectoryListingResponseDirectory&& aOther);

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(const FileSystemDirectoryListingResponseData& aOther);

    MOZ_IMPLICIT FileSystemDirectoryListingResponseData(FileSystemDirectoryListingResponseData&& aOther);

    ~FileSystemDirectoryListingResponseData();

    Type
    type() const
    {
        return mType;
    }

    FileSystemDirectoryListingResponseData&
    operator=(const FileSystemDirectoryListingResponseFile& aRhs);

    FileSystemDirectoryListingResponseData&
    operator=(FileSystemDirectoryListingResponseFile&& aRhs);

    FileSystemDirectoryListingResponseData&
    operator=(const FileSystemDirectoryListingResponseDirectory& aRhs);

    FileSystemDirectoryListingResponseData&
    operator=(FileSystemDirectoryListingResponseDirectory&& aRhs);

    FileSystemDirectoryListingResponseData&
    operator=(const FileSystemDirectoryListingResponseData& aRhs);

    FileSystemDirectoryListingResponseData&
    operator=(FileSystemDirectoryListingResponseData&& aRhs);

    FileSystemDirectoryListingResponseFile&
    get_FileSystemDirectoryListingResponseFile()
    {
        AssertSanity(TFileSystemDirectoryListingResponseFile);
        return (*(ptr_FileSystemDirectoryListingResponseFile()));
    }
    const FileSystemDirectoryListingResponseFile&
    get_FileSystemDirectoryListingResponseFile() const
    {
        AssertSanity(TFileSystemDirectoryListingResponseFile);
        return (*(constptr_FileSystemDirectoryListingResponseFile()));
    }
    operator FileSystemDirectoryListingResponseFile&()
    {
        return get_FileSystemDirectoryListingResponseFile();
    }
    operator const FileSystemDirectoryListingResponseFile&() const
    {
        return get_FileSystemDirectoryListingResponseFile();
    }

    FileSystemDirectoryListingResponseDirectory&
    get_FileSystemDirectoryListingResponseDirectory()
    {
        AssertSanity(TFileSystemDirectoryListingResponseDirectory);
        return (*(ptr_FileSystemDirectoryListingResponseDirectory()));
    }
    const FileSystemDirectoryListingResponseDirectory&
    get_FileSystemDirectoryListingResponseDirectory() const
    {
        AssertSanity(TFileSystemDirectoryListingResponseDirectory);
        return (*(constptr_FileSystemDirectoryListingResponseDirectory()));
    }
    operator FileSystemDirectoryListingResponseDirectory&()
    {
        return get_FileSystemDirectoryListingResponseDirectory();
    }
    operator const FileSystemDirectoryListingResponseDirectory&() const
    {
        return get_FileSystemDirectoryListingResponseDirectory();
    }

private:
    union {
        FileSystemDirectoryListingResponseFile mVFileSystemDirectoryListingResponseFile;
        FileSystemDirectoryListingResponseDirectory mVFileSystemDirectoryListingResponseDirectory;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemDirectoryListingResponseData>
{
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemDirectoryListingResponse|
//
namespace mozilla {
namespace dom {
class FileSystemDirectoryListingResponse final
{
private:
    typedef ::mozilla::dom::FileSystemDirectoryListingResponseData FileSystemDirectoryListingResponseData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemDirectoryListingResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemDirectoryListingResponse(const nsTArray<FileSystemDirectoryListingResponseData>& _data) :
        data_(_data)
    {
    }

    MOZ_IMPLICIT FileSystemDirectoryListingResponse(nsTArray<FileSystemDirectoryListingResponseData>&& _data) :
        data_(std::move(_data))
    {
    }

    nsTArray<FileSystemDirectoryListingResponseData>&
    data()
    {
        return data_;
    }
    const nsTArray<FileSystemDirectoryListingResponseData>&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FileSystemDirectoryListingResponseData>> data_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemDirectoryListingResponse>
{
    typedef ::mozilla::dom::FileSystemDirectoryListingResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemFilesResponse|
//
namespace mozilla {
namespace dom {
class FileSystemFilesResponse final
{
private:
    typedef ::mozilla::dom::FileSystemFileResponse FileSystemFileResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemFilesResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemFilesResponse(const nsTArray<FileSystemFileResponse>& _data) :
        data_(_data)
    {
    }

    MOZ_IMPLICIT FileSystemFilesResponse(nsTArray<FileSystemFileResponse>&& _data) :
        data_(std::move(_data))
    {
    }

    nsTArray<FileSystemFileResponse>&
    data()
    {
        return data_;
    }
    const nsTArray<FileSystemFileResponse>&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FileSystemFileResponse>> data_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemFilesResponse>
{
    typedef ::mozilla::dom::FileSystemFilesResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FileSystemErrorResponse|
//
namespace mozilla {
namespace dom {
class FileSystemErrorResponse final
{
private:
    typedef ::nsresult nsresult;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FileSystemErrorResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FileSystemErrorResponse(const nsresult& _error) :
        error_(_error)
    {
    }

    MOZ_IMPLICIT FileSystemErrorResponse(nsresult&& _error) :
        error_(std::move(_error))
    {
    }

    nsresult&
    error()
    {
        return error_;
    }
    const nsresult&
    error() const
    {
        return error_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsresult> error_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemErrorResponse>
{
    typedef ::mozilla::dom::FileSystemErrorResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union FileSystemResponseValue|
//
namespace mozilla {
namespace dom {
class FileSystemResponseValue final
{
public:
    enum Type {
        T__None,
        TFileSystemDirectoryResponse = 1,
        TFileSystemDirectoryListingResponse,
        TFileSystemFileResponse,
        TFileSystemFilesResponse,
        TFileSystemErrorResponse,
        T__Last = TFileSystemErrorResponse
    };

private:
    typedef ::mozilla::dom::FileSystemDirectoryResponse FileSystemDirectoryResponse;
    typedef ::mozilla::dom::FileSystemDirectoryListingResponse FileSystemDirectoryListingResponse;
    typedef ::mozilla::dom::FileSystemFileResponse FileSystemFileResponse;
    typedef ::mozilla::dom::FileSystemFilesResponse FileSystemFilesResponse;
    typedef ::mozilla::dom::FileSystemErrorResponse FileSystemErrorResponse;
    typedef FileSystemDirectoryResponse FileSystemDirectoryResponse__tdef;
    typedef FileSystemDirectoryListingResponse FileSystemDirectoryListingResponse__tdef;
    typedef FileSystemFileResponse FileSystemFileResponse__tdef;
    typedef FileSystemFilesResponse FileSystemFilesResponse__tdef;
    typedef FileSystemErrorResponse FileSystemErrorResponse__tdef;

    FileSystemDirectoryResponse*
    ptr_FileSystemDirectoryResponse()
    {
        return (&(mVFileSystemDirectoryResponse));
    }
    const FileSystemDirectoryResponse*
    constptr_FileSystemDirectoryResponse() const
    {
        return (&(mVFileSystemDirectoryResponse));
    }
    FileSystemDirectoryListingResponse*
    ptr_FileSystemDirectoryListingResponse()
    {
        return (&(mVFileSystemDirectoryListingResponse));
    }
    const FileSystemDirectoryListingResponse*
    constptr_FileSystemDirectoryListingResponse() const
    {
        return (&(mVFileSystemDirectoryListingResponse));
    }
    FileSystemFileResponse*
    ptr_FileSystemFileResponse()
    {
        return (&(mVFileSystemFileResponse));
    }
    const FileSystemFileResponse*
    constptr_FileSystemFileResponse() const
    {
        return (&(mVFileSystemFileResponse));
    }
    FileSystemFilesResponse*
    ptr_FileSystemFilesResponse()
    {
        return (&(mVFileSystemFilesResponse));
    }
    const FileSystemFilesResponse*
    constptr_FileSystemFilesResponse() const
    {
        return (&(mVFileSystemFilesResponse));
    }
    FileSystemErrorResponse*
    ptr_FileSystemErrorResponse()
    {
        return (&(mVFileSystemErrorResponse));
    }
    const FileSystemErrorResponse*
    constptr_FileSystemErrorResponse() const
    {
        return (&(mVFileSystemErrorResponse));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT FileSystemResponseValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemDirectoryResponse& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemDirectoryResponse&& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemDirectoryListingResponse& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemDirectoryListingResponse&& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemFileResponse& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemFileResponse&& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemFilesResponse& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemFilesResponse&& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemErrorResponse& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemErrorResponse&& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(const FileSystemResponseValue& aOther);

    MOZ_IMPLICIT FileSystemResponseValue(FileSystemResponseValue&& aOther);

    ~FileSystemResponseValue();

    Type
    type() const
    {
        return mType;
    }

    FileSystemResponseValue&
    operator=(const FileSystemDirectoryResponse& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemDirectoryResponse&& aRhs);

    FileSystemResponseValue&
    operator=(const FileSystemDirectoryListingResponse& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemDirectoryListingResponse&& aRhs);

    FileSystemResponseValue&
    operator=(const FileSystemFileResponse& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemFileResponse&& aRhs);

    FileSystemResponseValue&
    operator=(const FileSystemFilesResponse& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemFilesResponse&& aRhs);

    FileSystemResponseValue&
    operator=(const FileSystemErrorResponse& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemErrorResponse&& aRhs);

    FileSystemResponseValue&
    operator=(const FileSystemResponseValue& aRhs);

    FileSystemResponseValue&
    operator=(FileSystemResponseValue&& aRhs);

    FileSystemDirectoryResponse&
    get_FileSystemDirectoryResponse()
    {
        AssertSanity(TFileSystemDirectoryResponse);
        return (*(ptr_FileSystemDirectoryResponse()));
    }
    const FileSystemDirectoryResponse&
    get_FileSystemDirectoryResponse() const
    {
        AssertSanity(TFileSystemDirectoryResponse);
        return (*(constptr_FileSystemDirectoryResponse()));
    }
    operator FileSystemDirectoryResponse&()
    {
        return get_FileSystemDirectoryResponse();
    }
    operator const FileSystemDirectoryResponse&() const
    {
        return get_FileSystemDirectoryResponse();
    }

    FileSystemDirectoryListingResponse&
    get_FileSystemDirectoryListingResponse()
    {
        AssertSanity(TFileSystemDirectoryListingResponse);
        return (*(ptr_FileSystemDirectoryListingResponse()));
    }
    const FileSystemDirectoryListingResponse&
    get_FileSystemDirectoryListingResponse() const
    {
        AssertSanity(TFileSystemDirectoryListingResponse);
        return (*(constptr_FileSystemDirectoryListingResponse()));
    }
    operator FileSystemDirectoryListingResponse&()
    {
        return get_FileSystemDirectoryListingResponse();
    }
    operator const FileSystemDirectoryListingResponse&() const
    {
        return get_FileSystemDirectoryListingResponse();
    }

    FileSystemFileResponse&
    get_FileSystemFileResponse()
    {
        AssertSanity(TFileSystemFileResponse);
        return (*(ptr_FileSystemFileResponse()));
    }
    const FileSystemFileResponse&
    get_FileSystemFileResponse() const
    {
        AssertSanity(TFileSystemFileResponse);
        return (*(constptr_FileSystemFileResponse()));
    }
    operator FileSystemFileResponse&()
    {
        return get_FileSystemFileResponse();
    }
    operator const FileSystemFileResponse&() const
    {
        return get_FileSystemFileResponse();
    }

    FileSystemFilesResponse&
    get_FileSystemFilesResponse()
    {
        AssertSanity(TFileSystemFilesResponse);
        return (*(ptr_FileSystemFilesResponse()));
    }
    const FileSystemFilesResponse&
    get_FileSystemFilesResponse() const
    {
        AssertSanity(TFileSystemFilesResponse);
        return (*(constptr_FileSystemFilesResponse()));
    }
    operator FileSystemFilesResponse&()
    {
        return get_FileSystemFilesResponse();
    }
    operator const FileSystemFilesResponse&() const
    {
        return get_FileSystemFilesResponse();
    }

    FileSystemErrorResponse&
    get_FileSystemErrorResponse()
    {
        AssertSanity(TFileSystemErrorResponse);
        return (*(ptr_FileSystemErrorResponse()));
    }
    const FileSystemErrorResponse&
    get_FileSystemErrorResponse() const
    {
        AssertSanity(TFileSystemErrorResponse);
        return (*(constptr_FileSystemErrorResponse()));
    }
    operator FileSystemErrorResponse&()
    {
        return get_FileSystemErrorResponse();
    }
    operator const FileSystemErrorResponse&() const
    {
        return get_FileSystemErrorResponse();
    }

private:
    union {
        FileSystemDirectoryResponse mVFileSystemDirectoryResponse;
        FileSystemDirectoryListingResponse mVFileSystemDirectoryListingResponse;
        FileSystemFileResponse mVFileSystemFileResponse;
        FileSystemFilesResponse mVFileSystemFilesResponse;
        FileSystemErrorResponse mVFileSystemErrorResponse;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FileSystemResponseValue>
{
    typedef ::mozilla::dom::FileSystemResponseValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
class PFileSystemRequestParent;
} // namespace dom
} // namespace mozilla
namespace mozilla {
namespace dom {
class PFileSystemRequestChild;
} // namespace dom
} // namespace mozilla

//-----------------------------------------------------------------------------
// Code common to PFileSystemRequestChild and PFileSystemRequestParent
//
namespace mozilla {
namespace dom {
namespace PFileSystemRequest {

nsresult
CreateEndpoints(
        mozilla::ipc::EndpointProcInfo aParentDestInfo,
        mozilla::ipc::EndpointProcInfo aChildDestInfo,
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemRequestParent>* aParent,
        mozilla::ipc::Endpoint<::mozilla::dom::PFileSystemRequestChild>* aChild);

enum MessageType {
    PFileSystemRequestStart = PFileSystemRequestMsgStart << 16,
    Msg___delete____ID,
    Reply___delete____ID,
    PFileSystemRequestEnd
};

mozilla::UniquePtr<IPC::Message>
Msg___delete__(IPC::Message::routeid_t routingId);
mozilla::UniquePtr<IPC::Message>
Reply___delete__(IPC::Message::routeid_t routingId);



} // namespace PFileSystemRequest
} // namespace dom
} // namespace mozilla

#endif // ifndef PFileSystemRequest_h
