/* gitg-application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include "libgitg-ext.h"
#include <libpeas/peas.h>
#include "libgitg.h"
#include <gee.h>
#include <handy.h>
#include "libgitg/gitg-platform-support.h"
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>

#define GITG_APPLICATION_version VERSION
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GITG_TYPE_APPLICATION (gitg_application_get_type ())
#define GITG_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_APPLICATION, GitgApplication))
#define GITG_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_APPLICATION, GitgApplicationClass))
#define GITG_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_APPLICATION))
#define GITG_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_APPLICATION))
#define GITG_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_APPLICATION, GitgApplicationClass))

typedef struct _GitgApplication GitgApplication;
typedef struct _GitgApplicationClass GitgApplicationClass;
typedef struct _GitgApplicationPrivate GitgApplicationPrivate;

#define GITG_TYPE_PREFERENCES_DIALOG (gitg_preferences_dialog_get_type ())
#define GITG_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialog))
#define GITG_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))
#define GITG_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))

typedef struct _GitgPreferencesDialog GitgPreferencesDialog;
typedef struct _GitgPreferencesDialogClass GitgPreferencesDialogClass;

#define GITG_APPLICATION_TYPE_PLUGIN_ACCEL (gitg_application_plugin_accel_get_type ())
typedef struct _GitgApplicationPluginAccel GitgApplicationPluginAccel;
enum  {
	GITG_APPLICATION_0_PROPERTY,
	GITG_APPLICATION_STATE_SETTINGS_PROPERTY,
	GITG_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* gitg_application_properties[GITG_APPLICATION_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_HISTORY_TYPE_COMMAND_LINE (gitg_history_command_line_get_type ())
#define GITG_HISTORY_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLine))
#define GITG_HISTORY_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))
#define GITG_HISTORY_IS_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_IS_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_COMMAND_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))

typedef struct _GitgHistoryCommandLine GitgHistoryCommandLine;
typedef struct _GitgHistoryCommandLineClass GitgHistoryCommandLineClass;

#define GITG_TYPE_PLUGINS_ENGINE (gitg_plugins_engine_get_type ())
#define GITG_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngine))
#define GITG_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))
#define GITG_IS_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_IS_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_PLUGINS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))

typedef struct _GitgPluginsEngine GitgPluginsEngine;
typedef struct _GitgPluginsEngineClass GitgPluginsEngineClass;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gitg_application_plugin_accel_free0(var) ((var == NULL) ? NULL : (var = (gitg_application_plugin_accel_free (var), NULL)))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_TYPE_AUTHOR_DETAILS_DIALOG (gitg_author_details_dialog_get_type ())
#define GITG_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog))
#define GITG_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))
#define GITG_IS_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_IS_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_AUTHOR_DETAILS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))

typedef struct _GitgAuthorDetailsDialog GitgAuthorDetailsDialog;
typedef struct _GitgAuthorDetailsDialogClass GitgAuthorDetailsDialogClass;

#define GITG_APPLICATION_TYPE_ACCEL (gitg_application_accel_get_type ())
typedef struct _GitgApplicationAccel GitgApplicationAccel;

#define GITG_APPLICATION_TYPE_MULTI_ACCEL (gitg_application_multi_accel_get_type ())
typedef struct _GitgApplicationMultiAccel GitgApplicationMultiAccel;

struct _GitgApplication {
	GtkApplication parent_instance;
	GitgApplicationPrivate * priv;
};

struct _GitgApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GitgApplicationPluginAccel {
	gchar* name;
	gchar* shortcut;
};

struct _GitgApplicationPrivate {
	GSettings* d_state_settings;
	GitgPreferencesDialog* d_preferences;
	GtkShortcutsWindow* d_shortcuts;
	GList* plugins_accel;
};

struct _GitgApplicationAccel {
	gchar* name;
	gchar* accel;
};

struct _GitgApplicationMultiAccel {
	gchar* name;
	gchar** accels;
	gint accels_length1;
	gint _accels_size_;
};

static gint GitgApplication_private_offset;
static gpointer gitg_application_parent_class = NULL;
static gchar* gitg_application_activity;
static gboolean gitg_application_no_wd;
static gboolean gitg_application_standalone;
static gboolean gitg_application_init;
static gboolean gitg_application_app_quit;
static gboolean gitg_application_app_quit = FALSE;
static gchar* gitg_application_activity = NULL;
static gboolean gitg_application_no_wd = FALSE;
static gboolean gitg_application_standalone = FALSE;
static GApplicationCommandLine* gitg_application_app_command_line;
static GApplicationCommandLine* gitg_application_app_command_line = NULL;
static gboolean gitg_application_init = FALSE;

VALA_EXTERN GType gitg_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgApplication, g_object_unref)
VALA_EXTERN GType gitg_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgPreferencesDialog, g_object_unref)
static GType gitg_application_plugin_accel_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgApplicationPluginAccel* gitg_application_plugin_accel_dup (const GitgApplicationPluginAccel* self);
static void gitg_application_plugin_accel_free (GitgApplicationPluginAccel* self);
static void gitg_application_plugin_accel_copy (const GitgApplicationPluginAccel* self,
                                         GitgApplicationPluginAccel* dest);
static void gitg_application_plugin_accel_destroy (GitgApplicationPluginAccel* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgApplicationPluginAccel, gitg_application_plugin_accel_destroy)
static gboolean gitg_application_show_version_and_quit (void);
static gboolean gitg_application_commit_activity (void);
static void gitg_application_on_app_new_window_activated (GitgApplication* self);
static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
static void gitg_application_on_app_about_activated (GitgApplication* self);
static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void gitg_application_on_app_quit_activated (GitgApplication* self);
static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void gitg_application_on_app_author_details_global_activated (GitgApplication* self);
static void _gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                GVariant* parameter,
                                                                                                gpointer self);
static void gitg_application_on_preferences_activated (GitgApplication* self);
static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void gitg_application_on_shortcuts_activated (GitgApplication* self);
static void _gitg_application_on_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void _gitg_application_plugin_accel_free0_ (gpointer var);
static inline void _g_list_free__gitg_application_plugin_accel_free0_ (GList* self);
VALA_EXTERN GitgApplication* gitg_application_new (void);
VALA_EXTERN GitgApplication* gitg_application_construct (GType object_type);
static GitgExtCommandLines* gitg_application_parse_command_line (GitgApplication* self,
                                                          gchar*** argv,
                                                          gint* argv_length1,
                                                          GError** error);
VALA_EXTERN GType gitg_history_command_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgHistoryCommandLine, g_object_unref)
VALA_EXTERN GitgHistoryCommandLine* gitg_history_command_line_new (void);
VALA_EXTERN GitgHistoryCommandLine* gitg_history_command_line_construct (GType object_type);
static void _vala_array_add21 (GitgExtCommandLine** * array,
                        gint* length,
                        gint* size,
                        GitgExtCommandLine* value);
VALA_EXTERN GType gitg_plugins_engine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgPluginsEngine, g_object_unref)
VALA_EXTERN GitgPluginsEngine* gitg_plugins_engine_get_default (void);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_array_add22 (GitgExtCommandLine** * array,
                        gint* length,
                        gint* size,
                        GitgExtCommandLine* value);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static gboolean gitg_application_real_local_command_line (GApplication* base,
                                                   gchar*** arguments,
                                                   gint* exit_status);
static gchar** _vala_array_dup18 (gchar** self,
                           gssize length);
VALA_EXTERN void gitg_plugins_engine_initialize (void);
static gint gitg_application_real_command_line (GApplication* base,
                                         GApplicationCommandLine* cmd);
static void _vala_array_add23 (GFile** * array,
                        gint* length,
                        gint* size,
                        GFile* value);
static void gitg_application_open_command_line (GitgApplication* self,
                                         GFile** files,
                                         gint files_length1,
                                         const gchar* hint,
                                         GitgExtCommandLines* command_lines);
static void gitg_application_activate_command_line (GitgApplication* self,
                                             GitgExtCommandLines* command_lines);
static void gitg_application_new_window (GitgApplication* self,
                                  GitgRepository* repo,
                                  const gchar* hint,
                                  GitgExtCommandLines* command_lines);
VALA_EXTERN gpointer gitg_builder_load_object (GType t_type,
                                   GBoxedCopyFunc t_dup_func,
                                   GDestroyNotify t_destroy_func,
                                   const gchar* id,
                                   const gchar* object);
static void ___lambda191_ (GitgApplication* self,
                    GtkWidget* w);
static void ____lambda191__gtk_widget_destroy (GtkWidget* _sender,
                                        gpointer self);
static void ___lambda192_ (GitgApplication* self,
                    GtkWidget* w);
static void ____lambda192__gtk_widget_destroy (GtkWidget* _sender,
                                        gpointer self);
VALA_EXTERN GType gitg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgWindow, g_object_unref)
VALA_EXTERN GType gitg_author_details_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GitgAuthorDetailsDialog, g_object_unref)
VALA_EXTERN GitgAuthorDetailsDialog* gitg_author_details_dialog_show_global (GitgWindow* window);
static void gitg_application_init_error (GitgApplication* self,
                                  const gchar* msg);
static void __lambda193_ (GitgApplication* self);
static void ___lambda193__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void gitg_application_real_startup (GApplication* base);
static GType gitg_application_accel_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgApplicationAccel* gitg_application_accel_dup (const GitgApplicationAccel* self);
static void gitg_application_accel_free (GitgApplicationAccel* self);
static void gitg_application_accel_copy (const GitgApplicationAccel* self,
                                  GitgApplicationAccel* dest);
static void gitg_application_accel_destroy (GitgApplicationAccel* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgApplicationAccel, gitg_application_accel_destroy)
static GType gitg_application_multi_accel_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgApplicationMultiAccel* gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_free (GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self,
                                        GitgApplicationMultiAccel* dest);
static void gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GitgApplicationMultiAccel, gitg_application_multi_accel_destroy)
static void gitg_application_add_css (GitgApplication* self,
                               const gchar* path);
static void _vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel * array,
                                                 gssize array_length);
static void gitg_application_real_shutdown (GApplication* base);
static void gitg_application_present_window (GitgApplication* self,
                                      const gchar* activity,
                                      GitgExtCommandLines* command_lines);
static void gitg_application_real_activate (GApplication* base);
static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self,
                                                   GFile* file);
static void gitg_application_real_open (GApplication* base,
                                 GFile** files,
                                 gint files_length1,
                                 const gchar* hint);
VALA_EXTERN void gitg_window_set_environment (GitgWindow* self,
                                  gchar** environment,
                                  gint environment_length1);
VALA_EXTERN void gitg_window_present (GitgWindow* self,
                          const gchar* hint,
                          GitgExtCommandLines* command_lines);
VALA_EXTERN GitgWindow* gitg_window_create_new (GtkApplication* app,
                                    GitgRepository* repository,
                                    const gchar* action);
VALA_EXTERN void gitg_application_register_shortcut (GitgApplication* self,
                                         const gchar* name,
                                         guint shortcut);
VALA_EXTERN GSettings* gitg_application_get_state_settings (GitgApplication* self);
static gchar** _vala_array_dup19 (gchar** self,
                           gssize length);
static void gitg_application_finalize (GObject * obj);
static GType gitg_application_get_type_once (void);
static void _vala_gitg_application_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry GITG_APPLICATION_entries[7] = {{"version", 'v', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_show_version_and_quit, N_ ("Show the application’s version"), NULL}, {"activity", '\0', (gint) 0, G_OPTION_ARG_STRING, &gitg_application_activity, N_ ("Start gitg with a particular activity"), NULL}, {"commit", 'c', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_commit_activity, N_ ("Start gitg with the commit activity (shorthand for --activity commit)"), NULL}, {"no-wd", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &gitg_application_no_wd, N_ ("Do not try to load a repository from the current working directory"), NULL}, {"standalone", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &gitg_application_standalone, N_ ("Run gitg in standalone mode"), NULL}, {"init", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &gitg_application_init, N_ ("Put paths under git if needed"), NULL}, {NULL}};
static const GActionEntry GITG_APPLICATION_app_entries[5] = {{"new", _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback}, {"about", _gitg_application_on_app_about_activated_gsimple_action_activate_callback}, {"quit", _gitg_application_on_app_quit_activated_gsimple_action_activate_callback}, {"author-details-global", _gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback}, {"preferences", _gitg_application_on_preferences_activated_gsimple_action_activate_callback}};
static const GActionEntry GITG_APPLICATION_shortcut_window_entries[1] = {{"shortcuts", _gitg_application_on_shortcuts_activated_gsimple_action_activate_callback}};

static inline gpointer
gitg_application_get_instance_private (GitgApplication* self)
{
	return G_STRUCT_MEMBER_P (self, GitgApplication_private_offset);
}

static void
_gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	gitg_application_on_app_new_window_activated ((GitgApplication*) self);
}

static void
_gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	gitg_application_on_app_about_activated ((GitgApplication*) self);
}

static void
_gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	gitg_application_on_app_quit_activated ((GitgApplication*) self);
}

static void
_gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                           GVariant* parameter,
                                                                                           gpointer self)
{
	gitg_application_on_app_author_details_global_activated ((GitgApplication*) self);
}

static void
_gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	gitg_application_on_preferences_activated ((GitgApplication*) self);
}

static void
_gitg_application_on_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	gitg_application_on_shortcuts_activated ((GitgApplication*) self);
}

static void
_gitg_application_plugin_accel_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_application_plugin_accel_free (var), NULL));
}

static inline void
_g_list_free__gitg_application_plugin_accel_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gitg_application_plugin_accel_free0_);
}

static gboolean
gitg_application_commit_activity (void)
{
	gchar* _tmp0_;
	gboolean result;
	_tmp0_ = g_strdup ("commit");
	_g_free0 (gitg_application_activity);
	gitg_application_activity = _tmp0_;
	result = TRUE;
	return result;
}

GitgApplication*
gitg_application_construct (GType object_type)
{
	GitgApplication * self = NULL;
	self = (GitgApplication*) g_object_new (object_type, "application-id", APPLICATION_ID, "flags", (G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE) | G_APPLICATION_SEND_ENVIRONMENT, NULL);
	return self;
}

GitgApplication*
gitg_application_new (void)
{
	return gitg_application_construct (GITG_TYPE_APPLICATION);
}

static gboolean
gitg_application_show_version_and_quit (void)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	_tmp0_ = stdout;
	_tmp1_ = g_get_application_name ();
	fprintf (_tmp0_, "%s %s\n", _tmp1_, VERSION);
	gitg_application_app_quit = TRUE;
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add21 (GitgExtCommandLine** * array,
                   gint* length,
                   gint* size,
                   GitgExtCommandLine* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_array_add22 (GitgExtCommandLine** * array,
                   gint* length,
                   gint* size,
                   GitgExtCommandLine* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static GitgExtCommandLines*
gitg_application_parse_command_line (GitgApplication* self,
                                     gchar*** argv,
                                     gint* argv_length1,
                                     GError** error)
{
	GOptionContext* ctx = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	GitgExtCommandLine** cmdexts = NULL;
	GitgExtCommandLine** _tmp4_;
	gint cmdexts_length1;
	gint _cmdexts_size_;
	GitgHistoryCommandLine* historycmd = NULL;
	GitgHistoryCommandLine* _tmp5_;
	GitgHistoryCommandLine* _tmp6_;
	GitgExtCommandLine* _tmp7_;
	GOptionContext* _tmp8_;
	GitgHistoryCommandLine* _tmp9_;
	GOptionGroup* _tmp10_;
	GitgPluginsEngine* engine = NULL;
	GitgPluginsEngine* _tmp11_;
	GitgPluginsEngine* _tmp12_;
	GList* _tmp13_;
	GOptionContext* _tmp27_;
	GitgExtCommandLines* ret = NULL;
	GitgExtCommandLine** _tmp28_;
	gint _tmp28__length1;
	GitgExtCommandLines* _tmp29_;
	GitgExtCommandLines* _tmp30_;
	GError* _inner_error0_ = NULL;
	GitgExtCommandLines* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_option_context_new (_ ("— Git repository viewer"));
	ctx = _tmp0_;
	_tmp1_ = ctx;
	g_option_context_add_main_entries (_tmp1_, GITG_APPLICATION_entries, GETTEXT_PACKAGE);
	_tmp2_ = ctx;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	_tmp4_ = g_new0 (GitgExtCommandLine*, 0 + 1);
	cmdexts = _tmp4_;
	cmdexts_length1 = 0;
	_cmdexts_size_ = cmdexts_length1;
	_tmp5_ = gitg_history_command_line_new ();
	historycmd = _tmp5_;
	_tmp6_ = historycmd;
	_tmp7_ = _g_object_ref0 ((GitgExtCommandLine*) _tmp6_);
	_vala_array_add21 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp7_);
	_tmp8_ = ctx;
	_tmp9_ = historycmd;
	_tmp10_ = gitg_ext_command_line_get_option_group ((GitgExtCommandLine*) _tmp9_);
	g_option_context_add_group (_tmp8_, _tmp10_);
	_tmp11_ = gitg_plugins_engine_get_default ();
	engine = _tmp11_;
	_tmp12_ = engine;
	_tmp13_ = peas_engine_get_plugin_list ((PeasEngine*) _tmp12_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp13_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* _tmp14_;
			PeasPluginInfo* info = NULL;
			_tmp14_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) info_it->data);
			info = _tmp14_;
			{
				PeasPluginInfo* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = info;
				_tmp16_ = peas_plugin_info_get_external_data (_tmp15_, "CommandLine");
				if (_tmp16_ != NULL) {
					GitgExtCommandLine* ext = NULL;
					GitgPluginsEngine* _tmp17_;
					PeasPluginInfo* _tmp18_;
					PeasExtension* _tmp19_;
					GitgExtCommandLine* _tmp20_;
					GitgExtCommandLine* _tmp21_;
					_tmp17_ = engine;
					_tmp18_ = info;
					_tmp19_ = peas_engine_create_extension ((PeasEngine*) _tmp17_, _tmp18_, GITG_EXT_TYPE_COMMAND_LINE, NULL);
					_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GITG_EXT_TYPE_COMMAND_LINE) ? ((GitgExtCommandLine*) _tmp19_) : NULL;
					if (_tmp20_ == NULL) {
						_g_object_unref0 (_tmp19_);
					}
					ext = _tmp20_;
					_tmp21_ = ext;
					if (_tmp21_ != NULL) {
						GitgExtCommandLine* _tmp22_;
						GitgExtCommandLine* _tmp23_;
						GOptionContext* _tmp24_;
						GitgExtCommandLine* _tmp25_;
						GOptionGroup* _tmp26_;
						_tmp22_ = ext;
						_tmp23_ = _g_object_ref0 (_tmp22_);
						_vala_array_add22 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp23_);
						_tmp24_ = ctx;
						_tmp25_ = ext;
						_tmp26_ = gitg_ext_command_line_get_option_group (_tmp25_);
						g_option_context_add_group (_tmp24_, _tmp26_);
					}
					_g_object_unref0 (ext);
				}
				__vala_PeasPluginInfo_free0 (info);
			}
		}
	}
	_tmp27_ = ctx;
	g_option_context_parse (_tmp27_, (gint*) (argv_length1), argv, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_OPTION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (engine);
			_g_object_unref0 (historycmd);
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_option_context_free0 (ctx);
			return NULL;
		} else {
			_g_object_unref0 (engine);
			_g_object_unref0 (historycmd);
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_option_context_free0 (ctx);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp28_ = cmdexts;
	_tmp28__length1 = cmdexts_length1;
	_tmp29_ = gitg_ext_command_lines_new (_tmp28_, _tmp28__length1);
	ret = _tmp29_;
	_tmp30_ = ret;
	gitg_ext_command_lines_parse_finished (_tmp30_);
	result = ret;
	_g_object_unref0 (engine);
	_g_object_unref0 (historycmd);
	cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_option_context_free0 (ctx);
	return result;
}

static gchar**
_vala_array_dup18 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
gitg_application_real_local_command_line (GApplication* base,
                                          gchar*** arguments,
                                          gint* exit_status)
{
	GitgApplication * self;
	gint _vala_exit_status = 0;
	gchar** cp = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint cp_length1;
	gint _cp_size_;
	gchar** argv = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint argv_length1;
	gint _argv_size_;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (GitgApplication*) base;
	_tmp0_ = ((*arguments) != NULL) ? _vala_array_dup18 (*arguments, _vala_array_length (*arguments)) : (*arguments);
	_tmp0__length1 = _vala_array_length (*arguments);
	cp = _tmp0_;
	cp_length1 = _tmp0__length1;
	_cp_size_ = cp_length1;
	_tmp1_ = cp;
	_tmp1__length1 = cp_length1;
	argv = _tmp1_;
	argv_length1 = _tmp1__length1;
	_argv_size_ = argv_length1;
	gitg_plugins_engine_initialize ();
	{
		GitgExtCommandLines* _tmp2_;
		GitgExtCommandLines* _tmp3_;
		_tmp2_ = gitg_application_parse_command_line (self, &argv, (gint*) (&argv_length1), &_inner_error0_);
		_argv_size_ = argv_length1;
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Failed to parse options: %s\n", _tmp6_);
		_vala_exit_status = 1;
		result = TRUE;
		_g_error_free0 (e);
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	if (!gitg_application_standalone) {
		g_application_set_flags ((GApplication*) self, g_application_get_flags ((GApplication*) self) | G_APPLICATION_NON_UNIQUE);
	}
	if (gitg_application_app_quit) {
		_vala_exit_status = 0;
		result = TRUE;
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	_tmp9_ = G_APPLICATION_CLASS (gitg_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), arguments, &_tmp8_);
	_vala_exit_status = _tmp8_;
	result = _tmp9_;
	cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}

static void
_vala_array_add23 (GFile** * array,
                   gint* length,
                   gint* size,
                   GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
gitg_application_real_command_line (GApplication* base,
                                    GApplicationCommandLine* cmd)
{
	GitgApplication * self;
	gchar** arguments = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint arguments_length1;
	gint _arguments_size_;
	gchar** argv = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint argv_length1;
	gint _argv_size_;
	GitgExtCommandLines* command_lines = NULL;
	GApplicationCommandLine* tmpcmd = NULL;
	GApplicationCommandLine* _tmp10_;
	GApplicationCommandLine* _tmp11_;
	GApplicationCommandLine* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GApplicationCommandLine* _tmp25_;
	GApplicationCommandLine* _tmp26_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (GitgApplication*) base;
	g_return_val_if_fail (cmd != NULL, 0);
	_tmp1_ = g_application_command_line_get_arguments (cmd, &_tmp0_);
	arguments = _tmp1_;
	arguments_length1 = _tmp0_;
	_arguments_size_ = arguments_length1;
	_tmp2_ = arguments;
	_tmp2__length1 = arguments_length1;
	argv = _tmp2_;
	argv_length1 = _tmp2__length1;
	_argv_size_ = argv_length1;
	{
		GitgExtCommandLines* _tmp3_ = NULL;
		GitgExtCommandLines* _tmp4_;
		GitgExtCommandLines* _tmp5_;
		_tmp4_ = gitg_application_parse_command_line (self, &argv, (gint*) (&argv_length1), &_inner_error0_);
		_argv_size_ = argv_length1;
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (command_lines);
		command_lines = _tmp5_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_application_command_line_printerr (cmd, "option parsing failed: %s\n", _tmp7_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (command_lines);
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		_g_object_unref0 (command_lines);
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	if (gitg_application_app_quit) {
		result = 0;
		_g_object_unref0 (command_lines);
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (!g_application_command_line_get_is_remote (cmd)) {
		GApplicationCommandLine* _tmp9_;
		_tmp9_ = _g_object_ref0 (cmd);
		_g_object_unref0 (gitg_application_app_command_line);
		gitg_application_app_command_line = _tmp9_;
	}
	_tmp10_ = gitg_application_app_command_line;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	tmpcmd = _tmp11_;
	_tmp12_ = _g_object_ref0 (cmd);
	_g_object_unref0 (gitg_application_app_command_line);
	gitg_application_app_command_line = _tmp12_;
	_tmp13_ = argv;
	_tmp13__length1 = argv_length1;
	if (_tmp13__length1 > 1) {
		GFile** files = NULL;
		gchar** _tmp14_;
		gint _tmp14__length1;
		GFile** _tmp15_;
		gint files_length1;
		gint _files_size_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		GFile** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		GitgExtCommandLines* _tmp23_;
		_tmp14_ = argv;
		_tmp14__length1 = argv_length1;
		_tmp15_ = g_new0 (GFile*, (_tmp14__length1 - 1) + 1);
		files = _tmp15_;
		files_length1 = _tmp14__length1 - 1;
		_files_size_ = files_length1;
		files_length1 = 0;
		_tmp16_ = argv;
		_tmp16__length1 = argv_length1;
		_tmp17_ = argv;
		_tmp17__length1 = argv_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp16_ + 1;
			arg_collection_length1 = _tmp17__length1 - 1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp18_;
				gchar* arg = NULL;
				_tmp18_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp18_;
				{
					const gchar* _tmp19_;
					GFile* _tmp20_;
					_tmp19_ = arg;
					_tmp20_ = g_file_new_for_commandline_arg (_tmp19_);
					_vala_array_add23 (&files, &files_length1, &_files_size_, _tmp20_);
					_g_free0 (arg);
				}
			}
		}
		_tmp21_ = files;
		_tmp21__length1 = files_length1;
		_tmp22_ = gitg_application_activity;
		_tmp23_ = command_lines;
		gitg_application_open_command_line (self, _tmp21_, (gint) _tmp21__length1, _tmp22_, _tmp23_);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	} else {
		GitgExtCommandLines* _tmp24_;
		_tmp24_ = command_lines;
		gitg_application_activate_command_line (self, _tmp24_);
	}
	_tmp25_ = tmpcmd;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (gitg_application_app_command_line);
	gitg_application_app_command_line = _tmp26_;
	result = 1;
	_g_object_unref0 (tmpcmd);
	_g_object_unref0 (command_lines);
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
gitg_application_on_app_new_window_activated (GitgApplication* self)
{
	g_return_if_fail (self != NULL);
	gitg_application_new_window (self, NULL, NULL, NULL);
}

static void
gitg_application_on_app_about_activated (GitgApplication* self)
{
	gchar** artists = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint artists_length1;
	gint _artists_size_;
	gchar** authors = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint authors_length1;
	gint _authors_size_;
	gchar* copyright = NULL;
	gchar* _tmp6_;
	gchar* comments = NULL;
	gchar* _tmp7_;
	GList* wnds = NULL;
	GList* _tmp8_;
	GtkWindow* _tmp9_ = NULL;
	GList* _tmp10_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Jakub Steiner <jimmac@gmail.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	artists = _tmp1_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp2_ = g_strdup ("Jesse van den Kieboom <jessevdk@gnome.org>");
	_tmp3_ = g_strdup ("Ignacio Casal Quinteiro <icq@gnome.org>");
	_tmp4_ = g_strdup ("Alberto Fanjul <albfan@gnome.org>");
	_tmp5_ = g_new0 (gchar*, 3 + 1);
	_tmp5_[0] = _tmp2_;
	_tmp5_[1] = _tmp3_;
	_tmp5_[2] = _tmp4_;
	authors = _tmp5_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp6_ = g_strdup ("Copyright \xc2\xa9 2012 Jesse van den Kieboom");
	copyright = _tmp6_;
	_tmp7_ = g_strdup (_ ("gitg is a Git repository viewer for GTK+/GNOME"));
	comments = _tmp7_;
	_tmp8_ = gtk_application_get_windows ((GtkApplication*) self);
	wnds = _tmp8_;
	_tmp10_ = wnds;
	if (_tmp10_ != NULL) {
		GList* _tmp11_;
		gconstpointer _tmp12_;
		_tmp11_ = wnds;
		_tmp12_ = _tmp11_->data;
		_tmp9_ = (GtkWindow*) _tmp12_;
	} else {
		_tmp9_ = NULL;
	}
	_tmp13_ = artists;
	_tmp13__length1 = artists_length1;
	_tmp14_ = authors;
	_tmp14__length1 = authors_length1;
	_tmp15_ = copyright;
	_tmp16_ = comments;
	gtk_show_about_dialog (_tmp9_, "artists", _tmp13_, "authors", _tmp14_, "copyright", _tmp15_, "comments", _tmp16_, "translator-credits", _ ("translator-credits"), "version", VERSION, "website", PACKAGE_URL, "website-label", _ ("gitg homepage"), "logo-icon-name", APPLICATION_ID, "license-type", GTK_LICENSE_GPL_2_0, NULL);
	_g_free0 (comments);
	_g_free0 (copyright);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}

static void
gitg_application_on_app_quit_activated (GitgApplication* self)
{
	GList* wnds = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	_tmp1_ = g_list_copy (_tmp0_);
	wnds = _tmp1_;
	_tmp2_ = wnds;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* window = NULL;
			window = (GtkWindow*) window_it->data;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = window;
				gtk_widget_destroy ((GtkWidget*) _tmp3_);
			}
		}
	}
	(wnds == NULL) ? NULL : (wnds = (g_list_free (wnds), NULL));
}

static void
___lambda191_ (GitgApplication* self,
               GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->d_preferences);
	self->priv->d_preferences = NULL;
}

static void
____lambda191__gtk_widget_destroy (GtkWidget* _sender,
                                   gpointer self)
{
	___lambda191_ ((GitgApplication*) self, _sender);
}

static void
gitg_application_on_preferences_activated (GitgApplication* self)
{
	GList* wnds = NULL;
	GList* _tmp0_;
	GitgPreferencesDialog* _tmp1_;
	GList* _tmp4_;
	GitgPreferencesDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	wnds = _tmp0_;
	_tmp1_ = self->priv->d_preferences;
	if (_tmp1_ == NULL) {
		gpointer _tmp2_;
		GitgPreferencesDialog* _tmp3_;
		_tmp2_ = gitg_builder_load_object (GITG_TYPE_PREFERENCES_DIALOG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "ui/gitg-preferences.ui", "preferences");
		_g_object_unref0 (self->priv->d_preferences);
		self->priv->d_preferences = (GitgPreferencesDialog*) _tmp2_;
		_tmp3_ = self->priv->d_preferences;
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda191__gtk_widget_destroy, self, 0);
	}
	_tmp4_ = wnds;
	if (_tmp4_ != NULL) {
		GitgPreferencesDialog* _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
		_tmp5_ = self->priv->d_preferences;
		_tmp6_ = wnds;
		_tmp7_ = _tmp6_->data;
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp7_);
	}
	_tmp8_ = self->priv->d_preferences;
	gtk_window_present ((GtkWindow*) _tmp8_);
}

static gpointer
_gitg_application_plugin_accel_dup0 (gpointer self)
{
	return self ? gitg_application_plugin_accel_dup (self) : NULL;
}

static void
___lambda192_ (GitgApplication* self,
               GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->d_shortcuts);
	self->priv->d_shortcuts = NULL;
}

static void
____lambda192__gtk_widget_destroy (GtkWidget* _sender,
                                   gpointer self)
{
	___lambda192_ ((GitgApplication*) self, _sender);
}

static void
gitg_application_on_shortcuts_activated (GitgApplication* self)
{
	GList* wnds = NULL;
	GList* _tmp0_;
	GtkShortcutsWindow* _tmp1_;
	GList* _tmp24_;
	GtkShortcutsWindow* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	wnds = _tmp0_;
	_tmp1_ = self->priv->d_shortcuts;
	if (_tmp1_ == NULL) {
		GeeHashMap* shortcuts_ui_objects = NULL;
		GeeHashMap* _tmp2_;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		GList* _tmp5_;
		GtkShortcutsWindow* _tmp23_;
		_tmp2_ = gitg_ext_ui_from_builder ("ui/gitg-shortcuts.ui", "shortcuts-gitg", "history-shortcuts-group", NULL);
		shortcuts_ui_objects = _tmp2_;
		_tmp3_ = shortcuts_ui_objects;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, "shortcuts-gitg");
		_g_object_unref0 (self->priv->d_shortcuts);
		self->priv->d_shortcuts = G_TYPE_CHECK_INSTANCE_CAST ((GObject*) _tmp4_, gtk_shortcuts_window_get_type (), GtkShortcutsWindow);
		_tmp5_ = self->priv->plugins_accel;
		if (_tmp5_ != NULL) {
			GtkShortcutsGroup* history_shortcuts_group = NULL;
			GeeHashMap* _tmp6_;
			gpointer _tmp7_;
			GtkShortcutsGroup* _tmp8_;
			GList* _tmp9_;
			_tmp6_ = shortcuts_ui_objects;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, "history-shortcuts-group");
			history_shortcuts_group = G_TYPE_CHECK_INSTANCE_CAST ((GObject*) _tmp7_, gtk_shortcuts_group_get_type (), GtkShortcutsGroup);
			_tmp8_ = history_shortcuts_group;
			gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
			_tmp9_ = self->priv->plugins_accel;
			{
				GList* element_collection = NULL;
				GList* element_it = NULL;
				element_collection = _tmp9_;
				for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
					GitgApplicationPluginAccel* _tmp10_;
					GitgApplicationPluginAccel* element = NULL;
					_tmp10_ = _gitg_application_plugin_accel_dup0 ((GitgApplicationPluginAccel*) element_it->data);
					element = _tmp10_;
					{
						GtkShortcutsShortcut* shortcut = NULL;
						GitgApplicationPluginAccel* _tmp11_;
						const gchar* _tmp12_;
						GitgApplicationPluginAccel* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						GObject* _tmp17_;
						GObject* _tmp18_;
						GtkShortcutsShortcut* _tmp19_;
						GtkShortcutsShortcut* _tmp20_;
						GtkShortcutsGroup* _tmp21_;
						GtkShortcutsShortcut* _tmp22_;
						_tmp11_ = element;
						_tmp12_ = (*_tmp11_).name;
						_tmp13_ = element;
						_tmp14_ = (*_tmp13_).shortcut;
						_tmp15_ = g_strconcat ("<Alt>", _tmp14_, NULL);
						_tmp16_ = _tmp15_;
						_tmp17_ = g_object_new (gtk_shortcuts_shortcut_get_type (), "title", _tmp12_, "accelerator", _tmp16_, NULL, NULL);
						_tmp18_ = G_IS_INITIALLY_UNOWNED (_tmp17_) ? g_object_ref_sink (_tmp17_) : _tmp17_;
						_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_shortcuts_shortcut_get_type (), GtkShortcutsShortcut);
						_g_free0 (_tmp16_);
						shortcut = _tmp19_;
						_tmp20_ = shortcut;
						gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
						_tmp21_ = history_shortcuts_group;
						_tmp22_ = shortcut;
						gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
						_g_object_unref0 (shortcut);
						_gitg_application_plugin_accel_free0 (element);
					}
				}
			}
			_g_object_unref0 (history_shortcuts_group);
		}
		_tmp23_ = self->priv->d_shortcuts;
		g_signal_connect_object ((GtkWidget*) _tmp23_, "destroy", (GCallback) ____lambda192__gtk_widget_destroy, self, 0);
		_g_object_unref0 (shortcuts_ui_objects);
	}
	_tmp24_ = wnds;
	if (_tmp24_ != NULL) {
		GtkShortcutsWindow* _tmp25_;
		GList* _tmp26_;
		gconstpointer _tmp27_;
		_tmp25_ = self->priv->d_shortcuts;
		_tmp26_ = wnds;
		_tmp27_ = _tmp26_->data;
		gtk_window_set_transient_for ((GtkWindow*) _tmp25_, (GtkWindow*) _tmp27_);
	}
	_tmp28_ = self->priv->d_shortcuts;
	gtk_window_present ((GtkWindow*) _tmp28_);
}

static void
gitg_application_on_app_author_details_global_activated (GitgApplication* self)
{
	GList* wnds = NULL;
	GList* _tmp0_;
	GitgWindow* window = NULL;
	GList* _tmp1_;
	GitgWindow* _tmp6_;
	GitgAuthorDetailsDialog* _tmp7_;
	GitgAuthorDetailsDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	wnds = _tmp0_;
	window = NULL;
	_tmp1_ = wnds;
	if (_tmp1_ != NULL) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		GtkWindow* _tmp4_;
		GitgWindow* _tmp5_;
		_tmp2_ = wnds;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = (GtkWindow*) _tmp3_;
		_tmp5_ = _g_object_ref0 (GITG_IS_WINDOW (_tmp4_) ? ((GitgWindow*) _tmp4_) : NULL);
		_g_object_unref0 (window);
		window = _tmp5_;
	}
	_tmp6_ = window;
	_tmp7_ = gitg_author_details_dialog_show_global (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (window);
}

static void
__lambda193_ (GitgApplication* self)
{
	gtk_main_quit ();
}

static void
___lambda193__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda193_ ((GitgApplication*) self);
}

static void
gitg_application_init_error (GitgApplication* self,
                             const gchar* msg)
{
	GtkMessageDialog* dlg = NULL;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", msg);
	g_object_ref_sink (_tmp0_);
	dlg = _tmp0_;
	g_object_set ((GtkWindow*) dlg, "window-position", GTK_WIN_POS_CENTER, NULL);
	g_signal_connect_object ((GtkDialog*) dlg, "response", (GCallback) ___lambda193__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dlg);
	_g_object_unref0 (dlg);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel * array,
                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gitg_application_multi_accel_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
gitg_application_real_startup (GApplication* base)
{
	GitgApplication * self;
	HdyStyleManager* style_manager = NULL;
	HdyStyleManager* _tmp0_;
	HdyStyleManager* _tmp1_;
	HdyStyleManager* _tmp2_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	static const GitgApplicationAccel single_accels[8] = {{"app.new", "<Primary>N"}, {"app.quit", "<Primary>Q"}, {"app.shortcuts", "<Primary>question"}, {"win.search", "<Primary>F"}, {"win.gear-menu", "F10"}, {"win.open-repository", "<Primary>O"}, {"win.close", "<Primary>W"}, {"win.preferences", "<Primary>comma"}};
	GitgApplicationMultiAccel* multi_accels = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	GitgApplicationMultiAccel _tmp11_ = {0};
	GitgApplicationMultiAccel* _tmp12_;
	gint multi_accels_length1;
	gint _multi_accels_size_;
	GitgApplicationMultiAccel* _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp30_;
	GtkIconTheme* _tmp31_;
	GtkIconTheme* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _inner_error0_ = NULL;
	self = (GitgApplication*) base;
	G_APPLICATION_CLASS (gitg_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = hdy_style_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_manager = _tmp1_;
	_tmp2_ = style_manager;
	hdy_style_manager_set_color_scheme (_tmp2_, HDY_COLOR_SCHEME_PREFER_LIGHT);
	gitg_platform_support_application_support_prepare_startup ();
	{
		gitg_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (g_error_matches (_tmp3_, GITG_INIT_ERROR, GITG_INIT_ERROR_THREADS_UNSAFE)) {
			gchar* errmsg = NULL;
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("We are terribly sorry, but gitg requires libgit2 (a library on which g" \
"itg depends) to be compiled with threading support.\n" \
"\n" \
"If you manually compiled libgit2, then please configure libgit2 with -" \
"DTHREADSAFE:BOOL=ON.\n" \
"\n" \
"Otherwise, report a bug in your distributions’ bug reporting system fo" \
"r providing libgit2 without threading support."));
			errmsg = _tmp4_;
			gitg_application_init_error (self, errmsg);
			g_error ("gitg-application.vala:402: %s", errmsg);
			_g_free0 (errmsg);
		}
		_g_error_free0 (e);
		_g_object_unref0 (style_manager);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (style_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = g_settings_new (APPLICATION_ID ".state.window");
	_g_object_unref0 (self->priv->d_state_settings);
	self->priv->d_state_settings = _tmp5_;
	_tmp6_ = self->priv->d_state_settings;
	g_settings_delay (_tmp6_);
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_app_entries, (gint) G_N_ELEMENTS (GITG_APPLICATION_app_entries), self);
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_shortcut_window_entries, (gint) G_N_ELEMENTS (GITG_APPLICATION_shortcut_window_entries), self);
	_tmp7_ = g_strdup ("win.reload");
	_tmp8_ = g_strdup ("<Primary>R");
	_tmp9_ = g_strdup ("F5");
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	memset (&_tmp11_, 0, sizeof (GitgApplicationMultiAccel));
	_g_free0 (_tmp11_.name);
	_tmp11_.name = _tmp7_;
	_tmp11_.accels = (_vala_array_free (_tmp11_.accels, _tmp11_.accels_length1, (GDestroyNotify) g_free), NULL);
	_tmp11_.accels = _tmp10_;
	_tmp11_.accels_length1 = 2;
	_tmp11_._accels_size_ = _tmp11_.accels_length1;
	_tmp12_ = g_new0 (GitgApplicationMultiAccel, 1);
	_tmp12_[0] = _tmp11_;
	multi_accels = _tmp12_;
	multi_accels_length1 = 1;
	_multi_accels_size_ = multi_accels_length1;
	{
		GitgApplicationAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
		accel_collection = single_accels;
		accel_collection_length1 = G_N_ELEMENTS (single_accels);
		for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
			GitgApplicationAccel accel = {0};
			accel = accel_collection[accel_it];
			{
				GitgApplicationAccel _tmp13_;
				const gchar* _tmp14_;
				GitgApplicationAccel _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				_tmp13_ = accel;
				_tmp14_ = _tmp13_.name;
				_tmp15_ = accel;
				_tmp16_ = _tmp15_.accel;
				_tmp17_ = g_strdup (_tmp16_);
				_tmp18_ = g_new0 (gchar*, 1 + 1);
				_tmp18_[0] = _tmp17_;
				_tmp19_ = _tmp18_;
				_tmp19__length1 = 1;
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp14_, _tmp19_);
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp20_ = multi_accels;
	_tmp20__length1 = multi_accels_length1;
	{
		GitgApplicationMultiAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
		accel_collection = _tmp20_;
		accel_collection_length1 = _tmp20__length1;
		for (accel_it = 0; accel_it < accel_collection_length1; accel_it = accel_it + 1) {
			GitgApplicationMultiAccel _tmp21_;
			GitgApplicationMultiAccel _tmp22_ = {0};
			GitgApplicationMultiAccel accel = {0};
			_tmp21_ = accel_collection[accel_it];
			gitg_application_multi_accel_copy (&_tmp21_, &_tmp22_);
			accel = _tmp22_;
			{
				GitgApplicationMultiAccel _tmp23_;
				const gchar* _tmp24_;
				GitgApplicationMultiAccel _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				_tmp23_ = accel;
				_tmp24_ = _tmp23_.name;
				_tmp25_ = accel;
				_tmp26_ = _tmp25_.accels;
				_tmp26__length1 = _tmp25_.accels_length1;
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp24_, _tmp26_);
				gitg_application_multi_accel_destroy (&accel);
			}
		}
	}
	gitg_application_add_css (self, "style.css");
	_tmp27_ = string_to_string (PLATFORM_NAME);
	_tmp28_ = g_strconcat ("style-", _tmp27_, ".css", NULL);
	_tmp29_ = _tmp28_;
	gitg_application_add_css (self, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp30_ = gtk_icon_theme_get_default ();
	_tmp31_ = _g_object_ref0 (_tmp30_);
	theme = _tmp31_;
	_tmp32_ = theme;
	_tmp33_ = gitg_platform_support_get_data_dir ();
	_tmp34_ = _tmp33_;
	_tmp35_ = g_build_filename (_tmp34_, "icons", NULL);
	_tmp36_ = _tmp35_;
	gtk_icon_theme_prepend_search_path (_tmp32_, _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_object_unref0 (theme);
	multi_accels = (_vala_GitgApplicationMultiAccel_array_free (multi_accels, multi_accels_length1), NULL);
	_g_object_unref0 (style_manager);
}

static void
gitg_application_add_css (GitgApplication* self,
                          const gchar* path)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gitg_resource_load_css (path);
	provider = _tmp0_;
	_tmp1_ = provider;
	if (_tmp1_ != NULL) {
		GdkScreen* _tmp2_;
		GtkCssProvider* _tmp3_;
		_tmp2_ = gdk_screen_get_default ();
		_tmp3_ = provider;
		gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) 600);
	}
	_g_object_unref0 (provider);
}

static void
gitg_application_real_shutdown (GApplication* base)
{
	GitgApplication * self;
	GSettings* _tmp0_;
	self = (GitgApplication*) base;
	_tmp0_ = self->priv->d_state_settings;
	g_settings_apply (_tmp0_);
	G_APPLICATION_CLASS (gitg_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
gitg_application_activate_command_line (GitgApplication* self,
                                        GitgExtCommandLines* command_lines)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_lines != NULL);
	if (gitg_application_no_wd) {
		const gchar* _tmp0_;
		_tmp0_ = gitg_application_activity;
		gitg_application_present_window (self, _tmp0_, command_lines);
	} else {
		const gchar* git_dir_env = NULL;
		GApplicationCommandLine* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = gitg_application_app_command_line;
		_tmp2_ = g_application_command_line_getenv (_tmp1_, "GIT_DIR");
		git_dir_env = _tmp2_;
		_tmp3_ = git_dir_env;
		if (_tmp3_ != NULL) {
			GFile** files = NULL;
			const gchar* _tmp4_;
			GFile* _tmp5_;
			GFile** _tmp6_;
			gint files_length1;
			gint _files_size_;
			GFile** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp4_ = git_dir_env;
			_tmp5_ = g_file_new_for_path (_tmp4_);
			_tmp6_ = g_new0 (GFile*, 1 + 1);
			_tmp6_[0] = _tmp5_;
			files = _tmp6_;
			files_length1 = 1;
			_files_size_ = files_length1;
			_tmp7_ = files;
			_tmp7__length1 = files_length1;
			_tmp8_ = gitg_application_activity;
			gitg_application_open_command_line (self, _tmp7_, (gint) _tmp7__length1, _tmp8_, command_lines);
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		} else {
			gchar* wd = NULL;
			GApplicationCommandLine* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile** _tmp14_;
			GFile** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp9_ = gitg_application_app_command_line;
			_tmp10_ = g_application_command_line_get_cwd (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			wd = _tmp11_;
			_tmp12_ = wd;
			_tmp13_ = g_file_new_for_path (_tmp12_);
			_tmp14_ = g_new0 (GFile*, 1 + 1);
			_tmp14_[0] = _tmp13_;
			_tmp15_ = _tmp14_;
			_tmp15__length1 = 1;
			_tmp16_ = gitg_application_activity;
			g_application_open ((GApplication*) self, _tmp15_, (gint) 1, _tmp16_);
			_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
			_tmp17_ = gitg_application_activity;
			gitg_application_present_window (self, _tmp17_, command_lines);
			_g_free0 (wd);
		}
	}
}

static void
gitg_application_real_activate (GApplication* base)
{
	GitgApplication * self;
	self = (GitgApplication*) base;
	gitg_application_present_window (self, NULL, NULL);
	G_APPLICATION_CLASS (gitg_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static GitgWindow*
gitg_application_find_window_for_file (GitgApplication* self,
                                       GFile* file)
{
	GList* _tmp0_;
	GitgWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				GitgWindow* wnd = NULL;
				GtkWindow* _tmp2_;
				GitgWindow* _tmp3_;
				GitgWindow* _tmp4_;
				GitgRepository* _tmp5_;
				GitgRepository* _tmp6_;
				GitgRepository* _tmp7_;
				gboolean _tmp8_;
				GitgWindow* _tmp9_;
				GitgRepository* _tmp10_;
				GitgRepository* _tmp11_;
				GitgRepository* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gboolean _tmp15_;
				_tmp2_ = window;
				_tmp3_ = _g_object_ref0 (GITG_IS_WINDOW (_tmp2_) ? ((GitgWindow*) _tmp2_) : NULL);
				wnd = _tmp3_;
				_tmp4_ = wnd;
				_tmp5_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_ == NULL;
				_g_object_unref0 (_tmp7_);
				if (_tmp8_) {
					_g_object_unref0 (wnd);
					_g_object_unref0 (window);
					continue;
				}
				_tmp9_ = wnd;
				_tmp10_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = ggit_repository_get_location ((GgitRepository*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_file_equal (_tmp14_, file);
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (_tmp12_);
				if (_tmp15_) {
					result = wnd;
					_g_object_unref0 (window);
					return result;
				}
				_g_object_unref0 (wnd);
				_g_object_unref0 (window);
			}
		}
	}
	result = NULL;
	return result;
}

static void
gitg_application_real_open (GApplication* base,
                            GFile** files,
                            gint files_length1,
                            const gchar* hint)
{
	GitgApplication * self;
	self = (GitgApplication*) base;
	g_return_if_fail (hint != NULL);
	gitg_application_open_command_line (self, files, (gint) files_length1, hint, NULL);
}

static void
gitg_application_open_command_line (GitgApplication* self,
                                    GFile** files,
                                    gint files_length1,
                                    const gchar* hint,
                                    GitgExtCommandLines* command_lines)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (files_length1 == 0) {
		return;
	}
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = files;
		f_collection_length1 = files_length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			GFile* _tmp0_;
			GFile* f = NULL;
			_tmp0_ = _g_object_ref0 (f_collection[f_it]);
			f = _tmp0_;
			{
				GFile* resolved = NULL;
				GitgWindow* window = NULL;
				GFile* _tmp28_;
				GitgWindow* _tmp29_;
				GitgWindow* _tmp30_;
				GitgRepository* repo = NULL;
				GitgRepository* _tmp43_;
				{
					GFile* _tmp1_ = NULL;
					GFile* _tmp2_;
					GFile* _tmp3_;
					GFile* _tmp4_;
					_tmp2_ = f;
					_tmp3_ = ggit_repository_discover (_tmp2_, &_inner_error0_);
					_tmp1_ = _tmp3_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp4_ = _tmp1_;
					_tmp1_ = NULL;
					_g_object_unref0 (resolved);
					resolved = _tmp4_;
					_g_object_unref0 (_tmp1_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					if (!gitg_application_init) {
						FILE* _tmp5_;
						GError* _tmp6_;
						const gchar* _tmp7_;
						_tmp5_ = stderr;
						_tmp6_ = err;
						_tmp7_ = _tmp6_->message;
						fprintf (_tmp5_, "Error: %s.\n", _tmp7_);
						_g_error_free0 (err);
						_g_object_unref0 (resolved);
						_g_object_unref0 (f);
						continue;
					}
					{
						gboolean exists = FALSE;
						GFile* _tmp8_;
						gboolean _tmp9_ = FALSE;
						gboolean valid = FALSE;
						gchar* path = NULL;
						GFile* _tmp12_;
						gchar* _tmp13_;
						GFile* _tmp16_;
						GitgRepository* _tmp17_;
						GitgRepository* _tmp18_;
						GFile* _tmp19_ = NULL;
						GFile* _tmp20_;
						GFile* _tmp21_;
						GFile* _tmp22_;
						FILE* _tmp23_;
						const gchar* _tmp24_;
						_tmp8_ = f;
						exists = g_file_query_exists (_tmp8_, NULL);
						if (exists) {
							GFile* _tmp10_;
							_tmp10_ = f;
							_tmp9_ = G_FILE_TYPE_DIRECTORY == g_file_query_file_type (_tmp10_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
						} else {
							GFile* _tmp11_;
							_tmp11_ = f;
							_tmp9_ = g_file_make_directory_with_parents (_tmp11_, NULL, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
						}
						valid = _tmp9_;
						_tmp12_ = f;
						_tmp13_ = g_file_get_path (_tmp12_);
						path = _tmp13_;
						if (!valid) {
							FILE* _tmp14_;
							const gchar* _tmp15_;
							_tmp14_ = stderr;
							_tmp15_ = path;
							fprintf (_tmp14_, "Invalid location %s.\n", _tmp15_);
							_g_free0 (path);
							_g_error_free0 (err);
							_g_object_unref0 (resolved);
							_g_object_unref0 (f);
							continue;
						}
						_tmp16_ = f;
						_tmp17_ = gitg_repository_init_repository (_tmp16_, FALSE, &_inner_error0_);
						_tmp18_ = _tmp17_;
						_g_object_unref0 (_tmp18_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (path);
							goto __catch1_g_error;
						}
						_tmp20_ = f;
						_tmp21_ = ggit_repository_discover (_tmp20_, &_inner_error0_);
						_tmp19_ = _tmp21_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (path);
							goto __catch1_g_error;
						}
						_tmp22_ = _tmp19_;
						_tmp19_ = NULL;
						_g_object_unref0 (resolved);
						resolved = _tmp22_;
						_tmp23_ = stdout;
						_tmp24_ = path;
						fprintf (_tmp23_, "Successfully initialized git repository at “%s”.\n", _tmp24_);
						_g_object_unref0 (_tmp19_);
						_g_free0 (path);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* err2 = NULL;
						FILE* _tmp25_;
						GError* _tmp26_;
						const gchar* _tmp27_;
						err2 = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp25_ = stderr;
						_tmp26_ = err2;
						_tmp27_ = _tmp26_->message;
						fprintf (_tmp25_, "Error: %s.\n", _tmp27_);
						_g_error_free0 (err2);
						_g_error_free0 (err);
						_g_object_unref0 (resolved);
						_g_object_unref0 (f);
						continue;
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_error_free0 (err);
						_g_object_unref0 (resolved);
						_g_object_unref0 (f);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (resolved);
					_g_object_unref0 (f);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp28_ = resolved;
				_tmp29_ = gitg_application_find_window_for_file (self, _tmp28_);
				window = _tmp29_;
				_tmp30_ = window;
				if (_tmp30_ != NULL) {
					GitgWindow* _tmp31_;
					GApplicationCommandLine* _tmp32_;
					gchar** _tmp33_;
					gchar** _tmp34_;
					GitgWindow* _tmp35_;
					_tmp31_ = window;
					_tmp32_ = gitg_application_app_command_line;
					_tmp34_ = _tmp33_ = g_application_command_line_get_environ (_tmp32_);
					gitg_window_set_environment (_tmp31_, _tmp34_, (gint) _vala_array_length (_tmp33_));
					_tmp35_ = window;
					gitg_window_present (_tmp35_, hint, command_lines);
					_g_object_unref0 (window);
					_g_object_unref0 (resolved);
					_g_object_unref0 (f);
					continue;
				}
				{
					GitgRepository* _tmp36_ = NULL;
					GFile* _tmp37_;
					GitgRepository* _tmp38_;
					GitgRepository* _tmp39_;
					_tmp37_ = resolved;
					_tmp38_ = gitg_repository_new (_tmp37_, NULL, &_inner_error0_);
					_tmp36_ = _tmp38_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					_tmp39_ = _tmp36_;
					_tmp36_ = NULL;
					_g_object_unref0 (repo);
					repo = _tmp39_;
					_g_object_unref0 (_tmp36_);
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* err = NULL;
					FILE* _tmp40_;
					GError* _tmp41_;
					const gchar* _tmp42_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp40_ = stderr;
					_tmp41_ = err;
					_tmp42_ = _tmp41_->message;
					fprintf (_tmp40_, "Error: not able to open repository “%s”.\n", _tmp42_);
					_g_error_free0 (err);
					_g_object_unref0 (repo);
					_g_object_unref0 (window);
					_g_object_unref0 (resolved);
					_g_object_unref0 (f);
					continue;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (repo);
					_g_object_unref0 (window);
					_g_object_unref0 (resolved);
					_g_object_unref0 (f);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp43_ = repo;
				gitg_application_new_window (self, _tmp43_, hint, command_lines);
				_g_object_unref0 (repo);
				_g_object_unref0 (window);
				_g_object_unref0 (resolved);
				_g_object_unref0 (f);
			}
		}
	}
}

static void
gitg_application_new_window (GitgApplication* self,
                             GitgRepository* repo,
                             const gchar* hint,
                             GitgExtCommandLines* command_lines)
{
	GitgWindow* window = NULL;
	GitgWindow* _tmp0_;
	GitgWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_window_create_new ((GtkApplication*) self, repo, hint);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ != NULL) {
		GitgWindow* _tmp2_;
		GApplicationCommandLine* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		_tmp2_ = window;
		_tmp3_ = gitg_application_app_command_line;
		_tmp5_ = _tmp4_ = g_application_command_line_get_environ (_tmp3_);
		gitg_window_set_environment (_tmp2_, _tmp5_, (gint) _vala_array_length (_tmp4_));
	}
	gitg_application_present_window (self, hint, command_lines);
	_g_object_unref0 (window);
}

static void
gitg_application_present_window (GitgApplication* self,
                                 const gchar* activity,
                                 GitgExtCommandLines* command_lines)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GitgWindow* w = NULL;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GitgWindow* _tmp5_;
	GitgWindow* _tmp6_;
	GApplicationCommandLine* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	GitgWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	windows = _tmp0_;
	_tmp1_ = windows;
	if (_tmp1_ == NULL) {
		gitg_application_new_window (self, NULL, NULL, NULL);
		return;
	}
	_tmp2_ = windows;
	_tmp3_ = g_list_first (_tmp2_);
	_tmp4_ = _tmp3_->data;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp4_, GITG_TYPE_WINDOW, GitgWindow));
	w = _tmp5_;
	_tmp6_ = w;
	_tmp7_ = gitg_application_app_command_line;
	_tmp9_ = _tmp8_ = g_application_command_line_get_environ (_tmp7_);
	gitg_window_set_environment (_tmp6_, _tmp9_, (gint) _vala_array_length (_tmp8_));
	_tmp10_ = w;
	gitg_window_present (_tmp10_, activity, command_lines);
	_g_object_unref0 (w);
}

void
gitg_application_register_shortcut (GitgApplication* self,
                                    const gchar* name,
                                    guint shortcut)
{
	GList* _tmp0_;
	GitgApplicationPluginAccel plugin_accel = {0};
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GitgApplicationPluginAccel _tmp4_ = {0};
	GitgApplicationPluginAccel _tmp5_;
	GitgApplicationPluginAccel _tmp6_;
	GitgApplicationPluginAccel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->plugins_accel;
	if (_tmp0_ == NULL) {
		(self->priv->plugins_accel == NULL) ? NULL : (self->priv->plugins_accel = (_g_list_free__gitg_application_plugin_accel_free0_ (self->priv->plugins_accel), NULL));
		self->priv->plugins_accel = NULL;
	}
	_tmp1_ = g_strdup (name);
	_tmp2_ = gdk_keyval_name (shortcut);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_tmp4_.name);
	_tmp4_.name = _tmp1_;
	_g_free0 (_tmp4_.shortcut);
	_tmp4_.shortcut = _tmp3_;
	plugin_accel = _tmp4_;
	_tmp5_ = plugin_accel;
	_tmp6_ = _tmp5_;
	_tmp7_ = _gitg_application_plugin_accel_dup0 (&_tmp6_);
	self->priv->plugins_accel = g_list_append (self->priv->plugins_accel, _tmp7_);
	gitg_application_plugin_accel_destroy (&plugin_accel);
}

GSettings*
gitg_application_get_state_settings (GitgApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_state_settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
gitg_application_accel_copy (const GitgApplicationAccel* self,
                             GitgApplicationAccel* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).accel;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).accel);
	(*dest).accel = _tmp3_;
}

static void
gitg_application_accel_destroy (GitgApplicationAccel* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).accel);
}

static GitgApplicationAccel*
gitg_application_accel_dup (const GitgApplicationAccel* self)
{
	GitgApplicationAccel* dup;
	dup = g_new0 (GitgApplicationAccel, 1);
	gitg_application_accel_copy (self, dup);
	return dup;
}

static void
gitg_application_accel_free (GitgApplicationAccel* self)
{
	gitg_application_accel_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_application_accel_get_type_once (void)
{
	GType gitg_application_accel_type_id;
	gitg_application_accel_type_id = g_boxed_type_register_static ("GitgApplicationAccel", (GBoxedCopyFunc) gitg_application_accel_dup, (GBoxedFreeFunc) gitg_application_accel_free);
	return gitg_application_accel_type_id;
}

static GType
gitg_application_accel_get_type (void)
{
	static gsize gitg_application_accel_type_id__once = 0;
	if (g_once_init_enter (&gitg_application_accel_type_id__once)) {
		GType gitg_application_accel_type_id;
		gitg_application_accel_type_id = gitg_application_accel_get_type_once ();
		g_once_init_leave (&gitg_application_accel_type_id__once, gitg_application_accel_type_id);
	}
	return gitg_application_accel_type_id__once;
}

static gchar**
_vala_array_dup19 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self,
                                   GitgApplicationMultiAccel* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).accels;
	_tmp2__length1 = (*self).accels_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup19 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).accels = (_vala_array_free ((*dest).accels, (*dest).accels_length1, (GDestroyNotify) g_free), NULL);
	(*dest).accels = _tmp3_;
	(*dest).accels_length1 = _tmp3__length1;
	(*dest)._accels_size_ = (*dest).accels_length1;
}

static void
gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self)
{
	_g_free0 ((*self).name);
	(*self).accels = (_vala_array_free ((*self).accels, (*self).accels_length1, (GDestroyNotify) g_free), NULL);
}

static GitgApplicationMultiAccel*
gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self)
{
	GitgApplicationMultiAccel* dup;
	dup = g_new0 (GitgApplicationMultiAccel, 1);
	gitg_application_multi_accel_copy (self, dup);
	return dup;
}

static void
gitg_application_multi_accel_free (GitgApplicationMultiAccel* self)
{
	gitg_application_multi_accel_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_application_multi_accel_get_type_once (void)
{
	GType gitg_application_multi_accel_type_id;
	gitg_application_multi_accel_type_id = g_boxed_type_register_static ("GitgApplicationMultiAccel", (GBoxedCopyFunc) gitg_application_multi_accel_dup, (GBoxedFreeFunc) gitg_application_multi_accel_free);
	return gitg_application_multi_accel_type_id;
}

static GType
gitg_application_multi_accel_get_type (void)
{
	static gsize gitg_application_multi_accel_type_id__once = 0;
	if (g_once_init_enter (&gitg_application_multi_accel_type_id__once)) {
		GType gitg_application_multi_accel_type_id;
		gitg_application_multi_accel_type_id = gitg_application_multi_accel_get_type_once ();
		g_once_init_leave (&gitg_application_multi_accel_type_id__once, gitg_application_multi_accel_type_id);
	}
	return gitg_application_multi_accel_type_id__once;
}

static void
gitg_application_plugin_accel_copy (const GitgApplicationPluginAccel* self,
                                    GitgApplicationPluginAccel* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).shortcut;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).shortcut);
	(*dest).shortcut = _tmp3_;
}

static void
gitg_application_plugin_accel_destroy (GitgApplicationPluginAccel* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).shortcut);
}

static GitgApplicationPluginAccel*
gitg_application_plugin_accel_dup (const GitgApplicationPluginAccel* self)
{
	GitgApplicationPluginAccel* dup;
	dup = g_new0 (GitgApplicationPluginAccel, 1);
	gitg_application_plugin_accel_copy (self, dup);
	return dup;
}

static void
gitg_application_plugin_accel_free (GitgApplicationPluginAccel* self)
{
	gitg_application_plugin_accel_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_application_plugin_accel_get_type_once (void)
{
	GType gitg_application_plugin_accel_type_id;
	gitg_application_plugin_accel_type_id = g_boxed_type_register_static ("GitgApplicationPluginAccel", (GBoxedCopyFunc) gitg_application_plugin_accel_dup, (GBoxedFreeFunc) gitg_application_plugin_accel_free);
	return gitg_application_plugin_accel_type_id;
}

static GType
gitg_application_plugin_accel_get_type (void)
{
	static gsize gitg_application_plugin_accel_type_id__once = 0;
	if (g_once_init_enter (&gitg_application_plugin_accel_type_id__once)) {
		GType gitg_application_plugin_accel_type_id;
		gitg_application_plugin_accel_type_id = gitg_application_plugin_accel_get_type_once ();
		g_once_init_leave (&gitg_application_plugin_accel_type_id__once, gitg_application_plugin_accel_type_id);
	}
	return gitg_application_plugin_accel_type_id__once;
}

static void
gitg_application_class_init (GitgApplicationClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	gitg_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgApplication_private_offset);
	((GApplicationClass *) klass)->local_command_line = (gboolean (*) (GApplication*, gchar***, gint*)) gitg_application_real_local_command_line;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) gitg_application_real_command_line;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) gitg_application_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) gitg_application_real_shutdown;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) gitg_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) gitg_application_real_open;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_application_get_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_APPLICATION_STATE_SETTINGS_PROPERTY, gitg_application_properties[GITG_APPLICATION_STATE_SETTINGS_PROPERTY] = g_param_spec_object ("state-settings", "state-settings", "state-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_strdup ("");
	_g_free0 (gitg_application_activity);
	gitg_application_activity = _tmp0_;
}

static void
gitg_application_instance_init (GitgApplication * self,
                                gpointer klass)
{
	self->priv = gitg_application_get_instance_private (self);
}

static void
gitg_application_finalize (GObject * obj)
{
	GitgApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_APPLICATION, GitgApplication);
	_g_object_unref0 (self->priv->d_state_settings);
	_g_object_unref0 (self->priv->d_preferences);
	_g_object_unref0 (self->priv->d_shortcuts);
	(self->priv->plugins_accel == NULL) ? NULL : (self->priv->plugins_accel = (_g_list_free__gitg_application_plugin_accel_free0_ (self->priv->plugins_accel), NULL));
	G_OBJECT_CLASS (gitg_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgApplication), 0, (GInstanceInitFunc) gitg_application_instance_init, NULL };
	GType gitg_application_type_id;
	gitg_application_type_id = g_type_register_static (gtk_application_get_type (), "GitgApplication", &g_define_type_info, 0);
	GitgApplication_private_offset = g_type_add_instance_private (gitg_application_type_id, sizeof (GitgApplicationPrivate));
	return gitg_application_type_id;
}

GType
gitg_application_get_type (void)
{
	static gsize gitg_application_type_id__once = 0;
	if (g_once_init_enter (&gitg_application_type_id__once)) {
		GType gitg_application_type_id;
		gitg_application_type_id = gitg_application_get_type_once ();
		g_once_init_leave (&gitg_application_type_id__once, gitg_application_type_id);
	}
	return gitg_application_type_id__once;
}

static void
_vala_gitg_application_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GitgApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_APPLICATION, GitgApplication);
	switch (property_id) {
		case GITG_APPLICATION_STATE_SETTINGS_PROPERTY:
		g_value_take_object (value, gitg_application_get_state_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

